<?php

namespace Drupal\login_flow\Plugin;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Logger\LoggerChannelTrait;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\user\UserInterface;

/**
 * Provides a base implementation for an Login Flow plugin.
 *
 * @see \Drupal\login_flow\Attribute\Authentication
 * @see \Drupal\login_flow\Plugin\AuthenticationInterface
 * @see \Drupal\login_flow\Plugin\AuthenticationManager
 * @see plugin_api
 */
abstract class AuthenticationBase extends PluginBase implements ContainerFactoryPluginInterface {

  use StringTranslationTrait;
  use LoggerChannelTrait;

  /**
   * The user ID to be logged in.
   */
  protected ?int $userId = NULL;

  /**
   * {@inheritdoc}
   */
  public function getConfiguration() {
    return $this->configuration + $this->defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigurationSummary() {
    return 'Plug-in not configured';
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function setUserAccountId($user_id) {
    $this->userId = $user_id;
  }

  /**
   * {@inheritdoc}
   */
  public function getUserAccountId() {
    return $this->userId;
  }

  /**
   * {@inheritdoc}
   */
  public function isApplicable(UserInterface $account, ?FormStateInterface $form_state = NULL) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormElements(UserInterface $account, FormStateInterface $form_state) {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function processLogout(UserInterface $account) {
  }

}
