<?php

namespace Drupal\login_flow\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\user\UserInterface;

/**
 * Provides an interface for a Login Flow plugin.
 *
 * @see \Drupal\login_flow\Attribute\Challenge
 * @see \Drupal\login_flow\Plugin\ChallengeBase
 * @see \Drupal\login_flow\Plugin\ChallengeManager
 * @see plugin_api
 */
interface ChallengeInterface extends PluginInspectionInterface, PluginFormInterface {

  /**
   * Get the plugin configuration.
   *
   * @return array
   *   Array of settings for this plugin.
   */
  public function getConfiguration();

  /**
   * Get a summary of the plugin configuration.
   *
   * @return string
   *   A summary of the current settings for this plugin.
   */
  public function getConfigurationSummary();

  /**
   * Return the default configuration values for this plugin.
   *
   * @return array
   *   Associative array of default configuration values.
   */
  public function defaultConfiguration();

  /**
   * Checks if the Login Flow is applicable for the given account.
   *
   * @param \Drupal\user\UserInterface $account
   *   The user account, if one has been found.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   (Optional) The form state object.
   *
   * @return bool
   *   TRUE if this Login Flow plug-in is applicable, FALSE otherwise.
   */
  public function isApplicable(UserInterface $account, ?FormStateInterface $form_state = NULL);

  /**
   * Validate the user challenge for the account.
   *
   * @param \Drupal\user\UserInterface $account
   *   The user account.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state object.
   *
   * @return bool
   *   Return boolean challenge result.
   */
  public function validateChallenge(UserInterface $account, FormStateInterface $form_state);

  /**
   * Get additional form elements for the login form.
   *
   * @param \Drupal\user\UserInterface $account
   *   The user account.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state object.
   *
   * @return array
   *   An array of form elements to be added to the login form.
   */
  public function getFormElements(UserInterface $account, FormStateInterface $form_state);

}
