<?php

namespace Drupal\Tests\login_flow\Functional;

/**
 * Test for the Login Flow administrative interface.
 *
 * @group login_flow
 */
class LoginFlowAdminTest extends LoginFlowTestBase {

  /**
   * Use admin theme for testing of admin forms.
   *
   * @var string
   */
  protected $defaultTheme = 'claro';

  /**
   * Tests the configuration page access.
   */
  public function testLoginFlowPageAccess() {
    $this->drupalGet('/admin/config/system/login_flow');
    $this->assertSession()->statusCodeEquals(403);
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/system/login_flow');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests configuration form shows correct settings for config loaded.
   */
  public function testLoginFlowConfigPage() {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/system/login_flow');
    $this->assertSession()->elementExists('css', 'input#edit-authentication-plugins-login-flow-password-enabled[checked=checked]');
    $page = $this->getSession()->getPage();
    $page->fillField('username_title', 'Username/Email');
    $page->fillField('username_description', 'Enter your username or email address.');
    $page->pressButton('Save configuration');
    $username_title = $this->config('login_flow.settings')->get('username_title');
    $username_description = $this->config('login_flow.settings')->get('username_description');
    $this->assertEquals('Username/Email', $username_title, 'Config does not reflect updated username field label.');
    $this->assertEquals('Enter your username or email address.', $username_description, 'Config does not reflect updated username field description.');
  }

}
