<?php

namespace Drupal\login_flow\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an Login Flow Authentication attribute object.
 *
 * Plugin Namespace: Plugin\login_flow\Authentication.
 *
 * @see \Drupal\login_flow\AuthenticationManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Authentication extends Plugin {

  /**
   * Constructs a Login Flow Authentication attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the Login Flow plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the Login Flow plugin.
   * @param bool $uses_drupal_password
   *   Set TRUE if the plugin uses the Drupal password form field.
   * @param bool $supports_password_reset
   *   Set TRUE if the plugin supports password reset requests.
   * @param bool $will_redirect
   *   Set TRUE if the plugin redirects the user to a controller/external url.
   * @param bool $has_additional_fields
   *   Set TRUE if the plugin requires additional fields for the login form.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly bool $uses_drupal_password = TRUE,
    public readonly bool $supports_password_reset = TRUE,
    public readonly bool $will_redirect = FALSE,
    public readonly bool $has_additional_fields = FALSE,
    public readonly ?string $deriver = NULL,
  ) {}

}
