<?php

namespace Drupal\login_flow\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an Login Flow Challenge attribute object.
 *
 * Plugin Namespace: Plugin\login_flow\Challenge.
 *
 * @see \Drupal\login_flow\ChallengeManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Challenge extends Plugin {

  /**
   * Constructs a Login Flow Challenge attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the Login Flow plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the Login Flow plugin.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

}
