<?php

namespace Drupal\login_flow\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\Routing\RouteCollection;

/**
 * Route subscriber to alter core user routes.
 *
 * @package Drupal\login_flow\Routing
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Reroute the default user.logout route.
    if ($route = $collection->get('user.logout')) {
      $route->setDefault('_controller', '\Drupal\login_flow\Controller\LoginFlowRedirectController::processLogout');
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    // Ensure we alter the controller after other modules.
    $events[RoutingEvents::ALTER] = [
      'onAlterRoutes',
      -1025,
    ];
    return $events;
  }

}
