<?php

namespace Drupal\login_greeting\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class LoginGreetingSettingsForm extends ConfigFormBase {

  protected function getEditableConfigNames() {
    return ['login_greeting.settings'];
  }

  public function getFormId() {
    return 'login_greeting_settings_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('login_greeting.settings');
    $form['greeting_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Greeting message'),
      '#default_value' => $config->get('greeting_message') ?: 'Welcome back, [user:name]! Today is [date].',
      '#description' => $this->t('You can use [user:name], [date], and [time] as placeholders.'),
      '#size' => 80,
    ];
    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('login_greeting.settings')
      ->set('greeting_message', $form_state->getValue('greeting_message'))
      ->save();
    parent::submitForm($form, $form_state);
  }
}