<?php

namespace Drupal\login_switch\Routing;

use Drupal\Core\Session\AccountProxyInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\GetResponseForExceptionEvent;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteSubscriberBase;

/**
 * Route subscriber class to override the default core user routes.
 */
class LoginSwitchRouteSubscriber extends RouteSubscriberBase implements EventSubscriberInterface  {

  protected $configFactory;

  /**
   * The current user.
   *
   * @var \Drupal\Core\Session\AccountProxyInterface
   */
  protected $currentUser;

  /**
   * LoginSwitchRouteSubscriber constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   ConfigFactoryInterface.
   */
  public function __construct(ConfigFactoryInterface $config_factory, AccountProxyInterface $current_user) {
    $this->configFactory = $config_factory;
    $this->currentUser = $current_user;
  }

  /**
   * Checks if the module is activated and sets routes.
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Get configuration for the module.
    $config = $this->configFactory->get('login_switch.settings');

    $routes = [
      'login' => 'user.login',
      'register' => 'user.register',
      'password' => 'user.pass',
    ];

    foreach ($routes as $key => $route_name) {
      $route = $collection->get($route_name);
      if ($config->get($key . '_disabled') && $route) {
        $route_path = $config->get($key . '_route');

        if (!empty($route_path)) {
          // Set the new path based on the configuration.
          $route->setPath('/' . $route_path);
        }
        else {
          $route->setRequirement('_access', 'false');
        }
      }
    }
  }


  public function onException(GetResponseForExceptionEvent $event) {
    $route_name = \Drupal::routeMatch()->getRouteName();
    $config = $this->configFactory->get('login_switch.settings');
    if ($config->get('login_disabled')){
      if($route_name == 'user.page' && !$this->currentUser->hasPermission('access 403 page')){
        $event->setException(new NotFoundHttpException());
      }
    }
  }

  /**
   * Registers the methods in this class that should be listeners.
   *
   * @return array
   *   An array of event listener definitions.
   */
  public static function getSubscribedEvents() {
    $events[KernelEvents::EXCEPTION][] = ['onException', 100];
    return $events;
  }
}
