<?php

namespace Drupal\login_switch\EventSubscriber;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber which adds 'noindex' in the response header.
 */
class AddNoIndexHeader implements EventSubscriberInterface {

  /**
   * The configuration factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The current route match.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected $routeMatch;

  /**
   * AddNoIndexHeader constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match.
   */
  public function __construct(ConfigFactoryInterface $config_factory, RouteMatchInterface $route_match) {
    $this->configFactory = $config_factory;
    $this->routeMatch = $route_match;

  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[KernelEvents::RESPONSE][] = ['onRespond', -100];
    return $events;
  }

  /**
   * Add noindex Headers.
   *
   * @param \Symfony\Component\HttpKernel\Event\ResponseEvent $event
   *   The response event.
   */
  public function onRespond(ResponseEvent $event) {
    if (!$event->isMainRequest()) {
      return;
    }

    // Get Configuration & Event Response.
    $config = $this->configFactory->get('login_switch.settings');
    $response = $event->getResponse();

    // Routes to check for added header.
    $routes = [
      'login' => 'user.login',
      'register' => 'user.register',
      'password' => 'user.pass',
    ];

    $route = $this->routeMatch->getRouteName();
    if (in_array($route, $routes)) {
      $key = array_search($route, $routes);
      if (!empty($key)) {
        if ($config->get($key . '_noindex')) {
          $response->headers->set('X-Robots-Tag', 'noindex');
        }
      }
    }
  }

}
