<?php

namespace Drupal\login_switch\Routing;

use Drupal\Core\Site\Settings;
use Symfony\Component\Routing\Route;

class DynamicRoute
{
  public function routes()
  {
    // Get configuration for module and site
    $config = \Drupal::config('login_switch.settings');
    $config_site = \Drupal::config('system.site');

    $routes = array();

    if ($config->get('login')) {
      // Set the new route based on the configuration
      $route_url = $config->get('default_route');

      $routes['login.route'] = new Route(
        '/' . $route_url . '/login',
        array(
          '_form' => '\Drupal\user\Form\UserLoginForm',
          '_title' => $config_site->get('name') . ' User Login',
        ),
        array(
          '_user_is_logged_in' => 'FALSE',
        )
      );
    }

    return $routes;
  }
}
