<?php

namespace Drupal\login_switch\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Class RouteSubscriber.
 *
 * @package Drupal\user_login_switch\Routing
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase
{

  /**
   * {@inheritdoc}
   */
    protected function alterRoutes(RouteCollection $collection)
    {
        // Load Configuration
        $config = \Drupal::config('login_switch.settings');

        // Find the route object by the route name.
        if ($config->get('login')) {
            if ($route = $collection->get('user.login')) {
                // Always deny access to '/user/login'.
                $route->setRequirement('_access', 'FALSE');
            }
        }
    }
}
