<?php

namespace Drupal\login_switch\Routing;

use Symfony\Component\Routing\Route;

/**
 * Dynamic route class to override the default core login route.
 */
class DynamicRoute {

  /**
   * Checks if the module is activated and sets route.
   */
  public function routes() {
    // Get configuration for module and site.
    $config = \Drupal::config('login_switch.settings');
    $config_site = \Drupal::config('system.site');

    $routes = [];

    if ($config->get('login')) {
      // Set the new route based on the configuration.
      $route_url = $config->get('default_route');

      $routes['login.route'] = new Route(
            '/' . $route_url . '/login',
            [
              '_form' => '\Drupal\user\Form\UserLoginForm',
              '_title' => $config_site->get('name') . ' User Login',
            ],
            [
              '_user_is_logged_in' => 'FALSE',
            ]
        );
    }

    return $routes;
  }

}
