<?php

namespace Drupal\login_switch\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Configure site information settings for this site.
 */
class LoginSwitchSettingsForm extends ConfigBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'lc_test_menu_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->getConfig();

    $form['login'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable Default User Login Route'),
      '#description' => $this->t('This setting will force the /user/login route to be updated.'),
      '#default_value' => $config->get('login'),
    ];

    $form['settings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Login Settings'),
    ];

    $form['settings']['default_route'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Route update for the USER path /user/login.'),
      '#description' => $this->t(
          'This setting can be overwritten in your settings file using the following override:
      $config[\'login_switch.settings\'][\'default_route\'] = \'TEST\';  This will create a route of /TEST/login.'
      ),
      '#default_value' => $config->get('default_route'),
      '#required' => FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

}
