<?php

namespace Drupal\login_switch\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Routing\Route;

/**
 * Dynamic route class to override the default core login route.
 */
class DynamicRoute implements ContainerInjectionInterface {

  protected $configFactory;

  /**
   * DynamicRoute constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   ConfigFactoryInterface.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * Checks if the module is activated and sets route.
   */
  public function routes() {
    // Get configuration for module and site.
    $config = $this->configFactory->get('login_switch.settings');
    $config_site = $this->configFactory->get('system.site');

    $routes = [];
    if ($config->get('login')) {
      // Set the new route based on the configuration.
      $route_url = $config->get('default_route');

      $routes['login.route'] = new Route(
            '/' . $route_url . '/login',
            [
              '_form' => '\Drupal\user\Form\UserLoginForm',
              '_title' => $config_site->get('name') . ' User Login',
            ],
            [
              '_user_is_logged_in' => 'FALSE',
            ]
        );
    }

    return $routes;
  }

}
