<?php

namespace Drupal\login_switch\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Class RouteSubscriber.
 *
 * @package Drupal\user_login_switch\Routing
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  public $configFactory;

  /**
   * RouteSubscriber constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   RouteSubscriber.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Load Configuration.
    $config = $this->configFactory->get('login_switch.settings');

    // Find the route object by the route name.
    if ($config->get('login')) {
      if ($route = $collection->get('user.login')) {
        // Always deny access to '/user/login'.
        $route->setRequirement('_access', 'FALSE');
      }
    }
  }

}
