<?php

namespace Drupal\login_warning\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Class LoginSubscriber.
 */
class LoginSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return([
      KernelEvents::REQUEST => [
        ['redirectToWarningPage'],
      ],
    ]);
  }

  /**
   * Redirect requests for user.login to warning page.
   *
   * @param \Symfony\Component\HttpKernel\Event\GetResponseEvent $event
   *   The original request.
   */
  public function redirectToWarningPage(GetResponseEvent $event) {
    $request = $event->getRequest();
    $route = $request->attributes->get('_route');
    // Perform redirect only on user.login.
    if ($route === 'user.login') {
      // If they've already clicked OK on the warning page, render the original
      // page and do not redirect them to the warning page.
      if ($request->query->has('warn')) {
        if ('ok' === $request->query->get('warn')) {
          return;
        }
      }
      // Set the original route in a URL query argument, so we can take them
      // back there if they click 'OK'.
      $option = [
        'route' => $route,
      ];
      $redirect_url = Url::fromRoute('login_warning.warning', $option);
      $response = new RedirectResponse($redirect_url->toString());
      $event->setResponse($response);
    }
  }

}
