<?php

namespace Drupal\login_warning\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Url;

/**
 * Controller routines for page example routes.
 */
class LoginWarningController extends ControllerBase {

  /**
   * Login warning page.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The original request.
   *
   * @return array
   *   A render array.
   */
  public function warning(Request $request) {

    $config = \Drupal::config('login_warning.settings');

    $route = $request->get('route', '<front>');
    // Route only applies to the login page.
    if ($route !== 'user.login') {
      $route = '<front>';
    }

    $title = $config->get('warning_title');

    $body = $config->get('warning_body.value');

    // Build the 'OK' link with warn=ok arg so it doesn't redirect user again.
    $option = [
      'warn' => 'ok',
    ];

    $continue_link = [
      'text' => $this->t('OK'),
      'uri' => Url::fromRoute($route, $option),
    ];

    $cancel_link = [
      'text' => $this->t('Cancel'),
      'uri' => Url::fromRoute('<front>'),
    ];

    $render_array['login_warning'] = [
      '#theme' => 'login_warning_page',
      '#title' => $title,
      '#body' => $body,
      '#continue_link' => $continue_link,
      '#cancel_link' => $cancel_link,
      '#cache' => ['max-age' => 0],
    ];

    return $render_array;
  }

}
