<?php

namespace Drupal\login_warning\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\FOrm\FormStateInterface;

/**
 * Defines the module configuration form.
 */
class LoginWarningConfigurationForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'login_warning_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'login_warning.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('login_warning.settings');
    $form['warning_title'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Login Warning Title'),
      '#default_value' => $config->get('warning_title'),
    ];

    $form['warning_body'] = [
      '#type' => 'text_format',
      '#rows' => 5,
      '#title' => $this->t('Login Warning Body'),
      '#format' => $config->get('warning_body.format'),
      '#default_value' => $config->get('warning_body.value'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('login_warning.settings')
      ->set('warning_title', $form_state->getValue('warning_title'))
      ->set('warning_body', $form_state->getValue('warning_body'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
