<?php

/**
 * @file
 * Provides the LoginCookie API documentation.
 */

/**
 * Loads all default login/logout cookies that are to be set at the operation.
 *
 * @param $op
 *   A string representing if the user is to "login" or "logout".
 *
 * @return
 *   An array of cookies with key pairs of:
 *     "name", "value", "expire", "path", "domain", and "secure".
 */
function hook_logincookie_set($op) {
  $cookies = array();
  // Set the mycookie cookie when the user logs in.
  if ($op == 'login') {
    $cookies[] = array(
      'name' => 'mycookie',
      'value' => 'loggedin',
      'expire' => 300,
      'path' => '/',
      'domain' => '.example.com',
      'secure' => FALSE,
    );
  }
  return $cookies;
}

/**
 * Loads all default login/logout cookies that are to be unset at the operation.
 *
 * @param $op
 *   A string representing if the user is to "login" or "logout".
 *
 * @return
 *   An array of cookies with key pairs of:
 *     "name", "path", "domain", and "secure".
 */
function hook_logincookie_unset($op) {
  $cookies = array();
  // Unset the mycookie cookie when the user logs out.
  if ($op == 'logout') {
    $cookies[] = array(
      'name' => 'mycookie',
      'path' => '/',
      'domain' => '.example.com',
      'secure' => FALSE,
    );
  }
  return $cookies;
}
