<?php

namespace Drupal\loginnotification\Form;

/**
 * @file
 * Contains Drupal\loginnotification\Form\LoginNotificationConfigurationForm.
 */

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Initialization Class LoginNotificationConfigurationForm.
 */
class LoginNotificationConfigurationForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'loginnotification.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'loginnotification_configuration_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('loginnotification.settings');
    $notification_mail_body = $config->get('notification_mail_body') ?? '';

    $form['loginnotification_mail_body'] = [
      '#type' => 'text_format',
    // Or 'basic_html', 'filtered_html'.
      '#format' => $config->get('notification_mail_body_format') ?? 'full_html',
      '#default_value' => $notification_mail_body['value'] ?? '',
      '#title' => $this->t('Enter email body'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('loginnotification.settings')
      ->set('notification_mail_body', $form_state->getValue('loginnotification_mail_body'))
      ->set('notification_mail_body_format', $form_state->getValue('loginnotification_mail_body')['format'])
      ->save();

    drupal_flush_all_caches();
  }

}
