<?php
/**
 * @file loginza.pages.inc
 *    Pages and callbacks.
 */

function loginza_callback() {
  global $user;

  if (empty($_POST['token'])) {
    watchdog('loginza', 'token_url call attempt w/out token', array(), WATCHDOG_WARNING);
    drupal_access_denied();
    return;
  }

  $result = drupal_http_request('http://loginza.ru/api/authinfo?token=' . $_POST['token']);
  if ($result->code != 200) {
    watchdog('loginza', "Invalid response for auth info request:\r\n<pre>@response</pre>",
      array('@response' => var_export($result, TRUE)), WATCHDOG_WARNING);
    drupal_set_message(t('Unable to authorise. Invalid response from Loginza.'), 'warning');
    drupal_goto();
  }

  $data = (array) json_decode($result->data);
  if (!empty($data['error_type'])) {
    watchdog('loginza', "Error while Loginza authentication:\r\n<pre>@data</pre>",
      array('@data' => var_export($data, TRUE)), WATCHDOG_WARNING);
    drupal_set_message(t('Unable to authorise. @reason.', array('@reason' => $data['error_message'])), 'warning');
    drupal_goto();
  }

  loginza_save_identity_data($data);
  $account = user_external_load($data['identity']);
  if (isset($account->uid)) {
    if (!variable_get('user_email_verification', TRUE) || $account->login) {
      // Check if user is blocked.
      $state['values']['name'] = $account->name;
      user_login_name_validate(array(), $state);
      if (!form_get_errors()) {

        $user = $account;
        $form_state['uid'] = $account->uid;
        user_authenticate_finalize($form_state);
        // Let other modules act on Loginza login
        module_invoke_all('loginza_data', $data, $account);
        
        // Redirect would follow to destination param
        drupal_goto();
      }
    }
    else {
      drupal_set_message(t('You must validate your email address for this account before logging in via Loginza.'));
    }
  }
  elseif (user_is_logged_in()) {
    // If we are here - user is trying to associate new identity with the account.
    // Save response for use in loginza_user_identities().
    $_SESSION['loginza']['data'] = $data;
  }
  elseif (variable_get('user_register', USER_REGISTER_VISITORS_ADMINISTRATIVE_APPROVAL)) {

    // Save response for use in loginza_form_user_register_form_alter().
    $_SESSION['loginza']['data'] = $data;
    
    $form_state = array('storage' => NULL, 'submitted' => FALSE, 'values' => array());
    $form_state['values']['op'] = t('Create new account');

    loginza_user_register_form_submit($form_state);
    
    if (!empty($form_state['user'])) {
      module_invoke_all('loginza_data', $data, $form_state['user']);
      drupal_goto();
    }
    
    $messages = drupal_get_messages('error');
    if (empty($form_state['values']['name']) || empty($form_state['values']['mail'])) {
      // If the Loginza did not provide both a user name and an email
      // address, ask the user to complete the registration manually instead of
      // showing the error messages about the missing values generated by FAPI.
      drupal_set_message(t('Complete the registration by filling out the form below. If you already have an account, you can <a href="@login">log in</a> now and add your Loginza identity under "My account".', array('@login' => url('user/login'))), 'warning');
    }
    elseif (!empty($messages)) {
      drupal_set_message(t('Account registration using the information provided by Loginza failed due to the reasons listed below. Complete the registration by filling out the form below. If you already have an account, you can <a href="@login">log in</a> now and add your Loginza identity under "My account".', array('@login' => url('user/login'))), 'warning');
      // Append form validation errors below the above warning.
      foreach ($messages['error'] as $message) {
        drupal_set_message($message, 'error');
      }
    }

    // We were unable to register a valid new user. Redirect to the normal
    // registration page and prefill with the values we received.
    $destination = drupal_get_destination();
    unset($_GET['destination']);
    drupal_goto('user/register', array('query' => $destination));
  }
  else {
    drupal_set_message(t('Only site administrators can create new user accounts.'), 'error');
  }
  drupal_goto();
}

function loginza_user_identities($account) {
  $name = !empty($account->name) ? $account->name : variable_get('anonymous', t('Anonymous'));
  drupal_set_title($name);

  if (!empty($_SESSION['loginza']['data'])) {
    $data = $_SESSION['loginza']['data'];
    db_query("INSERT INTO {authmap} (uid, authname, module) ".
             "VALUES(%d, '%s', 'loginza')", $account->uid, $data['identity']);
    
    drupal_set_message(t('Successfully added %identity', array('%identity' => $data['identity'])));
    unset($_SESSION['loginza']);
  }

  $header = array(t('Loginza Identity'), t('Operations'));
  $rows = array();

  $result = db_query("SELECT * FROM {authmap} WHERE module = 'loginza' AND uid = %d", $account->uid);
  while ($identity = db_fetch_object($result)) {
    $rows[] = array(
      check_plain($identity->authname),
      l(t('Delete'), 'user/' . $account->uid . '/loginza/delete/' . $identity->aid)
    );
  }
  
  return theme('loginza_user_identities', $header, $rows);
}

function loginza_user_delete_form($form_state, $account, $aid = 0) {
  $authname = db_result(db_query("SELECT authname FROM {authmap} ".
                                 "WHERE uid = %d AND aid = %d AND module LIKE 'loginza'", $account->uid, $aid));

  return confirm_form(array(), t('Are you sure you want to delete the Loginza identity @authname for @user?',
    array('@authname' => $authname, '@user' => $account->name)), 'user/' . $account->uid . '/loginza'
  );
}

function loginza_user_delete_form_submit($form, &$form_state) {
  
  // Skip form_id and form_state
  array_shift($form['#parameters']);
  array_shift($form['#parameters']);
  list($account, $aid) = $form['#parameters'];
  $query = db_query("DELETE FROM {authmap} WHERE uid = %d AND aid = %d AND module LIKE 'loginza'",
                    $account->uid, $aid);
  
  if ($query) {
    drupal_set_message(t('Loginza identity deleted.'));
  }
  $form_state['redirect'] = 'user/'. $account->uid .'/loginza';
}

/**
 * Helper to submit user_register form programmaticaly
 */
function loginza_user_register_form_submit(&$form_state) {
  $form_id = 'user_register';

  $form = call_user_func_array('drupal_retrieve_form', array($form_id, &$form_state));
  drupal_prepare_form($form_id, $form, $form_state);
  
  $form['#programmed'] = TRUE;
  drupal_process_form($form_id, $form, $form_state);
}