<?php
/**
 * @file loginza.pages.inc
 *    Pages and callbacks.
 */

function loginza_callback() {
  if (empty($_POST['token'])) {
    watchdog('loginza', 'token_url call attempt w/out token', array(), WATCHDOG_WARNING);
    drupal_access_denied();
    return;
  }

  $result = drupal_http_request('http://loginza.ru/api/authinfo?token=' . $_POST['token']);
  if ($result->code != 200) {
    watchdog('loginza', "Invalid response for auth info request:\r\n<pre>@response</pre>",
      array('@response' => var_export($result, TRUE)), WATCHDOG_WARNING);
    drupal_set_message(t('Unable to authorize. Invalid response from Loginza.'), 'warning');
    drupal_goto();
  }

  $data = drupal_json_decode($result->data);
  if (!empty($data['error_type'])) {
    watchdog('loginza', "Error while Loginza authentication:\r\n<pre>@data</pre>",
      array('@data' => var_export($data, TRUE)), WATCHDOG_WARNING);
    drupal_set_message(t('Unable to authorize. @reason.', array('@reason' => $data['error_message'])), 'warning');
    drupal_goto();
  }

  loginza_save_identity_data($data);
  $account = user_external_load($data['identity']);
  if (isset($account->uid)) {
    if (!variable_get('user_email_verification', TRUE) || $account->login) {
      // Check if user is blocked.
      $state['values']['name'] = $account->name;
      user_login_name_validate(array(), $state);
      if (!form_get_errors()) {
        // Load global $user and perform final login tasks.
        $form_state['uid'] = $account->uid;
        user_login_submit(array(), $form_state);
        // Let other modules act on Loginza login
        module_invoke_all('loginza_data', $data, $account);
      }
    }
    else {
      drupal_set_message(t('You must validate your email address for this account before logging in via Loginza.'));
    }
  }
  elseif (user_is_logged_in()) {
    // If we are here - user is trying to associate new identity with the account.
    // Save response for use in loginza_user_identities().
    $_SESSION['loginza']['data'] = $data;
  }
  elseif (variable_get('user_register', USER_REGISTER_VISITORS_ADMINISTRATIVE_APPROVAL)) {
    // Register new user.

    // Save response for use in loginza_form_user_register_form_alter().
    $_SESSION['loginza']['data'] = $data;

    $form_state['values'] = array();
    $form_state['values']['op'] = t('Create new account');
    drupal_form_submit('user_register_form', $form_state);

    if (!empty($form_state['user'])) {
      module_invoke_all('loginza_data', $data, $form_state['user']);
      drupal_goto();
    }

    $messages = drupal_get_messages('error');
    if (empty($form_state['values']['name']) || empty($form_state['values']['mail'])) {
      // If the Loginza did not provide both a user name and an email
      // address, ask the user to complete the registration manually instead of
      // showing the error messages about the missing values generated by FAPI.
      drupal_set_message(t('Complete the registration by filling out the form below. If you already have an account, you can <a href="@login">log in</a> now and add your Loginza identity under "My account".', array('@login' => url('user/login'))), 'warning');
    }
    else {
      drupal_set_message(t('Account registration using the information provided by Loginza failed due to the reasons listed below. Complete the registration by filling out the form below. If you already have an account, you can <a href="@login">log in</a> now and add your Loginza identity under "My account".', array('@login' => url('user/login'))), 'warning');
      // Append form validation errors below the above warning.
      foreach ($messages['error'] as $message) {
        drupal_set_message($message, 'error');
      }
    }

    // We were unable to register a valid new user. Redirect to the normal
    // registration page and prefill with the values we received.
    $destination = drupal_get_destination();
    unset($_GET['destination']);
    drupal_goto('user/register', array('query' => $destination));
  }
  else {
    drupal_set_message(t('Only site administrators can create new user accounts.'), 'error');
  }
  drupal_goto();
}

function loginza_user_identities($account) {
  drupal_set_title(format_username($account));

  if (!empty($_SESSION['loginza']['data'])) {
    $data = $_SESSION['loginza']['data'];
    db_insert('authmap')
        ->fields(array(
      'uid' => $account->uid,
      'authname' => $data['identity'],
      'module' => 'loginza',
    ))
        ->execute();
    drupal_set_message(t('Successfully added %identity', array('%identity' => $data['identity'])));
    unset($_SESSION['loginza']);
  }

  $header = array(t('Loginza Identity'), t('Operations'));
  $rows = array();

  $result = db_query("SELECT * FROM {authmap} WHERE module = 'loginza' AND uid = :uid", array(':uid' => $account->uid));
  foreach ($result as $identity) {
    $rows[] = array(
      check_plain($identity->authname),
      l(t('Delete'), 'user/' . $account->uid . '/loginza/delete/' . $identity->aid)
    );
  }

  $build['loginza_table'] = array(
    '#theme' => 'table',
    '#header' => $header,
    '#rows' => $rows,
  );
  $build['loginza_user_add'] = array(
    '#type' => 'item',
    '#title' => t('Associate more identities'),
    '#markup' => theme('loginza_iframe'),
  );
  return $build;
}

function loginza_user_delete_form($form, $form_state, $account, $aid = 0) {
  $authname = db_query("SELECT authname FROM {authmap} WHERE uid = :uid AND aid = :aid AND module = 'loginza'", array(
    ':uid' => $account->uid,
    ':aid' => $aid,
  ))
      ->fetchField();
  return confirm_form(array(), t('Are you sure you want to delete the Loginza identity %authname for %user?',
    array('%authname' => $authname, '%user' => $account->name)), 'user/' . $account->uid . '/loginza'
  );
}

function loginza_user_delete_form_submit($form, &$form_state) {
  $query = db_delete('authmap')
      ->condition('uid', $form_state['build_info']['args'][0]->uid)
      ->condition('aid', $form_state['build_info']['args'][1])
      ->condition('module', 'loginza')
      ->execute();
  if ($query) {
    drupal_set_message(t('Loginza identity deleted.'));
  }
  $form_state['redirect'] = 'user/' . $form_state['build_info']['args'][0]->uid . '/loginza';
}
