/**
 * @file
 * Logo Image Enhanced - Apply attributes via JavaScript.
 */
(function (Drupal, drupalSettings, once) {
  'use strict';

  Drupal.behaviors.logoImageEnhanced = {
    attach: function (context) {
      var settings = drupalSettings.logoImageEnhanced;
      if (!settings) {
        return;
      }

      // Find logo images.
      var images = context.querySelectorAll('img');
      images.forEach(function (img) {
        var src = (img.src || '').toLowerCase();
        var className = (img.className || '').toLowerCase();
        var parentClass = img.parentElement ? (img.parentElement.className || '').toLowerCase() : '';

        var isLogo = src.indexOf('logo') !== -1 ||
                     className.indexOf('logo') !== -1 ||
                     parentClass.indexOf('logo') !== -1 ||
                     parentClass.indexOf('branding') !== -1;

        if (!isLogo || img.hasAttribute('data-logo-enhanced')) {
          return;
        }

        // Mark as processed.
        img.setAttribute('data-logo-enhanced', 'true');

        // Apply alt and title.
        if (settings.logoAlt) {
          img.setAttribute('alt', settings.logoAlt);
        }
        if (settings.logoTitle) {
          img.setAttribute('title', settings.logoTitle);
        }

        // Apply styled URL.
        if (settings.styleEnabled && settings.styledUrl) {
          var currentSrc = img.getAttribute('src') || '';
          if (currentSrc.indexOf('/styles/') === -1) {
            img.setAttribute('data-original-src', currentSrc);
            img.setAttribute('src', settings.styledUrl);

            if (img.hasAttribute('srcset')) {
              img.removeAttribute('srcset');
            }
          }
        }

        // Apply dimensions.
        if (settings.width && settings.height) {
          img.setAttribute('width', settings.width);
          img.setAttribute('height', settings.height);
        }
      });
    }
  };

})(Drupal, drupalSettings, once);