/**
 * @file
 * Logo Image Enhanced - Diagnostic panel.
 */
(function (Drupal, drupalSettings, once) {
  'use strict';

  Drupal.behaviors.logoImageEnhancedDiagnostic = {
    attach: function (context) {
      // DOM Analysis.
      once('logo-debug-dom', '#logo-debug-dom', context).forEach(function (container) {
        var html = '';
        var images = document.querySelectorAll('img');
        var logos = [];

        images.forEach(function (img) {
          var src = (img.src || '').toLowerCase();
          if (src.indexOf('logo') !== -1) {
            logos.push(img);
          }
        });

        if (logos.length === 0) {
          html = '<p class="status-error">⚠️ No logo found</p>';
        } else {
          html = '<p class="status-ok">✓ Found ' + logos.length + '</p><ul>';
          logos.forEach(function (img, i) {
            var src = img.getAttribute('src') || '';
            var isStyled = src.indexOf('/styles/') !== -1;
            var w = img.getAttribute('width') || img.naturalWidth || '?';
            var h = img.getAttribute('height') || img.naturalHeight || '?';

            html += '<li>';
            html += '<strong>#' + (i + 1) + '</strong> ';
            html += '<span class="' + (isStyled ? 'status-ok' : 'status-warning') + '">';
            html += isStyled ? '✓ Styled' : '✗ Original';
            html += '</span><br>';
            html += 'Size: ' + w + '×' + h + '<br>';
            html += 'alt: ' + (img.alt || '<em>empty</em>') + '<br>';
            html += 'title: ' + (img.title || '<em>empty</em>');
            html += '</li>';
          });
          html += '</ul>';
        }

        container.innerHTML = html;
      });

      // JS Settings.
      once('logo-debug-js', '#logo-debug-js', context).forEach(function (container) {
        var html = '';
        var s = drupalSettings.logoImageEnhanced;

        if (s) {
          html = '<ul>';
          html += '<li>styleEnabled: ' + (s.styleEnabled ? 'Yes' : 'No') + '</li>';
          html += '<li>width: ' + (s.width || 'N/A') + '</li>';
          html += '<li>height: ' + (s.height || 'N/A') + '</li>';
          html += '</ul>';
        } else {
          html = '<p class="status-warning">⚠️ Settings not found</p>';
        }

        container.innerHTML = html;
      });
    }
  };

})(Drupal, drupalSettings, once);