<?php

namespace Drupal\lupus_decoupled_views\Plugin\views\display;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views\Attribute\ViewsDisplay;
use Drupal\views\Plugin\views\display\Page;

/**
 * The plugin that handles a full page for a custom elements view.
 *
 * @ingroup views_display_plugins
 */
#[ViewsDisplay(
  id: "custom_elements_page",
  title: new TranslatableMarkup("Custom Elements Page"),
  help: new TranslatableMarkup("Display the view as page rendered with the custom_elements format."),
  uses_menu_links: TRUE,
  uses_route: TRUE,
  contextual_links_locations: ["custom_elements_page"],
  theme: "views_view",
  admin: new TranslatableMarkup("Custom Elements Page"),
)]
class CustomElementsPage extends Page {

  use CustomElementsViewsDisplayTrait;

  /**
   * {@inheritdoc}
   */
  public function render() {
    $render = parent::render();
    $rows = $render['#rows']['rows'] ?? [];
    // Manually pre-render the element, such that we can convert results into
    // the custom element.
    $render = $this->elementPreRender($render);
    $render = $this->buildCustomElement($this->view, $render, $rows)
      ->toRenderArray();
    $this->moduleHandler()->alter('lupus_decoupled_views_page_alter', $custom_element, $view, $render);
    return $render;
  }

  /**
   * {@inheritdoc}
   */
  public function preview() {
    $element = parent::preview();
    $element['#prefix'] = '<div class="preview-section"><pre>';
    $element['#suffix'] = '</pre></div>';
    return $element;
  }

}
