# Lupus Decoupled Form Support

## Overview

The "Lupus Decoupled Form" sub-module makes it easy to support Drupal forms in
a decoupled frontend. Together with the Nuxtjs Custom Elements Renderer module,
it provides a ready-to-use solution for supporting Drupal form in a progressive
way. The form HTML is rendered by Drupal and wrapped in a `<drupal-form>`
custom element, such that the frontend can easily add some styling or custom
JS-enhancements.

At the moment, progressive form submissions are supported, which work without
JavaScript. JavaScript enhanced form submissions are currently not a priority,
but can be achieved with some additional JavaScript code, see Issue [#3471135](https://www.drupal.org/project/lupus_decoupled/issues/3471135)
for some code to get started.

## How does it work?

Generally, Drupal renders the form as usual. The resulting HTML markup is
wrapped into a `<drupal-form-{FORM-ID}>` component, which simply shows the
server-rendered HTML of the form. When the form is submitted, the frontend
takes care of forwarding the POST request to the backend, where it's processed
as usual. After form processing the request is rendered in a custom element
response again: Either the page response contains a reloaded form or a
redirect. Any messages for form validation fails or success are handled as
usual via the [Drupal message system](/guide/breadcrumbs-messages) and sent as part of the next page
response. Thus, subsequently the frontend takes care of rendering the response
appropriately in a new page or redirect response - just as it does for any
other server-render page.

### Frontend support

* For the Nuxt frontend, The Nuxtjs Drupal-CE Connector module ships with a
suiting default component: [drupal-form--default.vue](https://github.com/drunomics/nuxtjs-drupal-ce/blob/2.x/playground/components/global/drupal-form--default.vue)
* There is [server middleware](https://github.com/drunomics/nuxtjs-drupal-ce/blob/4d8c9e43d8a3ed1f1f6480425b25016b82e57579/src/runtime/server/middleware/drupalFormHandler.ts)
which takes care of handling the POST request and renders the response.

## Rendering forms in the frontend

Generally, the `drupal-form--default` component may be used to add form styles
and JavaScript as suiting, either generally for all forms via the default
component, or individually by customizing things in a per-form component
`drupal-form--{FORM-ID}`. Any Drupal CSS or JavaScript assets for the form
elements won't be included in the decoupled frontend, thus the frontend needs
to take care of providing suiting replacement style and scripts as necessary.

In order to change the HTML markup of forms, the form elements need to be
themed in Drupal.

### Theming form elements

Since the markup is generated by Drupal, the HTML of individual form
elements can be altered only by adjusting the Drupal markup with the
help of a Drupal theme:

* For having a clean, semantic output of forms, the [lupus-stark theme](https://www.drupal.org/project/lupus_stark) has been created - which
  adds suiting Drupal twig files to do away unnecessary Drupal-isms.
  That way decent markup is generated and necessary style adaptions are
  made possible by targeting elements using the reasonable default classes.
* Generally, the active Drupal theme can be customized by setting the
  theme as site-wide standard theme. If the form is on a Drupal admin page,
  the Admin Theme will be applied though.
* The module adds support for a special '_theme' key in route definitions,
  what allows Drupal developers to switch themes to the given theme-name
  specifically for the form routes, as preferred.


## Adding support for a form

For adding a new form a custom-elements enabled form processing route
must be added. This is done easily by:

1. Ensuring there is a custom-elements enabled route,
   e.g. by cloning the original one and adding
   `custom_elements` as `_format`.
2. Pointing the custom-elements enabled route to a form
   controller that renders the results as custom elements.
   For standard form or entity_form controllers the following
   controllers may be specified:
     * For general forms: `lupus_decoupled_form.controller.form:getContentResult`
     * For entity forms:  `lupus_decoupled_form.controller.entity_form:getContentResult`
   Else, a custom controller can be easily be provided with the help
   of the `CustomElementsFormControllerTrait`, see the
   `lupus_decoupled_contact ` for an example.

That's it!

Generally, https://git.drupalcode.org/project/lupus_decoupled/-/tree/1.x/modules/
serves as a simple example that demonstrates how support for contact
forms is enabled.
