# Lupus Decoupled Drupal Recipe

A Drupal recipe that installs and configures the [Lupus Decoupled Drupal](https://lupus-decoupled.org/) module.

## Usage

### Standard Recipe (Site recipe)

For a complete site setup with Drupal's standard profile and Lupus Decoupled integration, use the standard sub-recipe:

```bash
drush site-install ../recipes/lupus_decoupled_recipe/standard
```

This installs:
- Drupal standard profile (Article and Page content types, comments, taxonomy, search, etc.)
- Lupus Decoupled Drupal with custom elements display configurations
- Simple, pre-configured custom elements for articles and pages (default and full view modes)

### Base Recipe

For a minimal setup or to use as a base for custom recipes:

```bash
composer require drupal/lupus_decoupled_recipe
drush recipe ../recipes/lupus_decoupled_recipe
```

Use this recipe as a base recipe for more sophisticated recipes.

## Project setup

Please refer to the project repository on [GitHub](https://github.com/drunomics/lupus-decoupled-project) for a complete project setup that is making e of this recipes.

## Credits

* Initial development, maintenance - drunomics GmbH <hello@drunomics.com>
