<?php

declare(strict_types=1);

namespace Drupal\FunctionalTests\Recipe\lupus_decoupled_recipe\standard;

use Drupal\Tests\system\Functional\Recipe\GenericRecipeTestBase;

/**
 * Tests Lupus Decoupled Standard recipe.
 *
 * @group lupus_decoupled_recipe_standard
 * @group #slow
 */
class GenericStandardTest extends GenericRecipeTestBase {

  /**
   * {@inheritdoc}
   */
  protected $strictConfigSchema = FALSE;

  /**
   * {@inheritdoc}
   */
  protected function getRecipePath(): string {
    // Test the standard sub-recipe.
    return dirname((new \ReflectionObject($this))->getFileName(), 4) . '/standard';
  }

  /**
   * {@inheritdoc}
   */
  public function testRecipeCanBeApplied(): void {
    parent::testRecipeCanBeApplied();

    // Verify article default view mode config.
    $config = $this->config('custom_elements.entity_ce_display.node.article.default');
    $this->assertSame('node-article', $config->get('customElementName'));
    $this->assertSame('field:text_trimmed', $config->get('content.body.formatter'));
    $this->assertTrue($config->get('content.body.is_slot'));
    $this->assertTrue($config->get('content.image.is_slot'));

    // Verify article full view mode config.
    $config = $this->config('custom_elements.entity_ce_display.node.article.full');
    $this->assertSame('node-article-full', $config->get('customElementName'));
    $this->assertSame('field:text_default', $config->get('content.body.formatter'));
    $this->assertTrue($config->get('content.body.is_slot'));

    // Verify page default view mode config.
    $config = $this->config('custom_elements.entity_ce_display.node.page.default');
    $this->assertSame('node-page', $config->get('customElementName'));
    $this->assertSame('field:text_trimmed', $config->get('content.body.formatter'));
    $this->assertTrue($config->get('content.body.is_slot'));

    // Verify page full view mode config.
    $config = $this->config('custom_elements.entity_ce_display.node.page.full');
    $this->assertSame('node-page-full', $config->get('customElementName'));
    $this->assertSame('field:text_default', $config->get('content.body.formatter'));
    $this->assertTrue($config->get('content.body.is_slot'));
  }

}
