(function ($, Drupal, once) {

  'use strict';

  /**
   * Attaches the Luzmo Dashboard Responsive behavior to the specified context.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the behavior for luzmoDashboardResponsive.
   */
  Drupal.behaviors.luzmoDashboardResponsive = {
    attach: function (context) {
      if (once('luzmoDashboardResize', 'html').length) {
        window.addEventListener('resize', function () {
          const dashboards = context.querySelectorAll('luzmo-dashboard');
          dashboards.forEach(dashboard => {
            const shadowRoot = dashboard.shadowRoot || null;
            if (shadowRoot) {
              shadowRoot.querySelectorAll('.dashboard-container').forEach(container => {
                container.style.width = '100%';
              });
            }
          });
        });
      };
    }
  };
})(jQuery, Drupal, once);
