<?php

namespace Drupal\luzmo_viewer;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a class for reacting to library events.
 */
class LibraryOperations implements ContainerInjectionInterface {

  /**
   * The Config Factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * LeafletOperations constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory service.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * Acts on library info alter phase.
   *
   * @param array $libraries
   *   An associative array of libraries registered by $extension.
   * @param string $extension
   *   Can either be 'core' or the machine name of the extension
   *   that registered the libraries.
   */
  public function libraryInfoAlter(array &$libraries, $extension) {
    if ($extension == 'luzmo_viewer') {
      foreach ($this->getLuzmoExternalLibraries() as $key => $value) {
        if (!empty($value)) {
          if ($key == 'js') {
            $libraries["luzmo-viewer"][$key][$value] = [
              'type' => 'external',
              'minified' => TRUE,
            ];
          }
        }
      }
    }
  }

  /**
   * Gets the Luzmo external libraries defined in the configurations.
   *
   * @return array
   *   An array containing the Luzmo external libraries.
   */
  private function getLuzmoExternalLibraries() {
    /*
     * Loads the luzmo_viewer configurations.
     */
    $config = $this->configFactory->get('luzmo_viewer.settings');
    /*
     * Initialize libraries.
     */
    $libraries = [];
    /*
     * Add geocoder js library.
     */
    if (!empty($config->get('luzmo_js'))) {
      $libraries['js'] = $config->get('luzmo_js');
    }
    return $libraries;
  }

}
