<?php

namespace Drupal\luzmo_viewer\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines the 'luzmo_viewer_dashboard' field widget.
 *
 * @FieldWidget(
 *   id = "luzmo_viewer_dashboard",
 *   label = @Translation("Luzmo Dashboard"),
 *   field_types = {"luzmo_viewer_dashboard"},
 * )
 */
class LuzmoDashboardWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element['dashboard_id'] = [
      '#type' => 'textfield',
      '#description' => $this->t('The id of the Luzmo dashboard you wish to embed.'),
      '#default_value' => $items[$delta]->dashboard_id ?? '',
      '#title' => $this->t('Luzmo Dashboard ID'),
    ];

    // Only show the options when a dashboard ID is provided.
    $parents = $element['#field_parents'];
    $parents[] = $this->fieldDefinition->getName();
    $selector = $root = array_shift($parents);
    if ($parents) {
      $selector = $root . '[' . implode('][', $parents) . ']';
    }
    $element['options'] = [
      '#type' => 'details',
      '#title' => $this->t('Luzmo Dashboard Settings'),
      '#group' => 'settings_group',
      '#open' => !empty($items[$delta]->dashboard_id),
      '#states' => [
        'visible' => [
          ':input[name="' . $selector . '[' . $delta . '][dashboard_id]"]' => ['filled' => TRUE],
        ],
      ],
    ];

    $element['options']['itemId'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Item ID'),
      '#description' => $this->t('Enter an Item ID to load only that specific item from the Luzmo dashboard. Leave empty to load the full dashboard.'),
      '#default_value' => $items[$delta]->options['itemId'] ?? '',
    ];

    return $element;
  }

  /**
   * {@inheritDoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    return array_map(function (array $value) {
      if (isset($value['options'])) {
        $value['options'] = array_filter($value['options'], function ($option) {
          return $option !== "";
        });
      }
      return $value;
    }, $values);
  }

}
