<?php


/*
 * The following are all of the Maestro hooks available in the core and sub modules
 * separated by the files in which they are found.
 */



/**************************************************
 * maestro.module Hooks
 **************************************************/


// Found in maestro_tokens function
// let's pass off the fetching of the data to any hooks that wish to do any work on the entity type.
function hook_maestro_get_entity_token_value($entity, $token_name, $original, $token_parts, &$replacements) {
  // Using the entity, it's type, the name of the token, the original value, the parts of the token and the current replacement values
  // Use this hook to alter or add to the replacements if its not a node or webform
};





/**************************************************
 * MaestroEngine Hooks
 **************************************************/


// Post-variable save hook.  maestro.module has a stub in the event we need to do any more with the reassignment post var save.
// See function hook_maestro_post_variable_save in maestro.module
function hook_maestro_post_variable_save($variableName, $variableValue, $processID) {
  // You know this is a variable being saved.  You're provided a variable name, value and process ID.
  // Make any changes to set any other values or carry out whatever you need post variable saving.
}

// Found in getAssignedTaskQueueIds method.
// Invoke other modules to add their entity IDs to the already fetched list
// pass to the invoked handler, the user ID and the current set of entity IDs.
function hook_maestro_post_fetch_assigned_queue_tasks($userID, &$queueIDs) {
  // Does your module need to add to the assigned queue tasks listing?
  // This hook fires after Maestro has compiled the list of Queue IDs in an array that are assigned to $userID
}

// Alter hook:
\Drupal::moduleHandler()->alter('maestro_can_user_execute_task', $returnValue, $queueID, $userID);
// Found in canUserExecuteTask method
function hook_maestro_can_user_execute_task_alter(&$returnValue, $queueID, $userID) {
  //Make alterations to the returnValue boolean based on your needs/requirements.

  if($userID == 1) {
    $returnValue = TRUE;
  }
  else {
    $returnValue = FALSE;
  }

}

// Modify the validation information and failures if required
function hook_maestro_template_validation_check($templateMachineName, &$validation_failure_tasks, &$validation_information_tasks) {
  //During template validation, you are able to modify the validation information and failure information
  //in the event there is something extra you have added to task configurations
}

// We do a module invoke for any add-on modules to do their own assignments or tweak the assignments.
function hook_maestro_post_production_assignments($templateMachineName, $taskID, $queueID) {
  //Fires after a production task assignment is done. You can use the template machine name, task ID and queue ID to 
  //perform any post assignment routines
}


// Notification hook for specific notification type
function hook_maestro_production_NOTIFICATIONTYPE_notification($queueID, $notification, &$notificationList) {
  //Use this hook to create/alter the notification being sent.
  //example:  hook_maestro_production_assignment_notification($queueID, $notification, $notificationList)

  //The $notification is an array of the configuration coming from the task on how this particular notification is configured. 
  // [0] is to what type of entity, [1] is fixed or variable, [2] is entity or variable, [3] is type
}

// Zero user notificaiton hook.  When an interactive task is assigned to a role with no discrete actors in it
// You can create your own notification mechanism with this hook
function hook_maestro_zero_user_notification($templateMachineName, $taskMachineName, $queueID, $notificationType) {
  //Do things like look up the token from the queue and create a customized URL for the outgoing notification.
}




/**************************************************
 * MaestroTaskTrait Hooks
 **************************************************/

 // Let other modules do their own assignments and notifications and any other task mods they want.
function hook_maestro_pre_task_save($templateMachineName, $taskID, &$task, $taskAssignments, $taskNotifications) {
  // Before saving a task, do you need to make any modifications or take action differently than Maestro?
}






/**************************************************
 * MaestroTaskConsoleController Hooks
 **************************************************/

// Let people change the name of the link to execute the task if they so choose to do so.
function hook_maestro_task_console_interactive_link_alter(&$link, $taskTemplate, $queueRecord, $templateMachineName) {
  // during task console rendering, you can alter the link auto-generated by Maestro.
}


// Provide your own execution links in the task console 
function hook_maestro_task_console_alter_execution_link(&$execute_link, $taskTemplate, $queueRecord, $templateMachineName) {
  // During task console rendering, you can alter the execution link.
  //Provides full task and queue information for alteration
}

// Provide or alter your own execution URL in the task console.
// The last parameter of $url_type will either be 'internal' or 'function' allowing you to decipher 
// if the URL is function generated or is a direct URL to a Drupal route
// For example, 'internal' will be a link used by the Content Type task for editing a content type as the route is a proper Drupal route.
// If 'function' the route is not a routable Drupal URL and is therefore deciphered by the Maestro task execution middleware.
function hook_maestro_task_console_interactive_url_alter(&$handler, &$query_options, $taskTemplate, $queueRecord, $templateMachineName, $url_type) {
  // During task console rendering, you can alter the URL to a task
  //Provides full task and queue information for alteration
}



// We provide an invokation here to allow other modules to inject their own custom information into the task display.
// This hook fires as the task row is being rendered.  
// The custom information will appear as a custom information bar surrounded by a DIV with class="custom-information"
// This bar will appear directly above the views-based task information expansion area.
function hook_maestro_task_console_custominformation_alter(&$customInformation, $taskTemplate, $queueRecord, $templateMachineName) {
  //set $customInformation with the desired customized text/structure you wish to show in the console's task row.
}


// Anyone want to override the task details display?
// This hook fires after the views-based task details have been rendered and allows you to alter that rendered content
function hook_maestro_task_console_taskdetails_alter(&$taskDetails, $taskTemplate, $queueRecord, $templateMachineName) {
  // $taskDetails holds rendered content to be displayed in the task's expanded details view.
  // This is HTML rendered data.  Add to it, prefix it, suffix is.  Whatever you need to do.
}





/**************************************************
 * MaestroWebformTask Hooks
 **************************************************/

// Does the developer/admin wish to attach any custom webform form elements?
// Fires during the getExecutableForm method in the Maestro Webform Engine Task.
// The result is a rendered task in the task console with the form fields you decide to provide, if any.
function hook_maestro_webform_submission_form($queueID, &$form, &$webformEngineTask) {
  //use $form as any other Drupal Form API form and add/remove/alter anything from the webform as you see fit.
}



// Complete the task, but we'll also flag it as TASK_STATUS_CANCEL
// Let the devs manage the submission as well
// Fires in the handleExecuteSubmit method of the Maestro Webform Engine Task
function hook_maestro_webform_submission_set_cancel_completion_status($queueID, &$form, &$form_state, $triggeringElement, &$completeTask) {
  //This method allows you to alter the $competeTask boolean flag.
  //If you set the $completeTask boolean to FALSE, the task will not be completed and its status not set.
  //You can complete and set the task status as you see fit in this hook.
}



// Fires after a webform submission has been completed by Maestro and just before any task execution redirect to, say, the task console.
// Let the devs manage the submission as well.  
function hook_maestro_webform_submission_form_submit($queueID, &$form, &$form_state, $triggeringElement) {
  //Do whatever post-webform-task completion processing you may need to do.
  //Note, the task may not actually be Maestro-complete.  But the execution of the submission has been completed.
}

/*************************************************************
 * MaestroSetProcessVariables - Plugin Hooks
 *************************************************************/


// Fires from the **SetNumberOfItems** SPV Plugin
// \Drupal::moduleHandler()->alter('maestro_set_process_variable_entity_field_list', $entity_field_list);
// Allows you to add to the entity field list that is presented to the user.
// For example, using ECK?  Use this hook to add to the entity field list?
function hook_maestro_set_process_variable_entity_field_list_alter($entity_field_list) {
  /** 
   * $entity_field_list is an array of arrays.  Contains an array that looks like
   * 
   * [entity_type] =>
   *    [bundle] =>
   *        [name] => bundle name/label
   *        [fields] => 
   *            [
   *              array of the field machine name => field label
   *            ]
   * 
   */
}

// Fires from the **SetNumberOfItems** SPV Plugin
// \Drupal::moduleHandler()->alter('maestro_set_process_variable_entity_types_list', $entity_types);
// Allows you to add to the entity type list that is presented to the user.
//  For example, using ECK?  Use this hook to add to the entity type list.
function hook_maestro_set_process_variable_entity_types_list($entity_types) {
  // The entity types is simple array of machine_name => entity label.  Add to it as you see fit
}

// Fires from the **SetNumberOfItems** SPV Plugin during execute.
// If you have a special entity type that needs extra processing to get the number of multi-value items in a field
// then this hook runs at the end of the execute for the plugin
function hook_maestro_spv_set_number_of_items_plugin($queueID, $processID, $task, $templateMachineName, &$returnValue) {
  //$returnValue passed by reference, so alter it directly in code.
}

// Fires from the **GetEntityIdentifierFieldValueDeltaFromProcessVariable** SPV Plugin during execute.
// If you have a special entity type that needs extra processing to get the value from a multi-value field
// then this hook runs at the end of the execute for the plugin
function hook_maestro_spv_get_field_value_delta_with_pv($queueID, $processID, $task, $templateMachineName, &$returnValue) {
  //$returnValue passed by reference, so alter it directly in code.
}

// Fires from the **GetContentTypeFieldValue** SPV Plugin during execute.
// If you have a special content type that needs extra processing to get the value from a field
// then this hook runs at the end of the execute for the plugin
function hook_maestro_spv_get_content_type_field_value_plugin($queueID, $processID, $task, $templateMachineName, &$returnValue) {
  //$returnValue passed by reference, so alter it directly in code.
}


/**************************************************
 * MaestroBatchFunctionTask Hooks
 * MaestroInteractiveTask Hooks
 * MaestroAutoCompleteController Hooks
 **************************************************/

// Let modules signal the handlers they wish to share.
// Not available in Batch function task
// Available in Interactive function task
// Available in AutoComplete controller
function hook_maestro_interactive_handlers() {
  // Add to the interactive handlers via this hook.
}

// Let modules signal the handlers they wish to share.
// Not available in Interactive function task
// Available in Batch function task
// Available in AutoComplete controller
function hook_maestro_batch_handlers() {
  // Add to the batch handlers via this hook.
}






/**************************************************
 * MaestroProcessStatusController Hooks
 **************************************************/

// Anyone want to override the task details display or add to it?
function hook_maestro_process_status_alter(&$taskDetails, $processID, $template) {
  // Lets you override/alter the task details in the Maestro Process Status block/display.
}



/**************************************************
 * MaestroStatus Utility Hooks
 **************************************************/

 // Anyone want to override the Maestro Status Bar?
function hook_maestro_task_console_status_bar_alter(&$status_bar, $processID) {
  // $status_bar holds the status bar information that you can alter/augment or even replace.
  // $processID provided as a way to look up the process in question, allowing you to know where
  // the process is in terms of execution and logical steps.
}