# Mail Actions

Provides action plugins for sending mails with formatted text and raw HTML.

# 0. Contents

1. Introduction
2. Requirements
3. Installation
4. Usage

# 1. Introduction

This module adds configurable actions for sending mails. Drupal core only
provides a mail action that supports plain text. This module adds further
mail actions that allow to send formatted text and raw HTML.

# 2. Requirements

This module only requires Drupal core. No other contrib module is required.

# 3. Installation

Install the module as you would normally install a contributed
Drupal module. Visit https://www.drupal.org/node/1897420 for further
information.

You probably need to initially configure your the mailer DSN settings of your
site. More details about configuring the transport DSN can be found here:
https://www.drupal.org/node/3369935

Following example can be used in a local `settings.php` file to test mailing
locally with MailHog (https://github.com/mailhog/MailHog):

```php
// Mailer DSN settings for local testing with MailHog.
$config['system.mail']['mailer_dsn'] = [
  'scheme' => 'smtp',
  'host' => 'localhost',
  'port' => 1025,
];

// Following part is usually not needed. This will be automatically configured
// when installing the module.
$config['system.mail']['interface']['mail_action'] = 'mail_action_html';
```

# 4. Usage

Once installed, you have two more action plugins available. They can be used
anywhere actions are involved.

The new action plugins are called
* "Send email with formatted text"
* "Send email with raw HTML"
