<?php

namespace Drupal\mail_action\Plugin\Mail;

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\Mail\Attribute\Mail;
use Drupal\Core\Mail\MailFormatHelper;
use Drupal\Core\Mail\Plugin\Mail\SymfonyMailer;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Utility\Error;
use Symfony\Component\Mime\Email;

/**
 * The "Mail action with HTML" mailer plugin.
 */
#[Mail(
  id: 'mail_action_html',
  label: new TranslatableMarkup('Mail action with HTML'),
)]
class MailActionHtmlMailer extends SymfonyMailer {

  /**
   * {@inheritdoc}
   */
  public function format(array $message) {
    foreach ($message['body'] as &$part) {
      if (!($part instanceof MarkupInterface)) {
        $part = MailFormatHelper::wrapMail($part);
      }
    }

    // Join the body array into one string.
    $message['body'] = implode("\n\n", $message['body']);

    return $message;
  }

  /**
   * {@inheritdoc}
   */
  public function mail(array $message) {
    try {
      $email = new Email();

      $headers = $email->getHeaders();
      foreach ($message['headers'] as $name => $value) {
        if (!in_array(strtolower($name), self::SKIP_HEADERS, TRUE)) {
          if (in_array(strtolower($name), self::MAILBOX_LIST_HEADERS, TRUE)) {
            // Split values by comma, but ignore commas encapsulated in double
            // quotes.
            $value = str_getcsv($value, ',');
          }
          $headers->addHeader($name, $value);
        }
      }

      $recipients = array_map('trim', explode(',', $message['to']));

      $email
        ->to(...$recipients)
        ->subject($message['subject'])
        ->html($message['body']);

      $mailer = $this->getMailer();
      $mailer->send($email);
      return TRUE;
    }
    catch (\Exception $e) {
      Error::logException($this->logger, $e);
      return FALSE;
    }
  }

}
