<?php

namespace Drupal\mail_entity_queue_symfony_mailer\Plugin\EmailBuilder;

use Drupal\symfony_mailer\EmailFactoryInterface;
use Drupal\symfony_mailer\MailerHelperTrait;
use Drupal\symfony_mailer\Processor\EmailBuilderBase;

/**
 * Email Builder for emails queued via mail_entity_queue and Symfony Mailer.
 *
 * @EmailBuilder(
 *   id = "symfony_mail_entity_queue",
 *   sub_types = { },
 *   common_adjusters = {},
 *   import = @Translation(""),
 *   proxy = FALSE,
 *   override = {},
 * )
 */
class SymfonyMailEntityQueueEmailBuilder extends EmailBuilderBase {

  use MailerHelperTrait;

  /**
   * {@inheritdoc}
   */
  public function fromArray(EmailFactoryInterface $factory, array $message) {
    $email = $factory->newTypedEmail(
      $message['module'],
      $message['key'],
      $message['params']
    );

    $email->setTo($this->helper()->parseAddress($message['to'], $message['langcode']));

    $format = empty($message['params']['format']) ? 'mail' : $message['params']['params']['format'];
    $email->setBody(check_markup($message['params']['body'], $format, $message['langcode']));

    if (isset($message['params']['subject'])) {
      $email->setSubject($message['params']['subject']);
    }

    if (isset($message['params']['cc'])) {
      $email->setCc($this->helper()->parseAddress($message['params']['cc'], $message['langcode']));
    }
    if (isset($message['params']['bcc'])) {
      $email->setBcc($this->helper()->parseAddress($message['params']['bcc'], $message['langcode']));
    }
    if (isset($message['params']['from'])) {
      $email->setFrom($this->helper()->parseAddress($message['params']['from'], $message['langcode']));
    }
    if (isset($message['params']['reply-to'])) {
      $email->setReplyTo($this->helper()->parseAddress($message['params']['reply-to'], $message['langcode']));
    }

    if (isset($message['params']['mail_entity_queue'])) {
      $email->setVariable('mail_entity_queue', $message['params']['mail_entity_queue']);
    }

    if (isset($message['params']['mail_entity_queue_item'])) {
      $email->setVariable('mail_entity_queue_item', $message['params']['mail_entity_queue_item']);
    }

    return $email;
  }

  /**
   * {@inheritdoc}
   */
  public function import() {
  }

}
