<?php

namespace Drupal\mail_entity_queue\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;

/**
 * Defines the interface for mail entity queue.
 */
interface MailEntityQueueInterface extends ConfigEntityInterface, EntityDescriptionInterface {

  /**
   * Gets the number of items to process in each cron run.
   *
   * @return int
   *   The number of items to process in each cron run.
   */
  public function getCronItems();

  /**
   * Sets the number of items to process in each cron run.
   *
   * @param int $items
   *   The number of items to process in each cron run.
   *
   * @return $this
   */
  public function setCronItems(int $items);

  /**
   * Gets the pause between execution of queue elements.
   *
   * @return int
   *   The mail entity queue delay in milliseconds for this queue.
   */
  public function getCronDelay();

  /**
   * Sets the pause between execution of queue elements.
   *
   * @param int $cron_delay
   *   The delay in milliseconds.
   *
   * @return $this
   */
  public function setCronDelay(int $cron_delay);

  /**
   * Gets an instanced of the mail entity queue processor plugin.
   *
   * @return \Drupal\mail_entity_queue\Plugin\MailEntityQueueProcessorInterface
   *   An instanced of the mail entity queue processor plugin.
   */
  public function getQueueProcessor();

  /**
   * Gets the mail entity queue plugin processor id.
   *
   * @return string
   *   The mail entity queue plugin processor id.
   */
  public function getQueueProcessorId();

  /**
   * Gets the email format.
   *
   * @return string
   *   The format for the email.
   */
  public function getFormat();

  /**
   * Sets the format for the email.
   *
   * @param string $format
   *   The format for the email.
   *
   * @return $this
   */
  public function setFormat(string $format);

  /**
   * Sets the mail entity queue plugin processor id.
   *
   * @param string $queue_processor
   *   The mail entity queue plugin processor id.
   *
   * @return $this
   */
  public function setQueueProcessorId(string $queue_processor);

  /**
   * Adds an item to the queue.
   *
   * @param string $mail
   *   The address the message will be sent to.
   * @param array $data
   *   Data array to compose the mail.
   * @param string $entity_type
   *   Type of the entity related to the item.
   * @param string $entity_id
   *   Id of the entity related to the item.
   *
   * @return \Drupal\mail_entity_queue\Entity\MailEntityQueueItemInterface
   *   The mail entity queue item added.
   */
  public function addItem(string $mail, array $data, $entity_type = NULL, $entity_id = NULL);

}
