<?php

namespace Drupal\mail_entity_queue\Event;

/**
 * Defines event names for mail entity queue item lifecycle.
 *
 * This final class provides constants used as event names for different
 * stages in the mail entity queue item processing flow. Each constant is
 * intended to be used with the event dispatcher to react to queue item
 * lifecycle changes.
 */
final class MailEntityQueueItemEvents {

  /**
   * Event fired after a mail queue item is processed successfully.
   *
   * Use this event to perform secondary actions when processing completes
   * without errors.
   *
   * @Event
   *
   * @see \Drupal\mail_entity_queue\Event\MailEntityQueueItemEvents
   */
  const MAIL_ENTITY_QUEUE_ITEM_PROCESSED_SUCCESSFULLY = 'mail_entity_queue.mail_entity_queue_item.processed_successfully';

  /**
   * Event fired after a mail queue item is processed with an error.
   *
   * Use this event to log errors or trigger retries when processing fails.
   *
   * @Event
   *
   * @see \Drupal\mail_entity_queue\Event\MailEntityQueueItemEvents
   */
  const MAIL_ENTITY_QUEUE_ITEM_PROCESSED_WRONGLY = 'mail_entity_queue.mail_entity_queue_item.processed_wrongly';

  /**
   * Event fired when a mail queue item is discarded after processing checks.
   *
   * Use this event to handle items that were intentionally discarded and
   * should not be retried.
   *
   * @Event
   *
   * @see \Drupal\mail_entity_queue\Event\MailEntityQueueItemEvents
   */
  const MAIL_ENTITY_QUEUE_ITEM_DISCARDED = 'mail_entity_queue.mail_entity_queue_item.discarded';

}
