<?php

namespace Drupal\mailchimp_honeypot\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Mailchimp Honeypot.
 */
class MailchimpHoneypotForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'mailchimp_honeypot_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['mailchimp_honeypot.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('mailchimp_honeypot.settings');
    $protect_all = $config->get('protect_all') ?? FALSE;

    $form['protect_all'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Honeypot protection for all Mailchimp forms'),
      '#default_value' => $protect_all,
      '#description' => $this->t('If enabled, Honeypot protection will be added to all Mailchimp signup forms. Uncheck to remove Honeypot protection.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('mailchimp_honeypot.settings')
      ->set('protect_all', $form_state->getValue('protect_all'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
