<?php

declare(strict_types=1);

namespace Drupal\Tests\mailchimp_signup_forms\Functional;

use Composer\InstalledVersions;
use Drupal\block\Entity\Block;
use Drupal\Core\Recipe\Recipe;
use Drupal\Core\Recipe\RecipeRunner;
use Drupal\FunctionalTests\Core\Recipe\RecipeTestTrait;
use Drupal\KernelTests\KernelTestBase;
use Drupal\mailchimp_signup\Entity\MailchimpSignup;

final class SignupFormsRecipeTest extends KernelTestBase {

  use RecipeTestTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'block',
    'mailchimp',
    'mailchimp_signup'
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $configFactory = $this->container->get('config.factory');
    $configFactory->getEditable('mailchimp.settings')->set('test_mode', TRUE)->save();
    $this->container->set('config.factory', $configFactory);
  }

  public function testListsAreGenerated() {
    // First, apply the recipe.
    $recipe_path = InstalledVersions::getInstallPath('drupal/mailchimp_signup_forms');
    $recipe = Recipe::createFromDirectory($recipe_path);
    RecipeRunner::processRecipe($recipe);

    // Change the config value to trigger the ECA model.
    $this->config('mailchimp.settings')
      ->set('api_timeout', 13)
      ->save();

    // Assert that the expected signup forms and blocks were generated.
    $signups = MailchimpSignup::loadMultiple();
    $this->assertArrayHasKey('signup_form_57afe96172', $signups);
    $this->assertArrayHasKey('signup_form_587693d673', $signups);
    $this->assertArrayHasKey('signup_form_f4b7b26b2e', $signups);

    $blocks = Block::loadMultiple();
    $this->assertArrayHasKey('mailchimp_signup_57afe96172', $blocks);
    $this->assertArrayHasKey('mailchimp_signup_587693d673', $blocks);
    $this->assertArrayHasKey('mailchimp_signup_f4b7b26b2e', $blocks);
  }

}
