/**
 * @file
 * Config - Global configuration settings
 */

(function() {
  'use strict';

  const Config = {
    // Map settings
    map: {
      defaultCenter: [41.9028, 12.4964],
      defaultZoom: 12,
      minZoom: 10,
      maxZoom: 18,
      tileLayer: 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
      attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
    },

    // Business information
    business: {
      name: "Your Business",
      location: [41.8349, 12.4700],
      address: "Business Street, 123 - 00100 Rome, Italy",
      phone: "+39 06 1234 5678",
      email: "info@yourbusiness.com",
      hours: {
        weekdays: "9:00 AM - 6:00 PM",
        saturday: "9:00 AM - 1:00 PM",
        sunday: "Closed"
      }
    },

    // Transportation points
    transportation: {
      tollBooth: {
        name: "Roma Nord Toll Booth",
        location: [42.0044, 12.5128],
        description: "Highway A1 - Exit 5"
      },
      trainStation: {
        name: "Roma Termini Station",
        location: [41.8518, 12.4940],
        description: "Main train station"
      },
      busTerminal: {
        name: "EUR Bus Terminal",
        location: [41.8330, 12.4740],
        description: "Local bus services"
      },
      metroStation: {
        name: "EUR Fermi Metro Station",
        location: [41.8335, 12.472],
        description: "Metro Line B"
      }
    },

    // Route settings
    routes: {
      car: {
        color: '#3498db',
        weight: 7,
        opacity: 0.95,
        dashArray: '10, 10'
      },
      publicTransport: {
        color: '#2ecc71',
        weight: 7,
        opacity: 0.95,
        dashArray: '12, 6'
      },
      user: {
        color: '#9b59b6',
        weight: 7,
        opacity: 0.95,
        dashArray: '8, 8'
      }
    },

    // Marker icons
    markers: {
      main: {
        className: 'marker-pulse',
        icon: 'building',
        color: 'white',
        size: [26, 26]
      },
      toll: {
        className: 'custom-marker marker-toll',
        icon: 'road',
        color: 'white',
        size: [28, 28]
      },
      train: {
        className: 'custom-marker marker-transport',
        icon: 'train',
        color: 'white',
        size: [28, 28]
      },
      bus: {
        className: 'custom-marker marker-transport',
        icon: 'bus',
        color: 'white',
        size: [28, 28]
      },
      subway: {
        className: 'custom-marker marker-transport',
        icon: 'subway',
        color: 'white',
        size: [28, 28]
      },
      user: {
        className: 'custom-marker marker-user',
        icon: 'user',
        color: 'white',
        size: [26, 26]
      }
    },

    // Animation settings
    animations: {
      flyToDuration: 1.2,
      easeLinearity: 0.25,
      markerDelay: 100
    },

    // Geolocation settings
    geolocation: {
      enableHighAccuracy: true,
      timeout: 10000,
      maximumAge: 0
    },

    // API endpoints
    apis: {
      osrm: 'https://router.project-osrm.org/route/v1'
    },

    // Debug settings
    debug: {
      enabled: false,
      logLevel: 'error' // 'error', 'warn', 'info', 'debug'
    }
  };

  // Export to global scope
  window.Config = Config;

})();