/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.7.2/LICENSE.txt
 */
var maplibregl=function(){"use strict";function t(t,e,r,n){return new(r||(r=Promise))((function(i,s){function o(t){try{l(n.next(t))}catch(t){s(t)}}function a(t){try{l(n.throw(t))}catch(t){s(t)}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(o,a)}l((n=n.apply(t,e||[])).next())}))}function e(t,e){this.x=t,this.y=e}function r(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var n,i;"function"==typeof SuppressedError&&SuppressedError,e.prototype={clone(){return new e(this.x,this.y)},add(t){return this.clone()._add(t)},sub(t){return this.clone()._sub(t)},multByPoint(t){return this.clone()._multByPoint(t)},divByPoint(t){return this.clone()._divByPoint(t)},mult(t){return this.clone()._mult(t)},div(t){return this.clone()._div(t)},rotate(t){return this.clone()._rotate(t)},rotateAround(t,e){return this.clone()._rotateAround(t,e)},matMult(t){return this.clone()._matMult(t)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(t){return this.x===t.x&&this.y===t.y},dist(t){return Math.sqrt(this.distSqr(t))},distSqr(t){const e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle(){return Math.atan2(this.y,this.x)},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith(t){return this.angleWithSep(t.x,t.y)},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add(t){return this.x+=t.x,this.y+=t.y,this},_sub(t){return this.x-=t.x,this.y-=t.y,this},_mult(t){return this.x*=t,this.y*=t,this},_div(t){return this.x/=t,this.y/=t,this},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this},_unit(){return this._div(this.mag()),this},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this},_rotate(t){const e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround(t,e){const r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:e},e.convert=function(t){if(t instanceof e)return t;if(Array.isArray(t))return new e(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new e(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format")};var s=function(){if(i)return n;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n}return i=1,n=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s}var o=0,a=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},n}(),o=r(s);let a,l;var u,c="undefined"!=typeof Float32Array?Float32Array:Array;function h(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*o,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*o,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*o,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*o,t}u=new c(4),c!=Float32Array&&(u[0]=0,u[1]=0,u[2]=0,u[3]=0);const p=8192;function f(t,e,r){return Math.min(r,Math.max(e,t))}function d(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function y(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function m(t){return Array.isArray(t)?t.map(m):"object"==typeof t&&t?y(t,m):t}new o(.25,.1,.25,1);const g={};function x(t){g[t]||("undefined"!=typeof console&&console.warn(t),g[t]=!0)}function v(t,e,r){return(r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function b(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}function w(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}let _,S;function k(t,e,r,n){return t.addEventListener(e,r,n),{unsubscribe:()=>{t.removeEventListener(e,r,n)}}}function A(t){return t*Math.PI/180}class I{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r))}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly}else{this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s)}query(t,e,r,n,i){const s=this.min,o=this.max;if(t<=s&&e<=s&&o<=r&&o<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,o,a){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===o[h]){const l=4*h;(a?a(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(o[h]=!0,s.push(i[h])):o[h]=!1}}}}_forEachCell(t,e,r,n,i,s,o,a){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,o,a))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new I(t.buffer)}}var M={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"array",value:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const z=["type","source","source-layer","minzoom","maxzoom","filter","layout"];class P{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__)}}function T(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class C extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class E{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r}concat(t){return new E(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const B={kind:"null"},V={kind:"number"},D={kind:"string"},F={kind:"boolean"},$={kind:"color"},L={kind:"projectionDefinition"},O={kind:"object"},R={kind:"value"},N={kind:"collator"},U={kind:"formatted"},j={kind:"padding"},q={kind:"colorArray"},G={kind:"numberArray"},X={kind:"resolvedImage"},Z={kind:"variableAnchorOffsetCollection"};function Y(t,e){return{kind:"array",itemType:t,N:e}}function H(t){if("array"===t.kind){const e=H(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const J=[B,V,D,F,$,L,U,O,Y(R),j,G,q,X,Z];function W(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!W(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of J)if(!W(t,e))return null}return`Expected ${H(t)} but found ${H(e)} instead.`}function K(t,e){return e.some((e=>e.kind===t.kind))}function Q(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function tt(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const et=.96422,rt=.82521,nt=4/29,it=6/29,st=3*it*it,ot=it*it*it,at=Math.PI/180,lt=180/Math.PI;function ut(t){return(t%=360)<0&&(t+=360),t}function ct([t,e,r,n]){let i,s;const o=pt((.2225045*(t=ht(t))+.7168786*(e=ht(e))+.0606169*(r=ht(r)))/1);t===e&&e===r?i=s=o:(i=pt((.4360747*t+.3850649*e+.1430804*r)/et),s=pt((.0139322*t+.0971045*e+.7141733*r)/rt));const a=116*o-16;return[a<0?0:a,500*(i-o),200*(o-s),n]}function ht(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function pt(t){return t>ot?Math.pow(t,1/3):t/st+nt}function ft([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,o=isNaN(r)?i:i-r/200;return i=1*yt(i),s=et*yt(s),o=rt*yt(o),[dt(3.1338561*s-1.6168667*i-.4906146*o),dt(-.9787684*s+1.9161415*i+.033454*o),dt(.0719453*s-.2289914*i+1.4052427*o),n]}function dt(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function yt(t){return t>it?t*t*t:st*(t-nt)}const mt=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function gt(t,e){return mt(t,e)?t[e]:void 0}function xt(t){return parseInt(t.padEnd(2,t),16)/255}function vt(t,e){return bt(e?t/100:t,0,1)}function bt(t,e,r){return Math.min(Math.max(e,t),r)}function wt(t){return!t.some(Number.isNaN)}const _t={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function St(t,e,r){return t+r*(e-t)}function kt(t,e,r){return t.map(((t,n)=>St(t,e[n],r)))}class At{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]))}static parse(t){if(t instanceof At)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=gt(_t,t);if(e){const[t,r,n]=e;return[t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return[xt(t.slice(r,r+=e)),xt(t.slice(r,r+=e)),xt(t.slice(r,r+=e)),xt(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,o,a,l,u,c,h,p]=e,f=[i||" ",a||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,o,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[bt(+r/e,0,1),bt(+s/e,0,1),bt(+l/e,0,1),h?vt(+h,p):1];if(wt(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,o,a,l,u]=r,c=[n||" ",s||" ",a].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,bt(+i,0,100),bt(+o,0,100),l?vt(+l,u):1];if(wt(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=ut(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new At(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=ct(t),s=Math.sqrt(r*r+n*n);return[Math.round(1e4*s)?ut(Math.atan2(n,r)*lt):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",ct(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return`rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}static interpolate(t,e,r,n="rgb"){switch(n){case"rgb":{const[n,i,s,o]=kt(t.rgb,e.rgb,r);return new At(n,i,s,o,!1)}case"hcl":{const[n,i,s,o]=t.hcl,[a,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(a))isNaN(n)?isNaN(a)?h=NaN:(h=a,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else{let t=a-n;a>n&&t>180?t-=360:a<n&&n-a>180&&(t+=360),h=n+r*t}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*at,ft([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:St(i,l,r),St(s,u,r),St(o,c,r)]);return new At(f,d,y,m,!1)}case"lab":{const[n,i,s,o]=ft(kt(t.lab,e.lab,r));return new At(n,i,s,o,!1)}}}}At.black=new At(0,0,0,1),At.white=new At(1,1,1,1),At.transparent=new At(0,0,0,0),At.red=new At(1,0,0,1);class It{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Mt=["bottom","center","top"];class zt{constructor(t,e,r,n,i,s){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s}}class Pt{constructor(t){this.sections=t}static fromString(t){return new Pt([new zt(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Pt?t:Pt.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Tt{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Tt)return t;if("number"==typeof t)return new Tt([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new Tt(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Tt(kt(t.values,e.values,r))}}class Ct{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ct)return t;if("number"==typeof t)return new Ct([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Ct(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Ct(kt(t.values,e.values,r))}}class Et{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Et)return t;if("string"==typeof t){const e=At.parse(t);if(!e)return;return new Et([e])}if(!Array.isArray(t))return;const e=[];for(const r of t){if("string"!=typeof r)return;const t=At.parse(r);if(!t)return;e.push(t)}return new Et(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r,n="rgb"){const i=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)i.push(At.interpolate(t.values[s],e.values[s],r,n));return new Et(i)}}class Bt extends Error{constructor(t){super(t),this.name="RuntimeError"}toJSON(){return this.message}}const Vt=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Dt{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Dt)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Vt.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Dt(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new Bt(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new Bt(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,o]=n[t+1],[a,l]=i[t+1];s.push([St(e,a,r),St(o,l,r)])}return new Dt(s)}}class Ft{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new Ft({name:t,available:!1}):null}}class $t{constructor(t,e,r){this.from=t,this.to=e,this.transition=r}static interpolate(t,e,r){return new $t(t,e,r)}static parse(t){return t instanceof $t?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new $t(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new $t(t.from,t.to,t.transition):"string"==typeof t?new $t(t,t,1):void 0}}function Lt(t,e,r,n){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Ot(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof $t||t instanceof At||t instanceof It||t instanceof Pt||t instanceof Tt||t instanceof Ct||t instanceof Et||t instanceof Dt||t instanceof Ft)return!0;if(Array.isArray(t)){for(const e of t)if(!Ot(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!Ot(t[e]))return!1;return!0}return!1}function Rt(t){if(null===t)return B;if("string"==typeof t)return D;if("boolean"==typeof t)return F;if("number"==typeof t)return V;if(t instanceof At)return $;if(t instanceof $t)return L;if(t instanceof It)return N;if(t instanceof Pt)return U;if(t instanceof Tt)return j;if(t instanceof Ct)return G;if(t instanceof Et)return q;if(t instanceof Dt)return Z;if(t instanceof Ft)return X;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Rt(e);if(r){if(r===t)continue;r=R;break}r=t}return Y(r||R,e)}return O}function Nt(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof At||t instanceof $t||t instanceof Pt||t instanceof Tt||t instanceof Ct||t instanceof Et||t instanceof Dt||t instanceof Ft?t.toString():JSON.stringify(t)}class Ut{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Ot(t[1]))return e.error("invalid value");const r=t[1];let n=Rt(r);const i=e.expectedType;return"array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Ut(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const jt={string:D,number:V,boolean:F,object:O};class qt{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in jt)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=jt[r],n++}else i=R;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++}r=Y(i,s)}else{if(!jt[i])throw new Error(`Types doesn't contain name = ${i}`);r=jt[i]}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,R);if(!r)return null;s.push(r)}return new qt(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!W(this.type,Rt(r)))return r;if(e===this.args.length-1)throw new Bt(`Expected value to be of type ${H(this.type)}, but found ${H(Rt(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Gt={"to-boolean":F,"to-color":$,"to-number":V,"to-string":D};class Xt{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Gt[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Gt[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,R);if(!n)return null;i.push(n)}return new Xt(n,i)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof At)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Lt(e[0],e[1],e[2],e[3]),!r))return new At(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Bt(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=Tt.parse(e);if(n)return n}throw new Bt(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"numberArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Ct.parse(e);if(n)return n}throw new Bt(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"colorArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Et.parse(e);if(n)return n}throw new Bt(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=Dt.parse(e);if(n)return n}throw new Bt(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Bt(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Pt.fromString(Nt(this.args[0].evaluate(t)));case"resolvedImage":return Ft.fromString(Nt(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Nt(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Zt=["Unknown","Point","LineString","Polygon"];class Yt{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Zt[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=At.parse(t),this._parseColorCache.set(t,e)),e}}class Ht{constructor(t,e,r=[],n,i=new E,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return"assert"===r?new qt(e,[t]):"coerce"===r?new Xt(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===t.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(i.kind))n=r(n,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"assert")}if(!(n instanceof Ut)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new Yt;try{n=new Ut(n.type,n.evaluate(t))}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Ht(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new C(r,t))}checkSubtype(t,e){const r=W(t,e);return r&&this.error(r),r}}class Jt{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s])}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Jt(r,n):null}outputDefined(){return this.result.outputDefined()}}class Wt{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Wt(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class Kt{constructor(t,e,r){this.type=t,this.index=e,this.input=r}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,V),n=e.parse(t[2],2,Y(e.expectedType||R));return r&&n?new Kt(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Bt(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Bt(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Bt(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class Qt{constructor(t,e){this.type=F,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,R),n=e.parse(t[2],2,R);return r&&n?K(r.type,[F,D,V,B,R])?new Qt(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${H(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return!1;if(!Q(e,["boolean","string","number","null"]))throw new Bt(`Expected first argument to be of type boolean, string, number or null, but found ${H(Rt(e))} instead.`);if(!Q(r,["string","array"]))throw new Bt(`Expected second argument to be of type array or string, but found ${H(Rt(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class te{constructor(t,e,r){this.type=V,this.needle=t,this.haystack=e,this.fromIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,R),n=e.parse(t[2],2,R);if(!r||!n)return null;if(!K(r.type,[F,D,V,B,R]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${H(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,V);return i?new te(r,n,i):null}return new te(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!Q(e,["boolean","string","number","null"]))throw new Bt(`Expected first argument to be of type boolean, string, number or null, but found ${H(Rt(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),Q(r,["string"])){const t=r.indexOf(e,n);return-1===t?-1:[...r.slice(0,t)].length}if(Q(r,["array"]))return r.indexOf(e,n);throw new Bt(`Expected second argument to be of type array or string, but found ${H(Rt(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class ee{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const u=e.concat(o);if(0===a.length)return u.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Rt(t)))return null}else r=Rt(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length}const c=e.parse(l,o,n);if(!c)return null;n=n||c.type,s.push(c)}const o=e.parse(t[1],1,R);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,n);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(r,o.type)?null:new ee(r,n,o,i,s,a):null}evaluate(t){const e=this.input.evaluate(t);return(Rt(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class re{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,F);if(!s)return null;const o=e.parse(t[i+1],i+1,r);if(!o)return null;n.push([s,o]),r=r||o.type}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new re(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class ne{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,R),n=e.parse(t[2],2,V);if(!r||!n)return null;if(!K(r.type,[Y(R),D,R]))return e.error(`Expected first argument to be of type array or string, but found ${H(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,V);return i?new ne(r.type,r,n,i):null}return new ne(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),Q(e,["string"]))return[...e].slice(r,n).join("");if(Q(e,["array"]))return e.slice(r,n);throw new Bt(`Expected first argument to be of type array or string, but found ${H(Rt(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function ie(t,e){const r=t.length-1;let n,i,s=0,o=r,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),n=t[a],i=t[a+1],n<=e){if(a===r||e<i)return a;s=a+1}else{if(!(n>e))throw new Bt("Input is not a number.");o=a-1}return 0}class se{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,V);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],o=t[r+1],a=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const u=e.parse(o,l,i);if(!u)return null;i=i||u.type,n.push([s,u])}return new se(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[ie(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function oe(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var ae,le,ue=function(){if(le)return ae;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n}return le=1,ae=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s}var o=0,a=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},ae}(),ce=oe(ue);class he{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=pe(e,t.base,r,n);else if("linear"===t.name)i=pe(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new ce(s[0],s[1],s[2],s[3]).solve(pe(e,1,r,n))}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t}}else{if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,V),!i)return null;const o=[];let a=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||e.expectedType==q?e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType):a=$;for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(o.length&&o[o.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,a);if(!u)return null;a=a||u.type,o.push([r,u])}return tt(a,V)||tt(a,L)||tt(a,$)||tt(a,j)||tt(a,G)||tt(a,q)||tt(a,Z)||tt(a,Y(V))?new he(a,r,n,i,o):e.error(`Type ${H(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=ie(e,n),o=he.interpolationFactor(this.interpolation,n,e[s],e[s+1]),a=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return St(a,l,o);case"color":return At.interpolate(a,l,o);case"padding":return Tt.interpolate(a,l,o);case"colorArray":return Et.interpolate(a,l,o);case"numberArray":return Ct.interpolate(a,l,o);case"variableAnchorOffsetCollection":return Dt.interpolate(a,l,o);case"array":return kt(a,l,o);case"projectionDefinition":return $t.interpolate(a,l,o)}case"interpolate-hcl":switch(this.type.kind){case"color":return At.interpolate(a,l,o,"hcl");case"colorArray":return Et.interpolate(a,l,o,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return At.interpolate(a,l,o,"lab");case"colorArray":return Et.interpolate(a,l,o,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function pe(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}const fe={color:At.interpolate,number:St,padding:Tt.interpolate,numberArray:Ct.interpolate,colorArray:Et.interpolate,variableAnchorOffsetCollection:Dt.interpolate,array:kt};class de{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t)}if(!r)throw new Error("No output type");const s=n&&i.some((t=>W(n,t.type)));return new de(s?R:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof Ft&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function ye(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function me(t,e,r,n){return 0===n.compare(e,r)}function ge(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=F,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,R);if(!s)return null;if(!ye(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${H(s.type)}'.`);let o=e.parse(t[2],2,R);if(!o)return null;if(!ye(r,o.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${H(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${H(s.type)}' and '${H(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new qt(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new qt(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,N),!a)return null}return new i(s,o,a)}evaluate(i){const s=this.lhs.evaluate(i),o=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Rt(s),r=Rt(o);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Bt(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Rt(s),r=Rt(o);if("string"!==t.kind||"string"!==r.kind)return e(i,s,o)}return this.collator?r(i,s,o,this.collator.evaluate(i)):e(i,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const xe=ge("==",(function(t,e,r){return e===r}),me),ve=ge("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return!me(0,e,r,n)})),be=ge("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),we=ge(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),_e=ge("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Se=ge(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class ke{constructor(t,e,r){this.type=N,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,F);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,F);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,D),!s)?null:new ke(n,i,s)}evaluate(t){return new It(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class Ae{constructor(t,e,r,n,i){this.type=D,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,V);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,D),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,D),!s))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parse(n["min-fraction-digits"],1,V),!o))return null;let a=null;return n["max-fraction-digits"]&&(a=e.parse(n["max-fraction-digits"],1,V),!a)?null:new Ae(r,i,s,o,a)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class Ie{constructor(t){this.type=U,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,V),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Y(D)),!r))return null;let o=null;if(s["text-color"]&&(o=e.parse(s["text-color"],1,$),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Mt.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=e.parse(s["vertical-align"],1,D),!a)return null}const l=n[n.length-1];l.scale=t,l.font=r,l.textColor=o,l.verticalAlign=a}else{const s=e.parse(t[r],1,R);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new Ie(n)}evaluate(t){return new Pt(this.sections.map((e=>{const r=e.content.evaluate(t);return Rt(r)===X?new zt("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new zt(Nt(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class Me{constructor(t){this.type=X,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,D);return r?new Me(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Ft.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input)}outputDefined(){return!1}}class ze{constructor(t){this.type=V,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${H(r.type)} instead.`):new ze(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Bt(`Expected value to be of type string or array, but found ${H(Rt(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Pe=8192;function Te(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return[Math.round(r*i*Pe),Math.round(n*i*Pe)]}function Ce(t,e){const r=Math.pow(2,e.z);return[(i=(t[0]/Pe+e.x)/r,360*i-180),(n=(t[1]/Pe+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i}function Ee(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function Be(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Ve(t,e,r){return e[1]>t[1]!=r[1]>t[1]&&t[0]<(r[0]-e[0])*(t[1]-e[1])/(r[1]-e[1])+e[0]}function De(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],o=t[1]-r[1];return n*o-s*i==0&&n*s<=0&&i*o<=0}function Fe(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!Ue(t,e,r,n)||!Ue(r,n,t,e));var i,s}function $e(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Fe(t,e,n[r],n[r+1]))return!0;return!1}function Le(t,e,r=!1){let n=!1;for(const i of e)for(let e=0;e<i.length-1;e++){if(De(t,i[e],i[e+1]))return r;Ve(t,i[e],i[e+1])&&(n=!n)}return n}function Oe(t,e){for(const r of e)if(Le(t,r))return!0;return!1}function Re(t,e){for(const r of t)if(!Le(r,e))return!1;for(let r=0;r<t.length-1;++r)if($e(t[r],t[r+1],e))return!1;return!0}function Ne(t,e){for(const r of e)if(Re(t,r))return!0;return!1}function Ue(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],o=(t[0]-r[0])*s-i*(t[1]-r[1]),a=(e[0]-r[0])*s-i*(e[1]-r[1]);return o>0&&a<0||o<0&&a>0}function je(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const o=Te(t[i][n],r);Ee(e,o),s.push(o)}n.push(s)}return n}function qe(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=je(t[i],e,r);n.push(s)}return n}function Ge(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i}Ee(e,t)}function Xe(t,e,r,n){const i=Math.pow(2,n.z)*Pe,s=[n.x*Pe,n.y*Pe],o=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Ge(n,e,r,i),o.push(n)}return o}function Ze(t,e,r,n){const i=Math.pow(2,n.z)*Pe,s=[n.x*Pe,n.y*Pe],o=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Ee(e,r),t.push(r)}o.push(t)}if(e[2]-e[0]<=i/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const n of t)Ge(n,e,r,i)}var a;return o}class Ye{constructor(t,e){this.type=F,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ot(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n)}if(t.length)return new Ye(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Ye(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Ye(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=je(e.coordinates,n,i),o=Xe(t.geometry(),r,n,i);if(!Be(r,n))return!1;for(const t of o)if(!Le(t,s))return!1}if("MultiPolygon"===e.type){const s=qe(e.coordinates,n,i),o=Xe(t.geometry(),r,n,i);if(!Be(r,n))return!1;for(const t of o)if(!Oe(t,s))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=je(e.coordinates,n,i),o=Ze(t.geometry(),r,n,i);if(!Be(r,n))return!1;for(const t of o)if(!Re(t,s))return!1}if("MultiPolygon"===e.type){const s=qe(e.coordinates,n,i),o=Ze(t.geometry(),r,n,i);if(!Be(r,n))return!1;for(const t of o)if(!Ne(t,s))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}let He=class{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i}e[t]=n}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n}e[t]=i}};function Je(t,e,r=0,n=t.length-1,i=Ke){for(;n>r;){if(n-r>600){const s=n-r+1,o=e-r+1,a=Math.log(s),l=.5*Math.exp(2*a/3),u=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);Je(t,e,Math.max(r,Math.floor(e-o*l/s+u)),Math.min(n,Math.floor(e+(s-o)*l/s+u)),i)}const s=t[e];let o=r,a=n;for(We(t,r,e),i(t[n],s)>0&&We(t,r,n);o<a;){for(We(t,o,a),o++,a--;i(t[o],s)<0;)o++;for(;i(t[a],s)>0;)a--}0===i(t[r],s)?We(t,r,a):(a++,We(t,a,n)),a<=e&&(r=a+1),e<=a&&(n=a-1)}}function We(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}function Ke(t,e){return t<e?-1:t>e?1:0}function Qe(t,e){if(t.length<=1)return[t];const r=[];let n,i;for(const e of t){const t=er(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e))}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Je(r[t],e,1,r[t].length-1,tr),r[t]=r[t].slice(0,e));return r}function tr(t,e){return e.area-t.area}function er(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}const rr=1/298.257223563,nr=rr*(2-rr),ir=Math.PI/180;class sr{constructor(t){const e=6378.137*ir*1e3,r=Math.cos(t*ir),n=1/(1-nr*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-nr)}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,i,s,o=1/0;for(let a=0;a<t.length-1;a++){let l=t[a][0],u=t[a][1],c=this.wrap(t[a+1][0]-l)*this.kx,h=(t[a+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[a+1][0],u=t[a+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<o&&(o=f,r=l,n=u,i=a,s=p)}return{point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function or(t,e){return e[0]-t[0]}function ar(t){return t[1]-t[0]+1}function lr(t,e){return t[1]>=t[0]&&t[1]<e}function ur(t,e){if(t[0]>t[1])return[null,null];const r=ar(t);if(e){if(2===r)return[t,null];const e=Math.floor(r/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return[t,null];const n=Math.floor(r/2)-1;return[[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function cr(t,e){if(!lr(e,t.length))return[1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)Ee(r,t[n]);return r}function hr(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)Ee(e,t);return e}function pr(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function fr(t,e,r){if(!pr(t)||!pr(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function dr(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function yr(t,e,r,n,i){const s=Math.min(dr(t,[r,n],i),dr(e,[r,n],i)),o=Math.min(dr(r,[t,e],i),dr(n,[t,e],i));return Math.min(s,o)}function mr(t,e,r,n,i){if(!lr(e,t.length)||!lr(n,r.length))return 1/0;let s=1/0;for(let o=e[0];o<e[1];++o){const e=t[o],a=t[o+1];for(let t=n[0];t<n[1];++t){const n=r[t],o=r[t+1];if(Fe(e,a,n,o))return 0;s=Math.min(s,yr(e,a,n,o,i))}}return s}function gr(t,e,r,n,i){if(!lr(e,t.length)||!lr(n,r.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[o],r[e])),0===s)return s;return s}function xr(t,e,r){if(Le(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,dr(t,[s,e],r)),0===n))return n;const o=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,o.point)),0===n)return n}return n}function vr(t,e,r,n){if(!lr(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Le(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],o=t[s+1];for(const t of r)for(let r=0,s=t.length,a=s-1;r<s;a=r++){const s=t[a],l=t[r];if(Fe(e,o,s,l))return 0;i=Math.min(i,yr(e,o,s,l,n))}}return i}function br(t,e){for(const r of t)for(const t of r)if(Le(t,e,!0))return!0;return!1}function wr(t,e,r,n=1/0){const i=hr(t),s=hr(e);if(n!==1/0&&fr(i,s,r)>=n)return n;if(Be(i,s)){if(br(t,e))return 0}else if(br(e,t))return 0;let o=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],a=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if(Fe(i,a,n,l))return 0;o=Math.min(o,yr(i,a,n,l,r))}}return o}function _r(t,e,r,n,i,s){if(!s)return;const o=fr(cr(n,s),i,r);o<e&&t.push([o,s,[0,0]])}function Sr(t,e,r,n,i,s,o){if(!s||!o)return;const a=fr(cr(n,s),cr(i,o),r);a<e&&t.push([a,s,o])}function kr(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const o=new He([[0,[0,t.length-1],[0,0]]],or),a=hr(r);for(;o.length>0;){const i=o.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(ar(l)<=u){if(!lr(l,t.length))return NaN;if(e){const e=vr(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e)}else for(let e=l[0];e<=l[1];++e){const i=xr(t[e],r,n);if(s=Math.min(s,i),0===s)return 0}}else{const r=ur(l,e);_r(o,s,n,t,a,r[0]),_r(o,s,n,t,a,r[1])}}return s}function Ar(t,e,r,n,i,s=1/0){let o=Math.min(s,i.distance(t[0],r[0]));if(0===o)return o;const a=new He([[0,[0,t.length-1],[0,r.length-1]]],or);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(ar(l)<=c&&ar(u)<=h){if(!lr(l,t.length)&&lr(u,r.length))return NaN;let s;if(e&&n)s=mr(t,l,r,u,i),o=Math.min(o,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=dr(r[t],e,i),o=Math.min(o,s),0===o)return o}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=dr(t[r],e,i),o=Math.min(o,s),0===o)return o}else s=gr(t,l,r,u,i),o=Math.min(o,s)}else{const s=ur(l,e),c=ur(u,n);Sr(a,o,i,t,r,s[0],c[0]),Sr(a,o,i,t,r,s[0],c[1]),Sr(a,o,i,t,r,s[1],c[0]),Sr(a,o,i,t,r,s[1],c[1])}}return o}function Ir(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Mr{constructor(t,e){this.type=V,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ot(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Mr(e,e.features.map((t=>Ir(t.geometry))).flat());if("Feature"===e.type)return new Mr(e,Ir(e.geometry));if("type"in e&&"coordinates"in e)return new Mr(e,Ir(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Ce([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new sr(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Ar(n,!1,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Ar(n,!1,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,kr(n,!1,t.coordinates,i,s))}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Ce([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new sr(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Ar(n,!0,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Ar(n,!0,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,kr(n,!0,t.coordinates,i,s))}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=Qe(r,0).map((e=>e.map((e=>e.map((e=>Ce([e.x,e.y],t.canonical))))))),i=new sr(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case"Point":s=Math.min(s,kr([t.coordinates],!1,e,i,s));break;case"LineString":s=Math.min(s,kr(t.coordinates,!0,e,i,s));break;case"Polygon":s=Math.min(s,wr(e,t.coordinates,i,s))}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class zr{constructor(t){this.type=R,this.key=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=t[1];return null==r?e.error("Global state property must be defined."):"string"!=typeof r?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new zr(r)}evaluate(t){var e;const r=null===(e=t.globals)||void 0===e?void 0:e.globalState;return r&&0!==Object.keys(r).length?gt(r,this.key):null}eachChild(){}outputDefined(){return!1}}const Pr={"==":xe,"!=":ve,">":we,"<":be,">=":Se,"<=":_e,array:qt,at:Kt,boolean:qt,case:re,coalesce:de,collator:ke,format:Ie,image:Me,in:Qt,"index-of":te,interpolate:he,"interpolate-hcl":he,"interpolate-lab":he,length:ze,let:Jt,literal:Ut,match:ee,number:qt,"number-format":Ae,object:qt,slice:ne,step:se,string:qt,"to-boolean":Xt,"to-color":Xt,"to-number":Xt,"to-string":Xt,var:Wt,within:Ye,distance:Mr,"global-state":zr};class Tr{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const r=t[0],n=Tr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,o=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let a=null;for(const[n,s]of o){a=new Ht(e.registry,Dr,e.path,null,e.scope);const o=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=a.parse(r,1+o.length,i);if(!s){l=!0;break}o.push(s)}if(!l)if(Array.isArray(n)&&n.length!==o.length)a.error(`Expected ${n.length} arguments, but found ${o.length} instead.`);else{for(let t=0;t<o.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=o[t];a.concat(t+1).checkSubtype(e,r.type)}if(0===a.errors.length)return new Tr(r,i,s,o)}}if(1===o.length)e.errors.push(...a.errors);else{const r=(o.length?o:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(H).join(", ")})`:`(${H(e.type)}...)`;var e})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(H(i.type))}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`)}return null}static register(t,e){Tr.definitions=e;for(const r in e)t[r]=Tr}}function Cr(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,o=Lt(e,r,n,s);if(o)throw new Bt(o);return new At(e/255,r/255,n/255,s,!1)}function Er(t,e){return t in e}function Br(t,e){const r=e[t];return void 0===r?null:r}function Vr(t){return{type:t}}function Dr(t){if(t instanceof Wt)return Dr(t.boundExpression);if(t instanceof Tr&&"error"===t.name)return!1;if(t instanceof ke)return!1;if(t instanceof Ye)return!1;if(t instanceof Mr)return!1;if(t instanceof zr)return!1;const e=t instanceof Xt||t instanceof qt;let r=!0;return t.eachChild((t=>{r=e?r&&Dr(t):r&&t instanceof Ut})),!!r&&Fr(t)&&Lr(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function Fr(t){if(t instanceof Tr){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof Ye)return!1;if(t instanceof Mr)return!1;let e=!0;return t.eachChild((t=>{e&&!Fr(t)&&(e=!1)})),e}function $r(t){if(t instanceof Tr&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!$r(t)&&(e=!1)})),e}function Lr(t,e){if(t instanceof Tr&&e.indexOf(t.name)>=0)return!1;let r=!0;return t.eachChild((t=>{r&&!Lr(t,e)&&(r=!1)})),r}function Or(t){return{result:"success",value:t}}function Rr(t){return{result:"error",value:t}}function Nr(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Ur(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function jr(t){return!!t.expression&&t.expression.interpolated}function qr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Gr(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)&&Rt(t)===O}function Xr(t){return t}function Zr(t,e){const r=t.stops&&"object"==typeof t.stops[0][0],n=r||!(r||void 0!==t.property),i=t.type||(jr(e)?"exponential":"interval"),s=function(t){switch(t.type){case"color":return At.parse;case"padding":return Tt.parse;case"numberArray":return Ct.parse;case"colorArray":return Et.parse;default:return null}}(e);if(s&&((t=T({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],s(t[1])]))),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(o=t.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${t.colorSpace}"`);var o;const a=function(t){switch(t){case"exponential":return Wr;case"interval":return Jr;case"categorical":return Hr;case"identity":return Kr;default:throw new Error(`Unknown function type "${t}"`)}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0]}if(r){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]])}const i=[];for(const t of n)i.push([r[t].zoom,Zr(r[t],e)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:he.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Wr({stops:i,base:t.base},e,r).evaluate(r,n)}}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:r,interpolationFactor:he.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,l,u)}}return{kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Yr(t.default,e.default):a(t,e,i,l,u)}}}function Yr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Hr(t,e,r,n,i){return Yr(typeof r===i?n[r]:void 0,t.default,e.default)}function Jr(t,e,r){if("number"!==qr(r))return Yr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=ie(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Wr(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==qr(r))return Yr(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=ie(t.stops.map((t=>t[0])),r),o=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1],u=fe[e.type]||Xr;return"function"==typeof a.evaluate?{evaluate(...e){const r=a.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,o,t.colorSpace)}}:u(a,l,o,t.colorSpace)}function Kr(t,e,r){switch(e.type){case"color":r=At.parse(r);break;case"formatted":r=Pt.fromString(r.toString());break;case"resolvedImage":r=Ft.fromString(r.toString());break;case"padding":r=Tt.parse(r);break;case"colorArray":r=Et.parse(r);break;case"numberArray":r=Ct.parse(r);break;default:qr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0)}return Yr(r,t.default,e.default)}Tr.register(Pr,{error:[{kind:"error"},[D],(t,[e])=>{throw new Bt(e.evaluate(t))}],typeof:[D,[R],(t,[e])=>H(Rt(e.evaluate(t)))],"to-rgba":[Y(V,4),[$],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return[255*r,255*n,255*i,s]}],rgb:[$,[V,V,V],Cr],rgba:[$,[V,V,V,V],Cr],has:{type:F,overloads:[[[D],(t,[e])=>Er(e.evaluate(t),t.properties())],[[D,O],(t,[e,r])=>Er(e.evaluate(t),r.evaluate(t))]]},get:{type:R,overloads:[[[D],(t,[e])=>Br(e.evaluate(t),t.properties())],[[D,O],(t,[e,r])=>Br(e.evaluate(t),r.evaluate(t))]]},"feature-state":[R,[D],(t,[e])=>Br(e.evaluate(t),t.featureState||{})],properties:[O,[],t=>t.properties()],"geometry-type":[D,[],t=>t.geometryType()],id:[R,[],t=>t.id()],zoom:[V,[],t=>t.globals.zoom],"heatmap-density":[V,[],t=>t.globals.heatmapDensity||0],elevation:[V,[],t=>t.globals.elevation||0],"line-progress":[V,[],t=>t.globals.lineProgress||0],accumulated:[R,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[V,Vr(V),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[V,Vr(V),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:V,overloads:[[[V,V],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[V],(t,[e])=>-e.evaluate(t)]]},"/":[V,[V,V],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[V,[V,V],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[V,[],()=>Math.LN2],pi:[V,[],()=>Math.PI],e:[V,[],()=>Math.E],"^":[V,[V,V],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[V,[V],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[V,[V],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[V,[V],(t,[e])=>Math.log(e.evaluate(t))],log2:[V,[V],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[V,[V],(t,[e])=>Math.sin(e.evaluate(t))],cos:[V,[V],(t,[e])=>Math.cos(e.evaluate(t))],tan:[V,[V],(t,[e])=>Math.tan(e.evaluate(t))],asin:[V,[V],(t,[e])=>Math.asin(e.evaluate(t))],acos:[V,[V],(t,[e])=>Math.acos(e.evaluate(t))],atan:[V,[V],(t,[e])=>Math.atan(e.evaluate(t))],min:[V,Vr(V),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[V,Vr(V),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[V,[V],(t,[e])=>Math.abs(e.evaluate(t))],round:[V,[V],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[V,[V],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[V,[V],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[F,[D,R],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[F,[R],(t,[e])=>t.id()===e.value],"filter-type-==":[F,[D],(t,[e])=>t.geometryType()===e.value],"filter-<":[F,[D,R],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[F,[R],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[F,[D,R],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[F,[R],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[F,[D,R],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[F,[R],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[F,[D,R],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[F,[R],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[F,[R],(t,[e])=>e.value in t.properties()],"filter-has-id":[F,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[F,[Y(D)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[F,[Y(R)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[F,[D,Y(R)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[F,[D,Y(R)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return!0;e[i]>t?n=i-1:r=i+1}return!1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:F,overloads:[[[F,F],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Vr(F),(t,e)=>{for(const r of e)if(!r.evaluate(t))return!1;return!0}]]},any:{type:F,overloads:[[[F,F],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Vr(F),(t,e)=>{for(const r of e)if(r.evaluate(t))return!0;return!1}]]},"!":[F,[F],(t,[e])=>!e.evaluate(t)],"is-supported-script":[F,[D],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return!r||r(e.evaluate(t))}],upcase:[D,[D],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[D,[D],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[D,Vr(R),(t,e)=>e.map((e=>Nt(e.evaluate(t)))).join("")],"resolved-locale":[D,[N],(t,[e])=>e.evaluate(t).resolvedLocale()]});class Qr{constructor(t,e,r){this.expression=t,this._warningHistory={},this._evaluator=new Yt,this._defaultValue=e?function(t){if("color"===t.type&&Gr(t.default))return new At(0,0,0,0);switch(t.type){case"color":return At.parse(t.default)||null;case"padding":return Tt.parse(t.default)||null;case"numberArray":return Ct.parse(t.default)||null;case"colorArray":return Et.parse(t.default)||null;case"variableAnchorOffsetCollection":return Dt.parse(t.default)||null;case"projectionDefinition":return $t.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this._globalState=r}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._globalState&&(t={...t,globalState:this._globalState}),this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Bt(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function tn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Pr}function en(t,e,r){const n=new Ht(Pr,Dr,[],e?function(t){const e={color:$,string:D,number:V,enum:D,boolean:F,formatted:U,padding:j,numberArray:G,colorArray:q,projectionDefinition:L,resolvedImage:X,variableAnchorOffsetCollection:Z};return"array"===t.type?Y(e[t.value]||R,t.length):e[t.type]}(e):void 0),i=n.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return i?Or(new Qr(i,e,r)):Rr(n.errors)}class rn{constructor(t,e,r){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!$r(e.expression),this.globalStateRefs=ln(e.expression),this._globalState=r}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluate(t,e,r,n,i,s)}}class nn{constructor(t,e,r,n,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!$r(e.expression),this.globalStateRefs=ln(e.expression),this.interpolationType=n,this._globalState=i}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?he.interpolationFactor(this.interpolationType,t,e,r):0}}function sn(t,e,r){const n=en(t,e,r);if("error"===n.result)return n;const i=n.value.expression,s=Fr(i);if(!s&&!Nr(e))return Rr([new C("","data expressions not supported")]);const o=Lr(i,["zoom"]);if(!o&&!Ur(e))return Rr([new C("","zoom expressions not supported")]);const a=an(i);return a||o?a instanceof C?Rr([a]):a instanceof he&&!jr(e)?Rr([new C("",'"interpolate" expressions cannot be used with this property')]):Or(a?new nn(s?"camera":"composite",n.value,a.labels,a instanceof he?a.interpolation:void 0,r):new rn(s?"constant":"source",n.value,r)):Rr([new C("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class on{constructor(t,e){this._parameters=t,this._specification=e,T(this,Zr(this._parameters,this._specification))}static deserialize(t){return new on(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function an(t){let e=null;if(t instanceof Jt)e=an(t.result);else if(t instanceof de){for(const r of t.args)if(e=an(r),e)break}else(t instanceof se||t instanceof he)&&t.input instanceof Tr&&"zoom"===t.input.name&&(e=t);return e instanceof C||t.eachChild((t=>{const r=an(t);r instanceof C?e=r:!e&&r?e=new C("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new C("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function ln(t,e=new Set){return t instanceof zr&&e.add(t.key),t.eachChild((t=>{ln(t,e)})),e}function un(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!un(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const cn={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function hn(t,e){if(null==t)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};un(t)||(t=dn(t));const r=en(t,cn,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,e,n)=>r.value.evaluate(t,e,{},n),needGeometry:fn(t),getGlobalStateRefs:()=>ln(r.value.expression)}}function pn(t,e){return t<e?-1:t>e?1:0}function fn(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(fn(t[e]))return!0;return!1}function dn(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?yn(t[1],t[2],"=="):"!="===e?xn(yn(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?yn(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(dn))):"all"===e?["all"].concat(t.slice(1).map(dn)):"none"===e?["all"].concat(t.slice(1).map(dn).map(xn)):"in"===e?mn(t[1],t.slice(2)):"!in"===e?xn(mn(t[1],t.slice(2))):"has"===e?gn(t[1]):"!has"!==e||xn(gn(t[1]));var r}function yn(t,e,r){switch(t){case"$type":return[`filter-type-${r}`,e];case"$id":return[`filter-id-${r}`,e];default:return[`filter-${r}`,t,e]}}function mn(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(pn)]]:["filter-in-small",t,["literal",e]]}}function gn(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function xn(t){return["!",t]}function vn(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${vn(r)},`;return`${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${vn(t[r[e]])},`;return`${n}}`}function bn(t){let e="";for(const r of z)e+=`/${vn(t[r])}`;return e}function wn(t){const e=t.value;return e?[new P(t.key,e,"constants have been deprecated as of v8")]:[]}function _n(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Sn(t){if(Array.isArray(t))return t.map(Sn);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Sn(t[r]);return e}return _n(t)}function kn(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,o=t.styleSpec,a=t.validateSpec;let l=[];const u=qr(r);if("object"!==u)return[new P(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=gt(n,u)||n["*"];let h;if(gt(i,u))h=i[u];else if(gt(n,u))h=a;else if(i["*"])h=i["*"];else{if(!n["*"]){l.push(new P(e,r[t],`unknown property "${t}"`));continue}h=a}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:o,object:r,objectKey:t,validateSpec:a},r))}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new P(e,r,`missing required property "${t}"`));return l}function An(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,o=t.arrayElementValidator||t.validateSpec;if("array"!==qr(e))return[new P(s,e,`array expected, ${qr(e)} found`)];if(r.length&&e.length!==r.length)return[new P(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return[new P(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let a={type:r.value,values:r.values};i.$version<7&&(a.function=r.function),"object"===qr(r.value)&&(a=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(o({array:e,arrayIndex:r,value:e[r],valueSpec:a,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function In(t){const e=t.key,r=t.value,n=t.valueSpec;let i=qr(r);return"number"===i&&r!=r&&(i="NaN"),"number"!==i?[new P(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new P(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new P(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function Mn(t){const e=t.valueSpec,r=_n(t.value.type);let n,i,s,o={};const a="categorical"!==r&&void 0===t.value.property,l=!a,u="array"===qr(t.value.stops)&&"array"===qr(t.value.stops[0])&&"object"===qr(t.value.stops[0][0]),c=kn({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return[new P(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(An({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===qr(n)&&0===n.length&&e.push(new P(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===r&&a&&c.push(new P(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new P(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!jr(t.valueSpec)&&c.push(new P(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Nr(t.valueSpec)?c.push(new P(t.key,t.value,"property functions not supported")):a&&!Ur(t.valueSpec)&&c.push(new P(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new P(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,a=t.key;if("array"!==qr(n))return[new P(a,n,`array expected, ${qr(n)} found`)];if(2!==n.length)return[new P(a,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==qr(n[0]))return[new P(a,n,`object expected, ${qr(n[0])} found`)];if(void 0===n[0].zoom)return[new P(a,n,"object stop key must have zoom")];if(void 0===n[0].value)return[new P(a,n,"object stop key must have value")];if(s&&s>_n(n[0].zoom))return[new P(a,n[0].zoom,"stop zoom values must appear in ascending order")];_n(n[0].zoom)!==s&&(s=_n(n[0].zoom),i=void 0,o={}),r=r.concat(kn({key:`${a}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:In,value:p}}))}else r=r.concat(p({key:`${a}[0]`,value:n[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return tn(Sn(n[1]))?r.concat([new P(`${a}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${a}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const a=qr(t.value),l=_n(t.value),u=null!==t.value?t.value:s;if(n){if(a!==n)return[new P(t.key,u,`${a} stop domain type must match previous stop domain type ${n}`)]}else n=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return[new P(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==r){let n=`number expected, ${a} found`;return Nr(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new P(t.key,u,n)]}return"categorical"!==r||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===a&&void 0!==i&&l<i?[new P(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in o?[new P(t.key,u,"stop domain values must be unique")]:(o[l]=!0,[])):[new P(t.key,u,`integer expected, found ${l}`)]}}function zn(t){const e=("property"===t.expressionContext?sn:en)(Sn(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new P(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return[new P(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!$r(r))return[new P(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!$r(r))return[new P(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Lr(r,["zoom","feature-state"]))return[new P(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Fr(r))return[new P(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Pn(t){const e=t.key,r=t.value,n=qr(r);return"string"!==n?[new P(e,r,`color expected, ${n} found`)]:At.parse(String(r))?[]:[new P(e,r,`color expected, "${r}" found`)]}function Tn(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(_n(r))&&i.push(new P(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(_n(r))&&i.push(new P(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function Cn(t){return un(Sn(t.value))?zn(T({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):En(t)}function En(t){const e=t.value,r=t.key;if("array"!==qr(e))return[new P(r,e,`array expected, ${qr(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return[new P(r,e,"filter array must have at least 1 element")];switch(s=s.concat(Tn({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),_n(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===_n(e[1])&&s.push(new P(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new P(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=qr(e[1]),"string"!==i&&s.push(new P(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let o=2;o<e.length;o++)i=qr(e[o]),"$type"===_n(e[1])?s=s.concat(Tn({key:`${r}[${o}]`,value:e[o],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new P(`${r}[${o}]`,e[o],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(En({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=qr(e[1]),2!==e.length?s.push(new P(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new P(`${r}[1]`,e[1],`string expected, ${i} found`))}return s}function Bn(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,o=t.value,a=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return[];const u=a.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:o,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[a];if(!c)return[new P(r,o,`unknown property "${a}"`)];let h;if("string"===qr(o)&&Nr(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(o)))return[new P(r,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&("text-field"===a&&i&&!i.glyphs&&p.push(new P(r,o,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Gr(Sn(o))&&"identity"===_n(o.type)&&p.push(new P(r,o,'"text-font" does not support identity functions'))),p.concat(n({key:t.key,value:o,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:a}))}function Vn(t){return Bn(t,"paint")}function Dn(t){return Bn(t,"layout")}function Fn(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;if("object"!==qr(r))return[new P(n,r,`object expected, ${qr(r)} found`)];r.type||r.ref||e.push(new P(n,r,'either "type" or "ref" is required'));let o=_n(r.type);const a=_n(r.ref);if(r.id){const s=_n(r.id);for(let o=0;o<t.arrayIndex;o++){const t=i.layers[o];_n(t.id)===s&&e.push(new P(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`))}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new P(n,r[t],`"${t}" is prohibited for ref layers`))})),i.layers.forEach((e=>{_n(e.id)===a&&(t=e)})),t?t.ref?e.push(new P(n,r.ref,"ref cannot reference another ref layer")):o=_n(t.type):e.push(new P(n,r.ref,`ref layer "${a}" not found`))}else if("background"!==o)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&_n(t.type);t?"vector"===s&&"raster"===o?e.push(new P(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o||"raster-dem"!==s&&"color-relief"===o?e.push(new P(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?e.push(new P(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==o&&"color-relief"!==o?e.push(new P(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==o||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new P(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new P(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new P(n,r.source,`source "${r.source}" not found`))}else e.push(new P(n,r,'missing required property "source"'));return e=e.concat(kn({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:Cn,layout:t=>kn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Dn(T({layerType:o},t))}}),paint:t=>kn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Vn(T({layerType:o},t))}})}})),e}function $n(t){const e=t.value,r=t.key,n=qr(e);return"string"!==n?[new P(r,e,`string expected, ${n} found`)]:[]}const Ln={promoteId:function({key:t,value:e}){if("string"===qr(e))return $n({key:t,value:e});{const r=[];for(const n in e)r.push(...$n({key:`${t}.${n}`,value:e[n]}));return r}}};function On(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return[new P(r,e,'"type" is required')];const o=_n(e.type);let a;switch(o){case"vector":case"raster":return a=kn({key:r,value:e,valueSpec:n[`source_${o.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Ln,validateSpec:s}),a;case"raster-dem":return a=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,o=t.style;let a=[];const l=qr(n);if(void 0===n)return a;if("object"!==l)return a.push(new P("source_raster_dem",n,`object expected, ${l} found`)),a;const u="custom"===_n(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?a.push(new P(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?a=a.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:o,styleSpec:i})):a.push(new P(e,n[e],`unknown property "${e}"`));return a}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),a;case"geojson":if(a=kn({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:Ln}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;a.push(...zn({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),a.push(...zn({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return a;case"video":return kn({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case"image":return kn({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case"canvas":return[new P(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Tn({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Rn(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const o=qr(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new P("light",e,`object expected, ${o} found`)]),s;for(const o in e){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?t.validateSpec({key:o,value:e[o],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[o]?t.validateSpec({key:o,value:e[o],valueSpec:n[o],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new P(o,e[o],`unknown property "${o}"`)])}return s}function Nn(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=qr(e);if(void 0===e)return[];if("object"!==s)return[new P("sky",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new P(s,e[s],`unknown property "${s}"`)]);return o}function Un(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const o=qr(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new P("terrain",e,`object expected, ${o} found`)]),s;for(const o in e)s=s.concat(n[o]?t.validateSpec({key:o,value:e[o],valueSpec:n[o],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new P(o,e[o],`unknown property "${o}"`)]);return s}function jn(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const o in r)r[o].id&&i.includes(r[o].id)&&e.push(new P(n,r,`all the sprites' ids must be unique, but ${r[o].id} is duplicated`)),i.push(r[o].id),r[o].url&&s.includes(r[o].url)&&e.push(new P(n,r,`all the sprites' URLs must be unique, but ${r[o].url} is duplicated`)),s.push(r[o].url),e=e.concat(kn({key:`${n}[${o}]`,value:r[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return $n({key:n,value:r})}function qn(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new P(t.key,t.value,`object expected, ${qr(t.value)} found`)];var e}const Gn={"*":()=>[],array:An,boolean:function(t){const e=t.value,r=t.key,n=qr(e);return"boolean"!==n?[new P(r,e,`boolean expected, ${n} found`)]:[]},number:In,color:Pn,constants:wn,enum:Tn,filter:Cn,function:Mn,layer:Fn,object:kn,source:On,light:Rn,sky:Nn,terrain:Un,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=qr(e);if(void 0===e)return[];if("object"!==s)return[new P("projection",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new P(s,e[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=qr(r);return"array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(r)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(r)?["array","string"].includes(n)?[]:[new P(e,r,`projection expected, invalid type "${n}" found`)]:[new P(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:$n,formatted:function(t){return 0===$n(t).length?[]:zn(t)},resolvedImage:function(t){return 0===$n(t).length?[]:zn(t)},padding:function(t){const e=t.key,r=t.value;if("array"===qr(r)){if(r.length<1||r.length>4)return[new P(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return In({key:e,value:r,valueSpec:{}})},numberArray:function(t){const e=t.key,r=t.value;if("array"===qr(r)){const n={type:"number"};if(r.length<1)return[new P(e,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return In({key:e,value:r,valueSpec:{}})},colorArray:function(t){const e=t.key,r=t.value;if("array"===qr(r)){if(r.length<1)return[new P(e,r,"array length at least 1 expected, length 0 found")];let t=[];for(let n=0;n<r.length;n++)t=t.concat(Pn({key:`${e}[${n}]`,value:r[n]}));return t}return Pn({key:e,value:r})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=qr(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return[new P(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Tn({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(An({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:jn,state:qn};function Xn(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=Xn,r.expression&&Gr(_n(e))?Mn(t):r.expression&&tn(Sn(e))?zn(t):r.type&&Gn[r.type]?Gn[r.type](t):kn(T({},t,{valueSpec:r.type?n[r.type]:r}))}function Zn(t){const e=t.value,r=t.key,n=$n(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new P(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new P(r,e,'"glyphs" url must include a "{range}" token'))),n}function Yn(t,e=M){let r=[];return r=r.concat(Xn({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Xn,objectElementValidators:{glyphs:Zn,"*":()=>[]}})),t.constants&&(r=r.concat(wn({key:"constants",value:t.constants}))),Jn(r)}function Hn(t){return function(e){return t({...e,validateSpec:Xn})}}function Jn(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function Wn(t){return function(...e){return Jn(t.apply(this,e))}}Yn.source=Wn(Hn(On)),Yn.sprite=Wn(Hn(jn)),Yn.glyphs=Wn(Hn(Zn)),Yn.light=Wn(Hn(Rn)),Yn.sky=Wn(Hn(Nn)),Yn.terrain=Wn(Hn(Un)),Yn.state=Wn(Hn(qn)),Yn.layer=Wn(Hn(Fn)),Yn.filter=Wn(Hn(Cn)),Yn.paintProperty=Wn(Hn(Vn)),Yn.layoutProperty=Wn(Hn(Dn));const Kn="AbortError";function Qn(){return new Error(Kn)}const ti={REGISTERED_PROTOCOLS:{}};function ei(t,e){ti.REGISTERED_PROTOCOLS[t]=e}function ri(t){delete ti.REGISTERED_PROTOCOLS[t]}const ni="global-dispatcher";class ii extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n}}const si=()=>b(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,oi=function(e,r){if(/:\/\//.test(e.url)&&!/^https?:|^file:/.test(e.url)){const t=ti.REGISTERED_PROTOCOLS[(n=e.url).substring(0,n.indexOf("://"))];if(t)return t(e,r);if(b(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,targetMapId:ni},r)}var n;if(!(t=>/^file:/.test(t)||/^file:/.test(si())&&!/^\w+:/.test(t))(e.url)){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(e,r){return t(this,void 0,void 0,(function*(){const t=new Request(e.url,{method:e.method||"GET",body:e.body,credentials:e.credentials,headers:e.headers,cache:e.cache,referrer:si(),signal:r.signal});let n,i;"json"!==e.type||t.headers.has("Accept")||t.headers.set("Accept","application/json");try{n=yield fetch(t)}catch(t){throw new ii(0,t.message,e.url,new Blob)}if(!n.ok){const t=yield n.blob();throw new ii(n.status,n.statusText,e.url,t)}i="arrayBuffer"===e.type||"image"===e.type?n.arrayBuffer():"json"===e.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw Qn();return{data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(e,r);if(b(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,mustQueue:!0,targetMapId:ni},r)}return function(t,e){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText))},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response)}catch(t){return void n(t)}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new ii(s.status,s.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{s.abort(),n(Qn())})),s.send(t.body)}))}(e,r)},ai={};function li(t,e,r={}){if(ai[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ai[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]}}li("Object",Object),li("Set",Set),li("TransferableGridIndex",I),li("Color",At),li("Error",Error),li("AJAXError",ii),li("ResolvedImage",Ft),li("StylePropertyFunction",on),li("StyleExpression",Qr,{omit:["_evaluator"]}),li("ZoomDependentExpression",nn),li("ZoomConstantExpression",rn),li("CompoundExpression",Tr,{omit:["_evaluate"]});for(const t in Pr)Pr[t]._classRegistryKey||li(`Expression_${t}`,Pr[t]);function ui(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function ci(t){return t.$name||t.constructor._classRegistryKey}function hi(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=ci(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||ui(t)||w(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function pi(t,e){if(hi(t))return(ui(t)||w(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(pi(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=ci(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!ai[r])throw new Error(`${r} is not registered.`);const{klass:n}=ai[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const n in t){if(!t.hasOwnProperty(n))continue;if(ai[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=ai[r].shallow.indexOf(n)>=0?s:pi(s,e)}t instanceof Error&&(i.message=t.message)}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(i.$name=r),i}function fi(t){if(hi(t))return t;if(Array.isArray(t))return t.map(fi);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=ci(t)||"Object";if(!ai[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=ai[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=ai[e].shallow.indexOf(r)>=0?i:fi(i)}return n}class di{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const yi={once:!0};class mi{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new di((()=>this.process())),this.subscription=k(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=b(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?k(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),yi):null;this.resolveRejects[i]={resolve:t=>{null==s||s.unsubscribe(),r(t)},reject:t=>{null==s||s.unsubscribe(),n(t)}};const o=[],a=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:pi(t.data,o)});this.target.postMessage(a,{transfer:o})}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(b(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(e,r){return t(this,void 0,void 0,(function*(){if("<response>"===r.type){const t=this.resolveRejects[e];if(delete this.resolveRejects[e],!t)return;return void(r.error?t.reject(fi(r.error)):t.resolve(fi(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(e,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const t=fi(r.data),n=new AbortController;this.abortControllers[e]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,t,n);this.completeTask(e,null,i)}catch(t){this.completeTask(e,t)}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?pi(e):null,data:pi(r,n)};this.target.postMessage(i,{transfer:n})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}function gi(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e))}function xi(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1)}}class vi{constructor(t,e={}){d(this,e),this.type=t}}class bi extends vi{constructor(t,e={}){super("error",d({error:t},e))}}class wi{on(t,e){return this._listeners=this._listeners||{},gi(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return xi(t,e,this._listeners),xi(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},gi(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new vi(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)xi(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(d(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t))}else t instanceof bi&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}const _i=Yn,Si=_i.paintProperty,ki=_i.layoutProperty;class Ai{constructor(){this.first=!0}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const Ii=t=>t>=12272&&t<=12287,Mi=t=>t>=12288&&t<=12351,zi=t=>t>=12448&&t<=12543,Pi=t=>t>=12736&&t<=12783,Ti=t=>t>=12800&&t<=13055,Ci=t=>t>=13056&&t<=13311,Ei=t=>t>=65040&&t<=65055,Bi=t=>t>=65072&&t<=65103,Vi=t=>t>=65104&&t<=65135,Di=t=>t>=65280&&t<=65519;function Fi(t){for(const e of t)if(Ui(e.charCodeAt(0)))return!0;return!1}function $i(t){for(const e of t)if(!Ri(e.charCodeAt(0)))return!1;return!0}function Li(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const Oi=Li(["Arab","Dupl","Mong","Ougr","Syrc"]);function Ri(t){return!Oi.test(String.fromCodePoint(t))}const Ni=Li(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function Ui(t){return!(746!==t&&747!==t&&(t<4352||!(Bi(t)&&!(t>=65097&&t<=65103)||Ci(t)||Pi(t)||!(!Mi(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Ti(t)||Ii(t)||(t=>t>=12688&&t<=12703)(t)||zi(t)&&12540!==t||!(!Di(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Vi(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Ei(t)||(t=>t>=19904&&t<=19967)(t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||Ni.test(String.fromCodePoint(t)))))}function ji(t){return!(Ui(t)||function(t){return!!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Mi(t)||zi(t)||(t=>t>=57344&&t<=63743)(t)||Bi(t)||Vi(t)||Di(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}const qi=Li(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Gi(t){return qi.test(String.fromCodePoint(t))}function Xi(t,e){return!(!e&&Gi(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Zi(t){for(const e of t)if(Gi(e.charCodeAt(0)))return!0;return!1}const Yi=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(Yi.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(e,r){return t(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==e.pluginStatus)return this.setState(e),e;const t=e.pluginURL,n=new Promise((t=>{this.loadScriptResolve=t}));r(t);const i=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const e={pluginStatus:"loaded",pluginURL:t};return this.setState(e),e}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${t}`)}))}};class Hi{constructor(t,e){this.isSupportedScript=Ji,this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new Ai,this.transition=e.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Ai,this.transition={})}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}function Ji(t){return function(t,e){for(const r of t)if(!Xi(r.charCodeAt(0),e))return!1;return!0}(t,"loaded"===Yi.getRTLTextPluginStatus())}class Wi{constructor(t,e,r){this.property=t,this.value=e,this.expression=function(t,e,r){if(Gr(t))return new on(t,e);if(tn(t)){const n=sn(t,e,r);if("error"===n.result)throw new Error(n.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return n.value}{let r=t;return"color"===e.type&&"string"==typeof t?r=At.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=Dt.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=$t.parse(t)):r=Et.parse(t):r=Ct.parse(t):r=Tt.parse(t),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Ki{constructor(t,e){this.property=t,this.value=new Wi(t,void 0,e)}transitioned(t,e){return new ts(this.property,this.value,e,d({},t.transition,this.transition),t.now)}untransitioned(){return new ts(this.property,this.value,null,{},0)}}class Qi{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._globalState=e}getValue(t){return m(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ki(this._values[t].property,this._globalState)),this._values[t].value=new Wi(this._values[t].property,null===e?void 0:m(e),this._globalState)}getTransition(t){return m(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ki(this._values[t].property,this._globalState)),this._values[t].transition=m(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n)}return t}transitioned(t,e){const r=new es(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new es(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class ts{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r)}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const o=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}(o))}}return i}}class es{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,r){const n=new is(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class rs{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._globalState=e}hasValue(t){return void 0!==this._values[t].value}getValue(t){return m(this._values[t].value)}setValue(t,e){this._values[t]=new Wi(this._values[t].property,null===e?void 0:m(e),this._globalState)}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r)}return t}possiblyEvaluate(t,e,r){const n=new is(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class ns{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class is{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class ss{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=fe[this.specification.type];return n?n(t,e,r):t}}class os{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,r,n){return new ns(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new ns(this,{kind:"constant",value:void 0},t.parameters);const n=fe[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new ns(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return"constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class as extends os{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new ns(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,o=this._calculate(s,s,s,e);return new ns(this,{kind:"constant",value:o},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new ns(this,{kind:"constant",value:r},e)}return new ns(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const o=t.evaluate(e,r,n,i,s);return this._calculate(o,o,o,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class ls{constructor(t){this.specification=t}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Hi(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Hi(Math.floor(e.zoom),e)),t.expression.evaluate(new Hi(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class us{constructor(t){this.specification=t}possiblyEvaluate(t,e,r,n){return!!t.expression.evaluate(e,null,{},r,n)}interpolate(){return!1}}class cs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new Wi(r,void 0,void 0),i=this.defaultTransitionablePropertyValues[e]=new Ki(r,void 0);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({})}}}li("DataDrivenProperty",os),li("DataConstantProperty",ss),li("CrossFadedDataDrivenProperty",as),li("CrossFadedProperty",ls),li("ColorRampProperty",us);const hs="-transition";class ps extends wi{constructor(t,e,r){if(super(),this.id=t.id,this.type=t.type,this._globalState=r,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=hn(t.filter,r)),e.layout&&(this._unevaluatedLayout=new rs(e.layout,r)),e.paint)){this._transitionablePaint=new Qi(e.paint,r);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new is(e.paint)}}setFilter(t){this.filter=t,this._featureFilter=hn(t,this._globalState)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[e];for(const e of r.getGlobalStateRefs())t.add(e)}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}getPaintAffectingGlobalStateRefs(){var t;const e=new globalThis.Map;if(this._transitionablePaint)for(const r in this._transitionablePaint._values){const n=this._transitionablePaint._values[r].value;for(const i of n.getGlobalStateRefs()){const s=null!==(t=e.get(i))&&void 0!==t?t:[];s.push({name:r,value:n.value}),e.set(i,s)}}return e}setLayoutProperty(t,e,r={}){null!=e&&this._validate(ki,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(hs)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Si,`layers.${this.id}.paint.${t}`,t,e,r))return!1;if(t.endsWith(hs))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const o=this._transitionablePaint._values[t].value;return o.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,o)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),function(t,e){const r={};for(const n in t)e.call(this,t[n],n,t)&&(r[n]=t[n]);return r}(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return(!i||!1!==i.validate)&&function(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new bi(new Error(n.message))),r=!0;return r}(this,t.call(_i,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:M,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof ns&&Nr(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const fs={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ds{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class ys{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function ms(t,e=1){let r=0,n=0;return{members:t.map((t=>{const i=fs[t.type].BYTES_PER_ELEMENT,s=r=gs(r,Math.max(e,i)),o=t.components||1;return n=Math.max(n,i),r+=i*o,{name:t.name,type:t.type,components:o,offset:s}})),size:gs(r,Math.max(n,e)),alignment:e}}function gs(t,e){return Math.ceil(t/e)*e}class xs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}xs.prototype.bytesPerElement=4,li("StructArrayLayout2i4",xs);class vs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}vs.prototype.bytesPerElement=6,li("StructArrayLayout3i6",vs);class bs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}bs.prototype.bytesPerElement=8,li("StructArrayLayout4i8",bs);class ws extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,t}}ws.prototype.bytesPerElement=12,li("StructArrayLayout2i4i12",ws);class _s extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=4*t,l=8*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=o,t}}_s.prototype.bytesPerElement=8,li("StructArrayLayout2i4ub8",_s);class Ss extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Ss.prototype.bytesPerElement=8,li("StructArrayLayout2f8",Ss);class ks extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,o,a,l,u)}emplace(t,e,r,n,i,s,o,a,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=o,this.uint16[h+6]=a,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}ks.prototype.bytesPerElement=20,li("StructArrayLayout10ui20",ks);class As extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,o,a,l,u,c,h)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=o,this.uint16[f+6]=a,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}As.prototype.bytesPerElement=24,li("StructArrayLayout4i4ui4i24",As);class Is extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Is.prototype.bytesPerElement=12,li("StructArrayLayout3f12",Is);class Ms extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Ms.prototype.bytesPerElement=4,li("StructArrayLayout1ul4",Ms);class zs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,o,a,l)}emplace(t,e,r,n,i,s,o,a,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=o,this.uint32[h+3]=a,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}zs.prototype.bytesPerElement=20,li("StructArrayLayout6i1ul2ui20",zs);class Ps extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,t}}Ps.prototype.bytesPerElement=12,li("StructArrayLayout2i2i2i12",Ps);class Ts extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.int16[a+6]=i,this.int16[a+7]=s,t}}Ts.prototype.bytesPerElement=16,li("StructArrayLayout2f1f2i16",Ts);class Cs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=16*t,l=4*t,u=8*t;return this.uint8[a+0]=e,this.uint8[a+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=o,t}}Cs.prototype.bytesPerElement=16,li("StructArrayLayout2ub2f2i16",Cs);class Es extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Es.prototype.bytesPerElement=6,li("StructArrayLayout3ui6",Es);class Bs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=o,this.uint32[v+4]=a,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}Bs.prototype.bytesPerElement=48,li("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Bs);class Vs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M,z){const P=32*t,T=16*t;return this.int16[P+0]=e,this.int16[P+1]=r,this.int16[P+2]=n,this.int16[P+3]=i,this.int16[P+4]=s,this.int16[P+5]=o,this.int16[P+6]=a,this.int16[P+7]=l,this.uint16[P+8]=u,this.uint16[P+9]=c,this.uint16[P+10]=h,this.uint16[P+11]=p,this.uint16[P+12]=f,this.uint16[P+13]=d,this.uint16[P+14]=y,this.uint16[P+15]=m,this.uint16[P+16]=g,this.uint16[P+17]=x,this.uint16[P+18]=v,this.uint16[P+19]=b,this.uint16[P+20]=w,this.uint16[P+21]=_,this.uint16[P+22]=S,this.uint32[T+12]=k,this.float32[T+13]=A,this.float32[T+14]=I,this.uint16[P+30]=M,this.uint16[P+31]=z,t}}Vs.prototype.bytesPerElement=64,li("StructArrayLayout8i15ui1ul2f2ui64",Vs);class Ds extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Ds.prototype.bytesPerElement=4,li("StructArrayLayout1f4",Ds);class Fs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Fs.prototype.bytesPerElement=12,li("StructArrayLayout1ui2f12",Fs);class $s extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}$s.prototype.bytesPerElement=8,li("StructArrayLayout1ul2ui8",$s);class Ls extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ls.prototype.bytesPerElement=4,li("StructArrayLayout2ui4",Ls);class Os extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Os.prototype.bytesPerElement=2,li("StructArrayLayout1ui2",Os);class Rs extends ys{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Rs.prototype.bytesPerElement=16,li("StructArrayLayout4f16",Rs);class Ns extends ds{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new e(this.anchorPointX,this.anchorPointY)}}Ns.prototype.size=20;class Us extends zs{get(t){return new Ns(this,t)}}li("CollisionBoxArray",Us);class js extends ds{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}js.prototype.size=48;class qs extends Bs{get(t){return new js(this,t)}}li("PlacedSymbolArray",qs);class Gs extends ds{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Gs.prototype.size=64;class Xs extends Vs{get(t){return new Gs(this,t)}}li("SymbolInstanceArray",Xs);class Zs extends Ds{getoffsetX(t){return this.float32[1*t+0]}}li("GlyphOffsetArray",Zs);class Ys extends vs{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}li("SymbolLineVertexArray",Ys);class Hs extends ds{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Hs.prototype.size=12;class Js extends Fs{get(t){return new Hs(this,t)}}li("TextAnchorOffsetArray",Js);class Ws extends ds{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Ws.prototype.size=8;class Ks extends $s{get(t){return new Ws(this,t)}}li("FeatureIndexArray",Ks);class Qs extends xs{}class to extends xs{}class eo extends xs{}class ro extends ws{}class no extends _s{}class io extends Ss{}class so extends ks{}class oo extends As{}class ao extends Is{}class lo extends Ms{}class uo extends Ps{}class co extends Cs{}class ho extends Es{}class po extends Ls{}const fo=ms([{name:"a_pos",components:2,type:"Int16"}],4),{members:yo}=fo;class mo{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,r,n){const i=this.segments[this.segments.length-1];return t>mo.MAX_VERTEX_ARRAY_LENGTH&&x(`Max vertices per segment is ${mo.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${mo.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+t>mo.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(e,r,n):i}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,r,n){return new mo([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function go(t,e){return 256*(t=f(Math.floor(t),0,255))+f(Math.floor(e),0,255)}mo.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,li("SegmentVector",mo);const xo=ms([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var vo,bo,wo,_o={exports:{}},So={exports:{}},ko={exports:{}},Ao=function(){if(wo)return _o.exports;wo=1;var t=(vo||(vo=1,So.exports=function(t,e){var r,n,i,s,o,a,l,u;for(n=t.length-(r=3&t.length),i=e,o=3432918353,a=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),So.exports),e=(bo||(bo=1,ko.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16)}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),ko.exports);return _o.exports=t,_o.exports.murmur3=t,_o.exports.murmur2=e,_o.exports}(),Io=r(Ao);class Mo{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,r,n){this.ids.push(zo(t)),this.positions.push(e,r,n)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=zo(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Po(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new Mo;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function zo(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:Io(String(t))}function Po(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,o=n+1;for(;;){do{s++}while(t[s]<i);do{o--}while(t[o]>i);if(s>=o)break;To(t,s,o),To(e,3*s,3*o),To(e,3*s+1,3*o+1),To(e,3*s+2,3*o+2)}o-r<n-o?(Po(t,e,r,o),r=o+1):(Po(t,e,o+1,n),n=o)}}function To(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}li("FeaturePositionMap",Mo);class Co{constructor(t,e){this.gl=t.gl,this.location=e}}class Eo extends Co{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class Bo extends Co{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class Vo extends Co{constructor(t,e){super(t,e),this.current=At.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}function Do(t){return[go(255*t.r,255*t.g),go(255*t.b,255*t.a)]}class Fo{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r}setUniform(t,e,r){t.set(r.constantOr(this.value))}getBinding(t,e,r){return"color"===this.type?new Vo(t,e):new Eo(t,e)}}class $o{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i)}getBinding(t,e,r){return"u_pattern"===r.substr(0,9)?new Bo(t,e):new Eo(t,e)}}class Lo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n}populatePaintArray(t,e,r){const n=this.paintVertexArray.length,i=this.expression.evaluate(new Hi(0,r),e,{},r.canonical,[],r.formattedSection);this.paintVertexArray.resize(t),this._setPaintValue(n,t,i)}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Hi(0,i),r,n);this._setPaintValue(t,e,s)}_setPaintValue(t,e,r){if("color"===this.type){const n=Do(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Oo{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(t,e,r){const n=this.expression.evaluate(new Hi(this.zoom,r),e,{},r.canonical,[],r.formattedSection),i=this.expression.evaluate(new Hi(this.zoom+1,r),e,{},r.canonical,[],r.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(s,t,n,i)}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Hi(this.zoom,i),r,n),o=this.expression.evaluate(new Hi(this.zoom+1,i),r,n);this._setPaintValue(t,e,s,o)}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Do(r),s=Do(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1])}else{for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=f(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n)}getBinding(t,e,r){return new Eo(t,e)}}class Ro{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r.imagePositions)}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i.imagePositions)}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:o}=r,a=n[i],l=n[s],u=n[o];if(a&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],a.tl[0],a.tl[1],a.br[0],a.br[1],l.pixelRatio,a.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,xo.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,xo.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class No{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof ns&&Nr(s.property.specification)))continue;const o=jo(i,t.type),a=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===a.kind)this.binders[i]=h?new $o(a.value,o):new Fo(a.value,o,l),n.push(`/u_${i}`);else if("source"===a.kind||h){const r=qo(i,l,"source");this.binders[i]=h?new Ro(a,l,u,e,r,t.id):new Lo(a,o,l,r),n.push(`/a_${i}`)}else{const t=qo(i,l,"composite");this.binders[i]=new Oo(a,o,l,u,e,t),n.push(`/z_${i}`)}}this.cacheKey=n.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof Lo||e instanceof Oo?e.maxValue:0}populatePaintArrays(t,e,r){for(const n in this.binders){const i=this.binders[n];(i instanceof Lo||i instanceof Oo||i instanceof Ro)&&i.populatePaintArray(t,e,r)}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof $o&&n.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const o in t){const a=e.getPositions(o);for(const e of a){const a=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Lo||l instanceof Oo||l instanceof Ro)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,a,t[o],i),s=!0}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Fo||r instanceof $o)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Lo||r instanceof Oo)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof Ro)for(let e=0;e<xo.members.length;e++)t.push(xo.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Fo||r instanceof $o||r instanceof Oo)for(const e of r.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Fo||i instanceof $o||i instanceof Oo)for(const s of i.uniformNames)if(e[s]){const o=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:o})}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof Ro){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(r instanceof Lo||r instanceof Oo)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer)}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Lo||r instanceof Oo||r instanceof Ro)&&r.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Lo||e instanceof Oo||e instanceof Ro)&&e.destroy()}}}class Uo{constructor(t,e,r=()=>!0){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new No(n,e,r);this.needsUpload=!1,this._featureMap=new Mo,this._bufferOffset=0}populatePaintArrays(t,e,r,n){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function jo(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function qo(t,e,r){const n={color:{source:Ss,composite:Rs},number:{source:Ds,composite:Ss}},i=function(t){return{"line-pattern":{source:so,composite:so},"fill-pattern":{source:so,composite:so},"fill-extrusion-pattern":{source:so,composite:so}}[t]}(t);return i&&i[r]||n[e][r]}li("ConstantBinder",Fo),li("CrossFadedConstantBinder",$o),li("SourceExpressionBinder",Lo),li("CrossFadedCompositeBinder",Ro),li("CompositeExpressionBinder",Oo),li("ProgramConfiguration",No,{omit:["_buffers"]}),li("ProgramConfigurationSet",Uo);const Go=Math.pow(2,14)-1,Xo=-Go-1;function Zo(t){const e=p/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=f(i,Xo,Go),r.y=f(s,Xo,Go),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&x("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return r}function Yo(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?Zo(t):[]}}const Ho=-32768;function Jo(t,e,r,n,i){t.emplaceBack(Ho+8*e+n,Ho+8*r+i)}class Wo{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new to,this.indexArray=new ho,this.segments=new mo,this.programConfigurations=new Uo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){const n=this.layers[0],i=[];let s=null,o=!1,a="heatmap"===n.type;if("circle"===n.type){const t=n;s=t.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===t.paint.get("circle-pitch-alignment")}const l=a?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Yo(e,t);if(!this.layers[0]._featureFilter.filter(new Hi(this.zoom),u,r))continue;const c=o?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?u.geometry:Zo(e),patterns:{},sortKey:c};i.push(h)}o&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:o}=n,a=t[s].feature;this.addFeature(n,i,s,r,l),e.featureIndex.insert(a,i,s,o,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r})}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,yo),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=p||n<0||n>=p)continue;const i=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,t.sortKey),a=i.vertexLength;for(let t=0;t<o;t++)for(let e=0;e<o;e++)Jo(this.layoutVertexArray,r,n,s[e],s[t]);for(let t=0;t<o-1;t++)for(let e=0;e<o-1;e++){const r=a+t*o+e,n=a+(t+1)*o+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1)}i.vertexLength+=o*o,i.primitiveLength+=(o-1)*(o-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:{},canonical:n})}}function Ko(t,e){for(let r=0;r<t.length;r++)if(aa(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(aa(t,e[r]))return!0;return!!ra(t,e)}function Qo(t,e,r){return!!aa(t,e)||!!ia(e,t,r)}function ta(t,e){if(1===t.length)return oa(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(aa(t,n[e]))return!0}for(let r=0;r<t.length;r++)if(oa(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(ra(t,e[r]))return!0;return!1}function ea(t,e,r){if(t.length>1){if(ra(t,e))return!0;for(let n=0;n<e.length;n++)if(ia(e[n],t,r))return!0}for(let n=0;n<t.length;n++)if(ia(t[n],e,r))return!0;return!1}function ra(t,e){if(0===t.length||0===e.length)return!1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(na(n,i,e[t],e[t+1]))return!0}return!1}function na(t,e,r,n){return v(t,r,n)!==v(e,r,n)&&v(t,e,r)!==v(t,e,n)}function ia(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(sa(t,e[r-1],e[r])<n)return!0;return!1}function sa(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function oa(t,e){let r,n,i,s=!1;for(let o=0;o<t.length;o++){r=t[o];for(let t=0,o=r.length-1;t<r.length;o=t++)n=r[t],i=r[o],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s)}return s}function aa(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],o=t[i];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(r=!r)}return r}function la(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return!1;const s=v(t,e,r[0]);return s!==v(t,e,r[1])||s!==v(t,e,r[2])||s!==v(t,e,r[3])}function ua(t,e,r){const n=e.paint.get(t).value;return"constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function ca(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function ha(t,r,n,i,s){if(!r[0]&&!r[1])return t;const o=e.convert(r)._mult(s);"viewport"===n&&o._rotate(-i);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(o));return a}function pa({queryGeometry:t,size:e},r){return Qo(t,r,e)}function fa({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i},s){return Qo(t,s,e*(r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera/r.cameraToCenterDistance))}function da({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i},s){const o=r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera,a=e*(r.cameraToCenterDistance/o);return Qo(t,ga(s,r,n,i),a)}function ya({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i},s){return Qo(t,ga(s,r,n,i),e)}function ma({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i,pitchAlignment:s="map",pitchScale:o="map"},a){const l="map"===s?"map"===o?pa:fa:"map"===o?da:ya,u={queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i};for(const t of a)for(const e of t)if(l(u,e))return!0;return!1}function ga(t,r,n,i){const s=r.projectTileCoordinates(t.x,t.y,n,i).point;return new e((.5*s.x+.5)*r.width,(.5*-s.y+.5)*r.height)}let xa,va;li("CircleBucket",Wo,{omit:["layers"]});var ba={get paint(){return va=va||new cs({"circle-radius":new os(M.paint_circle["circle-radius"]),"circle-color":new os(M.paint_circle["circle-color"]),"circle-blur":new os(M.paint_circle["circle-blur"]),"circle-opacity":new os(M.paint_circle["circle-opacity"]),"circle-translate":new ss(M.paint_circle["circle-translate"]),"circle-translate-anchor":new ss(M.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new ss(M.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new ss(M.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new os(M.paint_circle["circle-stroke-width"]),"circle-stroke-color":new os(M.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new os(M.paint_circle["circle-stroke-opacity"])})},get layout(){return xa=xa||new cs({"circle-sort-key":new os(M.layout_circle["circle-sort-key"])})}};class wa extends ps{constructor(t,e){super(t,ba,e)}createBucket(t){return new Wo(t)}queryRadius(t){const e=t;return ua("circle-radius",this,e)+ua("circle-stroke-width",this,e)+ca(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){const l=ha(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c=this.paint.get("circle-pitch-scale"),h=this.paint.get("circle-pitch-alignment");let p,f;return"map"===h?(p=l,f=u*s):(p=function(t,e,r,n){return t.map((t=>ga(t,e,r,n)))}(l,i,o,a),f=u),ma({queryGeometry:p,size:f,transform:i,unwrappedTileID:o,getElevation:a,pitchAlignment:h,pitchScale:c},n)}}class _a extends Wo{}let Sa;li("HeatmapBucket",_a,{omit:["layers"]});var ka={get paint(){return Sa=Sa||new cs({"heatmap-radius":new os(M.paint_heatmap["heatmap-radius"]),"heatmap-weight":new os(M.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new ss(M.paint_heatmap["heatmap-intensity"]),"heatmap-color":new us(M.paint_heatmap["heatmap-color"]),"heatmap-opacity":new ss(M.paint_heatmap["heatmap-opacity"])})}};function Aa(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function Ia(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=Aa({},{width:e,height:r},n);Ma(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data}function Ma(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const o=t.data,a=e.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)a[c+t]=o[u+t]}return e}class za{constructor(t,e){Aa(this,t,1,e)}resize(t){Ia(this,t,1)}clone(){return new za({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Ma(t,e,r,n,i,1)}}class Pa{constructor(t,e){Aa(this,t,4,e)}resize(t){Ia(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new Pa({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Ma(t,e,r,n,i,4)}setPixel(t,e,r){const n=4*(t*this.width+e);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a)}}li("AlphaImage",za),li("RGBAImage",Pa);const Ta="big-fb";class Ca extends ps{createBucket(t){return new _a(t)}constructor(t,e){super(t,ka,e),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=function(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Pa({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,o)=>{e[t.evaluationKey]=o;const a=t.expression.evaluate(e);i.setPixel(n/4/r,s/4,a)};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,o=0;n<r;n++,o+=4){const a=n/(r-1),{start:l,end:u}=t.clips[e];s(i,o,l*(1-a)+u*a)}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(Ta)&&this.heatmapFbos.delete(Ta)}queryRadius(t){return ua("heatmap-radius",this,t)}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){return ma({queryGeometry:t,size:this.paint.get("heatmap-radius").evaluate(e,r)*s,transform:i,unwrappedTileID:o,getElevation:a},n)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Ea;var Ba={get paint(){return Ea=Ea||new cs({"hillshade-illumination-direction":new ss(M.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new ss(M.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new ss(M.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new ss(M.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new ss(M.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new ss(M.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new ss(M.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new ss(M.paint_hillshade["hillshade-method"])})}};class Va extends ps{constructor(t,e){super(t,Ba,e),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(t.length,e.length,r.length,n.length);t=t.concat(Array(i-t.length).fill(t.at(-1))),e=e.concat(Array(i-e.length).fill(e.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=e.map(A);return{directionRadians:t.map(A),altitudeRadians:s,shadowColor:n,highlightColor:r}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let Da;var Fa={get paint(){return Da=Da||new cs({"color-relief-opacity":new ss(M["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new us(M["paint_color-relief"]["color-relief-color"])})}};class $a{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n)}update(t,e,r){const{width:n,height:i}=t,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(e&&e.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||w(t)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,n,i,0,this.format,a.UNSIGNED_BYTE,t.data);else{const{x:e,y:s}=r||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||w(t)?a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,s,n,i,a.RGBA,a.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D),o.pixelStoreUnpackFlipY.setDefault(),o.pixelStoreUnpack.setDefault(),o.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(t,e,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),t!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}class La{constructor(t,e,r,n=1,i=1,s=1,o=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void x(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const a=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<a;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(a,t)]=this.data[this._idx(a-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,a)]=this.data[this._idx(t,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<a;t++)for(let e=0;e<a;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r)}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}pack(t){return Oa(t,this.getUnpackVector())}getPixels(){return new Pa({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,o=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1}switch(r){case-1:s=o-1;break;case 1:o=s+1}const a=-e*this.dim,l=-r*this.dim;for(let e=s;e<o;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+a,e+l)]}}function Oa(t,e){const r=e[0],n=e[1],i=e[2],s=e[3],o=Math.min(r,n,i),a=Math.round((t+s)/o);return{r:Math.floor(a*o/r)%256,g:Math.floor(a*o/n)%256,b:Math.floor(a*o/i)%256}}li("DEMData",La);class Ra extends ps{constructor(t,e){super(t,Fa,e)}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof rn&&r._styleExpression.expression instanceof he){this.colorRampExpression=r;const t=r._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const r of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:r}}))}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[At.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const n={elevationStops:[],colorStops:[]},i=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=i)n.elevationStops.push(e.elevationStops[Math.round(t)]),n.colorStops.push(e.colorStops[Math.round(t)]);return x(`Too many colors in specification of ${this.id} color-relief layer, may not render properly.`),n}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(e),i=new Pa({width:n.colorStops.length,height:1}),s=new Pa({width:n.colorStops.length,height:1});for(let t=0;t<n.elevationStops.length;t++){const e=Oa(n.elevationStops[t],r);s.setPixel(0,t,new At(e.r/255,e.g/255,e.b/255,1)),i.setPixel(0,t,n.colorStops[t])}return this.colorRampTextures={elevationTexture:new $a(t,s,t.gl.RGBA),colorTexture:new $a(t,i,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return"none"!==this.visibility&&!!this.colorRampTextures}}const Na=ms([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ua}=Na;function ja(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0)}return i}function qa(t,e,r,n,i){const{zoom:s}=n,o=i.patternDependencies;for(const n of e){const e=n.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:s-1},r,{},i.availableImages),a=e.evaluate({zoom:s},r,{},i.availableImages),l=e.evaluate({zoom:s+1},r,{},i.availableImages);t=t&&t.name?t.name:t,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,o[t]=!0,o[a]=!0,o[l]=!0,r.patterns[n.id]={min:t,mid:a,max:l}}}return r}function Ga(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,o=r-n;s<r;s+=n)i+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=fl(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=fl(i/n|0,t[i],t[i+1],s);return s&&al(s,s.next)&&(dl(s),s=s.next),s}function Xa(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!al(n,n.next)&&0!==ol(n.prev,n,n.next))n=n.next;else{if(dl(n),n=e=n.prev,n===n.next)break;r=!0}}while(r||n!==e);return e}function Za(t,e,r,n,i,s,o){if(!t)return;!o&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=el(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let o=i,a=0;for(let t=0;t<r&&(a++,o=o.nextZ,o);t++);let l=r;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||i.z<=o.z)?(n=i,i=i.nextZ,a--):(n=o,o=o.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=o}s.nextZ=null,r*=2}while(e>1)}(i)}(t,n,i,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Ha(t,n,i,s):Ya(t))e.push(l.i,t.i,u.i),dl(t),t=u.next,a=u.next;else if((t=u)===a){o?1===o?Za(t=Ja(Xa(t),e),e,r,n,i,s,2):2===o&&Wa(t,e,r,n,i,s):Za(Xa(t),e,r,n,i,s,1);break}}}function Ya(t){const e=t.prev,r=t,n=t.next;if(ol(e,r,n)>=0)return!1;const i=e.x,s=r.x,o=n.x,a=e.y,l=r.y,u=n.y,c=Math.min(i,s,o),h=Math.min(a,l,u),p=Math.max(i,s,o),f=Math.max(a,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&il(i,a,s,l,o,u,d.x,d.y)&&ol(d.prev,d,d.next)>=0)return!1;d=d.next}return!0}function Ha(t,e,r,n){const i=t.prev,s=t,o=t.next;if(ol(i,s,o)>=0)return!1;const a=i.x,l=s.x,u=o.x,c=i.y,h=s.y,p=o.y,f=Math.min(a,l,u),d=Math.min(c,h,p),y=Math.max(a,l,u),m=Math.max(c,h,p),g=el(f,d,e,r,n),x=el(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&il(a,c,l,h,u,p,v.x,v.y)&&ol(v.prev,v,v.next)>=0)return!1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&il(a,c,l,h,u,p,b.x,b.y)&&ol(b.prev,b,b.next)>=0)return!1;b=b.nextZ}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&il(a,c,l,h,u,p,v.x,v.y)&&ol(v.prev,v,v.next)>=0)return!1;v=v.prevZ}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&il(a,c,l,h,u,p,b.x,b.y)&&ol(b.prev,b,b.next)>=0)return!1;b=b.nextZ}return!0}function Ja(t,e){let r=t;do{const n=r.prev,i=r.next.next;!al(n,i)&&ll(n,r,r.next,i)&&hl(n,i)&&hl(i,n)&&(e.push(n.i,r.i,i.i),dl(r),dl(r.next),r=t=i),r=r.next}while(r!==t);return Xa(r)}function Wa(t,e,r,n,i,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&sl(o,t)){let a=pl(o,t);return o=Xa(o,o.next),a=Xa(a,a.next),Za(o,e,r,n,i,s,0),void Za(a,e,r,n,i,s,0)}t=t.next}o=o.next}while(o!==t)}function Ka(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Qa(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,o=-1/0;if(al(t,r))return r;do{if(al(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>o&&(o=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next}while(r!==e);if(!s)return null;const a=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&nl(i<u?n:o,i,l,u,i<u?o:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);hl(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&tl(s,r)))&&(s=r,c=e)}r=r.next}while(r!==a);return s}(t,e);if(!r)return e;const n=pl(r,t);return Xa(n,n.next),Xa(r,r.next)}function tl(t,e){return ol(t.prev,t,e.prev)<0&&ol(e.next,t,t.next)<0}function el(t,e,r,n,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function rl(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next}while(e!==t);return r}function nl(t,e,r,n,i,s,o,a){return(i-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(n-a)>=(r-o)*(e-a)&&(r-o)*(s-a)>=(i-o)*(n-a)}function il(t,e,r,n,i,s,o,a){return!(t===o&&e===a)&&nl(t,e,r,n,i,s,o,a)}function sl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&ll(r,r.next,t,e))return!0;r=r.next}while(r!==t);return!1}(t,e)&&(hl(t,e)&&hl(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==t);return n}(t,e)&&(ol(t.prev,t,e.prev)||ol(t,e.prev,e))||al(t,e)&&ol(t.prev,t,t.next)>0&&ol(e.prev,e,e.next)>0)}function ol(t,e,r){return(e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function al(t,e){return t.x===e.x&&t.y===e.y}function ll(t,e,r,n){const i=cl(ol(t,e,r)),s=cl(ol(t,e,n)),o=cl(ol(r,n,t)),a=cl(ol(r,n,e));return i!==s&&o!==a||!(0!==i||!ul(t,r,e))||!(0!==s||!ul(t,n,e))||!(0!==o||!ul(r,t,n))||!(0!==a||!ul(r,e,n))}function ul(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function cl(t){return t>0?1:t<0?-1:0}function hl(t,e){return ol(t.prev,t,t.next)<0?ol(t,e,t.next)>=0&&ol(t,t.prev,e)>=0:ol(t,e,t.prev)<0||ol(t,t.next,e)<0}function pl(t,e){const r=yl(t.i,t.x,t.y),n=yl(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function fl(t,e,r,n){const i=yl(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function dl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function yl(t,e,r){return{i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class ml{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class gl{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}gl.noSubdivision=new gl({fill:new ml(0,0),line:new ml(0,0),tile:new ml(0,0),stencil:new ml(0,0),circle:1}),li("SubdivisionGranularityExpression",ml),li("SubdivisionGranularitySetting",gl);const xl=-32768,vl=32767;class bl{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=p/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const i=e[n],s=e[n+1],o=e[n+2],a=t[2*i],l=t[2*i+1];(t[2*s]-a)*(t[2*o+1]-l)-(t[2*s+1]-l)*(t[2*o]-a)>0?(r.push(i),r.push(o),r.push(s)):(r.push(i),r.push(s),r.push(o))}return r}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],i=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=i[2*t],r=i[2*t+1];s=Math.min(s,e),a=Math.max(a,e),o=Math.min(o,r),l=Math.max(l,r)}if(s===a||o===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(a/this._granularityCellSize),h=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let t=h;t<p;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,i,r);Sl(this._vertexBuffer,n,e)}else e.push(...r)}return e}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const o=e[2*t],a=e[2*t+1],l=e[2*(t+1)%6],u=e[(2*(t+1)+1)%6],c=e[2*(t+2)%6],h=e[(2*(t+2)+1)%6],p=l-o,f=u-a,d=0===p,y=0===f,m=(n-a)/f,g=(i-a)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(a<n||a>i)){u>=n&&u<=i&&s.push(r[(t+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(o+p*x,a+f*x));const b=o+p*Math.max(x,0),w=o+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,o,a,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(o+p*v,a+f*v)),(y||u>=n&&u<=i)&&s.push(r[(t+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,o,a,l,u,c,h,w,n,i)}return s}_generateIntraEdgeVertices(t,e,r,n,i,s,o){const a=n-e,l=i-r,u=0===l,c=u?Math.min(e,n):Math.min(s,o),h=u?Math.max(e,n):Math.max(s,o),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?e<n:s<o)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/a))}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/a))}}_generateInterEdgeVertices(t,e,r,n,i,s,o,a,l,u){const c=i-r,h=s-n,p=o-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,b=a<g;const w=0===p;if(w&&(o===l||o===u))return;if(w||y>=1||m<=0){const t=r-o,n=s+(e-s)*Math.min((l-o)/t,(u-o)/t);x=Math.floor(Math.min(n,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,a)/this._granularityCellSize)-1,b=a<n}const _=c>0?u:l;if(b)for(let e=x;e<=v;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,_));else for(let e=v;e>=x;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,_))}_generateOutline(t){const e=[];for(const r of t){const t=_l(r,this._granularity,!0),n=this._pointArrayToIndices(t),i=[];for(let t=1;t<n.length;t++)i.push(n[t-1]),i.push(n[t]);e.push(i)}return e}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===xl&&(t[e+1]=-32767),r===vl&&(t[e+1]=32766)}}_generatePoleQuad(t,e,r,n,i,s){n>i!=(s===xl)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,s)),t.push(r),t.push(this._vertexToIndex(i,s)),t.push(this._vertexToIndex(n,s))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(i,s)),t.push(r),t.push(this._vertexToIndex(n,s)))}_fillPoles(t,e,r){const n=this._vertexBuffer,i=p,s=t.length;for(let o=2;o<s;o+=3){const s=t[o-2],a=t[o-1],l=t[o],u=n[2*s],c=n[2*s+1],h=n[2*a],p=n[2*a+1],f=n[2*l],d=n[2*l+1];e&&(0===c&&0===p&&this._generatePoleQuad(t,s,a,u,h,xl),0===p&&0===d&&this._generatePoleQuad(t,a,l,h,f,xl),0===d&&0===c&&this._generatePoleQuad(t,l,s,f,u,xl)),r&&(c===i&&p===i&&this._generatePoleQuad(t,s,a,u,h,vl),p===i&&d===i&&this._generatePoleQuad(t,a,l,h,f,vl),d===i&&c===i&&this._generatePoleQuad(t,l,s,f,u,vl))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y)}return{flattened:r,holeIndices:e}}(t);let i;this._initializeVertices(r);try{const t=function(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Ga(t,0,i,r,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const o=Ga(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);o===o.next&&(o.steiner=!0),i.push(rl(o))}i.sort(Ka);for(let t=0;t<i.length;t++)r=Qa(i[t],r);return r}(t,e,s,r)),t.length>80*r){a=t[0],l=t[1];let e=a,n=l;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<a&&(a=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i)}u=Math.max(e-a,n-l),u=0!==u?32767/u:0}return Za(s,o,r,a,l,u,0),o}(r,n),e=this._convertIndices(r,t);i=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y))}return e}}function wl(t,e,r,n=!0){return new bl(r,e).subdividePolygonInternal(t,n)}function _l(t,r,n=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const i=t[0],s=t[t.length-1],o=n&&(i.x!==s.x||i.y!==s.y);if(r<2)return o?[...t,t[0]]:[...t];const a=Math.floor(p/r),l=[];l.push(new e(t[0].x,t[0].y));const u=t.length,c=o?u:u-1;for(let r=0;r<c;r++){const n=t[r],i=r<u-1?t[r+1]:t[0],s=n.x,o=n.y,c=i.x,h=i.y,p=s!==c,f=o!==h;if(!p&&!f)continue;const d=c-s,y=h-o,m=Math.abs(d),g=Math.abs(y);let x=s,v=o;for(;;){const t=d>0?(Math.floor(x/a)+1)*a:(Math.ceil(x/a)-1)*a,r=y>0?(Math.floor(v/a)+1)*a:(Math.ceil(v/a)-1)*a,n=Math.abs(x-t),i=Math.abs(v-r),s=Math.abs(x-c),o=Math.abs(v-h),u=p?n/m:Number.POSITIVE_INFINITY,b=f?i/g:Number.POSITIVE_INFINITY;if((s<=n||!p)&&(o<=i||!f))break;if(u<b&&p||!f){x=t,v+=y*u;const r=new e(x,Math.round(v));l[l.length-1].x===r.x&&l[l.length-1].y===r.y||l.push(r)}else{x+=d*b,v=r;const t=new e(Math.round(x),v);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t)}}const b=new e(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b)}return l}function Sl(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=t[2*e[0]];for(let r=1;r<e.length;r++){const s=t[2*e[r]];s<i&&(i=s,n=r)}const s=e.length;let o=n,a=(o+1)%s;for(;;){const n=o-1>=0?o-1:s-1,i=(a+1)%s,l=t[2*e[n]],u=t[2*e[i]],c=t[2*e[o]],h=t[2*e[o]+1],p=t[2*e[a]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else{const r=p-h,s=-(t[2*e[a]]-c),o=h<p?1:-1;((l-c)*r+(t[2*e[n]+1]-h)*s)*o>((u-c)*r+(t[2*e[i]+1]-h)*s)*o&&(f=!0)}if(f){const t=e[n],i=e[o],l=e[a];t!==i&&t!==l&&i!==l&&r.push(l,i,t),o--,o<0&&(o=s-1)}else{const t=e[i],n=e[o],l=e[a];t!==n&&t!==l&&n!==l&&r.push(l,n,t),a++,a>=s&&(a=0)}if(n===i)break}}function kl(t,e,r,n,i,s,o,a,l){const u=i.length/2,c=o&&a&&l;if(u<mo.MAX_VERTEX_ARRAY_LENGTH){const h=e.prepareSegment(u,r,n),p=h.vertexLength;for(let t=0;t<s.length;t+=3)n.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=o.prepareSegment(u,r,a),f=d.vertexLength,d.vertexLength+=u);for(let e=0;e<i.length;e+=2)t(i[e],i[e+1]);if(c)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)a.emplaceBack(f+e[t-1],f+e[t]);d.primitiveLength+=e.length/2}}else!function(t,e,r,n,i,s){const o=[];for(let t=0;t<n.length/2;t++)o.push(-1);const a={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=o[p]<l,m=o[f]<l,g=o[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>mo.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=a.count,y=!0,m=!0,g=!0,c=0);const x=Al(o,n,s,a,p,y,u),v=Al(o,n,s,a,f,m,u),b=Al(o,n,s,a,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++}}(e,r,n,i,s,t),c&&function(t,e,r,n,i,s){const o=[];for(let t=0;t<n.length/2;t++)o.push(-1);const a={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=o[i]<l,y=o[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>mo.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=a.count,d=!0,y=!0,c=0);const m=Al(o,n,s,a,i,d,u),g=Al(o,n,s,a,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++}}}(o,r,a,i,l,t),e.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare()}function Al(t,e,r,n,i,s,o){if(s){const s=n.count;return r(e[2*i],e[2*i+1]),t[i]=n.count,n.count++,o.vertexLength++,s}return t[i]}class Il{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new eo,this.indexArray=new ho,this.indexArray2=new po,this.programConfigurations=new Uo(t.layers,t.zoom),this.segments=new mo,this.segments2=new mo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.hasPattern=ja("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Yo(o,t);if(!this.layers[0]._featureFilter.filter(new Hi(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Zo(o),patterns:{},sortKey:h};s.push(p)}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasPattern){const t=qa("fill",this.layers,n,{zoom:this.zoom},e);this.patternFeatures.push(t)}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,o,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r})}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ua),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,r,n,i,s){for(const t of Qe(e,500)){const e=wl(t,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;kl(((t,e)=>{r.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n})}}let Ml,zl;li("FillBucket",Il,{omit:["layers","patternFeatures"]});var Pl={get paint(){return zl=zl||new cs({"fill-antialias":new ss(M.paint_fill["fill-antialias"]),"fill-opacity":new os(M.paint_fill["fill-opacity"]),"fill-color":new os(M.paint_fill["fill-color"]),"fill-outline-color":new os(M.paint_fill["fill-outline-color"]),"fill-translate":new ss(M.paint_fill["fill-translate"]),"fill-translate-anchor":new ss(M.paint_fill["fill-translate-anchor"]),"fill-pattern":new as(M.paint_fill["fill-pattern"])})},get layout(){return Ml=Ml||new cs({"fill-sort-key":new os(M.layout_fill["fill-sort-key"])})}};class Tl extends ps{constructor(t,e){super(t,Pl,e)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new Il(t)}queryRadius(){return ca(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}){return ta(ha(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e)}isTileClipped(){return!0}}const Cl=ms([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),El=ms([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Bl}=Cl;class Vl{constructor(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(Dl,this,e)}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const r=t.readVarint()+t.pos,n=[];let i,s=1,o=0,a=0,l=0;for(;t.pos<r;){if(o<=0){const e=t.readVarint();s=7&e,o=e>>3}if(o--,1===s||2===s)a+=t.readSVarint(),l+=t.readSVarint(),1===s&&(i&&n.push(i),i=[]),i&&i.push(new e(a,l));else{if(7!==s)throw new Error(`unknown command ${s}`);i&&i.push(i[0].clone())}}return i&&n.push(i),n}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let r=1,n=0,i=0,s=0,o=1/0,a=-1/0,l=1/0,u=-1/0;for(;t.pos<e;){if(n<=0){const e=t.readVarint();r=7&e,n=e>>3}if(n--,1===r||2===r)i+=t.readSVarint(),s+=t.readSVarint(),i<o&&(o=i),i>a&&(a=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`)}return[o,l,a,u]}toGeoJSON(t,e,r){const n=this.extent*Math.pow(2,r),i=this.extent*t,s=this.extent*e,o=this.loadGeometry();function a(t){return[360*(t.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+s)/n)*Math.PI))-90]}function l(t){return t.map(a)}let u;if(1===this.type){const t=[];for(const e of o)t.push(e[0]);const e=l(t);u=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e}}else if(2===this.type){const t=o.map(l);u=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t}}else{if(3!==this.type)throw new Error("unknown feature type");{const t=function(t){const e=t.length;if(e<=1)return[t];const r=[];let n,i;for(let s=0;s<e;s++){const e=Fl(t[s]);0!==e&&(void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t[s]]):n&&n.push(t[s]))}return n&&r.push(n),r}(o),e=[];for(const r of t)e.push(r.map(l));u=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e}}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c}}function Dl(t,e,r){1===t?e.id=r.readVarint():2===t?function(t,e){const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n}}(r,e):3===t?e.type=r.readVarint():4===t&&(e._geometry=r.pos)}function Fl(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}Vl.types=["Unknown","Point","LineString","Polygon"];class $l{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Ll,this,e),this.length=this._features.length}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new Vl(this._pbf,e,this.extent,this._keys,this._values)}}function Ll(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){let e=null;const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null}if(null==e)throw new Error("unknown feature value");return e}(r))}class Ol{constructor(t,e){this.layers=t.readFields(Rl,{},e)}}function Rl(t,e,r){if(3===t){const t=new $l(r,r.readVarint()+r.pos);t.length&&(e[t.name]=t)}}const Nl=Math.pow(2,13);function Ul(t,e,r,n,i,s,o,a){t.emplaceBack(e,r,2*Math.floor(n*Nl)+o,i*Nl*2,s*Nl*2,Math.round(a))}class jl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new ro,this.centroidVertexArray=new Qs,this.indexArray=new ho,this.programConfigurations=new Uo(t.layers,t.zoom),this.segments=new mo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.features=[],this.hasPattern=ja("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,a=Yo(n,t);if(!this.layers[0]._featureFilter.filter(new Hi(this.zoom),a,r))continue;const l={id:i,sourceLayerIndex:o,index:s,geometry:t?a.geometry:Zo(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(qa("fill-extrusion",this.layers,l,{zoom:this.zoom},e)):this.addFeature(l,l.geometry,s,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,l.geometry,s,o,this.index,!0)}}addFeatures(t,e,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,e,r,t.subdivisionGranularity)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r})}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Bl),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,El.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,r,n,i,s){for(const r of Qe(e,500)){const e={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,s);const o=this.layoutVertexArray.length-i,a=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<o;t++)this.centroidVertexArray.emplaceBack(a,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n})}processPolygon(t,e,r,n,i){if(n.length<1)return;if(Xl(n[0]))return;for(const e of n)0!==e.length&&ql(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=i.fill.getGranularityForZoomLevel(e.z),a="Polygon"===Vl.types[r.type];for(const t of n){if(0===t.length)continue;if(Xl(t))continue;const e=_l(t,o,a);this._generateSideFaces(e,s)}if(!a)return;const l=wl(n,e,o,!1),u=this.layoutVertexArray;kl(((t,e)=>{Ul(u,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const i=t[n],s=t[n-1];if(Gl(i,s))continue;e.segment.vertexLength+4>mo.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=i.sub(s)._perp()._unit(),a=s.dist(i);r+a>32768&&(r=0),Ul(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,0,r),Ul(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,1,r),r+=a,Ul(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,r),Ul(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,r);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function ql(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++)}}function Gl(t,e){return t.x===e.x&&(t.x<0||t.x>p)||t.y===e.y&&(t.y<0||t.y>p)}function Xl(t){return t.every((t=>t.x<0))||t.every((t=>t.x>p))||t.every((t=>t.y<0))||t.every((t=>t.y>p))}let Zl;li("FillExtrusionBucket",jl,{omit:["layers","features"]});var Yl={get paint(){return Zl=Zl||new cs({"fill-extrusion-opacity":new ss(M["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new os(M["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new ss(M["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new ss(M["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new as(M["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new os(M["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new os(M["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new ss(M["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Hl extends ps{constructor(t,e){super(t,Yl,e)}createBucket(t){return new jl(t)}queryRadius(){return ca(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:r,featureState:n,geometry:i,transform:s,pixelsToTileUnits:o,pixelPosMatrix:a}){const l=ha(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,o),u=this.paint.get("fill-extrusion-height").evaluate(r,n),c=this.paint.get("fill-extrusion-base").evaluate(r,n),p=function(t,r){const n=[];for(const i of t){const t=[i.x,i.y,0,1];h(t,t,r),n.push(new e(t[0]/t[3],t[1]/t[3]))}return n}(l,a),f=function(t,r,n,i){const s=[],o=[],a=i[8]*r,l=i[9]*r,u=i[10]*r,c=i[11]*r,h=i[8]*n,p=i[9]*n,f=i[10]*n,d=i[11]*n;for(const r of t){const t=[],n=[];for(const s of r){const r=s.x,o=s.y,y=i[0]*r+i[4]*o+i[12],m=i[1]*r+i[5]*o+i[13],g=i[2]*r+i[6]*o+i[14],x=i[3]*r+i[7]*o+i[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,k=x+d,A=new e((y+a)/b,(m+l)/b);A.z=v/b,t.push(A);const I=new e(w/k,_/k);I.z=S/k,n.push(I)}s.push(t),o.push(n)}return[s,o]}(i,c,u,a);return function(t,e,r){let n=1/0;ta(r,e)&&(n=Wl(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],o=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],o[t+1],o[t],e];Ko(r,i)&&(n=Math.min(n,Wl(r,i)))}}return n!==1/0&&n}(f[0],f[1],p)}}function Jl(t,e){return t.x*e.x+t.y*e.y}function Wl(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],o=t[0],a=i.sub(n),l=s.sub(n),u=o.sub(n),c=Jl(a,a),h=Jl(a,l),p=Jl(l,l),f=Jl(u,a),d=Jl(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const Kl=ms([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:Ql}=Kl,tu=ms([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:eu}=tu,ru=Math.cos(Math.PI/180*37.5),nu=Math.pow(2,14)/.5;class iu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new no,this.layoutVertexArray2=new io,this.indexArray=new ho,this.programConfigurations=new Uo(t.layers,t.zoom),this.segments=new mo,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.hasPattern=ja("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:o,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Yo(e,t);if(!this.layers[0]._featureFilter.filter(new Hi(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:o,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?u.geometry:Zo(e),patterns:{},sortKey:c};s.push(h)}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasPattern){const t=qa("line",this.layers,n,{zoom:this.zoom},e);this.patternFeatures.push(t)}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,o,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r})}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,eu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ql),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s){const o=this.layers[0].layout,a=o.get("line-join").evaluate(t,{}),l=o.get("line-cap"),u=o.get("line-miter-limit"),c=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,l,u,c,n,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n})}addLine(t,e,r,n,i,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=_l(t,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===Vl.types[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=t[u-2],g=t[c].sub(f)._unit()._perp());for(let e=c;e<u;e++){if(y=e===u-1?l?t[c+1]:void 0:t[e+1],y&&t[e].equals(y))continue;g&&(m=g),f&&(d=f),f=t[e],g=y?y.sub(f)._unit()._perp():m,m=m||g;let o=m.add(g);0===o.x&&0===o.y||o._unit();const a=m.x*g.x+m.y*g.y,x=o.x*g.x+o.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<ru&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&e>c){const t=f.dist(d);if(t>2*h){const e=f.sub(f.sub(d)._mult(h/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,m,0,0,p),d=e}}const S=d&&y;let k=S?r:l?"butt":n;if(S&&"round"===k&&(v<s?k="miter":v<=2&&(k="fakeround")),"miter"===k&&v>i&&(k="bevel"),"bevel"===k&&(v>2&&(k="flipbevel"),v<i&&(k="miter")),d&&this.updateDistance(d,f),"miter"===k)o._mult(v),this.addCurrentVertex(f,o,0,0,p);else if("flipbevel"===k){if(v>100)o=g.mult(-1);else{const t=v*m.add(g).mag()/m.sub(g).mag();o._perp()._mult(t*(_?-1:1))}this.addCurrentVertex(f,o,0,0,p),this.addCurrentVertex(f,o.mult(-1),0,0,p)}else if("bevel"===k||"fakeround"===k){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(d&&this.addCurrentVertex(f,m,e,r,p),"fakeround"===k){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*t*t+(.848013+a*(.215638*a-1.06021)))}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p)}}y&&this.addCurrentVertex(f,g,-e,-r,p)}else if("butt"===k)this.addCurrentVertex(f,o,0,0,p);else if("square"===k){const t=d?1:-1;this.addCurrentVertex(f,o,t,t,p)}else"round"===k&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&e<u-1){const t=f.dist(y);if(t>2*h){const e=f.add(y.sub(f)._mult(h/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,g,0,0,p),f=e}}}}addCurrentVertex(t,e,r,n,i,s=!1){const o=e.y*n-e.x,a=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,o,a,s,!0,-n,i),this.distance>nu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s))}addHalfVertex({x:t,y:e},r,n,i,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(nu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),a.primitiveLength++),s?this.e2=u:this.e1=u}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let su,ou;li("LineBucket",iu,{omit:["layers","patternFeatures"]});var au={get paint(){return ou=ou||new cs({"line-opacity":new os(M.paint_line["line-opacity"]),"line-color":new os(M.paint_line["line-color"]),"line-translate":new ss(M.paint_line["line-translate"]),"line-translate-anchor":new ss(M.paint_line["line-translate-anchor"]),"line-width":new os(M.paint_line["line-width"]),"line-gap-width":new os(M.paint_line["line-gap-width"]),"line-offset":new os(M.paint_line["line-offset"]),"line-blur":new os(M.paint_line["line-blur"]),"line-dasharray":new ls(M.paint_line["line-dasharray"]),"line-pattern":new as(M.paint_line["line-pattern"]),"line-gradient":new us(M.paint_line["line-gradient"])})},get layout(){return su=su||new cs({"line-cap":new ss(M.layout_line["line-cap"]),"line-join":new os(M.layout_line["line-join"]),"line-miter-limit":new ss(M.layout_line["line-miter-limit"]),"line-round-limit":new ss(M.layout_line["line-round-limit"]),"line-sort-key":new os(M.layout_line["line-sort-key"])})}};class lu extends os{possiblyEvaluate(t,e){return e=new Hi(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=d({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let uu;class cu extends ps{constructor(t,e){super(t,au,e),this.gradientVersion=0,uu||(uu=new lu(au.paint.properties["line-width"].specification),uu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof se,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=uu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new iu(t)}queryRadius(t){const e=t,r=hu(ua("line-width",this,e),ua("line-gap-width",this,e)),n=ua("line-offset",this,e);return r/2+Math.abs(n)+ca(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:r,featureState:n,geometry:i,transform:s,pixelsToTileUnits:o}){const a=ha(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,o),l=o/2*hu(this.paint.get("line-width").evaluate(r,n),this.paint.get("line-gap-width").evaluate(r,n)),u=this.paint.get("line-offset").evaluate(r,n);return u&&(i=function(t,r){const n=[];for(let i=0;i<t.length;i++){const s=t[i],o=[];for(let t=0;t<s.length;t++){const n=s[t-1],i=s[t],a=s[t+1],l=0===t?new e(0,0):i.sub(n)._unit()._perp(),u=t===s.length-1?new e(0,0):a.sub(i)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),o.push(c._mult(r)._add(i))}n.push(o)}return n}(i,u*o)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(aa(t,i[e]))return!0;if(ea(t,i,r))return!0}return!1}(a,i,l)}isTileClipped(){return!0}}function hu(t,e){return e>0?e+2*t:t}const pu=ms([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),fu=ms([{name:"a_projected_pos",components:3,type:"Float32"}],4);ms([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const du=ms([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);ms([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const yu=ms([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4);function mu(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return"uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Yi.applyArabicShaping&&(t=Yi.applyArabicShaping(t)),t}(t.text,e,r)})),t}ms([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4),ms([{name:"triangle",components:3,type:"Uint16"}]),ms([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),ms([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),ms([{type:"Float32",name:"offsetX"}]),ms([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),ms([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const gu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var xu=24;const vu=4294967296,bu=1/vu,wu="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class _u{constructor(t=new Uint8Array(16)){this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length}readFields(t,e,r=this.length){for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,t(n,e,this),this.pos===i&&this.skip(r)}return e}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos)}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*vu;return this.pos+=8,t}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*vu;return this.pos+=8,t}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t}readVarint(t){const e=this.buf;let r,n;return n=e[this.pos++],r=127&n,n<128?r:(n=e[this.pos++],r|=(127&n)<<7,n<128?r:(n=e[this.pos++],r|=(127&n)<<14,n<128?r:(n=e[this.pos++],r|=(127&n)<<21,n<128?r:(n=e[this.pos],r|=(15&n)<<28,function(t,e,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return Su(t,i,e);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return Su(t,i,e);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return Su(t,i,e);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return Su(t,i,e);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return Su(t,i,e);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return Su(t,i,e);throw new Error("Expected varint not more than 10 bytes")}(r,t,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2}readBoolean(){return Boolean(this.readVarint())}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&wu?wu.decode(this.buf.subarray(e,t)):function(t,e,r){let n="",i=e;for(;i<r;){const e=t[i];let s,o,a,l=null,u=e>239?4:e>223?3:e>191?2:1;if(i+u>r)break;1===u?e<128&&(l=e):2===u?(s=t[i+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===u?(s=t[i+1],o=t[i+2],128==(192&s)&&128==(192&o)&&(l=(15&e)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=t[i+1],o=t[i+2],a=t[i+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&e)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u}return n}(this.buf,e,t)}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e}readPackedVarint(t=[],e){const r=this.readPackedEnd();for(;this.pos<r;)t.push(this.readVarint(e));return t}readPackedSVarint(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t}readPackedBoolean(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t}readPackedFloat(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t}readPackedDouble(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t}readPackedFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t}readPackedSFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t}readPackedFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t}readPackedSFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else{if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8}}writeTag(t,e){this.writeVarint(t<<3|e)}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*bu),!0),this.pos+=8}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*bu),!0),this.pos+=8}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(r=~(-t%4294967296),n=~(-t/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7)}(r,0,e),function(t,e){const r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(n,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t)}writeBoolean(t){this.writeVarint(+t)}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,r){for(let n,i,s=0;s<e.length;s++){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128)}return r}(this.buf,t,this.pos);const r=this.pos-e;r>=128&&ku(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let r=0;r<e;r++)this.buf[this.pos++]=t[r]}writeRawMessage(t,e){this.pos++;const r=this.pos;t(e,this);const n=this.pos-r;n>=128&&ku(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n}writeMessage(t,e,r){this.writeTag(t,2),this.writeRawMessage(e,r)}writePackedVarint(t,e){e.length&&this.writeMessage(t,Au,e)}writePackedSVarint(t,e){e.length&&this.writeMessage(t,Iu,e)}writePackedBoolean(t,e){e.length&&this.writeMessage(t,Pu,e)}writePackedFloat(t,e){e.length&&this.writeMessage(t,Mu,e)}writePackedDouble(t,e){e.length&&this.writeMessage(t,zu,e)}writePackedFixed32(t,e){e.length&&this.writeMessage(t,Tu,e)}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,Cu,e)}writePackedFixed64(t,e){e.length&&this.writeMessage(t,Eu,e)}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,Bu,e)}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e)}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e)}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e)}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e)}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e)}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e)}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e)}writeStringField(t,e){this.writeTag(t,2),this.writeString(e)}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e)}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e)}writeBooleanField(t,e){this.writeVarintField(t,+e)}}function Su(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function ku(t,e,r){const n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(let e=r.pos-1;e>=t;e--)r.buf[e+n]=r.buf[e]}function Au(t,e){for(let r=0;r<t.length;r++)e.writeVarint(t[r])}function Iu(t,e){for(let r=0;r<t.length;r++)e.writeSVarint(t[r])}function Mu(t,e){for(let r=0;r<t.length;r++)e.writeFloat(t[r])}function zu(t,e){for(let r=0;r<t.length;r++)e.writeDouble(t[r])}function Pu(t,e){for(let r=0;r<t.length;r++)e.writeBoolean(t[r])}function Tu(t,e){for(let r=0;r<t.length;r++)e.writeFixed32(t[r])}function Cu(t,e){for(let r=0;r<t.length;r++)e.writeSFixed32(t[r])}function Eu(t,e){for(let r=0;r<t.length;r++)e.writeFixed64(t[r])}function Bu(t,e){for(let r=0;r<t.length;r++)e.writeSFixed64(t[r])}function Vu(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();e&&t<n.length&&(n[t]=e)}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return{w:i,h:s,fill:e/(i*s)||0}}class Du{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=o,this.textFitHeight=a}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Fu{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:o}=Vu(i),a=new Pa({width:s||1,height:o||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Pa.copy(n.data,a,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data)}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,o=i.y+1,l=r.data.width,u=r.data.height;Pa.copy(r.data,a,{x:0,y:0},{x:s,y:o},r.data),Pa.copy(r.data,a,{x:0,y:u-1},{x:s,y:o-1},{width:l,height:1}),Pa.copy(r.data,a,{x:0,y:0},{x:s,y:o+u},{width:l,height:1}),Pa.copy(r.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:u}),Pa.copy(r.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:u})}this.image=a,this.iconPositions=r,this.patternPositions=n}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new Du(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e)}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i})}}var $u;li("ImagePosition",Du),li("ImageAtlas",Fu),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}($u||($u={}));class Lu{constructor(){this.scale=1,this.fontStack="",this.imageName=null,this.verticalAlign="bottom"}static forText(t,e,r){const n=new Lu;return n.scale=t||1,n.fontStack=e,n.verticalAlign=r||"bottom",n}static forImage(t,e){const r=new Lu;return r.imageName=t,r.verticalAlign=e||"bottom",r}}class Ou{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null}static fromFeature(t,e){const r=new Ou;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e)}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&ji(n)&&!gu[t[r+1]]||i&&ji(i)&&!gu[t[r-1]]||!gu[t[r]]?t[r]:gu[t[r]]}return e}(this.text)}trim(){let t=0;for(let e=0;e<this.text.length&&Nu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Nu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e)}substring(t,e){const r=new Ou;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if(i.imageName){const n=t[i.imageName];if(!n)continue;const s=n.displaySize;e=Math.max(e,s[0]),r=Math.max(r,s[1])}}return{maxImageWidth:e,maxImageHeight:r}}addTextSection(t,e){this.text+=t.text,this.sections.push(Lu.forText(t.scale,t.fontStack||e,t.verticalAlign));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r)}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void x("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Lu.forImage(e,t.verticalAlign)),this.sectionIndex.push(this.sections.length-1)):x("Reached maximum number of images 6401")}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Ru(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d){const y=Ou.fromFeature(t,i);let m;h===$u.vertical&&y.verticalizePunctuation();const{processBidirectionalText:g,processStyledBidirectionalText:x}=Yi;if(g&&1===y.sections.length){m=[];const t=g(y.toString(),Hu(y,u,s,e,n,f));for(const e of t){const t=new Ou;t.text=e,t.sections=y.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);m.push(t)}}else if(x){m=[];const t=x(y.text,y.sectionIndex,Hu(y,u,s,e,n,f));for(const e of t){const t=new Ou;t.text=e[0],t.sectionIndex=e[1],t.sections=y.sections,m.push(t)}}else m=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(y,Hu(y,u,s,e,n,f));const v=[],b={positionedLines:v,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,o,a,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===a?1:"left"===a?0:.5,g=xu/h;let x=0;for(const o of i){o.trim();const i=o.getMaxScale(),a={positionedGlyphs:[],lineOffset:0};t.positionedLines[x]=a;const h=a.positionedGlyphs;let v=0;if(!o.length()){f+=s,++x;continue}const b=Wu(n,o,g);for(let s=0;s<o.length();s++){const a=o.getSection(s),d=o.getSectionIndex(s),y=o.getCharCode(s),m=Qu(l,c,y);let x;if(a.imageName){if(t.iconsInText=!0,a.scale=a.scale*g,x=ec(a,m,i,b,n),!x)continue;v=Math.max(v,x.imageOffset)}else if(x=tc(a,y,m,b,e,r),!x)continue;const{rect:w,metrics:_,baselineOffset:S}=x;h.push({glyph:y,imageName:a.imageName,x:p,y:f+S+-17,vertical:m,scale:a.scale,fontStack:a.fontStack,sectionIndex:d,metrics:_,rect:w}),m?(t.verticalizable=!0,p+=(a.imageName?_.advance:xu)*a.scale+u):p+=_.advance*a.scale+u}0!==h.length&&(d=Math.max(p-u,d),rc(h,0,h.length-1,m)),p=0,a.lineOffset=Math.max(v,(i-1)*xu);const w=s*i+v;f+=w,y=Math.max(w,y),++x}const{horizontalAlign:v,verticalAlign:b}=Ju(o);(function(t,e,r,n,i,s,o,a,l){const u=(e-r)*i;let c=0;c=s!==o?-a*n- -17:-n*l*o+.5*o;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c})(t.positionedLines,m,v,b,d,y,s,f,i.length),t.top+=-b*f,t.bottom=t.top+f,t.left+=-v*d,t.right=t.left+d}(b,e,r,n,m,o,a,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return!1;return!0}(v)&&b}const Nu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Uu={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},ju={40:!0};function qu(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*xu/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function Gu(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Xu(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Zu(t,e,r,n,i,s){let o=null,a=Gu(e,r,i,s);for(const t of n){const n=Gu(e-t.x,r,i,s)+t.badness;n<=a&&(o=t,a=n)}return{index:t,x:e,priorBreak:o,badness:a}}function Yu(t){return t?Yu(t.priorBreak).concat(t.index):[]}function Hu(t,e,r,n,i,s){if(!t)return[];const o=[],a=function(t,e,r,n,i,s){let o=0;for(let r=0;r<t.length();r++){const a=t.getSection(r);o+=qu(t.getCharCode(r),a,n,i,e,s)}return o/Math.max(1,Math.ceil(o/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(Nu[p]||(u+=qu(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904)&&(!!Bi(c)||!!Ci(c)||!!Pi(c)||!!Mi(c)||!!Ti(c)||!!Di(c)||!!Ii(c)||!!Ei(c)||Ni.test(String.fromCodePoint(c)));(Uu[p]||e||h.imageName||r!==t.length()-2&&ju[t.getCharCode(r+1)])&&o.push(Zu(r+1,u,a,o,Xu(p,t.getCharCode(r+1),e&&l),!1))}}var c;return Yu(Zu(t.length(),u,a,o,0,!0))}function Ju(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0}return{horizontalAlign:e,verticalAlign:r}}function Wu(t,e,r){const n=e.getMaxScale()*xu,{maxImageWidth:i,maxImageHeight:s}=e.getMaxImageSize(t),o=Math.max(n,s*r);return{verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:o}}function Ku(t){switch(t){case"top":return 0;case"center":return.5;default:return 1}}function Qu(t,e,r){return!(t===$u.horizontal||!e&&!Ui(r)||e&&(Nu[r]||(n=r,/\p{sc=Arab}/u.test(String.fromCodePoint(n)))));var n}function tc(t,e,r,n,i,s){const o=s[t.fontStack],a=function(t,e,r,n){if(t&&t.rect)return t;const i=e[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(o&&o[e],i,t,e);if(null===a)return null;let l;if(r)l=n.verticalLineContentWidth-t.scale*xu;else{const e=Ku(t.verticalAlign);l=(n.horizontalLineContentHeight-t.scale*xu)*e}return{rect:a.rect,metrics:a.metrics,baselineOffset:l}}function ec(t,e,r,n,i){const s=i[t.imageName];if(!s)return null;const o=s.paddedRect,a=s.displaySize,l={width:a[0],height:a[1],left:1,top:-3,advance:e?a[1]:a[0]};let u;if(e)u=n.verticalLineContentWidth-a[1]*t.scale;else{const e=Ku(t.verticalAlign);u=(n.horizontalLineContentHeight-a[1]*t.scale)*e}return{rect:o,metrics:l,baselineOffset:u,imageOffset:(e?a[0]:a[1])*t.scale-xu*r}}function rc(t,e,r,n){if(0===n)return;const i=t[r],s=(t[r].x+i.metrics.advance*i.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s}function nc(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Ju(r),s=e[0]-t.displaySize[0]*n,o=e[1]-t.displaySize[1]*i;return{image:t,top:o,bottom:o+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function ic(t){var e,r;let n=t.left,i=t.top,s=t.right-n,o=t.bottom-i;const a=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===a&&s/o<u||"proportional"===a){const t=Math.ceil(o*u);n*=t/s,s=t}}else if("proportional"===a&&"stretchOnly"===l&&0!==u&&s/o>u){const t=Math.ceil(s/u);i*=t/o,o=t}return{x1:n,y1:i,x2:n+s,y2:i+o}}function sc(t,e,r,n,i,s){const o=t.image;let a;if(o.content){const t=o.content,e=o.pixelRatio||1;a=[t[0]/e,t[1]/e,o.displaySize[0]-t[2]/e,o.displaySize[1]-t[3]/e]}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-o.displaySize[0])/2,h=f+o.displaySize[0]);const d=e.top*s,y=e.bottom*s;return"height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-o.displaySize[1])/2,p=c+o.displaySize[1]),{image:o,top:c,right:h,bottom:p,left:f,collisionPadding:a}}const oc=128,ac=32640;function lc(t,e){const{expression:r}=e;if("constant"===r.kind)return{kind:"constant",layoutSize:r.evaluate(new Hi(t+1))};if("source"===r.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const o=e[i],a=e[s];return"composite"===r.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:n}:{kind:"camera",minZoom:o,maxZoom:a,minSize:r.evaluate(new Hi(o)),maxSize:r.evaluate(new Hi(a)),interpolationType:n}}}function uc(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const cc=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function hc(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=a?Math.min(ac,Math.round(a[0])):0,d=a?Math.min(ac,Math.round(a[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,o,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p)}function pc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r)}function fc(t){for(const e of t.sections)if(Zi(e.text))return!0;return!1}class dc{constructor(t){this.layoutVertexArray=new oo,this.indexArray=new ho,this.programConfigurations=t,this.segments=new mo,this.dynamicLayoutVertexArray=new ao,this.opacityVertexArray=new lo,this.hasVisibleVertices=!1,this.placedSymbolArray=new qs}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,pu.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,fu.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,cc,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}li("SymbolBuffers",dc);class yc{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new mo,this.collisionVertexArray=new co}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,du.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}li("CollisionBuffers",yc);class mc{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=lc(this.zoom,e["text-size"]),this.iconSizeData=lc(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap="never"!==uc(r,"text-overlap","text-allow-overlap")||"never"!==uc(r,"icon-overlap","icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&!n.isConstant(),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map((t=>$u[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new dc(new Uo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new dc(new Uo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Zs,this.lineVertexArray=new Ys,this.symbolInstances=new Xs,this.textAnchorOffsets=new Js}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=gu[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0)}}populate(t,e,r){const n=this.layers[0],i=n.layout,s=i.get("text-font"),o=i.get("text-field"),a=i.get("icon-image"),l=("constant"!==o.value.kind||o.value.value instanceof Pt&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),u="constant"!==a.value.kind||!!a.value.value||Object.keys(a.parameters).length>0,c=i.get("symbol-sort-key");if(this.features=[],!l&&!u)return;const h=e.iconDependencies,p=e.glyphDependencies,f=e.availableImages,d=new Hi(this.zoom);for(const{feature:e,id:o,index:a,sourceLayerIndex:y}of t){const t=n._featureFilter.needGeometry,m=Yo(e,t);if(!n._featureFilter.filter(d,m,r))continue;let g,x;if(t||(m.geometry=Zo(e)),l){const t=n.getValueAndResolveTokens("text-field",m,r,f),e=Pt.factory(t),i=this.hasRTLText=this.hasRTLText||fc(e);(!i||"unavailable"===Yi.getRTLTextPluginStatus()||i&&Yi.isParsed())&&(g=mu(e,n,m))}if(u){const t=n.getValueAndResolveTokens("icon-image",m,r,f);x=t instanceof Ft?t:Ft.fromString(t)}if(!g&&!x)continue;const v=this.sortFeaturesByKey?c.evaluate(m,{},r):void 0;if(this.features.push({id:o,text:g,icon:x,index:a,sourceLayerIndex:y,geometry:m.geometry,properties:e.properties,type:Vl.types[e.type],sortKey:v}),x&&(h[x.name]=!0),g){const t=s.evaluate(m,{},r).join(","),e="viewport"!==i.get("text-rotation-alignment")&&"point"!==i.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf($u.vertical)>=0;for(const r of g.sections)if(r.image)h[r.image.name]=!0;else{const n=Fi(g.toString()),i=r.fontStack||t,s=p[i]=p[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n)}}}"line"===i.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++}function o(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function a(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return`${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=a(f,d,h),i=o(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null}else f in r?o(f,d,h):d in e?a(f,d,h):(s(u),e[f]=i-1,r[d]=i-1)}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r}),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r}))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,o,a,l,u,c,h){const p=t.indexArray,f=t.layoutVertexArray,d=t.segments.prepareSegment(4*e.length,f,p,this.canOverlap?s.sortKey:void 0),y=this.glyphOffsetArray.length,m=d.vertexLength,g=this.allowVerticalPlacement&&o===$u.vertical?Math.PI/2:0,x=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:o,bl:l,br:u,tex:c,pixelOffsetTL:y,pixelOffsetBR:m,minFontScaleX:v,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=e[n],k=d.vertexLength,A=w[1];hc(f,a.x,a.y,i.x,A+i.y,c.x,c.y,r,_,y.x,y.y,v,b),hc(f,a.x,a.y,o.x,A+o.y,c.x+c.w,c.y,r,_,m.x,y.y,v,b),hc(f,a.x,a.y,l.x,A+l.y,c.x,c.y+c.h,r,_,y.x,m.y,v,b),hc(f,a.x,a.y,u.x,A+u.y,c.x+c.w,c.y+c.h,r,_,m.x,m.y,v,b),pc(t.dynamicLayoutVertexArray,a,g),p.emplaceBack(k,k+2,k+1),p.emplaceBack(k+1,k+2,k+3),d.vertexLength+=4,d.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),n!==e.length-1&&S===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(f.length,s,s.index,{imagePositions:{},canonical:h,formattedSection:x&&x[S]})}t.placedSymbolArray.emplaceBack(a.x,a.y,y,this.glyphOffsetArray.length-y,m,l,u,a.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],o,0,!1,0,c)}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,r,n,i,s,o,a){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),u=l.vertexLength,c=s.layoutVertexArray,h=s.collisionVertexArray,p=a.anchorX,f=a.anchorY;this._addCollisionDebugVertex(c,h,o,p,f,new e(t,r)),this._addCollisionDebugVertex(c,h,o,p,f,new e(n,r)),this._addCollisionDebugVertex(c,h,o,p,f,new e(n,i)),this._addCollisionDebugVertex(c,h,o,p,f,new e(t,i)),l.vertexLength+=4;const d=s.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new yc(uo,yu.members,po),this.iconCollisionBox=new yc(uo,yu.members,po);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,o,a,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<o;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=a;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);n.push(0|Math.round(e*o.anchorX+r*o.anchorY)),i.push(o.featureIndex)}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let gc,xc;li("SymbolBucket",mc,{omit:["layers","collisionBoxArray","features","compareText"]}),mc.MAX_GLYPHS=65535,mc.addDynamicAttributes=pc;var vc={get paint(){return xc=xc||new cs({"icon-opacity":new os(M.paint_symbol["icon-opacity"]),"icon-color":new os(M.paint_symbol["icon-color"]),"icon-halo-color":new os(M.paint_symbol["icon-halo-color"]),"icon-halo-width":new os(M.paint_symbol["icon-halo-width"]),"icon-halo-blur":new os(M.paint_symbol["icon-halo-blur"]),"icon-translate":new ss(M.paint_symbol["icon-translate"]),"icon-translate-anchor":new ss(M.paint_symbol["icon-translate-anchor"]),"text-opacity":new os(M.paint_symbol["text-opacity"]),"text-color":new os(M.paint_symbol["text-color"],{runtimeType:$,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new os(M.paint_symbol["text-halo-color"]),"text-halo-width":new os(M.paint_symbol["text-halo-width"]),"text-halo-blur":new os(M.paint_symbol["text-halo-blur"]),"text-translate":new ss(M.paint_symbol["text-translate"]),"text-translate-anchor":new ss(M.paint_symbol["text-translate-anchor"])})},get layout(){return gc=gc||new cs({"symbol-placement":new ss(M.layout_symbol["symbol-placement"]),"symbol-spacing":new ss(M.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new ss(M.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new os(M.layout_symbol["symbol-sort-key"]),"symbol-z-order":new ss(M.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new ss(M.layout_symbol["icon-allow-overlap"]),"icon-overlap":new ss(M.layout_symbol["icon-overlap"]),"icon-ignore-placement":new ss(M.layout_symbol["icon-ignore-placement"]),"icon-optional":new ss(M.layout_symbol["icon-optional"]),"icon-rotation-alignment":new ss(M.layout_symbol["icon-rotation-alignment"]),"icon-size":new os(M.layout_symbol["icon-size"]),"icon-text-fit":new ss(M.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new ss(M.layout_symbol["icon-text-fit-padding"]),"icon-image":new os(M.layout_symbol["icon-image"]),"icon-rotate":new os(M.layout_symbol["icon-rotate"]),"icon-padding":new os(M.layout_symbol["icon-padding"]),"icon-keep-upright":new ss(M.layout_symbol["icon-keep-upright"]),"icon-offset":new os(M.layout_symbol["icon-offset"]),"icon-anchor":new os(M.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new ss(M.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new ss(M.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new ss(M.layout_symbol["text-rotation-alignment"]),"text-field":new os(M.layout_symbol["text-field"]),"text-font":new os(M.layout_symbol["text-font"]),"text-size":new os(M.layout_symbol["text-size"]),"text-max-width":new os(M.layout_symbol["text-max-width"]),"text-line-height":new ss(M.layout_symbol["text-line-height"]),"text-letter-spacing":new os(M.layout_symbol["text-letter-spacing"]),"text-justify":new os(M.layout_symbol["text-justify"]),"text-radial-offset":new os(M.layout_symbol["text-radial-offset"]),"text-variable-anchor":new ss(M.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new os(M.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new os(M.layout_symbol["text-anchor"]),"text-max-angle":new ss(M.layout_symbol["text-max-angle"]),"text-writing-mode":new ss(M.layout_symbol["text-writing-mode"]),"text-rotate":new os(M.layout_symbol["text-rotate"]),"text-padding":new ss(M.layout_symbol["text-padding"]),"text-keep-upright":new ss(M.layout_symbol["text-keep-upright"]),"text-transform":new os(M.layout_symbol["text-transform"]),"text-offset":new os(M.layout_symbol["text-offset"]),"text-allow-overlap":new ss(M.layout_symbol["text-allow-overlap"]),"text-overlap":new ss(M.layout_symbol["text-overlap"]),"text-ignore-placement":new ss(M.layout_symbol["text-ignore-placement"]),"text-optional":new ss(M.layout_symbol["text-optional"])})}};class bc{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:B,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}li("FormatSectionOverride",bc,{omit:["defaultValue"]});class wc extends ps{constructor(t,e){super(t,vc,e)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||tn(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new mc(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of vc.paint.overridableProperties){if(!wc.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new bc(e),n=new Qr(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new rn("source",n):new nn("composite",n,e.value.zoomStops),this.paint._values[t]=new ns(e.property,i,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,r){return!(!this.layout||e.isDataDriven()||r.isDataDriven())&&wc.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=vc.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Pt)s(r.value.value.sections);else if("source"===r.value.kind||"composite"===r.value.kind){const t=e=>{i||(e instanceof Ut&&Rt(e.value)===U?s(e.value.sections):e instanceof Ie?s(e.sections):e.eachChild(t))},e=r.value;e._styleExpression&&t(e._styleExpression.expression)}return i}}let _c;var Sc={get paint(){return _c=_c||new cs({"background-color":new ss(M.paint_background["background-color"]),"background-pattern":new ls(M.paint_background["background-pattern"]),"background-opacity":new ss(M.paint_background["background-opacity"])})}};class kc extends ps{constructor(t,e){super(t,Sc,e)}}let Ac;var Ic,Mc={get paint(){return Ac=Ac||new cs({"raster-opacity":new ss(M.paint_raster["raster-opacity"]),"raster-hue-rotate":new ss(M.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new ss(M.paint_raster["raster-brightness-min"]),"raster-brightness-max":new ss(M.paint_raster["raster-brightness-max"]),"raster-saturation":new ss(M.paint_raster["raster-saturation"]),"raster-contrast":new ss(M.paint_raster["raster-contrast"]),"raster-resampling":new ss(M.paint_raster["raster-resampling"]),"raster-fade-duration":new ss(M.paint_raster["raster-fade-duration"])})}};class zc extends ps{constructor(t,e){super(t,Mc,e)}}class Pc extends ps{constructor(t,e){super(t,{},e),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function Tc(t,e){if("custom"===t.type)return new Pc(t,e);switch(t.type){case"background":return new kc(t,e);case"circle":return new wa(t,e);case"color-relief":return new Ra(t,e);case"fill":return new Tl(t,e);case"fill-extrusion":return new Hl(t,e);case"heatmap":return new Ca(t,e);case"hillshade":return new Va(t,e);case"line":return new cu(t,e);case"raster":return new zc(t,e);case"symbol":return new wc(t,e)}}class Cc{constructor(t,e){this.keyCache={},t&&this.replace(t,e)}replace(t,e){this._layerConfigs={},this._layers={},this.update(t,[],e)}update(t,e,r){for(const e of t){this._layerConfigs[e.id]=e;const t=this._layers[e.id]=Tc(e,r);t._featureFilter=hn(t.filter,r),this.keyCache[e.id]&&delete this.keyCache[e.id]}for(const t of e)delete this.keyCache[t],delete this._layerConfigs[t],delete this._layers[t];this.familiesBySource={};const n=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||bn(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n])}const n=[];for(const t in r)n.push(r[t]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const t of n){const e=t.map((t=>this._layers[t.id])),r=e[0];if("none"===r.visibility)continue;const n=r.source||"";let i=this.familiesBySource[n];i||(i=this.familiesBySource[n]={});const s=r.sourceLayer||"_geojsonTileLayer";let o=i[s];o||(o=i[s]=[]),o.push(e)}}}class Ec{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class Bc{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class Vc{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const r=new Vc;return r.extend(t(new e(this.minX,this.minY))),r.extend(t(new e(this.maxX,this.minY))),r.extend(t(new e(this.minX,this.maxY))),r.extend(t(new e(this.maxX,this.maxY))),r}static fromPoints(t){const e=new Vc;for(const r of t)e.extend(r);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return!this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return!this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class Dc{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new I(p,16,0),this.grid3D=new I(p,16,0),this.featureIndexArray=new Ks,this.promoteId=e}insert(t,e,r,n,i,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const a=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y)}n[0]<p&&n[1]<p&&n[2]>=0&&n[3]>=0&&a.insert(o,n[0],n[1],n[2],n[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Ol(new _u(this.rawTileData)).layers,this.sourceLayerCoder=new Ec(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,r,n,i){this.loadVTLayers();const s=t.params,o=p/t.tileSize/t.scale,a=hn(s.filter,s.globalState),l=t.queryGeometry,u=t.queryPadding*o,c=Vc.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),f=Vc.fromPoints(t.cameraQueryGeometry).expandBy(u),d=this.grid3D.query(f.minX,f.minY,f.maxX,f.maxY,((r,n,i,s)=>function(t,r,n,i,s){for(const e of t)if(r<=e.x&&n<=e.y&&i>=e.x&&s>=e.y)return!0;const o=[new e(r,n),new e(r,s),new e(i,s),new e(i,n)];if(t.length>2)for(const e of o)if(aa(t,e))return!0;for(let e=0;e<t.length-1;e++)if(la(t[e],t[e+1],o))return!0;return!1}(t.cameraQueryGeometry,r-u,n-u,i+u,s+u)));for(const t of d)h.push(t);h.sort($c);const y={};let m;for(let e=0;e<h.length;e++){const u=h[e];if(u===m)continue;m=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(y,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,a,s.layers,s.availableImages,r,n,i,((e,r,n)=>(p||(p=Zo(e)),r.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:n,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:o,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))))}return y}loadMatchingFeature(t,e,r,n,i,s,o,a,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!h.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=Yo(f,!0);if(!i.filter(new Hi(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new Hi(this.tileID.overscaledZ),f))return;const y=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&!s.has(r))continue;const i=a[r];if(!i)continue;let p={};y&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",y));const m=d({},l[r]);m.paint=Fc(m.paint,i.paint,f,p,o),m.layout=Fc(m.layout,i.layout,f,p,o);const g=!c||c(f,i,p);if(!g)continue;const x=new Bc(f,this.z,this.x,this.y,y);x.layer=m;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:n,feature:x,intersectionZ:g})}}lookupSymbolFeatures(t,e,r,n,i,s,o,a){const l={};this.loadVTLayers();const u=hn(i.filterSpec,i.globalState);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,o,a,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return!0;return!1}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n}}function Fc(t,e,r,n,i){return y(t,((t,s)=>{const o=e instanceof is?e.get(s):null;return o&&o.evaluate?o.evaluate(r,n,i):o}))}function $c(t,e){return e-t}li("FeatureIndex",Dc,{omit:["rawTileData","sourceLayerCoder"]});class Lc extends e{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n)}clone(){return new Lc(this.x,this.y,this.angle,this.segment)}}function Oc(t,e,r,n,i){if(void 0===e.segment||0===r)return!0;let s=e,o=e.segment+1,a=0;for(;a>-r/2;){if(o--,o<0)return!1;a-=t[o].dist(s),s=t[o]}a+=t[o].dist(t[o+1]),o++;const l=[];let u=0;for(;a<r/2;){const e=t[o],r=t[o+1];if(!r)return!1;let s=t[o-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:a,angleDelta:s}),u+=s;a-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return!1;o++,a+=e.dist(r)}return!0}function Rc(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Nc(t,e,r){return t?.6*e*r:0}function Uc(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function jc(t,e,r,n,i,s){const o=Nc(r,i,s),a=Uc(r,n)*s;let l=0;const u=Rc(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=fe.number(n.x,i.x,c),p=fe.number(n.y,i.y,c),f=new Lc(h,p,i.angleTo(n),r);return f._round(),!o||Oc(t,f,a,o,e)?f:void 0}l+=s}}function qc(t,e,r,n,i,s,o,a,l){const u=Nc(n,s,o),c=Uc(n,i),h=c*o,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),Gc(t,p?e/2*a%e:(c/2+2*s)*o*a%e,e,u,r,h,p,!1,l)}function Gc(t,e,r,n,i,s,o,a,l){const u=s/2,c=Rc(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const o=t[e],a=t[e+1],d=o.dist(a),y=a.angleTo(o);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=fe.number(o.x,a.x,m),x=fe.number(o.y,a.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Lc(g,x,y,e);r._round(),n&&!Oc(t,r,s,n,i)||f.push(r)}}h+=d}return a||f.length||o||(f=Gc(t,h/2,r,n,i,s,o,!0,l)),f}function Xc(t,r,n,i){const s=[],o=t.image,a=o.pixelRatio,l=o.paddedRect.w-2,u=o.paddedRect.h-2;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=o.stretchX||[[0,l]],p=o.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,k=0,A=g;if(o.content&&i){const e=o.content,r=e[2]-e[0],n=e[3]-e[1];(o.textFitWidth||o.textFitHeight)&&(c=ic(t)),x=Zc(h,0,e[0]),b=Zc(p,0,e[1]),v=Zc(h,e[0],e[2]),w=Zc(p,e[1],e[3]),_=e[0]-x,k=e[1]-b,S=r-v,A=n-w}const I=c.x1,M=c.y1,z=c.x2-I,P=c.y2-M,T=(t,i,s,l)=>{const u=Hc(t.stretch-x,v,z,I),c=Jc(t.fixed-_,S,t.stretch,d),h=Hc(i.stretch-b,w,P,M),p=Jc(i.fixed-k,A,i.stretch,y),f=Hc(s.stretch-x,v,z,I),m=Jc(s.fixed-_,S,s.stretch,d),g=Hc(l.stretch-b,w,P,M),T=Jc(l.fixed-k,A,l.stretch,y),C=new e(u,h),E=new e(f,h),B=new e(f,g),V=new e(u,g),D=new e(c/a,p/a),F=new e(m/a,T/a),$=r*Math.PI/180;if($){const t=Math.sin($),e=Math.cos($),r=[e,-t,t,e];C._matMult(r),E._matMult(r),V._matMult(r),B._matMult(r)}const L=t.stretch+t.fixed,O=i.stretch+i.fixed;return{tl:C,tr:E,bl:V,br:B,tex:{x:o.paddedRect.x+1+L,y:o.paddedRect.y+1+O,w:s.stretch+s.fixed-L,h:l.stretch+l.fixed-O},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:D,pixelOffsetBR:F,minFontScaleX:S/a/z,minFontScaleY:A/a/P,isSDF:n}};if(i&&(o.stretchX||o.stretchY)){const t=Yc(h,m,d),e=Yc(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(T(n,e[t],i,e[t+1]))}}else s.push(T({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Zc(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Yc(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)})}return n.push({fixed:e+1,stretch:r}),n}function Hc(t,e,r,n){return t/e*r+n}function Jc(t,e,r,n){return t-e*r/n}li("Anchor",Lc);class Wc{constructor(t,r,n,i,s,o,a,l,u,c){var h;if(this.boxStartIndex=t.length,u){let t=o.top,e=o.bottom;const r=o.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n)}else{const u=(null===(h=o.image)||void 0===h?void 0:h.content)&&(o.image.textFitWidth||o.image.textFitHeight)?ic(o):{x1:o.left,y1:o.top,x2:o.right,y2:o.bottom};u.y1=u.y1*a-l[0],u.y2=u.y2*a+l[2],u.x1=u.x1*a-l[3],u.x2=u.x2*a+l[1];const p=o.collisionPadding;if(p&&(u.x1-=p[0]*a,u.y1-=p[1]*a,u.x2+=p[2]*a,u.y2+=p[3]*a),c){const t=new e(u.x1,u.y1),r=new e(u.x2,u.y1),n=new e(u.x1,u.y2),i=new e(u.x2,u.y2),s=c*Math.PI/180;t._rotate(s),r._rotate(s),n._rotate(s),i._rotate(s),u.x1=Math.min(t.x,r.x,n.x,i.x),u.x2=Math.max(t.x,r.x,n.x,i.x),u.y1=Math.min(t.y,r.y,n.y,i.y),u.y2=Math.max(t.y,r.y,n.y,i.y)}t.emplaceBack(r.x,r.y,u.x1,u.y1,u.x2,u.y2,n,i,s)}this.boxEndIndex=t.length}}class Kc{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i}e[t]=n}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n}e[t]=i}}function Qc(t,r=1,n=!1){const i=Vc.fromPoints(t[0]),s=Math.min(i.width(),i.height());let o=s/2;const a=new Kc([],th),{minX:l,minY:u,maxX:c,maxY:h}=i;if(0===s)return new e(l,u);for(let e=l;e<c;e+=s)for(let r=u;r<h;r+=s)a.push(new eh(e+o,r+o,o,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,o=s-1;t<s;o=t++){const s=i[t],a=i[o],l=s.x*a.y-a.x*s.y;r+=(s.x+a.x)*l,n+=(s.y+a.y)*l,e+=3*l}return new eh(r/e,n/e,0,t)}(t),f=a.length;for(;a.length;){const e=a.pop();(e.d>p.d||!p.d)&&(p=e,n&&console.log("found best %d after %d probes",Math.round(1e4*e.d)/1e4,f)),e.max-p.d<=r||(o=e.h/2,a.push(new eh(e.p.x-o,e.p.y-o,o,t)),a.push(new eh(e.p.x+o,e.p.y-o,o,t)),a.push(new eh(e.p.x-o,e.p.y+o,o,t)),a.push(new eh(e.p.x+o,e.p.y+o,o,t)),f+=4)}return n&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function th(t,e){return e.max-t.max}function eh(t,r,n,i){this.p=new e(t,r),this.h=n,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,o=i-1;e<i;o=e++){const i=s[e],a=s[o];i.y>t.y!=a.y>t.y&&t.x<(a.x-i.x)*(t.y-i.y)/(a.y-i.y)+i.x&&(r=!r),n=Math.min(n,sa(t,i,a))}}return(r?1:-1)*Math.sqrt(n)}(this.p,i),this.max=this.d+this.h*Math.SQRT2}!function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(Ic||(Ic={}));const rh=Number.POSITIVE_INFINITY;function nh(t,e){return e[1]!==rh?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e}return[n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-e;break;case"top":n=e-7}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e}return[r,n]}(t,e[0])}function ih(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*xu));n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),e[r+1]=i}return new Dt(e)}const o=i.get("text-variable-anchor");if(o){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*xu,rh]:i.get("text-offset").evaluate(e,{},r).map((t=>t*xu));const s=[];for(const t of o)s.push(t,nh(t,n));return new Dt(s)}return null}function sh(t){t.bucket.createArrays(),t.bucket.tilePixelRatio=p/(512*t.bucket.overscaling),t.bucket.compareText={},t.bucket.iconsNeedLinear=!1;const e=t.bucket.layers[0],r=e.layout,n=e._unevaluatedLayout._values,i={layoutIconSize:n["icon-size"].possiblyEvaluate(new Hi(t.bucket.zoom+1),t.canonical),layoutTextSize:n["text-size"].possiblyEvaluate(new Hi(t.bucket.zoom+1),t.canonical),textMaxSize:n["text-size"].possiblyEvaluate(new Hi(18))};if("composite"===t.bucket.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.textSizeData;i.compositeTextSizes=[n["text-size"].possiblyEvaluate(new Hi(e),t.canonical),n["text-size"].possiblyEvaluate(new Hi(r),t.canonical)]}if("composite"===t.bucket.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.iconSizeData;i.compositeIconSizes=[n["icon-size"].possiblyEvaluate(new Hi(e),t.canonical),n["icon-size"].possiblyEvaluate(new Hi(r),t.canonical)]}const s=r.get("text-line-height")*xu,o="viewport"!==r.get("text-rotation-alignment")&&"point"!==r.get("symbol-placement"),a=r.get("text-keep-upright"),l=r.get("text-size");for(const n of t.bucket.features){const u=r.get("text-font").evaluate(n,{},t.canonical).join(","),c=l.evaluate(n,{},t.canonical),h=i.layoutTextSize.evaluate(n,{},t.canonical),p=i.layoutIconSize.evaluate(n,{},t.canonical),f={horizontal:{},vertical:void 0},d=n.text;let y,m=[0,0];if(d){const i=d.toString(),l=r.get("text-letter-spacing").evaluate(n,{},t.canonical)*xu,p=$i(i)?l:0,y=r.get("text-anchor").evaluate(n,{},t.canonical),g=ih(e,n,t.canonical);if(!g){const e=r.get("text-radial-offset").evaluate(n,{},t.canonical);m=e?nh(y,[e*xu,rh]):r.get("text-offset").evaluate(n,{},t.canonical).map((t=>t*xu))}let x=o?"center":r.get("text-justify").evaluate(n,{},t.canonical);const v="point"===r.get("symbol-placement")?r.get("text-max-width").evaluate(n,{},t.canonical)*xu:1/0,b=()=>{t.bucket.allowVerticalPlacement&&Fi(i)&&(f.vertical=Ru(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,y,"left",p,m,$u.vertical,!0,h,c))};if(!o&&g){const e=new Set;if("auto"===x)for(let t=0;t<g.values.length;t+=2)e.add(oh(g.values[t]));else e.add(x);let r=!1;for(const n of e)if(!f.horizontal[n])if(r)f.horizontal[n]=f.horizontal[0];else{const e=Ru(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,"center",n,p,m,$u.horizontal,!1,h,c);e&&(f.horizontal[n]=e,r=1===e.positionedLines.length)}b()}else{"auto"===x&&(x=oh(y));const e=Ru(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,y,x,p,m,$u.horizontal,!1,h,c);e&&(f.horizontal[x]=e),b(),Fi(i)&&o&&a&&(f.vertical=Ru(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,y,x,p,m,$u.vertical,!1,h,c))}}let g=!1;if(n.icon&&n.icon.name){const e=t.imageMap[n.icon.name];e&&(y=nc(t.imagePositions[n.icon.name],r.get("icon-offset").evaluate(n,{},t.canonical),r.get("icon-anchor").evaluate(n,{},t.canonical)),g=!!e.sdf,void 0===t.bucket.sdfIcons?t.bucket.sdfIcons=g:t.bucket.sdfIcons!==g&&x("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.bucket.pixelRatio||0!==r.get("icon-rotate").constantOr(1))&&(t.bucket.iconsNeedLinear=!0))}const v=uh(f.horizontal)||f.vertical;t.bucket.iconsInText=!!v&&v.iconsInText,(v||y)&&ah(t.bucket,n,f,y,t.imageMap,i,h,p,m,g,t.canonical,t.subdivisionGranularity)}t.showCollisionBoxes&&t.bucket.generateCollisionDebugBuffers()}function oh(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}function ah(t,r,n,i,s,o,a,l,u,c,h,f){let d=o.textMaxSize.evaluate(r,{});void 0===d&&(d=a);const y=t.layers[0].layout,m=y.get("icon-offset").evaluate(r,{},h),g=uh(n.horizontal),v=a/24,b=t.tilePixelRatio*v,w=t.tilePixelRatio*d/24,_=t.tilePixelRatio*l,S=t.tilePixelRatio*y.get("symbol-spacing"),k=y.get("text-padding")*t.tilePixelRatio,A=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return[s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(y,r,h,t.tilePixelRatio),I=y.get("text-max-angle")/180*Math.PI,M="viewport"!==y.get("text-rotation-alignment")&&"point"!==y.get("symbol-placement"),z="map"===y.get("icon-rotation-alignment")&&"point"!==y.get("symbol-placement"),P=y.get("symbol-placement"),T=S/2,C=y.get("icon-text-fit");let E;i&&"none"!==C&&(t.allowVerticalPlacement&&n.vertical&&(E=sc(i,n.vertical,C,y.get("icon-text-fit-padding"),m,v)),g&&(i=sc(i,g,C,y.get("icon-text-fit-padding"),m,v)));const B=h?f.line.getGranularityForZoomLevel(h.z):1,V=(e,l)=>{l.x<0||l.x>=p||l.y<0||l.y>=p||function(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,v,b,w,_,S,k,A){const I=t.addToLineVertexArray(e,r);let M,z,P,T,C=0,E=0,B=0,V=0,D=-1,F=-1;const $={};let L=Io("");if(t.allowVerticalPlacement&&n.vertical){const t=a.layout.get("text-rotate").evaluate(w,{},k)+90;P=new Wc(l,e,u,c,h,n.vertical,p,f,d,t),o&&(T=new Wc(l,e,u,c,h,o,m,g,d,t))}if(i){const r=a.layout.get("icon-rotate").evaluate(w,{}),n="none"!==a.layout.get("icon-text-fit"),s=Xc(i,r,S,n),p=o?Xc(o,r,S,n):void 0;z=new Wc(l,e,u,c,h,i,m,g,!1,r),C=4*s.length;const f=t.iconSizeData;let d=null;"source"===f.kind?(d=[oc*a.layout.get("icon-size").evaluate(w,{})],d[0]>ac&&x(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===f.kind&&(d=[oc*_.compositeIconSizes[0].evaluate(w,{},k),oc*_.compositeIconSizes[1].evaluate(w,{},k)],(d[0]>ac||d[1]>ac)&&x(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,s,d,b,v,w,$u.none,e,I.lineStartIndex,I.lineLength,-1,k),D=t.icon.placedSymbolArray.length-1,p&&(E=4*p.length,t.addSymbols(t.icon,p,d,b,v,w,$u.vertical,e,I.lineStartIndex,I.lineLength,-1,k),F=t.icon.placedSymbolArray.length-1)}const O=Object.keys(n.horizontal);for(const r of O){const i=n.horizontal[r];if(!M){L=Io(i.text);const t=a.layout.get("text-rotate").evaluate(w,{},k);M=new Wc(l,e,u,c,h,i,p,f,d,t)}const o=1===i.positionedLines.length;if(B+=lh(t,e,i,s,a,d,w,y,I,n.vertical?$u.horizontal:$u.horizontalOnly,o?O:[r],$,D,_,k),o)break}n.vertical&&(V+=lh(t,e,n.vertical,s,a,d,w,y,I,$u.vertical,["vertical"],$,F,_,k));const R=M?M.boxStartIndex:t.collisionBoxArray.length,N=M?M.boxEndIndex:t.collisionBoxArray.length,U=P?P.boxStartIndex:t.collisionBoxArray.length,j=P?P.boxEndIndex:t.collisionBoxArray.length,q=z?z.boxStartIndex:t.collisionBoxArray.length,G=z?z.boxEndIndex:t.collisionBoxArray.length,X=T?T.boxStartIndex:t.collisionBoxArray.length,Z=T?T.boxEndIndex:t.collisionBoxArray.length;let Y=-1;const H=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;Y=H(M,Y),Y=H(P,Y),Y=H(z,Y),Y=H(T,Y);const J=Y>-1?1:0;J&&(Y*=A/xu),t.glyphOffsetArray.length>=mc.MAX_GLYPHS&&x("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,w.sortKey);const W=ih(a,w,k),[K,Q]=function(t,e){const r=t.length,n=null==e?void 0:e.values;if((null==n?void 0:n.length)>0)for(let e=0;e<n.length;e+=2){const r=n[e+1];t.emplaceBack(Ic[n[e]],r[0],r[1])}return[r,t.length]}(t.textAnchorOffsets,W);t.symbolInstances.emplaceBack(e.x,e.y,$.right>=0?$.right:-1,$.center>=0?$.center:-1,$.left>=0?$.left:-1,$.vertical||-1,D,F,L,R,N,U,j,q,G,X,Z,u,B,V,C,E,J,0,p,Y,K,Q)}(t,l,e,n,i,s,E,t.layers[0],t.collisionBoxArray,r.index,r.sourceLayerIndex,t.index,b,[k,k,k,k],M,u,_,A,z,m,r,o,c,h,a)};if("line"===P)for(const s of function(t,r,n,i,s){const o=[];for(let r=0;r<t.length;r++){const n=t[r];let a;for(let t=0;t<n.length-1;t++){let r=n[t],l=n[t+1];r.x<0&&l.x<0||(r.x<0?r=new e(0,r.y+(0-r.x)/(l.x-r.x)*(l.y-r.y))._round():l.x<0&&(l=new e(0,r.y+(0-r.x)/(l.x-r.x)*(l.y-r.y))._round()),r.y<0&&l.y<0||(r.y<0?r=new e(r.x+(0-r.y)/(l.y-r.y)*(l.x-r.x),0)._round():l.y<0&&(l=new e(r.x+(0-r.y)/(l.y-r.y)*(l.x-r.x),0)._round()),r.x>=i&&l.x>=i||(r.x>=i?r=new e(i,r.y+(i-r.x)/(l.x-r.x)*(l.y-r.y))._round():l.x>=i&&(l=new e(i,r.y+(i-r.x)/(l.x-r.x)*(l.y-r.y))._round()),r.y>=s&&l.y>=s||(r.y>=s?r=new e(r.x+(s-r.y)/(l.y-r.y)*(l.x-r.x),s)._round():l.y>=s&&(l=new e(r.x+(s-r.y)/(l.y-r.y)*(l.x-r.x),s)._round()),a&&r.equals(a[a.length-1])||(a=[r],o.push(a)),a.push(l)))))}}return o}(r.geometry,0,0,p,p)){const e=_l(s,B),r=qc(e,S,I,n.vertical||g,i,24,w,t.overscaling,p);for(const n of r)g&&ch(t,g.text,T,n)||V(e,n)}else if("line-center"===P){for(const t of r.geometry)if(t.length>1){const e=_l(t,B),r=jc(e,I,n.vertical||g,i,24,w);r&&V(e,r)}}else if("Polygon"===r.type)for(const t of Qe(r.geometry,0)){const e=Qc(t,16);V(_l(t[0],B,!0),new Lc(e.x,e.y,0))}else if("LineString"===r.type)for(const t of r.geometry){const e=_l(t,B);V(e,new Lc(e[0].x,e[0].y,0))}else if("Point"===r.type)for(const t of r.geometry)for(const e of t)V([e],new Lc(e.x,e.y,0))}function lh(t,r,n,i,s,o,a,l,u,c,h,p,f,d,y){const m=function(t,r,n,i,s,o,a,l){const u=i.layout.get("text-rotate").evaluate(o,{})*Math.PI/180,c=[];for(const t of r.positionedLines)for(const i of t.positionedGlyphs){if(!i.rect)continue;const o=i.rect||{};let h=4,p=!0,f=1,d=0;const y=(s||l)&&i.vertical,m=i.metrics.advance*i.scale/2;if(l&&r.verticalizable&&(d=t.lineOffset/2-(i.imageName?-(xu-i.metrics.width*i.scale)/2:(i.scale-1)*xu)),i.imageName){const t=a[i.imageName];p=t.sdf,f=t.pixelRatio,h=1/f}const g=s?[i.x+m,i.y]:[0,0];let x=s?[0,0]:[i.x+m+n[0],i.y+n[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=i.metrics.isDoubleResolution?2:1,w=(i.metrics.left-h)*i.scale-m+x[0],_=(-i.metrics.top-h)*i.scale+x[1],S=w+o.w/b*i.scale/f,k=_+o.h/b*i.scale/f,A=new e(w,_),I=new e(S,_),M=new e(w,k),z=new e(S,k);if(y){const t=new e(-m,m- -17),r=-Math.PI/2,n=12-m,s=new e(22-n,-(i.imageName?n:0)),o=new e(...v);A._rotateAround(r,t)._add(s)._add(o),I._rotateAround(r,t)._add(s)._add(o),M._rotateAround(r,t)._add(s)._add(o),z._rotateAround(r,t)._add(s)._add(o)}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];A._matMult(r),I._matMult(r),M._matMult(r),z._matMult(r)}const P=new e(0,0),T=new e(0,0);c.push({tl:A,tr:I,bl:M,br:z,tex:o,writingMode:r.writingMode,glyphOffset:g,sectionIndex:i.sectionIndex,isSDF:p,pixelOffsetTL:P,pixelOffsetBR:T,minFontScaleX:0,minFontScaleY:0})}return c}(0,n,l,s,o,a,i,t.allowVerticalPlacement),g=t.textSizeData;let v=null;"source"===g.kind?(v=[oc*s.layout.get("text-size").evaluate(a,{})],v[0]>ac&&x(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(v=[oc*d.compositeTextSizes[0].evaluate(a,{},y),oc*d.compositeTextSizes[1].evaluate(a,{},y)],(v[0]>ac||v[1]>ac)&&x(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,v,l,o,a,c,r,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function uh(t){for(const e in t)return t[e];return null}function ch(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return!0}else i[e]=[];return i[e].push(n),!1}class hh{constructor(t){const e={},r=[];for(const n in t){const i=t[n],s=e[n]={};for(const t in i){const e=i[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const n={x:0,y:0,w:e.bitmap.width+2,h:e.bitmap.height+2};r.push(n),s[t]={rect:n,metrics:e.metrics}}}const{w:n,h:i}=Vu(r),s=new za({width:n||1,height:i||1});for(const r in t){const n=t[r];for(const t in n){const i=n[+t];if(!i||0===i.bitmap.width||0===i.bitmap.height)continue;const o=e[r][t].rect;za.copy(i.bitmap,s,{x:0,y:0},{x:o.x+1,y:o.y+1},i.bitmap)}}this.image=s,this.positions=e}}function ph(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return[t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}li("GlyphAtlas",hh);const fh=6371008.8;class dh{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new dh(function(t,e){const r=((t-e)%360+360)%360+e;return r===e?180:r}(this.lng,-180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return fh*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof dh)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new dh(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new dh(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const yh=2*Math.PI*fh;function mh(t){return yh*Math.cos(t*Math.PI/180)}function gh(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class xh{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r}static fromLngLat(t,e=0){const r=dh.convert(t);return new xh((180+r.lng)/360,(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+r.lat*Math.PI/360)))/360,function(t,e){return t/mh(e)}(e,r.lat))}toLngLat(){return new dh(360*this.x-180,gh(this.y))}toAltitude(){return function(t,e){return t*mh(gh(e))}(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/yh*(t=gh(this.y),1/Math.cos(t*Math.PI/180));var t}}class vh{constructor(t,e,r){if(!function(t,e,r){return!(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=_h(0,t,t,e,r)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=function(t,e,r){var n=ph(256*t,256*(e=Math.pow(2,r)-e-1),r),i=ph(256*(t+1),256*(e+1),r);return n[0]+","+n[1]+","+i[0]+","+i[1]}(this.x,this.y,this.z),i=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,i).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const r=Math.pow(2,this.z);return new e((t.x*r-this.x)*p,(t.y*r-this.y)*p)}toString(){return`${this.z}/${this.x}/${this.y}`}}class bh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=_h(t,e.z,e.z,e.x,e.y)}}class wh{constructor(t,e,r,n,i){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new vh(r,+n,+i),this.key=_h(e,t,r,n,i)}clone(){return new wh(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new wh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new wh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?_h(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):_h(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new wh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return[new wh(e,this.wrap,e,r,n),new wh(e,this.wrap,e,r+1,n),new wh(e,this.wrap,e,r,n+1),new wh(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new wh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new wh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new bh(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new xh(t.x-this.wrap,t.y))}}function _h(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return(s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}li("CanonicalTileID",vh),li("OverscaledTileID",wh,{omit:["terrainRttPosMatrix32f"]});class Sh{constructor(t){this.tileID=new wh(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[]}parse(e,r,n,i,s){return t(this,void 0,void 0,(function*(){this.status="parsing",this.data=e,this.collisionBoxArray=new Us;const t=new Ec(Object.keys(e.layers).sort()),o=new Dc(this.tileID,this.promoteId);o.bucketLayerIDs=[];const a={},l={featureIndex:o,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:n,subdivisionGranularity:s},u=r.familiesBySource[this.source];for(const r in u){const i=e.layers[r];if(!i)continue;1===i.version&&x(`Vector tile source "${this.source}" layer "${r}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const s=t.encode(r),c=[];for(let t=0;t<i.length;t++){const e=i.feature(t),n=o.getId(e,r);c.push({feature:e,id:n,index:t,sourceLayerIndex:s})}for(const t of u[r]){const e=t[0];e.source!==this.source&&x(`layer.source = ${e.source} does not equal this.source = ${this.source}`),e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(kh(t,this.zoom,n),(a[e.id]=e.createBucket({index:o.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:s,sourceID:this.source})).populate(c,l,this.tileID.canonical),o.bucketLayerIDs.push(t.map((t=>t.id))))}}const c=y(l.glyphDependencies,(t=>Object.keys(t).map(Number)));this.inFlightDependencies.forEach((t=>null==t?void 0:t.abort())),this.inFlightDependencies=[];let h=Promise.resolve({});if(Object.keys(c).length){const t=new AbortController;this.inFlightDependencies.push(t),h=i.sendAsync({type:"GG",data:{stacks:c,source:this.source,tileID:this.tileID,type:"glyphs"}},t)}const p=Object.keys(l.iconDependencies);let f=Promise.resolve({});if(p.length){const t=new AbortController;this.inFlightDependencies.push(t),f=i.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},t)}const d=Object.keys(l.patternDependencies);let m=Promise.resolve({});if(d.length){const t=new AbortController;this.inFlightDependencies.push(t),m=i.sendAsync({type:"GI",data:{icons:d,source:this.source,tileID:this.tileID,type:"patterns"}},t)}const[g,v,b]=yield Promise.all([h,f,m]),w=new hh(g),_=new Fu(v,b);for(const t in a){const e=a[t];e instanceof mc?(kh(e.layers,this.zoom,n),sh({bucket:e,glyphMap:g,glyphPositions:w.positions,imageMap:v,imagePositions:_.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:l.subdivisionGranularity})):e.hasPattern&&(e instanceof iu||e instanceof Il||e instanceof jl)&&(kh(e.layers,this.zoom,n),e.addFeatures(l,this.tileID.canonical,_.patternPositions))}return this.status="done",{buckets:Object.values(a).filter((t=>!t.isEmpty())),featureIndex:o,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:w.image,imageAtlas:_,glyphMap:this.returnDependencies?g:null,iconMap:this.returnDependencies?v:null,glyphPositions:this.returnDependencies?w.positions:null}}))}}function kh(t,e,r){const n=new Hi(e);for(const e of t)e.recalculate(n,r)}var Ah,Ih,Mh;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(Ah||(Ah={}));class zh{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start)}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}}class Ph{constructor(t,e,r){this.actor=t,this.layerIndex=e,this.availableImages=r,this.fetching={},this.loading={},this.loaded={}}loadVectorTile(e,r){return t(this,void 0,void 0,(function*(){const t=yield((t,e)=>oi(d(t,{type:"arrayBuffer"}),e))(e.request,r);try{return{vectorTile:new Ol(new _u(t.data)),rawData:t.data,cacheControl:t.cacheControl,expires:t.expires}}catch(r){const n=new Uint8Array(t.data);let i=`Unable to parse the tile at ${e.request.url}, `;throw i+=31===n[0]&&139===n[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${r.message}`,new Error(i)}}))}loadTile(e){return t(this,void 0,void 0,(function*(){const t=e.uid,r=!!(e&&e.request&&e.request.collectResourceTiming)&&new zh(e.request),n=new Sh(e);this.loading[t]=n;const i=new AbortController;n.abort=i;try{const s=yield this.loadVectorTile(e,i);if(delete this.loading[t],!s)return null;const o=s.rawData,a={};s.expires&&(a.expires=s.expires),s.cacheControl&&(a.cacheControl=s.cacheControl);const l={};if(r){const t=r.finish();t&&(l.resourceTiming=JSON.parse(JSON.stringify(t)))}n.vectorTile=s.vectorTile;const u=n.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity);this.loaded[t]=n,this.fetching[t]={rawTileData:o,cacheControl:a,resourceTiming:l};try{const t=yield u;return d({rawTileData:o.slice(0)},t,a,l)}finally{delete this.fetching[t]}}catch(e){throw delete this.loading[t],n.status="done",this.loaded[t]=n,e}}))}reloadTile(e){return t(this,void 0,void 0,(function*(){const t=e.uid;if(!this.loaded||!this.loaded[t])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const r=this.loaded[t];if(r.showCollisionBoxes=e.showCollisionBoxes,"parsing"===r.status){const n=yield r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity);let i;if(this.fetching[t]){const{rawTileData:e,cacheControl:r,resourceTiming:s}=this.fetching[t];delete this.fetching[t],i=d({rawTileData:e.slice(0)},n,r,s)}else i=n;return i}if("done"===r.status&&r.vectorTile)return r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity)}))}abortTile(e){return t(this,void 0,void 0,(function*(){const t=this.loading,r=e.uid;t&&t[r]&&t[r].abort&&(t[r].abort.abort(),delete t[r])}))}removeTile(e){return t(this,void 0,void 0,(function*(){this.loaded&&this.loaded[e.uid]&&delete this.loaded[e.uid]}))}}class Th{constructor(){this.loaded={}}loadTile(e){return t(this,void 0,void 0,(function*(){const{uid:r,encoding:n,rawImageData:i,redFactor:s,greenFactor:o,blueFactor:u,baseShift:c}=e,h=i.width+2,p=i.height+2,f=w(i)?new Pa({width:h,height:p},yield function(e,r,n,i,s){return t(this,void 0,void 0,(function*(){if(function(){if(null==l&&(l=!1,null==a&&(a="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),a)){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1)}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){l=!0;break}}}return l||!1}())try{return yield function(e,r,n,i,s){return t(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const t=new VideoFrame(e,{timestamp:0});try{const o=null==t?void 0:t.format;if(!o||!o.startsWith("BGR")&&!o.startsWith("RGB"))throw new Error(`Unrecognized format ${o}`);const a=o.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield t.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),o=(Math.max(0,r)-r)*n*4+s,a=4*n,l=Math.max(0,e),u=Math.max(0,r);return{rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:o,stride:a}]}}(e,r,n,i,s)),a)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e}return l}finally{t.close()}}))}(e,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,o=t.height;_&&S||(_=new OffscreenCanvas(s,o),S=_.getContext("2d",{willReadFrequently:!0})),_.width=s,_.height=o,S.drawImage(t,0,0,s,o);const a=S.getImageData(e,r,n,i);return S.clearRect(0,0,s,o),a.data}(e,r,n,i,s)}))}(i,-1,-1,h,p)):i,d=new La(r,f,n,s,o,u,c);return this.loaded=this.loaded||{},this.loaded[r]=d,d}))}removeTile(t){const e=this.loaded,r=t.uid;e&&e[r]&&delete e[r]}}var Ch=function(){if(Mh)return Ih;function t(t,r){if(0!==t.length){e(t[0],r);for(var n=1;n<t.length;n++)e(t[n],!r)}}function e(t,e){for(var r=0,n=0,i=0,s=t.length,o=s-1;i<s;o=i++){var a=(t[i][0]-t[o][0])*(t[o][1]+t[i][1]),l=r+a;n+=Math.abs(r)>=Math.abs(a)?r-l+a:a-l+r,r=l}r+n>=0!=!!e&&t.reverse()}return Mh=1,Ih=function e(r,n){var i,s=r&&r.type;if("FeatureCollection"===s)for(i=0;i<r.features.length;i++)e(r.features[i],n);else if("GeometryCollection"===s)for(i=0;i<r.geometries.length;i++)e(r.geometries[i],n);else if("Feature"===s)e(r.geometry,n);else if("Polygon"===s)t(r.coordinates,n);else if("MultiPolygon"===s)for(i=0;i<r.coordinates.length;i++)t(r.coordinates[i],n);return r}}(),Eh=r(Ch);class Bh extends Vl{constructor(t,e){super(new _u,0,e,[],[]),this.feature=t,this.type=t.type,this.properties=t.tags?t.tags:{},"id"in t&&("string"==typeof t.id?this.id=parseInt(t.id,10):"number"!=typeof t.id||isNaN(t.id)||(this.id=t.id))}loadGeometry(){const t=[],r=1===this.feature.type?[this.feature.geometry]:this.feature.geometry;for(const n of r){const r=[];for(const t of n)r.push(new e(t[0],t[1]));t.push(r)}return t}}class Vh extends $l{constructor(t,e){super(new _u),this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.version=e?e.version:1,this.extent=e?e.extent:4096,this.length=t.length,this.features=t}feature(t){return new Bh(this.features[t],this.extent)}}function Dh(t,e){e.writeVarintField(15,t.version||1),e.writeStringField(1,t.name||""),e.writeVarintField(5,t.extent||4096);const r={keys:[],values:[],keycache:{},valuecache:{}};for(let n=0;n<t.length;n++)r.feature=t.feature(n),e.writeMessage(2,Fh,r);const n=r.keys;for(const t of n)e.writeStringField(3,t);const i=r.values;for(const t of i)e.writeMessage(4,Nh,t)}function Fh(t,e){if(!t.feature)return;const r=t.feature;void 0!==r.id&&e.writeVarintField(1,r.id),e.writeMessage(2,$h,t),e.writeVarintField(3,r.type),e.writeMessage(4,Rh,r)}function $h(t,e){for(const r in t.feature?.properties){let n=t.feature.properties[r],i=t.keycache[r];if(null===n)continue;void 0===i&&(t.keys.push(r),i=t.keys.length-1,t.keycache[r]=i),e.writeVarint(i),"string"!=typeof n&&"boolean"!=typeof n&&"number"!=typeof n&&(n=JSON.stringify(n));const s=typeof n+":"+n;let o=t.valuecache[s];void 0===o&&(t.values.push(n),o=t.values.length-1,t.valuecache[s]=o),e.writeVarint(o)}}function Lh(t,e){return(e<<3)+(7&t)}function Oh(t){return t<<1^t>>31}function Rh(t,e){const r=t.loadGeometry(),n=t.type;let i=0,s=0;for(const o of r){let r=1;1===n&&(r=o.length),e.writeVarint(Lh(1,r));const a=3===n?o.length-1:o.length;for(let t=0;t<a;t++){1===t&&1!==n&&e.writeVarint(Lh(2,a-1));const r=o[t].x-i,l=o[t].y-s;e.writeVarint(Oh(r)),e.writeVarint(Oh(l)),i+=r,s+=l}3===t.type&&e.writeVarint(Lh(7,1))}}function Nh(t,e){const r=typeof t;"string"===r?e.writeStringField(1,t):"boolean"===r?e.writeBooleanField(7,t):"number"===r&&(t%1!=0?e.writeDoubleField(3,t):t<0?e.writeSVarintField(6,t):e.writeVarintField(5,t))}const Uh=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class jh{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Uh[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new jh(o,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=Uh.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return qh(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:o}=this,a=[0,i.length-1,0],l=[];for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=o){for(let o=h;o<=c;o++){const a=s[2*o],u=s[2*o+1];a>=t&&a<=r&&u>=e&&u<=n&&l.push(i[o])}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?r>=f:n>=d)&&(a.push(p+1),a.push(c),a.push(1-u))}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,o=[0,n.length-1,0],a=[],l=r*r;for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Yh(i[2*r],i[2*r+1],t,e)<=l&&a.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Yh(f,d,t,e)<=l&&a.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(o.push(p+1),o.push(c),o.push(1-u))}return a}}function qh(t,e,r,n,i,s){if(i-n<=r)return;const o=n+i>>1;Gh(t,e,o,n,i,s),qh(t,e,r,n,o-1,1-s),qh(t,e,r,o+1,i,1-s)}function Gh(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const o=i-n+1,a=r-n+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);Gh(t,e,r,Math.max(n,Math.floor(r-a*u/o+c)),Math.min(i,Math.floor(r+(o-a)*u/o+c)),s)}const o=e[2*r+s];let a=n,l=i;for(Xh(t,e,n,r),e[2*i+s]>o&&Xh(t,e,n,i);a<l;){for(Xh(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--}e[2*n+s]===o?Xh(t,e,n,l):(l++,Xh(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1)}}function Xh(t,e,r,n){Zh(t,r,n),Zh(e,2*r,2*n),Zh(e,2*r+1,2*n+1)}function Zh(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}function Yh(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}const Hh={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:t=>t},Jh=Math.fround||(Wh=new Float32Array(1),t=>(Wh[0]=+t,Wh[0]));var Wh;class Kh{constructor(t){this.options=Object.assign(Object.create(Hh),t),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[]}load(t){const{log:e,minZoom:r,maxZoom:n}=this.options;e&&console.time("total time");const i=`prepare ${t.length} points`;e&&console.time(i),this.points=t;const s=[];for(let e=0;e<t.length;e++){const r=t[e];if(!r.geometry)continue;const[n,i]=r.geometry.coordinates,o=Jh(ep(n)),a=Jh(rp(i));s.push(o,a,1/0,e,-1,1),this.options.reduce&&s.push(0)}let o=this.trees[n+1]=this._createTree(s);e&&console.timeEnd(i);for(let t=n;t>=r;t--){const r=+Date.now();o=this.trees[t]=this._createTree(this._cluster(o,t)),e&&console.log("z%d: %d clusters in %dms",t,o.numItems,+Date.now()-r)}return e&&console.timeEnd("total time"),this}getClusters(t,e){let r=((t[0]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,t[1]));let i=180===t[2]?180:((t[2]+180)%360+360)%360-180;const s=Math.max(-90,Math.min(90,t[3]));if(t[2]-t[0]>=360)r=-180,i=180;else if(r>i){const t=this.getClusters([r,n,180,s],e),o=this.getClusters([-180,n,i,s],e);return t.concat(o)}const o=this.trees[this._limitZoom(e)],a=o.range(ep(r),rp(s),ep(i),rp(n)),l=o.data,u=[];for(const t of a){const e=this.stride*t;u.push(l[e+5]>1?Qh(l,e,this.clusterProps):this.points[l[e+3]])}return u}getChildren(t){const e=this._getOriginId(t),r=this._getOriginZoom(t),n="No cluster with the specified id.",i=this.trees[r];if(!i)throw new Error(n);const s=i.data;if(e*this.stride>=s.length)throw new Error(n);const o=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=i.within(s[e*this.stride],s[e*this.stride+1],o),l=[];for(const e of a){const r=e*this.stride;s[r+4]===t&&l.push(s[r+5]>1?Qh(s,r,this.clusterProps):this.points[s[r+3]])}if(0===l.length)throw new Error(n);return l}getLeaves(t,e,r){const n=[];return this._appendLeaves(n,t,e=e||10,r=r||0,0),n}getTile(t,e,r){const n=this.trees[this._limitZoom(t)],i=Math.pow(2,t),{extent:s,radius:o}=this.options,a=o/s,l=(r-a)/i,u=(r+1+a)/i,c={features:[]};return this._addTileFeatures(n.range((e-a)/i,l,(e+1+a)/i,u),n.data,e,r,i,c),0===e&&this._addTileFeatures(n.range(1-a/i,l,1,u),n.data,i,r,i,c),e===i-1&&this._addTileFeatures(n.range(0,l,a/i,u),n.data,-1,r,i,c),c.features.length?c:null}getClusterExpansionZoom(t){let e=this._getOriginZoom(t)-1;for(;e<=this.options.maxZoom;){const r=this.getChildren(t);if(e++,1!==r.length)break;t=r[0].properties.cluster_id}return e}_appendLeaves(t,e,r,n,i){const s=this.getChildren(e);for(const e of s){const s=e.properties;if(s&&s.cluster?i+s.point_count<=n?i+=s.point_count:i=this._appendLeaves(t,s.cluster_id,r,n,i):i<n?i++:t.push(e),t.length===r)break}return i}_createTree(t){const e=new jh(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let r=0;r<t.length;r+=this.stride)e.add(t[r],t[r+1]);return e.finish(),e.data=t,e}_addTileFeatures(t,e,r,n,i,s){for(const o of t){const t=o*this.stride,a=e[t+5]>1;let l,u,c;if(a)l=tp(e,t,this.clusterProps),u=e[t],c=e[t+1];else{const r=this.points[e[t+3]];l=r.properties;const[n,i]=r.geometry.coordinates;u=ep(n),c=rp(i)}const h={type:1,geometry:[[Math.round(this.options.extent*(u*i-r)),Math.round(this.options.extent*(c*i-n))]],tags:l};let p;p=a||this.options.generateId?e[t+3]:this.points[e[t+3]].id,void 0!==p&&(h.id=p),s.features.push(h)}}_limitZoom(t){return Math.max(this.options.minZoom,Math.min(Math.floor(+t),this.options.maxZoom+1))}_cluster(t,e){const{radius:r,extent:n,reduce:i,minPoints:s}=this.options,o=r/(n*Math.pow(2,e)),a=t.data,l=[],u=this.stride;for(let r=0;r<a.length;r+=u){if(a[r+2]<=e)continue;a[r+2]=e;const n=a[r],c=a[r+1],h=t.within(a[r],a[r+1],o),p=a[r+5];let f=p;for(const t of h){const r=t*u;a[r+2]>e&&(f+=a[r+5])}if(f>p&&f>=s){let t,s=n*p,o=c*p,d=-1;const y=(r/u<<5)+(e+1)+this.points.length;for(const n of h){const l=n*u;if(a[l+2]<=e)continue;a[l+2]=e;const c=a[l+5];s+=a[l]*c,o+=a[l+1]*c,a[l+4]=y,i&&(t||(t=this._map(a,r,!0),d=this.clusterProps.length,this.clusterProps.push(t)),i(t,this._map(a,l)))}a[r+4]=y,l.push(s/f,o/f,1/0,y,-1,f),i&&l.push(d)}else{for(let t=0;t<u;t++)l.push(a[r+t]);if(f>1)for(const t of h){const r=t*u;if(!(a[r+2]<=e)){a[r+2]=e;for(let t=0;t<u;t++)l.push(a[r+t])}}}}return l}_getOriginId(t){return t-this.points.length>>5}_getOriginZoom(t){return(t-this.points.length)%32}_map(t,e,r){if(t[e+5]>1){const n=this.clusterProps[t[e+6]];return r?Object.assign({},n):n}const n=this.points[t[e+3]].properties,i=this.options.map(n);return r&&i===n?Object.assign({},i):i}}function Qh(t,e,r){return{type:"Feature",id:t[e+3],properties:tp(t,e,r),geometry:{type:"Point",coordinates:[(n=t[e],360*(n-.5)),np(t[e+1])]}};var n}function tp(t,e,r){const n=t[e+5],i=n>=1e4?`${Math.round(n/1e3)}k`:n>=1e3?Math.round(n/100)/10+"k":n,s=t[e+6],o=-1===s?{}:Object.assign({},r[s]);return Object.assign(o,{cluster:!0,cluster_id:t[e+3],point_count:n,point_count_abbreviated:i})}function ep(t){return t/360+.5}function rp(t){const e=Math.sin(t*Math.PI/180),r=.5-.25*Math.log((1+e)/(1-e))/Math.PI;return r<0?0:r>1?1:r}function np(t){const e=(180-360*t)*Math.PI/180;return 360*Math.atan(Math.exp(e))/Math.PI-90}function ip(t,e,r,n){let i=n;const s=e+(r-e>>1);let o,a=r-e;const l=t[e],u=t[e+1],c=t[r],h=t[r+1];for(let n=e+3;n<r;n+=3){const e=sp(t[n],t[n+1],l,u,c,h);if(e>i)o=n,i=e;else if(e===i){const t=Math.abs(n-s);t<a&&(o=n,a=t)}}i>n&&(o-e>3&&ip(t,e,o,n),t[o+2]=i,r-o>3&&ip(t,o,r,n))}function sp(t,e,r,n,i,s){let o=i-r,a=s-n;if(0!==o||0!==a){const l=((t-r)*o+(e-n)*a)/(o*o+a*a);l>1?(r=i,n=s):l>0&&(r+=o*l,n+=a*l)}return o=t-r,a=e-n,o*o+a*a}function op(t,e,r,n){const i={id:null==t?null:t,type:e,geometry:r,tags:n,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===e||"MultiPoint"===e||"LineString"===e)ap(i,r);else if("Polygon"===e)ap(i,r[0]);else if("MultiLineString"===e)for(const t of r)ap(i,t);else if("MultiPolygon"===e)for(const t of r)ap(i,t[0]);return i}function ap(t,e){for(let r=0;r<e.length;r+=3)t.minX=Math.min(t.minX,e[r]),t.minY=Math.min(t.minY,e[r+1]),t.maxX=Math.max(t.maxX,e[r]),t.maxY=Math.max(t.maxY,e[r+1])}function lp(t,e,r,n){if(!e.geometry)return;const i=e.geometry.coordinates;if(i&&0===i.length)return;const s=e.geometry.type,o=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2);let a=[],l=e.id;if(r.promoteId?l=e.properties[r.promoteId]:r.generateId&&(l=n||0),"Point"===s)up(i,a);else if("MultiPoint"===s)for(const t of i)up(t,a);else if("LineString"===s)cp(i,a,o,!1);else if("MultiLineString"===s){if(r.lineMetrics){for(const r of i)a=[],cp(r,a,o,!1),t.push(op(l,"LineString",a,e.properties));return}hp(i,a,o,!1)}else if("Polygon"===s)hp(i,a,o,!0);else{if("MultiPolygon"!==s){if("GeometryCollection"===s){for(const i of e.geometry.geometries)lp(t,{id:l,geometry:i,properties:e.properties},r,n);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const t of i){const e=[];hp(t,e,o,!0),a.push(e)}}t.push(op(l,s,a,e.properties))}function up(t,e){e.push(pp(t[0]),fp(t[1]),0)}function cp(t,e,r,n){let i,s,o=0;for(let r=0;r<t.length;r++){const a=pp(t[r][0]),l=fp(t[r][1]);e.push(a,l,0),r>0&&(o+=n?(i*l-a*s)/2:Math.sqrt(Math.pow(a-i,2)+Math.pow(l-s,2))),i=a,s=l}const a=e.length-3;e[2]=1,ip(e,0,a,r),e[a+2]=1,e.size=Math.abs(o),e.start=0,e.end=e.size}function hp(t,e,r,n){for(let i=0;i<t.length;i++){const s=[];cp(t[i],s,r,n),e.push(s)}}function pp(t){return t/360+.5}function fp(t){const e=Math.sin(t*Math.PI/180),r=.5-.25*Math.log((1+e)/(1-e))/Math.PI;return r<0?0:r>1?1:r}function dp(t,e,r,n,i,s,o,a){if(n/=e,s>=(r/=e)&&o<n)return t;if(o<r||s>=n)return null;const l=[];for(const e of t){const t=e.geometry;let s=e.type;const o=0===i?e.minX:e.minY,u=0===i?e.maxX:e.maxY;if(o>=r&&u<n){l.push(e);continue}if(u<r||o>=n)continue;let c=[];if("Point"===s||"MultiPoint"===s)yp(t,c,r,n,i);else if("LineString"===s)mp(t,c,r,n,i,!1,a.lineMetrics);else if("MultiLineString"===s)xp(t,c,r,n,i,!1);else if("Polygon"===s)xp(t,c,r,n,i,!0);else if("MultiPolygon"===s)for(const e of t){const t=[];xp(e,t,r,n,i,!0),t.length&&c.push(t)}if(c.length){if(a.lineMetrics&&"LineString"===s){for(const t of c)l.push(op(e.id,s,t,e.tags));continue}"LineString"!==s&&"MultiLineString"!==s||(1===c.length?(s="LineString",c=c[0]):s="MultiLineString"),"Point"!==s&&"MultiPoint"!==s||(s=3===c.length?"Point":"MultiPoint"),l.push(op(e.id,s,c,e.tags))}}return l.length?l:null}function yp(t,e,r,n,i){for(let s=0;s<t.length;s+=3){const o=t[s+i];o>=r&&o<=n&&vp(e,t[s],t[s+1],t[s+2])}}function mp(t,e,r,n,i,s,o){let a=gp(t);const l=0===i?bp:wp;let u,c,h=t.start;for(let p=0;p<t.length-3;p+=3){const f=t[p],d=t[p+1],y=t[p+2],m=t[p+3],g=t[p+4],x=0===i?f:d,v=0===i?m:g;let b=!1;o&&(u=Math.sqrt(Math.pow(f-m,2)+Math.pow(d-g,2))),x<r?v>r&&(c=l(a,f,d,m,g,r),o&&(a.start=h+u*c)):x>n?v<n&&(c=l(a,f,d,m,g,n),o&&(a.start=h+u*c)):vp(a,f,d,y),v<r&&x>=r&&(c=l(a,f,d,m,g,r),b=!0),v>n&&x<=n&&(c=l(a,f,d,m,g,n),b=!0),!s&&b&&(o&&(a.end=h+u*c),e.push(a),a=gp(t)),o&&(h+=u)}let p=t.length-3;const f=t[p],d=t[p+1],y=0===i?f:d;y>=r&&y<=n&&vp(a,f,d,t[p+2]),p=a.length-3,s&&p>=3&&(a[p]!==a[0]||a[p+1]!==a[1])&&vp(a,a[0],a[1],a[2]),a.length&&e.push(a)}function gp(t){const e=[];return e.size=t.size,e.start=t.start,e.end=t.end,e}function xp(t,e,r,n,i,s){for(const o of t)mp(o,e,r,n,i,s,!1)}function vp(t,e,r,n){t.push(e,r,n)}function bp(t,e,r,n,i,s){const o=(s-e)/(n-e);return vp(t,s,r+(i-r)*o,1),o}function wp(t,e,r,n,i,s){const o=(s-r)/(i-r);return vp(t,e+(n-e)*o,s,1),o}function _p(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],s=i.type;let o;if("Point"===s||"MultiPoint"===s||"LineString"===s)o=Sp(i.geometry,e);else if("MultiLineString"===s||"Polygon"===s){o=[];for(const t of i.geometry)o.push(Sp(t,e))}else if("MultiPolygon"===s){o=[];for(const t of i.geometry){const r=[];for(const n of t)r.push(Sp(n,e));o.push(r)}}r.push(op(i.id,s,o,i.tags))}return r}function Sp(t,e){const r=[];r.size=t.size,void 0!==t.start&&(r.start=t.start,r.end=t.end);for(let n=0;n<t.length;n+=3)r.push(t[n]+e,t[n+1],t[n+2]);return r}function kp(t,e){if(t.transformed)return t;const r=1<<t.z,n=t.x,i=t.y;for(const s of t.features){const t=s.geometry,o=s.type;if(s.geometry=[],1===o)for(let o=0;o<t.length;o+=2)s.geometry.push(Ap(t[o],t[o+1],e,r,n,i));else for(let o=0;o<t.length;o++){const a=[];for(let s=0;s<t[o].length;s+=2)a.push(Ap(t[o][s],t[o][s+1],e,r,n,i));s.geometry.push(a)}}return t.transformed=!0,t}function Ap(t,e,r,n,i,s){return[Math.round(r*(t*n-i)),Math.round(r*(e*n-s))]}function Ip(t,e,r,n,i){const s=e===i.maxZoom?0:i.tolerance/((1<<e)*i.extent),o={features:[],numPoints:0,numSimplified:0,numFeatures:t.length,source:null,x:r,y:n,z:e,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const e of t)Mp(o,e,s,i);return o}function Mp(t,e,r,n){const i=e.geometry,s=e.type,o=[];if(t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),"Point"===s||"MultiPoint"===s)for(let e=0;e<i.length;e+=3)o.push(i[e],i[e+1]),t.numPoints++,t.numSimplified++;else if("LineString"===s)zp(o,i,t,r,!1,!1);else if("MultiLineString"===s||"Polygon"===s)for(let e=0;e<i.length;e++)zp(o,i[e],t,r,"Polygon"===s,0===e);else if("MultiPolygon"===s)for(let e=0;e<i.length;e++){const n=i[e];for(let e=0;e<n.length;e++)zp(o,n[e],t,r,!0,0===e)}if(o.length){let r=e.tags||null;if("LineString"===s&&n.lineMetrics){r={};for(const t in e.tags)r[t]=e.tags[t];r.mapbox_clip_start=i.start/i.size,r.mapbox_clip_end=i.end/i.size}const a={geometry:o,type:"Polygon"===s||"MultiPolygon"===s?3:"LineString"===s||"MultiLineString"===s?2:1,tags:r};null!==e.id&&(a.id=e.id),t.features.push(a)}}function zp(t,e,r,n,i,s){const o=n*n;if(n>0&&e.size<(i?o:n))return void(r.numPoints+=e.length/3);const a=[];for(let t=0;t<e.length;t+=3)(0===n||e[t+2]>o)&&(r.numSimplified++,a.push(e[t],e[t+1])),r.numPoints++;i&&function(t,e){let r=0;for(let e=0,n=t.length,i=n-2;e<n;i=e,e+=2)r+=(t[e]-t[i])*(t[e+1]+t[i+1]);if(r>0===e)for(let e=0,r=t.length;e<r/2;e+=2){const n=t[e],i=t[e+1];t[e]=t[r-2-e],t[e+1]=t[r-1-e],t[r-2-e]=n,t[r-1-e]=i}}(a,s),t.push(a)}const Pp={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class Tp{constructor(t,e){const r=(e=this.options=function(t,e){for(const r in e)t[r]=e[r];return t}(Object.create(Pp),e)).debug;if(r&&console.time("preprocess data"),e.maxZoom<0||e.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(e.promoteId&&e.generateId)throw new Error("promoteId and generateId cannot be used together.");let n=function(t,e){const r=[];if("FeatureCollection"===t.type)for(let n=0;n<t.features.length;n++)lp(r,t.features[n],e,n);else lp(r,"Feature"===t.type?t:{geometry:t},e);return r}(t,e);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",e.indexMaxZoom,e.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),n=function(t,e){const r=e.buffer/e.extent;let n=t;const i=dp(t,1,-1-r,r,0,-1,2,e),s=dp(t,1,1-r,2+r,0,-1,2,e);return(i||s)&&(n=dp(t,1,-r,1+r,0,-1,2,e)||[],i&&(n=_p(i,1).concat(n)),s&&(n=n.concat(_p(s,-1)))),n}(n,e),n.length&&this.splitTile(n,0,0,0),r&&(n.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)))}splitTile(t,e,r,n,i,s,o){const a=[t,e,r,n],l=this.options,u=l.debug;for(;a.length;){n=a.pop(),r=a.pop(),e=a.pop(),t=a.pop();const c=1<<e,h=Cp(e,r,n);let p=this.tiles[h];if(!p&&(u>1&&console.time("creation"),p=this.tiles[h]=Ip(t,e,r,n,l),this.tileCoords.push({z:e,x:r,y:n}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",e,r,n,p.numFeatures,p.numPoints,p.numSimplified),console.timeEnd("creation"));const t=`z${e}`;this.stats[t]=(this.stats[t]||0)+1,this.total++}if(p.source=t,null==i){if(e===l.indexMaxZoom||p.numPoints<=l.indexMaxPoints)continue}else{if(e===l.maxZoom||e===i)continue;if(null!=i){const t=i-e;if(r!==s>>t||n!==o>>t)continue}}if(p.source=null,0===t.length)continue;u>1&&console.time("clipping");const f=.5*l.buffer/l.extent,d=.5-f,y=.5+f,m=1+f;let g=null,x=null,v=null,b=null,w=dp(t,c,r-f,r+y,0,p.minX,p.maxX,l),_=dp(t,c,r+d,r+m,0,p.minX,p.maxX,l);t=null,w&&(g=dp(w,c,n-f,n+y,1,p.minY,p.maxY,l),x=dp(w,c,n+d,n+m,1,p.minY,p.maxY,l),w=null),_&&(v=dp(_,c,n-f,n+y,1,p.minY,p.maxY,l),b=dp(_,c,n+d,n+m,1,p.minY,p.maxY,l),_=null),u>1&&console.timeEnd("clipping"),a.push(g||[],e+1,2*r,2*n),a.push(x||[],e+1,2*r,2*n+1),a.push(v||[],e+1,2*r+1,2*n),a.push(b||[],e+1,2*r+1,2*n+1)}}getTile(t,e,r){t=+t,e=+e,r=+r;const n=this.options,{extent:i,debug:s}=n;if(t<0||t>24)return null;const o=1<<t,a=Cp(t,e=e+o&o-1,r);if(this.tiles[a])return kp(this.tiles[a],i);s>1&&console.log("drilling down to z%d-%d-%d",t,e,r);let l,u=t,c=e,h=r;for(;!l&&u>0;)u--,c>>=1,h>>=1,l=this.tiles[Cp(u,c,h)];return l&&l.source?(s>1&&(console.log("found parent tile z%d-%d-%d",u,c,h),console.time("drilling down")),this.splitTile(l.source,u,c,h,t,e,r),s>1&&console.timeEnd("drilling down"),this.tiles[a]?kp(this.tiles[a],i):null):null}}function Cp(t,e,r){return 32*((1<<t)*r+e)+t}function Ep(t,e){return e?t.properties[e]:t.id}function Bp(t,e){if(null==t)return!0;if("Feature"===t.type)return null!=Ep(t,e);if("FeatureCollection"===t.type){const r=new Set;for(const n of t.features){const t=Ep(n,e);if(null==t)return!1;if(r.has(t))return!1;r.add(t)}return!0}return!1}function Vp(t,e){const r=new Map;if(null==t);else if("Feature"===t.type)r.set(Ep(t,e),t);else for(const n of t.features)r.set(Ep(n,e),n);return r}class Dp extends Ph{constructor(){super(...arguments),this._dataUpdateable=new Map}loadVectorTile(e,r){return t(this,void 0,void 0,(function*(){const t=e.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const r=this._geoJSONIndex.getTile(t.z,t.x,t.y);if(!r)return null;const n=new Vh(r.features,{version:2,extent:p});let i=function(t){const e=new _u;return function(t,e){for(const r in t.layers)e.writeMessage(3,Dh,t.layers[r])}(t,e),e.finish()}(n);return 0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),{vectorTile:n,rawData:i.buffer}}))}loadData(e){return t(this,void 0,void 0,(function*(){var t;null===(t=this._pendingRequest)||void 0===t||t.abort();const r=!!(e&&e.request&&e.request.collectResourceTiming)&&new zh(e.request);this._pendingRequest=new AbortController;try{this._pendingData=this.loadAndProcessGeoJSON(e,this._pendingRequest);const t=yield this._pendingData;this._geoJSONIndex=e.cluster?new Kh(function({superclusterOptions:t,clusterProperties:e}){if(!e||!t)return t;const r={},n={},i={accumulated:null,zoom:0},s={properties:null},o=Object.keys(e);for(const t of o){const[i,s]=e[t],o=en(s),a=en("string"==typeof i?[i,["accumulated"],["get",t]]:i);r[t]=o.value,n[t]=a.value}return t.map=t=>{s.properties=t;const e={};for(const t of o)e[t]=r[t].evaluate(i,s);return e},t.reduce=(t,e)=>{s.properties=e;for(const e of o)i.accumulated=t[e],t[e]=n[e].evaluate(i,s)},t}(e)).load(t.features):function(t,e){return new Tp(t,e)}(t,e.geojsonVtOptions),this.loaded={};const n={data:t};if(r){const t=r.finish();t&&(n.resourceTiming={},n.resourceTiming[e.source]=JSON.parse(JSON.stringify(t)))}return n}catch(t){if(delete this._pendingRequest,function(t){return t.message===Kn}(t))return{abandoned:!0};throw t}}))}getData(){return t(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(t){const e=this.loaded;return e&&e[t.uid]?super.reloadTile(t):this.loadTile(t)}loadAndProcessGeoJSON(e,r){return t(this,void 0,void 0,(function*(){let t=yield this.loadGeoJSON(e,r);if(delete this._pendingRequest,"object"!=typeof t)throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`);if(Eh(t,!0),e.filter){const r=en(e.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));const n=t.features.filter((t=>r.value.evaluate({zoom:0},t)));t={type:"FeatureCollection",features:n}}return t}))}loadGeoJSON(e,r){return t(this,void 0,void 0,(function*(){const{promoteId:t}=e;if(e.request){const n=yield((t,e)=>oi(d(t,{type:"json"}),e))(e.request,r);return this._dataUpdateable=Bp(n.data,t)?Vp(n.data,t):void 0,n.data}if("string"==typeof e.data)try{const r=JSON.parse(e.data);return this._dataUpdateable=Bp(r,t)?Vp(r,t):void 0,r}catch(t){throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`)}if(!e.dataDiff)throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${e.source}`);return function(t,e,r){var n,i,s,o;if(e.removeAll&&t.clear(),e.remove)for(const r of e.remove)t.delete(r);if(e.add)for(const n of e.add){const e=Ep(n,r);null!=e&&t.set(e,n)}if(e.update)for(const r of e.update){let e=t.get(r.id);if(null==e)continue;const a=!r.removeAllProperties&&((null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0);if((r.newGeometry||r.removeAllProperties||a)&&(e=Object.assign({},e),t.set(r.id,e),a&&(e.properties=Object.assign({},e.properties))),r.newGeometry&&(e.geometry=r.newGeometry),r.removeAllProperties)e.properties={};else if((null===(s=r.removeProperties)||void 0===s?void 0:s.length)>0)for(const t of r.removeProperties)Object.prototype.hasOwnProperty.call(e.properties,t)&&delete e.properties[t];if((null===(o=r.addOrUpdateProperties)||void 0===o?void 0:o.length)>0)for(const{key:t,value:n}of r.addOrUpdateProperties)e.properties[t]=n}}(this._dataUpdateable,e.dataDiff,t),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(e){return t(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort()}))}getClusterExpansionZoom(t){return this._geoJSONIndex.getClusterExpansionZoom(t.clusterId)}getClusterChildren(t){return this._geoJSONIndex.getChildren(t.clusterId)}getClusterLeaves(t){return this._geoJSONIndex.getLeaves(t.clusterId,t.limit,t.offset)}}class Fp{constructor(e){this.self=e,this.actor=new mi(e),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.globalStates=new Map,this.self.registerWorkerSource=(t,e)=>{if(this.externalWorkerSourceTypes[t])throw new Error(`Worker source with name "${t}" already registered.`);this.externalWorkerSourceTypes[t]=e},this.self.addProtocol=ei,this.self.removeProtocol=ri,this.self.registerRTLTextPlugin=t=>{Yi.setMethods(t)},this.actor.registerMessageHandler("LDT",((t,e)=>this._getDEMWorkerSource(t,e.source).loadTile(e))),this.actor.registerMessageHandler("RDT",((e,r)=>t(this,void 0,void 0,(function*(){this._getDEMWorkerSource(e,r.source).removeTile(r)})))),this.actor.registerMessageHandler("GCEZ",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterExpansionZoom(r)})))),this.actor.registerMessageHandler("GCC",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterChildren(r)})))),this.actor.registerMessageHandler("GCL",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterLeaves(r)})))),this.actor.registerMessageHandler("LD",((t,e)=>this._getWorkerSource(t,e.type,e.source).loadData(e))),this.actor.registerMessageHandler("GD",((t,e)=>this._getWorkerSource(t,e.type,e.source).getData())),this.actor.registerMessageHandler("LT",((t,e)=>this._getWorkerSource(t,e.type,e.source).loadTile(e))),this.actor.registerMessageHandler("RT",((t,e)=>this._getWorkerSource(t,e.type,e.source).reloadTile(e))),this.actor.registerMessageHandler("AT",((t,e)=>this._getWorkerSource(t,e.type,e.source).abortTile(e))),this.actor.registerMessageHandler("RMT",((t,e)=>this._getWorkerSource(t,e.type,e.source).removeTile(e))),this.actor.registerMessageHandler("RS",((e,r)=>t(this,void 0,void 0,(function*(){if(!this.workerSources[e]||!this.workerSources[e][r.type]||!this.workerSources[e][r.type][r.source])return;const t=this.workerSources[e][r.type][r.source];delete this.workerSources[e][r.type][r.source],void 0!==t.removeSource&&t.removeSource(r)})))),this.actor.registerMessageHandler("RM",(e=>t(this,void 0,void 0,(function*(){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e],this.globalStates.delete(e)})))),this.actor.registerMessageHandler("SR",((e,r)=>t(this,void 0,void 0,(function*(){this.referrer=r})))),this.actor.registerMessageHandler("SRPS",((t,e)=>this._syncRTLPluginState(t,e))),this.actor.registerMessageHandler("IS",((e,r)=>t(this,void 0,void 0,(function*(){this.self.importScripts(r)})))),this.actor.registerMessageHandler("SI",((t,e)=>this._setImages(t,e))),this.actor.registerMessageHandler("UL",((e,r)=>t(this,void 0,void 0,(function*(){this._getLayerIndex(e).update(r.layers,r.removedIds,this._getGlobalState(e))})))),this.actor.registerMessageHandler("UGS",((e,r)=>t(this,void 0,void 0,(function*(){const t=this._getGlobalState(e);for(const e in r)t[e]=r[e]})))),this.actor.registerMessageHandler("SL",((e,r)=>t(this,void 0,void 0,(function*(){this._getLayerIndex(e).replace(r,this._getGlobalState(e))}))))}_getGlobalState(t){let e=this.globalStates.get(t);return e||(e={},this.globalStates.set(t,e)),e}_setImages(e,r){return t(this,void 0,void 0,(function*(){this.availableImages[e]=r;for(const t in this.workerSources[e]){const n=this.workerSources[e][t];for(const t in n)n[t].availableImages=r}}))}_syncRTLPluginState(e,r){return t(this,void 0,void 0,(function*(){return yield Yi.syncState(r,this.self.importScripts)}))}_getAvailableImages(t){let e=this.availableImages[t];return e||(e=[]),e}_getLayerIndex(t){let e=this.layerIndexes[t];return e||(e=this.layerIndexes[t]=new Cc),e}_getWorkerSource(t,e,r){if(this.workerSources[t]||(this.workerSources[t]={}),this.workerSources[t][e]||(this.workerSources[t][e]={}),!this.workerSources[t][e][r]){const n={sendAsync:(e,r)=>(e.targetMapId=t,this.actor.sendAsync(e,r))};switch(e){case"vector":this.workerSources[t][e][r]=new Ph(n,this._getLayerIndex(t),this._getAvailableImages(t));break;case"geojson":this.workerSources[t][e][r]=new Dp(n,this._getLayerIndex(t),this._getAvailableImages(t));break;default:this.workerSources[t][e][r]=new this.externalWorkerSourceTypes[e](n,this._getLayerIndex(t),this._getAvailableImages(t))}}return this.workerSources[t][e][r]}_getDEMWorkerSource(t,e){return this.demWorkerSources[t]||(this.demWorkerSources[t]={}),this.demWorkerSources[t][e]||(this.demWorkerSources[t][e]=new Th),this.demWorkerSources[t][e]}}return b(self)&&(self.worker=new Fp(self)),Fp}();
//# sourceMappingURL=maplibre-gl-csp-worker.js.map
