/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.7.2/LICENSE.txt
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).maplibregl={})}(this,(function(t){"use strict";var e,i,r="5.7.2";function n(t,e,i,r){return new(i||(i=Promise))((function(n,s){function o(t){try{l(r.next(t))}catch(t){s(t)}}function a(t){try{l(r.throw(t))}catch(t){s(t)}}function l(t){var e;t.done?n(t.value):(e=t.value,e instanceof i?e:new i((function(t){t(e)}))).then(o,a)}l((r=r.apply(t,e||[])).next())}))}function s(t,e){this.x=t,this.y=e}function o(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}"function"==typeof SuppressedError&&SuppressedError,s.prototype={clone(){return new s(this.x,this.y)},add(t){return this.clone()._add(t)},sub(t){return this.clone()._sub(t)},multByPoint(t){return this.clone()._multByPoint(t)},divByPoint(t){return this.clone()._divByPoint(t)},mult(t){return this.clone()._mult(t)},div(t){return this.clone()._div(t)},rotate(t){return this.clone()._rotate(t)},rotateAround(t,e){return this.clone()._rotateAround(t,e)},matMult(t){return this.clone()._matMult(t)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(t){return this.x===t.x&&this.y===t.y},dist(t){return Math.sqrt(this.distSqr(t))},distSqr(t){const e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle(){return Math.atan2(this.y,this.x)},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith(t){return this.angleWithSep(t.x,t.y)},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add(t){return this.x+=t.x,this.y+=t.y,this},_sub(t){return this.x-=t.x,this.y-=t.y,this},_mult(t){return this.x*=t,this.y*=t,this},_div(t){return this.x/=t,this.y/=t,this},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this},_unit(){return this._div(this.mag()),this},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this},_rotate(t){const e=Math.cos(t),i=Math.sin(t),r=i*this.x+e*this.y;return this.x=e*this.x-i*this.y,this.y=r,this},_rotateAround(t,e){const i=Math.cos(t),r=Math.sin(t),n=e.y+r*(this.x-e.x)+i*(this.y-e.y);return this.x=e.x+i*(this.x-e.x)-r*(this.y-e.y),this.y=n,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:s},s.convert=function(t){if(t instanceof s)return t;if(Array.isArray(t))return new s(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new s(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format")};var a=function(){if(i)return e;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return i=1,e=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var o=0,a=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?o=i:a=i,i=.5*(a-o)+o;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},e}(),l=o(a);let c,h;function u(){return null==c&&(c="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),c}var p=1e-6,d="undefined"!=typeof Float32Array?Float32Array:Array;function f(){var t=new d(4);return d!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}function m(){var t=new d(9);return d!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function _(){var t=new d(16);return d!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function g(t){var e=new d(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function y(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function x(t,e){var i=e[0],r=e[1],n=e[2],s=e[3],o=e[4],a=e[5],l=e[6],c=e[7],h=e[8],u=e[9],p=e[10],d=e[11],f=e[12],m=e[13],_=e[14],g=e[15],y=i*a-r*o,x=i*l-n*o,v=i*c-s*o,b=r*l-n*a,w=r*c-s*a,T=n*c-s*l,P=h*m-u*f,S=h*_-p*f,M=h*g-d*f,I=u*_-p*m,C=u*g-d*m,E=p*g-d*_,A=y*E-x*C+v*I+b*M-w*S+T*P;return A?(t[0]=(a*E-l*C+c*I)*(A=1/A),t[1]=(n*C-r*E-s*I)*A,t[2]=(m*T-_*w+g*b)*A,t[3]=(p*w-u*T-d*b)*A,t[4]=(l*M-o*E-c*S)*A,t[5]=(i*E-n*M+s*S)*A,t[6]=(_*v-f*T-g*x)*A,t[7]=(h*T-p*v+d*x)*A,t[8]=(o*C-a*M+c*P)*A,t[9]=(r*M-i*C-s*P)*A,t[10]=(f*w-m*v+g*y)*A,t[11]=(u*v-h*w-d*y)*A,t[12]=(a*S-o*I-l*P)*A,t[13]=(i*I-r*S+n*P)*A,t[14]=(m*x-f*b-_*y)*A,t[15]=(h*b-u*x+p*y)*A,t):null}function v(t,e,i){var r=e[0],n=e[1],s=e[2],o=e[3],a=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],m=e[12],_=e[13],g=e[14],y=e[15],x=i[0],v=i[1],b=i[2],w=i[3];return t[0]=x*r+v*a+b*u+w*m,t[1]=x*n+v*l+b*p+w*_,t[2]=x*s+v*c+b*d+w*g,t[3]=x*o+v*h+b*f+w*y,t[4]=(x=i[4])*r+(v=i[5])*a+(b=i[6])*u+(w=i[7])*m,t[5]=x*n+v*l+b*p+w*_,t[6]=x*s+v*c+b*d+w*g,t[7]=x*o+v*h+b*f+w*y,t[8]=(x=i[8])*r+(v=i[9])*a+(b=i[10])*u+(w=i[11])*m,t[9]=x*n+v*l+b*p+w*_,t[10]=x*s+v*c+b*d+w*g,t[11]=x*o+v*h+b*f+w*y,t[12]=(x=i[12])*r+(v=i[13])*a+(b=i[14])*u+(w=i[15])*m,t[13]=x*n+v*l+b*p+w*_,t[14]=x*s+v*c+b*d+w*g,t[15]=x*o+v*h+b*f+w*y,t}function b(t,e,i){var r,n,s,o,a,l,c,h,u,p,d,f,m=i[0],_=i[1],g=i[2];return e===t?(t[12]=e[0]*m+e[4]*_+e[8]*g+e[12],t[13]=e[1]*m+e[5]*_+e[9]*g+e[13],t[14]=e[2]*m+e[6]*_+e[10]*g+e[14],t[15]=e[3]*m+e[7]*_+e[11]*g+e[15]):(n=e[1],s=e[2],o=e[3],a=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],t[0]=r=e[0],t[1]=n,t[2]=s,t[3]=o,t[4]=a,t[5]=l,t[6]=c,t[7]=h,t[8]=u,t[9]=p,t[10]=d,t[11]=f,t[12]=r*m+a*_+u*g+e[12],t[13]=n*m+l*_+p*g+e[13],t[14]=s*m+c*_+d*g+e[14],t[15]=o*m+h*_+f*g+e[15]),t}function w(t,e,i){var r=i[0],n=i[1],s=i[2];return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*n,t[5]=e[5]*n,t[6]=e[6]*n,t[7]=e[7]*n,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function T(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[4],o=e[5],a=e[6],l=e[7],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*n+c*r,t[5]=o*n+h*r,t[6]=a*n+u*r,t[7]=l*n+p*r,t[8]=c*n-s*r,t[9]=h*n-o*r,t[10]=u*n-a*r,t[11]=p*n-l*r,t}function P(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[0],o=e[1],a=e[2],l=e[3],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n-c*r,t[1]=o*n-h*r,t[2]=a*n-u*r,t[3]=l*n-p*r,t[8]=s*r+c*n,t[9]=o*r+h*n,t[10]=a*r+u*n,t[11]=l*r+p*n,t}function S(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[0],o=e[1],a=e[2],l=e[3],c=e[4],h=e[5],u=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n+c*r,t[1]=o*n+h*r,t[2]=a*n+u*r,t[3]=l*n+p*r,t[4]=c*n-s*r,t[5]=h*n-o*r,t[6]=u*n-a*r,t[7]=p*n-l*r,t}var M=function(t,e,i,r,n){var s=1/Math.tan(e/2);if(t[0]=s/i,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=n&&n!==1/0){var o=1/(r-n);t[10]=(n+r)*o,t[14]=2*n*r*o}else t[10]=-1,t[14]=-2*r;return t},I=function(t,e,i,r,n,s,o){var a=1/(e-i),l=1/(r-n),c=1/(s-o);return t[0]=-2*a,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*c,t[11]=0,t[12]=(e+i)*a,t[13]=(n+r)*l,t[14]=(o+s)*c,t[15]=1,t};function C(){var t=new d(3);return d!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function E(t){var e=new d(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function A(t){var e=t[0],i=t[1],r=t[2];return Math.sqrt(e*e+i*i+r*r)}function z(t,e,i){var r=new d(3);return r[0]=t,r[1]=e,r[2]=i,r}function k(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}function D(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i,t}function R(t,e){var i=e[0],r=e[1],n=e[2],s=i*i+r*r+n*n;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function L(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function B(t,e,i){var r=e[0],n=e[1],s=e[2],o=i[0],a=i[1],l=i[2];return t[0]=n*l-s*a,t[1]=s*o-r*l,t[2]=r*a-n*o,t}function F(t,e,i){var r=i[0],n=i[1],s=i[2],o=i[3],a=e[0],l=e[1],c=e[2],h=n*c-s*l,u=s*a-r*c,p=r*l-n*a;return t[0]=a+o*(h+=h)+n*(p+=p)-s*(u+=u),t[1]=l+o*u+s*h-r*p,t[2]=c+o*p+r*u-n*h,t}function O(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[0],s[1]=n[1]*Math.cos(r)-n[2]*Math.sin(r),s[2]=n[1]*Math.sin(r)+n[2]*Math.cos(r),t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}function j(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[2]*Math.sin(r)+n[0]*Math.cos(r),s[1]=n[1],s[2]=n[2]*Math.cos(r)-n[0]*Math.sin(r),t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}function V(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[0]*Math.cos(r)-n[1]*Math.sin(r),s[1]=n[0]*Math.sin(r)+n[1]*Math.cos(r),s[2]=n[2],t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}var N,U=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t},Z=A;function G(t,e,i){var r=e[0],n=e[1],s=e[2],o=e[3];return t[0]=i[0]*r+i[4]*n+i[8]*s+i[12]*o,t[1]=i[1]*r+i[5]*n+i[9]*s+i[13]*o,t[2]=i[2]*r+i[6]*n+i[10]*s+i[14]*o,t[3]=i[3]*r+i[7]*n+i[11]*s+i[15]*o,t}function $(){var t=new d(4);return d!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function q(t,e,i,r){var n=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",s=Math.PI/360;e*=s,r*=s,i*=s;var o=Math.sin(e),a=Math.cos(e),l=Math.sin(i),c=Math.cos(i),h=Math.sin(r),u=Math.cos(r);switch(n){case"xyz":t[0]=o*c*u+a*l*h,t[1]=a*l*u-o*c*h,t[2]=a*c*h+o*l*u,t[3]=a*c*u-o*l*h;break;case"xzy":t[0]=o*c*u-a*l*h,t[1]=a*l*u-o*c*h,t[2]=a*c*h+o*l*u,t[3]=a*c*u+o*l*h;break;case"yxz":t[0]=o*c*u+a*l*h,t[1]=a*l*u-o*c*h,t[2]=a*c*h-o*l*u,t[3]=a*c*u+o*l*h;break;case"yzx":t[0]=o*c*u+a*l*h,t[1]=a*l*u+o*c*h,t[2]=a*c*h-o*l*u,t[3]=a*c*u-o*l*h;break;case"zxy":t[0]=o*c*u-a*l*h,t[1]=a*l*u+o*c*h,t[2]=a*c*h+o*l*u,t[3]=a*c*u-o*l*h;break;case"zyx":t[0]=o*c*u-a*l*h,t[1]=a*l*u+o*c*h,t[2]=a*c*h-o*l*u,t[3]=a*c*u+o*l*h;break;default:throw new Error("Unknown angle order "+n)}return t}function W(){var t=new d(2);return d!=Float32Array&&(t[0]=0,t[1]=0),t}function H(t,e){var i=new d(2);return i[0]=t,i[1]=e,i}function X(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t}function Y(t){var e=t[0],i=t[1];return Math.sqrt(e*e+i*i)}function K(t){return t[0]=0,t[1]=0,t}C(),N=new d(4),d!=Float32Array&&(N[0]=0,N[1]=0,N[2]=0,N[3]=0),C(),z(1,0,0),z(0,1,0),$(),$(),m();var J=function(t){var e=t[0],i=t[1];return e*e+i*i};W();const Q=8192;function tt(t,e,i){return e*(Q/(t.tileSize*Math.pow(2,i-t.tileID.overscaledZ)))}function et(){return new Float64Array(4)}function it(){return new Float64Array(3)}function rt(){return new Float64Array(16)}function nt(){const t=new Float64Array(16);return y(t),t}function st(){const t=new Float32Array(16);return y(t),t}function ot(t,e,i,r,n=!1){if(!i[0]&&!i[1])return[0,0];const s=n?"map"===r?-t.bearingInRadians:0:"viewport"===r?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e]}return[n?i[0]:tt(e,i[0],t.zoom),n?i[1]:tt(e,i[1],t.zoom)]}function at(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]}function lt(t,e,i){const r=(n=[t[0],t[1],t[2],e[0],e[1],e[2],i[0],i[1],i[2]])[0]*((h=n[8])*(o=n[4])-(a=n[5])*(c=n[7]))+n[1]*(-h*(s=n[3])+a*(l=n[6]))+n[2]*(c*s-o*l);var n,s,o,a,l,c,h;if(0===r)return null;const u=B([],[e[0],e[1],e[2]],[i[0],i[1],i[2]]),p=B([],[i[0],i[1],i[2]],[t[0],t[1],t[2]]),d=B([],[t[0],t[1],t[2]],[e[0],e[1],e[2]]),f=D([],u,-t[3]);return k(f,f,D([],p,-e[3])),k(f,f,D([],d,-i[3])),D(f,f,1/r),f}function ct(t,e,i){const r=e[0]*i[0]+e[1]*i[1]+e[2]*i[2];return 0===r?null:(-(t[0]*i[0]+t[1]*i[1]+t[2]*i[2])-i[3])/r}function ht(t,e,i,r){const n=Math.sqrt(t*t+e*e),s=Math.sqrt(i*i+r*r);t/=n,e/=n,i/=s,r/=s;const o=Math.acos(t*i+e*r);return-e*i+t*r>0?o:-o}function ut(t,e){const i=dt(t,360),r=dt(e,360),n=r-i,s=r>i?n-360:n+360;return Math.abs(n)<Math.abs(s)?n:s}function pt(t,e){const i=dt(t,2*Math.PI),r=dt(e,2*Math.PI);return Math.min(Math.abs(i-r),Math.abs(i-r+2*Math.PI),Math.abs(i-r-2*Math.PI))}function dt(t,e){return(t%e+e)%e}function ft(t,e,i,r,n){return mt(r,n,vt((t-e)/(i-e),0,1))}function mt(t,e,i){return t*(1-i)+e*i}function _t(t){let e=1/0,i=1/0,r=-1/0,n=-1/0;for(const s of t)e=Math.min(e,s.x),i=Math.min(i,s.y),r=Math.max(r,s.x),n=Math.max(n,s.y);return[e,i,r,n]}function gt(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,i=e*t;return 4*(t<.5?i:3*(t-e)+i-.75)}function yt(t,e,i,r){const n=new l(t,e,i,r);return t=>n.solve(t)}const xt=yt(.25,.1,.25,1);function vt(t,e,i){return Math.min(i,Math.max(e,t))}function bt(t,e,i){const r=i-e,n=((t-e)%r+r)%r+e;return n===e?i:n}function wt(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}function Tt(t,e){const i={};for(let r=0;r<e.length;r++){const n=e[r];n in t&&(i[n]=t[n])}return i}let Pt=1;function St(){return Pt++}function Mt(t){return Math.pow(2,t)}function It(t){return Math.log(t)/Math.LN2}function Ct(t,e,i){const r={};for(const i in t)r[i]=e.call(this,t[i],i,t);return r}function Et(t,e,i){const r={};for(const i in t)e.call(this,t[i],i,t)&&(r[i]=t[i]);return r}function At(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!At(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!At(t[i],e[i]))return!1;return!0}return t===e}function zt(t){return Array.isArray(t)?t.map(zt):"object"==typeof t&&t?Ct(t,zt):t}const kt={};function Dt(t){kt[t]||("undefined"!=typeof console&&console.warn(t),kt[t]=!0)}function Rt(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}function Lt(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let Bt=null;function Ft(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const Ot="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function jt(t,e,i,r){return t.addEventListener(e,i,r),{unsubscribe:()=>{t.removeEventListener(e,i,r)}}}function Vt(t){return t*Math.PI/180}function Nt(t){return t/Math.PI*180}function Ut(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing}function Zt(t,e,i){const r=H(e.x-i.x,e.y-i.y),n=H(t.x-i.x,t.y-i.y);var s,o;return Nt(Math.atan2(r[0]*n[1]-r[1]*n[0],(s=r)[0]*(o=n)[0]+s[1]*o[1]))}function Gt(t,e,i){const r=new Float64Array(4);return q(r,t,e-90,i),r}const $t=85.051129,qt={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},Wt={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0};function Ht(t,e){return qt[e]&&"touches"in t}const Xt="AbortError";function Yt(){return new Error(Xt)}let Kt,Jt;const Qt={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frame(t,e,i){const r=requestAnimationFrame((t=>{n(),e(t)})),{unsubscribe:n}=jt(t.signal,"abort",(()=>{n(),cancelAnimationFrame(r),i(Yt())}),!1)},frameAsync(t){return new Promise(((e,i)=>{this.frame(t,e,i)}))},getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>(Kt||(Kt=document.createElement("a")),Kt.href=t,Kt.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return!!matchMedia&&(null==Jt&&(Jt=matchMedia("(prefers-reduced-motion: reduce)")),Jt.matches)}};class te{static testProp(t){if(!te.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in te.docStyle)return t[e];return t[0]}static create(t,e,i){const r=window.document.createElement(t);return void 0!==e&&(r.className=e),i&&i.appendChild(r),r}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){te.docStyle&&te.selectProp&&(te.userSelect=te.docStyle[te.selectProp],te.docStyle[te.selectProp]="none")}static enableDrag(){te.docStyle&&te.selectProp&&(te.docStyle[te.selectProp]=te.userSelect)}static setTransform(t,e){t.style[te.transformProp]=e}static addEventListener(t,e,i,r={}){t.addEventListener(e,i,"passive"in r?r:r.capture)}static removeEventListener(t,e,i,r={}){t.removeEventListener(e,i,"passive"in r?r:r.capture)}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",te.suppressClickInternal,!0)}static suppressClick(){window.addEventListener("click",te.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",te.suppressClickInternal,!0)}),0)}static getScale(t){const e=t.getBoundingClientRect();return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,e,i){const r=e.boundingClientRect;return new s((i.clientX-r.left)/e.x-t.clientLeft,(i.clientY-r.top)/e.y-t.clientTop)}static mousePos(t,e){const i=te.getScale(t);return te.getPoint(t,i,e)}static touchPos(t,e){const i=[],r=te.getScale(t);for(let n=0;n<e.length;n++)i.push(te.getPoint(t,r,e[n]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t)}static sanitize(t){const e=(new DOMParser).parseFromString(t,"text/html").body||document.createElement("body"),i=e.querySelectorAll("script");for(const t of i)t.remove();return te.clean(e),e.innerHTML}static isPossiblyDangerous(t,e){const i=e.replace(/\s+/g,"").toLowerCase();return!(!["src","href","xlink:href"].includes(t)||!i.includes("javascript:")&&!i.includes("data:"))||!!t.startsWith("on")||void 0}static clean(t){const e=t.children;for(const t of e)te.removeAttributes(t),te.clean(t)}static removeAttributes(t){for(const{name:e,value:i}of t.attributes)te.isPossiblyDangerous(e,i)&&t.removeAttribute(e)}}te.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,te.selectProp=te.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),te.transformProp=te.testProp(["transform","WebkitTransform"]);const ee={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function ie(t){return ee.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const re="global-dispatcher";class ne extends Error{constructor(t,e,i,r){super(`AJAXError: ${e} (${t}): ${i}`),this.status=t,this.statusText=e,this.url=i,this.body=r}}const se=()=>Lt(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,oe=function(t,e){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const i=ie(t.url);if(i)return i(t,e);if(Lt(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:re},e)}if(!(/^file:/.test(i=t.url)||/^file:/.test(se())&&!/^\w+:/.test(i))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,e){return n(this,void 0,void 0,(function*(){const i=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:se(),signal:e.signal});let r,n;"json"!==t.type||i.headers.has("Accept")||i.headers.set("Accept","application/json");try{r=yield fetch(i)}catch(e){throw new ne(0,e.message,t.url,new Blob)}if(!r.ok){const e=yield r.blob();throw new ne(r.status,r.statusText,t.url,e)}n="arrayBuffer"===t.type||"image"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text();const s=yield n;if(e.signal.aborted)throw Yt();return{data:s,cacheControl:r.headers.get("Cache-Control"),expires:r.headers.get("Expires")}}))}(t,e);if(Lt(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:re},e)}var i;return function(t,e){return new Promise(((i,r)=>{var n;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(n=t.headers)||void 0===n?void 0:n.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{r(new Error(s.statusText))},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response)}catch(t){return void r(t)}i({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});r(new ne(s.status,s.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{s.abort(),r(Yt())})),s.send(t.body)}))}(t,e)},ae=(t,e)=>oe(wt(t,{type:"json"}),e);function le(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return!0;const e=new URL(t),i=window.location;return e.protocol===i.protocol&&e.host===i.host}const ce={supported:!1,testSupport:function(t){!pe&&ue&&(de?fe(t):he=t)}};let he,ue,pe=!1,de=!1;function fe(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,ue),t.isContextLost())return;ce.supported=!0}catch(t){}t.deleteTexture(e),pe=!0}var me;"undefined"!=typeof document&&(ue=document.createElement("img"),ue.onload=()=>{he&&fe(he),he=null,de=!0},ue.onerror=()=>{pe=!0,he=null},ue.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let e,i,r,s;t.resetRequestQueue=()=>{e=[],i=0,r=0,s={}},t.addThrottleControl=t=>{const e=r++;return s[e]=t,e},t.removeThrottleControl=t=>{delete s[t],a()},t.getImage=(t,i,r=!0)=>new Promise(((n,s)=>{ce.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),wt(t,{type:"image"});const o={abortController:i,requestParameters:t,supportImageRefresh:r,state:"queued",onError:t=>{s(t)},onSuccess:t=>{n(t)}};e.push(o),a()}));const o=t=>n(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:e,supportImageRefresh:r,onError:s,onSuccess:o,abortController:c}=t,h=!1===r&&!Lt(self)&&!ie(e.url)&&(!e.headers||Object.keys(e.headers).reduce(((t,e)=>t&&"accept"===e),!0));i++;const u=h?l(e,c):oe(e,c);try{const e=yield u;delete t.abortController,t.state="completed",e.data instanceof HTMLImageElement||Ft(e.data)?o(e):e.data&&o({data:yield(p=e.data,"function"==typeof createImageBitmap?(t=>n(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})))(p):(t=>new Promise(((e,i)=>{const r=new Image;r.onload=()=>{e(r),URL.revokeObjectURL(r.src),r.onload=null,window.requestAnimationFrame((()=>{r.src=Ot}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):Ot})))(p)),cacheControl:e.cacheControl,expires:e.expires})}catch(e){delete t.abortController,s(e)}finally{i--,a()}var p})),a=()=>{const t=(()=>{for(const t of Object.keys(s))if(s[t]())return!0;return!1})()?ee.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:ee.MAX_PARALLEL_IMAGE_REQUESTS;for(let r=i;r<t&&e.length>0;r++){const t=e.shift();t.abortController.signal.aborted?r--:o(t)}},l=(t,e)=>new Promise(((i,r)=>{const n=new Image,s=t.url,o=t.credentials;o&&"include"===o?n.crossOrigin="use-credentials":(o&&"same-origin"===o||!le(s))&&(n.crossOrigin="anonymous"),e.signal.addEventListener("abort",(()=>{n.src="",r(Yt())})),n.fetchPriority="high",n.onload=()=>{n.onerror=n.onload=null,i({data:n})},n.onerror=()=>{n.onerror=n.onload=null,e.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."))},n.src=s}))}(me||(me={})),me.resetRequestQueue();class _e{constructor(t){this._transformRequestFn=null!=t?t:null}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}setTransformRequest(t){this._transformRequestFn=t}}function ge(t,e,i){i[t]&&-1!==i[t].indexOf(e)||(i[t]=i[t]||[],i[t].push(e))}function ye(t,e,i){if(i&&i[t]){const r=i[t].indexOf(e);-1!==r&&i[t].splice(r,1)}}class xe{constructor(t,e={}){wt(this,e),this.type=t}}class ve extends xe{constructor(t,e={}){super("error",wt({error:t},e))}}class be{on(t,e){return this._listeners=this._listeners||{},ge(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return ye(t,e,this._listeners),ye(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},ge(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new xe(t,e||{}));const i=t.type;if(this.listens(i)){t.target=this;const e=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of e)i.call(this,t);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const e of r)ye(i,e,this._oneTimeListeners),e.call(this,t);const n=this._eventedParent;n&&(wt(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(t))}else t instanceof ve&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var we={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"array",value:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const Te=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function Pe(t,e){const i={};for(const e in t)"ref"!==e&&(i[e]=t[e]);return Te.forEach((t=>{t in e&&(i[t]=e[t])})),i}function Se(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=Pe(t[i],e[t[i].ref]));return t}function Me(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!Me(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!Me(t[i],e[i]))return!1;return!0}return t===e}function Ie(t,e){t.push(e)}function Ce(t,e,i){Ie(i,{command:"addSource",args:[t,e[t]]})}function Ee(t,e,i){Ie(e,{command:"removeSource",args:[t]}),i[t]=!0}function Ae(t,e,i,r){Ee(t,i,r),Ce(t,e,i)}function ze(t,e,i){let r;for(r in t[i])if(Object.prototype.hasOwnProperty.call(t[i],r)&&"data"!==r&&!Me(t[i][r],e[i][r]))return!1;for(r in e[i])if(Object.prototype.hasOwnProperty.call(e[i],r)&&"data"!==r&&!Me(t[i][r],e[i][r]))return!1;return!0}function ke(t,e,i,r,n,s){t=t||{},e=e||{};for(const o in t)Object.prototype.hasOwnProperty.call(t,o)&&(Me(t[o],e[o])||i.push({command:s,args:[r,o,e[o],n]}));for(const o in e)Object.prototype.hasOwnProperty.call(e,o)&&!Object.prototype.hasOwnProperty.call(t,o)&&(Me(t[o],e[o])||i.push({command:s,args:[r,o,e[o],n]}))}function De(t){return t.id}function Re(t,e){return t[e.id]=e,t}class Le{constructor(t,e,i,r){this.message=(t?`${t}: `:"")+i,r&&(this.identifier=r),null!=e&&e.__line__&&(this.line=e.__line__)}}function Be(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}class Fe extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class Oe{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,i]of e)this.bindings[t]=i}concat(t){return new Oe(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const je={kind:"null"},Ve={kind:"number"},Ne={kind:"string"},Ue={kind:"boolean"},Ze={kind:"color"},Ge={kind:"projectionDefinition"},$e={kind:"object"},qe={kind:"value"},We={kind:"collator"},He={kind:"formatted"},Xe={kind:"padding"},Ye={kind:"colorArray"},Ke={kind:"numberArray"},Je={kind:"resolvedImage"},Qe={kind:"variableAnchorOffsetCollection"};function ti(t,e){return{kind:"array",itemType:t,N:e}}function ei(t){if("array"===t.kind){const e=ei(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const ii=[je,Ve,Ne,Ue,Ze,Ge,He,$e,ti(qe),Xe,Ke,Ye,Je,Qe];function ri(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!ri(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of ii)if(!ri(t,e))return null}return`Expected ${ei(t)} but found ${ei(e)} instead.`}function ni(t,e){return e.some((e=>e.kind===t.kind))}function si(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function oi(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const ai=.96422,li=.82521,ci=4/29,hi=6/29,ui=3*hi*hi,pi=hi*hi*hi,di=Math.PI/180,fi=180/Math.PI;function mi(t){return(t%=360)<0&&(t+=360),t}function _i([t,e,i,r]){let n,s;const o=yi((.2225045*(t=gi(t))+.7168786*(e=gi(e))+.0606169*(i=gi(i)))/1);t===e&&e===i?n=s=o:(n=yi((.4360747*t+.3850649*e+.1430804*i)/ai),s=yi((.0139322*t+.0971045*e+.7141733*i)/li));const a=116*o-16;return[a<0?0:a,500*(n-o),200*(o-s),r]}function gi(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function yi(t){return t>pi?Math.pow(t,1/3):t/ui+ci}function xi([t,e,i,r]){let n=(t+16)/116,s=isNaN(e)?n:n+e/500,o=isNaN(i)?n:n-i/200;return n=1*bi(n),s=ai*bi(s),o=li*bi(o),[vi(3.1338561*s-1.6168667*n-.4906146*o),vi(-.9787684*s+1.9161415*n+.033454*o),vi(.0719453*s-.2289914*n+1.4052427*o),r]}function vi(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function bi(t){return t>hi?t*t*t:ui*(t-ci)}const wi=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function Ti(t,e){return wi(t,e)?t[e]:void 0}function Pi(t){return parseInt(t.padEnd(2,t),16)/255}function Si(t,e){return Mi(e?t/100:t,0,1)}function Mi(t,e,i){return Math.min(Math.max(e,t),i)}function Ii(t){return!t.some(Number.isNaN)}const Ci={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function Ei(t,e,i){return t+i*(e-t)}function Ai(t,e,i){return t.map(((t,r)=>Ei(t,e[r],i)))}class zi{constructor(t,e,i,r=1,n=!0){this.r=t,this.g=e,this.b=i,this.a=r,n||(this.r*=r,this.g*=r,this.b*=r,r||this.overwriteGetter("rgb",[t,e,i,r]))}static parse(t){if(t instanceof zi)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=Ti(Ci,t);if(e){const[t,i,r]=e;return[t/255,i/255,r/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let i=1;return[Pi(t.slice(i,i+=e)),Pi(t.slice(i,i+=e)),Pi(t.slice(i,i+=e)),Pi(t.slice(i,i+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,i,r,n,s,o,a,l,c,h,u,p]=e,d=[n||" ",a||" ",h].join("");if("  "===d||"  /"===d||",,"===d||",,,"===d){const t=[r,o,c].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[Mi(+i/e,0,1),Mi(+s/e,0,1),Mi(+l/e,0,1),u?Si(+u,p):1];if(Ii(t))return t}}return}}const i=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(i){const[t,e,r,n,s,o,a,l,c]=i,h=[r||" ",s||" ",a].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const t=[+e,Mi(+n,0,100),Mi(+o,0,100),l?Si(+l,c):1];if(Ii(t))return function([t,e,i,r]){function n(r){const n=(r+t/30)%12,s=e*Math.min(i,1-i);return i-s*Math.max(-1,Math.min(n-3,9-n,1))}return t=mi(t),e/=100,i/=100,[n(0),n(8),n(4),r]}(t)}}}(t);return e?new zi(...e,!1):void 0}get rgb(){const{r:t,g:e,b:i,a:r}=this,n=r||1/0;return this.overwriteGetter("rgb",[t/n,e/n,i/n,r])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,i,r,n]=_i(t),s=Math.sqrt(i*i+r*r);return[Math.round(1e4*s)?mi(Math.atan2(r,i)*fi):NaN,s,e,n]}(this.rgb))}get lab(){return this.overwriteGetter("lab",_i(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,i,r]=this.rgb;return`rgba(${[t,e,i].map((t=>Math.round(255*t))).join(",")},${r})`}static interpolate(t,e,i,r="rgb"){switch(r){case"rgb":{const[r,n,s,o]=Ai(t.rgb,e.rgb,i);return new zi(r,n,s,o,!1)}case"hcl":{const[r,n,s,o]=t.hcl,[a,l,c,h]=e.hcl;let u,p;if(isNaN(r)||isNaN(a))isNaN(r)?isNaN(a)?u=NaN:(u=a,1!==s&&0!==s||(p=l)):(u=r,1!==c&&0!==c||(p=n));else{let t=a-r;a>r&&t>180?t-=360:a<r&&r-a>180&&(t+=360),u=r+i*t}const[d,f,m,_]=function([t,e,i,r]){return t=isNaN(t)?0:t*di,xi([i,Math.cos(t)*e,Math.sin(t)*e,r])}([u,null!=p?p:Ei(n,l,i),Ei(s,c,i),Ei(o,h,i)]);return new zi(d,f,m,_,!1)}case"lab":{const[r,n,s,o]=xi(Ai(t.lab,e.lab,i));return new zi(r,n,s,o,!1)}}}}zi.black=new zi(0,0,0,1),zi.white=new zi(1,1,1,1),zi.transparent=new zi(0,0,0,0),zi.red=new zi(1,0,0,1);class ki{constructor(t,e,i){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Di=["bottom","center","top"];class Ri{constructor(t,e,i,r,n,s){this.text=t,this.image=e,this.scale=i,this.fontStack=r,this.textColor=n,this.verticalAlign=s}}class Li{constructor(t){this.sections=t}static fromString(t){return new Li([new Ri(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Li?t:Li.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Bi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Bi)return t;if("number"==typeof t)return new Bi([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new Bi(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new Bi(Ai(t.values,e.values,i))}}class Fi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Fi)return t;if("number"==typeof t)return new Fi([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Fi(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new Fi(Ai(t.values,e.values,i))}}class Oi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Oi)return t;if("string"==typeof t){const e=zi.parse(t);if(!e)return;return new Oi([e])}if(!Array.isArray(t))return;const e=[];for(const i of t){if("string"!=typeof i)return;const t=zi.parse(i);if(!t)return;e.push(t)}return new Oi(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i,r="rgb"){const n=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)n.push(zi.interpolate(t.values[s],e.values[s],i,r));return new Oi(n)}}class ji extends Error{constructor(t){super(t),this.name="RuntimeError"}toJSON(){return this.message}}const Vi=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Ni{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ni)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const i=t[e],r=t[e+1];if("string"!=typeof i||!Vi.has(i))return;if(!Array.isArray(r)||2!==r.length||"number"!=typeof r[0]||"number"!=typeof r[1])return}return new Ni(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){const r=t.values,n=e.values;if(r.length!==n.length)throw new ji(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<r.length;t+=2){if(r[t]!==n[t])throw new ji(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${r[t]}, to[${t}]: ${n[t]}`);s.push(r[t]);const[e,o]=r[t+1],[a,l]=n[t+1];s.push([Ei(e,a,i),Ei(o,l,i)])}return new Ni(s)}}class Ui{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new Ui({name:t,available:!1}):null}}class Zi{constructor(t,e,i){this.from=t,this.to=e,this.transition=i}static interpolate(t,e,i){return new Zi(t,e,i)}static parse(t){return t instanceof Zi?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new Zi(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new Zi(t.from,t.to,t.transition):"string"==typeof t?new Zi(t,t,1):void 0}}function Gi(t,e,i,r){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[t,e,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[t,e,i,r]:[t,e,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function $i(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Zi||t instanceof zi||t instanceof ki||t instanceof Li||t instanceof Bi||t instanceof Fi||t instanceof Oi||t instanceof Ni||t instanceof Ui)return!0;if(Array.isArray(t)){for(const e of t)if(!$i(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!$i(t[e]))return!1;return!0}return!1}function qi(t){if(null===t)return je;if("string"==typeof t)return Ne;if("boolean"==typeof t)return Ue;if("number"==typeof t)return Ve;if(t instanceof zi)return Ze;if(t instanceof Zi)return Ge;if(t instanceof ki)return We;if(t instanceof Li)return He;if(t instanceof Bi)return Xe;if(t instanceof Fi)return Ke;if(t instanceof Oi)return Ye;if(t instanceof Ni)return Qe;if(t instanceof Ui)return Je;if(Array.isArray(t)){const e=t.length;let i;for(const e of t){const t=qi(e);if(i){if(i===t)continue;i=qe;break}i=t}return ti(i||qe,e)}return $e}function Wi(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof zi||t instanceof Zi||t instanceof Li||t instanceof Bi||t instanceof Fi||t instanceof Oi||t instanceof Ni||t instanceof Ui?t.toString():JSON.stringify(t)}class Hi{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!$i(t[1]))return e.error("invalid value");const i=t[1];let r=qi(i);const n=e.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Hi(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Xi={string:Ne,number:Ve,boolean:Ue,object:$e};class Yi{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i,r=1;const n=t[0];if("array"===n){let n,s;if(t.length>2){const i=t[1];if("string"!=typeof i||!(i in Xi)||"object"===i)return e.error('The item type argument of "array" must be one of string, number, boolean',1);n=Xi[i],r++}else n=qe;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],r++}i=ti(n,s)}else{if(!Xi[n])throw new Error(`Types doesn't contain name = ${n}`);i=Xi[n]}const s=[];for(;r<t.length;r++){const i=e.parse(t[r],r,qe);if(!i)return null;s.push(i)}return new Yi(i,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const i=this.args[e].evaluate(t);if(!ri(this.type,qi(i)))return i;if(e===this.args.length-1)throw new ji(`Expected value to be of type ${ei(this.type)}, but found ${ei(qi(i))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Ki={"to-boolean":Ue,"to-color":Ze,"to-number":Ve,"to-string":Ne};class Ji{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[0];if(!Ki[i])throw new Error(`Can't parse ${i} as it is not part of the known types`);if(("to-boolean"===i||"to-string"===i)&&2!==t.length)return e.error("Expected one argument.");const r=Ki[i],n=[];for(let i=1;i<t.length;i++){const r=e.parse(t[i],i,qe);if(!r)return null;n.push(r)}return new Ji(r,n)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,i;for(const r of this.args){if(e=r.evaluate(t),i=null,e instanceof zi)return e;if("string"==typeof e){const i=t.parseColor(e);if(i)return i}else if(Array.isArray(e)&&(i=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Gi(e[0],e[1],e[2],e[3]),!i))return new zi(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new ji(i||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const i of this.args){e=i.evaluate(t);const r=Bi.parse(e);if(r)return r}throw new ji(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"numberArray":{let e;for(const i of this.args){e=i.evaluate(t);const r=Fi.parse(e);if(r)return r}throw new ji(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"colorArray":{let e;for(const i of this.args){e=i.evaluate(t);const r=Oi.parse(e);if(r)return r}throw new ji(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const i of this.args){e=i.evaluate(t);const r=Ni.parse(e);if(r)return r}throw new ji(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const i of this.args){if(e=i.evaluate(t),null===e)return 0;const r=Number(e);if(!isNaN(r))return r}throw new ji(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Li.fromString(Wi(this.args[0].evaluate(t)));case"resolvedImage":return Ui.fromString(Wi(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Wi(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Qi=["Unknown","Point","LineString","Polygon"];class tr{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Qi[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=zi.parse(t),this._parseColorCache.set(t,e)),e}}class er{constructor(t,e,i=[],r,n=new Oe,s=[]){this.registry=t,this.path=i,this.key=i.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=s,this.expectedType=r,this._isConstant=e}parse(t,e,i,r,n={}){return e?this.concat(e,i,r)._parse(t,n):this._parse(t,n)}_parse(t,e){function i(t,e,i){return"assert"===i?new Yi(e,[t]):"coerce"===i?new Ji(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=t[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[r];if(n){let r=n.parse(t,this);if(!r)return null;if(this.expectedType){const t=this.expectedType,n=r.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(n.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(n.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(n.kind)||"colorArray"===t.kind&&["value","string","array"].includes(n.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(n.kind))r=i(r,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,n))return null}else r=i(r,t,e.typeAnnotation||"assert")}if(!(r instanceof Hi)&&"resolvedImage"!==r.type.kind&&this._isConstant(r)){const t=new tr;try{r=new Hi(r.type,r.evaluate(t))}catch(t){return this.error(t.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,i){const r="number"==typeof t?this.path.concat(t):this.path,n=i?this.scope.concat(i):this.scope;return new er(this.registry,this._isConstant,r,e||null,n,this.errors)}error(t,...e){const i=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Fe(i,t))}checkSubtype(t,e){const i=ri(t,e);return i&&this.error(i),i}}class ir{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const i=[];for(let r=1;r<t.length-1;r+=2){const n=t[r];if("string"!=typeof n)return e.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return e.error("Variable names must contain only alphanumeric characters or '_'.",r);const s=e.parse(t[r+1],r+1);if(!s)return null;i.push([n,s])}const r=e.parse(t[t.length-1],t.length-1,e.expectedType,i);return r?new ir(i,r):null}outputDefined(){return this.result.outputDefined()}}class rr{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const i=t[1];return e.scope.has(i)?new rr(i,e.scope.get(i)):e.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class nr{constructor(t,e,i){this.type=t,this.index=e,this.input=i}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Ve),r=e.parse(t[2],2,ti(e.expectedType||qe));return i&&r?new nr(r.type.itemType,i,r):null}evaluate(t){const e=this.index.evaluate(t),i=this.input.evaluate(t);if(e<0)throw new ji(`Array index out of bounds: ${e} < 0.`);if(e>=i.length)throw new ji(`Array index out of bounds: ${e} > ${i.length-1}.`);if(e!==Math.floor(e))throw new ji(`Array index must be an integer, but found ${e} instead.`);return i[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class sr{constructor(t,e){this.type=Ue,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,qe),r=e.parse(t[2],2,qe);return i&&r?ni(i.type,[Ue,Ne,Ve,je,qe])?new sr(i,r):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ei(i.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!i)return!1;if(!si(e,["boolean","string","number","null"]))throw new ji(`Expected first argument to be of type boolean, string, number or null, but found ${ei(qi(e))} instead.`);if(!si(i,["string","array"]))throw new ji(`Expected second argument to be of type array or string, but found ${ei(qi(i))} instead.`);return i.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class or{constructor(t,e,i){this.type=Ve,this.needle=t,this.haystack=e,this.fromIndex=i}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,qe),r=e.parse(t[2],2,qe);if(!i||!r)return null;if(!ni(i.type,[Ue,Ne,Ve,je,qe]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ei(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Ve);return n?new or(i,r,n):null}return new or(i,r)}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!si(e,["boolean","string","number","null"]))throw new ji(`Expected first argument to be of type boolean, string, number or null, but found ${ei(qi(e))} instead.`);let r;if(this.fromIndex&&(r=this.fromIndex.evaluate(t)),si(i,["string"])){const t=i.indexOf(e,r);return-1===t?-1:[...i.slice(0,t)].length}if(si(i,["array"]))return i.indexOf(e,r);throw new ji(`Expected second argument to be of type array or string, but found ${ei(qi(i))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class ar{constructor(t,e,i,r,n,s){this.inputType=t,this.type=e,this.input=i,this.cases=r,this.outputs=n,this.otherwise=s}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let i,r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const c=e.concat(o);if(0===a.length)return c.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return c.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,qi(t)))return null}else i=qi(t);if(void 0!==n[String(t)])return c.error("Branch labels must be unique.");n[String(t)]=s.length}const h=e.parse(l,o,r);if(!h)return null;r=r||h.type,s.push(h)}const o=e.parse(t[1],1,qe);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,r);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(i,o.type)?null:new ar(i,r,o,n,s,a):null}evaluate(t){const e=this.input.evaluate(t);return(qi(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class lr{constructor(t,e,i){this.type=t,this.branches=e,this.otherwise=i}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const r=[];for(let n=1;n<t.length-1;n+=2){const s=e.parse(t[n],n,Ue);if(!s)return null;const o=e.parse(t[n+1],n+1,i);if(!o)return null;r.push([s,o]),i=i||o.type}const n=e.parse(t[t.length-1],t.length-1,i);if(!n)return null;if(!i)throw new Error("Can't infer output type");return new lr(i,r,n)}evaluate(t){for(const[e,i]of this.branches)if(e.evaluate(t))return i.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,i]of this.branches)t(e),t(i);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class cr{constructor(t,e,i,r){this.type=t,this.input=e,this.beginIndex=i,this.endIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,qe),r=e.parse(t[2],2,Ve);if(!i||!r)return null;if(!ni(i.type,[ti(qe),Ne,qe]))return e.error(`Expected first argument to be of type array or string, but found ${ei(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Ve);return n?new cr(i.type,i,r,n):null}return new cr(i.type,i,r)}evaluate(t){const e=this.input.evaluate(t),i=this.beginIndex.evaluate(t);let r;if(this.endIndex&&(r=this.endIndex.evaluate(t)),si(e,["string"]))return[...e].slice(i,r).join("");if(si(e,["array"]))return e.slice(i,r);throw new ji(`Expected first argument to be of type array or string, but found ${ei(qi(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function hr(t,e){const i=t.length-1;let r,n,s=0,o=i,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),r=t[a],n=t[a+1],r<=e){if(a===i||e<n)return a;s=a+1}else{if(!(r>e))throw new ji("Input is not a number.");o=a-1}return 0}class ur{constructor(t,e,i){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const i=e.parse(t[1],1,Ve);if(!i)return null;const r=[];let n=null;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);for(let i=1;i<t.length;i+=2){const s=1===i?-1/0:t[i],o=t[i+1],a=i,l=i+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(r.length&&r[r.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const c=e.parse(o,l,n);if(!c)return null;n=n||c.type,r.push([s,c])}return new ur(n,i,r)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;return r>=e[n-1]?i[n-1].evaluate(t):i[hr(e,r)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function pr(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var dr,fr,mr=function(){if(fr)return dr;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return fr=1,dr=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var o=0,a=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?o=i:a=i,i=.5*(a-o)+o;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},dr}(),_r=pr(mr);class gr{constructor(t,e,i,r,n){this.type=t,this.operator=e,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[t,e]of n)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,i,r){let n=0;if("exponential"===t.name)n=yr(e,t.base,i,r);else if("linear"===t.name)n=yr(e,1,i,r);else if("cubic-bezier"===t.name){const s=t.controlPoints;n=new _r(s[0],s[1],s[2],s[3]).solve(yr(e,1,i,r))}return n}static parse(t,e){let[i,r,n,...s]=t;if(!Array.isArray(r)||0===r.length)return e.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const t=r[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:t}}else{if("cubic-bezier"!==r[0])return e.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const t=r.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(n=e.parse(n,2,Ve),!n)return null;const o=[];let a=null;"interpolate-hcl"!==i&&"interpolate-lab"!==i||e.expectedType==Ye?e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType):a=Ze;for(let t=0;t<s.length;t+=2){const i=s[t],r=s[t+1],n=t+3,l=t+4;if("number"!=typeof i)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(o.length&&o[o.length-1][0]>=i)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=e.parse(r,l,a);if(!c)return null;a=a||c.type,o.push([i,c])}return oi(a,Ve)||oi(a,Ge)||oi(a,Ze)||oi(a,Xe)||oi(a,Ke)||oi(a,Ye)||oi(a,Qe)||oi(a,ti(Ve))?new gr(a,i,r,n,o):e.error(`Type ${ei(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;if(r>=e[n-1])return i[n-1].evaluate(t);const s=hr(e,r),o=gr.interpolationFactor(this.interpolation,r,e[s],e[s+1]),a=i[s].evaluate(t),l=i[s+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return Ei(a,l,o);case"color":return zi.interpolate(a,l,o);case"padding":return Bi.interpolate(a,l,o);case"colorArray":return Oi.interpolate(a,l,o);case"numberArray":return Fi.interpolate(a,l,o);case"variableAnchorOffsetCollection":return Ni.interpolate(a,l,o);case"array":return Ai(a,l,o);case"projectionDefinition":return Zi.interpolate(a,l,o)}case"interpolate-hcl":switch(this.type.kind){case"color":return zi.interpolate(a,l,o,"hcl");case"colorArray":return Oi.interpolate(a,l,o,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return zi.interpolate(a,l,o,"lab");case"colorArray":return Oi.interpolate(a,l,o,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function yr(t,e,i,r){const n=r-i,s=t-i;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}const xr={color:zi.interpolate,number:Ei,padding:Bi.interpolate,numberArray:Fi.interpolate,colorArray:Oi.interpolate,variableAnchorOffsetCollection:Ni.interpolate,array:Ai};class vr{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i=null;const r=e.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of t.slice(1)){const t=e.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!t)return null;i=i||t.type,n.push(t)}if(!i)throw new Error("No output type");const s=r&&n.some((t=>ri(r,t.type)));return new vr(s?qe:i,n)}evaluate(t){let e,i=null,r=0;for(const n of this.args)if(r++,i=n.evaluate(t),i&&i instanceof Ui&&!i.available&&(e||(e=i.name),i=null,r===this.args.length&&(i=e)),null!==i)break;return i}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function br(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function wr(t,e,i,r){return 0===r.compare(e,i)}function Tr(t,e,i){const r="=="!==t&&"!="!==t;return class n{constructor(t,e,i){this.type=Ue,this.lhs=t,this.rhs=e,this.collator=i,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const i=t[0];let s=e.parse(t[1],1,qe);if(!s)return null;if(!br(i,s.type))return e.concat(1).error(`"${i}" comparisons are not supported for type '${ei(s.type)}'.`);let o=e.parse(t[2],2,qe);if(!o)return null;if(!br(i,o.type))return e.concat(2).error(`"${i}" comparisons are not supported for type '${ei(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${ei(s.type)}' and '${ei(o.type)}'.`);r&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Yi(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Yi(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,We),!a)return null}return new n(s,o,a)}evaluate(n){const s=this.lhs.evaluate(n),o=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const e=qi(s),i=qi(o);if(e.kind!==i.kind||"string"!==e.kind&&"number"!==e.kind)throw new ji(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const t=qi(s),i=qi(o);if("string"!==t.kind||"string"!==i.kind)return e(n,s,o)}return this.collator?i(n,s,o,this.collator.evaluate(n)):e(n,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const Pr=Tr("==",(function(t,e,i){return e===i}),wr),Sr=Tr("!=",(function(t,e,i){return e!==i}),(function(t,e,i,r){return!wr(0,e,i,r)})),Mr=Tr("<",(function(t,e,i){return e<i}),(function(t,e,i,r){return r.compare(e,i)<0})),Ir=Tr(">",(function(t,e,i){return e>i}),(function(t,e,i,r){return r.compare(e,i)>0})),Cr=Tr("<=",(function(t,e,i){return e<=i}),(function(t,e,i,r){return r.compare(e,i)<=0})),Er=Tr(">=",(function(t,e,i){return e>=i}),(function(t,e,i,r){return r.compare(e,i)>=0}));class Ar{constructor(t,e,i){this.type=We,this.locale=i,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const i=t[1];if("object"!=typeof i||Array.isArray(i))return e.error("Collator options argument must be an object.");const r=e.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,Ue);if(!r)return null;const n=e.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,Ue);if(!n)return null;let s=null;return i.locale&&(s=e.parse(i.locale,1,Ne),!s)?null:new Ar(r,n,s)}evaluate(t){return new ki(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class zr{constructor(t,e,i,r,n){this.type=Ne,this.number=t,this.locale=e,this.currency=i,this.minFractionDigits=r,this.maxFractionDigits=n}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Ve);if(!i)return null;const r=t[2];if("object"!=typeof r||Array.isArray(r))return e.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=e.parse(r.locale,1,Ne),!n))return null;let s=null;if(r.currency&&(s=e.parse(r.currency,1,Ne),!s))return null;let o=null;if(r["min-fraction-digits"]&&(o=e.parse(r["min-fraction-digits"],1,Ve),!o))return null;let a=null;return r["max-fraction-digits"]&&(a=e.parse(r["max-fraction-digits"],1,Ve),!a)?null:new zr(i,n,s,o,a)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class kr{constructor(t){this.type=He,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[1];if(!Array.isArray(i)&&"object"==typeof i)return e.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=t.length-1;++i){const s=t[i];if(n&&"object"==typeof s&&!Array.isArray(s)){n=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Ve),!t))return null;let i=null;if(s["text-font"]&&(i=e.parse(s["text-font"],1,ti(Ne)),!i))return null;let o=null;if(s["text-color"]&&(o=e.parse(s["text-color"],1,Ze),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Di.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=e.parse(s["vertical-align"],1,Ne),!a)return null}const l=r[r.length-1];l.scale=t,l.font=i,l.textColor=o,l.verticalAlign=a}else{const s=e.parse(t[i],1,qe);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new kr(r)}evaluate(t){return new Li(this.sections.map((e=>{const i=e.content.evaluate(t);return qi(i)===Je?new Ri("",i,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Ri(Wi(i),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class Dr{constructor(t){this.type=Je,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Ne);return i?new Dr(i):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),i=Ui.fromString(e);return i&&t.availableImages&&(i.available=t.availableImages.indexOf(e)>-1),i}eachChild(t){t(this.input)}outputDefined(){return!1}}class Rr{constructor(t){this.type=Ve,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=e.parse(t[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?e.error(`Expected argument of type string or array, but found ${ei(i.type)} instead.`):new Rr(i):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new ji(`Expected value to be of type string or array, but found ${ei(qi(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Lr=8192;function Br(t,e){const i=(180+t[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,n=Math.pow(2,e.z);return[Math.round(i*n*Lr),Math.round(r*n*Lr)]}function Fr(t,e){const i=Math.pow(2,e.z);return[(n=(t[0]/Lr+e.x)/i,360*n-180),(r=(t[1]/Lr+e.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,n}function Or(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function jr(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Vr(t,e,i){const r=t[0]-e[0],n=t[1]-e[1],s=t[0]-i[0],o=t[1]-i[1];return r*o-s*n==0&&r*s<=0&&n*o<=0}function Nr(t,e,i,r){return 0!=(n=[r[0]-i[0],r[1]-i[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-n[1]*s[0]&&!(!Wr(t,e,i,r)||!Wr(i,r,t,e));var n,s}function Ur(t,e,i){for(const r of i)for(let i=0;i<r.length-1;++i)if(Nr(t,e,r[i],r[i+1]))return!0;return!1}function Zr(t,e,i=!1){let r=!1;for(const a of e)for(let e=0;e<a.length-1;e++){if(Vr(t,a[e],a[e+1]))return i;(s=a[e])[1]>(n=t)[1]!=(o=a[e+1])[1]>n[1]&&n[0]<(o[0]-s[0])*(n[1]-s[1])/(o[1]-s[1])+s[0]&&(r=!r)}var n,s,o;return r}function Gr(t,e){for(const i of e)if(Zr(t,i))return!0;return!1}function $r(t,e){for(const i of t)if(!Zr(i,e))return!1;for(let i=0;i<t.length-1;++i)if(Ur(t[i],t[i+1],e))return!1;return!0}function qr(t,e){for(const i of e)if($r(t,i))return!0;return!1}function Wr(t,e,i,r){const n=r[0]-i[0],s=r[1]-i[1],o=(t[0]-i[0])*s-n*(t[1]-i[1]),a=(e[0]-i[0])*s-n*(e[1]-i[1]);return o>0&&a<0||o<0&&a>0}function Hr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const s=[];for(let r=0;r<t[n].length;r++){const o=Br(t[n][r],i);Or(e,o),s.push(o)}r.push(s)}return r}function Xr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const s=Hr(t[n],e,i);r.push(s)}return r}function Yr(t,e,i,r){if(t[0]<i[0]||t[0]>i[2]){const e=.5*r;let n=t[0]-i[0]>e?-r:i[0]-t[0]>e?r:0;0===n&&(n=t[0]-i[2]>e?-r:i[2]-t[0]>e?r:0),t[0]+=n}Or(e,t)}function Kr(t,e,i,r){const n=Math.pow(2,r.z)*Lr,s=[r.x*Lr,r.y*Lr],o=[];for(const r of t)for(const t of r){const r=[t.x+s[0],t.y+s[1]];Yr(r,e,i,n),o.push(r)}return o}function Jr(t,e,i,r){const n=Math.pow(2,r.z)*Lr,s=[r.x*Lr,r.y*Lr],o=[];for(const i of t){const t=[];for(const r of i){const i=[r.x+s[0],r.y+s[1]];Or(e,i),t.push(i)}o.push(t)}if(e[2]-e[0]<=n/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const r of t)Yr(r,e,i,n)}var a;return o}class Qr{constructor(t,e){this.type=Ue,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if($i(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const i of e.features){const{type:e,coordinates:r}=i.geometry;"Polygon"===e&&t.push(r),"MultiPolygon"===e&&t.push(...r)}if(t.length)return new Qr(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Qr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Qr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Hr(e.coordinates,r,n),o=Kr(t.geometry(),i,r,n);if(!jr(i,r))return!1;for(const t of o)if(!Zr(t,s))return!1}if("MultiPolygon"===e.type){const s=Xr(e.coordinates,r,n),o=Kr(t.geometry(),i,r,n);if(!jr(i,r))return!1;for(const t of o)if(!Gr(t,s))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Hr(e.coordinates,r,n),o=Jr(t.geometry(),i,r,n);if(!jr(i,r))return!1;for(const t of o)if(!$r(t,s))return!1}if("MultiPolygon"===e.type){const s=Xr(e.coordinates,r,n),o=Jr(t.geometry(),i,r,n);if(!jr(i,r))return!1;for(const t of o)if(!qr(t,s))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}class tn{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:i}=this,r=e[t];for(;t>0;){const n=t-1>>1,s=e[n];if(i(r,s)>=0)break;e[t]=s,t=n}e[t]=r}_down(t){const{data:e,compare:i}=this,r=this.length>>1,n=e[t];for(;t<r;){let r=1+(t<<1);const s=r+1;if(s<this.length&&i(e[s],e[r])<0&&(r=s),i(e[r],n)>=0)break;e[t]=e[r],t=r}e[t]=n}}function en(t,e,i=0,r=t.length-1,n=nn){for(;r>i;){if(r-i>600){const s=r-i+1,o=e-i+1,a=Math.log(s),l=.5*Math.exp(2*a/3),c=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);en(t,e,Math.max(i,Math.floor(e-o*l/s+c)),Math.min(r,Math.floor(e+(s-o)*l/s+c)),n)}const s=t[e];let o=i,a=r;for(rn(t,i,e),n(t[r],s)>0&&rn(t,i,r);o<a;){for(rn(t,o,a),o++,a--;n(t[o],s)<0;)o++;for(;n(t[a],s)>0;)a--}0===n(t[i],s)?rn(t,i,a):(a++,rn(t,a,r)),a<=e&&(i=a+1),e<=a&&(r=a-1)}}function rn(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function nn(t,e){return t<e?-1:t>e?1:0}function sn(t,e){if(t.length<=1)return[t];const i=[];let r,n;for(const e of t){const t=an(e);0!==t&&(e.area=Math.abs(t),void 0===n&&(n=t<0),n===t<0?(r&&i.push(r),r=[e]):r.push(e))}if(r&&i.push(r),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(en(i[t],e,1,i[t].length-1,on),i[t]=i[t].slice(0,e));return i}function on(t,e){return e.area-t.area}function an(t){let e=0;for(let i,r,n=0,s=t.length,o=s-1;n<s;o=n++)i=t[n],r=t[o],e+=(r.x-i.x)*(i.y+r.y);return e}const ln=1/298.257223563,cn=ln*(2-ln),hn=Math.PI/180;class un{constructor(t){const e=6378.137*hn*1e3,i=Math.cos(t*hn),r=1/(1-cn*(1-i*i)),n=Math.sqrt(r);this.kx=e*n*i,this.ky=e*n*r*(1-cn)}distance(t,e){const i=this.wrap(t[0]-e[0])*this.kx,r=(t[1]-e[1])*this.ky;return Math.sqrt(i*i+r*r)}pointOnLine(t,e){let i,r,n,s,o=1/0;for(let a=0;a<t.length-1;a++){let l=t[a][0],c=t[a][1],h=this.wrap(t[a+1][0]-l)*this.kx,u=(t[a+1][1]-c)*this.ky,p=0;0===h&&0===u||(p=(this.wrap(e[0]-l)*this.kx*h+(e[1]-c)*this.ky*u)/(h*h+u*u),p>1?(l=t[a+1][0],c=t[a+1][1]):p>0&&(l+=h/this.kx*p,c+=u/this.ky*p)),h=this.wrap(e[0]-l)*this.kx,u=(e[1]-c)*this.ky;const d=h*h+u*u;d<o&&(o=d,i=l,r=c,n=a,s=p)}return{point:[i,r],index:n,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function pn(t,e){return e[0]-t[0]}function dn(t){return t[1]-t[0]+1}function fn(t,e){return t[1]>=t[0]&&t[1]<e}function mn(t,e){if(t[0]>t[1])return[null,null];const i=dn(t);if(e){if(2===i)return[t,null];const e=Math.floor(i/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===i)return[t,null];const r=Math.floor(i/2)-1;return[[t[0],t[0]+r],[t[0]+r+1,t[1]]]}function _n(t,e){if(!fn(e,t.length))return[1/0,1/0,-1/0,-1/0];const i=[1/0,1/0,-1/0,-1/0];for(let r=e[0];r<=e[1];++r)Or(i,t[r]);return i}function gn(t){const e=[1/0,1/0,-1/0,-1/0];for(const i of t)for(const t of i)Or(e,t);return e}function yn(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function xn(t,e,i){if(!yn(t)||!yn(e))return NaN;let r=0,n=0;return t[2]<e[0]&&(r=e[0]-t[2]),t[0]>e[2]&&(r=t[0]-e[2]),t[1]>e[3]&&(n=t[1]-e[3]),t[3]<e[1]&&(n=e[1]-t[3]),i.distance([0,0],[r,n])}function vn(t,e,i){const r=i.pointOnLine(e,t);return i.distance(t,r.point)}function bn(t,e,i,r,n){const s=Math.min(vn(t,[i,r],n),vn(e,[i,r],n)),o=Math.min(vn(i,[t,e],n),vn(r,[t,e],n));return Math.min(s,o)}function wn(t,e,i,r,n){if(!fn(e,t.length)||!fn(r,i.length))return 1/0;let s=1/0;for(let o=e[0];o<e[1];++o){const e=t[o],a=t[o+1];for(let t=r[0];t<r[1];++t){const r=i[t],o=i[t+1];if(Nr(e,a,r,o))return 0;s=Math.min(s,bn(e,a,r,o,n))}}return s}function Tn(t,e,i,r,n){if(!fn(e,t.length)||!fn(r,i.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=r[0];e<=r[1];++e)if(s=Math.min(s,n.distance(t[o],i[e])),0===s)return s;return s}function Pn(t,e,i){if(Zr(t,e,!0))return 0;let r=1/0;for(const n of e){const e=n[0],s=n[n.length-1];if(e!==s&&(r=Math.min(r,vn(t,[s,e],i)),0===r))return r;const o=i.pointOnLine(n,t);if(r=Math.min(r,i.distance(t,o.point)),0===r)return r}return r}function Sn(t,e,i,r){if(!fn(e,t.length))return NaN;for(let r=e[0];r<=e[1];++r)if(Zr(t[r],i,!0))return 0;let n=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],o=t[s+1];for(const t of i)for(let i=0,s=t.length,a=s-1;i<s;a=i++){const s=t[a],l=t[i];if(Nr(e,o,s,l))return 0;n=Math.min(n,bn(e,o,s,l,r))}}return n}function Mn(t,e){for(const i of t)for(const t of i)if(Zr(t,e,!0))return!0;return!1}function In(t,e,i,r=1/0){const n=gn(t),s=gn(e);if(r!==1/0&&xn(n,s,i)>=r)return r;if(jr(n,s)){if(Mn(t,e))return 0}else if(Mn(e,t))return 0;let o=1/0;for(const r of t)for(let t=0,n=r.length,s=n-1;t<n;s=t++){const n=r[s],a=r[t];for(const t of e)for(let e=0,r=t.length,s=r-1;e<r;s=e++){const r=t[s],l=t[e];if(Nr(n,a,r,l))return 0;o=Math.min(o,bn(n,a,r,l,i))}}return o}function Cn(t,e,i,r,n,s){if(!s)return;const o=xn(_n(r,s),n,i);o<e&&t.push([o,s,[0,0]])}function En(t,e,i,r,n,s,o){if(!s||!o)return;const a=xn(_n(r,s),_n(n,o),i);a<e&&t.push([a,s,o])}function An(t,e,i,r,n=1/0){let s=Math.min(r.distance(t[0],i[0][0]),n);if(0===s)return s;const o=new tn([[0,[0,t.length-1],[0,0]]],pn),a=gn(i);for(;o.length>0;){const n=o.pop();if(n[0]>=s)continue;const l=n[1],c=e?50:100;if(dn(l)<=c){if(!fn(l,t.length))return NaN;if(e){const e=Sn(t,l,i,r);if(isNaN(e)||0===e)return e;s=Math.min(s,e)}else for(let e=l[0];e<=l[1];++e){const n=Pn(t[e],i,r);if(s=Math.min(s,n),0===s)return 0}}else{const i=mn(l,e);Cn(o,s,r,t,a,i[0]),Cn(o,s,r,t,a,i[1])}}return s}function zn(t,e,i,r,n,s=1/0){let o=Math.min(s,n.distance(t[0],i[0]));if(0===o)return o;const a=new tn([[0,[0,t.length-1],[0,i.length-1]]],pn);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],c=s[2],h=e?50:100,u=r?50:100;if(dn(l)<=h&&dn(c)<=u){if(!fn(l,t.length)&&fn(c,i.length))return NaN;let s;if(e&&r)s=wn(t,l,i,c,n),o=Math.min(o,s);else if(e&&!r){const e=t.slice(l[0],l[1]+1);for(let t=c[0];t<=c[1];++t)if(s=vn(i[t],e,n),o=Math.min(o,s),0===o)return o}else if(!e&&r){const e=i.slice(c[0],c[1]+1);for(let i=l[0];i<=l[1];++i)if(s=vn(t[i],e,n),o=Math.min(o,s),0===o)return o}else s=Tn(t,l,i,c,n),o=Math.min(o,s)}else{const s=mn(l,e),h=mn(c,r);En(a,o,n,t,i,s[0],h[0]),En(a,o,n,t,i,s[0],h[1]),En(a,o,n,t,i,s[1],h[0]),En(a,o,n,t,i,s[1],h[1])}}return o}function kn(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Dn{constructor(t,e){this.type=Ve,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if($i(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Dn(e,e.features.map((t=>kn(t.geometry))).flat());if("Feature"===e.type)return new Dn(e,kn(e.geometry));if("type"in e&&"coordinates"in e)return new Dn(e,kn(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Fr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new un(r[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,zn(r,!1,[t.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,zn(r,!1,t.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,An(r,!1,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Fr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new un(r[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,zn(r,!0,[t.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,zn(r,!0,t.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,An(r,!0,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const i=t.geometry();if(0===i.length||0===i[0].length)return NaN;const r=sn(i,0).map((e=>e.map((e=>e.map((e=>Fr([e.x,e.y],t.canonical))))))),n=new un(r[0][0][0][1]);let s=1/0;for(const t of e)for(const e of r){switch(t.type){case"Point":s=Math.min(s,An([t.coordinates],!1,e,n,s));break;case"LineString":s=Math.min(s,An(t.coordinates,!0,e,n,s));break;case"Polygon":s=Math.min(s,In(e,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class Rn{constructor(t){this.type=qe,this.key=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=t[1];return null==i?e.error("Global state property must be defined."):"string"!=typeof i?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Rn(i)}evaluate(t){var e;const i=null===(e=t.globals)||void 0===e?void 0:e.globalState;return i&&0!==Object.keys(i).length?Ti(i,this.key):null}eachChild(){}outputDefined(){return!1}}const Ln={"==":Pr,"!=":Sr,">":Ir,"<":Mr,">=":Er,"<=":Cr,array:Yi,at:nr,boolean:Yi,case:lr,coalesce:vr,collator:Ar,format:kr,image:Dr,in:sr,"index-of":or,interpolate:gr,"interpolate-hcl":gr,"interpolate-lab":gr,length:Rr,let:ir,literal:Hi,match:ar,number:Yi,"number-format":zr,object:Yi,slice:cr,step:ur,string:Yi,"to-boolean":Ji,"to-color":Ji,"to-number":Ji,"to-string":Ji,var:rr,within:Qr,distance:Dn,"global-state":Rn};class Bn{constructor(t,e,i,r){this.name=t,this.type=e,this._evaluate=i,this.args=r}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const i=t[0],r=Bn.definitions[i];if(!r)return e.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,s=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,o=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let a=null;for(const[r,s]of o){a=new er(e.registry,Nn,e.path,null,e.scope);const o=[];let l=!1;for(let e=1;e<t.length;e++){const i=t[e],n=Array.isArray(r)?r[e-1]:r.type,s=a.parse(i,1+o.length,n);if(!s){l=!0;break}o.push(s)}if(!l)if(Array.isArray(r)&&r.length!==o.length)a.error(`Expected ${r.length} arguments, but found ${o.length} instead.`);else{for(let t=0;t<o.length;t++){const e=Array.isArray(r)?r[t]:r.type,i=o[t];a.concat(t+1).checkSubtype(e,i.type)}if(0===a.errors.length)return new Bn(i,n,s,o)}}if(1===o.length)e.errors.push(...a.errors);else{const i=(o.length?o:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(ei).join(", ")})`:`(${ei(e.type)}...)`;var e})).join(" | "),r=[];for(let i=1;i<t.length;i++){const n=e.parse(t[i],1+r.length);if(!n)return null;r.push(ei(n.type))}e.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(t,e){Bn.definitions=e;for(const i in e)t[i]=Bn}}function Fn(t,[e,i,r,n]){e=e.evaluate(t),i=i.evaluate(t),r=r.evaluate(t);const s=n?n.evaluate(t):1,o=Gi(e,i,r,s);if(o)throw new ji(o);return new zi(e/255,i/255,r/255,s,!1)}function On(t,e){return t in e}function jn(t,e){const i=e[t];return void 0===i?null:i}function Vn(t){return{type:t}}function Nn(t){if(t instanceof rr)return Nn(t.boundExpression);if(t instanceof Bn&&"error"===t.name)return!1;if(t instanceof Ar)return!1;if(t instanceof Qr)return!1;if(t instanceof Dn)return!1;if(t instanceof Rn)return!1;const e=t instanceof Ji||t instanceof Yi;let i=!0;return t.eachChild((t=>{i=e?i&&Nn(t):i&&t instanceof Hi})),!!i&&Un(t)&&Gn(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function Un(t){if(t instanceof Bn){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof Qr)return!1;if(t instanceof Dn)return!1;let e=!0;return t.eachChild((t=>{e&&!Un(t)&&(e=!1)})),e}function Zn(t){if(t instanceof Bn&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!Zn(t)&&(e=!1)})),e}function Gn(t,e){if(t instanceof Bn&&e.indexOf(t.name)>=0)return!1;let i=!0;return t.eachChild((t=>{i&&!Gn(t,e)&&(i=!1)})),i}function $n(t){return{result:"success",value:t}}function qn(t){return{result:"error",value:t}}function Wn(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Hn(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Xn(t){return!!t.expression&&t.expression.interpolated}function Yn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Kn(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)&&qi(t)===$e}function Jn(t){return t}function Qn(t,e){const i=t.stops&&"object"==typeof t.stops[0][0],r=i||!(i||void 0!==t.property),n=t.type||(Xn(e)?"exponential":"interval"),s=function(t){switch(t.type){case"color":return zi.parse;case"padding":return Bi.parse;case"numberArray":return Fi.parse;case"colorArray":return Oi.parse;default:return null}}(e);if(s&&((t=Be({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],s(t[1])]))),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(o=t.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${t.colorSpace}"`);var o;const a=function(t){switch(t){case"exponential":return rs;case"interval":return is;case"categorical":return es;case"identity":return ns;default:throw new Error(`Unknown function type "${t}"`)}}(n);let l,c;if("categorical"===n){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];c=typeof t.stops[0][0]}if(i){const i={},r=[];for(let e=0;e<t.stops.length;e++){const n=t.stops[e],s=n[0].zoom;void 0===i[s]&&(i[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},r.push(s)),i[s].stops.push([n[0].value,n[1]])}const n=[];for(const t of r)n.push([i[t].zoom,Qn(i[t],e)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:gr.interpolationFactor.bind(void 0,s),zoomStops:n.map((t=>t[0])),evaluate:({zoom:i},r)=>rs({stops:n,base:t.base},e,i).evaluate(i,r)}}if(r){const i="exponential"===n?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:gr.interpolationFactor.bind(void 0,i),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:i})=>a(t,e,i,l,c)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[t.property]:void 0;return void 0===n?ts(t.default,e.default):a(t,e,n,l,c)}}}function ts(t,e,i){return void 0!==t?t:void 0!==e?e:void 0!==i?i:void 0}function es(t,e,i,r,n){return ts(typeof i===n?r[i]:void 0,t.default,e.default)}function is(t,e,i){if("number"!==Yn(i))return ts(t.default,e.default);const r=t.stops.length;if(1===r)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[r-1][0])return t.stops[r-1][1];const n=hr(t.stops.map((t=>t[0])),i);return t.stops[n][1]}function rs(t,e,i){const r=void 0!==t.base?t.base:1;if("number"!==Yn(i))return ts(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[n-1][0])return t.stops[n-1][1];const s=hr(t.stops.map((t=>t[0])),i),o=function(t,e,i,r){const n=r-i,s=t-i;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}(i,r,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1],c=xr[e.type]||Jn;return"function"==typeof a.evaluate?{evaluate(...e){const i=a.evaluate.apply(void 0,e),r=l.evaluate.apply(void 0,e);if(void 0!==i&&void 0!==r)return c(i,r,o,t.colorSpace)}}:c(a,l,o,t.colorSpace)}function ns(t,e,i){switch(e.type){case"color":i=zi.parse(i);break;case"formatted":i=Li.fromString(i.toString());break;case"resolvedImage":i=Ui.fromString(i.toString());break;case"padding":i=Bi.parse(i);break;case"colorArray":i=Oi.parse(i);break;case"numberArray":i=Fi.parse(i);break;default:Yn(i)===e.type||"enum"===e.type&&e.values[i]||(i=void 0)}return ts(i,t.default,e.default)}Bn.register(Ln,{error:[{kind:"error"},[Ne],(t,[e])=>{throw new ji(e.evaluate(t))}],typeof:[Ne,[qe],(t,[e])=>ei(qi(e.evaluate(t)))],"to-rgba":[ti(Ve,4),[Ze],(t,[e])=>{const[i,r,n,s]=e.evaluate(t).rgb;return[255*i,255*r,255*n,s]}],rgb:[Ze,[Ve,Ve,Ve],Fn],rgba:[Ze,[Ve,Ve,Ve,Ve],Fn],has:{type:Ue,overloads:[[[Ne],(t,[e])=>On(e.evaluate(t),t.properties())],[[Ne,$e],(t,[e,i])=>On(e.evaluate(t),i.evaluate(t))]]},get:{type:qe,overloads:[[[Ne],(t,[e])=>jn(e.evaluate(t),t.properties())],[[Ne,$e],(t,[e,i])=>jn(e.evaluate(t),i.evaluate(t))]]},"feature-state":[qe,[Ne],(t,[e])=>jn(e.evaluate(t),t.featureState||{})],properties:[$e,[],t=>t.properties()],"geometry-type":[Ne,[],t=>t.geometryType()],id:[qe,[],t=>t.id()],zoom:[Ve,[],t=>t.globals.zoom],"heatmap-density":[Ve,[],t=>t.globals.heatmapDensity||0],elevation:[Ve,[],t=>t.globals.elevation||0],"line-progress":[Ve,[],t=>t.globals.lineProgress||0],accumulated:[qe,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Ve,Vn(Ve),(t,e)=>{let i=0;for(const r of e)i+=r.evaluate(t);return i}],"*":[Ve,Vn(Ve),(t,e)=>{let i=1;for(const r of e)i*=r.evaluate(t);return i}],"-":{type:Ve,overloads:[[[Ve,Ve],(t,[e,i])=>e.evaluate(t)-i.evaluate(t)],[[Ve],(t,[e])=>-e.evaluate(t)]]},"/":[Ve,[Ve,Ve],(t,[e,i])=>e.evaluate(t)/i.evaluate(t)],"%":[Ve,[Ve,Ve],(t,[e,i])=>e.evaluate(t)%i.evaluate(t)],ln2:[Ve,[],()=>Math.LN2],pi:[Ve,[],()=>Math.PI],e:[Ve,[],()=>Math.E],"^":[Ve,[Ve,Ve],(t,[e,i])=>Math.pow(e.evaluate(t),i.evaluate(t))],sqrt:[Ve,[Ve],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Ve,[Ve],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Ve,[Ve],(t,[e])=>Math.log(e.evaluate(t))],log2:[Ve,[Ve],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Ve,[Ve],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Ve,[Ve],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Ve,[Ve],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Ve,[Ve],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Ve,[Ve],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Ve,[Ve],(t,[e])=>Math.atan(e.evaluate(t))],min:[Ve,Vn(Ve),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Ve,Vn(Ve),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Ve,[Ve],(t,[e])=>Math.abs(e.evaluate(t))],round:[Ve,[Ve],(t,[e])=>{const i=e.evaluate(t);return i<0?-Math.round(-i):Math.round(i)}],floor:[Ve,[Ve],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Ve,[Ve],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Ue,[Ne,qe],(t,[e,i])=>t.properties()[e.value]===i.value],"filter-id-==":[Ue,[qe],(t,[e])=>t.id()===e.value],"filter-type-==":[Ue,[Ne],(t,[e])=>t.geometryType()===e.value],"filter-<":[Ue,[Ne,qe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[Ue,[qe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<r}],"filter->":[Ue,[Ne,qe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[Ue,[qe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>r}],"filter-<=":[Ue,[Ne,qe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[Ue,[qe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<=r}],"filter->=":[Ue,[Ne,qe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[Ue,[qe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>=r}],"filter-has":[Ue,[qe],(t,[e])=>e.value in t.properties()],"filter-has-id":[Ue,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Ue,[ti(Ne)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Ue,[ti(qe)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Ue,[Ne,ti(qe)],(t,[e,i])=>i.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Ue,[Ne,ti(qe)],(t,[e,i])=>function(t,e,i,r){for(;i<=r;){const n=i+r>>1;if(e[n]===t)return!0;e[n]>t?r=n-1:i=n+1}return!1}(t.properties()[e.value],i.value,0,i.value.length-1)],all:{type:Ue,overloads:[[[Ue,Ue],(t,[e,i])=>e.evaluate(t)&&i.evaluate(t)],[Vn(Ue),(t,e)=>{for(const i of e)if(!i.evaluate(t))return!1;return!0}]]},any:{type:Ue,overloads:[[[Ue,Ue],(t,[e,i])=>e.evaluate(t)||i.evaluate(t)],[Vn(Ue),(t,e)=>{for(const i of e)if(i.evaluate(t))return!0;return!1}]]},"!":[Ue,[Ue],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Ue,[Ne],(t,[e])=>{const i=t.globals&&t.globals.isSupportedScript;return!i||i(e.evaluate(t))}],upcase:[Ne,[Ne],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Ne,[Ne],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Ne,Vn(qe),(t,e)=>e.map((e=>Wi(e.evaluate(t)))).join("")],"resolved-locale":[Ne,[We],(t,[e])=>e.evaluate(t).resolvedLocale()]});class ss{constructor(t,e,i){this.expression=t,this._warningHistory={},this._evaluator=new tr,this._defaultValue=e?function(t){if("color"===t.type&&Kn(t.default))return new zi(0,0,0,0);switch(t.type){case"color":return zi.parse(t.default)||null;case"padding":return Bi.parse(t.default)||null;case"numberArray":return Fi.parse(t.default)||null;case"colorArray":return Oi.parse(t.default)||null;case"variableAnchorOffsetCollection":return Ni.parse(t.default)||null;case"projectionDefinition":return Zi.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this._globalState=i}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=i,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,i,r,n,s){this._globalState&&(t={...t,globalState:this._globalState}),this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new ji(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function os(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Ln}function as(t,e,i){const r=new er(Ln,Nn,[],e?function(t){const e={color:Ze,string:Ne,number:Ve,enum:Ne,boolean:Ue,formatted:He,padding:Xe,numberArray:Ke,colorArray:Ye,projectionDefinition:Ge,resolvedImage:Je,variableAnchorOffsetCollection:Qe};return"array"===t.type?ti(e[t.value]||qe,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?$n(new ss(n,e,i)):qn(r.errors)}class ls{constructor(t,e,i){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Zn(e.expression),this.globalStateRefs=ds(e.expression),this._globalState=i}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,s)}evaluate(t,e,i,r,n,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluate(t,e,i,r,n,s)}}class cs{constructor(t,e,i,r,n){this.kind=t,this.zoomStops=i,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Zn(e.expression),this.globalStateRefs=ds(e.expression),this.interpolationType=r,this._globalState=n}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,s)}evaluate(t,e,i,r,n,s){return this._globalState&&(t={...t,globalState:this._globalState}),this._styleExpression.evaluate(t,e,i,r,n,s)}interpolationFactor(t,e,i){return this.interpolationType?gr.interpolationFactor(this.interpolationType,t,e,i):0}}function hs(t,e,i){const r=as(t,e,i);if("error"===r.result)return r;const n=r.value.expression,s=Un(n);if(!s&&!Wn(e))return qn([new Fe("","data expressions not supported")]);const o=Gn(n,["zoom"]);if(!o&&!Hn(e))return qn([new Fe("","zoom expressions not supported")]);const a=ps(n);return a||o?a instanceof Fe?qn([a]):a instanceof gr&&!Xn(e)?qn([new Fe("",'"interpolate" expressions cannot be used with this property')]):$n(a?new cs(s?"camera":"composite",r.value,a.labels,a instanceof gr?a.interpolation:void 0,i):new ls(s?"constant":"source",r.value,i)):qn([new Fe("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class us{constructor(t,e){this._parameters=t,this._specification=e,Be(this,Qn(this._parameters,this._specification))}static deserialize(t){return new us(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function ps(t){let e=null;if(t instanceof ir)e=ps(t.result);else if(t instanceof vr){for(const i of t.args)if(e=ps(i),e)break}else(t instanceof ur||t instanceof gr)&&t.input instanceof Bn&&"zoom"===t.input.name&&(e=t);return e instanceof Fe||t.eachChild((t=>{const i=ps(t);i instanceof Fe?e=i:!e&&i?e=new Fe("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&i&&e!==i&&(e=new Fe("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function ds(t,e=new Set){return t instanceof Rn&&e.add(t.key),t.eachChild((t=>{ds(t,e)})),e}function fs(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!fs(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const ms={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function _s(t,e){if(null==t)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};fs(t)||(t=xs(t));const i=as(t,ms,e);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,e,r)=>i.value.evaluate(t,e,{},r),needGeometry:ys(t),getGlobalStateRefs:()=>ds(i.value.expression)}}function gs(t,e){return t<e?-1:t>e?1:0}function ys(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(ys(t[e]))return!0;return!1}function xs(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?vs(t[1],t[2],"=="):"!="===e?Ts(vs(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?vs(t[1],t[2],e):"any"===e?(i=t.slice(1),["any"].concat(i.map(xs))):"all"===e?["all"].concat(t.slice(1).map(xs)):"none"===e?["all"].concat(t.slice(1).map(xs).map(Ts)):"in"===e?bs(t[1],t.slice(2)):"!in"===e?Ts(bs(t[1],t.slice(2))):"has"===e?ws(t[1]):"!has"!==e||Ts(ws(t[1]));var i}function vs(t,e,i){switch(t){case"$type":return[`filter-type-${i}`,e];case"$id":return[`filter-id-${i}`,e];default:return[`filter-${i}`,t,e]}}function bs(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(gs)]]:["filter-in-small",t,["literal",e]]}}function ws(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function Ts(t){return["!",t]}function Ps(t){const e=t.value;return e?[new Le(t.key,e,"constants have been deprecated as of v8")]:[]}function Ss(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Ms(t){if(Array.isArray(t))return t.map(Ms);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const i in t)e[i]=Ms(t[i]);return e}return Ss(t)}function Is(t){const e=t.key,i=t.value,r=t.valueSpec||{},n=t.objectElementValidators||{},s=t.style,o=t.styleSpec,a=t.validateSpec;let l=[];const c=Yn(i);if("object"!==c)return[new Le(e,i,`object expected, ${c} found`)];for(const t in i){const c=t.split(".")[0],h=Ti(r,c)||r["*"];let u;if(Ti(n,c))u=n[c];else if(Ti(r,c))u=a;else if(n["*"])u=n["*"];else{if(!r["*"]){l.push(new Le(e,i[t],`unknown property "${t}"`));continue}u=a}l=l.concat(u({key:(e?`${e}.`:e)+t,value:i[t],valueSpec:h,style:s,styleSpec:o,object:i,objectKey:t,validateSpec:a},i))}for(const t in r)n[t]||r[t].required&&void 0===r[t].default&&void 0===i[t]&&l.push(new Le(e,i,`missing required property "${t}"`));return l}function Cs(t){const e=t.value,i=t.valueSpec,r=t.style,n=t.styleSpec,s=t.key,o=t.arrayElementValidator||t.validateSpec;if("array"!==Yn(e))return[new Le(s,e,`array expected, ${Yn(e)} found`)];if(i.length&&e.length!==i.length)return[new Le(s,e,`array length ${i.length} expected, length ${e.length} found`)];if(i["min-length"]&&e.length<i["min-length"])return[new Le(s,e,`array length at least ${i["min-length"]} expected, length ${e.length} found`)];let a={type:i.value,values:i.values};n.$version<7&&(a.function=i.function),"object"===Yn(i.value)&&(a=i.value);let l=[];for(let i=0;i<e.length;i++)l=l.concat(o({array:e,arrayIndex:i,value:e[i],valueSpec:a,validateSpec:t.validateSpec,style:r,styleSpec:n,key:`${s}[${i}]`}));return l}function Es(t){const e=t.key,i=t.value,r=t.valueSpec;let n=Yn(i);return"number"===n&&i!=i&&(n="NaN"),"number"!==n?[new Le(e,i,`number expected, ${n} found`)]:"minimum"in r&&i<r.minimum?[new Le(e,i,`${i} is less than the minimum value ${r.minimum}`)]:"maximum"in r&&i>r.maximum?[new Le(e,i,`${i} is greater than the maximum value ${r.maximum}`)]:[]}function As(t){const e=t.valueSpec,i=Ss(t.value.type);let r,n,s,o={};const a="categorical"!==i&&void 0===t.value.property,l=!a,c="array"===Yn(t.value.stops)&&"array"===Yn(t.value.stops[0])&&"object"===Yn(t.value.stops[0][0]),h=Is({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===i)return[new Le(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const r=t.value;return e=e.concat(Cs({key:t.key,value:r,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===Yn(r)&&0===r.length&&e.push(new Le(t.key,r,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===i&&a&&h.push(new Le(t.key,t.value,'missing required property "property"')),"identity"===i||t.value.stops||h.push(new Le(t.key,t.value,'missing required property "stops"')),"exponential"===i&&t.valueSpec.expression&&!Xn(t.valueSpec)&&h.push(new Le(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Wn(t.valueSpec)?h.push(new Le(t.key,t.value,"property functions not supported")):a&&!Hn(t.valueSpec)&&h.push(new Le(t.key,t.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==t.value.property||h.push(new Le(t.key,t.value,'"property" property is required')),h;function u(t){let i=[];const r=t.value,a=t.key;if("array"!==Yn(r))return[new Le(a,r,`array expected, ${Yn(r)} found`)];if(2!==r.length)return[new Le(a,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==Yn(r[0]))return[new Le(a,r,`object expected, ${Yn(r[0])} found`)];if(void 0===r[0].zoom)return[new Le(a,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new Le(a,r,"object stop key must have value")];if(s&&s>Ss(r[0].zoom))return[new Le(a,r[0].zoom,"stop zoom values must appear in ascending order")];Ss(r[0].zoom)!==s&&(s=Ss(r[0].zoom),n=void 0,o={}),i=i.concat(Is({key:`${a}[0]`,value:r[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:Es,value:p}}))}else i=i.concat(p({key:`${a}[0]`,value:r[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},r));return os(Ms(r[1]))?i.concat([new Le(`${a}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(t.validateSpec({key:`${a}[1]`,value:r[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const a=Yn(t.value),l=Ss(t.value),c=null!==t.value?t.value:s;if(r){if(a!==r)return[new Le(t.key,c,`${a} stop domain type must match previous stop domain type ${r}`)]}else r=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return[new Le(t.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==i){let r=`number expected, ${a} found`;return Wn(e)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Le(t.key,c,r)]}return"categorical"!==i||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===a&&void 0!==n&&l<n?[new Le(t.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in o?[new Le(t.key,c,"stop domain values must be unique")]:(o[l]=!0,[])):[new Le(t.key,c,`integer expected, found ${l}`)]}}function zs(t){const e=("property"===t.expressionContext?hs:as)(Ms(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Le(`${t.key}${e.key}`,t.value,e.message)));const i=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!i.outputDefined())return[new Le(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Zn(i))return[new Le(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!Zn(i))return[new Le(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Gn(i,["zoom","feature-state"]))return[new Le(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Un(i))return[new Le(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function ks(t){const e=t.key,i=t.value,r=Yn(i);return"string"!==r?[new Le(e,i,`color expected, ${r} found`)]:zi.parse(String(i))?[]:[new Le(e,i,`color expected, "${i}" found`)]}function Ds(t){const e=t.key,i=t.value,r=t.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(Ss(i))&&n.push(new Le(e,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(Ss(i))&&n.push(new Le(e,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function Rs(t){return fs(Ms(t.value))?zs(Be({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Ls(t)}function Ls(t){const e=t.value,i=t.key;if("array"!==Yn(e))return[new Le(i,e,`array expected, ${Yn(e)} found`)];const r=t.styleSpec;let n,s=[];if(e.length<1)return[new Le(i,e,"filter array must have at least 1 element")];switch(s=s.concat(Ds({key:`${i}[0]`,value:e[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),Ss(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Ss(e[1])&&s.push(new Le(i,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new Le(i,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(n=Yn(e[1]),"string"!==n&&s.push(new Le(`${i}[1]`,e[1],`string expected, ${n} found`)));for(let o=2;o<e.length;o++)n=Yn(e[o]),"$type"===Ss(e[1])?s=s.concat(Ds({key:`${i}[${o}]`,value:e[o],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&s.push(new Le(`${i}[${o}]`,e[o],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<e.length;r++)s=s.concat(Ls({key:`${i}[${r}]`,value:e[r],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":n=Yn(e[1]),2!==e.length?s.push(new Le(i,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==n&&s.push(new Le(`${i}[1]`,e[1],`string expected, ${n} found`))}return s}function Bs(t,e){const i=t.key,r=t.validateSpec,n=t.style,s=t.styleSpec,o=t.value,a=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return[];const c=a.match(/^(.*)-transition$/);if("paint"===e&&c&&l[c[1]]&&l[c[1]].transition)return r({key:i,value:o,valueSpec:s.transition,style:n,styleSpec:s});const h=t.valueSpec||l[a];if(!h)return[new Le(i,o,`unknown property "${a}"`)];let u;if("string"===Yn(o)&&Wn(h)&&!h.tokens&&(u=/^{([^}]+)}$/.exec(o)))return[new Le(i,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(u[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&("text-field"===a&&n&&!n.glyphs&&p.push(new Le(i,o,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Kn(Ms(o))&&"identity"===Ss(o.type)&&p.push(new Le(i,o,'"text-font" does not support identity functions'))),p.concat(r({key:t.key,value:o,valueSpec:h,style:n,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:a}))}function Fs(t){return Bs(t,"paint")}function Os(t){return Bs(t,"layout")}function js(t){let e=[];const i=t.value,r=t.key,n=t.style,s=t.styleSpec;if("object"!==Yn(i))return[new Le(r,i,`object expected, ${Yn(i)} found`)];i.type||i.ref||e.push(new Le(r,i,'either "type" or "ref" is required'));let o=Ss(i.type);const a=Ss(i.ref);if(i.id){const s=Ss(i.id);for(let o=0;o<t.arrayIndex;o++){const t=n.layers[o];Ss(t.id)===s&&e.push(new Le(r,i.id,`duplicate layer id "${i.id}", previously used at line ${t.id.__line__}`))}}if("ref"in i){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in i&&e.push(new Le(r,i[t],`"${t}" is prohibited for ref layers`))})),n.layers.forEach((e=>{Ss(e.id)===a&&(t=e)})),t?t.ref?e.push(new Le(r,i.ref,"ref cannot reference another ref layer")):o=Ss(t.type):e.push(new Le(r,i.ref,`ref layer "${a}" not found`))}else if("background"!==o)if(i.source){const t=n.sources&&n.sources[i.source],s=t&&Ss(t.type);t?"vector"===s&&"raster"===o?e.push(new Le(r,i.source,`layer "${i.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o||"raster-dem"!==s&&"color-relief"===o?e.push(new Le(r,i.source,`layer "${i.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?e.push(new Le(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==s||i["source-layer"]?"raster-dem"===s&&"hillshade"!==o&&"color-relief"!==o?e.push(new Le(r,i.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==o||!i.paint||!i.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Le(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Le(r,i,`layer "${i.id}" must specify a "source-layer"`)):e.push(new Le(r,i.source,`source "${i.source}" not found`))}else e.push(new Le(r,i,'missing required property "source"'));return e=e.concat(Is({key:r,value:i,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${r}.type`,value:i.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:i,objectKey:"type"}),filter:Rs,layout:t=>Is({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Os(Be({layerType:o},t))}}),paint:t=>Is({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Fs(Be({layerType:o},t))}})}})),e}function Vs(t){const e=t.value,i=t.key,r=Yn(e);return"string"!==r?[new Le(i,e,`string expected, ${r} found`)]:[]}const Ns={promoteId:function({key:t,value:e}){if("string"===Yn(e))return Vs({key:t,value:e});{const i=[];for(const r in e)i.push(...Vs({key:`${t}.${r}`,value:e[r]}));return i}}};function Us(t){const e=t.value,i=t.key,r=t.styleSpec,n=t.style,s=t.validateSpec;if(!e.type)return[new Le(i,e,'"type" is required')];const o=Ss(e.type);let a;switch(o){case"vector":case"raster":return a=Is({key:i,value:e,valueSpec:r[`source_${o.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:Ns,validateSpec:s}),a;case"raster-dem":return a=function(t){var e;const i=null!==(e=t.sourceName)&&void 0!==e?e:"",r=t.value,n=t.styleSpec,s=n.source_raster_dem,o=t.style;let a=[];const l=Yn(r);if(void 0===r)return a;if("object"!==l)return a.push(new Le("source_raster_dem",r,`object expected, ${l} found`)),a;const c="custom"===Ss(r.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],u=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in r)!c&&h.includes(e)?a.push(new Le(e,r[e],`In "${i}": "${e}" is only valid when "encoding" is set to "custom". ${u} encoding found`)):s[e]?a=a.concat(t.validateSpec({key:e,value:r[e],valueSpec:s[e],validateSpec:t.validateSpec,style:o,styleSpec:n})):a.push(new Le(e,r[e],`unknown property "${e}"`));return a}({sourceName:i,value:e,style:t.style,styleSpec:r,validateSpec:s}),a;case"geojson":if(a=Is({key:i,value:e,valueSpec:r.source_geojson,style:n,styleSpec:r,validateSpec:s,objectElementValidators:Ns}),e.cluster)for(const t in e.clusterProperties){const[r,n]=e.clusterProperties[t],s="string"==typeof r?[r,["accumulated"],["get",t]]:r;a.push(...zs({key:`${i}.${t}.map`,value:n,expressionContext:"cluster-map"})),a.push(...zs({key:`${i}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return a;case"video":return Is({key:i,value:e,valueSpec:r.source_video,style:n,validateSpec:s,styleSpec:r});case"image":return Is({key:i,value:e,valueSpec:r.source_image,style:n,validateSpec:s,styleSpec:r});case"canvas":return[new Le(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Ds({key:`${i}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Zs(t){const e=t.value,i=t.styleSpec,r=i.light,n=t.style;let s=[];const o=Yn(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new Le("light",e,`object expected, ${o} found`)]),s;for(const o in e){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&r[a[1]]&&r[a[1]].transition?t.validateSpec({key:o,value:e[o],valueSpec:i.transition,validateSpec:t.validateSpec,style:n,styleSpec:i}):r[o]?t.validateSpec({key:o,value:e[o],valueSpec:r[o],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Le(o,e[o],`unknown property "${o}"`)])}return s}function Gs(t){const e=t.value,i=t.styleSpec,r=i.sky,n=t.style,s=Yn(e);if(void 0===e)return[];if("object"!==s)return[new Le("sky",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],style:n,styleSpec:i}):[new Le(s,e[s],`unknown property "${s}"`)]);return o}function $s(t){const e=t.value,i=t.styleSpec,r=i.terrain,n=t.style;let s=[];const o=Yn(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new Le("terrain",e,`object expected, ${o} found`)]),s;for(const o in e)s=s.concat(r[o]?t.validateSpec({key:o,value:e[o],valueSpec:r[o],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Le(o,e[o],`unknown property "${o}"`)]);return s}function qs(t){let e=[];const i=t.value,r=t.key;if(Array.isArray(i)){const n=[],s=[];for(const o in i)i[o].id&&n.includes(i[o].id)&&e.push(new Le(r,i,`all the sprites' ids must be unique, but ${i[o].id} is duplicated`)),n.push(i[o].id),i[o].url&&s.includes(i[o].url)&&e.push(new Le(r,i,`all the sprites' URLs must be unique, but ${i[o].url} is duplicated`)),s.push(i[o].url),e=e.concat(Is({key:`${r}[${o}]`,value:i[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Vs({key:r,value:i})}function Ws(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new Le(t.key,t.value,`object expected, ${Yn(t.value)} found`)];var e}const Hs={"*":()=>[],array:Cs,boolean:function(t){const e=t.value,i=t.key,r=Yn(e);return"boolean"!==r?[new Le(i,e,`boolean expected, ${r} found`)]:[]},number:Es,color:ks,constants:Ps,enum:Ds,filter:Rs,function:As,layer:js,object:Is,source:Us,light:Zs,sky:Gs,terrain:$s,projection:function(t){const e=t.value,i=t.styleSpec,r=i.projection,n=t.style,s=Yn(e);if(void 0===e)return[];if("object"!==s)return[new Le("projection",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],style:n,styleSpec:i}):[new Le(s,e[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(t){const e=t.key;let i=t.value;i=i instanceof String?i.valueOf():i;const r=Yn(i);return"array"!==r||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(i)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(i)?["array","string"].includes(r)?[]:[new Le(e,i,`projection expected, invalid type "${r}" found`)]:[new Le(e,i,`projection expected, invalid array ${JSON.stringify(i)} found`)]},string:Vs,formatted:function(t){return 0===Vs(t).length?[]:zs(t)},resolvedImage:function(t){return 0===Vs(t).length?[]:zs(t)},padding:function(t){const e=t.key,i=t.value;if("array"===Yn(i)){if(i.length<1||i.length>4)return[new Le(e,i,`padding requires 1 to 4 values; ${i.length} values found`)];const r={type:"number"};let n=[];for(let s=0;s<i.length;s++)n=n.concat(t.validateSpec({key:`${e}[${s}]`,value:i[s],validateSpec:t.validateSpec,valueSpec:r}));return n}return Es({key:e,value:i,valueSpec:{}})},numberArray:function(t){const e=t.key,i=t.value;if("array"===Yn(i)){const r={type:"number"};if(i.length<1)return[new Le(e,i,"array length at least 1 expected, length 0 found")];let n=[];for(let s=0;s<i.length;s++)n=n.concat(t.validateSpec({key:`${e}[${s}]`,value:i[s],validateSpec:t.validateSpec,valueSpec:r}));return n}return Es({key:e,value:i,valueSpec:{}})},colorArray:function(t){const e=t.key,i=t.value;if("array"===Yn(i)){if(i.length<1)return[new Le(e,i,"array length at least 1 expected, length 0 found")];let t=[];for(let r=0;r<i.length;r++)t=t.concat(ks({key:`${e}[${r}]`,value:i[r]}));return t}return ks({key:e,value:i})},variableAnchorOffsetCollection:function(t){const e=t.key,i=t.value,r=Yn(i),n=t.styleSpec;if("array"!==r||i.length<1||i.length%2!=0)return[new Le(e,i,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let r=0;r<i.length;r+=2)s=s.concat(Ds({key:`${e}[${r}]`,value:i[r],valueSpec:n.layout_symbol["text-anchor"]})),s=s.concat(Cs({key:`${e}[${r+1}]`,value:i[r+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:n}));return s},sprite:qs,state:Ws};function Xs(t){const e=t.value,i=t.valueSpec,r=t.styleSpec;return t.validateSpec=Xs,i.expression&&Kn(Ss(e))?As(t):i.expression&&os(Ms(e))?zs(t):i.type&&Hs[i.type]?Hs[i.type](t):Is(Be({},t,{valueSpec:i.type?r[i.type]:i}))}function Ys(t){const e=t.value,i=t.key,r=Vs(t);return r.length||(-1===e.indexOf("{fontstack}")&&r.push(new Le(i,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&r.push(new Le(i,e,'"glyphs" url must include a "{range}" token'))),r}function Ks(t,e=we){let i=[];return i=i.concat(Xs({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Xs,objectElementValidators:{glyphs:Ys,"*":()=>[]}})),t.constants&&(i=i.concat(Ps({key:"constants",value:t.constants}))),Qs(i)}function Js(t){return function(e){return t({...e,validateSpec:Xs})}}function Qs(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function to(t){return function(...e){return Qs(t.apply(this,e))}}Ks.source=to(Js(Us)),Ks.sprite=to(Js(qs)),Ks.glyphs=to(Js(Ys)),Ks.light=to(Js(Zs)),Ks.sky=to(Js(Gs)),Ks.terrain=to(Js($s)),Ks.state=to(Js(Ws)),Ks.layer=to(Js(js)),Ks.filter=to(Js(Rs)),Ks.paintProperty=to(Js(Fs)),Ks.layoutProperty=to(Js(Os));const eo=Ks,io=eo.light,ro=eo.sky,no=eo.paintProperty,so=eo.layoutProperty;function oo(t,e){let i=!1;if(e&&e.length)for(const r of e)t.fire(new ve(new Error(r.message))),i=!0;return i}class ao{constructor(t,e,i){const r=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const n=new Int32Array(this.arrayBuffer);t=n[0],this.d=(e=n[1])+2*(i=n[2]);for(let t=0;t<this.d*this.d;t++){const e=n[3+t],i=n[3+t+1];r.push(e===i?null:n.subarray(e,i))}const s=n[3+r.length+1];this.keys=n.subarray(n[3+r.length],s),this.bboxes=n.subarray(s),this.insert=this._insertReadonly}else{this.d=e+2*i;for(let t=0;t<this.d*this.d;t++)r.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=i,this.scale=e/t,this.uid=0;const n=i/e*t;this.min=-n,this.max=t+n}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,i,r,n,s){this.cells[n].push(s)}query(t,e,i,r,n){const s=this.min,o=this.max;if(t<=s&&e<=s&&o<=i&&o<=r&&!n)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,i,r,this._queryCell,s,{},n),s}}_queryCell(t,e,i,r,n,s,o,a){const l=this.cells[n];if(null!==l){const n=this.keys,c=this.bboxes;for(let h=0;h<l.length;h++){const u=l[h];if(void 0===o[u]){const l=4*u;(a?a(c[l+0],c[l+1],c[l+2],c[l+3]):t<=c[l+2]&&e<=c[l+3]&&i>=c[l+0]&&r>=c[l+1])?(o[u]=!0,s.push(n[u])):o[u]=!1}}}}_forEachCell(t,e,i,r,n,s,o,a){const l=this._convertToCellCoord(t),c=this._convertToCellCoord(e),h=this._convertToCellCoord(i),u=this._convertToCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++){const c=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&n.call(this,t,e,i,r,c,s,o,a))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let i=0;for(let t=0;t<this.cells.length;t++)i+=this.cells[t].length;const r=new Int32Array(e+i+this.keys.length+this.bboxes.length);r[0]=this.extent,r[1]=this.n,r[2]=this.padding;let n=e;for(let e=0;e<t.length;e++){const i=t[e];r[3+e]=n,r.set(i,n),n+=i.length}return r[3+t.length]=n,r.set(this.keys,n),n+=this.keys.length,r[3+t.length+1]=n,r.set(this.bboxes,n),n+=this.bboxes.length,r.buffer}static serialize(t,e){const i=t.toArrayBuffer();return e&&e.push(i),{buffer:i}}static deserialize(t){return new ao(t.buffer)}}const lo={};function co(t,e,i={}){if(lo[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),lo[t]={klass:e,omit:i.omit||[],shallow:i.shallow||[]}}co("Object",Object),co("Set",Set),co("TransferableGridIndex",ao),co("Color",zi),co("Error",Error),co("AJAXError",ne),co("ResolvedImage",Ui),co("StylePropertyFunction",us),co("StyleExpression",ss,{omit:["_evaluator"]}),co("ZoomDependentExpression",cs),co("ZoomConstantExpression",ls),co("CompoundExpression",Bn,{omit:["_evaluate"]});for(const t in Ln)Ln[t]._classRegistryKey||co(`Expression_${t}`,Ln[t]);function ho(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function uo(t){return t.$name||t.constructor._classRegistryKey}function po(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=uo(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||ho(t)||Ft(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function fo(t,e){if(po(t))return(ho(t)||Ft(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const i=[];for(const r of t)i.push(fo(r,e));return i}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const i=uo(t);if(!i)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!lo[i])throw new Error(`${i} is not registered.`);const{klass:r}=lo[i],n=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&n===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const r in t){if(!t.hasOwnProperty(r))continue;if(lo[i].omit.indexOf(r)>=0)continue;const s=t[r];n[r]=lo[i].shallow.indexOf(r)>=0?s:fo(s,e)}t instanceof Error&&(n.message=t.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==i&&(n.$name=i),n}function mo(t){if(po(t))return t;if(Array.isArray(t))return t.map(mo);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=uo(t)||"Object";if(!lo[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:i}=lo[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const i of Object.keys(t)){if("$name"===i)continue;const n=t[i];r[i]=lo[e].shallow.indexOf(i)>=0?n:mo(n)}return r}class _o{constructor(){this.first=!0}update(t,e){const i=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=i,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=i,!0):(this.lastFloorZoom>i?(this.lastIntegerZoom=i+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<i&&(this.lastIntegerZoom=i,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=i,!0))}}const go=t=>t>=12288&&t<=12351,yo=t=>t>=12448&&t<=12543,xo=t=>t>=65280&&t<=65519;function vo(t){for(const e of t)if(To(e.charCodeAt(0)))return!0;return!1}function bo(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}bo(["Arab","Dupl","Mong","Ougr","Syrc"]);const wo=bo(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function To(t){return!(746!==t&&747!==t&&(t<4352||!((t=>t>=65072&&t<=65103)(t)&&!(t>=65097&&t<=65103)||(t=>t>=13056&&t<=13311)(t)||(t=>t>=12736&&t<=12783)(t)||!(!go(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||(t=>t>=12800&&t<=13055)(t)||(t=>t>=12272&&t<=12287)(t)||(t=>t>=12688&&t<=12703)(t)||yo(t)&&12540!==t||!(!xo(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!(t=>t>=65104&&t<=65135)(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=65040&&t<=65055)(t)||(t=>t>=19904&&t<=19967)(t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||wo.test(String.fromCodePoint(t)))))}const Po=bo(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function So(t){return Po.test(String.fromCodePoint(t))}function Mo(t,e){return!(!e&&So(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Io(t){for(const e of t)if(So(e.charCodeAt(0)))return!0;return!1}const Co=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(Co.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,e){return n(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const i=t.pluginURL,r=new Promise((t=>{this.loadScriptResolve=t}));e(i);const n=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([r,n]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:i};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${i}`)}))}};class Eo{constructor(t,e){this.isSupportedScript=Ao,this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new _o,this.transition=e.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new _o,this.transition={})}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),i=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*i}:{fromScale:.5,toScale:1,t:1-(1-i)*e}}}function Ao(t){return function(t,e){for(const i of t)if(!Mo(i.charCodeAt(0),e))return!1;return!0}(t,"loaded"===Co.getRTLTextPluginStatus())}class zo{constructor(t,e,i){this.property=t,this.value=e,this.expression=function(t,e,i){if(Kn(t))return new us(t,e);if(os(t)){const r=hs(t,e,i);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let i=t;return"color"===e.type&&"string"==typeof t?i=zi.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?i=Ni.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(i=Zi.parse(t)):i=Oi.parse(t):i=Fi.parse(t):i=Bi.parse(t),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>i}}}(void 0===e?t.specification.default:e,t.specification,i)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,i){return this.property.possiblyEvaluate(this,t,e,i)}}class ko{constructor(t,e){this.property=t,this.value=new zo(t,void 0,e)}transitioned(t,e){return new Ro(this.property,this.value,e,wt({},t.transition,this.transition),t.now)}untransitioned(){return new Ro(this.property,this.value,null,{},0)}}class Do{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._globalState=e}getValue(t){return zt(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ko(this._values[t].property,this._globalState)),this._values[t].value=new zo(this._values[t].property,null===e?void 0:zt(e),this._globalState)}getTransition(t){return zt(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ko(this._values[t].property,this._globalState)),this._values[t].transition=zt(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i);const r=this.getTransition(e);void 0!==r&&(t[`${e}-transition`]=r)}return t}transitioned(t,e){const i=new Lo(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(t,e._values[r]);return i}untransitioned(){const t=new Lo(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Ro{constructor(t,e,i,r,n){this.property=t,this.value=e,this.begin=n+r.delay||0,this.end=this.begin+r.duration||0,t.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(t,e,i){const r=t.now||0,n=this.value.possiblyEvaluate(t,e,i),s=this.prior;if(s){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return s.possiblyEvaluate(t,e,i);{const o=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,i),n,gt(o))}}return n}}class Lo{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,i){const r=new Oo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class Bo{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._globalState=e}hasValue(t){return void 0!==this._values[t].value}getValue(t){return zt(this._values[t].value)}setValue(t,e){this._values[t]=new zo(this._values[t].property,null===e?void 0:zt(e),this._globalState)}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i)}return t}possiblyEvaluate(t,e,i){const r=new Oo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}}class Fo{constructor(t,e,i){this.property=t,this.value=e,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,i,r){return this.property.evaluate(this.value,this.parameters,t,e,i,r)}}class Oo{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class jo{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,i){const r=xr[this.specification.type];return r?r(t,e,i):t}}class Vo{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,i,r){return new Fo(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},i,r)}:t.expression,e)}interpolate(t,e,i){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Fo(this,{kind:"constant",value:void 0},t.parameters);const r=xr[this.specification.type];if(r){const n=r(t.value.value,e.value.value,i);return new Fo(this,{kind:"constant",value:n},t.parameters)}return t}evaluate(t,e,i,r,n,s){return"constant"===t.kind?t.value:t.evaluate(e,i,r,n,s)}}class No extends Vo{possiblyEvaluate(t,e,i,r){if(void 0===t.value)return new Fo(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r),s="resolvedImage"===t.property.specification.type&&"string"!=typeof n?n.name:n,o=this._calculate(s,s,s,e);return new Fo(this,{kind:"constant",value:o},e)}if("camera"===t.expression.kind){const i=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Fo(this,{kind:"constant",value:i},e)}return new Fo(this,t.expression,e)}evaluate(t,e,i,r,n,s){if("source"===t.kind){const o=t.evaluate(e,i,r,n,s);return this._calculate(o,o,o,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},i,r),t.evaluate({zoom:Math.floor(e.zoom)},i,r),t.evaluate({zoom:Math.floor(e.zoom)+1},i,r),e):t.value}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class Uo{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){if(void 0!==t.value){if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r);return this._calculate(n,n,n,e)}return this._calculate(t.expression.evaluate(new Eo(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Eo(Math.floor(e.zoom),e)),t.expression.evaluate(new Eo(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class Zo{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){return!!t.expression.evaluate(e,null,{},i,r)}interpolate(){return!1}}class Go{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const i=t[e];i.specification.overridable&&this.overridableProperties.push(e);const r=this.defaultPropertyValues[e]=new zo(i,void 0,void 0),n=this.defaultTransitionablePropertyValues[e]=new ko(i,void 0);this.defaultTransitioningPropertyValues[e]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=r.possiblyEvaluate({})}}}co("DataDrivenProperty",Vo),co("DataConstantProperty",jo),co("CrossFadedDataDrivenProperty",No),co("CrossFadedProperty",Uo),co("ColorRampProperty",Zo);const $o="-transition";class qo extends be{constructor(t,e,i){if(super(),this.id=t.id,this.type=t.type,this._globalState=i,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=_s(t.filter,i)),e.layout&&(this._unevaluatedLayout=new Bo(e.layout,i)),e.paint)){this._transitionablePaint=new Do(e.paint,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Oo(e.paint)}}setFilter(t){this.filter=t,this._featureFilter=_s(t,this._globalState)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const i=this._unevaluatedLayout._values[e];for(const e of i.getGlobalStateRefs())t.add(e)}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}getPaintAffectingGlobalStateRefs(){var t;const e=new globalThis.Map;if(this._transitionablePaint)for(const i in this._transitionablePaint._values){const r=this._transitionablePaint._values[i].value;for(const n of r.getGlobalStateRefs()){const s=null!==(t=e.get(n))&&void 0!==t?t:[];s.push({name:i,value:r.value}),e.set(n,s)}}return e}setLayoutProperty(t,e,i={}){null!=e&&this._validate(so,`layers.${this.id}.layout.${t}`,t,e,i)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith($o)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,i={}){if(null!=e&&this._validate(no,`layers.${this.id}.paint.${t}`,t,e,i))return!1;if(t.endsWith($o))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const i=this._transitionablePaint._values[t],r="cross-faded-data-driven"===i.property.specification["property-type"],n=i.value.isDataDriven(),s=i.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const o=this._transitionablePaint._values[t].value;return o.isDataDriven()||n||r||this._handleOverridablePaintPropertyUpdate(t,s,o)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,i){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),Et(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&oo(this,t.call(eo,{key:e,layerType:this.type,objectKey:i,value:r,styleSpec:we,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Fo&&Wn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const Wo={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Ho{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class Xo{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function Yo(t,e=1){let i=0,r=0;return{members:t.map((t=>{const n=Wo[t.type].BYTES_PER_ELEMENT,s=i=Ko(i,Math.max(e,n)),o=t.components||1;return r=Math.max(r,n),i+=n*o,{name:t.name,type:t.type,components:o,offset:s}})),size:Ko(i,Math.max(r,e)),alignment:e}}function Ko(t,e){return Math.ceil(t/e)*e}class Jo extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.int16[r+0]=e,this.int16[r+1]=i,t}}Jo.prototype.bytesPerElement=4,co("StructArrayLayout2i4",Jo);class Qo extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.int16[n+0]=e,this.int16[n+1]=i,this.int16[n+2]=r,t}}Qo.prototype.bytesPerElement=6,co("StructArrayLayout3i6",Qo);class ta extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=i,this.int16[s+2]=r,this.int16[s+3]=n,t}}ta.prototype.bytesPerElement=8,co("StructArrayLayout4i8",ta);class ea extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=s,this.int16[a+5]=o,t}}ea.prototype.bytesPerElement=12,co("StructArrayLayout2i4i12",ea);class ia extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=4*t,l=8*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.uint8[l+4]=r,this.uint8[l+5]=n,this.uint8[l+6]=s,this.uint8[l+7]=o,t}}ia.prototype.bytesPerElement=8,co("StructArrayLayout2i4ub8",ia);class ra extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.float32[r+0]=e,this.float32[r+1]=i,t}}ra.prototype.bytesPerElement=8,co("StructArrayLayout2f8",ra);class na extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,i,r,n,s,o,a,l,c)}emplace(t,e,i,r,n,s,o,a,l,c,h){const u=10*t;return this.uint16[u+0]=e,this.uint16[u+1]=i,this.uint16[u+2]=r,this.uint16[u+3]=n,this.uint16[u+4]=s,this.uint16[u+5]=o,this.uint16[u+6]=a,this.uint16[u+7]=l,this.uint16[u+8]=c,this.uint16[u+9]=h,t}}na.prototype.bytesPerElement=20,co("StructArrayLayout10ui20",na);class sa extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,i,r,n,s,o,a,l,c,h,u)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=i,this.int16[d+2]=r,this.int16[d+3]=n,this.uint16[d+4]=s,this.uint16[d+5]=o,this.uint16[d+6]=a,this.uint16[d+7]=l,this.int16[d+8]=c,this.int16[d+9]=h,this.int16[d+10]=u,this.int16[d+11]=p,t}}sa.prototype.bytesPerElement=24,co("StructArrayLayout4i4ui4i24",sa);class oa extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.float32[n+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}oa.prototype.bytesPerElement=12,co("StructArrayLayout3f12",oa);class aa extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}aa.prototype.bytesPerElement=4,co("StructArrayLayout1ul4",aa);class la extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,i,r,n,s,o,a,l)}emplace(t,e,i,r,n,s,o,a,l,c){const h=10*t,u=5*t;return this.int16[h+0]=e,this.int16[h+1]=i,this.int16[h+2]=r,this.int16[h+3]=n,this.int16[h+4]=s,this.int16[h+5]=o,this.uint32[u+3]=a,this.uint16[h+8]=l,this.uint16[h+9]=c,t}}la.prototype.bytesPerElement=20,co("StructArrayLayout6i1ul2ui20",la);class ca extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=s,this.int16[a+5]=o,t}}ca.prototype.bytesPerElement=12,co("StructArrayLayout2i2i2i12",ca);class ha extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n)}emplace(t,e,i,r,n,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=i,this.float32[o+2]=r,this.int16[a+6]=n,this.int16[a+7]=s,t}}ha.prototype.bytesPerElement=16,co("StructArrayLayout2f1f2i16",ha);class ua extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=16*t,l=4*t,c=8*t;return this.uint8[a+0]=e,this.uint8[a+1]=i,this.float32[l+1]=r,this.float32[l+2]=n,this.int16[c+6]=s,this.int16[c+7]=o,t}}ua.prototype.bytesPerElement=16,co("StructArrayLayout2ub2f2i16",ua);class pa extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[n+0]=e,this.uint16[n+1]=i,this.uint16[n+2]=r,t}}pa.prototype.bytesPerElement=6,co("StructArrayLayout3ui6",pa);class da extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g){const y=24*t,x=12*t,v=48*t;return this.int16[y+0]=e,this.int16[y+1]=i,this.uint16[y+2]=r,this.uint16[y+3]=n,this.uint32[x+2]=s,this.uint32[x+3]=o,this.uint32[x+4]=a,this.uint16[y+10]=l,this.uint16[y+11]=c,this.uint16[y+12]=h,this.float32[x+7]=u,this.float32[x+8]=p,this.uint8[v+36]=d,this.uint8[v+37]=f,this.uint8[v+38]=m,this.uint32[x+10]=_,this.int16[y+22]=g,t}}da.prototype.bytesPerElement=48,co("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",da);class fa extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,S,M,I){const C=this.length;return this.resize(C+1),this.emplace(C,t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,S,M,I)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,S,M,I,C){const E=32*t,A=16*t;return this.int16[E+0]=e,this.int16[E+1]=i,this.int16[E+2]=r,this.int16[E+3]=n,this.int16[E+4]=s,this.int16[E+5]=o,this.int16[E+6]=a,this.int16[E+7]=l,this.uint16[E+8]=c,this.uint16[E+9]=h,this.uint16[E+10]=u,this.uint16[E+11]=p,this.uint16[E+12]=d,this.uint16[E+13]=f,this.uint16[E+14]=m,this.uint16[E+15]=_,this.uint16[E+16]=g,this.uint16[E+17]=y,this.uint16[E+18]=x,this.uint16[E+19]=v,this.uint16[E+20]=b,this.uint16[E+21]=w,this.uint16[E+22]=T,this.uint32[A+12]=P,this.float32[A+13]=S,this.float32[A+14]=M,this.uint16[E+30]=I,this.uint16[E+31]=C,t}}fa.prototype.bytesPerElement=64,co("StructArrayLayout8i15ui1ul2f2ui64",fa);class ma extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}ma.prototype.bytesPerElement=4,co("StructArrayLayout1f4",ma);class _a extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[6*t+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}_a.prototype.bytesPerElement=12,co("StructArrayLayout1ui2f12",_a);class ga extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=4*t;return this.uint32[2*t+0]=e,this.uint16[n+2]=i,this.uint16[n+3]=r,t}}ga.prototype.bytesPerElement=8,co("StructArrayLayout1ul2ui8",ga);class ya extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.uint16[r+0]=e,this.uint16[r+1]=i,t}}ya.prototype.bytesPerElement=4,co("StructArrayLayout2ui4",ya);class xa extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}xa.prototype.bytesPerElement=2,co("StructArrayLayout1ui2",xa);class va extends Xo{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=i,this.float32[s+2]=r,this.float32[s+3]=n,t}}va.prototype.bytesPerElement=16,co("StructArrayLayout4f16",va);class ba extends Ho{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new s(this.anchorPointX,this.anchorPointY)}}ba.prototype.size=20;class wa extends la{get(t){return new ba(this,t)}}co("CollisionBoxArray",wa);class Ta extends Ho{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Ta.prototype.size=48;class Pa extends da{get(t){return new Ta(this,t)}}co("PlacedSymbolArray",Pa);class Sa extends Ho{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Sa.prototype.size=64;class Ma extends fa{get(t){return new Sa(this,t)}}co("SymbolInstanceArray",Ma);class Ia extends ma{getoffsetX(t){return this.float32[1*t+0]}}co("GlyphOffsetArray",Ia);class Ca extends Qo{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}co("SymbolLineVertexArray",Ca);class Ea extends Ho{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Ea.prototype.size=12;class Aa extends _a{get(t){return new Ea(this,t)}}co("TextAnchorOffsetArray",Aa);class za extends Ho{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}za.prototype.size=8;class ka extends ga{get(t){return new za(this,t)}}co("FeatureIndexArray",ka);class Da extends Jo{}class Ra extends Qo{}class La extends ta{}class Ba extends Jo{}class Fa extends Jo{}class Oa extends ea{}class ja extends ia{}class Va extends ra{}class Na extends na{}class Ua extends sa{}class Za extends oa{}class Ga extends aa{}class $a extends ca{}class qa extends ha{}class Wa extends ua{}class Ha extends pa{}class Xa extends pa{}class Ya extends ya{}class Ka extends xa{}const Ja=Yo([{name:"a_pos",components:2,type:"Int16"}],4),{members:Qa}=Ja;class tl{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,i,r){const n=this.segments[this.segments.length-1];return t>tl.MAX_VERTEX_ARRAY_LENGTH&&Dt(`Max vertices per segment is ${tl.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${tl.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!n||n.vertexLength+t>tl.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r?this.createNewSegment(e,i,r):n}createNewSegment(t,e,i){const r={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==i&&(r.sortKey=i),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(r),r}getOrCreateLatestSegment(t,e,i){return this.prepareSegment(0,t,e,i)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,i,r){return new tl([{vertexOffset:t,primitiveOffset:e,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function el(t,e){return 256*(t=vt(Math.floor(t),0,255))+vt(Math.floor(e),0,255)}tl.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,co("SegmentVector",tl);const il=Yo([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var rl,nl,sl,ol={exports:{}},al={exports:{}},ll={exports:{}},cl=function(){if(sl)return ol.exports;sl=1;var t=(rl||(rl=1,function(t){t.exports=function(t,e){var i,r,n,s,o,a,l,c;for(r=t.length-(i=3&t.length),n=e,o=3432918353,a=461845907,c=0;c<r;)l=255&t.charCodeAt(c)|(255&t.charCodeAt(++c))<<8|(255&t.charCodeAt(++c))<<16|(255&t.charCodeAt(++c))<<24,++c,n=27492+(65535&(s=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&t.charCodeAt(c+2))<<16;case 2:l^=(255&t.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(c)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return n^=t.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(al)),al.exports),e=(nl||(nl=1,function(t){t.exports=function(t,e){for(var i,r=t.length,n=e^r,s=0;r>=4;)i=1540483477*(65535&(i=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++s;switch(r){case 3:n^=(255&t.charCodeAt(s+2))<<16;case 2:n^=(255&t.charCodeAt(s+1))<<8;case 1:n=1540483477*(65535&(n^=255&t.charCodeAt(s)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(ll)),ll.exports);return ol.exports=t,ol.exports.murmur3=t,ol.exports.murmur2=e,ol.exports}(),hl=o(cl);class ul{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,i,r){this.ids.push(pl(t)),this.positions.push(e,i,r)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=pl(t);let i=0,r=this.ids.length-1;for(;i<r;){const t=i+r>>1;this.ids[t]>=e?r=t:i=t+1}const n=[];for(;this.ids[i]===e;)n.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return n}static serialize(t,e){const i=new Float64Array(t.ids),r=new Uint32Array(t.positions);return dl(i,r,0,i.length-1),e&&e.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(t){const e=new ul;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function pl(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:hl(String(t))}function dl(t,e,i,r){for(;i<r;){const n=t[i+r>>1];let s=i-1,o=r+1;for(;;){do{s++}while(t[s]<n);do{o--}while(t[o]>n);if(s>=o)break;fl(t,s,o),fl(e,3*s,3*o),fl(e,3*s+1,3*o+1),fl(e,3*s+2,3*o+2)}o-i<r-o?(dl(t,e,i,o),i=o+1):(dl(t,e,o+1,r),r=o)}}function fl(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}co("FeaturePositionMap",ul);class ml{constructor(t,e){this.gl=t.gl,this.location=e}}class _l extends ml{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t))}}class gl extends ml{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class yl extends ml{constructor(t,e){super(t,e),this.current=[0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]))}}class xl extends ml{constructor(t,e){super(t,e),this.current=[0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]))}}class vl extends ml{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class bl extends ml{constructor(t,e){super(t,e),this.current=zi.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}class wl extends ml{constructor(t,e){super(t,e),this.current=new Array}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(4*t.length);for(let i=0;i<t.length;i++)e[4*i]=t[i].r,e[4*i+1]=t[i].g,e[4*i+2]=t[i].b,e[4*i+3]=t[i].a;this.gl.uniform4fv(this.location,e)}}}class Tl extends ml{constructor(t,e){super(t,e),this.current=new Array}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(t);this.gl.uniform1fv(this.location,e)}}}const Pl=new Float32Array(16);class Sl extends ml{constructor(t,e){super(t,e),this.current=Pl}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}}function Ml(t){return[el(255*t.r,255*t.g),el(255*t.b,255*t.a)]}class Il{constructor(t,e,i){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=i}setUniform(t,e,i){t.set(i.constantOr(this.value))}getBinding(t,e,i){return"color"===this.type?new bl(t,e):new gl(t,e)}}class Cl{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,i,r){const n="u_pattern_to"===r?this.patternTo:"u_pattern_from"===r?this.patternFrom:"u_pixel_ratio_to"===r?this.pixelRatioTo:"u_pixel_ratio_from"===r?this.pixelRatioFrom:null;n&&t.set(n)}getBinding(t,e,i){return"u_pattern"===i.substr(0,9)?new vl(t,e):new gl(t,e)}}class El{constructor(t,e,i,r){this.expression=t,this.type=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(t,e,i){const r=this.paintVertexArray.length,n=this.expression.evaluate(new Eo(0,i),e,{},i.canonical,[],i.formattedSection);this.paintVertexArray.resize(t),this._setPaintValue(r,t,n)}updatePaintArray(t,e,i,r,n){const s=this.expression.evaluate(new Eo(0,n),i,r);this._setPaintValue(t,e,s)}_setPaintValue(t,e,i){if("color"===this.type){const r=Ml(i);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Al{constructor(t,e,i,r,n,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(t,e,i){const r=this.expression.evaluate(new Eo(this.zoom,i),e,{},i.canonical,[],i.formattedSection),n=this.expression.evaluate(new Eo(this.zoom+1,i),e,{},i.canonical,[],i.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(s,t,r,n)}updatePaintArray(t,e,i,r,n){const s=this.expression.evaluate(new Eo(this.zoom,n),i,r),o=this.expression.evaluate(new Eo(this.zoom+1,n),i,r);this._setPaintValue(t,e,s,o)}_setPaintValue(t,e,i,r){if("color"===this.type){const n=Ml(i),s=Ml(r);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,n[0],n[1],s[0],s[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const i=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,r=vt(this.expression.interpolationFactor(i,this.zoom,this.zoom+1),0,1);t.set(r)}getBinding(t,e,i){return new gl(t,e)}}class zl{constructor(t,e,i,r,n,s){this.expression=t,this.type=e,this.useIntegerZoom=i,this.zoom=r,this.layerId=s,this.zoomInPaintVertexArray=new n,this.zoomOutPaintVertexArray=new n}populatePaintArray(t,e,i){const r=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(r,t,e.patterns&&e.patterns[this.layerId],i.imagePositions)}updatePaintArray(t,e,i,r,n){this._setPaintValues(t,e,i.patterns&&i.patterns[this.layerId],n.imagePositions)}_setPaintValues(t,e,i,r){if(!r||!i)return;const{min:n,mid:s,max:o}=i,a=r[n],l=r[s],c=r[o];if(a&&l&&c)for(let i=t;i<e;i++)this.zoomInPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],a.tl[0],a.tl[1],a.br[0],a.br[1],l.pixelRatio,a.pixelRatio),this.zoomOutPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],c.tl[0],c.tl[1],c.br[0],c.br[1],l.pixelRatio,c.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,il.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,il.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class kl{constructor(t,e,i){this.binders={},this._buffers=[];const r=[];for(const n in t.paint._values){if(!i(n))continue;const s=t.paint.get(n);if(!(s instanceof Fo&&Wn(s.property.specification)))continue;const o=Rl(n,t.type),a=s.value,l=s.property.specification.type,c=s.property.useIntegerZoom,h=s.property.specification["property-type"],u="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===a.kind)this.binders[n]=u?new Cl(a.value,o):new Il(a.value,o,l),r.push(`/u_${n}`);else if("source"===a.kind||u){const i=Ll(n,l,"source");this.binders[n]=u?new zl(a,l,c,e,i,t.id):new El(a,o,l,i),r.push(`/a_${n}`)}else{const t=Ll(n,l,"composite");this.binders[n]=new Al(a,o,l,c,e,t),r.push(`/z_${n}`)}}this.cacheKey=r.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof El||e instanceof Al?e.maxValue:0}populatePaintArrays(t,e,i){for(const r in this.binders){const n=this.binders[r];(n instanceof El||n instanceof Al||n instanceof zl)&&n.populatePaintArray(t,e,i)}}setConstantPatternPositions(t,e){for(const i in this.binders){const r=this.binders[i];r instanceof Cl&&r.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,i,r,n){let s=!1;for(const o in t){const a=e.getPositions(o);for(const e of a){const a=i.feature(e.index);for(const i in this.binders){const l=this.binders[i];if((l instanceof El||l instanceof Al||l instanceof zl)&&!0===l.expression.isStateDependent){const c=r.paint.get(i);l.expression=c.value,l.updatePaintArray(e.start,e.end,a,t[o],n),s=!0}}}}return s}defines(){const t=[];for(const e in this.binders){const i=this.binders[e];(i instanceof Il||i instanceof Cl)&&t.push(...i.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof El||i instanceof Al)for(let e=0;e<i.paintVertexAttributes.length;e++)t.push(i.paintVertexAttributes[e].name);else if(i instanceof zl)for(let e=0;e<il.members.length;e++)t.push(il.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof Il||i instanceof Cl||i instanceof Al)for(const e of i.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const i=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Il||n instanceof Cl||n instanceof Al)for(const s of n.uniformNames)if(e[s]){const o=n.getBinding(t,e[s],s);i.push({name:s,property:r,binding:o})}}return i}setUniforms(t,e,i,r){for(const{name:t,property:n,binding:s}of e)this.binders[n].setUniform(s,r,i.get(n),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const i=this.binders[e];if(t&&i instanceof zl){const e=2===t.fromScale?i.zoomInPaintVertexBuffer:i.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(i instanceof El||i instanceof Al)&&i.paintVertexBuffer&&this._buffers.push(i.paintVertexBuffer)}}upload(t){for(const e in this.binders){const i=this.binders[e];(i instanceof El||i instanceof Al||i instanceof zl)&&i.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof El||e instanceof Al||e instanceof zl)&&e.destroy()}}}class Dl{constructor(t,e,i=()=>!0){this.programConfigurations={};for(const r of t)this.programConfigurations[r.id]=new kl(r,e,i);this.needsUpload=!1,this._featureMap=new ul,this._bufferOffset=0}populatePaintArrays(t,e,i,r){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(t,e,r);void 0!==e.id&&this._featureMap.add(e.id,i,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,i,r){for(const n of i)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(t,this._featureMap,e,n,r)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function Rl(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Ll(t,e,i){const r={color:{source:ra,composite:va},number:{source:ma,composite:ra}},n=function(t){return{"line-pattern":{source:Na,composite:Na},"fill-pattern":{source:Na,composite:Na},"fill-extrusion-pattern":{source:Na,composite:Na}}[t]}(t);return n&&n[i]||r[e][i]}co("ConstantBinder",Il),co("CrossFadedConstantBinder",Cl),co("SourceExpressionBinder",El),co("CrossFadedCompositeBinder",zl),co("CompositeExpressionBinder",Al),co("ProgramConfiguration",kl,{omit:["_buffers"]}),co("ProgramConfigurationSet",Dl);const Bl=Math.pow(2,14)-1,Fl=-Bl-1;function Ol(t){const e=Q/t.extent,i=t.loadGeometry();for(let t=0;t<i.length;t++){const r=i[t];for(let t=0;t<r.length;t++){const i=r[t],n=Math.round(i.x*e),s=Math.round(i.y*e);i.x=vt(n,Fl,Bl),i.y=vt(s,Fl,Bl),(n<i.x||n>i.x+1||s<i.y||s>i.y+1)&&Dt("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return i}function jl(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?Ol(t):[]}}const Vl=-32768;function Nl(t,e,i,r,n){t.emplaceBack(Vl+8*e+r,Vl+8*i+n)}class Ul{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Ba,this.indexArray=new Xa,this.segments=new tl,this.programConfigurations=new Dl(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){const r=this.layers[0],n=[];let s=null,o=!1,a="heatmap"===r.type;if("circle"===r.type){const t=r;s=t.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===t.paint.get("circle-pitch-alignment")}const l=a?e.subdivisionGranularity.circle:1;for(const{feature:e,id:r,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=jl(e,t);if(!this.layers[0]._featureFilter.filter(new Eo(this.zoom),c,i))continue;const h=o?s.evaluate(c,{},i):void 0,u={id:r,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?c.geometry:Ol(e),patterns:{},sortKey:h};n.push(u)}o&&n.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of n){const{geometry:n,index:s,sourceLayerIndex:o}=r,a=t[s].feature;this.addFeature(r,n,s,i,l),e.featureIndex.insert(a,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Qa),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,i,r,n=1){let s;switch(n){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${n}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const i of e)for(const e of i){const i=e.x,r=e.y;if(i<0||i>=Q||r<0||r>=Q)continue;const n=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,t.sortKey),a=n.vertexLength;for(let t=0;t<o;t++)for(let e=0;e<o;e++)Nl(this.layoutVertexArray,i,r,s[e],s[t]);for(let t=0;t<o-1;t++)for(let e=0;e<o-1;e++){const i=a+t*o+e,r=a+(t+1)*o+e;this.indexArray.emplaceBack(i,r+1,i+1),this.indexArray.emplaceBack(i,r,r+1)}n.vertexLength+=o*o,n.primitiveLength+=(o-1)*(o-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:{},canonical:r})}}function Zl(t,e){for(let i=0;i<t.length;i++)if(Jl(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(Jl(t,e[i]))return!0;return!!Wl(t,e)}function Gl(t,e,i){return!!Jl(t,e)||!!Xl(e,t,i)}function $l(t,e){if(1===t.length)return Kl(e,t[0]);for(let i=0;i<e.length;i++){const r=e[i];for(let e=0;e<r.length;e++)if(Jl(t,r[e]))return!0}for(let i=0;i<t.length;i++)if(Kl(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(Wl(t,e[i]))return!0;return!1}function ql(t,e,i){if(t.length>1){if(Wl(t,e))return!0;for(let r=0;r<e.length;r++)if(Xl(e[r],t,i))return!0}for(let r=0;r<t.length;r++)if(Xl(t[r],e,i))return!0;return!1}function Wl(t,e){if(0===t.length||0===e.length)return!1;for(let i=0;i<t.length-1;i++){const r=t[i],n=t[i+1];for(let t=0;t<e.length-1;t++)if(Hl(r,n,e[t],e[t+1]))return!0}return!1}function Hl(t,e,i,r){return Rt(t,i,r)!==Rt(e,i,r)&&Rt(t,e,i)!==Rt(t,e,r)}function Xl(t,e,i){const r=i*i;if(1===e.length)return t.distSqr(e[0])<r;for(let i=1;i<e.length;i++)if(Yl(t,e[i-1],e[i])<r)return!0;return!1}function Yl(t,e,i){const r=e.distSqr(i);if(0===r)return t.distSqr(e);const n=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/r;return t.distSqr(n<0?e:n>1?i:i.sub(e)._mult(n)._add(e))}function Kl(t,e){let i,r,n,s=!1;for(let o=0;o<t.length;o++){i=t[o];for(let t=0,o=i.length-1;t<i.length;o=t++)r=i[t],n=i[o],r.y>e.y!=n.y>e.y&&e.x<(n.x-r.x)*(e.y-r.y)/(n.y-r.y)+r.x&&(s=!s)}return s}function Jl(t,e){let i=!1;for(let r=0,n=t.length-1;r<t.length;n=r++){const s=t[r],o=t[n];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(i=!i)}return i}function Ql(t,e,i){const r=i[0],n=i[2];if(t.x<r.x&&e.x<r.x||t.x>n.x&&e.x>n.x||t.y<r.y&&e.y<r.y||t.y>n.y&&e.y>n.y)return!1;const s=Rt(t,e,i[0]);return s!==Rt(t,e,i[1])||s!==Rt(t,e,i[2])||s!==Rt(t,e,i[3])}function tc(t,e,i){const r=e.paint.get(t).value;return"constant"===r.kind?r.value:i.programConfigurations.get(e.id).getMaxValue(t)}function ec(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function ic(t,e,i,r,n){if(!e[0]&&!e[1])return t;const o=s.convert(e)._mult(n);"viewport"===i&&o._rotate(-r);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(o));return a}function rc({queryGeometry:t,size:e},i){return Gl(t,i,e)}function nc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n},s){return Gl(t,s,e*(i.projectTileCoordinates(s.x,s.y,r,n).signedDistanceFromCamera/i.cameraToCenterDistance))}function sc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n},s){const o=i.projectTileCoordinates(s.x,s.y,r,n).signedDistanceFromCamera,a=e*(i.cameraToCenterDistance/o);return Gl(t,lc(s,i,r,n),a)}function oc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n},s){return Gl(t,lc(s,i,r,n),e)}function ac({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n,pitchAlignment:s="map",pitchScale:o="map"},a){const l="map"===s?"map"===o?rc:nc:"map"===o?sc:oc,c={queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n};for(const t of a)for(const e of t)if(l(c,e))return!0;return!1}function lc(t,e,i,r){const n=e.projectTileCoordinates(t.x,t.y,i,r).point;return new s((.5*n.x+.5)*e.width,(.5*-n.y+.5)*e.height)}let cc,hc;co("CircleBucket",Ul,{omit:["layers"]});var uc={get paint(){return hc=hc||new Go({"circle-radius":new Vo(we.paint_circle["circle-radius"]),"circle-color":new Vo(we.paint_circle["circle-color"]),"circle-blur":new Vo(we.paint_circle["circle-blur"]),"circle-opacity":new Vo(we.paint_circle["circle-opacity"]),"circle-translate":new jo(we.paint_circle["circle-translate"]),"circle-translate-anchor":new jo(we.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new jo(we.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new jo(we.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Vo(we.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Vo(we.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Vo(we.paint_circle["circle-stroke-opacity"])})},get layout(){return cc=cc||new Go({"circle-sort-key":new Vo(we.layout_circle["circle-sort-key"])})}};class pc extends qo{constructor(t,e){super(t,uc,e)}createBucket(t){return new Ul(t)}queryRadius(t){const e=t;return tc("circle-radius",this,e)+tc("circle-stroke-width",this,e)+ec(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){const l=ic(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-n.bearingInRadians,s),c=this.paint.get("circle-radius").evaluate(e,i)+this.paint.get("circle-stroke-width").evaluate(e,i),h=this.paint.get("circle-pitch-scale"),u=this.paint.get("circle-pitch-alignment");let p,d;return"map"===u?(p=l,d=c*s):(p=function(t,e,i,r){return t.map((t=>lc(t,e,i,r)))}(l,n,o,a),d=c),ac({queryGeometry:p,size:d,transform:n,unwrappedTileID:o,getElevation:a,pitchAlignment:u,pitchScale:h},r)}}class dc extends Ul{}let fc;co("HeatmapBucket",dc,{omit:["layers"]});var mc={get paint(){return fc=fc||new Go({"heatmap-radius":new Vo(we.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Vo(we.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new jo(we.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Zo(we.paint_heatmap["heatmap-color"]),"heatmap-opacity":new jo(we.paint_heatmap["heatmap-opacity"])})}};function _c(t,{width:e,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==e*i*r)throw new RangeError(`mismatched image size. expected: ${n.length} but got: ${e*i*r}`)}else n=new Uint8Array(e*i*r);return t.width=e,t.height=i,t.data=n,t}function gc(t,{width:e,height:i},r){if(e===t.width&&i===t.height)return;const n=_c({},{width:e,height:i},r);yc(t,n,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,i)},r),t.width=e,t.height=i,t.data=n.data}function yc(t,e,i,r,n,s){if(0===n.width||0===n.height)return e;if(n.width>t.width||n.height>t.height||i.x>t.width-n.width||i.y>t.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>e.width||n.height>e.height||r.x>e.width-n.width||r.y>e.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const o=t.data,a=e.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<n.height;l++){const c=((i.y+l)*t.width+i.x)*s,h=((r.y+l)*e.width+r.x)*s;for(let t=0;t<n.width*s;t++)a[h+t]=o[c+t]}return e}class xc{constructor(t,e){_c(this,t,1,e)}resize(t){gc(this,t,1)}clone(){return new xc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){yc(t,e,i,r,n,1)}}class vc{constructor(t,e){_c(this,t,4,e)}resize(t){gc(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new vc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){yc(t,e,i,r,n,4)}setPixel(t,e,i){const r=4*(t*this.width+e);this.data[r+0]=Math.round(255*i.r/i.a),this.data[r+1]=Math.round(255*i.g/i.a),this.data[r+2]=Math.round(255*i.b/i.a),this.data[r+3]=Math.round(255*i.a)}}function bc(t){const e={},i=t.resolution||256,r=t.clips?t.clips.length:1,n=t.image||new vc({width:i,height:r});if(Math.log(i)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${i}`);const s=(r,s,o)=>{e[t.evaluationKey]=o;const a=t.expression.evaluate(e);n.setPixel(r/4/i,s/4,a)};if(t.clips)for(let e=0,n=0;e<r;++e,n+=4*i)for(let r=0,o=0;r<i;r++,o+=4){const a=r/(i-1),{start:l,end:c}=t.clips[e];s(n,o,l*(1-a)+c*a)}else for(let t=0,e=0;t<i;t++,e+=4)s(0,e,t/(i-1));return n}co("AlphaImage",xc),co("RGBAImage",vc);const wc="big-fb";class Tc extends qo{createBucket(t){return new dc(t)}constructor(t,e){super(t,mc,e),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=bc({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(wc)&&this.heatmapFbos.delete(wc)}queryRadius(t){return tc("heatmap-radius",this,t)}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){return ac({queryGeometry:t,size:this.paint.get("heatmap-radius").evaluate(e,i)*s,transform:n,unwrappedTileID:o,getElevation:a},r)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Pc;var Sc={get paint(){return Pc=Pc||new Go({"hillshade-illumination-direction":new jo(we.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new jo(we.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new jo(we.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new jo(we.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new jo(we.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new jo(we.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new jo(we.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new jo(we.paint_hillshade["hillshade-method"])})}};class Mc extends qo{constructor(t,e){super(t,Sc,e),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,i=this.paint.get("hillshade-highlight-color").values,r=this.paint.get("hillshade-shadow-color").values;const n=Math.max(t.length,e.length,i.length,r.length);t=t.concat(Array(n-t.length).fill(t.at(-1))),e=e.concat(Array(n-e.length).fill(e.at(-1))),i=i.concat(Array(n-i.length).fill(i.at(-1))),r=r.concat(Array(n-r.length).fill(r.at(-1)));const s=e.map(Vt);return{directionRadians:t.map(Vt),altitudeRadians:s,shadowColor:r,highlightColor:i}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let Ic;var Cc={get paint(){return Ic=Ic||new Go({"color-relief-opacity":new jo(we["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new Zo(we["paint_color-relief"]["color-relief-color"])})}};class Ec{constructor(t,e,i,r){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,r)}update(t,e,i){const{width:r,height:n}=t,s=!(this.size&&this.size[0]===r&&this.size[1]===n||i),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(e&&e.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[r,n],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Ft(t)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,r,n,0,this.format,a.UNSIGNED_BYTE,t.data);else{const{x:e,y:s}=i||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Ft(t)?a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,s,r,n,a.RGBA,a.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D),o.pixelStoreUnpackFlipY.setDefault(),o.pixelStoreUnpack.setDefault(),o.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(t,e,i){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),i!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=n.LINEAR),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}function Ac(t,e){const i=e[0],r=e[1],n=e[2],s=e[3],o=Math.min(i,r,n),a=Math.round((t+s)/o);return{r:Math.floor(a*o/i)%256,g:Math.floor(a*o/r)%256,b:Math.floor(a*o/n)%256}}co("DEMData",class{constructor(t,e,i,r=1,n=1,s=1,o=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(i&&!["mapbox","terrarium","custom"].includes(i))return void Dt(`"${i}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const a=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),i){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=r,this.greenFactor=n,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<a;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(a,t)]=this.data[this._idx(a-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,a)]=this.data[this._idx(t,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<a;t++)for(let e=0;e<a;e++){const i=this.get(t,e);i>this.max&&(this.max=i),i<this.min&&(this.min=i)}}get(t,e){const i=new Uint8Array(this.data.buffer),r=4*this._idx(t,e);return this.unpack(i[r],i[r+1],i[r+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,i){return t*this.redFactor+e*this.greenFactor+i*this.blueFactor-this.baseShift}pack(t){return Ac(t,this.getUnpackVector())}getPixels(){return new vc({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,i){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let r=e*this.dim,n=e*this.dim+this.dim,s=i*this.dim,o=i*this.dim+this.dim;switch(e){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:s=o-1;break;case 1:o=s+1}const a=-e*this.dim,l=-i*this.dim;for(let e=s;e<o;e++)for(let i=r;i<n;i++)this.data[this._idx(i,e)]=t.data[this._idx(i+a,e+l)]}});class zc extends qo{constructor(t,e){super(t,Cc,e)}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},i=this._transitionablePaint._values["color-relief-color"].value.expression;if(i instanceof ls&&i._styleExpression.expression instanceof gr){this.colorRampExpression=i;const t=i._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const i of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:i}}))}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[zi.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const r={elevationStops:[],colorStops:[]},n=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=n)r.elevationStops.push(e.elevationStops[Math.round(t)]),r.colorStops.push(e.colorStops[Math.round(t)]);return Dt(`Too many colors in specification of ${this.id} color-relief layer, may not render properly.`),r}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,i){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const r=this._createColorRamp(e),n=new vc({width:r.colorStops.length,height:1}),s=new vc({width:r.colorStops.length,height:1});for(let t=0;t<r.elevationStops.length;t++){const e=Ac(r.elevationStops[t],i);s.setPixel(0,t,new zi(e.r/255,e.g/255,e.b/255,1)),n.setPixel(0,t,r.colorStops[t])}return this.colorRampTextures={elevationTexture:new Ec(t,s,t.gl.RGBA),colorTexture:new Ec(t,n,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return"none"!==this.visibility&&!!this.colorRampTextures}}const kc=Yo([{name:"a_pos",components:2,type:"Int16"}],4),{members:Dc}=kc;function Rc(t,e,i){const r=i.patternDependencies;let n=!1;for(const i of e){const e=i.paint.get(`${t}-pattern`);e.isConstant()||(n=!0);const s=e.constantOr(null);s&&(n=!0,r[s.to]=!0,r[s.from]=!0)}return n}function Lc(t,e,i,r,n){const{zoom:s}=r,o=n.patternDependencies;for(const r of e){const e=r.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:s-1},i,{},n.availableImages),a=e.evaluate({zoom:s},i,{},n.availableImages),l=e.evaluate({zoom:s+1},i,{},n.availableImages);t=t&&t.name?t.name:t,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,o[t]=!0,o[a]=!0,o[l]=!0,i.patterns[r.id]={min:t,mid:a,max:l}}}return i}function Bc(t,e,i,r,n){let s;if(n===function(t,e,i,r){let n=0;for(let s=e,o=i-r;s<i;s+=r)n+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return n}(t,e,i,r)>0)for(let n=e;n<i;n+=r)s=nh(n/r|0,t[n],t[n+1],s);else for(let n=i-r;n>=e;n-=r)s=nh(n/r|0,t[n],t[n+1],s);return s&&Jc(s,s.next)&&(sh(s),s=s.next),s}function Fc(t,e){if(!t)return t;e||(e=t);let i,r=t;do{if(i=!1,r.steiner||!Jc(r,r.next)&&0!==Kc(r.prev,r,r.next))r=r.next;else{if(sh(r),r=e=r.prev,r===r.next)break;i=!0}}while(i||r!==e);return e}function Oc(t,e,i,r,n,s,o){if(!t)return;!o&&s&&function(t,e,i,r){let n=t;do{0===n.z&&(n.z=qc(n.x,n.y,e,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){let e,i=1;do{let r,n=t;t=null;let s=null;for(e=0;n;){e++;let o=n,a=0;for(let t=0;t<i&&(a++,o=o.nextZ,o);t++);let l=i;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||n.z<=o.z)?(r=n,n=n.nextZ,a--):(r=o,o=o.nextZ,l--),s?s.nextZ=r:t=r,r.prevZ=s,s=r;n=o}s.nextZ=null,i*=2}while(e>1)}(n)}(t,r,n,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,c=t.next;if(s?Vc(t,r,n,s):jc(t))e.push(l.i,t.i,c.i),sh(t),t=c.next,a=c.next;else if((t=c)===a){o?1===o?Oc(t=Nc(Fc(t),e),e,i,r,n,s,2):2===o&&Uc(t,e,i,r,n,s):Oc(Fc(t),e,i,r,n,s,1);break}}}function jc(t){const e=t.prev,i=t,r=t.next;if(Kc(e,i,r)>=0)return!1;const n=e.x,s=i.x,o=r.x,a=e.y,l=i.y,c=r.y,h=Math.min(n,s,o),u=Math.min(a,l,c),p=Math.max(n,s,o),d=Math.max(a,l,c);let f=r.next;for(;f!==e;){if(f.x>=h&&f.x<=p&&f.y>=u&&f.y<=d&&Xc(n,a,s,l,o,c,f.x,f.y)&&Kc(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function Vc(t,e,i,r){const n=t.prev,s=t,o=t.next;if(Kc(n,s,o)>=0)return!1;const a=n.x,l=s.x,c=o.x,h=n.y,u=s.y,p=o.y,d=Math.min(a,l,c),f=Math.min(h,u,p),m=Math.max(a,l,c),_=Math.max(h,u,p),g=qc(d,f,e,i,r),y=qc(m,_,e,i,r);let x=t.prevZ,v=t.nextZ;for(;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==o&&Xc(a,h,l,u,c,p,x.x,x.y)&&Kc(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==o&&Xc(a,h,l,u,c,p,v.x,v.y)&&Kc(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==o&&Xc(a,h,l,u,c,p,x.x,x.y)&&Kc(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==o&&Xc(a,h,l,u,c,p,v.x,v.y)&&Kc(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function Nc(t,e){let i=t;do{const r=i.prev,n=i.next.next;!Jc(r,n)&&Qc(r,i,i.next,n)&&ih(r,n)&&ih(n,r)&&(e.push(r.i,i.i,n.i),sh(i),sh(i.next),i=t=n),i=i.next}while(i!==t);return Fc(i)}function Uc(t,e,i,r,n,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&Yc(o,t)){let a=rh(o,t);return o=Fc(o,o.next),a=Fc(a,a.next),Oc(o,e,i,r,n,s,0),void Oc(a,e,i,r,n,s,0)}t=t.next}o=o.next}while(o!==t)}function Zc(t,e){let i=t.x-e.x;return 0===i&&(i=t.y-e.y,0===i)&&(i=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),i}function Gc(t,e){const i=function(t,e){let i=e;const r=t.x,n=t.y;let s,o=-1/0;if(Jc(t,i))return i;do{if(Jc(t,i.next))return i.next;if(n<=i.y&&n>=i.next.y&&i.next.y!==i.y){const t=i.x+(n-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(t<=r&&t>o&&(o=t,s=i.x<i.next.x?i:i.next,t===r))return s}i=i.next}while(i!==e);if(!s)return null;const a=s,l=s.x,c=s.y;let h=1/0;i=s;do{if(r>=i.x&&i.x>=l&&r!==i.x&&Hc(n<c?r:o,n,l,c,n<c?o:r,n,i.x,i.y)){const e=Math.abs(n-i.y)/(r-i.x);ih(i,t)&&(e<h||e===h&&(i.x>s.x||i.x===s.x&&$c(s,i)))&&(s=i,h=e)}i=i.next}while(i!==a);return s}(t,e);if(!i)return e;const r=rh(i,t);return Fc(r,r.next),Fc(i,i.next)}function $c(t,e){return Kc(t.prev,t,e.prev)<0&&Kc(e.next,t,t.next)<0}function qc(t,e,i,r,n){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-i)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Wc(t){let e=t,i=t;do{(e.x<i.x||e.x===i.x&&e.y<i.y)&&(i=e),e=e.next}while(e!==t);return i}function Hc(t,e,i,r,n,s,o,a){return(n-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(r-a)>=(i-o)*(e-a)&&(i-o)*(s-a)>=(n-o)*(r-a)}function Xc(t,e,i,r,n,s,o,a){return!(t===o&&e===a)&&Hc(t,e,i,r,n,s,o,a)}function Yc(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&Qc(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}(t,e)&&(ih(t,e)&&ih(e,t)&&function(t,e){let i=t,r=!1;const n=(t.x+e.x)/2,s=(t.y+e.y)/2;do{i.y>s!=i.next.y>s&&i.next.y!==i.y&&n<(i.next.x-i.x)*(s-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}(t,e)&&(Kc(t.prev,t,e.prev)||Kc(t,e.prev,e))||Jc(t,e)&&Kc(t.prev,t,t.next)>0&&Kc(e.prev,e,e.next)>0)}function Kc(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function Jc(t,e){return t.x===e.x&&t.y===e.y}function Qc(t,e,i,r){const n=eh(Kc(t,e,i)),s=eh(Kc(t,e,r)),o=eh(Kc(i,r,t)),a=eh(Kc(i,r,e));return n!==s&&o!==a||!(0!==n||!th(t,i,e))||!(0!==s||!th(t,r,e))||!(0!==o||!th(i,t,r))||!(0!==a||!th(i,e,r))}function th(t,e,i){return e.x<=Math.max(t.x,i.x)&&e.x>=Math.min(t.x,i.x)&&e.y<=Math.max(t.y,i.y)&&e.y>=Math.min(t.y,i.y)}function eh(t){return t>0?1:t<0?-1:0}function ih(t,e){return Kc(t.prev,t,t.next)<0?Kc(t,e,t.next)>=0&&Kc(t,t.prev,e)>=0:Kc(t,e,t.prev)<0||Kc(t,t.next,e)<0}function rh(t,e){const i=oh(t.i,t.x,t.y),r=oh(e.i,e.x,e.y),n=t.next,s=e.prev;return t.next=e,e.prev=t,i.next=n,n.prev=i,r.next=i,i.prev=r,s.next=r,r.prev=s,r}function nh(t,e,i,r){const n=oh(t,e,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function sh(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function oh(t,e,i){return{i:t,x:e,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class ah{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class lh{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}lh.noSubdivision=new lh({fill:new ah(0,0),line:new ah(0,0),tile:new ah(0,0),stencil:new ah(0,0),circle:1}),co("SubdivisionGranularityExpression",ah),co("SubdivisionGranularitySetting",lh);const ch=-32768,hh=32767;class uh{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=Q/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const i=0|Math.round(t),r=0|Math.round(e),n=this._getKey(i,r);if(this._vertexDictionary.has(n))return this._vertexDictionary.get(n);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(n,s),this._vertexBuffer.push(i,r),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const i=[];for(let r=0;r<e.length;r+=3){const n=e[r],s=e[r+1],o=e[r+2],a=t[2*n],l=t[2*n+1];(t[2*s]-a)*(t[2*o+1]-l)-(t[2*s+1]-l)*(t[2*o]-a)>0?(i.push(n),i.push(o),i.push(s)):(i.push(n),i.push(s),i.push(o))}return i}(this._vertexBuffer,t);const e=[],i=t.length;for(let r=0;r<i;r+=3){const i=[t[r+0],t[r+1],t[r+2]],n=[this._vertexBuffer[2*t[r+0]+0],this._vertexBuffer[2*t[r+0]+1],this._vertexBuffer[2*t[r+1]+0],this._vertexBuffer[2*t[r+1]+1],this._vertexBuffer[2*t[r+2]+0],this._vertexBuffer[2*t[r+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=n[2*t],i=n[2*t+1];s=Math.min(s,e),a=Math.max(a,e),o=Math.min(o,i),l=Math.max(l,i)}if(s===a||o===l)continue;const c=Math.floor(s/this._granularityCellSize),h=Math.ceil(a/this._granularityCellSize),u=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(c!==h||u!==p)for(let t=u;t<p;t++){const r=this._scanlineGenerateVertexRingForCellRow(t,n,i);fh(this._vertexBuffer,r,e)}else e.push(...i)}return e}_scanlineGenerateVertexRingForCellRow(t,e,i){const r=t*this._granularityCellSize,n=r+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const o=e[2*t],a=e[2*t+1],l=e[2*(t+1)%6],c=e[(2*(t+1)+1)%6],h=e[2*(t+2)%6],u=e[(2*(t+2)+1)%6],p=l-o,d=c-a,f=0===p,m=0===d,_=(r-a)/d,g=(n-a)/d,y=Math.min(_,g),x=Math.max(_,g);if(!m&&(y>=1||x<=0)||m&&(a<r||a>n)){c>=r&&c<=n&&s.push(i[(t+1)%3]);continue}!m&&y>0&&s.push(this._vertexToIndex(o+p*y,a+d*y));const v=o+p*Math.max(y,0),b=o+p*Math.min(x,1);f||this._generateIntraEdgeVertices(s,o,a,l,c,v,b),!m&&x<1&&s.push(this._vertexToIndex(o+p*x,a+d*x)),(m||c>=r&&c<=n)&&s.push(i[(t+1)%3]),!m&&(c<=r||c>=n)&&this._generateInterEdgeVertices(s,o,a,l,c,h,u,b,r,n)}return s}_generateIntraEdgeVertices(t,e,i,r,n,s,o){const a=r-e,l=n-i,c=0===l,h=c?Math.min(e,r):Math.min(s,o),u=c?Math.max(e,r):Math.max(s,o),p=Math.floor(h/this._granularityCellSize)+1,d=Math.ceil(u/this._granularityCellSize)-1;if(c?e<r:s<o)for(let r=p;r<=d;r++){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/a))}else for(let r=d;r>=p;r--){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/a))}}_generateInterEdgeVertices(t,e,i,r,n,s,o,a,l,c){const h=n-i,u=s-r,p=o-n,d=(l-n)/p,f=(c-n)/p,m=Math.min(d,f),_=Math.max(d,f),g=r+u*m;let y=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,x=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,v=a<g;const b=0===p;if(b&&(o===l||o===c))return;if(b||m>=1||_<=0){const t=i-o,r=s+(e-s)*Math.min((l-o)/t,(c-o)/t);y=Math.floor(Math.min(r,a)/this._granularityCellSize)+1,x=Math.ceil(Math.max(r,a)/this._granularityCellSize)-1,v=a<r}const w=h>0?c:l;if(v)for(let e=y;e<=x;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,w));else for(let e=x;e>=y;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,w))}_generateOutline(t){const e=[];for(const i of t){const t=dh(i,this._granularity,!0),r=this._pointArrayToIndices(t),n=[];for(let t=1;t<r.length;t++)n.push(r[t-1]),n.push(r[t]);e.push(n)}return e}_handlePoles(t){let e=!1,i=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(i=!0)),(e||i)&&this._fillPoles(t,e,i)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const i=t[e+1];i===ch&&(t[e+1]=-32767),i===hh&&(t[e+1]=32766)}}_generatePoleQuad(t,e,i,r,n,s){r>n!=(s===ch)?(t.push(e),t.push(i),t.push(this._vertexToIndex(r,s)),t.push(i),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(r,s))):(t.push(i),t.push(e),t.push(this._vertexToIndex(r,s)),t.push(this._vertexToIndex(n,s)),t.push(i),t.push(this._vertexToIndex(r,s)))}_fillPoles(t,e,i){const r=this._vertexBuffer,n=Q,s=t.length;for(let o=2;o<s;o+=3){const s=t[o-2],a=t[o-1],l=t[o],c=r[2*s],h=r[2*s+1],u=r[2*a],p=r[2*a+1],d=r[2*l],f=r[2*l+1];e&&(0===h&&0===p&&this._generatePoleQuad(t,s,a,c,u,ch),0===p&&0===f&&this._generatePoleQuad(t,a,l,u,d,ch),0===f&&0===h&&this._generatePoleQuad(t,l,s,d,c,ch)),i&&(h===n&&p===n&&this._generatePoleQuad(t,s,a,c,u,hh),p===n&&f===n&&this._generatePoleQuad(t,a,l,u,d,hh),f===n&&h===n&&this._generatePoleQuad(t,l,s,d,c,hh))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:i,holeIndices:r}=function(t){const e=[],i=[];for(const r of t)if(0!==r.length){r!==t[0]&&e.push(i.length/2);for(let t=0;t<r.length;t++)i.push(r[t].x),i.push(r[t].y)}return{flattened:i,holeIndices:e}}(t);let n;this._initializeVertices(i);try{const t=function(t,e,i=2){const r=e&&e.length,n=r?e[0]*i:t.length;let s=Bc(t,0,n,i,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,c;if(r&&(s=function(t,e,i,r){const n=[];for(let i=0,s=e.length;i<s;i++){const o=Bc(t,e[i]*r,i<s-1?e[i+1]*r:t.length,r,!1);o===o.next&&(o.steiner=!0),n.push(Wc(o))}n.sort(Zc);for(let t=0;t<n.length;t++)i=Gc(n[t],i);return i}(t,e,s,i)),t.length>80*i){a=t[0],l=t[1];let e=a,r=l;for(let s=i;s<n;s+=i){const i=t[s],n=t[s+1];i<a&&(a=i),n<l&&(l=n),i>e&&(e=i),n>r&&(r=n)}c=Math.max(e-a,r-l),c=0!==c?32767/c:0}return Oc(s,o,i,a,l,c,0),o}(i,r),e=this._convertIndices(i,t);n=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(n),{verticesFlattened:this._vertexBuffer,indicesTriangles:n,indicesLineList:s}}_convertIndices(t,e){const i=[];for(let r=0;r<e.length;r++)i.push(this._vertexToIndex(t[2*e[r]],t[2*e[r]+1]));return i}_pointArrayToIndices(t){const e=[];for(let i=0;i<t.length;i++){const r=t[i];e.push(this._vertexToIndex(r.x,r.y))}return e}}function ph(t,e,i,r=!0){return new uh(i,e).subdividePolygonInternal(t,r)}function dh(t,e,i=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const r=t[0],n=t[t.length-1],o=i&&(r.x!==n.x||r.y!==n.y);if(e<2)return o?[...t,t[0]]:[...t];const a=Math.floor(Q/e),l=[];l.push(new s(t[0].x,t[0].y));const c=t.length,h=o?c:c-1;for(let e=0;e<h;e++){const i=t[e],r=e<c-1?t[e+1]:t[0],n=i.x,o=i.y,h=r.x,u=r.y,p=n!==h,d=o!==u;if(!p&&!d)continue;const f=h-n,m=u-o,_=Math.abs(f),g=Math.abs(m);let y=n,x=o;for(;;){const t=f>0?(Math.floor(y/a)+1)*a:(Math.ceil(y/a)-1)*a,e=m>0?(Math.floor(x/a)+1)*a:(Math.ceil(x/a)-1)*a,i=Math.abs(y-t),r=Math.abs(x-e),n=Math.abs(y-h),o=Math.abs(x-u),c=p?i/_:Number.POSITIVE_INFINITY,v=d?r/g:Number.POSITIVE_INFINITY;if((n<=i||!p)&&(o<=r||!d))break;if(c<v&&p||!d){y=t,x+=m*c;const e=new s(y,Math.round(x));l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e)}else{y+=f*v,x=e;const t=new s(Math.round(y),x);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t)}}const v=new s(h,u);l[l.length-1].x===v.x&&l[l.length-1].y===v.y||l.push(v)}return l}function fh(t,e,i){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let r=0,n=t[2*e[0]];for(let i=1;i<e.length;i++){const s=t[2*e[i]];s<n&&(n=s,r=i)}const s=e.length;let o=r,a=(o+1)%s;for(;;){const r=o-1>=0?o-1:s-1,n=(a+1)%s,l=t[2*e[r]],c=t[2*e[n]],h=t[2*e[o]],u=t[2*e[o]+1],p=t[2*e[a]+1];let d=!1;if(l<c)d=!0;else if(l>c)d=!1;else{const i=p-u,s=-(t[2*e[a]]-h),o=u<p?1:-1;((l-h)*i+(t[2*e[r]+1]-u)*s)*o>((c-h)*i+(t[2*e[n]+1]-u)*s)*o&&(d=!0)}if(d){const t=e[r],n=e[o],l=e[a];t!==n&&t!==l&&n!==l&&i.push(l,n,t),o--,o<0&&(o=s-1)}else{const t=e[n],r=e[o],l=e[a];t!==r&&t!==l&&r!==l&&i.push(l,r,t),a++,a>=s&&(a=0)}if(r===n)break}}function mh(t,e,i,r,n,s,o,a,l){const c=n.length/2,h=o&&a&&l;if(c<tl.MAX_VERTEX_ARRAY_LENGTH){const u=e.prepareSegment(c,i,r),p=u.vertexLength;for(let t=0;t<s.length;t+=3)r.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let d,f;u.vertexLength+=c,u.primitiveLength+=s.length/3,h&&(f=o.prepareSegment(c,i,a),d=f.vertexLength,f.vertexLength+=c);for(let e=0;e<n.length;e+=2)t(n[e],n[e+1]);if(h)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)a.emplaceBack(d+e[t-1],d+e[t]);f.primitiveLength+=e.length/2}}else!function(t,e,i,r,n,s){const o=[];for(let t=0;t<r.length/2;t++)o.push(-1);const a={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=2;u<n.length;u+=3){const p=n[u-2],d=n[u-1],f=n[u];let m=o[p]<l,_=o[d]<l,g=o[f]<l;c.vertexLength+((m?1:0)+(_?1:0)+(g?1:0))>tl.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=a.count,m=!0,_=!0,g=!0,h=0);const y=_h(o,r,s,a,p,m,c),x=_h(o,r,s,a,d,_,c),v=_h(o,r,s,a,f,g,c);i.emplaceBack(h+y-l,h+x-l,h+v-l),c.primitiveLength++}}(e,i,r,n,s,t),h&&function(t,e,i,r,n,s){const o=[];for(let t=0;t<r.length/2;t++)o.push(-1);const a={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=0;u<n.length;u++){const p=n[u];for(let d=1;d<n[u].length;d+=2){const n=p[d-1],u=p[d];let f=o[n]<l,m=o[u]<l;c.vertexLength+((f?1:0)+(m?1:0))>tl.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=a.count,f=!0,m=!0,h=0);const _=_h(o,r,s,a,n,f,c),g=_h(o,r,s,a,u,m,c);i.emplaceBack(h+_-l,h+g-l),c.primitiveLength++}}}(o,i,a,n,l,t),e.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare()}function _h(t,e,i,r,n,s,o){if(s){const s=r.count;return i(e[2*n],e[2*n+1]),t[n]=r.count,r.count++,o.vertexLength++,s}return t[n]}class gh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Fa,this.indexArray=new Xa,this.indexArray2=new Ya,this.programConfigurations=new Dl(t.layers,t.zoom),this.segments=new tl,this.segments2=new tl,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=Rc("fill",this.layers,e);const r=this.layers[0].layout.get("fill-sort-key"),n=!r.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:c}of t){const t=this.layers[0]._featureFilter.needGeometry,h=jl(o,t);if(!this.layers[0]._featureFilter.filter(new Eo(this.zoom),h,i))continue;const u=n?r.evaluate(h,{},i,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:c,index:l,geometry:t?h.geometry:Ol(o),patterns:{},sortKey:u};s.push(p)}n&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:o}=r;if(this.hasPattern){const t=Lc("fill",this.layers,r,{zoom:this.zoom},e);this.patternFeatures.push(t)}else this.addFeature(r,n,s,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Dc),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,i,r,n,s){for(const t of sn(e,500)){const e=ph(t,r,s.fill.getGranularityForZoomLevel(r.z)),i=this.layoutVertexArray;mh(((t,e)=>{i.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:n,canonical:r})}}let yh,xh;co("FillBucket",gh,{omit:["layers","patternFeatures"]});var vh={get paint(){return xh=xh||new Go({"fill-antialias":new jo(we.paint_fill["fill-antialias"]),"fill-opacity":new Vo(we.paint_fill["fill-opacity"]),"fill-color":new Vo(we.paint_fill["fill-color"]),"fill-outline-color":new Vo(we.paint_fill["fill-outline-color"]),"fill-translate":new jo(we.paint_fill["fill-translate"]),"fill-translate-anchor":new jo(we.paint_fill["fill-translate-anchor"]),"fill-pattern":new No(we.paint_fill["fill-pattern"])})},get layout(){return yh=yh||new Go({"fill-sort-key":new Vo(we.layout_fill["fill-sort-key"])})}};class bh extends qo{constructor(t,e){super(t,vh,e)}recalculate(t,e){super.recalculate(t,e);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new gh(t)}queryRadius(){return ec(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:i,pixelsToTileUnits:r}){return $l(ic(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-i.bearingInRadians,r),e)}isTileClipped(){return!0}}const wh=Yo([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Th=Yo([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Ph}=wh;class Sh{constructor(t,e,i,r,n){this.properties={},this.extent=i,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=r,this._values=n,t.readFields(Mh,this,e)}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos,i=[];let r,n=1,o=0,a=0,l=0;for(;t.pos<e;){if(o<=0){const e=t.readVarint();n=7&e,o=e>>3}if(o--,1===n||2===n)a+=t.readSVarint(),l+=t.readSVarint(),1===n&&(r&&i.push(r),r=[]),r&&r.push(new s(a,l));else{if(7!==n)throw new Error(`unknown command ${n}`);r&&r.push(r[0].clone())}}return r&&i.push(r),i}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let i=1,r=0,n=0,s=0,o=1/0,a=-1/0,l=1/0,c=-1/0;for(;t.pos<e;){if(r<=0){const e=t.readVarint();i=7&e,r=e>>3}if(r--,1===i||2===i)n+=t.readSVarint(),s+=t.readSVarint(),n<o&&(o=n),n>a&&(a=n),s<l&&(l=s),s>c&&(c=s);else if(7!==i)throw new Error(`unknown command ${i}`)}return[o,l,a,c]}toGeoJSON(t,e,i){const r=this.extent*Math.pow(2,i),n=this.extent*t,s=this.extent*e,o=this.loadGeometry();function a(t){return[360*(t.x+n)/r-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+s)/r)*Math.PI))-90]}function l(t){return t.map(a)}let c;if(1===this.type){const t=[];for(const e of o)t.push(e[0]);const e=l(t);c=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e}}else if(2===this.type){const t=o.map(l);c=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t}}else{if(3!==this.type)throw new Error("unknown feature type");{const t=function(t){const e=t.length;if(e<=1)return[t];const i=[];let r,n;for(let s=0;s<e;s++){const e=Ih(t[s]);0!==e&&(void 0===n&&(n=e<0),n===e<0?(r&&i.push(r),r=[t[s]]):r&&r.push(t[s]))}return r&&i.push(r),i}(o),e=[];for(const i of t)e.push(i.map(l));c=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e}}}const h={type:"Feature",geometry:c,properties:this.properties};return null!=this.id&&(h.id=this.id),h}}function Mh(t,e,i){1===t?e.id=i.readVarint():2===t?function(t,e){const i=t.readVarint()+t.pos;for(;t.pos<i;){const i=e._keys[t.readVarint()],r=e._values[t.readVarint()];e.properties[i]=r}}(i,e):3===t?e.type=i.readVarint():4===t&&(e._geometry=i.pos)}function Ih(t){let e=0;for(let i,r,n=0,s=t.length,o=s-1;n<s;o=n++)i=t[n],r=t[o],e+=(r.x-i.x)*(i.y+r.y);return e}Sh.types=["Unknown","Point","LineString","Polygon"];class Ch{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Eh,this,e),this.length=this._features.length}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new Sh(this._pbf,e,this.extent,this._keys,this._values)}}function Eh(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){let e=null;const i=t.readVarint()+t.pos;for(;t.pos<i;){const i=t.readVarint()>>3;e=1===i?t.readString():2===i?t.readFloat():3===i?t.readDouble():4===i?t.readVarint64():5===i?t.readVarint():6===i?t.readSVarint():7===i?t.readBoolean():null}if(null==e)throw new Error("unknown feature value");return e}(i))}class Ah{constructor(t,e){this.layers=t.readFields(zh,{},e)}}function zh(t,e,i){if(3===t){const t=new Ch(i,i.readVarint()+i.pos);t.length&&(e[t.name]=t)}}const kh=Math.pow(2,13);function Dh(t,e,i,r,n,s,o,a){t.emplaceBack(e,i,2*Math.floor(r*kh)+o,n*kh*2,s*kh*2,Math.round(a))}class Rh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Oa,this.centroidVertexArray=new Da,this.indexArray=new Xa,this.programConfigurations=new Dl(t.layers,t.zoom),this.segments=new tl,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.features=[],this.hasPattern=Rc("fill-extrusion",this.layers,e);for(const{feature:r,id:n,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,a=jl(r,t);if(!this.layers[0]._featureFilter.filter(new Eo(this.zoom),a,i))continue;const l={id:n,sourceLayerIndex:o,index:s,geometry:t?a.geometry:Ol(r),properties:r.properties,type:r.type,patterns:{}};this.hasPattern?this.features.push(Lc("fill-extrusion",this.layers,l,{zoom:this.zoom},e)):this.addFeature(l,l.geometry,s,i,{},e.subdivisionGranularity),e.featureIndex.insert(r,l.geometry,s,o,this.index,!0)}}addFeatures(t,e,i){for(const r of this.features){const{geometry:n}=r;this.addFeature(r,n,r.index,e,i,t.subdivisionGranularity)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ph),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Th.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,i,r,n,s){for(const i of sn(e,500)){const e={x:0,y:0,sampleCount:0},n=this.layoutVertexArray.length;this.processPolygon(e,r,t,i,s);const o=this.layoutVertexArray.length-n,a=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<o;t++)this.centroidVertexArray.emplaceBack(a,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:n,canonical:r})}processPolygon(t,e,i,r,n){if(r.length<1)return;if(Fh(r[0]))return;for(const e of r)0!==e.length&&Lh(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=n.fill.getGranularityForZoomLevel(e.z),a="Polygon"===Sh.types[i.type];for(const t of r){if(0===t.length)continue;if(Fh(t))continue;const e=dh(t,o,a);this._generateSideFaces(e,s)}if(!a)return;const l=ph(r,e,o,!1),c=this.layoutVertexArray;mh(((t,e)=>{Dh(c,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(t,e){let i=0;for(let r=1;r<t.length;r++){const n=t[r],s=t[r-1];if(Bh(n,s))continue;e.segment.vertexLength+4>tl.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=n.sub(s)._perp()._unit(),a=s.dist(n);i+a>32768&&(i=0),Dh(this.layoutVertexArray,n.x,n.y,o.x,o.y,0,0,i),Dh(this.layoutVertexArray,n.x,n.y,o.x,o.y,0,1,i),i+=a,Dh(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,i),Dh(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,i);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function Lh(t,e){for(let i=0;i<e.length;i++){const r=e[i];i===e.length-1&&e[0].x===r.x&&e[0].y===r.y||(t.x+=r.x,t.y+=r.y,t.sampleCount++)}}function Bh(t,e){return t.x===e.x&&(t.x<0||t.x>Q)||t.y===e.y&&(t.y<0||t.y>Q)}function Fh(t){return t.every((t=>t.x<0))||t.every((t=>t.x>Q))||t.every((t=>t.y<0))||t.every((t=>t.y>Q))}let Oh;co("FillExtrusionBucket",Rh,{omit:["layers","features"]});var jh={get paint(){return Oh=Oh||new Go({"fill-extrusion-opacity":new jo(we["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Vo(we["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new jo(we["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new jo(we["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new No(we["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Vo(we["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Vo(we["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new jo(we["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Vh extends qo{constructor(t,e){super(t,jh,e)}createBucket(t){return new Rh(t)}queryRadius(){return ec(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:o,pixelPosMatrix:a}){const l=ic(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-n.bearingInRadians,o),c=this.paint.get("fill-extrusion-height").evaluate(e,i),h=this.paint.get("fill-extrusion-base").evaluate(e,i),u=function(t,e){const i=[];for(const r of t){const t=[r.x,r.y,0,1];G(t,t,e),i.push(new s(t[0]/t[3],t[1]/t[3]))}return i}(l,a),p=function(t,e,i,r){const n=[],o=[],a=r[8]*e,l=r[9]*e,c=r[10]*e,h=r[11]*e,u=r[8]*i,p=r[9]*i,d=r[10]*i,f=r[11]*i;for(const e of t){const t=[],i=[];for(const n of e){const e=n.x,o=n.y,m=r[0]*e+r[4]*o+r[12],_=r[1]*e+r[5]*o+r[13],g=r[2]*e+r[6]*o+r[14],y=r[3]*e+r[7]*o+r[15],x=g+c,v=y+h,b=m+u,w=_+p,T=g+d,P=y+f,S=new s((m+a)/v,(_+l)/v);S.z=x/v,t.push(S);const M=new s(b/P,w/P);M.z=T/P,i.push(M)}n.push(t),o.push(i)}return[n,o]}(r,h,c,a);return function(t,e,i){let r=1/0;$l(i,e)&&(r=Uh(i,e[0]));for(let n=0;n<e.length;n++){const s=e[n],o=t[n];for(let t=0;t<s.length-1;t++){const e=s[t],n=[e,s[t+1],o[t+1],o[t],e];Zl(i,n)&&(r=Math.min(r,Uh(i,n)))}}return r!==1/0&&r}(p[0],p[1],u)}}function Nh(t,e){return t.x*e.x+t.y*e.y}function Uh(t,e){if(1===t.length){let i=0;const r=e[i++];let n;for(;!n||r.equals(n);)if(n=e[i++],!n)return 1/0;for(;i<e.length;i++){const s=e[i],o=t[0],a=n.sub(r),l=s.sub(r),c=o.sub(r),h=Nh(a,a),u=Nh(a,l),p=Nh(l,l),d=Nh(c,a),f=Nh(c,l),m=h*p-u*u,_=(p*d-u*f)/m,g=(h*f-u*d)/m,y=r.z*(1-_-g)+n.z*_+s.z*g;if(isFinite(y))return y}return 1/0}{let t=1/0;for(const i of e)t=Math.min(t,i.z);return t}}const Zh=Yo([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:Gh}=Zh,$h=Yo([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:qh}=$h,Wh=Math.cos(Math.PI/180*37.5),Hh=Math.pow(2,14)/.5;class Xh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new ja,this.layoutVertexArray2=new Va,this.indexArray=new Xa,this.programConfigurations=new Dl(t.layers,t.zoom),this.segments=new tl,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=Rc("line",this.layers,e);const r=this.layers[0].layout.get("line-sort-key"),n=!r.isConstant(),s=[];for(const{feature:e,id:o,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=jl(e,t);if(!this.layers[0]._featureFilter.filter(new Eo(this.zoom),c,i))continue;const h=n?r.evaluate(c,{},i):void 0,u={id:o,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?c.geometry:Ol(e),patterns:{},sortKey:h};s.push(u)}n&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:o}=r;if(this.hasPattern){const t=Lc("line",this.layers,r,{zoom:this.zoom},e);this.patternFeatures.push(t)}else this.addFeature(r,n,s,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,qh)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Gh),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,i,r,n,s){const o=this.layers[0].layout,a=o.get("line-join").evaluate(t,{}),l=o.get("line-cap"),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const i of e)this.addLine(i,t,a,l,c,h,r,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:n,canonical:r})}addLine(t,e,i,r,n,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=dh(t,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===Sh.types[e.type];let c=t.length;for(;c>=2&&t[c-1].equals(t[c-2]);)c--;let h=0;for(;h<c-1&&t[h].equals(t[h+1]);)h++;if(c<(l?3:2))return;"bevel"===i&&(n=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*c,this.layoutVertexArray,this.indexArray);let d,f,m,_,g;this.e1=this.e2=-1,l&&(d=t[c-2],g=t[h].sub(d)._unit()._perp());for(let e=h;e<c;e++){if(m=e===c-1?l?t[h+1]:void 0:t[e+1],m&&t[e].equals(m))continue;g&&(_=g),d&&(f=d),d=t[e],g=m?m.sub(d)._unit()._perp():_,_=_||g;let o=_.add(g);0===o.x&&0===o.y||o._unit();const a=_.x*g.x+_.y*g.y,y=o.x*g.x+o.y*g.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<Wh&&f&&m,w=_.x*g.y-_.y*g.x>0;if(b&&e>h){const t=d.dist(f);if(t>2*u){const e=d.sub(d.sub(f)._mult(u/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,_,0,0,p),f=e}}const T=f&&m;let P=T?i:l?"butt":r;if(T&&"round"===P&&(x<s?P="miter":x<=2&&(P="fakeround")),"miter"===P&&x>n&&(P="bevel"),"bevel"===P&&(x>2&&(P="flipbevel"),x<n&&(P="miter")),f&&this.updateDistance(f,d),"miter"===P)o._mult(x),this.addCurrentVertex(d,o,0,0,p);else if("flipbevel"===P){if(x>100)o=g.mult(-1);else{const t=x*_.add(g).mag()/_.sub(g).mag();o._perp()._mult(t*(w?-1:1))}this.addCurrentVertex(d,o,0,0,p),this.addCurrentVertex(d,o.mult(-1),0,0,p)}else if("bevel"===P||"fakeround"===P){const t=-Math.sqrt(x*x-1),e=w?t:0,i=w?0:t;if(f&&this.addCurrentVertex(d,_,e,i,p),"fakeround"===P){const t=Math.round(180*v/Math.PI/20);for(let e=1;e<t;e++){let i=e/t;if(.5!==i){const t=i-.5;i+=i*t*(i-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*t*t+(.848013+a*(.215638*a-1.06021)))}const r=g.sub(_)._mult(i)._add(_)._unit()._mult(w?-1:1);this.addHalfVertex(d,r.x,r.y,!1,w,0,p)}}m&&this.addCurrentVertex(d,g,-e,-i,p)}else if("butt"===P)this.addCurrentVertex(d,o,0,0,p);else if("square"===P){const t=f?1:-1;this.addCurrentVertex(d,o,t,t,p)}else"round"===P&&(f&&(this.addCurrentVertex(d,_,0,0,p),this.addCurrentVertex(d,_,1,1,p,!0)),m&&(this.addCurrentVertex(d,g,-1,-1,p,!0),this.addCurrentVertex(d,g,0,0,p)));if(b&&e<c-1){const t=d.dist(m);if(t>2*u){const e=d.add(m.sub(d)._mult(u/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,g,0,0,p),d=e}}}}addCurrentVertex(t,e,i,r,n,s=!1){const o=e.y*r-e.x,a=-e.y-e.x*r;this.addHalfVertex(t,e.x+e.y*i,e.y-e.x*i,s,!1,i,n),this.addHalfVertex(t,o,a,s,!0,-r,n),this.distance>Hh/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,i,r,n,s))}addHalfVertex({x:t,y:e},i,r,n,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(Hh-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(n?1:0),(e<<1)+(s?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,c,this.e2),a.primitiveLength++),s?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let Yh,Kh;co("LineBucket",Xh,{omit:["layers","patternFeatures"]});var Jh={get paint(){return Kh=Kh||new Go({"line-opacity":new Vo(we.paint_line["line-opacity"]),"line-color":new Vo(we.paint_line["line-color"]),"line-translate":new jo(we.paint_line["line-translate"]),"line-translate-anchor":new jo(we.paint_line["line-translate-anchor"]),"line-width":new Vo(we.paint_line["line-width"]),"line-gap-width":new Vo(we.paint_line["line-gap-width"]),"line-offset":new Vo(we.paint_line["line-offset"]),"line-blur":new Vo(we.paint_line["line-blur"]),"line-dasharray":new Uo(we.paint_line["line-dasharray"]),"line-pattern":new No(we.paint_line["line-pattern"]),"line-gradient":new Zo(we.paint_line["line-gradient"])})},get layout(){return Yh=Yh||new Go({"line-cap":new jo(we.layout_line["line-cap"]),"line-join":new Vo(we.layout_line["line-join"]),"line-miter-limit":new jo(we.layout_line["line-miter-limit"]),"line-round-limit":new jo(we.layout_line["line-round-limit"]),"line-sort-key":new Vo(we.layout_line["line-sort-key"])})}};class Qh extends Vo{possiblyEvaluate(t,e){return e=new Eo(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,i,r){return e=wt({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,i,r)}}let tu;class eu extends qo{constructor(t,e){super(t,Jh,e),this.gradientVersion=0,tu||(tu=new Qh(Jh.paint.properties["line-width"].specification),tu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof ur,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=tu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new Xh(t)}queryRadius(t){const e=t,i=iu(tc("line-width",this,e),tc("line-gap-width",this,e)),r=tc("line-offset",this,e);return i/2+Math.abs(r)+ec(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:o}){const a=ic(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-n.bearingInRadians,o),l=o/2*iu(this.paint.get("line-width").evaluate(e,i),this.paint.get("line-gap-width").evaluate(e,i)),c=this.paint.get("line-offset").evaluate(e,i);return c&&(r=function(t,e){const i=[];for(let r=0;r<t.length;r++){const n=t[r],o=[];for(let t=0;t<n.length;t++){const i=n[t-1],r=n[t],a=n[t+1],l=0===t?new s(0,0):r.sub(i)._unit()._perp(),c=t===n.length-1?new s(0,0):a.sub(r)._unit()._perp(),h=l._add(c)._unit(),u=h.x*c.x+h.y*c.y;0!==u&&h._mult(1/u),o.push(h._mult(e)._add(r))}i.push(o)}return i}(r,c*o)),function(t,e,i){for(let r=0;r<e.length;r++){const n=e[r];if(t.length>=3)for(let e=0;e<n.length;e++)if(Jl(t,n[e]))return!0;if(ql(t,n,i))return!0}return!1}(a,r,l)}isTileClipped(){return!0}}function iu(t,e){return e>0?e+2*t:t}const ru=Yo([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),nu=Yo([{name:"a_projected_pos",components:3,type:"Float32"}],4);Yo([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const su=Yo([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);Yo([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const ou=Yo([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),au=Yo([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function lu(t,e,i){return t.sections.forEach((t=>{t.text=function(t,e,i){const r=e.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?t=t.toLocaleUpperCase():"lowercase"===r&&(t=t.toLocaleLowerCase()),Co.applyArabicShaping&&(t=Co.applyArabicShaping(t)),t}(t.text,e,i)})),t}Yo([{name:"triangle",components:3,type:"Uint16"}]),Yo([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),Yo([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),Yo([{type:"Float32",name:"offsetX"}]),Yo([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),Yo([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const cu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"},hu=4294967296,uu=1/hu,pu="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class du{constructor(t=new Uint8Array(16)){this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length}readFields(t,e,i=this.length){for(;this.pos<i;){const i=this.readVarint(),r=i>>3,n=this.pos;this.type=7&i,t(r,e,this),this.pos===n&&this.skip(i)}return e}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos)}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*hu;return this.pos+=8,t}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*hu;return this.pos+=8,t}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t}readVarint(t){const e=this.buf;let i,r;return r=e[this.pos++],i=127&r,r<128?i:(r=e[this.pos++],i|=(127&r)<<7,r<128?i:(r=e[this.pos++],i|=(127&r)<<14,r<128?i:(r=e[this.pos++],i|=(127&r)<<21,r<128?i:(r=e[this.pos],i|=(15&r)<<28,function(t,e,i){const r=i.buf;let n,s;if(s=r[i.pos++],n=(112&s)>>4,s<128)return fu(t,n,e);if(s=r[i.pos++],n|=(127&s)<<3,s<128)return fu(t,n,e);if(s=r[i.pos++],n|=(127&s)<<10,s<128)return fu(t,n,e);if(s=r[i.pos++],n|=(127&s)<<17,s<128)return fu(t,n,e);if(s=r[i.pos++],n|=(127&s)<<24,s<128)return fu(t,n,e);if(s=r[i.pos++],n|=(1&s)<<31,s<128)return fu(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(i,t,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2}readBoolean(){return Boolean(this.readVarint())}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&pu?pu.decode(this.buf.subarray(e,t)):function(t,e,i){let r="",n=e;for(;n<i;){const e=t[n];let s,o,a,l=null,c=e>239?4:e>223?3:e>191?2:1;if(n+c>i)break;1===c?e<128&&(l=e):2===c?(s=t[n+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===c?(s=t[n+1],o=t[n+2],128==(192&s)&&128==(192&o)&&(l=(15&e)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===c&&(s=t[n+1],o=t[n+2],a=t[n+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&e)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,c=1):l>65535&&(l-=65536,r+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),r+=String.fromCharCode(l),n+=c}return r}(this.buf,e,t)}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e}readPackedVarint(t=[],e){const i=this.readPackedEnd();for(;this.pos<i;)t.push(this.readVarint(e));return t}readPackedSVarint(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t}readPackedBoolean(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t}readPackedFloat(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t}readPackedDouble(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t}readPackedFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t}readPackedSFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t}readPackedFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t}readPackedSFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else{if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8}}writeTag(t,e){this.writeVarint(t<<3|e)}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*uu),!0),this.pos+=8}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*uu),!0),this.pos+=8}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let i,r;if(t>=0?(i=t%4294967296|0,r=t/4294967296|0):(i=~(-t%4294967296),r=~(-t/4294967296),4294967295^i?i=i+1|0:(i=0,r=r+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,i.buf[i.pos]=127&(t>>>=7)}(i,0,e),function(t,e){const i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(r,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t)}writeBoolean(t){this.writeVarint(+t)}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,i){for(let r,n,s=0;s<e.length;s++){if(r=e.charCodeAt(s),r>55295&&r<57344){if(!n){r>56319||s+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):n=r;continue}if(r<56320){t[i++]=239,t[i++]=191,t[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(t[i++]=239,t[i++]=191,t[i++]=189,n=null);r<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(r<65536?t[i++]=r>>12|224:(t[i++]=r>>18|240,t[i++]=r>>12&63|128),t[i++]=r>>6&63|128),t[i++]=63&r|128)}return i}(this.buf,t,this.pos);const i=this.pos-e;i>=128&&mu(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let i=0;i<e;i++)this.buf[this.pos++]=t[i]}writeRawMessage(t,e){this.pos++;const i=this.pos;t(e,this);const r=this.pos-i;r>=128&&mu(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r}writeMessage(t,e,i){this.writeTag(t,2),this.writeRawMessage(e,i)}writePackedVarint(t,e){e.length&&this.writeMessage(t,_u,e)}writePackedSVarint(t,e){e.length&&this.writeMessage(t,gu,e)}writePackedBoolean(t,e){e.length&&this.writeMessage(t,vu,e)}writePackedFloat(t,e){e.length&&this.writeMessage(t,yu,e)}writePackedDouble(t,e){e.length&&this.writeMessage(t,xu,e)}writePackedFixed32(t,e){e.length&&this.writeMessage(t,bu,e)}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,wu,e)}writePackedFixed64(t,e){e.length&&this.writeMessage(t,Tu,e)}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,Pu,e)}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e)}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e)}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e)}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e)}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e)}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e)}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e)}writeStringField(t,e){this.writeTag(t,2),this.writeString(e)}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e)}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e)}writeBooleanField(t,e){this.writeVarintField(t,+e)}}function fu(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function mu(t,e,i){const r=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));i.realloc(r);for(let e=i.pos-1;e>=t;e--)i.buf[e+r]=i.buf[e]}function _u(t,e){for(let i=0;i<t.length;i++)e.writeVarint(t[i])}function gu(t,e){for(let i=0;i<t.length;i++)e.writeSVarint(t[i])}function yu(t,e){for(let i=0;i<t.length;i++)e.writeFloat(t[i])}function xu(t,e){for(let i=0;i<t.length;i++)e.writeDouble(t[i])}function vu(t,e){for(let i=0;i<t.length;i++)e.writeBoolean(t[i])}function bu(t,e){for(let i=0;i<t.length;i++)e.writeFixed32(t[i])}function wu(t,e){for(let i=0;i<t.length;i++)e.writeSFixed32(t[i])}function Tu(t,e){for(let i=0;i<t.length;i++)e.writeFixed64(t[i])}function Pu(t,e){for(let i=0;i<t.length;i++)e.writeSFixed64(t[i])}function Su(t,e,i){1===t&&i.readMessage(Mu,e)}function Mu(t,e,i){if(3===t){const{id:t,bitmap:r,width:n,height:s,left:o,top:a,advance:l}=i.readMessage(Iu,{});e.push({id:t,bitmap:new xc({width:n+6,height:s+6},r),metrics:{width:n,height:s,left:o,top:a,advance:l}})}}function Iu(t,e,i){1===t?e.id=i.readVarint():2===t?e.bitmap=i.readBytes():3===t?e.width=i.readVarint():4===t?e.height=i.readVarint():5===t?e.left=i.readSVarint():6===t?e.top=i.readSVarint():7===t&&(e.advance=i.readVarint())}function Cu(t){let e=0,i=0;for(const r of t)e+=r.w*r.h,i=Math.max(i,r.w);t.sort(((t,e)=>e.h-t.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),i),h:1/0}];let n=0,s=0;for(const e of t)for(let t=r.length-1;t>=0;t--){const i=r[t];if(!(e.w>i.w||e.h>i.h)){if(e.x=i.x,e.y=i.y,s=Math.max(s,e.y+e.h),n=Math.max(n,e.x+e.w),e.w===i.w&&e.h===i.h){const e=r.pop();e&&t<r.length&&(r[t]=e)}else e.h===i.h?(i.x+=e.w,i.w-=e.w):e.w===i.w?(i.y+=e.h,i.h-=e.h):(r.push({x:i.x+e.w,y:i.y,w:i.w-e.w,h:e.h}),i.y+=e.h,i.h-=e.h);break}}return{w:n,h:s,fill:e/(n*s)||0}}class Eu{constructor(t,{pixelRatio:e,version:i,stretchX:r,stretchY:n,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=r,this.stretchY=n,this.content=s,this.version=i,this.textFitWidth=o,this.textFitHeight=a}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}var Au;function zu(t){let e=.5,i=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:e,verticalAlign:i}}function ku(t,e){const{expression:i}=e;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new Eo(t+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:r}=i;let n=0;for(;n<e.length&&e[n]<=t;)n++;n=Math.max(0,n-1);let s=n;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const o=e[n],a=e[s];return"composite"===i.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:r}:{kind:"camera",minZoom:o,maxZoom:a,minSize:i.evaluate(new Eo(o)),maxSize:i.evaluate(new Eo(a)),interpolationType:r}}}function Du(t,{uSize:e,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===t.kind?r/128:"composite"===t.kind?xr.number(r/128,n/128,i):e}function Ru(t,e){let i=0,r=0;if("constant"===t.kind)r=t.layoutSize;else if("source"!==t.kind){const{interpolationType:n,minZoom:s,maxZoom:o}=t,a=n?vt(gr.interpolationFactor(n,e,s,o),0,1):0;"camera"===t.kind?r=xr.number(t.minSize,t.maxSize,a):i=a}return{uSizeT:i,uSize:r}}function Lu(t,e,i){let r="never";const n=t.get(e);return n?r=n:t.get(i)&&(r="always"),r}co("ImagePosition",Eu),co("ImageAtlas",class{constructor(t,e){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(t,i,n),this.addImages(e,r,n);const{w:s,h:o}=Cu(n),a=new vc({width:s||1,height:o||1});for(const e in t){const r=t[e],n=i[e].paddedRect;vc.copy(r.data,a,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const t in e){const i=e[t],n=r[t].paddedRect,s=n.x+1,o=n.y+1,l=i.data.width,c=i.data.height;vc.copy(i.data,a,{x:0,y:0},{x:s,y:o},i.data),vc.copy(i.data,a,{x:0,y:c-1},{x:s,y:o-1},{width:l,height:1}),vc.copy(i.data,a,{x:0,y:0},{x:s,y:o+c},{width:l,height:1}),vc.copy(i.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:c}),vc.copy(i.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:c})}this.image=a,this.iconPositions=i,this.patternPositions=r}addImages(t,e,i){for(const r in t){const n=t[r],s={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(s),e[r]=new Eu(s,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in t.updatedImages)this.patchUpdatedImage(this.iconPositions[i],t.getImage(i),e),this.patchUpdatedImage(this.patternPositions[i],t.getImage(i),e)}patchUpdatedImage(t,e,i){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[r,n]=t.tl;i.update(e.data,void 0,{x:r,y:n})}}),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(Au||(Au={}));const Bu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Fu(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=a?Math.min(32640,Math.round(a[0])):0,f=a?Math.min(32640,Math.round(a[1])):0;t.emplaceBack(e,i,Math.round(32*r),Math.round(32*n),s,o,(d<<1)+(l?1:0),f,16*c,16*h,256*u,256*p)}function Ou(t,e,i){t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i)}function ju(t){for(const e of t.sections)if(Io(e.text))return!0;return!1}class Vu{constructor(t){this.layoutVertexArray=new Ua,this.indexArray=new Xa,this.programConfigurations=t,this.segments=new tl,this.dynamicLayoutVertexArray=new Za,this.opacityVertexArray=new Ga,this.hasVisibleVertices=!1,this.placedSymbolArray=new Pa}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ru.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,nu.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Bu,!0),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}co("SymbolBuffers",Vu);class Nu{constructor(t,e,i){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new i,this.segments=new tl,this.collisionVertexArray=new Wa}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,su.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}co("CollisionBuffers",Nu);class Uu{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=ku(this.zoom,e["text-size"]),this.iconSizeData=ku(this.zoom,e["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap="never"!==Lu(i,"text-overlap","text-allow-overlap")||"never"!==Lu(i,"icon-overlap","icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&!r.isConstant(),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===i.get("symbol-placement")&&(this.writingModes=i.get("text-writing-mode").map((t=>Au[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new Vu(new Dl(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new Vu(new Dl(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Ia,this.lineVertexArray=new Ca,this.symbolInstances=new Ma,this.textAnchorOffsets=new Aa}calculateGlyphDependencies(t,e,i,r,n){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(i||r)&&n){const i=cu[t.charAt(s)];i&&(e[i.charCodeAt(0)]=!0)}}populate(t,e,i){const r=this.layers[0],n=r.layout,s=n.get("text-font"),o=n.get("text-field"),a=n.get("icon-image"),l=("constant"!==o.value.kind||o.value.value instanceof Li&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),c="constant"!==a.value.kind||!!a.value.value||Object.keys(a.parameters).length>0,h=n.get("symbol-sort-key");if(this.features=[],!l&&!c)return;const u=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new Eo(this.zoom);for(const{feature:e,id:o,index:a,sourceLayerIndex:m}of t){const t=r._featureFilter.needGeometry,_=jl(e,t);if(!r._featureFilter.filter(f,_,i))continue;let g,y;if(t||(_.geometry=Ol(e)),l){const t=r.getValueAndResolveTokens("text-field",_,i,d),e=Li.factory(t),n=this.hasRTLText=this.hasRTLText||ju(e);(!n||"unavailable"===Co.getRTLTextPluginStatus()||n&&Co.isParsed())&&(g=lu(e,r,_))}if(c){const t=r.getValueAndResolveTokens("icon-image",_,i,d);y=t instanceof Ui?t:Ui.fromString(t)}if(!g&&!y)continue;const x=this.sortFeaturesByKey?h.evaluate(_,{},i):void 0;if(this.features.push({id:o,text:g,icon:y,index:a,sourceLayerIndex:m,geometry:_.geometry,properties:e.properties,type:Sh.types[e.type],sortKey:x}),y&&(u[y.name]=!0),g){const t=s.evaluate(_,{},i).join(","),e="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Au.vertical)>=0;for(const i of g.sections)if(i.image)u[i.image.name]=!0;else{const r=vo(g.toString()),n=i.fontStack||t,s=p[n]=p[n]||{};this.calculateGlyphDependencies(i.text,s,e,this.allowVerticalPlacement,r)}}}"line"===n.get("symbol-placement")&&(this.features=function(t){const e={},i={},r=[];let n=0;function s(e){r.push(t[e]),n++}function o(t,e,n){const s=i[t];return delete i[t],i[e]=s,r[s].geometry[0].pop(),r[s].geometry[0]=r[s].geometry[0].concat(n[0]),s}function a(t,i,n){const s=e[i];return delete e[i],e[t]=s,r[s].geometry[0].shift(),r[s].geometry[0]=n[0].concat(r[s].geometry[0]),s}function l(t,e,i){const r=i?e[0][e[0].length-1]:e[0][0];return`${t}:${r.x}:${r.y}`}for(let c=0;c<t.length;c++){const h=t[c],u=h.geometry,p=h.text?h.text.toString():null;if(!p){s(c);continue}const d=l(p,u),f=l(p,u,!0);if(d in i&&f in e&&i[d]!==e[f]){const t=a(d,f,u),n=o(d,f,r[t].geometry);delete e[d],delete i[f],i[l(p,r[n].geometry,!0)]=n,r[t].geometry=null}else d in i?o(d,f,u):f in e?a(d,f,u):(s(c),e[d]=n-1,i[f]=n-1)}return r.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,i){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:i}),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:i}))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const i=this.lineVertexArray.length;if(void 0!==t.segment){let i=t.dist(e[t.segment+1]),r=t.dist(e[t.segment]);const n={};for(let r=t.segment+1;r<e.length;r++)n[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r<e.length-1&&(i+=e[r+1].dist(e[r]));for(let i=t.segment||0;i>=0;i--)n[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i>0&&(r+=e[i-1].dist(e[i]));for(let t=0;t<e.length;t++){const e=n[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(t,e,i,r,n,s,o,a,l,c,h,u){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?s.sortKey:void 0),m=this.glyphOffsetArray.length,_=f.vertexLength,g=this.allowVerticalPlacement&&o===Au.vertical?Math.PI/2:0,y=s.text&&s.text.sections;for(let r=0;r<e.length;r++){const{tl:n,tr:o,bl:l,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:_,minFontScaleX:x,minFontScaleY:v,glyphOffset:b,isSDF:w,sectionIndex:T}=e[r],P=f.vertexLength,S=b[1];Fu(d,a.x,a.y,n.x,S+n.y,h.x,h.y,i,w,m.x,m.y,x,v),Fu(d,a.x,a.y,o.x,S+o.y,h.x+h.w,h.y,i,w,_.x,m.y,x,v),Fu(d,a.x,a.y,l.x,S+l.y,h.x,h.y+h.h,i,w,m.x,_.y,x,v),Fu(d,a.x,a.y,c.x,S+c.y,h.x+h.w,h.y+h.h,i,w,_.x,_.y,x,v),Ou(t.dynamicLayoutVertexArray,a,g),p.emplaceBack(P,P+2,P+1),p.emplaceBack(P+1,P+2,P+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(b[0]),r!==e.length-1&&T===e[r+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,s,s.index,{imagePositions:{},canonical:u,formattedSection:y&&y[T]})}t.placedSymbolArray.emplaceBack(a.x,a.y,m,this.glyphOffsetArray.length-m,_,l,c,a.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],o,0,!1,0,h)}_addCollisionDebugVertex(t,e,i,r,n,s){return e.emplaceBack(0,0),t.emplaceBack(i.x,i.y,r,n,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,i,r,n,o,a){const l=n.segments.prepareSegment(4,n.layoutVertexArray,n.indexArray),c=l.vertexLength,h=n.layoutVertexArray,u=n.collisionVertexArray,p=a.anchorX,d=a.anchorY;this._addCollisionDebugVertex(h,u,o,p,d,new s(t,e)),this._addCollisionDebugVertex(h,u,o,p,d,new s(i,e)),this._addCollisionDebugVertex(h,u,o,p,d,new s(i,r)),this._addCollisionDebugVertex(h,u,o,p,d,new s(t,r)),l.vertexLength+=4;const f=n.indexArray;f.emplaceBack(c,c+1),f.emplaceBack(c+1,c+2),f.emplaceBack(c+2,c+3),f.emplaceBack(c+3,c),l.primitiveLength+=4}addDebugCollisionBoxes(t,e,i,r){for(let n=t;n<e;n++){const t=this.collisionBoxArray.get(n);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,r?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,i)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Nu($a,ou.members,Ya),this.iconCollisionBox=new Nu($a,ou.members,Ya);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,i,r,n,s,o,a,l){const c={};for(let r=e;r<i;r++){const e=t.get(r);c.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},c.textFeatureIndex=e.featureIndex;break}for(let e=r;e<n;e++){const i=t.get(e);c.verticalTextBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalTextFeatureIndex=i.featureIndex;break}for(let e=s;e<o;e++){const i=t.get(e);c.iconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.iconFeatureIndex=i.featureIndex;break}for(let e=a;e<l;e++){const i=t.get(e);c.verticalIconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalIconFeatureIndex=i.featureIndex;break}return c}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const i=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const i=t.placedSymbolArray.get(e),r=i.vertexStartIndex+4*i.numGlyphs;for(let e=i.vertexStartIndex;e<r;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),i=Math.cos(t),r=[],n=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);r.push(0|Math.round(e*o.anchorX+i*o.anchorY)),n.push(o.featureIndex)}return s.sort(((t,e)=>r[t]-r[e]||n[e]-n[t])),s}addToSortKeyRanges(t,e){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===e?i.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,i)=>{t>=0&&i.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let Zu,Gu;co("SymbolBucket",Uu,{omit:["layers","collisionBoxArray","features","compareText"]}),Uu.MAX_GLYPHS=65535,Uu.addDynamicAttributes=Ou;var $u={get paint(){return Gu=Gu||new Go({"icon-opacity":new Vo(we.paint_symbol["icon-opacity"]),"icon-color":new Vo(we.paint_symbol["icon-color"]),"icon-halo-color":new Vo(we.paint_symbol["icon-halo-color"]),"icon-halo-width":new Vo(we.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Vo(we.paint_symbol["icon-halo-blur"]),"icon-translate":new jo(we.paint_symbol["icon-translate"]),"icon-translate-anchor":new jo(we.paint_symbol["icon-translate-anchor"]),"text-opacity":new Vo(we.paint_symbol["text-opacity"]),"text-color":new Vo(we.paint_symbol["text-color"],{runtimeType:Ze,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Vo(we.paint_symbol["text-halo-color"]),"text-halo-width":new Vo(we.paint_symbol["text-halo-width"]),"text-halo-blur":new Vo(we.paint_symbol["text-halo-blur"]),"text-translate":new jo(we.paint_symbol["text-translate"]),"text-translate-anchor":new jo(we.paint_symbol["text-translate-anchor"])})},get layout(){return Zu=Zu||new Go({"symbol-placement":new jo(we.layout_symbol["symbol-placement"]),"symbol-spacing":new jo(we.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new jo(we.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Vo(we.layout_symbol["symbol-sort-key"]),"symbol-z-order":new jo(we.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new jo(we.layout_symbol["icon-allow-overlap"]),"icon-overlap":new jo(we.layout_symbol["icon-overlap"]),"icon-ignore-placement":new jo(we.layout_symbol["icon-ignore-placement"]),"icon-optional":new jo(we.layout_symbol["icon-optional"]),"icon-rotation-alignment":new jo(we.layout_symbol["icon-rotation-alignment"]),"icon-size":new Vo(we.layout_symbol["icon-size"]),"icon-text-fit":new jo(we.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new jo(we.layout_symbol["icon-text-fit-padding"]),"icon-image":new Vo(we.layout_symbol["icon-image"]),"icon-rotate":new Vo(we.layout_symbol["icon-rotate"]),"icon-padding":new Vo(we.layout_symbol["icon-padding"]),"icon-keep-upright":new jo(we.layout_symbol["icon-keep-upright"]),"icon-offset":new Vo(we.layout_symbol["icon-offset"]),"icon-anchor":new Vo(we.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new jo(we.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new jo(we.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new jo(we.layout_symbol["text-rotation-alignment"]),"text-field":new Vo(we.layout_symbol["text-field"]),"text-font":new Vo(we.layout_symbol["text-font"]),"text-size":new Vo(we.layout_symbol["text-size"]),"text-max-width":new Vo(we.layout_symbol["text-max-width"]),"text-line-height":new jo(we.layout_symbol["text-line-height"]),"text-letter-spacing":new Vo(we.layout_symbol["text-letter-spacing"]),"text-justify":new Vo(we.layout_symbol["text-justify"]),"text-radial-offset":new Vo(we.layout_symbol["text-radial-offset"]),"text-variable-anchor":new jo(we.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Vo(we.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Vo(we.layout_symbol["text-anchor"]),"text-max-angle":new jo(we.layout_symbol["text-max-angle"]),"text-writing-mode":new jo(we.layout_symbol["text-writing-mode"]),"text-rotate":new Vo(we.layout_symbol["text-rotate"]),"text-padding":new jo(we.layout_symbol["text-padding"]),"text-keep-upright":new jo(we.layout_symbol["text-keep-upright"]),"text-transform":new Vo(we.layout_symbol["text-transform"]),"text-offset":new Vo(we.layout_symbol["text-offset"]),"text-allow-overlap":new jo(we.layout_symbol["text-allow-overlap"]),"text-overlap":new jo(we.layout_symbol["text-overlap"]),"text-ignore-placement":new jo(we.layout_symbol["text-ignore-placement"]),"text-optional":new jo(we.layout_symbol["text-optional"])})}};class qu{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:je,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}co("FormatSectionOverride",qu,{omit:["defaultValue"]});class Wu extends qo{constructor(t,e){super(t,$u,e)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const i of t)e.indexOf(i)<0&&e.push(i);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,i,r){const n=this.layout.get(t).evaluate(e,{},i,r),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||os(s.value)||!n?n:function(t,e){return e.replace(/{([^{}]+)}/g,((e,i)=>t&&i in t?String(t[i]):""))}(e.properties,n)}createBucket(t){return new Uu(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of $u.paint.overridableProperties){if(!Wu.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),i=new qu(e),r=new ss(i,e.property.specification);let n=null;n="constant"===e.value.kind||"source"===e.value.kind?new ls("source",r):new cs("composite",r,e.value.zoomStops),this.paint._values[t]=new Fo(e.property,n,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,i){return!(!this.layout||e.isDataDriven()||i.isDataDriven())&&Wu.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const i=t.get("text-field"),r=$u.paint.properties[e];let n=!1;const s=t=>{for(const e of t)if(r.overrides&&r.overrides.hasOverride(e))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Li)s(i.value.value.sections);else if("source"===i.value.kind||"composite"===i.value.kind){const t=e=>{n||(e instanceof Hi&&qi(e.value)===He?s(e.value.sections):e instanceof kr?s(e.sections):e.eachChild(t))},e=i.value;e._styleExpression&&t(e._styleExpression.expression)}return n}}let Hu;var Xu={get paint(){return Hu=Hu||new Go({"background-color":new jo(we.paint_background["background-color"]),"background-pattern":new Uo(we.paint_background["background-pattern"]),"background-opacity":new jo(we.paint_background["background-opacity"])})}};class Yu extends qo{constructor(t,e){super(t,Xu,e)}}let Ku;var Ju={get paint(){return Ku=Ku||new Go({"raster-opacity":new jo(we.paint_raster["raster-opacity"]),"raster-hue-rotate":new jo(we.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new jo(we.paint_raster["raster-brightness-min"]),"raster-brightness-max":new jo(we.paint_raster["raster-brightness-max"]),"raster-saturation":new jo(we.paint_raster["raster-saturation"]),"raster-contrast":new jo(we.paint_raster["raster-contrast"]),"raster-resampling":new jo(we.paint_raster["raster-resampling"]),"raster-fade-duration":new jo(we.paint_raster["raster-fade-duration"])})}};class Qu extends qo{constructor(t,e){super(t,Ju,e)}}class tp extends qo{constructor(t,e){super(t,{},e),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function ep(t,e){if("custom"===t.type)return new tp(t,e);switch(t.type){case"background":return new Yu(t,e);case"circle":return new pc(t,e);case"color-relief":return new zc(t,e);case"fill":return new bh(t,e);case"fill-extrusion":return new Vh(t,e);case"heatmap":return new Tc(t,e);case"hillshade":return new Mc(t,e);case"line":return new eu(t,e);case"raster":return new Qu(t,e);case"symbol":return new Wu(t,e)}}function ip(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:r,url:n}of t){const t=`${r}${n}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:r,url:n}))}}return e}function rp(t,e,i){try{const r=new URL(t);return r.pathname+=`${e}${i}`,r.toString()}catch(e){throw new Error(`Invalid sprite URL "${t}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function np(t){const{userImage:e}=t;return!!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class sp extends be{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new vc({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[]}}getImage(t){const e=this.images[t];if(e&&!e.data&&e.spriteData){const t=e.spriteData;e.data=new vc({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),e.spriteData=null}return e}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e)}_validate(t,e){let i=!0;const r=e.data||e.spriteData;return this._validateStretch(e.stretchX,r&&r.width)||(this.fire(new ve(new Error(`Image "${t}" has invalid "stretchX" value`))),i=!1),this._validateStretch(e.stretchY,r&&r.height)||(this.fire(new ve(new Error(`Image "${t}" has invalid "stretchY" value`))),i=!1),this._validateContent(e.content,e)||(this.fire(new ve(new Error(`Image "${t}" has invalid "content" value`))),i=!1),i}_validateStretch(t,e){if(!t)return!0;let i=0;for(const r of t){if(r[0]<i||r[1]<r[0]||e<r[1])return!1;i=r[1]}return!0}_validateContent(t,e){if(!t)return!0;if(4!==t.length)return!1;const i=e.spriteData,r=i&&i.width||e.data.width,n=i&&i.height||e.data.height;return!(t[0]<0||r<t[0]||t[1]<0||n<t[1]||t[2]<0||r<t[2]||t[3]<0||n<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const r=this.getImage(t);if(i&&(r.data.width!==e.data.width||r.data.height!==e.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=r.version+1,this.images[t]=e,this.updatedImages[t]=!0}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let r=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(r=!1);this.isLoaded()||r?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e})}))}_getImagesForIds(t){const e={};for(const i of t){let t=this.getImage(i);t||(this.fire(new xe("styleimagemissing",{id:i})),t=this.getImage(i)),t?e[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,textFitWidth:t.textFitWidth,textFitHeight:t.textFitHeight,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:Dt(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}return e}getPixelSize(){const{width:t,height:e}=this.atlasImage;return{width:t,height:e}}getPattern(t){const e=this.patterns[t],i=this.getImage(t);if(!i)return null;if(e&&e.position.version===i.version)return e.position;if(e)e.position.version=i.version;else{const e={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new Eu(e,i);this.patterns[t]={bin:e,position:r}}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Ec(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE)}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:e,h:i}=Cu(t),r=this.atlasImage;r.resize({width:e||1,height:i||1});for(const t in this.patterns){const{bin:e}=this.patterns[t],i=e.x+1,n=e.y+1,s=this.getImage(t).data,o=s.width,a=s.height;vc.copy(s,r,{x:0,y:0},{x:i,y:n},{width:o,height:a}),vc.copy(s,r,{x:0,y:a-1},{x:i,y:n-1},{width:o,height:1}),vc.copy(s,r,{x:0,y:0},{x:i,y:n+a},{width:o,height:1}),vc.copy(s,r,{x:o-1,y:0},{x:i-1,y:n},{width:1,height:a}),vc.copy(s,r,{x:0,y:0},{x:i+o,y:n},{width:1,height:a})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.getImage(e);t||Dt(`Image with ID: "${e}" was not found`),np(t)&&this.updateImage(e,t)}}}const op=1e20;function ap(t,e,i,r,n,s,o,a,l){for(let c=e;c<e+r;c++)lp(t,i*s+c,s,n,o,a,l);for(let c=i;c<i+n;c++)lp(t,c*s+e,1,r,o,a,l)}function lp(t,e,i,r,n,s,o){s[0]=0,o[0]=-op,o[1]=op,n[0]=t[e];for(let a=1,l=0,c=0;a<r;a++){n[a]=t[e+a*i];const r=a*a;do{const t=s[l];c=(n[a]-n[t]+r-t*t)/(a-t)/2}while(c<=o[l]&&--l>-1);l++,s[l]=a,o[l]=c,o[l+1]=op}for(let a=0,l=0;a<r;a++){for(;o[l+1]<a;)l++;const r=s[l],c=a-r;t[e+a*i]=n[r]+c*c}}class cp{constructor(t,e,i){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={},this.lang=i}setURL(t){this.url=t}getGlyphs(t){return n(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const r of t[i])e.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(e),r={};for(const{stack:t,id:e,glyph:n}of i)r[t]||(r[t]={}),r[t][e]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics};return r}))}_getAndCacheGlyphsPromise(t,e){return n(this,void 0,void 0,(function*(){let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{}});let r=i.glyphs[e];if(void 0!==r)return{stack:t,id:e,glyph:r};if(r=this._tinySDF(i,t,e),r)return i.glyphs[e]=r,{stack:t,id:e,glyph:r};const n=Math.floor(e/256);if(256*n>65535)throw new Error("glyphs > 65535 not supported");if(i.ranges[n])return{stack:t,id:e,glyph:r};if(!this.url)throw new Error("glyphsUrl is not set");if(!i.requests[n]){const e=cp.loadGlyphRange(t,n,this.url,this.requestManager);i.requests[n]=e}const s=yield i.requests[n];for(const t in s)this._doesCharSupportLocalGlyph(+t)||(i.glyphs[+t]=s[+t]);return i.ranges[n]=!0,{stack:t,id:e,glyph:s[e]||null}}))}_doesCharSupportLocalGlyph(t){return!!this.localIdeographFontFamily&&(/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(t))||(e=t)>=19968&&e<=40959||(t=>t>=44032&&t<=55215)(t)||(t=>t>=12352&&t<=12447)(t)||yo(t)||go(t)||xo(t));var e}_tinySDF(t,e,i){const r=this.localIdeographFontFamily;if(!r)return;if(!this._doesCharSupportLocalGlyph(i))return;let n=t.tinySDF;if(!n){let i="400";/bold/i.test(e)?i="900":/medium/i.test(e)?i="500":/light/i.test(e)&&(i="200"),n=t.tinySDF=new cp.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,lang:this.lang,fontFamily:r,fontWeight:i})}const s=n.draw(String.fromCharCode(i));return{id:i,bitmap:new xc({width:s.width||60,height:s.height||60},s.data),metrics:{width:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:s.glyphAdvance/2||24,isDoubleResolution:!0}}}}cp.loadGlyphRange=function(t,e,i,r){return n(this,void 0,void 0,(function*(){const n=256*e,s=n+255,o=r.transformRequest(i.replace("{fontstack}",t).replace("{range}",`${n}-${s}`),"Glyphs"),a=yield(l=o,c=new AbortController,oe(wt(l,{type:"arrayBuffer"}),c));var l,c;if(!a||!a.data)throw new Error(`Could not load glyph range. range: ${e}, ${n}-${s}`);const h={};for(const t of new du(a.data).readFields(Su,[]))h[t.id]=t;return h}))},cp.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:s="normal",fontStyle:o="normal",lang:a=null}={}){this.buffer=e,this.cutoff=r,this.radius=i,this.lang=a;const l=this.size=t+4*e,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${o} ${s} ${t}px ${n}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l)}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:s}=this.ctx.measureText(t),o=Math.ceil(i),a=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-n))),l=Math.min(this.size-this.buffer,o+Math.ceil(r)),c=a+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),p=new Uint8ClampedArray(u),d={data:p,width:c,height:h,glyphWidth:a,glyphHeight:l,glyphTop:o,glyphLeft:0,glyphAdvance:e};if(0===a||0===l)return d;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;this.lang&&(f.lang=this.lang),f.clearRect(m,m,a,l),f.fillText(t,m,m+o);const y=f.getImageData(m,m,a,l);g.fill(op,0,u),_.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<a;e++){const i=y.data[4*(t*a+e)+3]/255;if(0===i)continue;const r=(t+m)*c+e+m;if(1===i)g[r]=0,_[r]=op;else{const t=.5-i;g[r]=t>0?t*t:0,_[r]=t<0?t*t:0}}ap(g,0,0,c,h,c,this.f,this.v,this.z),ap(_,m,m,a,l,c,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(_[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff))}return d}};class hp{constructor(){this.specification=we.light.position}possiblyEvaluate(t,e){return function([t,e,i]){return e+=90,e*=Math.PI/180,i*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(i),y:t*Math.sin(e)*Math.sin(i),z:t*Math.cos(i)}}(t.expression.evaluate(e))}interpolate(t,e,i){return{x:xr.number(t.x,e.x,i),y:xr.number(t.y,e.y,i),z:xr.number(t.z,e.z,i)}}}let up;class pp extends be{constructor(t){super(),up=up||new Go({anchor:new jo(we.light.anchor),position:new hp,color:new jo(we.light.color),intensity:new jo(we.light.intensity)}),this._transitionable=new Do(up,void 0),this.setLight(t),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(t,e={}){if(!this._validate(io,t,e))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i){return(!i||!1!==i.validate)&&oo(this,t.call(eo,{value:e,style:{glyphs:!0,sprite:!0},styleSpec:we}))}}const dp=new Go({"sky-color":new jo(we.sky["sky-color"]),"horizon-color":new jo(we.sky["horizon-color"]),"fog-color":new jo(we.sky["fog-color"]),"fog-ground-blend":new jo(we.sky["fog-ground-blend"]),"horizon-fog-blend":new jo(we.sky["horizon-fog-blend"]),"sky-horizon-blend":new jo(we.sky["sky-horizon-blend"]),"atmosphere-blend":new jo(we.sky["atmosphere-blend"])});class fp extends be{constructor(t){super(),this._transitionable=new Do(dp,void 0),this.setSky(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new Eo(0))}setSky(t,e={}){if(!this._validate(ro,t,e)){t||(t={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}}getSky(){return this._transitionable.serialize()}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i={}){return!1!==(null==i?void 0:i.validate)&&oo(this,t.call(eo,wt({value:e,style:{glyphs:!0,sprite:!0},styleSpec:we})))}calculateFogBlendOpacity(t){return t<60?0:t<70?(t-60)/10:1}}class mp{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={}}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const r=[];let n=t.length%2==1?-t[t.length-1]*i:0,s=t[0]*i,o=!0;r.push({left:n,right:s,isDash:o,zeroLength:0===t[0]});let a=t[0];for(let e=1;e<t.length;e++){o=!o;const l=t[e];n=a*i,a+=l,s=a*i,r.push({left:n,right:s,isDash:o,zeroLength:0===l})}return r}addRoundDash(t,e,i){const r=e/2;for(let e=-i;e<=i;e++){const n=this.width*(this.nextRow+i+e);let s=0,o=t[s];for(let a=0;a<this.width;a++){a/o.right>1&&(o=t[++s]);const l=Math.abs(a-o.left),c=Math.abs(a-o.right),h=Math.min(l,c);let u;const p=e/i*(r+1);if(o.isDash){const t=r-Math.abs(p);u=Math.sqrt(h*h+t*t)}else u=r-Math.sqrt(h*h+p*p);this.data[n+a]=Math.max(0,Math.min(255,u+128))}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],r=t[e+1];i.zeroLength?t.splice(e,1):r&&r.isDash===i.isDash&&(r.left=i.left,t.splice(e,1))}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const r=this.width*this.nextRow;let n=0,s=t[n];for(let e=0;e<this.width;e++){e/s.right>1&&(s=t[++n]);const i=Math.abs(e-s.left),o=Math.abs(e-s.right),a=Math.min(i,o);this.data[r+e]=Math.max(0,Math.min(255,(s.isDash?a:-a)+128))}}addDash(t,e){const i=e?7:0,r=2*i+1;if(this.nextRow+r>this.height)return Dt("LineAtlas out of space"),null;let n=0;for(let e=0;e<t.length;e++)n+=t[e];if(0!==n){const r=this.width/n,s=this.getDashRanges(t,this.width,r);e?this.addRoundDash(s,r,i):this.addRegularDash(s)}const s={y:(this.nextRow+i+.5)/this.height,height:2*i/this.height,width:n};return this.nextRow+=r,this.dirty=!0,s}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data))}}class _p{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const gp={once:!0};class yp{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new _p((()=>this.process())),this.subscription=jt(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=Lt(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((i,r)=>{const n=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?jt(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[n];const e={id:n,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),gp):null;this.resolveRejects[n]={resolve:t=>{null==s||s.unsubscribe(),i(t)},reject:t=>{null==s||s.unsubscribe(),r(t)}};const o=[],a=Object.assign(Object.assign({},t),{id:n,sourceMapId:this.mapId,origin:location.origin,data:fo(t.data,o)});this.target.postMessage(a,{transfer:o})}))}receive(t){const e=t.data,i=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[i];const t=this.abortControllers[i];return delete this.abortControllers[i],void(t&&t.abort())}if(Lt(self)||e.mustQueue)return this.tasks[i]=e,this.taskQueue.push(i),void this.invoker.trigger();this.processTask(i,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(t,e){return n(this,void 0,void 0,(function*(){if("<response>"===e.type){const i=this.resolveRejects[t];if(delete this.resolveRejects[t],!i)return;return void(e.error?i.reject(mo(e.error)):i.resolve(mo(e.data)))}if(!this.messageHandlers[e.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${e.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const i=mo(e.data),r=new AbortController;this.abortControllers[t]=r;try{const n=yield this.messageHandlers[e.type](e.sourceMapId,i,r);this.completeTask(t,null,n)}catch(e){this.completeTask(t,e)}}))}completeTask(t,e,i){const r=[];delete this.abortControllers[t];const n={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?fo(e):null,data:fo(i,r)};this.target.postMessage(n,{transfer:r})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}const xp="maplibre_preloaded_worker_pool";class vp{constructor(){this.active={}}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<vp.workerCount;)this.workers.push(new Worker(ee.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[xp]}numActive(){return Object.keys(this.active).length}}const bp=Math.floor(Qt.hardwareConcurrency/2);let wp,Tp;function Pp(){return wp||(wp=new vp),wp}vp.workerCount=function(t){if(null==Bt){const e=t.navigator?t.navigator.userAgent:null;Bt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")))}return Bt}(globalThis)?Math.max(Math.min(bp,3),1):1;class Sp{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e;const i=this.workerPool.acquire(e);for(let t=0;t<i.length;t++){const r=new yp(i[t],e);r.name=`Worker ${t}`,this.actors.push(r)}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove()})),this.actors=[],t&&this.workerPool.release(this.id)}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e)}}function Mp(){return Tp||(Tp=new Sp(Pp(),re),Tp.registerMessageHandler("GR",((t,e,i)=>oe(e,i)))),Tp}function Ip(t,e){const i=_();return b(i,i,[1,1,0]),w(i,i,[.5*t.width,.5*t.height,1]),t.calculatePosMatrix?v(i,i,t.calculatePosMatrix(e.toUnwrapped())):i}function Cp(t,e,i,r,n,s,o){var a;const l=function(t,e,i){if(t)for(const r of t){const t=e[r];if(t&&t.source===i&&"fill-extrusion"===t.type)return!0}else for(const t in e){const r=e[t];if(r.source===i&&"fill-extrusion"===r.type)return!0}return!1}(null!==(a=null==n?void 0:n.layers)&&void 0!==a?a:null,e,t.id),c=s.maxPitchScaleFactor(),h=t.tilesIn(r,c,l);h.sort(Ep);const u=[];for(const r of h)u.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(e,i,t._state,r.queryGeometry,r.cameraQueryGeometry,r.scale,n,s,c,Ip(t.transform,r.tileID),o?(t,e)=>o(r.tileID,t,e):void 0)});return function(t,e){for(const i in t)for(const r of t[i])Ap(r,e);return t}(function(t){const e={},i={};for(const r of t){const t=r.queryResults,n=r.wrappedTileID,s=i[n]=i[n]||{};for(const i in t){const r=t[i],n=s[i]=s[i]||{},o=e[i]=e[i]||[];for(const t of r)n[t.featureIndex]||(n[t.featureIndex]=!0,o.push(t))}}return e}(u),t)}function Ep(t,e){const i=t.tileID,r=e.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function Ap(t,e){const i=t.feature,r=e.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r}function zp(t,e,i){return n(this,void 0,void 0,(function*(){let r=t;if(t.url?r=(yield ae(e.transformRequest(t.url,"Source"),i)).data:yield Qt.frameAsync(i),!r)return null;const n=Tt(wt(r,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in r&&r.vector_layers&&(n.vectorLayerIds=r.vector_layers.map((t=>t.id))),n}))}const kp=6371008.8;class Dp{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Dp(bt(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,i=this.lat*e,r=t.lat*e,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((t.lng-this.lng)*e);return kp*Math.acos(Math.min(n,1))}static convert(t){if(t instanceof Dp)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Dp(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Dp(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class Rp{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])))}setNorthEast(t){return this._ne=t instanceof Dp?new Dp(t.lng,t.lat):Dp.convert(t),this}setSouthWest(t){return this._sw=t instanceof Dp?new Dp(t.lng,t.lat):Dp.convert(t),this}extend(t){const e=this._sw,i=this._ne;let r,n;if(t instanceof Dp)r=t,n=t;else{if(!(t instanceof Rp))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(Rp.convert(t)):this.extend(Dp.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend(Dp.convert(t)):this;if(r=t._sw,n=t._ne,!r||!n)return this}return e||i?(e.lng=Math.min(r.lng,e.lng),e.lat=Math.min(r.lat,e.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new Dp(r.lng,r.lat),this._ne=new Dp(n.lng,n.lat)),this}getCenter(){return new Dp((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Dp(this.getWest(),this.getNorth())}getSouthEast(){return new Dp(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(t){const{lng:e,lat:i}=Dp.convert(t);let r=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}static convert(t){return t instanceof Rp?t:t?new Rp(t):t}static fromLngLat(t,e=0){const i=360*e/40075017,r=i/Math.cos(Math.PI/180*t.lat);return new Rp(new Dp(t.lng-r,t.lat-i),new Dp(t.lng+r,t.lat+i))}adjustAntiMeridian(){const t=new Dp(this._sw.lng,this._sw.lat),e=new Dp(this._ne.lng,this._ne.lat);return new Rp(t,t.lng>e.lng?new Dp(e.lng+360,e.lat):e)}}const Lp=2*Math.PI*kp;function Bp(t){return Lp*Math.cos(t*Math.PI/180)}function Fp(t){return(180+t)/360}function Op(t){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function jp(t,e){return t/Bp(e)}function Vp(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Np(t,e){return t*Bp(Vp(e))}class Up{constructor(t,e,i=0){this.x=+t,this.y=+e,this.z=+i}static fromLngLat(t,e=0){const i=Dp.convert(t);return new Up(Fp(i.lng),Op(i.lat),jp(e,i.lat))}toLngLat(){return new Dp(360*this.x-180,Vp(this.y))}toAltitude(){return Np(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Lp*(t=Vp(this.y),1/Math.cos(t*Math.PI/180));var t}}class Zp{constructor(t,e,i){this.bounds=Rp.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const e=Math.pow(2,t.z),i=Math.floor(Fp(this.bounds.getWest())*e),r=Math.floor(Op(this.bounds.getNorth())*e),n=Math.ceil(Fp(this.bounds.getEast())*e),s=Math.ceil(Op(this.bounds.getSouth())*e);return t.x>=i&&t.x<n&&t.y>=r&&t.y<s}}class Gp extends be{constructor(t,e,i,r){if(super(),this.id=t,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,wt(this,Tt(e,["url","scheme","tileSize","promoteId"])),this._options=wt({type:"vector"},e),this._collectResourceTiming=e.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r)}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new xe("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield zp(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),t&&(wt(this,t),t.bounds&&(this.tileBounds=new Zp(t.bounds,this.minzoom,this.maxzoom)),this.fire(new xe("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new xe("data",{dataType:"source",sourceDataType:"content"})))}catch(t){this._tileJSONRequest=null,this._loaded=!0,this.fire(new ve(t))}}))}loaded(){return this._loaded}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load()}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load()}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}serialize(){return wt({},this._options)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,"Tile"),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i}}))}else t.actor=this.dispatcher.getActor(),r="LT";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:r,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e)}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null)}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject)}}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"AT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}hasTransition(){return!1}}class $p extends be{constructor(t,e,i,r){super(),this.id=t,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=wt({type:"raster"},e),wt(this,Tt(e,["url","scheme","tileSize"]))}load(){return n(this,arguments,void 0,(function*(t=!1){this._loaded=!1,this.fire(new xe("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield zp(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,e&&(wt(this,e),e.bounds&&(this.tileBounds=new Zp(e.bounds,this.minzoom,this.maxzoom)),this.fire(new xe("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new xe("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:t})))}catch(t){this._tileJSONRequest=null,this._loaded=!0,this.fire(new ve(t))}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load()}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load(!0)}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}serialize(){return wt({},this._options)}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield me.getImage(this.map._requestManager.transformRequest(e,"Tile"),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,r=e.gl,n=i.data;t.texture=this.map.painter.getTileTexture(n.width),t.texture?t.texture.update(n,{useMipmap:!0}):(t.texture=new Ec(e,n,r.RGBA,{useMipmap:!0}),t.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),t.state="loaded"}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController)}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture)}))}hasTransition(){return!1}}function qp(t,e,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[t*r-2*Math.PI*6378137/2,e*r-2*Math.PI*6378137/2]}class Wp{constructor(t,e,i){if(!function(t,e,i){return!(t<0||t>25||i<0||i>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,i))throw new Error(`x=${e}, y=${i}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=i,this.key=Yp(0,t,t,e,i)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,i){const r=(s=this.y,o=this.z,a=qp(256*(n=this.x),256*(s=Math.pow(2,o)-s-1),o),l=qp(256*(n+1),256*(s+1),o),a[0]+","+a[1]+","+l[0]+","+l[1]);var n,s,o,a,l;const c=function(t,e,i){let r,n="";for(let s=t;s>0;s--)r=1<<s-1,n+=(e&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===i?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,r)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new s((t.x*e-this.x)*Q,(t.y*e-this.y)*Q)}toString(){return`${this.z}/${this.x}/${this.y}`}}class Hp{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Yp(t,e.z,e.z,e.x,e.y)}}class Xp{constructor(t,e,i,r,n){if(this.terrainRttPosMatrix32f=null,t<i)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${i}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Wp(i,+r,+n),this.key=Yp(e,t,i,r,n)}clone(){return new Xp(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new Xp(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Xp(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const i=this.canonical.z-t;return t>this.canonical.z?Yp(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Yp(this.wrap*+e,t,t,this.canonical.x>>i,this.canonical.y>>i)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new Xp(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new Xp(e,this.wrap,e,i,r),new Xp(e,this.wrap,e,i+1,r),new Xp(e,this.wrap,e,i,r+1),new Xp(e,this.wrap,e,i+1,r+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Xp(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Xp(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Hp(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Up(t.x-this.wrap,t.y))}}function Yp(t,e,i,r,n){(t*=2)<0&&(t=-1*t-1);const s=1<<i;return(s*s*t+s*n+r).toString(36)+i.toString(36)+e.toString(36)}co("CanonicalTileID",Wp),co("OverscaledTileID",Xp,{omit:["terrainRttPosMatrix32f"]});class Kp extends $p{constructor(t,e,i,r){super(t,e,i,r),this.type="raster-dem",this.maxzoom=22,this._options=wt({type:"raster-dem"},e),this.encoding=e.encoding||"mapbox",this.redFactor=e.redFactor,this.greenFactor=e.greenFactor,this.blueFactor=e.blueFactor,this.baseShift=e.baseShift}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i=this.map._requestManager.transformRequest(e,"Tile");t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const e=yield me.getImage(i,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(e&&e.data){const i=e.data;this.map._refreshExpiredTiles&&(e.cacheControl||e.expires)&&t.setExpiryData({cacheControl:e.cacheControl,expires:e.expires});const r=Ft(i)&&u()?i:yield this.readImageNow(i),n={type:this.type,uid:t.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"LDT",data:n});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded"}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return n(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&function(){if(null==h&&(h=!1,u())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let i=0;i<t*t;i++){const r=4*i;e.fillStyle=`rgb(${r},${r+1},${r+2})`,e.fillRect(i%t,Math.floor(i/t),1,1)}const i=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&i[e]!==e){h=!0;break}}}return h||!1}()){const e=t.width+2,i=t.height+2;try{return new vc({width:e,height:i},yield function(t,e,i,r,s){return n(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const i=null==e?void 0:e.format;if(!i||!i.startsWith("BGR")&&!i.startsWith("RGB"))throw new Error(`Unrecognized format ${i}`);const n=i.startsWith("BGR"),o=new Uint8ClampedArray(r*s*4);if(yield e.copyTo(o,function(t,e,i,r,n){const s=4*Math.max(1,0),o=(Math.max(0,-1)- -1)*r*4+s,a=4*r,l=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:l,y:c,width:Math.min(t.width,-1+r)-l,height:Math.min(t.height,-1+n)-c},layout:[{offset:o,stride:a}]}}(t,0,0,r,s)),n)for(let t=0;t<o.length;t+=4){const e=o[t];o[t]=o[t+2],o[t+2]=e}return o}finally{e.close()}}))}(t,0,0,e,i))}catch(t){}}return Qt.getImageData(t,1)}))}_getNeighboringTiles(t){const e=t.canonical,i=Math.pow(2,e.z),r=(e.x-1+i)%i,n=0===e.x?t.wrap-1:t.wrap,s=(e.x+1+i)%i,o=e.x+1===i?t.wrap+1:t.wrap,a={};return a[new Xp(t.overscaledZ,n,e.z,r,e.y).key]={backfilled:!1},a[new Xp(t.overscaledZ,o,e.z,s,e.y).key]={backfilled:!1},e.y>0&&(a[new Xp(t.overscaledZ,n,e.z,r,e.y-1).key]={backfilled:!1},a[new Xp(t.overscaledZ,t.wrap,e.z,e.x,e.y-1).key]={backfilled:!1},a[new Xp(t.overscaledZ,o,e.z,s,e.y-1).key]={backfilled:!1}),e.y+1<i&&(a[new Xp(t.overscaledZ,n,e.z,r,e.y+1).key]={backfilled:!1},a[new Xp(t.overscaledZ,t.wrap,e.z,e.x,e.y+1).key]={backfilled:!1},a[new Xp(t.overscaledZ,o,e.z,s,e.y+1).key]={backfilled:!1}),a}unloadTile(t){return n(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"RDT",data:{type:this.type,uid:t.uid,source:this.id}}))}))}}class Jp extends be{constructor(t,e,i,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:e.data},this.actor=i.getActor(),this.setEventedParent(r),this._data=e.data,this._options=wt({},e),this._collectResourceTiming=e.collectResourceTiming,void 0!==e.maxzoom&&(this.maxzoom=e.maxzoom),e.type&&(this.type=e.type),e.attribution&&(this.attribution=e.attribution),this.promoteId=e.promoteId,void 0!==e.clusterMaxZoom&&this.maxzoom<=e.clusterMaxZoom&&Dt(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${e.clusterMaxZoom}".`),this.workerOptions=wt({source:this.id,cluster:e.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==e.buffer?e.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==e.tolerance?e.tolerance:.375),extent:Q,maxZoom:this.maxzoom,lineMetrics:e.lineMetrics||!1,generateId:e.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(e.clusterMaxZoom),minPoints:Math.max(2,e.clusterMinPoints||2),extent:Q,radius:this._pixelsToTileUnits(e.clusterRadius||50),log:!1,generateId:e.generateId||!1},clusterProperties:e.clusterProperties,filter:e.filter},e.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId)}_pixelsToTileUnits(t){return t*(Q/this.tileSize)}_getClusterMaxZoom(t){const e=t?Math.round(t):this.maxzoom-1;return Number.isInteger(t)||void 0===t||Dt(`Integer expected for option 'clusterMaxZoom': provided value "${t}" rounded to "${e}"`),e}load(){return n(this,void 0,void 0,(function*(){yield this._updateWorkerData()}))}onAdd(t){this.map=t,this.load()}setData(t){return this._data=t,this._pendingWorkerUpdate={data:t},this._updateWorkerData(),this}updateData(t){return this._pendingWorkerUpdate.diff=function(t,e){var i,r,n,s,o;if(!t)return null!=e?e:{};if(!e)return t;let a=Object.assign({},t);if(e.removeAll&&(a={removeAll:!0}),e.remove){const r=new Set(e.remove);a.add&&(a.add=a.add.filter((t=>!r.has(t.id)))),a.update&&(a.update=a.update.filter((t=>!r.has(t.id))));const n=new Set((null!==(i=t.add)&&void 0!==i?i:[]).map((t=>t.id)));e.remove=e.remove.filter((t=>!n.has(t)))}if(e.remove){const t=new Set(a.remove?a.remove.concat(e.remove):e.remove);a.remove=Array.from(t.values())}if(e.add){const t=a.add?a.add.concat(e.add):e.add,i=new Map(t.map((t=>[t.id,t])));a.add=Array.from(i.values())}if(e.update){const t=new Map(null===(r=a.update)||void 0===r?void 0:r.map((t=>[t.id,t])));for(const i of e.update){const e=null!==(n=t.get(i.id))&&void 0!==n?n:{id:i.id};i.newGeometry&&(e.newGeometry=i.newGeometry),i.addOrUpdateProperties&&(e.addOrUpdateProperties=(null!==(s=e.addOrUpdateProperties)&&void 0!==s?s:[]).concat(i.addOrUpdateProperties)),i.removeProperties&&(e.removeProperties=(null!==(o=e.removeProperties)&&void 0!==o?o:[]).concat(i.removeProperties)),i.removeAllProperties&&(e.removeAllProperties=!0),t.set(i.id,e)}a.update=Array.from(t.values())}return a.remove&&a.add&&(a.remove=a.remove.filter((t=>-1===a.add.findIndex((e=>e.id===t))))),a}(this._pendingWorkerUpdate.diff,t),this._updateWorkerData(),this}getData(){return n(this,void 0,void 0,(function*(){const t=wt({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:t})}))}getCoordinatesFromGeometry(t){return"GeometryCollection"===t.type?t.geometries.map((t=>t.coordinates)).flat(1/0):t.coordinates.flat(1/0)}getBounds(){return n(this,void 0,void 0,(function*(){const t=new Rp,e=yield this.getData();let i;switch(e.type){case"FeatureCollection":i=e.features.map((t=>this.getCoordinatesFromGeometry(t.geometry))).flat(1/0);break;case"Feature":i=this.getCoordinatesFromGeometry(e.geometry);break;default:i=this.getCoordinatesFromGeometry(e)}if(0==i.length)return t;for(let e=0;e<i.length-1;e+=2)t.extend([i[e],i[e+1]]);return t}))}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,t&&(void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(t.clusterRadius)),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(t.clusterMaxZoom))),this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(){return n(this,void 0,void 0,(function*(){if(this._isUpdatingWorker)return;const{data:t,diff:e}=this._pendingWorkerUpdate;if(!t&&!e)return void Dt(`No data or diff provided to GeoJSONSource ${this.id}.`);const i=wt({type:this.type},this.workerOptions);t?("string"==typeof t?(i.request=this.map._requestManager.transformRequest(Qt.resolveURL(t),"Source"),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(t),this._pendingWorkerUpdate.data=void 0):e&&(i.dataDiff=e,this._pendingWorkerUpdate.diff=void 0),this._isUpdatingWorker=!0,this.fire(new xe("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"LD",data:i});if(this._isUpdatingWorker=!1,this._removed||t.abandoned)return void this.fire(new xe("dataabort",{dataType:"source"}));this._data=t.data;let e=null;t.resourceTiming&&t.resourceTiming[this.id]&&(e=t.resourceTiming[this.id].slice(0));const r={dataType:"source"};this._collectResourceTiming&&e&&e.length>0&&wt(r,{resourceTiming:e}),this.fire(new xe("data",Object.assign(Object.assign({},r),{sourceDataType:"metadata"}))),this.fire(new xe("data",Object.assign(Object.assign({},r),{sourceDataType:"content"})))}catch(t){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new xe("dataabort",{dataType:"source"}));this.fire(new ve(t))}finally{(this._pendingWorkerUpdate.data||this._pendingWorkerUpdate.diff)&&this._updateWorkerData()}}))}loaded(){return!this._isUpdatingWorker&&void 0===this._pendingWorkerUpdate.data&&void 0===this._pendingWorkerUpdate.diff}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.actor?"RT":"LT";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};t.abortController=new AbortController;const r=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(r,this.map.painter,"RT"===e)}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}})}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}})}serialize(){return wt({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}}class Qp{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const e=new Qp;return e.extend(t(new s(this.minX,this.minY))),e.extend(t(new s(this.maxX,this.minY))),e.extend(t(new s(this.minX,this.maxY))),e.extend(t(new s(this.maxX,this.maxY))),e}static fromPoints(t){const e=new Qp;for(const i of t)e.extend(i);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return!this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return!this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class td extends be{constructor(t,e,i,r){super(),this.flippedWindingOrder=!1,this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=e}load(t){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new xe("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield me.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading())}catch(t){this._request=null,this._loaded=!0,this.fire(new ve(t))}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new xe("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(t){this.map=t,this.load()}onRemove(){this._request&&(this._request.abort(),this._request=null)}setCoordinates(t){this.coordinates=t;const e=t.map(Up.fromLngLat);var i;return this.tileID=function(t){const e=Qp.fromPoints(t),i=e.width(),r=e.height(),n=Math.max(i,r),s=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),o=Math.pow(2,s);return new Wp(s,Math.floor((e.minX+e.maxX)/2*o),Math.floor((e.minY+e.maxY)/2*o))}(e),this.terrainTileRanges=this._getOverlappingTileRanges(e),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=e.map((t=>this.tileID.getTilePoint(t)._round())),this.flippedWindingOrder=((i=this.tileCoords)[1].x-i[0].x)*(i[2].y-i[0].y)-(i[1].y-i[0].y)*(i[2].x-i[0].x)<0,this.fire(new xe("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,e=t.gl;this.texture||(this.texture=new Ec(t,this.image,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new xe("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}loadTile(t){return n(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored"}))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}_getOverlappingTileRanges(t){const{minX:e,minY:i,maxX:r,maxY:n}=Qp.fromPoints(t),s={};for(let t=0;t<=25;t++){const o=Math.pow(2,t),a=Math.floor(e*o),l=Math.floor(i*o),c=Math.floor(r*o),h=Math.floor(n*o);s[t]={minTileX:a,minTileY:l,maxTileX:c,maxTileY:h}}return s}}class ed extends td{constructor(t,e,i,r){super(t,e,i,r),this.roundZoom=!0,this.type="video",this.options=e}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,"Source").url);try{const t=yield(t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((i=>{e.onloadstart=()=>{i(e)};for(const i of t){const t=window.document.createElement("source");le(i)||(e.crossOrigin="Anonymous"),t.src=i,e.appendChild(t)}}))})(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading()}catch(t){this.fire(new ve(t))}}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(t){if(this.video){const e=this.video.seekable;t<e.start(0)||t>e.end(0)?this.fire(new ve(new Le(`sources.${this.id}`,null,`Playback for this video can be set only between the ${e.start(0)} and ${e.end(0)}-second mark.`))):this.video.currentTime=t}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,e=t.gl;this.texture?this.video.paused||(this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE),e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,this.video)):(this.texture=new Ec(t,this.video,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new xe("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class id extends td{constructor(t,e,i,r){super(t,e,i,r),e.coordinates?Array.isArray(e.coordinates)&&4===e.coordinates.length&&!e.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new ve(new Le(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new ve(new Le(`sources.${t}`,null,'missing required property "coordinates"'))),e.animate&&"boolean"!=typeof e.animate&&this.fire(new ve(new Le(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),e.canvas?"string"==typeof e.canvas||e.canvas instanceof HTMLCanvasElement||this.fire(new ve(new Le(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new ve(new Le(`sources.${t}`,null,'missing required property "canvas"'))),this.options=e,this.animate=void 0===e.animate||e.animate}load(){return n(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new ve(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const e=this.map.painter.context,i=e.gl;this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Ec(e,this.canvas,i.RGBA,{premultiply:!0});let r=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,r=!0)}r&&this.fire(new xe("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of[this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return!0;return!1}}const rd={},nd=t=>{switch(t){case"geojson":return Jp;case"image":return td;case"raster":return $p;case"raster-dem":return Kp;case"vector":return Gp;case"video":return ed;case"canvas":return id}return rd[t]};class sd{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const i=t[e];this._stringToNumber[i]=e,this._numberToString[e]=i}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class od{constructor(t,e,i,r,n){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=i,t._y=r,this.properties=t.properties,this.id=n}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}function ad(t,e,i,r,n){return Ct(t,((t,s)=>{const o=e instanceof Oo?e.get(s):null;return o&&o.evaluate?o.evaluate(i,r,n):o}))}function ld(t,e){return e-t}co("FeatureIndex",class{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ao(Q,16,0),this.grid3D=new ao(Q,16,0),this.featureIndexArray=new ka,this.promoteId=e}insert(t,e,i,r,n,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n);const a=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const i=e[t],r=[1/0,1/0,-1/0,-1/0];for(let t=0;t<i.length;t++){const e=i[t];r[0]=Math.min(r[0],e.x),r[1]=Math.min(r[1],e.y),r[2]=Math.max(r[2],e.x),r[3]=Math.max(r[3],e.y)}r[0]<Q&&r[1]<Q&&r[2]>=0&&r[3]>=0&&a.insert(o,r[0],r[1],r[2],r[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Ah(new du(this.rawTileData)).layers,this.sourceLayerCoder=new sd(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,i,r){this.loadVTLayers();const n=t.params,o=Q/t.tileSize/t.scale,a=_s(n.filter,n.globalState),l=t.queryGeometry,c=t.queryPadding*o,h=Qp.fromPoints(l),u=this.grid.query(h.minX-c,h.minY-c,h.maxX+c,h.maxY+c),p=Qp.fromPoints(t.cameraQueryGeometry).expandBy(c),d=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,((e,i,r,n)=>function(t,e,i,r,n){for(const s of t)if(e<=s.x&&i<=s.y&&r>=s.x&&n>=s.y)return!0;const o=[new s(e,i),new s(e,n),new s(r,n),new s(r,i)];if(t.length>2)for(const e of o)if(Jl(t,e))return!0;for(let e=0;e<t.length-1;e++)if(Ql(t[e],t[e+1],o))return!0;return!1}(t.cameraQueryGeometry,e-c,i-c,r+c,n+c)));for(const t of d)u.push(t);u.sort(ld);const f={};let m;for(let s=0;s<u.length;s++){const c=u[s];if(c===m)continue;m=c;const h=this.featureIndexArray.get(c);let p=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,a,n.layers,n.availableImages,e,i,r,((e,i,r)=>(p||(p=Ol(e)),i.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:r,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:o,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))))}return f}loadMatchingFeature(t,e,i,r,n,s,o,a,l,c,h){const u=this.bucketLayerIDs[e];if(s&&!u.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(i),d=this.vtLayers[p].feature(r);if(n.needGeometry){const t=jl(d,!0);if(!n.filter(new Eo(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!n.filter(new Eo(this.tileID.overscaledZ),d))return;const f=this.getId(d,p);for(let e=0;e<u.length;e++){const i=u[e];if(s&&!s.has(i))continue;const n=a[i];if(!n)continue;let p={};f&&c&&(p=c.getState(n.sourceLayer||"_geojsonTileLayer",f));const m=wt({},l[i]);m.paint=ad(m.paint,n.paint,d,p,o),m.layout=ad(m.layout,n.layout,d,p,o);const _=!h||h(d,n,p);if(!_)continue;const g=new od(d,this.z,this.x,this.y,f);g.layer=m;let y=t[i];void 0===y&&(y=t[i]=[]),y.push({featureIndex:r,feature:g,intersectionZ:_})}}lookupSymbolFeatures(t,e,i,r,n,s,o,a){const l={};this.loadVTLayers();const c=_s(n.filterSpec,n.globalState);for(const n of t)this.loadMatchingFeature(l,i,r,n,c,s,o,a,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const i of e)if(t===i)return!0;return!1}getId(t,e){var i;let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r)),void 0===r&&(null===(i=t.properties)||void 0===i?void 0:i.cluster)&&this.promoteId&&(r=Number(t.properties.cluster_id))),r}},{omit:["rawTileData","sourceLayerCoder"]});const cd="RTLPluginLoaded";class hd extends be{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Mp()}_syncState(t){return this.status=t,this.dispatcher.broadcast("SRPS",{pluginStatus:t,pluginURL:this.url}).catch((t=>{throw this.status="error",t}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null}setRTLTextPlugin(t){return n(this,arguments,void 0,(function*(t,e=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=Qt.resolveURL(t),!this.url)throw new Error(`requested url ${t} is invalid`);if("unavailable"===this.status){if(!e)return this._requestImport();this.status="deferred",this._syncState(this.status)}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return n(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new xe(cd))}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport()}}let ud=null;function pd(){return ud||(ud=new hd),ud}class dd{constructor(t,e){this.timeAdded=0,this.fadeEndTime=0,this.tileID=t,this.uid=St(),this.uses=0,this.tileSize=e,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading"}registerFadeDuration(t){const e=t+this.timeAdded;e<this.fadeEndTime||(this.fadeEndTime=e)}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null}loadVectorData(t,e,i){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const r of t){const t=r.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){r.layers=t,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=r}}return i}(t.buckets,null==e?void 0:e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Uu){if(this.hasSymbolBuckets=!0,!i)break;e.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Uu&&e.hasRTLText){this.hasRTLText=!0,pd().lazyLoad();break}}this.queryPadding=0;for(const t in this.buckets){const i=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(i))}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage)}else this.collisionBoxArray=new wa}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded"}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t)}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Ec(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Ec(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null)}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture)}queryRenderedFeatures(t,e,i,r,n,s,o,a,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:n,scale:s,tileSize:this.tileSize,pixelPosMatrix:c,transform:a,params:o,queryPadding:this.queryPadding*l,getElevation:h},t,e,i):{}}querySourceFeatures(t,e){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=e&&e.sourceLayer?e.sourceLayer:"",s=r._geojsonTileLayer||r[n];if(!s)return;const o=_s(null==e?void 0:e.filter,null==e?void 0:e.globalState),{z:a,x:l,y:c}=this.tileID.canonical,h={z:a,x:l,y:c};for(let e=0;e<s.length;e++){const r=s.feature(e);if(o.needGeometry){const t=jl(r,!0);if(!o.filter(new Eo(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!o.filter(new Eo(this.tileID.overscaledZ),r))continue;const u=i.getId(r,n),p=new od(r,a,l,c,u);p.tile=h,t.push(p)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,i,r,n)=>{const s=r||n;return e[i]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t}return e}(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"])}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let i=!1;if(this.expirationTime>t)i=!1;else if(e)if(this.expirationTime<e)i=!0;else{const r=this.expirationTime-e;r?this.expirationTime=t+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!e.style.hasLayer(r))continue;const n=this.buckets[r],s=n.layers[0].sourceLayer||"_geojsonTileLayer",o=i[s],a=t[s];if(!o||!a||0===Object.keys(a).length)continue;n.update(a,o,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)))}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<Qt.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0}setHoldDuration(t){this.symbolFadeHoldUntil=Qt.now()+t}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return!0}return!1}}class fd{constructor(t,e){this.max=t,this.onRemove=e,this.reset()}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const r=t.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:e,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(t,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,r=void 0===e?0:this.data[i].indexOf(e),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}filter(t){const e=[];for(const i in this.data)for(const r of this.data[i])t(r.value)||e.push(r);for(const t of e)this.remove(t.value.tileID,t)}}class md{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(t,e,i){const r=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][r]=this.stateChanges[t][r]||{},wt(this.stateChanges[t][r],i),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==r&&(this.deletedStates[t][e]=null)}else if(this.deletedStates[t]&&null===this.deletedStates[t][r]){this.deletedStates[t][r]={};for(const e in this.state[t][r])i[e]||(this.deletedStates[t][r][e]=null)}else for(const e in i)this.deletedStates[t]&&this.deletedStates[t][r]&&null===this.deletedStates[t][r][e]&&delete this.deletedStates[t][r][e]}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const r=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][r]&&(this.deletedStates[t][r]=this.deletedStates[t][r]||{},this.deletedStates[t][r][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][r])for(i in this.deletedStates[t][r]={},this.stateChanges[t][r])this.deletedStates[t][r][i]=null;else this.deletedStates[t][r]=null;else this.deletedStates[t]=null}getState(t,e){const i=String(e),r=wt({},(this.state[t]||{})[i],(this.stateChanges[t]||{})[i]);if(null===this.deletedStates[t])return{};if(this.deletedStates[t]){const i=this.deletedStates[t][e];if(null===i)return{};for(const t in i)delete r[t]}return r}initializeTileState(t,e){t.setFeatureState(this.state,e)}coalesceChanges(t,e){const i={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const i in this.stateChanges[t])this.state[t][i]||(this.state[t][i]={}),wt(this.state[t][i],this.stateChanges[t][i]),e[i]=this.state[t][i];i[t]=e}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const i in this.state[t])e[i]={},this.state[t][i]={};else for(const i in this.deletedStates[t]){if(null===this.deletedStates[t][i])this.state[t][i]={};else for(const e of Object.keys(this.deletedStates[t][i]))delete this.state[t][i][e];e[i]=this.state[t][i]}i[t]=i[t]||{},wt(i[t],e)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in t)t[r].setFeatureState(i,e)}}const _d=89.25;function gd(t,e){const i=vt(e.lat,-85.051129,$t);return new s(Fp(e.lng)*t,Op(i)*t)}function yd(t,e){return new Up(e.x/t,e.y/t).toLngLat()}function xd(t){return t.cameraToCenterDistance*Math.min(.85*Math.tan(Vt(90-t.pitch)),Math.tan(Vt(_d-t.pitch)))}function vd(t,e){const i=t.canonical,r=e/Mt(i.z),n=i.x+Math.pow(2,i.z)*t.wrap,s=y(new Float64Array(16));return b(s,s,[n*r,i.y*r,0]),w(s,s,[r/Q,r/Q,1]),s}function bd(t,e,i,r,n){const s=Up.fromLngLat(t,e),o=n*jp(1,t.lat),a=o*Math.cos(Vt(i)),l=Math.sqrt(o*o-a*a),c=l*Math.sin(Vt(-r)),h=l*Math.cos(Vt(-r));return new Up(s.x+c,s.y+h,s.z+a)}function wd(t,e,i){const r=e.intersectsFrustum(t);if(!i||0===r)return r;const n=e.intersectsPlane(i);return 0===n?0:2===r&&2===n?2:1}function Td(t,e,i){let r=0;const n=(i-e)/10;for(let s=0;s<10;s++)r+=n*Math.pow(Math.cos(e+(s+.5)/10*(i-e)),t);return r}function Pd(t,e){return function(i,r,n,s,o){const a=2*((t-1)/It(Math.cos(Vt(_d-o))/Math.cos(Vt(_d)))-1),l=Math.acos(n/s),c=2*Td(a-1,0,Vt(o/2)),h=Math.min(Vt(_d),l+Vt(o/2)),u=Td(a-1,Math.min(h,l-Vt(o/2)),h),p=Math.atan(r/n);let d=i;return d+=It(s/Math.hypot(r,n)/Math.max(.5,Math.cos(Vt(o/2)))),d+=a*It(Math.cos(p))/2,d-=It(Math.max(1,u/c/e))/2,d}}const Sd=Pd(9.314,3);function Md(t,e){const i=(e.roundZoom?Math.round:Math.floor)(t.zoom+It(t.tileSize/e.tileSize));return Math.max(0,i)}function Id(t,e){const i=t.getCameraFrustum(),r=t.getClippingPlane(),n=t.screenPointToMercatorCoordinate(t.getCameraPoint()),s=Up.fromLngLat(t.center,t.elevation);n.z=s.z+Math.cos(t.pitchInRadians)*t.cameraToCenterDistance/t.worldSize;const o=t.getCoveringTilesDetailsProvider(),a=o.allowVariableZoom(t,e),l=Md(t,e),c=e.minzoom||0,h=void 0!==e.maxzoom?e.maxzoom:t.maxZoom,u=Math.min(Math.max(0,l),h),p=Math.pow(2,u),d=[p*n.x,p*n.y,0],f=[p*s.x,p*s.y,0],m=Math.hypot(s.x-n.x,s.y-n.y),_=Math.abs(s.z-n.z),g=Math.hypot(m,_),y=t=>({zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),x=[],v=[];if(t.renderWorldCopies&&o.allowWorldCopies())for(let t=1;t<=3;t++)x.push(y(-t)),x.push(y(t));for(x.push(y(0));x.length>0;){const p=x.pop(),m=p.x,y=p.y;let b=p.fullyVisible;const w={x:m,y:y,z:p.zoom},T=o.getTileBoundingVolume(w,p.wrap,t.elevation,e);if(!b){const t=wd(i,T,r);if(0===t)continue;b=2===t}const P=o.distanceToTile2d(n.x,n.y,w,T);let S=l;a&&(S=(e.calculateTileZoom||Sd)(t.zoom+It(t.tileSize/e.tileSize),P,_,g,t.fov)),S=(e.roundZoom?Math.round:Math.floor)(S),S=Math.max(0,S);const M=Math.min(S,h);if(p.wrap=o.getWrap(s,w,p.wrap),p.zoom>=M){if(p.zoom<c)continue;const t=u-p.zoom,i=d[0]-.5-(m<<t),r=d[1]-.5-(y<<t),n=e.reparseOverscaled?Math.max(p.zoom,S):p.zoom;v.push({tileID:new Xp(p.zoom===h?n:p.zoom,p.wrap,p.zoom,m,y),distanceSq:J([f[0]-.5-m,f[1]-.5-y]),tileDistanceToCamera:Math.sqrt(i*i+r*r)})}else for(let t=0;t<4;t++)x.push({zoom:p.zoom+1,x:(m<<1)+t%2,y:(y<<1)+(t>>1),wrap:p.wrap,fullyVisible:b})}return v.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}const Cd=Qp.fromPoints([new s(0,0),new s(Q,Q)]);class Ed extends be{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>this._dataHandler(t))),this.on("dataloading",(()=>{this._sourceErrored=!1})),this.on("error",(()=>{this._sourceErrored=this._source.loaded()})),this._source=((t,e,i,r)=>{const n=new(nd(e.type))(t,e,i,r);if(n.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${n.id}`);return n})(t,e,i,this),this._tiles={},this._cache=new fd(0,(t=>this._unloadTile(t))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new md,this._didEmitContent=!1,this._updated=!1}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t)}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t)}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return!0;if(!this._updated)return!1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}return!0}getSource(){return this._source}pause(){this._paused=!0}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain)}_loadTile(t,e,i){return n(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,e,i)}catch(e){t.state="errored",404!==e.status?this._source.fire(new ve(e,{tile:t})):this.update(this.transform,this.terrain)}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t)}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new xe("dataabort",{tile:t,coord:t.tileID,dataType:"source"}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager)}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(Ad).map((t=>t.key))}getRenderableIds(t){const e=[];for(const i in this._tiles)this._isIdRenderable(i,t)&&e.push(this._tiles[i]);return t?e.sort(((t,e)=>{const i=t.tileID,r=e.tileID,n=new s(i.canonical.x,i.canonical.y)._rotate(-this.transform.bearingInRadians),o=new s(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians);return i.overscaledZ-r.overscaledZ||o.y-n.y||o.x-n.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(Ad).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return!!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(t){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const e in this._tiles)t?this._reloadTile(e,"expired"):"errored"!==this._tiles[e].state&&this._reloadTile(e,"reloading")}}_reloadTile(t,e){return n(this,void 0,void 0,(function*(){const i=this._tiles[t];i&&("loading"!==i.state&&(i.state=e),yield this._loadTile(i,t,e))}))}_tileLoaded(t,e,i){t.timeAdded=Qt.now(),"expired"===i&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new xe("data",{dataType:"source",tile:t,coord:t.tileID}))}_backfillDEM(t){const e=this.getRenderableIds();for(let r=0;r<e.length;r++){const n=e[r];if(t.neighboringTiles&&t.neighboringTiles[n]){const e=this.getTileByID(n);i(t,e),i(e,t)}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const r=e.tileID.canonical.y-t.tileID.canonical.y,n=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+n)?i+=n:1===Math.abs(i-n)&&(i-=n)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,r),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)))}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,i,r){for(const n in this._tiles){let s=this._tiles[n];if(r[n]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>i)continue;let o=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(o=t)}let a=o;for(;a.overscaledZ>e;)if(a=a.scaledTo(a.overscaledZ-1),t[a.key]||t[a.canonical.key]){r[o.key]=o;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const i=this._loadedParentTiles[t.key];return i&&i.tileID.overscaledZ>=e?i:null}for(let i=t.overscaledZ-1;i>=e;i--){const e=t.scaledTo(i),r=this._getLoadedTile(e);if(r)return r}}findLoadedSibling(t){return this._getLoadedTile(t)}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(t.wrapped().key)}updateCacheSize(t){const e=Math.ceil(t.width/this._source.tileSize)+1,i=Math.ceil(t.height/this._source.tileSize)+1,r=Math.floor(e*i*(null===this._maxTileCacheZoomLevels?ee.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n)}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),t[r.tileID.key]=r}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t])}}_updateCoveredAndRetainedTiles(t,e,i,r,n,s){const o={},a={},l=Object.keys(t),c=Qt.now();for(const i of l){const r=t[i],n=this._tiles[i];if(!n||0!==n.fadeEndTime&&n.fadeEndTime<=c)continue;const s=this.findLoadedParent(r,e),l=this.findLoadedSibling(r),h=s||l||null;h&&(this._addTile(h.tileID),o[h.tileID.key]=h.tileID),a[i]=r}this._retainLoadedChildren(a,r,i,t);for(const e in o)t[e]||(this._coveredTiles[e]=!0,t[e]=o[e]);if(s){const e={},i={};for(const t of n)this._tiles[t.key].hasData()?e[t.key]=t:i[t.key]=t;for(const r in i){const n=i[r].children(this._source.maxzoom);this._tiles[n[0].key]&&this._tiles[n[1].key]&&this._tiles[n[2].key]&&this._tiles[n[3].key]&&(e[n[0].key]=t[n[0].key]=n[0],e[n[1].key]=t[n[1].key]=n[1],e[n[2].key]=t[n[2].key]=n[2],e[n[3].key]=t[n[3].key]=n[3],delete i[r])}for(const r in i){const n=i[r],s=this.findLoadedParent(n,this._source.minzoom),o=this.findLoadedSibling(n),a=s||o||null;if(a){e[a.tileID.key]=t[a.tileID.key]=a.tileID;for(const t in e)e[t].isChildOf(a.tileID)&&delete e[t]}}for(const t in this._tiles)e[t]||(this._coveredTiles[t]=!0)}}update(t,e){if(!this._sourceLoaded||this._paused)return;let i;this.transform=t,this.terrain=e,this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new Xp(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(i=Id(t,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:e,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(i=i.filter((t=>this._source.hasTile(t))))):i=[];const r=Md(t,this._source),n=Math.max(r-Ed.maxOverzooming,this._source.minzoom),s=Math.max(r+Ed.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const t={};for(const e of i)if(e.canonical.z>this._source.minzoom){const i=e.scaledTo(e.canonical.z-1);t[i.key]=i;const r=e.scaledTo(Math.max(this._source.minzoom,Math.min(e.canonical.z,5)));t[r.key]=r}i=i.concat(Object.values(t))}const o=0===i.length&&!this._updated&&this._didEmitContent;this._updated=!0,o&&this.fire(new xe("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const a=this._updateRetainedTiles(i,r);zd(this._source.type)&&this._updateCoveredAndRetainedTiles(a,n,s,r,i,e);for(const t in a)this._tiles[t].clearFadeHold();const l=function(t,e){const i=[];for(const r in t)r in e||i.push(r);return i}(this._tiles,a);for(const t of l){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(t)}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache()}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(t)}_updateRetainedTiles(t,e){var i;const r={},n={},s=Math.max(e-Ed.maxOverzooming,this._source.minzoom),o=Math.max(e+Ed.maxUnderzooming,this._source.minzoom),a={};for(const i of t){const t=this._addTile(i);r[i.key]=i,t.hasData()||e<this._source.maxzoom&&(a[i.key]=i)}this._retainLoadedChildren(a,e,o,r);for(const o of t){let t=this._tiles[o.key];if(t.hasData())continue;if(e+1>this._source.maxzoom){const t=o.children(this._source.maxzoom)[0],e=this.getTile(t);if(e&&e.hasData()){r[t.key]=t;continue}}else{const t=o.children(this._source.maxzoom);if(4===t.length&&r[t[0].key]&&r[t[1].key]&&r[t[2].key]&&r[t[3].key])continue;if(1===t.length&&r[t[0].key])continue}let a=t.wasRequested();for(let e=o.overscaledZ-1;e>=s;--e){const s=o.scaledTo(e);if(n[s.key])break;if(n[s.key]=!0,t=this.getTile(s),!t&&a&&(t=this._addTile(s)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||a)&&(r[s.key]=s),a=t.wasRequested(),e)break}}}return r}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let i,r=this._tiles[t].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}e.push(r.key);const t=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(t),i)break;r=t}for(const t of e)this._loadedParentTiles[t]=i}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const t in this._tiles){const e=this._tiles[t].tileID,i=this._getLoadedTile(e);this._loadedSiblingTiles[e.key]=i}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const i=e;return e||(e=new dd(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(e,t.key,e.state)),e.uses++,this._tiles[t.key]=e,i||this._source.fire(new xe("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t]}),i))}refreshTiles(t){for(const e in this._tiles)(this._isIdRenderable(e)||"errored"==this._tiles[e].state)&&t.some((t=>t.equals(this._tiles[e].tileID.canonical)))&&this._reloadTile(e,"expired")}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))))}_dataHandler(t){const e=t.sourceDataType;"source"===t.dataType&&"metadata"===e&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===e&&(this.reload(t.sourceDataChanged),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0)}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset()}tilesIn(t,e,i){const r=[],n=this.transform;if(!n)return r;const s=n.getCoveringTilesDetailsProvider().allowWorldCopies(),o=i?n.getCameraQueryGeometry(t):t,a=t=>n.screenPointToMercatorCoordinate(t,this.terrain),l=this.transformBbox(t,a,!s),c=this.transformBbox(o,a,!s),h=this.getIds(),u=Qp.fromPoints(c);for(let t=0;t<h.length;t++){const i=this._tiles[h[t]];if(i.holdingForFade())continue;const o=s?[i.tileID]:[i.tileID.unwrapTo(-1),i.tileID.unwrapTo(0)],a=Math.pow(2,n.zoom-i.tileID.overscaledZ),p=e*i.queryPadding*Q/i.tileSize/a;for(const t of o){const e=u.map((e=>t.getTilePoint(new Up(e.x,e.y))));if(e.expandBy(p),e.intersects(Cd)){const e=l.map((e=>t.getTilePoint(e))),n=c.map((e=>t.getTilePoint(e)));r.push({tile:i,tileID:s?t:t.unwrapTo(0),queryGeometry:e,cameraQueryGeometry:n,scale:a})}}}return r}transformBbox(t,e,i){let r=t.map(e);if(i){const i=Qp.fromPoints(t);i.shrinkBy(.001*Math.min(i.width(),i.height()));const n=i.map(e);Qp.fromPoints(r).covers(n)||(r=r.map((t=>t.x>.5?new Up(t.x-1,t.y,t.z):t)))}return r}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));return this.transform&&this.transform.populateCache(e),e}hasTransition(){if(this._source.hasTransition())return!0;if(zd(this._source.type)){const t=Qt.now();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return!0}return!1}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i)}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i)}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const r=this._tiles[t];r&&r.setDependencies(e,i)}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)))}}function Ad(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),r=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||r-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function zd(t){return"raster"===t||"image"===t||"video"===t}Ed.maxOverzooming=10,Ed.maxUnderzooming=3;class kd{constructor(t,e){this.reset(t,e)}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(t){if(1===this.points.length)return this.points[0];t=vt(t,0,1);let e=1,i=this._distances[e];const r=t*this.paddedLength+this.padding;for(;i<r&&e<this._distances.length;)i=this._distances[++e];const n=e-1,s=this._distances[n],o=i-s,a=o>0?(r-s)/o:0;return this.points[n].mult(1-a).add(this.points[e].mult(a))}}function Dd(t,e){let i=!0;return"always"===t||"never"!==t&&"never"!==e||(i=!1),i}class Rd{constructor(t,e,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(t,e,i,r){this._forEachCell(e-r,i-r,e+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(r)}_insertBoxCell(t,e,i,r,n,s){this.boxCells[n].push(s)}_insertCircleCell(t,e,i,r,n,s){this.circleCells[n].push(s)}_query(t,e,i,r,n,s,o){if(i<0||t>this.width||r<0||e>this.height)return[];const a=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=r){if(n)return[{key:null,x1:t,y1:e,x2:i,y2:r}];for(let t=0;t<this.boxKeys.length;t++)a.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],r=this.circles[3*t+2];a.push({key:this.circleKeys[t],x1:e-r,y1:i-r,x2:e+r,y2:i+r})}}else this._forEachCell(t,e,i,r,this._queryCell,a,{hitTest:n,overlapMode:s,seenUids:{box:{},circle:{}}},o);return a}query(t,e,i,r){return this._query(t,e,i,r,!1,null)}hitTest(t,e,i,r,n,s){return this._query(t,e,i,r,!0,n,s).length>0}hitTestCircle(t,e,i,r,n){const s=t-i,o=t+i,a=e-i,l=e+i;if(o<0||s>this.width||l<0||a>this.height)return!1;const c=[];return this._forEachCell(s,a,o,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},n),c.length>0}_queryCell(t,e,i,r,n,s,o,a){const{seenUids:l,hitTest:c,overlapMode:h}=o,u=this.boxCells[n];if(null!==u){const n=this.bboxes;for(const o of u)if(!l.box[o]){l.box[o]=!0;const u=4*o,p=this.boxKeys[o];if(t<=n[u+2]&&e<=n[u+3]&&i>=n[u+0]&&r>=n[u+1]&&(!a||a(p))&&(!c||!Dd(h,p.overlapMode))&&(s.push({key:p,x1:n[u],y1:n[u+1],x2:n[u+2],y2:n[u+3]}),c))return!0}}const p=this.circleCells[n];if(null!==p){const n=this.circles;for(const o of p)if(!l.circle[o]){l.circle[o]=!0;const u=3*o,p=this.circleKeys[o];if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],t,e,i,r)&&(!a||a(p))&&(!c||!Dd(h,p.overlapMode))){const t=n[u],e=n[u+1],i=n[u+2];if(s.push({key:p,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),c)return!0}}}return!1}_queryCellCircle(t,e,i,r,n,s,o,a){const{circle:l,seenUids:c,overlapMode:h}=o,u=this.boxCells[n];if(null!==u){const t=this.bboxes;for(const e of u)if(!c.box[e]){c.box[e]=!0;const i=4*e,r=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!a||a(r))&&!Dd(h,r.overlapMode))return s.push(!0),!0}}const p=this.circleCells[n];if(null!==p){const t=this.circles;for(const e of p)if(!c.circle[e]){c.circle[e]=!0;const i=3*e,r=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!a||a(r))&&!Dd(h,r.overlapMode))return s.push(!0),!0}}}_forEachCell(t,e,i,r,n,s,o,a){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++)if(n.call(this,t,e,i,r,this.xCellCount*l+p,s,o,a))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,r,n,s){const o=r-t,a=n-e,l=i+s;return l*l>o*o+a*a}_circleAndRectCollide(t,e,i,r,n,s,o){const a=(s-r)/2,l=Math.abs(t-(r+a));if(l>a+i)return!1;const c=(o-n)/2,h=Math.abs(e-(n+c));if(h>c+i)return!1;if(l<=a||h<=c)return!0;const u=l-a,p=h-c;return u*u+p*p<=i*i}}function Ld(t,e,i){const r=_();if(!t){const{vecSouth:t,vecEast:i}=Fd(e),u=f();u[0]=i[0],u[1]=i[1],u[2]=t[0],u[3]=t[1],n=u,(h=(o=(s=u)[0])*(c=s[3])-(l=s[2])*(a=s[1]))&&(n[0]=c*(h=1/h),n[1]=-a*h,n[2]=-l*h,n[3]=o*h),r[0]=u[0],r[1]=u[1],r[4]=u[2],r[5]=u[3]}var n,s,o,a,l,c,h;return w(r,r,[1/i,1/i,1]),r}function Bd(t,e,i,r){if(t){const t=_();if(!e){const{vecSouth:e,vecEast:r}=Fd(i);t[0]=r[0],t[1]=r[1],t[4]=e[0],t[5]=e[1]}return w(t,t,[r,r,1]),t}return i.pixelsToClipSpaceMatrix}function Fd(t){const e=Math.cos(t.rollInRadians),i=Math.sin(t.rollInRadians),r=Math.cos(t.pitchInRadians),n=Math.cos(t.bearingInRadians),s=Math.sin(t.bearingInRadians),o=W();o[0]=-n*r*i-s*e,o[1]=-s*r*i+n*e;const a=Y(o);a<1e-9?K(o):X(o,o,1/a);const l=W();l[0]=n*r*e-s*i,l[1]=s*r*e+n*i;const c=Y(l);return c<1e-9?K(l):X(l,l,1/c),{vecEast:l,vecSouth:o}}function Od(t,e,i,r){let n;r?(n=[t,e,r(t,e),1],G(n,n,i)):(n=[t,e,0,1],ef(n,n,i));const o=n[3];return{point:new s(n[0]/o,n[1]/o),signedDistanceFromCamera:o,isOccluded:!1}}function jd(t,e){return.5+t/e*.5}function Vd(t,e){return t.x>=-e[0]&&t.x<=e[0]&&t.y>=-e[1]&&t.y<=e[1]}function Nd(t,e,i,r,n,o,a,l,c,h,u,p,d){const f=i?t.textSizeData:t.iconSizeData,m=Ru(f,e.transform.zoom),_=[256/e.width*2+1,256/e.height*2+1],g=i?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;g.clear();const y=t.lineVertexArray,x=i?t.text.placedSymbolArray:t.icon.placedSymbolArray,v=e.transform.width/e.transform.height;let b=!1;for(let i=0;i<x.length;i++){const w=x.get(i);if(w.hidden||w.writingMode===Au.vertical&&!b){tf(w.numGlyphs,g);continue}b=!1;const T=new s(w.anchorX,w.anchorY),P={getElevation:d,pitchedLabelPlaneMatrix:r,lineVertexArray:y,pitchWithMap:o,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:e.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:p},S=Xd(w.anchorX,w.anchorY,P);if(!Vd(S.point,_)){tf(w.numGlyphs,g);continue}const M=jd(e.transform.cameraToCenterDistance,S.signedDistanceFromCamera),I=Du(f,m,w),C=o?I*e.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/M:I*M,E=Gd({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:C,flip:!1,keepUpright:a,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:l});b=E.useVertical,(E.notEnoughRoom||b||E.needsFlipping&&Gd({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:C,flip:!0,keepUpright:a,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:l}).notEnoughRoom)&&tf(w.numGlyphs,g)}i?t.text.dynamicLayoutVertexBuffer.updateData(g):t.icon.dynamicLayoutVertexBuffer.updateData(g)}function Ud(t,e,i,r,n,s,o,a){const l=s.glyphStartIndex+s.numGlyphs,c=s.lineStartIndex,h=s.lineStartIndex+s.lineLength,u=e.getoffsetX(s.glyphStartIndex),p=e.getoffsetX(l-1),d=Jd(t*u,i,r,n,s.segment,c,h,a,o);if(!d)return null;const f=Jd(t*p,i,r,n,s.segment,c,h,a,o);return f?a.projectionCache.anyProjectionOccluded?null:{first:d,last:f}:null}function Zd(t,e,i,r){return t===Au.horizontal&&Math.abs(i.y-e.y)>Math.abs(i.x-e.x)*r?{useVertical:!0}:(t===Au.vertical?e.y<i.y:e.x>i.x)?{needsFlipping:!0}:null}function Gd(t){const{projectionContext:e,pitchedLabelPlaneMatrixInverse:i,symbol:r,fontSize:n,flip:o,keepUpright:a,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=t,p=n/24,d=r.lineOffsetX*p,f=r.lineOffsetY*p;let m;if(r.numGlyphs>1){const t=r.glyphStartIndex+r.numGlyphs,n=r.lineStartIndex,s=r.lineStartIndex+r.lineLength,c=Ud(p,l,d,f,o,r,u,e);if(!c)return{notEnoughRoom:!0};const _=Hd(c.first.point.x,c.first.point.y,e,i),g=Hd(c.last.point.x,c.last.point.y,e,i);if(a&&!o){const t=Zd(r.writingMode,_,g,h);if(t)return t}m=[c.first];for(let i=r.glyphStartIndex+1;i<t-1;i++){const t=Jd(p*l.getoffsetX(i),d,f,o,r.segment,n,s,e,u);if(!t)return{notEnoughRoom:!0};m.push(t)}m.push(c.last)}else{if(a&&!o){const t=Wd(e.tileAnchorPoint.x,e.tileAnchorPoint.y,e).point,n=r.lineStartIndex+r.segment+1,o=new s(e.lineVertexArray.getx(n),e.lineVertexArray.gety(n)),a=Wd(o.x,o.y,e),l=a.signedDistanceFromCamera>0?a.point:$d(e.tileAnchorPoint,o,t,1,e),c=Hd(t.x,t.y,e,i),u=Hd(l.x,l.y,e,i),p=Zd(r.writingMode,c,u,h);if(p)return p}const t=Jd(p*l.getoffsetX(r.glyphStartIndex),d,f,o,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,e,u);if(!t||e.projectionCache.anyProjectionOccluded)return{notEnoughRoom:!0};m=[t]}for(const t of m)Ou(c,t.point,t.angle);return{}}function $d(t,e,i,r,n){const s=t.add(t.sub(e)._unit()),o=Wd(s.x,s.y,n).point,a=i.sub(o);return i.add(a._mult(r/a.mag()))}function qd(t,e,i){const r=e.projectionCache;if(r.projections[t])return r.projections[t];const n=new s(e.lineVertexArray.getx(t),e.lineVertexArray.gety(t)),o=Wd(n.x,n.y,e);if(o.signedDistanceFromCamera>0)return r.projections[t]=o.point,r.anyProjectionOccluded=r.anyProjectionOccluded||o.isOccluded,o.point;const a=t-i.direction;return $d(0===i.distanceFromAnchor?e.tileAnchorPoint:new s(e.lineVertexArray.getx(a),e.lineVertexArray.gety(a)),n,i.previousVertex,i.absOffsetX-i.distanceFromAnchor+1,e)}function Wd(t,e,i){const r=t+i.translation[0],n=e+i.translation[1];let s;return i.pitchWithMap?(s=Od(r,n,i.pitchedLabelPlaneMatrix,i.getElevation),s.isOccluded=!1):(s=i.transform.projectTileCoordinates(r,n,i.unwrappedTileID,i.getElevation),s.point.x=(.5*s.point.x+.5)*i.width,s.point.y=(.5*-s.point.y+.5)*i.height),s}function Hd(t,e,i,r){if(i.pitchWithMap){const n=[t,e,0,1];return G(n,n,r),i.transform.projectTileCoordinates(n[0]/n[3],n[1]/n[3],i.unwrappedTileID,i.getElevation).point}return{x:t/i.width*2-1,y:1-e/i.height*2}}function Xd(t,e,i){return i.transform.projectTileCoordinates(t,e,i.unwrappedTileID,i.getElevation)}function Yd(t,e,i){return t._unit()._perp()._mult(e*i)}function Kd(t,e,i,r,n,o,a,l,c){if(l.projectionCache.offsets[t])return l.projectionCache.offsets[t];const h=i.add(e);if(t+c.direction<r||t+c.direction>=n)return l.projectionCache.offsets[t]=h,h;const u=qd(t+c.direction,l,c),p=Yd(u.sub(i),a,c.direction),d=i.add(p),f=u.add(p);return l.projectionCache.offsets[t]=function(t,e,i,r){const n=e.y-t.y,o=e.x-t.x,a=r.y-i.y,l=r.x-i.x,c=a*o-l*n;if(0===c)return null;const h=(l*(t.y-i.y)-a*(t.x-i.x))/c;return new s(t.x+h*o,t.y+h*n)}(o,h,d,f)||h,l.projectionCache.offsets[t]}function Jd(t,e,i,r,n,s,o,a,l){const c=r?t-e:t+e;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let p,d=h>0?s+n:s+n+1;a.projectionCache.cachedAnchorPoint?p=a.projectionCache.cachedAnchorPoint:(p=Wd(a.tileAnchorPoint.x,a.tileAnchorPoint.y,a).point,a.projectionCache.cachedAnchorPoint=p);let f,m,_=p,g=p,y=0,x=0;const v=Math.abs(c),b=[];let w;for(;y+x<=v;){if(d+=h,d<s||d>=o)return null;y+=x,g=_,m=f;const t={absOffsetX:v,direction:h,distanceFromAnchor:y,previousVertex:g};if(_=qd(d,a,t),0===i)b.push(g),w=_.sub(g);else{let e;const r=_.sub(g);e=0===r.mag()?Yd(qd(d+h,a,t).sub(_),i,h):Yd(r,i,h),m||(m=g.add(e)),f=Kd(d,e,_,s,o,m,i,a,t),b.push(m),w=f.sub(m)}x=w.mag()}const T=w._mult((v-y)/x)._add(m||g),P=u+Math.atan2(_.y-g.y,_.x-g.x);return b.push(T),{point:T,angle:l?P:0,path:b}}const Qd=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function tf(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(Qd,3*t)}}function ef(t,e,i){const r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t[3]=i[3]*r+i[7]*n+i[15],t}const rf=100;class nf{constructor(t,e=new Rd(t.width+200,t.height+200,25),i=new Rd(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchFactor=Math.cos(t.pitch*Math.PI/180)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+rf,this.screenBottomBoundary=t.height+rf,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6}placeCollisionBox(t,e,i,r,n,s,o,a,l,c,h,u){const p=this.projectAndGetPerspectiveRatio(t.anchorPointX+a[0],t.anchorPointY+a[1],n,c,u),d=i*p.perspectiveRatio;let f;if(s||o)f=this._projectCollisionBox(t,d,r,n,s,o,a,p,c,h,u);else{const e=p.x+(h?h.x*d:0),i=p.y+(h?h.y*d:0);f={allPointsOccluded:!1,box:[e+t.x1*d,i+t.y1*d,e+t.x2*d,i+t.y2*d]}}const[m,_,g,y]=f.box,x=s?f.allPointsOccluded:p.isOccluded;let v=x;return v||(v=p.perspectiveRatio<this.perspectiveRatioCutoff),v||(v=!this.isInsideGrid(m,_,g,y)),v||"always"!==e&&this.grid.hitTest(m,_,g,y,e,l)?{box:[m,_,g,y],placeable:!1,offscreen:!1,occluded:x}:{box:[m,_,g,y],placeable:!0,offscreen:this.isOffscreen(m,_,g,y),occluded:x}}placeCollisionCircles(t,e,i,r,n,o,a,l,c,h,u,p,d,f){const m=[],_=new s(e.anchorX,e.anchorY),g=this.getPerspectiveRatio(_.x,_.y,o,f),y=(c?n*this.transform.getPitchedTextCorrection(e.anchorX,e.anchorY,o)/g:n*g)/24,x={getElevation:f,pitchedLabelPlaneMatrix:a,lineVertexArray:i,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:_,unwrappedTileID:o,width:this.transform.width,height:this.transform.height,translation:d},v=Ud(y,r,e.lineOffsetX*y,e.lineOffsetY*y,!1,e,!1,x);let b=!1,w=!1,T=!0;if(v){const e=.5*u*g+p,i=new s(-100,-100),r=new s(this.screenRightBoundary,this.screenBottomBoundary),n=new kd,o=v.first,a=v.last;let d=[];for(let t=o.path.length-1;t>=1;t--)d.push(o.path[t]);for(let t=1;t<a.path.length;t++)d.push(a.path[t]);const f=2.5*e;if(c){const t=this.projectPathToScreenSpace(d,x);d=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point))}let _=[];if(d.length>0){const t=d[0].clone(),e=d[0].clone();for(let i=1;i<d.length;i++)t.x=Math.min(t.x,d[i].x),t.y=Math.min(t.y,d[i].y),e.x=Math.max(e.x,d[i].x),e.y=Math.max(e.y,d[i].y);_=t.x>=i.x&&e.x<=r.x&&t.y>=i.y&&e.y<=r.y?[d]:e.x<i.x||t.x>r.x||e.y<i.y||t.y>r.y?[]:function(t,e,i,r,n){const o=[];for(let a=0;a<t.length;a++){const l=t[a];let c;for(let t=0;t<l.length-1;t++){let a=l[t],h=l[t+1];a.x<e&&h.x<e||(a.x<e?a=new s(e,a.y+(e-a.x)/(h.x-a.x)*(h.y-a.y))._round():h.x<e&&(h=new s(e,a.y+(e-a.x)/(h.x-a.x)*(h.y-a.y))._round()),a.y<i&&h.y<i||(a.y<i?a=new s(a.x+(i-a.y)/(h.y-a.y)*(h.x-a.x),i)._round():h.y<i&&(h=new s(a.x+(i-a.y)/(h.y-a.y)*(h.x-a.x),i)._round()),a.x>=r&&h.x>=r||(a.x>=r?a=new s(r,a.y+(r-a.x)/(h.x-a.x)*(h.y-a.y))._round():h.x>=r&&(h=new s(r,a.y+(r-a.x)/(h.x-a.x)*(h.y-a.y))._round()),a.y>=n&&h.y>=n||(a.y>=n?a=new s(a.x+(n-a.y)/(h.y-a.y)*(h.x-a.x),n)._round():h.y>=n&&(h=new s(a.x+(n-a.y)/(h.y-a.y)*(h.x-a.x),n)._round()),c&&a.equals(c[c.length-1])||(c=[a],o.push(c)),c.push(h)))))}}return o}([d],i.x,i.y,r.x,r.y)}for(const i of _){n.reset(i,.25*e);let r=0;r=n.length<=.5*e?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const s=i/Math.max(r-1,1),o=n.lerp(s),a=o.x+rf,c=o.y+rf;m.push(a,c,e,0);const u=a-e,p=c-e,d=a+e,f=c+e;if(T=T&&this.isOffscreen(u,p,d,f),w=w||this.isInsideGrid(u,p,d,f),"always"!==t&&this.grid.hitTestCircle(a,c,e,t,h)&&(b=!0,!l))return{circles:[],offscreen:!1,collisionDetected:b}}}}return{circles:!l&&b||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:b}}projectPathToScreenSpace(t,e){const i=function(t,e){const i=_();return x(i,e.pitchedLabelPlaneMatrix),t.map((t=>{const r=Od(t.x,t.y,i,e.getElevation),n=e.transform.projectTileCoordinates(r.point.x,r.point.y,e.unwrappedTileID,e.getElevation);return n.point.x=(.5*n.point.x+.5)*e.width,n.point.y=(.5*-n.point.y+.5)*e.height,n}))}(t,e);return function(t){let e=0,i=0,r=0,n=0;for(let s=0;s<t.length;s++)t[s].isOccluded?(r=s+1,n=0):(n++,n>i&&(i=n,e=r));return t.slice(e,e+i)}(i)}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const e=[],i=new Qp;for(const r of t){const t=new s(r.x+rf,r.y+rf);i.extend(t),e.push(t)}const{minX:r,minY:n,maxX:o,maxY:a}=i,l=this.grid.query(r,n,o,a).concat(this.ignoredGrid.query(r,n,o,a)),c={},h={};for(const t of l){const i=t.key;void 0===c[i.bucketInstanceId]&&(c[i.bucketInstanceId]={}),c[i.bucketInstanceId][i.featureIndex]||Zl(e,[new s(t.x1,t.y1),new s(t.x2,t.y1),new s(t.x2,t.y2),new s(t.x1,t.y2)])&&(c[i.bucketInstanceId][i.featureIndex]=!0,void 0===h[i.bucketInstanceId]&&(h[i.bucketInstanceId]=[]),h[i.bucketInstanceId].push(i.featureIndex))}return h}insertCollisionBox(t,e,i,r,n,s){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:e},t[0],t[1],t[2],t[3])}insertCollisionCircles(t,e,i,r,n,s){const o=i?this.ignoredGrid:this.grid,a={bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:e};for(let e=0;e<t.length;e+=4)o.insertCircle(a,t[e],t[e+1],t[e+2])}projectAndGetPerspectiveRatio(t,e,i,r,n){if(n){let i;r?(i=[t,e,r(t,e),1],G(i,i,n)):(i=[t,e,0,1],ef(i,i,n));const s=i[3];return{x:(i[0]/s+1)/2*this.transform.width+rf,y:(-i[1]/s+1)/2*this.transform.height+rf,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const n=this.transform.projectTileCoordinates(t,e,i,r);return{x:(n.point.x+1)/2*this.transform.width+rf,y:(1-n.point.y)/2*this.transform.height+rf,perspectiveRatio:.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5,isOccluded:n.isOccluded,signedDistanceFromCamera:n.signedDistanceFromCamera}}}getPerspectiveRatio(t,e,i,r){const n=this.transform.projectTileCoordinates(t,e,i,r);return.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5}isOffscreen(t,e,i,r){return i<rf||t>=this.screenRightBoundary||r<rf||e>this.screenBottomBoundary}isInsideGrid(t,e,i,r){return i>=0&&t<this.gridRightBoundary&&r>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=y([]);return b(t,t,[-100,-100,0]),t}_projectCollisionBox(t,e,i,r,n,o,a,l,c,h,u){let p=1,d=0,f=0,m=1;const _=t.anchorPointX+a[0],g=t.anchorPointY+a[1];if(o&&!n){const t=this.projectAndGetPerspectiveRatio(_+1,g,r,c,u),e=t.x-l.x,i=Math.atan((t.y-l.y)/e)+(e<0?Math.PI:0),n=Math.sin(i),s=Math.cos(i);p=s,d=n,f=-n,m=s}else if(!o&&n){const t=Fd(this.transform);p=t.vecEast[0],d=t.vecEast[1],f=t.vecSouth[0],m=t.vecSouth[1]}let y=l.x,x=l.y,v=e;n&&(y=_,x=g,v=Math.pow(2,-(this.transform.zoom-i.overscaledZ)),v*=this.transform.getPitchedTextCorrection(_,g,r),h||(v*=vt(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(y+=p*h.x*v+f*h.y*v,x+=d*h.x*v+m*h.y*v);const b=t.x1*v,w=t.x2*v,T=(b+w)/2,P=t.y1*v,S=t.y2*v,M=(P+S)/2,I=[{offsetX:b,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:M},{offsetX:w,offsetY:S},{offsetX:T,offsetY:S},{offsetX:b,offsetY:S},{offsetX:b,offsetY:M}];let C=[];for(const{offsetX:t,offsetY:e}of I)C.push(new s(y+p*t+f*e,x+d*t+m*e));let E=!1;if(n){const t=C.map((t=>this.projectAndGetPerspectiveRatio(t.x,t.y,r,c,u)));E=t.some((t=>!t.isOccluded)),C=t.map((t=>new s(t.x,t.y)))}else E=!0;return{box:_t(C),allPointsOccluded:!E}}}class sf extends s{constructor(t,e,i,r){super(t,e),this.angle=i,void 0!==r&&(this.segment=r)}clone(){return new sf(this.x,this.y,this.angle,this.segment)}}var of;co("Anchor",sf),function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(of||(of={}));class af{constructor(t,e,i,r){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class lf{constructor(t,e,i,r,n){this.text=new af(t?t.text:null,e,i,n),this.icon=new af(t?t.icon:null,e,r,n)}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class cf{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i}}class hf{constructor(t,e,i,r,n){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class uf{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={}}get(t){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e}}return this.collisionGroups[t]}}function pf(t,e,i,r,n){const{horizontalAlign:o,verticalAlign:a}=zu(t);return new s(-(o-.5)*e+r[0]*n,-(a-.5)*i+r[1]*n)}class df{constructor(t,e,i,r,n){this.transform=t.clone(),this.terrain=e,this.collisionIndex=new nf(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new uf(r),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=n,n&&(n.prevPlacement=void 0),this.placedOrientations={}}_getTerrainElevationFunc(t){const e=this.terrain;return e?(i,r)=>e.getElevation(t,i,r):null}getBucketParts(t,e,i,r){const n=i.getBucket(e),s=i.latestFeatureIndex;if(!n||!s||e.id!==n.layerIds[0])return;const o=i.collisionBoxArray,a=n.layers[0].layout,l=n.layers[0].paint,c=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),h=i.tileSize/Q,u=i.tileID.toUnwrapped(),p="map"===a.get("text-rotation-alignment"),d=tt(i,1,this.transform.zoom),f=ot(this.collisionIndex.transform,i,l.get("text-translate"),l.get("text-translate-anchor")),m=ot(this.collisionIndex.transform,i,l.get("icon-translate"),l.get("icon-translate-anchor")),_=Ld(p,this.transform,d);this.retainedQueryData[n.bucketInstanceId]=new hf(n.bucketInstanceId,s,n.sourceLayerIndex,n.index,i.tileID);const g={bucket:n,layout:a,translationText:f,translationIcon:m,unwrappedTileID:u,pitchedLabelPlaneMatrix:_,scale:c,textPixelRatio:h,holdingForFade:i.holdingForFade(),collisionBoxArray:o,partiallyEvaluatedTextSize:Ru(n.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=e;t.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:g})}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:g})}attemptAnchorPlacement(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x){const v=of[t.textAnchor],b=[t.textOffset0,t.textOffset1],w=pf(v,i,r,b,n),T=this.collisionIndex.placeCollisionBox(e,u,a,l,c,o,s,m,h.predicate,y,w,x);if((!g||this.collisionIndex.placeCollisionBox(g,u,a,l,c,o,s,_,h.predicate,y,w,x).placeable)&&T.placeable){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID].text&&(t=this.prevPlacement.variableOffsets[p.crossTileID].anchor),0===p.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[p.crossTileID]={textOffset:b,width:i,height:r,anchor:v,textBoxScale:n,prevAnchor:t},this.markUsedJustification(d,v,p,f),d.allowVerticalPlacement&&(this.markUsedOrientation(d,f,p),this.placedOrientations[p.crossTileID]=f),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,e,i){const{bucket:r,layout:n,translationText:s,translationIcon:o,unwrappedTileID:a,pitchedLabelPlaneMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:p,collisionGroup:d}=t.parameters,f=n.get("text-optional"),m=n.get("icon-optional"),_=Lu(n,"text-overlap","text-allow-overlap"),g="always"===_,y=Lu(n,"icon-overlap","icon-allow-overlap"),x="always"===y,v="map"===n.get("text-rotation-alignment"),b="map"===n.get("text-pitch-alignment"),w="none"!==n.get("icon-text-fit"),T="viewport-y"===n.get("symbol-z-order"),P=g&&(x||!r.hasIconData()||m),S=x&&(g||!r.hasTextData()||f);!r.collisionArrays&&u&&r.deserializeCollisionBoxes(u);const M=this.retainedQueryData[r.bucketInstanceId].tileID,I=this._getTerrainElevationFunc(M),C=this.transform.getFastPathSimpleProjectionMatrix(M),E=(t,u,x)=>{var T,E;if(e[t.crossTileID])return;if(h)return void(this.placements[t.crossTileID]=new cf(!1,!1,!1));let A=!1,z=!1,k=!0,D=null,R={box:null,placeable:!1,offscreen:null,occluded:!1},L={placeable:!1},B=null,F=null,O=null,j=0,V=0,N=0;u.textFeatureIndex?j=u.textFeatureIndex:t.useRuntimeCollisionCircles&&(j=t.featureIndex),u.verticalTextFeatureIndex&&(V=u.verticalTextFeatureIndex);const U=u.textBox;if(U){const e=e=>{let i=Au.horizontal;if(r.allowVerticalPlacement&&!e&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,i=e,this.markUsedOrientation(r,i,t))}return i},n=(e,i)=>{if(r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&u.verticalTextBox){for(const t of r.writingModes)if(t===Au.vertical?(R=i(),L=R):R=e(),R&&R.placeable)break}else R=e()},l=t.textAnchorOffsetStartIndex,h=t.textAnchorOffsetEndIndex;if(h===l){const i=(e,i)=>{const n=this.collisionIndex.placeCollisionBox(e,_,c,M,a,b,v,s,d.predicate,I,void 0,C);return n&&n.placeable&&(this.markUsedOrientation(r,i,t),this.placedOrientations[t.crossTileID]=i),n};n((()=>i(U,Au.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&e?i(e,Au.vertical):{box:null,offscreen:null}})),e(R&&R.placeable)}else{let p=of[null===(E=null===(T=this.prevPlacement)||void 0===T?void 0:T.variableOffsets[t.crossTileID])||void 0===E?void 0:E.anchor];const f=(e,n,u)=>{const f=e.x2-e.x1,m=e.y2-e.y1,g=t.textBoxScale,x=w&&"never"===y?n:null;let T=null,P="never"===_?1:2,S="never";p&&P++;for(let i=0;i<P;i++){for(let i=l;i<h;i++){const n=r.textAnchorOffsets.get(i);if(p&&n.textAnchor!==p)continue;const l=this.attemptAnchorPlacement(n,e,f,m,g,v,b,c,M,a,d,S,t,r,u,s,o,x,I);if(l&&(T=l.placedGlyphBoxes,T&&T.placeable))return A=!0,D=l.shift,T}p?p=null:S=_}return i&&!T&&(T={box:this.collisionIndex.placeCollisionBox(U,"always",c,M,a,b,v,s,d.predicate,I,void 0,C).box,offscreen:!1,placeable:!1,occluded:!1}),T};n((()=>f(U,u.iconBox,Au.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&(!R||!R.placeable)&&t.numVerticalGlyphVertices>0&&e?f(e,u.verticalIconBox,Au.vertical):{box:null,occluded:!0,offscreen:null}})),R&&(A=R.placeable,k=R.offscreen);const m=e(R&&R.placeable);if(!A&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(r,e.anchor,t,m))}}}if(B=R,A=B&&B.placeable,k=B&&B.offscreen,t.useRuntimeCollisionCircles){const e=r.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),o=Du(r.textSizeData,p,e),c=n.get("text-padding");F=this.collisionIndex.placeCollisionCircles(_,e,r.lineVertexArray,r.glyphOffsetArray,o,a,l,i,b,d.predicate,t.collisionCircleDiameter,c,s,I),F.circles.length&&F.collisionDetected&&!i&&Dt("Collisions detected, but collision boxes are not shown"),A=g||F.circles.length>0&&!F.collisionDetected,k=k&&F.offscreen}if(u.iconFeatureIndex&&(N=u.iconFeatureIndex),u.iconBox){const t=t=>this.collisionIndex.placeCollisionBox(t,y,c,M,a,b,v,o,d.predicate,I,w&&D?D:void 0,C);L&&L.placeable&&u.verticalIconBox?(O=t(u.verticalIconBox),z=O.placeable):(O=t(u.iconBox),z=O.placeable),k=k&&O.offscreen}const Z=f||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=m||0===t.numIconVertices;Z||G?G?Z||(z=z&&A):A=z&&A:z=A=z&&A;const $=z&&O.placeable;if(A&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,_,n.get("text-ignore-placement"),r.bucketInstanceId,L&&L.placeable&&V?V:j,d.ID),$&&this.collisionIndex.insertCollisionBox(O.box,y,n.get("icon-ignore-placement"),r.bucketInstanceId,N,d.ID),F&&A&&this.collisionIndex.insertCollisionCircles(F.circles,_,n.get("text-ignore-placement"),r.bucketInstanceId,j,d.ID),i&&this.storeCollisionData(r.bucketInstanceId,x,u,B,O,F),0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new cf((A||P)&&!(null==B?void 0:B.occluded),(z||S)&&!(null==O?void 0:O.occluded),k||r.justReloaded),e[t.crossTileID]=!0};if(T){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let t=e.length-1;t>=0;--t){const i=e[t];E(r.symbolInstances.get(i),r.collisionArrays[i],i)}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)E(r.symbolInstances.get(e),r.collisionArrays[e],e);r.justReloaded=!1}storeCollisionData(t,e,i,r,n,s){if(i.textBox||i.iconBox){let s,o;this.collisionBoxArrays.has(t)?s=this.collisionBoxArrays.get(t):(s=new Map,this.collisionBoxArrays.set(t,s)),s.has(e)?o=s.get(e):(o={text:null,icon:null},s.set(e,o)),i.textBox&&(o.text=r.box),i.iconBox&&(o.icon=n.box)}if(s){let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=[]);for(let t=0;t<s.circles.length;t+=4)e.push(s.circles[t+0]-rf),e.push(s.circles[t+1]-rf),e.push(s.circles[t+2]),e.push(s.collisionDetected?1:0)}}markUsedJustification(t,e,i,r){let n;n=r===Au.vertical?i.verticalPlacedTextSymbolIndex:{left:i.leftJustifiedTextSymbolIndex,center:i.centerJustifiedTextSymbolIndex,right:i.rightJustifiedTextSymbolIndex}[function(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(e)];const s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex,i.verticalPlacedTextSymbolIndex];for(const e of s)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=n>=0&&e!==n?0:i.crossTileID)}markUsedOrientation(t,e,i){const r=e===Au.horizontal||e===Au.horizontalOnly?e:0,n=e===Au.vertical?e:0,s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex];for(const e of s)t.text.placedSymbolArray.get(e).placedOrientation=r;i.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(i.verticalPlacedTextSymbolIndex).placedOrientation=n)}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const r=e?e.symbolFadeChange(t):1,n=e?e.opacities:{},s=e?e.variableOffsets:{},o=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],s=n[t];s?(this.opacities[t]=new lf(s,r,e.text,e.icon),i=i||e.text!==s.text.placed||e.icon!==s.icon.placed):(this.opacities[t]=new lf(null,r,e.text,e.icon,e.skipFade),i=i||e.text||e.icon)}for(const t in n){const e=n[t];if(!this.opacities[t]){const n=new lf(e,r,!1,!1);n.isHidden()||(this.opacities[t]=n,i=i||e.text.placed||e.icon.placed)}}for(const t in s)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=s[t]);for(const t in o)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=o[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t)}updateLayerOpacities(t,e){const i={};for(const r of e){const e=r.getBucket(t);e&&r.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,r.tileID,i,r.collisionBoxArray)}}updateBucketOpacities(t,e,i,r){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const n=t.layers[0],o=n.layout,a=new lf(null,0,!1,!1,!0),l=o.get("text-allow-overlap"),c=o.get("icon-allow-overlap"),h=n._unevaluatedLayout.hasValue("text-variable-anchor")||n._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===o.get("text-rotation-alignment"),p="map"===o.get("text-pitch-alignment"),d="none"!==o.get("icon-text-fit"),f=new lf(null,0,l&&(c||!t.hasIconData()||o.get("icon-optional")),c&&(l||!t.hasTextData()||o.get("text-optional")),!0);!t.collisionArrays&&r&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(r);const m=(t,e,i)=>{for(let r=0;r<e/4;r++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==Tf},_=this.collisionBoxArrays.get(t.bucketInstanceId);for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:o,crossTileID:l}=r;let c=this.opacities[l];i[l]?c=a:c||(c=f,this.opacities[l]=c),i[l]=!0;const g=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],x=y===Au.vertical,v=y===Au.horizontal||y===Au.horizontalOnly;if(n>0||o>0){const e=wf(c.text);m(t.text,n,x?Tf:e),m(t.text,o,v?Tf:e);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||x?1:0)})),r.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const s=this.variableOffsets[r.crossTileID];s&&this.markUsedJustification(t,s.anchor,r,y);const a=this.placedOrientations[r.crossTileID];a&&(this.markUsedJustification(t,"left",r,a),this.markUsedOrientation(t,a,r))}if(g){const e=wf(c.icon),i=!(d&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(t.icon,r.numIconVertices,i?e:Tf),t.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(t.icon,r.numVerticalIconVertices,i?Tf:e),t.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden())}const b=_&&_.has(e)?_.get(e):{text:null,icon:null};if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[e];if(i){let e=new s(0,0);if(i.textBox||i.verticalTextBox){let r=!0;if(h){const t=this.variableOffsets[l];t?(e=pf(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),u&&e._rotate(p?-this.transform.bearingInRadians:this.transform.bearingInRadians)):r=!1}if(i.textBox||i.verticalTextBox){let n;i.textBox&&(n=x),i.verticalTextBox&&(n=v),ff(t.textCollisionBox.collisionVertexArray,c.text.placed,!r||n,b.text,e.x,e.y)}}if(i.iconBox||i.verticalIconBox){const r=Boolean(!v&&i.verticalIconBox);let n;i.iconBox&&(n=r),i.verticalIconBox&&(n=!r),ff(t.iconCollisionBox.collisionVertexArray,c.icon.placed,n,b.icon,d?e.x:0,d?e.y:0)}}}}if(t.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);t.bucketInstanceId in this.collisionCircleArrays&&(t.collisionCircleArray=this.collisionCircleArrays[t.bucketInstanceId],delete this.collisionCircleArrays[t.bucketInstanceId])}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0}}function ff(t,e,i,r,n,s){r&&0!==r.length||(r=[0,0,0,0]);const o=r[0]-rf,a=r[1]-rf,l=r[2]-rf,c=r[3]-rf;t.emplaceBack(e?1:0,i?1:0,n||0,s||0,o,a),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,l,a),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,l,c),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,o,c)}const mf=Math.pow(2,25),_f=Math.pow(2,24),gf=Math.pow(2,17),yf=Math.pow(2,16),xf=Math.pow(2,9),vf=Math.pow(2,8),bf=Math.pow(2,1);function wf(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*mf+e*_f+i*gf+e*yf+i*xf+e*vf+i*bf+e}const Tf=0;class Pf{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[]}continuePlacement(t,e,i,r,n){const s=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(s,r,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,s.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<s.length;)if(e.placeLayerBucketPart(s[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,n())return!0;return!1}}class Sf{constructor(t,e,i,r,n,s,o,a){this.placement=new df(t,e,s,o,a),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=n,this._done=!1}isDone(){return this._done}continuePlacement(t,e,i){const r=Qt.now(),n=()=>!this._forceFullPlacement&&Qt.now()-r>2;for(;this._currentPlacementIndex>=0;){const r=e[t[this._currentPlacementIndex]],s=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=s)&&(!r.maxzoom||r.maxzoom>s)){if(this._inProgressLayer||(this._inProgressLayer=new Pf(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,n))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(t){return this.placement.commit(t),this.placement}}const Mf=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class If{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,i]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=Mf[15&i];if(!n)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new If(o,s,n,t)}constructor(t,e=64,i=Float64Array,r){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=i,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const n=Mf.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=t,this.coords[this._pos++]=e,i}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Cf(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:s,nodeSize:o}=this,a=[0,n.length-1,0],l=[];for(;a.length;){const c=a.pop()||0,h=a.pop()||0,u=a.pop()||0;if(h-u<=o){for(let o=u;o<=h;o++){const a=s[2*o],c=s[2*o+1];a>=t&&a<=i&&c>=e&&c<=r&&l.push(n[o])}continue}const p=u+h>>1,d=s[2*p],f=s[2*p+1];d>=t&&d<=i&&f>=e&&f<=r&&l.push(n[p]),(0===c?t<=d:e<=f)&&(a.push(u),a.push(p-1),a.push(1-c)),(0===c?i>=d:r>=f)&&(a.push(p+1),a.push(h),a.push(1-c))}return l}within(t,e,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:s}=this,o=[0,r.length-1,0],a=[],l=i*i;for(;o.length;){const c=o.pop()||0,h=o.pop()||0,u=o.pop()||0;if(h-u<=s){for(let i=u;i<=h;i++)kf(n[2*i],n[2*i+1],t,e)<=l&&a.push(r[i]);continue}const p=u+h>>1,d=n[2*p],f=n[2*p+1];kf(d,f,t,e)<=l&&a.push(r[p]),(0===c?t-i<=d:e-i<=f)&&(o.push(u),o.push(p-1),o.push(1-c)),(0===c?t+i>=d:e+i>=f)&&(o.push(p+1),o.push(h),o.push(1-c))}return a}}function Cf(t,e,i,r,n,s){if(n-r<=i)return;const o=r+n>>1;Ef(t,e,o,r,n,s),Cf(t,e,i,r,o-1,1-s),Cf(t,e,i,o+1,n,1-s)}function Ef(t,e,i,r,n,s){for(;n>r;){if(n-r>600){const o=n-r+1,a=i-r+1,l=Math.log(o),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(o-c)/o)*(a-o/2<0?-1:1);Ef(t,e,i,Math.max(r,Math.floor(i-a*c/o+h)),Math.min(n,Math.floor(i+(o-a)*c/o+h)),s)}const o=e[2*i+s];let a=r,l=n;for(Af(t,e,r,i),e[2*n+s]>o&&Af(t,e,r,n);a<l;){for(Af(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--}e[2*r+s]===o?Af(t,e,r,l):(l++,Af(t,e,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function Af(t,e,i,r){zf(t,i,r),zf(e,2*i,2*r),zf(e,2*i+1,2*r+1)}function zf(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function kf(t,e,i,r){const n=t-i,s=e-r;return n*n+s*s}const Df=.03125;class Rf{constructor(t,e,i){this.tileID=t,this.bucketInstanceId=i,this._symbolsByKey={};const r=new Map;for(let t=0;t<e.length;t++){const i=e.get(t),n=i.key,s=r.get(n);s?s.push(i):r.set(n,[i])}for(const[t,e]of r){const i={positions:e.map((t=>({x:Math.floor(t.anchorX*Df),y:Math.floor(t.anchorY*Df)}))),crossTileIDs:e.map((t=>t.crossTileID))};if(i.positions.length>128){const t=new If(i.positions.length,16,Uint16Array);for(const{x:e,y:r}of i.positions)t.add(e,r);t.finish(),delete i.positions,i.index=t}this._symbolsByKey[t]=i}}getScaledCoordinates(t,e){const{x:i,y:r,z:n}=this.tileID.canonical,{x:s,y:o,z:a}=e.canonical,l=Df/Math.pow(2,a-n),c=(o*Q+t.anchorY)*l,h=r*Q*Df;return{x:Math.floor((s*Q+t.anchorX)*l-i*Q*Df),y:Math.floor(c-h)}}findMatches(t,e,i){const r=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let n=0;n<t.length;n++){const s=t.get(n);if(s.crossTileID)continue;const o=this._symbolsByKey[s.key];if(!o)continue;const a=this.getScaledCoordinates(s,e);if(o.index){const t=o.index.range(a.x-r,a.y-r,a.x+r,a.y+r).sort();for(const e of t){const t=o.crossTileIDs[e];if(!i[t]){i[t]=!0,s.crossTileID=t;break}}}else if(o.positions)for(let t=0;t<o.positions.length;t++){const e=o.positions[t],n=o.crossTileIDs[t];if(Math.abs(e.x-a.x)<=r&&Math.abs(e.y-a.y)<=r&&!i[n]){i[n]=!0,s.crossTileID=n;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class Lf{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class Bf{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],r={};for(const t in i){const n=i[t];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),r[n.tileID.key]=n}this.indexes[t]=r}this.lng=t}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key])}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const r=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in n){const s=n[i];s.tileID.isChildOf(t)&&s.findMatches(e.symbolInstances,t,r)}else{const s=n[t.scaledTo(Number(i)).key];s&&s.findMatches(e.symbolInstances,t,r)}}for(let t=0;t<e.symbolInstances.length;t++){const n=e.symbolInstances.get(t);n.crossTileID||(n.crossTileID=i.generate(),r[n.crossTileID]=!0)}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new Rf(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e]}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)t[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],e=!0)}return e}}class Ff{constructor(){this.layerIndexes={},this.crossTileIDs=new Lf,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(t,e,i){let r=this.layerIndexes[t.id];void 0===r&&(r=this.layerIndexes[t.id]=new Bf);let n=!1;const s={};r.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,e,this.crossTileIDs)&&(n=!0),s[e.bucketInstanceId]=!0)}return r.removeStaleBuckets(s)&&(n=!0),n}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t]}}var Of="void main() {fragColor=vec4(1.0);}";const jf={prelude:Vf("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:Vf("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:Vf("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:Vf("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:Vf("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:Vf("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:Vf(Of,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:Vf("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:Vf("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:Vf("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Vf("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:Vf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:Vf("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:Vf(Of,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:Vf("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:Vf("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:Vf("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:Vf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:Vf("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:Vf("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:Vf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Vf("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:Vf("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:Vf("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:Vf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:Vf("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:Vf("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:Vf("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:Vf("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:Vf("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:Vf("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:Vf("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:Vf("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:Vf("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:Vf("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:Vf("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function Vf(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=e.match(/in ([\w]+) ([\w]+)/g),n=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=s?s.concat(n):n,a={};return{fragmentSource:t=t.replace(i,((t,e,i,r,n)=>(a[n]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nin ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = u_${n};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,r,n)=>{const s="float"===r?"vec2":"vec4",o=n.match(/color/)?"color":s;return a[n]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\nout ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===o?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${o}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===o?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = unpack_mix_${o}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`})),staticAttributes:r,staticUniforms:o}}class Nf{constructor(t,e,i){this.vertexBuffer=t,this.indexBuffer=e,this.segments=i}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null}}var Uf=Yo([{name:"a_pos",type:"Int16",components:2}]);const Zf="#define PROJECTION_MERCATOR",Gf="mercator";class $f{constructor(){this._cachedMesh=null}get name(){return"mercator"}get useSubdivision(){return!1}get shaderVariantName(){return Gf}get shaderDefine(){return Zf}get shaderPreludeCode(){return jf.projectionMercator}get vertexShaderPreludeCode(){return jf.projectionMercator.vertexSource}get subdivisionGranularity(){return lh.noSubdivision}get useGlobeControls(){return!1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(t){}getMeshFromTileID(t,e,i,r,n){if(this._cachedMesh)return this._cachedMesh;const s=new Da;s.emplaceBack(0,0),s.emplaceBack(Q,0),s.emplaceBack(0,Q),s.emplaceBack(Q,Q);const o=t.createVertexBuffer(s,Uf.members),a=tl.simpleSegment(0,0,4,2),l=new Xa;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3);const c=t.createIndexBuffer(l);return this._cachedMesh=new Nf(o,c,a),this._cachedMesh}recalculate(){}hasTransition(){return!1}setErrorQueryLatitudeDegrees(t){}}class qf{constructor(t=0,e=0,i=0,r=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=r}interpolate(t,e,i){return null!=e.top&&null!=t.top&&(this.top=xr.number(t.top,e.top,i)),null!=e.bottom&&null!=t.bottom&&(this.bottom=xr.number(t.bottom,e.bottom,i)),null!=e.left&&null!=t.left&&(this.left=xr.number(t.left,e.left,i)),null!=e.right&&null!=t.right&&(this.right=xr.number(t.right,e.right,i)),this}getCenter(t,e){return new s(vt((this.left+t-this.right)/2,0,t),vt((this.top+e-this.bottom)/2,0,e))}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new qf(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Wf(t,e){if(!t.renderWorldCopies||t.lngRange)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0}function Hf(t){return Math.max(0,Math.floor(t))}class Xf{constructor(t,e,i,r,n,s){this._callbacks=t,this._tileSize=512,this._renderWorldCopies=void 0===s||!!s,this._minZoom=e||0,this._maxZoom=i||22,this._minPitch=null==r?0:r,this._maxPitch=null==n?60:n,this.setMaxBounds(),this._width=0,this._height=0,this._center=new Dp(0,0),this._elevation=0,this._zoom=0,this._tileZoom=Hf(this._zoom),this._scale=Mt(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new qf,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0}apply(t,e,i){this._latRange=t.latRange,this._lngRange=t.lngRange,this._width=t.width,this._height=t.height,this._center=t.center,this._elevation=t.elevation,this._minElevationForCurrentTile=t.minElevationForCurrentTile,this._zoom=t.zoom,this._tileZoom=Hf(this._zoom),this._scale=Mt(this._zoom),this._bearingInRadians=t.bearingInRadians,this._fovInRadians=t.fovInRadians,this._pitchInRadians=t.pitchInRadians,this._rollInRadians=t.rollInRadians,this._unmodified=t.unmodified,this._edgeInsets=new qf(t.padding.top,t.padding.bottom,t.padding.left,t.padding.right),this._minZoom=t.minZoom,this._maxZoom=t.maxZoom,this._minPitch=t.minPitch,this._maxPitch=t.maxPitch,this._renderWorldCopies=t.renderWorldCopies,this._cameraToCenterDistance=t.cameraToCenterDistance,this._nearZ=t.nearZ,this._farZ=t.farZ,this._autoCalculateNearFarZ=!i&&t.autoCalculateNearFarZ,e&&this._constrain(),this._calcMatrices()}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(t){this._minElevationForCurrentTile=t}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(t){this._minZoom!==t&&(this._minZoom=t,this.setZoom(this.getConstrained(this._center,this.zoom).zoom))}get maxZoom(){return this._maxZoom}setMaxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.setZoom(this.getConstrained(this._center,this.zoom).zoom))}get minPitch(){return this._minPitch}setMinPitch(t){this._minPitch!==t&&(this._minPitch=t,this.setPitch(Math.max(this.pitch,t)))}get maxPitch(){return this._maxPitch}setMaxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.setPitch(Math.min(this.pitch,t)))}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new s(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(t){const e=bt(t,-180,180)*Math.PI/180;var i,r,n,s,o,a,l,c,h;this._bearingInRadians!==e&&(this._unmodified=!1,this._bearingInRadians=e,this._calcMatrices(),this._rotationMatrix=f(),i=this._rotationMatrix,n=-this._bearingInRadians,s=(r=this._rotationMatrix)[0],o=r[1],a=r[2],l=r[3],c=Math.sin(n),h=Math.cos(n),i[0]=s*h+a*c,i[1]=o*h+l*c,i[2]=s*-c+a*h,i[3]=o*-c+l*h)}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(t){const e=vt(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==e&&(this._unmodified=!1,this._pitchInRadians=e,this._calcMatrices())}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(t){const e=t/180*Math.PI;this._rollInRadians!==e&&(this._unmodified=!1,this._rollInRadians=e,this._calcMatrices())}get fovInRadians(){return this._fovInRadians}get fov(){return Nt(this._fovInRadians)}setFov(t){t=vt(t,.1,150),this.fov!==t&&(this._unmodified=!1,this._fovInRadians=Vt(t),this._calcMatrices())}get zoom(){return this._zoom}setZoom(t){const e=this.getConstrained(this._center,t).zoom;this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this._tileZoom=Math.max(0,Math.floor(e)),this._scale=Mt(e),this._constrain(),this._calcMatrices())}get center(){return this._center}setCenter(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._constrain(),this._calcMatrices())}get elevation(){return this._elevation}setElevation(t){t!==this._elevation&&(this._elevation=t,this._constrain(),this._calcMatrices())}get padding(){return this._edgeInsets.toJSON()}setPadding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices())}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(t,e){this._autoCalculateNearFarZ=!1,this._nearZ=t,this._farZ=e,this._calcMatrices()}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices()}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices()}resize(t,e,i=!0){this._width=t,this._height=e,i&&this._constrain(),this._calcMatrices()}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new Rp([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(t){t?(this._lngRange=[t.getWest(),t.getEast()],this._latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this._lngRange=null,this._latRange=[-85.051129,$t])}getConstrained(t,e){return this._callbacks.getConstrained(t,e)}getCameraQueryGeometry(t,e){if(1===e.length)return[e[0],t];{const{minX:i,minY:r,maxX:n,maxY:o}=Qp.fromPoints(e).extend(t);return[new s(i,r),new s(n,r),new s(n,o),new s(i,o),new s(i,r)]}}_constrain(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const t=this._unmodified,{center:e,zoom:i}=this.getConstrained(this.center,this.zoom);this.setCenter(e),this.setZoom(i),this._unmodified=t,this._constraining=!1}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let t=y(new Float64Array(16));w(t,t,[this._width/2,-this._height/2,1]),b(t,t,[1,-1,0]),this._clipSpaceToPixelsMatrix=t,t=y(new Float64Array(16)),w(t,t,[1,-1,1]),b(t,t,[-1,-1,0]),w(t,t,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=t,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height}this._callbacks.calcMatrices()}calculateCenterFromCameraLngLatAlt(t,e,i,r){const n=void 0!==i?i:this.bearing,s=r=void 0!==r?r:this.pitch,o=Up.fromLngLat(t,e),a=-Math.cos(Vt(s)),l=Math.sin(Vt(s)),c=l*Math.sin(Vt(n)),h=-l*Math.cos(Vt(n));let u=this.elevation;const p=e-u;let d;a*p>=0||Math.abs(a)<.1?(d=1e4,u=e+d*a):d=-p/a;let f,m,_=Np(1,o.y),g=0;do{if(g+=1,g>10)break;m=d/_,f=new Up(o.x+c*m,o.y+h*m),_=1/f.meterInMercatorCoordinateUnits()}while(Math.abs(d-m*_)>1e-12);return{center:f.toLngLat(),elevation:u,zoom:It(this.height/2/Math.tan(this.fovInRadians/2)/m/this.tileSize)}}recalculateZoomAndCenter(t){if(this.elevation-t==0)return;const e=jp(1,this.center.lat)*this.worldSize,i=this.cameraToCenterDistance/e,r=Up.fromLngLat(this.center,this.elevation),n=bd(this.center,this.elevation,this.pitch,this.bearing,i);this._elevation=t;const s=this.calculateCenterFromCameraLngLatAlt(n.toLngLat(),Np(n.z,r.y),this.bearing,this.pitch);this._elevation=s.elevation,this._center=s.center,this.setZoom(s.zoom)}getCameraPoint(){const t=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new s(t*Math.sin(this.rollInRadians),t*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const t=jp(1,this.center.lat)*this.worldSize;return bd(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/t).toLngLat()}getMercatorTileCoordinates(t){if(!t)return[0,0,1,1];const e=t.canonical.z>=0?1<<t.canonical.z:Math.pow(2,t.canonical.z);return[t.canonical.x/e,t.canonical.y/e,1/e/Q,1/e/Q]}}class Yf{constructor(t,e){this.min=t,this.max=e,this.center=D([],k([],this.min,this.max),.5)}quadrant(t){const e=[t%2==0,t<2],i=E(this.min),r=E(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],r[t]=e[t]?this.center[t]:this.max[t];return r[2]=this.max[2],new Yf(i,r)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersectsFrustum(t){let e=!0;for(let i=0;i<t.planes.length;i++){const r=this.intersectsPlane(t.planes[i]);if(0===r)return 0;1===r&&(e=!1)}return e?2:t.aabb.min[0]>this.max[0]||t.aabb.min[1]>this.max[1]||t.aabb.min[2]>this.max[2]||t.aabb.max[0]<this.min[0]||t.aabb.max[1]<this.min[1]||t.aabb.max[2]<this.min[2]?0:1}intersectsPlane(t){let e=t[3],i=t[3];for(let r=0;r<3;r++)t[r]>0?(e+=t[r]*this.min[r],i+=t[r]*this.max[r]):(i+=t[r]*this.min[r],e+=t[r]*this.max[r]);return e>=0?2:i<0?0:1}}class Kf{distanceToTile2d(t,e,i,r){const n=r.distanceX([t,e]),s=r.distanceY([t,e]);return Math.hypot(n,s)}getWrap(t,e,i){return i}getTileBoundingVolume(t,e,i,r){var n,s;let o=0,a=0;if(null==r?void 0:r.terrain){const l=new Xp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);o=null!==(n=c.minElevation)&&void 0!==n?n:Math.min(0,i),a=null!==(s=c.maxElevation)&&void 0!==s?s:Math.max(0,i)}const l=1<<t.z;return new Yf([e+t.x/l,t.y/l,o],[e+(t.x+1)/l,(t.y+1)/l,a])}allowVariableZoom(t,e){const i=vt(78.5-t.fov*(Math.abs(Math.cos(t.rollInRadians))*t.height+Math.abs(Math.sin(t.rollInRadians))*t.width)/t.height/2,0,60);return!!e.terrain||t.pitch>i}allowWorldCopies(){return!0}prepareNextFrame(){}}class Jf{constructor(t,e,i){this.points=t,this.planes=e,this.aabb=i}static fromInvProjectionMatrix(t,e=1,i=0,r,n){const s=n?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],o=Math.pow(2,i),a=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>function(t,e,i,r){const n=G([],t,e),s=1/n[3]/i*r;return function(t,e,i){return t[0]=e[0]*i[0],t[1]=e[1]*i[1],t[2]=e[2]*i[2],t[3]=e[3]*i[3],t}(n,n,[s,s,1/n[3],s])}(i,t,e,o)));r&&function(t,e,i,r){const n=r?4:0,s=r?0:4;let o=0;const a=[],l=[];for(let e=0;e<4;e++){const i=U([],t[e+s],t[e+n]),r=A(i);D(i,i,1/r),a.push(r),l.push(i)}for(let e=0;e<4;e++){const r=ct(t[e+n],l[e],i);o=null!==r&&r>=0?Math.max(o,r):Math.max(o,a[e])}const c=function(t,e){const i=[0,0,0,0];return R(i,B([],U([],t[e[0]],t[e[1]]),U([],t[e[2]],t[e[1]]))),i[3]=-L(i,t[e[0]]),i}(t,e),h=function(t,e){const i=Z(t),r=((o=[])[0]=(a=t)[0]*(l=1/i),o[1]=a[1]*l,o[2]=a[2]*l,o[3]=a[3]*l,o),n=U([],e,D([],r,L(e,r))),s=Z(n);var o,a,l;if(s>0){const t=Math.sqrt(1-r[3]*r[3]);return at(e,k([],D([],r,-r[3]),D([],n,t/s)))}return null}(i,c);if(null!==h){const t=h/L(l[0],c);o=Math.min(o,t)}for(let e=0;e<4;e++){const i=Math.min(o,a[e]);t[e+s]=[t[e+n][0]+l[e][0]*i,t[e+n][1]+l[e][1]*i,t[e+n][2]+l[e][2]*i,1]}}(a,s[0],r,n);const l=s.map((t=>{const e=R([],B([],U([],a[t[0]],a[t[1]]),U([],a[t[2]],a[t[1]]))),i=-L(e,a[t[1]]);return e.concat(i)})),c=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],h=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const t of a)for(let e=0;e<3;e++)c[e]=Math.min(c[e],t[e]),h[e]=Math.max(h[e],t[e]);return new Jf(a,l,new Yf(c,h))}}class Qf{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t,e){}constructor(t,e,i,r,n){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this._helper=new Xf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)},t,e,i,r,n),this._coveringTilesDetailsProvider=new Kf}clone(){const t=new Qf;return t.apply(this),t}apply(t,e,i){this._helper.apply(t,e,i)}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(t){const e=[new Hp(0,t)];if(this._helper._renderWorldCopies){const i=this.screenPointToMercatorCoordinate(new s(0,0)),r=this.screenPointToMercatorCoordinate(new s(this._helper._width,0)),n=this.screenPointToMercatorCoordinate(new s(this._helper._width,this._helper._height)),o=this.screenPointToMercatorCoordinate(new s(0,this._helper._height)),a=Math.floor(Math.min(i.x,r.x,n.x,o.x)),l=Math.floor(Math.max(i.x,r.x,n.x,o.x)),c=1;for(let i=a-c;i<=l+c;i++)0!==i&&e.push(new Hp(i,t))}return e}getCameraFrustum(){return Jf.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){const e=this.screenPointToLocation(this.centerPoint,t),i=t?t.getElevationForLngLatZoom(e,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i)}setLocationAtPoint(t,e){const i=jp(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(e,i),n=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,i),s=Up.fromLngLat(t),o=new Up(s.x-(r.x-n.x),s.y-(r.y-n.y));this.setCenter(null==o?void 0:o.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap())}locationToScreenPoint(t,e){return e?this.coordinatePoint(Up.fromLngLat(t),e.getElevationForLngLatZoom(t,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(Up.fromLngLat(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(t)}screenPointToMercatorCoordinateAtZ(t,e){const i=e||0,r=[t.x,t.y,0,1],n=[t.x,t.y,1,1];G(r,r,this._pixelMatrixInverse),G(n,n,this._pixelMatrixInverse);const s=r[3],o=n[3],a=r[1]/s,l=n[1]/o,c=r[2]/s,h=n[2]/o,u=c===h?0:(i-c)/(h-c);return new Up(xr.number(r[0]/s,n[0]/o,u)/this.worldSize,xr.number(a,l,u)/this.worldSize,i)}coordinatePoint(t,e=0,i=this._pixelMatrix){const r=[t.x*this.worldSize,t.y*this.worldSize,e,1];return G(r,r,i),new s(r[0]/r[3],r[1]/r[3])}getBounds(){const t=Math.max(0,this._helper._height/2-xd(this));return(new Rp).extend(this.screenPointToLocation(new s(0,t))).extend(this.screenPointToLocation(new s(this._helper._width,t))).extend(this.screenPointToLocation(new s(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new s(0,this._helper._height)))}isPointOnMapSurface(t,e){return e?null!=e.pointCoordinate(t):t.y>this.height/2-xd(this)}calculatePosMatrix(t,e=!1,i){var r;const n=null!==(r=t.key)&&void 0!==r?r:Yp(t.wrap,t.canonical.z,t.canonical.z,t.canonical.x,t.canonical.y),s=e?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(n)){const t=s.get(n);return i?t.f32:t.f64}const o=vd(t,this.worldSize);v(o,e?this._alignedProjMatrix:this._viewProjMatrix,o);const a={f64:o,f32:new Float32Array(o)};return s.set(n,a),i?a.f32:a.f64}calculateFogMatrix(t){const e=t.key,i=this._fogMatrixCacheF32;if(i.has(e))return i.get(e);const r=vd(t,this.worldSize);return v(r,this._fogMatrix,r),i.set(e,new Float32Array(r)),i.get(e)}getConstrained(t,e){e=vt(+e,this.minZoom,this.maxZoom);const i={center:new Dp(t.lng,t.lat),zoom:e};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const t=180-1e-10;r=[-t,t]}const n=this.tileSize*Mt(i.zoom);let o=0,a=n,l=0,c=n,h=0,u=0;const{x:p,y:d}=this.size;if(this._helper._latRange){const t=this._helper._latRange;o=Op(t[1])*n,a=Op(t[0])*n,a-o<d&&(h=d/(a-o))}r&&(l=bt(Fp(r[0])*n,0,n),c=bt(Fp(r[1])*n,0,n),c<l&&(c+=n),c-l<p&&(u=p/(c-l)));const{x:f,y:m}=gd(n,t);let _,g;const y=Math.max(u||0,h||0);if(y){const t=new s(u?(c+l)/2:f,h?(a+o)/2:m);return i.center=yd(n,t).wrap(),i.zoom+=It(y),i}if(this._helper._latRange){const t=d/2;m-t<o&&(g=o+t),m+t>a&&(g=a-t)}if(r){const t=(l+c)/2;let e=f;this._helper._renderWorldCopies&&(e=bt(f,t-n/2,t+n/2));const i=p/2;e-i<l&&(_=l+i),e+i>c&&(_=c-i)}if(void 0!==_||void 0!==g){const t=new s(null!=_?_:f,null!=g?g:m);i.center=yd(n,t).wrap()}return i}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}_calculateNearFarZIfNeeded(t,e,i){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),n=t-r*this._helper._pixelPerMeter/Math.cos(e),s=r<0?n:t,o=Math.PI/2+this.pitchInRadians,a=Vt(this.fov)*(Math.abs(Math.cos(Vt(this.roll)))*this.height+Math.abs(Math.sin(Vt(this.roll)))*this.width)/this.height*(.5+i.y/this.height),l=Math.sin(a)*s/Math.sin(vt(Math.PI-o-a,.01,Math.PI-.01)),c=xd(this),h=Math.atan(c/this._helper.cameraToCenterDistance),u=Vt(.75),p=h>u?2*h*(.5+i.y/(2*c)):u,d=Math.sin(p)*s/Math.sin(vt(Math.PI-o-p,.01,Math.PI-.01)),f=Math.min(l,d);this._helper._farZ=1.01*(Math.cos(Math.PI/2-e)*f+s),this._helper._nearZ=this._helper._height/50}_calcMatrices(){if(!this._helper._height)return;const t=this.centerOffset,e=gd(this.worldSize,this.center),i=e.x,r=e.y;this._helper._pixelPerMeter=jp(1,this.center.lat)*this.worldSize;const n=Vt(Math.min(this.pitch,_d)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(n));let o;this._calculateNearFarZIfNeeded(s,n,t),o=new Float64Array(16),M(o,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),x(this._invProjMatrix,o),o[8]=2*-t.x/this._helper._width,o[9]=2*t.y/this._helper._height,this._projectionMatrix=g(o),w(o,o,[1,-1,1]),b(o,o,[0,0,-this._helper.cameraToCenterDistance]),S(o,o,-this.rollInRadians),T(o,o,this.pitchInRadians),S(o,o,-this.bearingInRadians),b(o,o,[-i,-r,0]),this._mercatorMatrix=w([],o,[this.worldSize,this.worldSize,this.worldSize]),w(o,o,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=v(new Float64Array(16),this.clipSpaceToPixelsMatrix,o),b(o,o,[0,0,-this.elevation]),this._viewProjMatrix=o,this._invViewProjMatrix=x([],o);const a=[0,0,-1,1];G(a,a,this._invViewProjMatrix),this._cameraPosition=[a[0]/a[3],a[1]/a[3],a[2]/a[3]],this._fogMatrix=new Float64Array(16),M(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-t.x/this.width,this._fogMatrix[9]=2*t.y/this.height,w(this._fogMatrix,this._fogMatrix,[1,-1,1]),b(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),S(this._fogMatrix,this._fogMatrix,-this.rollInRadians),T(this._fogMatrix,this._fogMatrix,this.pitchInRadians),S(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),b(this._fogMatrix,this._fogMatrix,[-i,-r,0]),w(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),b(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=v(new Float64Array(16),this.clipSpaceToPixelsMatrix,o);const l=this._helper._width%2/2,c=this._helper._height%2/2,h=Math.cos(this.bearingInRadians),u=Math.sin(-this.bearingInRadians),p=i-Math.round(i)+h*l+u*c,d=r-Math.round(r)+h*c+u*l,f=new Float64Array(o);if(b(f,f,[p>.5?p-1:p,d>.5?d-1:d,0]),this._alignedProjMatrix=f,o=x(new Float64Array(16),this._pixelMatrix),!o)throw new Error("failed to invert matrix");this._pixelMatrixInverse=o,this._clearMatrixCaches()}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear()}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const t=this.screenPointToMercatorCoordinate(new s(0,0)),e=[t.x*this.worldSize,t.y*this.worldSize,0,1];return G(e,e,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const t=jp(1,this.center.lat)*this.worldSize;return bd(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/t).toLngLat()}lngLatToCameraDepth(t,e){const i=Up.fromLngLat(t),r=[i.x*this.worldSize,i.y*this.worldSize,e,1];return G(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(t){const{overscaledTileID:e,aligned:i,applyTerrainMatrix:r}=t,n=this._helper.getMercatorTileCoordinates(e),s=e?this.calculatePosMatrix(e,i,!0):null;let o;return o=e&&e.terrainRttPosMatrix32f&&r?e.terrainRttPosMatrix32f:s||st(),{mainMatrix:o,tileMercatorCoords:n,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:o}}isLocationOccluded(t){return!1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(t,e,i){return 1}transformLightDirection(t){return E(t)}getRayDirectionFromPixel(t){throw new Error("Not implemented.")}projectTileCoordinates(t,e,i,r){const n=this.calculatePosMatrix(i);let o;r?(o=[t,e,r(t,e),1],G(o,o,n)):(o=[t,e,0,1],ef(o,o,n));const a=o[3];return{point:new s(o[0]/a,o[1]/a),signedDistanceFromCamera:a,isOccluded:!1}}populateCache(t){for(const e of t)this.calculatePosMatrix(e)}getMatrixForModel(t,e){const i=Up.fromLngLat(t,e),r=i.meterInMercatorCoordinateUnits(),n=nt();return b(n,n,[i.x,i.y,i.z]),S(n,n,Math.PI),T(n,n,Math.PI/2),w(n,n,[-r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=new Xp(0,0,0,0,0),i=this.getProjectionData({overscaledTileID:e,applyGlobeMatrix:t}),r=vd(e,this.worldSize);v(r,this._viewProjMatrix,r),i.tileMercatorCoords=[0,0,1,1];const n=[Q,Q,this.worldSize/this._helper.pixelsPerMeter],s=rt();return w(s,r,n),i.fallbackMatrix=s,i.mainMatrix=s,i}getFastPathSimpleProjectionMatrix(t){return this.calculatePosMatrix(t)}}function tm(){Dt("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}function em(t){if(t.useSlerp)if(t.k<1){const e=Gt(t.startEulerAngles.roll,t.startEulerAngles.pitch,t.startEulerAngles.bearing),i=Gt(t.endEulerAngles.roll,t.endEulerAngles.pitch,t.endEulerAngles.bearing),r=new Float64Array(4);!function(t,e,i,r){var n,s,o,a,l,c=e[0],h=e[1],u=e[2],d=e[3],f=i[0],m=i[1],_=i[2],g=i[3];(s=c*f+h*m+u*_+d*g)<0&&(s=-s,f=-f,m=-m,_=-_,g=-g),1-s>p?(n=Math.acos(s),o=Math.sin(n),a=Math.sin((1-r)*n)/o,l=Math.sin(r*n)/o):(a=1-r,l=r),t[0]=a*c+l*f,t[1]=a*h+l*m,t[2]=a*u+l*_,t[3]=a*d+l*g}(r,e,i,t.k);const n=function(t){const e=new Float64Array(9);var i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x;u=(n=(r=t)[0])*(l=n+n),p=(s=r[1])*l,f=(o=r[2])*l,m=o*(c=s+s),g=(a=r[3])*l,y=a*c,x=a*(h=o+o),(i=e)[0]=1-(d=s*c)-(_=o*h),i[3]=p-x,i[6]=f+y,i[1]=p+x,i[4]=1-u-_,i[7]=m-g,i[2]=f-y,i[5]=m+g,i[8]=1-u-d;const v=Nt(-Math.asin(vt(e[2],-1,1)));let b,w;return Math.hypot(e[5],e[8])<.001?(b=0,w=-Nt(Math.atan2(e[3],e[4]))):(b=Nt(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),w=Nt(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:b,pitch:v+90,bearing:w}}(r);t.tr.setRoll(n.roll),t.tr.setPitch(n.pitch),t.tr.setBearing(n.bearing)}else t.tr.setRoll(t.endEulerAngles.roll),t.tr.setPitch(t.endEulerAngles.pitch),t.tr.setBearing(t.endEulerAngles.bearing);else t.tr.setRoll(xr.number(t.startEulerAngles.roll,t.endEulerAngles.roll,t.k)),t.tr.setPitch(xr.number(t.startEulerAngles.pitch,t.endEulerAngles.pitch,t.k)),t.tr.setBearing(xr.number(t.startEulerAngles.bearing,t.endEulerAngles.bearing,t.k))}function im(t,e,i,r,n){const o=n.padding,a=gd(n.worldSize,i.getNorthWest()),l=gd(n.worldSize,i.getNorthEast()),c=gd(n.worldSize,i.getSouthEast()),h=gd(n.worldSize,i.getSouthWest()),u=Vt(-r),p=a.rotate(u),d=l.rotate(u),f=c.rotate(u),m=h.rotate(u),_=new s(Math.max(p.x,d.x,m.x,f.x),Math.max(p.y,d.y,m.y,f.y)),g=new s(Math.min(p.x,d.x,m.x,f.x),Math.min(p.y,d.y,m.y,f.y)),y=_.sub(g),x=(n.width-(o.left+o.right+e.left+e.right))/y.x,v=(n.height-(o.top+o.bottom+e.top+e.bottom))/y.y;if(v<0||x<0)return void tm();const b=Math.min(It(n.scale*Math.min(x,v)),t.maxZoom),w=s.convert(t.offset),T=new s((e.left-e.right)/2,(e.top-e.bottom)/2).rotate(Vt(r)),P=w.add(T).mult(n.scale/Mt(b));return{center:yd(n.worldSize,a.add(c).div(2).sub(P)),zoom:b,bearing:r}}class rm{get useGlobeControls(){return!1}handlePanInertia(t,e){const i=t.mag(),r=Math.abs(xd(e));return{easingOffset:t.mult(Math.min(.75*r/i,1)),easingCenter:e.center}}handleMapControlsRollPitchBearingZoom(t,e){t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta),t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta)}handleMapControlsPan(t,e,i){t.around.distSqr(e.centerPoint)<.01||e.setLocationAtPoint(i,t.around)}cameraForBoxAndBearing(t,e,i,r,n){return im(t,e,i,r,n)}handleJumpToCenterZoom(t,e){t.zoom!==(void 0!==e.zoom?+e.zoom:t.zoom)&&t.setZoom(+e.zoom),void 0!==e.center&&t.setCenter(Dp.convert(e.center))}handleEaseTo(t,e){const i=t.zoom,r=t.padding,n={roll:t.roll,pitch:t.pitch,bearing:t.bearing},s={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},o=void 0!==e.zoom,a=!t.isPaddingEqual(e.padding);let l=!1;const c=o?+e.zoom:t.zoom;let h=t.centerPoint.add(e.offsetAsPoint);const u=t.screenPointToLocation(h),{center:p,zoom:d}=t.getConstrained(Dp.convert(e.center||u),null!=c?c:i);Wf(t,p);const f=gd(t.worldSize,u),m=gd(t.worldSize,p).sub(f),_=Mt(d-i);return l=d!==i,{easeFunc:o=>{if(l&&t.setZoom(xr.number(i,d,o)),Ut(n,s)||em({startEulerAngles:n,endEulerAngles:s,tr:t,k:o,useSlerp:n.roll!=s.roll}),a&&(t.interpolatePadding(r,e.padding,o),h=t.centerPoint.add(e.offsetAsPoint)),e.around)t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=Mt(t.zoom-i),r=d>i?Math.min(2,_):Math.max(.5,_),n=Math.pow(r,1-o),s=yd(t.worldSize,f.add(m.mult(o*n)).mult(e));t.setLocationAtPoint(t.renderWorldCopies?s.wrap():s,h)}},isZooming:l,elevationCenter:p}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.zoom,n=t.getConstrained(Dp.convert(e.center||e.locationAtOffset),i?+e.zoom:r),s=n.center,o=n.zoom;Wf(t,s);const a=gd(t.worldSize,e.locationAtOffset),l=gd(t.worldSize,s).sub(a),c=l.mag(),h=Mt(o-r);let u;if(void 0!==e.minZoom){const i=Math.min(+e.minZoom,r,o);u=Mt(t.getConstrained(s,i).zoom-r)}return{easeFunc:(e,i,n,c)=>{t.setZoom(1===e?o:r+It(i));const h=1===e?s:yd(t.worldSize,a.add(l.mult(n)).mult(i));t.setLocationAtPoint(t.renderWorldCopies?h.wrap():h,c)},scaleOfZoom:h,targetCenter:s,scaleOfMinZoom:u,pixelPathLength:c}}}class nm{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i}}nm.Replace=[1,0],nm.disabled=new nm(nm.Replace,zi.transparent,[!1,!1,!1,!1]),nm.unblended=new nm(nm.Replace,zi.transparent,[!0,!0,!0,!0]),nm.alphaBlended=new nm([1,771],zi.transparent,[!0,!0,!0,!0]);const sm=2305;class om{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i}}om.disabled=new om(!1,1029,sm),om.backCCW=new om(!0,1029,sm),om.frontCCW=new om(!0,1028,sm);class am{constructor(t,e,i){this.func=t,this.mask=e,this.range=i}}am.ReadOnly=!1,am.ReadWrite=!0,am.disabled=new am(519,am.ReadOnly,[0,1]);const lm=7680;class cm{constructor(t,e,i,r,n,s){this.test=t,this.ref=e,this.mask=i,this.fail=r,this.depthFail=n,this.pass=s}}cm.disabled=new cm({func:519,mask:0},0,0,lm,lm,lm);const hm=new WeakMap;function um(t){var e;if(hm.has(t))return hm.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return hm.set(t,i),i}}class pm{get awaitingQuery(){return!!this._readbackQueue}constructor(t){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=t;const e=t.context,i=e.gl;this._texFormat=i.RGBA,this._texType=i.UNSIGNED_BYTE;const r=new Da;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const n=new Xa;n.emplaceBack(0,1,2),this._fullscreenTriangle=new Nf(e.createVertexBuffer(r,Uf.members),e.createIndexBuffer(n),tl.simpleSegment(0,0,r.length,n.length)),this._resultBuffer=new Uint8Array(4),e.activeTexture.set(i.TEXTURE1);const s=i.createTexture();i.bindTexture(i.TEXTURE_2D,s),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST),i.texImage2D(i.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=e.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),um(i)&&(this._pbo=i.createBuffer(),i.bindBuffer(i.PIXEL_PACK_BUFFER,this._pbo),i.bufferData(i.PIXEL_PACK_BUFFER,4,i.STREAM_READ),i.bindBuffer(i.PIXEL_PACK_BUFFER,null))}destroy(){const t=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),t.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null}updateErrorLoop(t,e){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(t,e),this._updateCount++,this._measuredError}_bindFramebuffer(){const t=this._cachedRenderContext.context,e=t.gl;t.activeTexture.set(e.TEXTURE1),e.bindTexture(e.TEXTURE_2D,this._fbo.colorAttachment.get()),t.bindFramebuffer.set(this._fbo.framebuffer)}_renderErrorTexture(t,e){const i=this._cachedRenderContext.context,r=i.gl;if(this._bindFramebuffer(),i.viewport.set([0,0,this._texWidth,this._texHeight]),i.clear({color:zi.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(i,r.TRIANGLES,am.disabled,cm.disabled,nm.unblended,om.disabled,((t,e)=>({u_input:t,u_output_expected:e}))(t,e),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&um(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const t=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:t}}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null}}_tryReadback(){const t=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&um(t)){const e=t.clientWaitSync(this._readbackQueue.sync,0,0);if(e===t.WAIT_FAILED)return Dt("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(e===t.TIMEOUT_EXPIRED)return;t.bindBuffer(t.PIXEL_PACK_BUFFER,this._pbo),t.getBufferSubData(t.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),t.bindBuffer(t.PIXEL_PACK_BUFFER,null)}else this._bindFramebuffer(),t.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=pm._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount}static _parseRGBA8float(t){let e=0;return e+=t[0]/256,e+=t[1]/65536,e+=t[2]/16777216,t[3]<127&&(e=-e),e/128}}function dm(t,e){const i=void 0!==t.granularity?Math.max(t.granularity,1):1,r=i+(t.generateBorders?2:0),n=i+(t.extendToNorthPole||t.generateBorders?1:0)+(t.extendToSouthPole||t.generateBorders?1:0),s=r+1,o=n+1,a=t.generateBorders?-1:0,l=t.generateBorders||t.extendToNorthPole?-1:0,c=i+(t.generateBorders?1:0),h=i+(t.generateBorders||t.extendToSouthPole?1:0),u=s*o,p=r*n*6,d=s*o>65536;if(d&&"16bit"===e)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const f=d||"32bit"===e,m=new Int16Array(2*u);let _=0;for(let e=l;e<=h;e++)for(let r=a;r<=c;r++){let n=r/i*Q;-1===r&&(n=-64),r===i+1&&(n=8256);let s=e/i*Q;-1===e&&(s=t.extendToNorthPole?ch:-64),e===i+1&&(s=t.extendToSouthPole?hh:8256),m[_++]=n,m[_++]=s}const g=f?new Uint32Array(p):new Uint16Array(p);let y=0;for(let t=0;t<n;t++)for(let e=0;e<r;e++){const i=e+1+t*s,r=e+(t+1)*s,n=e+1+(t+1)*s;g[y++]=e+t*s,g[y++]=r,g[y++]=i,g[y++]=i,g[y++]=r,g[y++]=n}return{vertices:m.buffer.slice(0),indices:g.buffer.slice(0),uses32bitIndices:f}}const fm=new lh({fill:new ah(128,2),line:new ah(512,0),tile:new ah(128,32),stencil:new ah(128,1),circle:3});class mm{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3}get name(){return"vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return!0}get shaderVariantName(){return"globe"}get shaderDefine(){return"#define GLOBE"}get shaderPreludeCode(){return jf.projectionGlobe}get vertexShaderPreludeCode(){return jf.projectionMercator.vertexSource}get subdivisionGranularity(){return fm}get useGlobeControls(){return!0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy()}updateGPUdependent(t){this._errorMeasurement||(this._errorMeasurement=new pm(t));const e=Op(this._errorQueryLatitudeDegrees),i=2*Math.atan(Math.exp(Math.PI-e*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(e,i),n=Qt.now();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=n);const s=Math.min(Math.max((n-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=mt(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,gt(s))}_getMeshKey(t){return`${t.granularity.toString(36)}_${t.generateBorders?"b":""}${t.extendToNorthPole?"n":""}${t.extendToSouthPole?"s":""}`}getMeshFromTileID(t,e,i,r,n){const s=("stencil"===n?fm.stencil:fm.tile).getGranularityForZoomLevel(e.z);return this._getMesh(t,{granularity:s,generateBorders:i,extendToNorthPole:0===e.y&&r,extendToSouthPole:e.y===(1<<e.z)-1&&r})}_getMesh(t,e){const i=this._getMeshKey(e);if(i in this._tileMeshCache)return this._tileMeshCache[i];const r=function(t,e){const i=dm(e,"16bit"),r=Da.deserialize({arrayBuffer:i.vertices,length:i.vertices.byteLength/2/2}),n=Xa.deserialize({arrayBuffer:i.indices,length:i.indices.byteLength/2/3});return new Nf(t.createVertexBuffer(r,Uf.members),t.createIndexBuffer(n),tl.simpleSegment(0,0,r.length,n.length))}(t,e);return this._tileMeshCache[i]=r,r}recalculate(t){}hasTransition(){const t=Qt.now();let e=!1;return e=e||(t-this._errorMeasurementLastChangeTime)/1e3<.7,e=e||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,e}setErrorQueryLatitudeDegrees(t){this._errorQueryLatitudeDegrees=t}}const _m=new Go({type:new jo(we.projection.type)});class gm extends be{constructor(t){super(),this._transitionable=new Do(_m,void 0),this.setProjection(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new Eo(0)),this._mercatorProjection=new $f,this._verticalPerspectiveProjection=new mm}get transitionState(){const t=this.properties.get("type");if("string"==typeof t&&"mercator"===t)return 0;if("string"==typeof t&&"vertical-perspective"===t)return 1;if(t instanceof Zi){if("vertical-perspective"===t.from&&"mercator"===t.to)return 1-t.transition;if("mercator"===t.from&&"vertical-perspective"===t.to)return t.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return"globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy()}updateGPUdependent(t){this._mercatorProjection.updateGPUdependent(t),this._verticalPerspectiveProjection.updateGPUdependent(t)}getMeshFromTileID(t,e,i,r,n){return this.currentProjection.getMeshFromTileID(t,e,i,r,n)}setProjection(t){this._transitionable.setValue("type",(null==t?void 0:t.type)||"mercator")}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}setErrorQueryLatitudeDegrees(t){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(t),this._mercatorProjection.setErrorQueryLatitudeDegrees(t)}}function ym(t){const e=bm(t.worldSize,t.center.lat);return 2*Math.PI*e}function xm(t,e,i,r,n){const s=1/(1<<n),o=e/Q*s+r*s,a=dt((t/Q*s+i*s)*Math.PI*2+Math.PI,2*Math.PI),l=2*Math.atan(Math.exp(Math.PI-o*Math.PI*2))-.5*Math.PI,c=Math.cos(l),h=new Float64Array(3);return h[0]=Math.sin(a)*c,h[1]=Math.sin(l),h[2]=Math.cos(a)*c,h}function vm(t){return function(t,e){const i=Math.cos(e),r=new Float64Array(3);return r[0]=Math.sin(t)*i,r[1]=Math.sin(e),r[2]=Math.cos(t)*i,r}(t.lng*Math.PI/180,t.lat*Math.PI/180)}function bm(t,e){return t/(2*Math.PI)/Math.cos(e*Math.PI/180)}function wm(t){const e=Math.asin(t[1])/Math.PI*180,i=Math.sqrt(t[0]*t[0]+t[2]*t[2]);if(i>1e-6){const r=t[0]/i,n=Math.acos(t[2]/i),s=(r>0?n:-n)/Math.PI*180;return new Dp(bt(s,-180,180),e)}return new Dp(0,e)}function Tm(t){return Math.cos(t*Math.PI/180)}function Pm(t,e){const i=Tm(t);return It(Tm(e)/i)}function Sm(t,e){const i=t.rotate(e.bearingInRadians),r=e.zoom+Pm(e.center.lat,0),n=mt(1/Tm(e.center.lat),1/Tm(Math.min(Math.abs(e.center.lat),60)),ft(r,7,3,0,1)),s=360/ym({worldSize:e.worldSize,center:{lat:e.center.lat}});return new Dp(e.center.lng-i.x*s*n,vt(e.center.lat+i.y*s,-85.051129,$t))}function Mm(t){const e=.5*t,i=Math.sin(e),r=Math.cos(e);return Math.log(i+r)-Math.log(r-i)}function Im(t,e,i,r){const n=t.lat+i*r;if(Math.abs(i)>1){const s=(Math.sign(t.lat+i)!==Math.sign(t.lat)?-Math.abs(t.lat):Math.abs(t.lat))*Math.PI/180,o=Math.abs(t.lat+i)*Math.PI/180,a=Mm(s+r*(o-s)),l=Mm(s),c=Mm(o);return new Dp(t.lng+e*((a-l)/(c-l)),n)}return new Dp(t.lng+e*r,n)}class Cm{constructor(t){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=t}swapBuffers(){if(!this._hadAnyChanges)return;const t=this._cachePrevious;this._cachePrevious=this._cache,this._cache=t,this._cache.clear(),this._hadAnyChanges=!1}getTileBoundingVolume(t,e,i,r){const n=`${t.z}_${t.x}_${t.y}_${(null==r?void 0:r.terrain)?"t":""}`,s=this._cache.get(n);if(s)return s;const o=this._cachePrevious.get(n);if(o)return this._cache.set(n,o),o;const a=this._boundingVolumeFactory(t,e,i,r);return this._cache.set(n,a),this._hadAnyChanges=!0,a}}class Em{constructor(t,e,i,r){this.min=i,this.max=r,this.points=t,this.planes=e}static fromAabb(t,e){const i=[];for(let r=0;r<8;r++)i.push([1&~r?t[0]:e[0],1==(r>>1&1)?e[1]:t[1],1==(r>>2&1)?e[2]:t[2]]);return new Em(i,[[-1,0,0,e[0]],[1,0,0,-t[0]],[0,-1,0,e[1]],[0,1,0,-t[1]],[0,0,-1,e[2]],[0,0,1,-t[2]]],t,e)}static fromCenterSizeAngles(t,e,i){const r=q([],i[0],i[1],i[2]),n=F([],[e[0],0,0],r),s=F([],[0,e[1],0],r),o=F([],[0,0,e[2]],r),a=[...t],l=[...t];for(let e=0;e<8;e++)for(let i=0;i<3;i++){const r=t[i]+n[i]*(1&~e?-1:1)+s[i]*(1==(e>>1&1)?1:-1)+o[i]*(1==(e>>2&1)?1:-1);a[i]=Math.min(a[i],r),l[i]=Math.max(l[i],r)}const c=[];for(let e=0;e<8;e++){const i=[...t];k(i,i,D([],n,1&~e?-1:1)),k(i,i,D([],s,1==(e>>1&1)?1:-1)),k(i,i,D([],o,1==(e>>2&1)?1:-1)),c.push(i)}return new Em(c,[[...n,-L(n,c[0])],[...s,-L(s,c[0])],[...o,-L(o,c[0])],[-n[0],-n[1],-n[2],-L(n,c[7])],[-s[0],-s[1],-s[2],-L(s,c[7])],[-o[0],-o[1],-o[2],-L(o,c[7])]],a,l)}intersectsFrustum(t){let e=!0;const i=this.points.length,r=this.planes.length,n=t.planes.length,s=t.points.length;for(let r=0;r<n;r++){const n=t.planes[r];let s=0;for(let t=0;t<i;t++){const e=this.points[t];n[0]*e[0]+n[1]*e[1]+n[2]*e[2]+n[3]>=0&&s++}if(0===s)return 0;s<i&&(e=!1)}if(e)return 2;for(let e=0;e<r;e++){const i=this.planes[e];let r=0;for(let e=0;e<s;e++){const n=t.points[e];i[0]*n[0]+i[1]*n[1]+i[2]*n[2]+i[3]>=0&&r++}if(0===r)return 0}return 1}intersectsPlane(t){const e=this.points.length;let i=0;for(let r=0;r<e;r++){const e=this.points[r];t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0&&i++}return i===e?2:0===i?0:1}}function Am(t,e,i){const r=t-e;return r<0?-r:Math.max(0,r-i)}function zm(t,e,i,r,n){const s=t-i;let o;return o=s<0?Math.min(-s,1+s-n):s>1?Math.min(Math.max(s-n,0),1-s):0,Math.max(o,Am(e,r,n))}class km{constructor(){this._boundingVolumeCache=new Cm(this._computeTileBoundingVolume)}prepareNextFrame(){this._boundingVolumeCache.swapBuffers()}distanceToTile2d(t,e,i,r){const n=1<<i.z,s=1/n,o=i.x/n,a=i.y/n;let l=2;return l=Math.min(l,zm(t,e,o,a,s)),l=Math.min(l,zm(t,e,o+.5,-a-s,s)),l=Math.min(l,zm(t,e,o+.5,2-a-s,s)),l}getWrap(t,e,i){const r=1<<e.z,n=1/r,s=e.x/r,o=Am(t.x,s,n),a=Am(t.x,s-1,n),l=Am(t.x,s+1,n),c=Math.min(o,a,l);return c===l?1:c===a?-1:0}allowVariableZoom(t,e){return Md(t,e)>4}allowWorldCopies(){return!1}getTileBoundingVolume(t,e,i,r){return this._boundingVolumeCache.getTileBoundingVolume(t,e,i,r)}_computeTileBoundingVolume(t,e,i,r){var n,s;let o=0,a=0;if(null==r?void 0:r.terrain){const l=new Xp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);o=null!==(n=c.minElevation)&&void 0!==n?n:Math.min(0,i),a=null!==(s=c.maxElevation)&&void 0!==s?s:Math.max(0,i)}if(o/=kp,a/=kp,o+=1,a+=1,t.z<=0)return Em.fromAabb([-a,-a,-a],[a,a,a]);if(1===t.z)return Em.fromAabb([0===t.x?-a:0,0===t.y?0:-a,-a],[0===t.x?0:a,0===t.y?a:0,a]);{const e=[xm(0,0,t.x,t.y,t.z),xm(Q,0,t.x,t.y,t.z),xm(Q,Q,t.x,t.y,t.z),xm(0,Q,t.x,t.y,t.z)],i=[];for(const t of e)i.push(D([],t,a));if(a!==o)for(const t of e)i.push(D([],t,o));0===t.y&&i.push([0,1,0]),t.y===(1<<t.z)-1&&i.push([0,-1,0]);const r=[1,1,1],n=[-1,-1,-1];for(const t of i)for(let e=0;e<3;e++)r[e]=Math.min(r[e],t[e]),n[e]=Math.max(n[e],t[e]);const s=xm(4096,4096,t.x,t.y,t.z),l=B([],[0,1,0],s);R(l,l);const c=B([],s,l);R(c,c);const h=B([],e[2],e[1]);R(h,h);const u=B([],e[0],e[3]);R(u,u),i.push(D([],s,a)),t.y>=(1<<t.z)/2&&i.push(D([],xm(4096,0,t.x,t.y,t.z),a)),t.y<(1<<t.z)/2&&i.push(D([],xm(4096,Q,t.x,t.y,t.z),a));const p=Dm(s,i),d=Dm(c,i),f=[-s[0],-s[1],-s[2],p.max],m=[s[0],s[1],s[2],-p.min],_=[-c[0],-c[1],-c[2],d.max],g=[c[0],c[1],c[2],-d.min],y=[...h,0],x=[...u,0],v=[];return 0===t.y?v.push(lt(x,y,f),lt(x,y,m)):v.push(lt(_,y,f),lt(_,y,m),lt(_,x,f),lt(_,x,m)),t.y===(1<<t.z)-1?v.push(lt(x,y,f),lt(x,y,m)):v.push(lt(g,y,f),lt(g,y,m),lt(g,x,f),lt(g,x,m)),new Em(v,[f,m,_,g,y,x],r,n)}}}function Dm(t,e){let i=1/0,r=-1/0;for(const n of e){const e=L(t,n);i=Math.min(i,e),r=Math.max(r,e)}return{min:i,max:r}}class Rm{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e){this._helper.resize(t,e)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t){}constructor(){this._cachedClippingPlane=et(),this._projectionMatrix=nt(),this._globeViewProjMatrix32f=st(),this._globeViewProjMatrixNoCorrection=nt(),this._globeViewProjMatrixNoCorrectionInverted=nt(),this._globeProjMatrixInverted=nt(),this._cameraPosition=it(),this._globeLatitudeErrorCorrectionRadians=0,this._helper=new Xf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)}),this._coveringTilesDetailsProvider=new km}clone(){const t=new Rm;return t.apply(this),t}apply(t,e){this._globeLatitudeErrorCorrectionRadians=e||0,this._helper.apply(t)}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const t=it();return t[0]=this._cameraPosition[0],t[1]=this._cameraPosition[1],t[2]=this._cameraPosition[2],t}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(t){const{overscaledTileID:e,applyGlobeMatrix:i}=t,r=this._helper.getMercatorTileCoordinates(e);return{mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:r,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(t){const e=this.pitchInRadians,i=this.cameraToCenterDistance/t,r=Math.sin(e)*i,n=Math.cos(e)*i+1,s=1/Math.sqrt(r*r+n*n)*1;let o=-r,a=n;const l=Math.sqrt(o*o+a*a);o/=l,a/=l;const c=[0,o,a];V(c,c,[0,0,0],-this.bearingInRadians),O(c,c,[0,0,0],-1*this.center.lat*Math.PI/180),j(c,c,[0,0,0],this.center.lng*Math.PI/180);const h=1/A(c);return D(c,c,h),[...c,-s*h]}isLocationOccluded(t){return!this.isSurfacePointVisible(vm(t))}transformLightDirection(t){const e=this._helper._center.lng*Math.PI/180,i=this._helper._center.lat*Math.PI/180,r=Math.cos(i),n=[Math.sin(e)*r,Math.sin(i),Math.cos(e)*r],s=[n[2],0,-n[0]],o=[0,0,0];B(o,s,n),R(s,s),R(o,o);const a=[0,0,0];return R(a,[s[0]*t[0]+o[0]*t[1]+n[0]*t[2],s[1]*t[0]+o[1]*t[1]+n[1]*t[2],s[2]*t[0]+o[2]*t[1]+n[2]*t[2]]),a}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(t,e,i){const r=function(t,e,i){const r=1/(1<<i.z);return new Up(t/Q*r+i.x*r,e/Q*r+i.y*r)}(t,e,i.canonical),n=(s=r.y,[dt(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(n[1])}projectTileCoordinates(t,e,i,r){const n=i.canonical,o=xm(t,e,n.x,n.y,n.z),a=1+(r?r(t,e):0)/kp,l=[o[0]*a,o[1]*a,o[2]*a,1];G(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*o[0]+c[1]*o[1]+c[2]*o[2]+c[3]<0;return{point:new s(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const t=bm(this.worldSize,this.center.lat),e=rt(),i=rt();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*t),M(e,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;e[8]=2*-r.x/this._helper._width,e[9]=2*r.y/this._helper._height,this._projectionMatrix=g(e),this._globeProjMatrixInverted=rt(),x(this._globeProjMatrixInverted,e),b(e,e,[0,0,-this.cameraToCenterDistance]),S(e,e,this.rollInRadians),T(e,e,-this.pitchInRadians),S(e,e,this.bearingInRadians),b(e,e,[0,0,-t]);const n=it();n[0]=t,n[1]=t,n[2]=t,T(i,e,this.center.lat*Math.PI/180),P(i,i,-this.center.lng*Math.PI/180),w(i,i,n),this._globeViewProjMatrixNoCorrection=i,T(e,e,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),P(e,e,-this.center.lng*Math.PI/180),w(e,e,n),this._globeViewProjMatrix32f=new Float32Array(e),this._globeViewProjMatrixNoCorrectionInverted=rt(),x(this._globeViewProjMatrixNoCorrectionInverted,i);const s=it();this._cameraPosition=it(),this._cameraPosition[2]=this.cameraToCenterDistance/t,V(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),O(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),V(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),k(this._cameraPosition,this._cameraPosition,[0,0,1]),O(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),j(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(t);const o=g(this._globeViewProjMatrixNoCorrectionInverted);w(o,o,[1,1,-1]),this._cachedFrustum=Jf.fromInvProjectionMatrix(o,1,0,this._cachedClippingPlane,!0)}calculateFogMatrix(t){Dt("calculateFogMatrix is not supported on globe projection.");const e=rt();return y(e),e}getVisibleUnwrappedCoordinates(t){return[new Hp(0,t)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){t&&Dt("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0)}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){if(!this._globeViewProjMatrixNoCorrection)return 1;const i=vm(t);D(i,i,1+e/kp);const r=et();return G(r,[i[0],i[1],i[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(t){}getBounds(){const t=.5*this.width,e=.5*this.height,i=[new s(0,0),new s(t,0),new s(this.width,0),new s(this.width,e),new s(this.width,this.height),new s(t,this.height),new s(0,this.height),new s(0,e)],r=[];for(const t of i)r.push(this.unprojectScreenPoint(t));let n=0,o=0,a=0,l=0;const c=this.center;for(const t of r){const e=ut(c.lng,t.lng),i=ut(c.lat,t.lat);e<o&&(o=e),e>n&&(n=e),i<l&&(l=i),i>a&&(a=i)}const h=[c.lng+o,c.lat+l,c.lng+n,c.lat+a];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new Rp(h)}getConstrained(t,e){const i=vt(t.lat,-85.051129,$t),r=vt(+e,this.minZoom+Pm(0,i),this.maxZoom);return{center:new Dp(t.lng,i),zoom:r}}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){const i=vm(this.unprojectScreenPoint(e)),r=vm(t),n=it();var s;(s=n)[0]=0,s[1]=0,s[2]=0;const o=it();j(o,i,n,-this.center.lng*Math.PI/180),O(o,o,n,this.center.lat*Math.PI/180);const a=r[0]*r[0]+r[2]*r[2],l=o[0]*o[0];if(a<l)return;const c=Math.sqrt(a-l),h=-c,u=ht(r[0],r[2],o[0],c),p=ht(r[0],r[2],o[0],h),d=it();j(d,r,n,-u);const f=ht(d[1],d[2],o[1],o[2]),m=it();j(m,r,n,-p);const _=ht(m[1],m[2],o[1],o[2]),g=.5*Math.PI,y=f>=-g&&f<=g,x=_>=-g&&_<=g;let v,b;if(y&&x){const t=this.center.lng*Math.PI/180,e=this.center.lat*Math.PI/180;pt(u,t)+pt(f,e)<pt(p,t)+pt(_,e)?(v=u,b=f):(v=p,b=_)}else if(y)v=u,b=f;else{if(!x)return;v=p,b=_}const w=v/Math.PI*180,T=b/Math.PI*180,P=this.center.lat;this.setCenter(new Dp(w,vt(T,-90,90))),this.setZoom(this.zoom+Pm(P,this.center.lat))}locationToScreenPoint(t,e){const i=vm(t);return e&&D(i,i,1+e.getElevationForLngLatZoom(t,this._helper._tileZoom)/kp),this._projectSurfacePointToScreen(i)}_projectSurfacePointToScreen(t){const e=et();return G(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],new s((.5*e[0]+.5)*this.width,(.5*-e[1]+.5)*this.height)}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(i)return i}return Up.fromLngLat(this.unprojectScreenPoint(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(t,e){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(t);return!!this.rayPlanetIntersection(i,r)}getRayDirectionFromPixel(t){const e=et();e[0]=t.x/this.width*2-1,e[1]=-1*(t.y/this.height*2-1),e[2]=1,e[3]=1,G(e,e,this._globeViewProjMatrixNoCorrectionInverted),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3];const i=it();i[0]=e[0]-this._cameraPosition[0],i[1]=e[1]-this._cameraPosition[1],i[2]=e[2]-this._cameraPosition[2];const r=it();return R(r,i),r}isSurfacePointVisible(t){const e=this._cachedClippingPlane;return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0}isSurfacePointOnScreen(t){if(!this.isSurfacePointVisible(t))return!1;const e=et();return G(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3],e[0]>-1&&e[0]<1&&e[1]>-1&&e[1]<1&&e[2]>-1&&e[2]<1}rayPlanetIntersection(t,e){const i=L(t,e),r=it(),n=it();D(n,e,i),U(r,t,n);const s=1-L(r,r);if(s<0)return null;const o=L(t,t)-1,a=-i+(i<0?1:-1)*Math.sqrt(s),l=o/a,c=a;return{tMin:Math.min(l,c),tMax:Math.max(l,c)}}unprojectScreenPoint(t){const e=this._cameraPosition,i=this.getRayDirectionFromPixel(t),r=this.rayPlanetIntersection(e,i);if(r){const t=it();k(t,e,[i[0]*r.tMin,i[1]*r.tMin,i[2]*r.tMin]);const n=it();return R(n,t),wm(n)}const n=this._cachedClippingPlane,s=n[0]*i[0]+n[1]*i[1]+n[2]*i[2],o=-at(n,e)/s,a=it();if(o>0)k(a,e,[i[0]*o,i[1]*o,i[2]*o]);else{const t=it();k(t,e,[2*i[0],2*i[1],2*i[2]]);const r=at(this._cachedClippingPlane,t);U(a,t,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r])}const l=function(t){const e=it();return e[0]=t[0]*-t[3],e[1]=t[1]*-t[3],e[2]=t[2]*-t[3],{center:e,radius:Math.sqrt(1-t[3]*t[3])}}(n),c=function(t,e,i){const r=it();U(r,i,t);const n=it();return function(t,e,i,r){t[0]=e[0]+i[0]*r,t[1]=e[1]+i[1]*r,t[2]=e[2]+i[2]*r}(n,t,r,e/Z(r)),n}(l.center,l.radius,a);return wm(c)}getMatrixForModel(t,e){const i=Dp.convert(t),r=1/kp,n=nt();return P(n,n,i.lng/180*Math.PI),T(n,n,-i.lat/180*Math.PI),b(n,n,[0,0,1+e/kp]),T(n,n,.5*Math.PI),w(n,n,[r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=this.getProjectionData({overscaledTileID:new Xp(0,0,0,0,0),applyGlobeMatrix:t});return e.tileMercatorCoords=[0,0,1,1],e}getFastPathSimpleProjectionMatrix(t){}}class Lm{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(t,e){this._globeness=t,this._globeLatitudeErrorCorrectionRadians=e,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame()}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this._helper=new Xf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)}),this._globeness=1,this._mercatorTransform=new Qf,this._verticalPerspectiveTransform=new Rm}clone(){const t=new Lm;return t._globeness=this._globeness,t._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,t.apply(this),t}apply(t){this._helper.apply(t),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians)}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(t){const e=this._mercatorTransform.getProjectionData(t),i=this._verticalPerspectiveTransform.getProjectionData(t);return{mainMatrix:this.isGlobeRendering?i.mainMatrix:e.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:t.applyGlobeMatrix?this._globeness:0,fallbackMatrix:e.fallbackMatrix}}isLocationOccluded(t){return this.currentTransform.isLocationOccluded(t)}transformLightDirection(t){return this.currentTransform.transformLightDirection(t)}getPixelScale(){return mt(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return mt(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(t,e,i){return mt(this._mercatorTransform.getPitchedTextCorrection(t,e,i),this._verticalPerspectiveTransform.getPitchedTextCorrection(t,e,i),this._globeness)}projectTileCoordinates(t,e,i,r){return this.currentTransform.projectTileCoordinates(t,e,i,r)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ)}calculateFogMatrix(t){return this.currentTransform.calculateFogMatrix(t)}getVisibleUnwrappedCoordinates(t){return this.currentTransform.getVisibleUnwrappedCoordinates(t)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(t){this._mercatorTransform.recalculateZoomAndCenter(t),this._verticalPerspectiveTransform.recalculateZoomAndCenter(t)}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){return this.currentTransform.lngLatToCameraDepth(t,e)}populateCache(t){this._mercatorTransform.populateCache(t),this._verticalPerspectiveTransform.populateCache(t)}getBounds(){return this.currentTransform.getBounds()}getConstrained(t,e){return this.currentTransform.getConstrained(t,e)}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(t,e),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(t,e),this.apply(this._verticalPerspectiveTransform)}locationToScreenPoint(t,e){return this.currentTransform.locationToScreenPoint(t,e)}screenPointToMercatorCoordinate(t,e){return this.currentTransform.screenPointToMercatorCoordinate(t,e)}screenPointToLocation(t,e){return this.currentTransform.screenPointToLocation(t,e)}isPointOnMapSurface(t,e){return this.currentTransform.isPointOnMapSurface(t,e)}getRayDirectionFromPixel(t){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(t)}getMatrixForModel(t,e){return this.currentTransform.getMatrixForModel(t,e)}getProjectionDataForCustomLayer(t=!0){const e=this._mercatorTransform.getProjectionDataForCustomLayer(t);if(!this.isGlobeRendering)return e;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(t);return i.fallbackMatrix=e.mainMatrix,i}getFastPathSimpleProjectionMatrix(t){return this.currentTransform.getFastPathSimpleProjectionMatrix(t)}}class Bm{get useGlobeControls(){return!0}handlePanInertia(t,e){const i=Sm(t,e);return Math.abs(i.lng-e.center.lng)>180&&(i.lng=e.center.lng+179.5*Math.sign(i.lng-e.center.lng)),{easingCenter:i,easingOffset:new s(0,0)}}handleMapControlsRollPitchBearingZoom(t,e){const i=t.around,r=e.screenPointToLocation(i);t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta);const n=e.zoom;t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta);const s=e.zoom-n;if(0===s)return;const o=ut(e.center.lng,r.lng),a=o/(Math.abs(o/180)+1),l=ut(e.center.lat,r.lat),c=e.getRayDirectionFromPixel(i),h=e.cameraPosition,u=-1*L(h,c),p=it();k(p,h,[c[0]*u,c[1]*u,c[2]*u]);const d=A(p)-1,f=Math.exp(.5*-Math.max(d-.3,0)),m=bm(e.worldSize,e.center.lat)/Math.min(e.width,e.height),_=ft(m,.9,.5,1,.25),g=(1-Mt(-s))*Math.min(f,_),y=e.center.lat,x=e.zoom,v=new Dp(e.center.lng+a*g,vt(e.center.lat+l*g,-85.051129,$t));e.setLocationAtPoint(r,i);const b=e.center,w=ft(Math.abs(o),45,85,0,1),T=ft(m,.75,.35,0,1),P=Math.pow(Math.max(w,T),.25),S=ut(b.lng,v.lng),M=ut(b.lat,v.lat);e.setCenter(new Dp(b.lng+S*P,b.lat+M*P).wrap()),e.setZoom(x+Pm(y,e.center.lat))}handleMapControlsPan(t,e,i){if(!t.panDelta)return;const r=e.center.lat,n=e.zoom;e.setCenter(Sm(t.panDelta,e).wrap()),e.setZoom(n+Pm(r,e.center.lat))}cameraForBoxAndBearing(t,e,i,r,n){const s=im(t,e,i,r,n),o=e.left/n.width*2-1,a=(n.width-e.right)/n.width*2-1,l=e.top/n.height*-2+1,c=(n.height-e.bottom)/n.height*-2+1,h=ut(i.getWest(),i.getEast())<0,u=h?i.getEast():i.getWest(),p=h?i.getWest():i.getEast(),d=Math.max(i.getNorth(),i.getSouth()),f=Math.min(i.getNorth(),i.getSouth()),m=u+.5*ut(u,p),_=d+.5*ut(d,f),g=n.clone();g.setCenter(s.center),g.setBearing(s.bearing),g.setPitch(0),g.setRoll(0),g.setZoom(s.zoom);const y=g.modelViewProjectionMatrix,x=[vm(i.getNorthWest()),vm(i.getNorthEast()),vm(i.getSouthWest()),vm(i.getSouthEast()),vm(new Dp(p,_)),vm(new Dp(u,_)),vm(new Dp(m,d)),vm(new Dp(m,f))],v=vm(s.center);let b=Number.POSITIVE_INFINITY;for(const t of x)o<0&&(b=Bm.getLesserNonNegativeNonNull(b,Bm.solveVectorScale(t,v,y,"x",o))),a>0&&(b=Bm.getLesserNonNegativeNonNull(b,Bm.solveVectorScale(t,v,y,"x",a))),l>0&&(b=Bm.getLesserNonNegativeNonNull(b,Bm.solveVectorScale(t,v,y,"y",l))),c<0&&(b=Bm.getLesserNonNegativeNonNull(b,Bm.solveVectorScale(t,v,y,"y",c)));if(Number.isFinite(b)&&0!==b)return s.zoom=g.zoom+It(b),s;tm()}handleJumpToCenterZoom(t,e){const i=t.center.lat,r=t.getConstrained(e.center?Dp.convert(e.center):t.center,t.zoom).center;t.setCenter(r.wrap());const n=void 0!==e.zoom?+e.zoom:t.zoom+Pm(i,r.lat);t.zoom!==n&&t.setZoom(n)}handleEaseTo(t,e){const i=t.zoom,r=t.center,n=t.padding,o={roll:t.roll,pitch:t.pitch,bearing:t.bearing},a={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},l=void 0!==e.zoom,c=!t.isPaddingEqual(e.padding);let h=!1;const u=e.center?Dp.convert(e.center):r,p=t.getConstrained(u,i).center;Wf(t,p);const d=t.clone();d.setCenter(p),d.setZoom(l?+e.zoom:i+Pm(r.lat,u.lat)),d.setBearing(e.bearing);const f=new s(vt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),vt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));d.setLocationAtPoint(p,f);const m=(e.offset&&e.offsetAsPoint.mag())>0?d.center:p,_=l?+e.zoom:i+Pm(r.lat,m.lat),g=i+Pm(r.lat,0),y=_+Pm(m.lat,0),x=ut(r.lng,m.lng),v=ut(r.lat,m.lat),b=Mt(y-g);return h=_!==i,{easeFunc:i=>{if(Ut(o,a)||em({startEulerAngles:o,endEulerAngles:a,tr:t,k:i,useSlerp:o.roll!=a.roll}),c&&t.interpolatePadding(n,e.padding,i),e.around)Dt("Easing around a point is not supported under globe projection."),t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=y>g?Math.min(2,b):Math.max(.5,b),n=Math.pow(e,1-i),s=Im(r,x,v,i*n);t.setCenter(s.wrap())}if(h){const e=xr.number(g,y,i)+Pm(0,t.center.lat);t.setZoom(e)}},isZooming:h,elevationCenter:m}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.center,n=t.zoom,o=t.padding,a=!t.isPaddingEqual(e.padding),l=t.getConstrained(Dp.convert(e.center||e.locationAtOffset),n).center,c=i?+e.zoom:t.zoom+Pm(t.center.lat,l.lat),h=t.clone();h.setCenter(l),h.setZoom(c),h.setBearing(e.bearing);const u=new s(vt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),vt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));h.setLocationAtPoint(l,u);const p=h.center;Wf(t,p);const d=function(t,e,i){const r=L(vm(e),vm(i)),n=Math.acos(r),s=ym(t);return n/(2*Math.PI)*s}(t,r,p),f=n+Pm(r.lat,0),m=c+Pm(p.lat,0),_=Mt(m-f);let g;if("number"==typeof e.minZoom){const i=+e.minZoom+Pm(p.lat,0),r=Math.min(i,f,m)+Pm(0,p.lat);g=Mt(t.getConstrained(p,r).zoom+Pm(p.lat,0)-f)}const y=ut(r.lng,p.lng),x=ut(r.lat,p.lat);return{easeFunc:(i,n,s,l)=>{const h=Im(r,y,x,s);a&&t.interpolatePadding(o,e.padding,i);const u=1===i?p:h;t.setCenter(u.wrap());const d=f+It(n);t.setZoom(1===i?c:d+Pm(0,u.lat))},scaleOfZoom:_,targetCenter:p,scaleOfMinZoom:g,pixelPathLength:d}}static solveVectorScale(t,e,i,r,n){const s="x"===r?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],o=[i[3],i[7],i[11],i[15]],a=t[0]*s[0]+t[1]*s[1]+t[2]*s[2],l=t[0]*o[0]+t[1]*o[1]+t[2]*o[2],c=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],h=e[0]*o[0]+e[1]*o[1]+e[2]*o[2];return c+n*l===a+n*h||o[3]*(a-c)+s[3]*(h-l)+a*h==c*l?null:(c+s[3]-n*h-n*o[3])/(c-a-n*h+n*l)}static getLesserNonNegativeNonNull(t,e){return null!==e&&e>=0&&e<t?e:t}}class Fm{constructor(t){this._globe=t,this._mercatorCameraHelper=new rm,this._verticalPerspectiveCameraHelper=new Bm}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(t,e){return this.currentHelper.handlePanInertia(t,e)}handleMapControlsRollPitchBearingZoom(t,e){return this.currentHelper.handleMapControlsRollPitchBearingZoom(t,e)}handleMapControlsPan(t,e,i){this.currentHelper.handleMapControlsPan(t,e,i)}cameraForBoxAndBearing(t,e,i,r,n){return this.currentHelper.cameraForBoxAndBearing(t,e,i,r,n)}handleJumpToCenterZoom(t,e){this.currentHelper.handleJumpToCenterZoom(t,e)}handleEaseTo(t,e){return this.currentHelper.handleEaseTo(t,e)}handleFlyTo(t,e){return this.currentHelper.handleFlyTo(t,e)}}const Om=(t,e)=>oo(t,e&&e.filter((t=>"source.canvas"!==t.identifier))),jm=function(){const t={},e=we.$version;for(const i in we.$root){const r=we.$root[i];if(r.required){let n=null;n="version"===i?e:"array"===r.type?[]:{},null!=n&&(t[i]=n)}}return t}();class Vm extends be{constructor(t,e={}){var i,r;super(),this._rtlPluginLoaded=()=>{for(const t in this.sourceCaches){const e=this.sourceCaches[t].getSource().type;"vector"!==e&&"geojson"!==e||this.sourceCaches[t].reload()}},this.map=t,this.dispatcher=new Sp(Pp(),t._getMapId()),this.dispatcher.registerMessageHandler("GG",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("GI",((t,e)=>this.getImages(t,e))),this.imageManager=new sp,this.imageManager.setEventedParent(this);const n=(null===(i=t._container)||void 0===i?void 0:i.lang)||"undefined"!=typeof document&&(null===(r=document.documentElement)||void 0===r?void 0:r.lang)||void 0;this.glyphManager=new cp(t._requestManager,e.localIdeographFontFamily,n),this.lineAtlas=new mp(256,512),this.crossTileSymbolIndex=new Ff,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new _o,this._loaded=!1,this._availableImages=[],this._globalState={},this._resetUpdates(),this.dispatcher.broadcast("SR",se()),pd().on(cd,this._rtlPluginLoaded),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.sourceCaches[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e)}}))}setGlobalStateProperty(t,e){var i,r,n;this._checkLoaded();const s=null===e?null!==(n=null===(r=null===(i=this.stylesheet.state)||void 0===i?void 0:i[t])||void 0===r?void 0:r.default)&&void 0!==n?n:null:e;if(At(s,this._globalState[t]))return this;this._globalState[t]=s,this._applyGlobalStateChanges([t])}getGlobalState(){return this._globalState}setGlobalState(t){this._checkLoaded();const e=[];for(const i in t)!At(this._globalState[i],t[i].default)&&(e.push(i),this._globalState[i]=t[i].default);this._applyGlobalStateChanges(e)}_applyGlobalStateChanges(t){if(0===t.length)return;const e=new Set,i={};for(const r of t){i[r]=this._globalState[r];for(const t in this._layers){const i=this._layers[t],n=i.getLayoutAffectingGlobalStateRefs(),s=i.getPaintAffectingGlobalStateRefs();if(n.has(r)&&e.add(i.source),s.has(r))for(const{name:t,value:e}of s.get(r))this._updatePaintProperty(i,t,e)}}this.dispatcher.broadcast("UGS",i);for(const t in this.sourceCaches)e.has(t)&&(this._reloadSource(t),this._changed=!0)}loadURL(t,e={},i){this.fire(new xe("dataloading",{dataType:"style"})),e.validate="boolean"!=typeof e.validate||e.validate;const r=this.map._requestManager.transformRequest(t,"Style");this._loadStyleRequest=new AbortController;const n=this._loadStyleRequest;ae(r,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,e,i)})).catch((t=>{this._loadStyleRequest=null,t&&!n.signal.aborted&&this.fire(new ve(t))}))}loadJSON(t,e={},i){this.fire(new xe("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,Qt.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,e.validate=!1!==e.validate,this._load(t,e,i)})).catch((()=>{}))}loadEmpty(){this.fire(new xe("dataloading",{dataType:"style"})),this._load(jm,{validate:!1})}_load(t,e,i){var r,n;let s=e.transformStyle?e.transformStyle(i,t):t;if(!e.validate||!Om(this,eo(s))){s=Object.assign({},s),this._loaded=!0,this.stylesheet=s;for(const t in s.sources)this.addSource(t,s.sources[t],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new pp(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new fp(this.stylesheet.sky),this.map.setTerrain(null!==(n=this.stylesheet.terrain)&&void 0!==n?n:null),this.fire(new xe("data",{dataType:"style"})),this.fire(new xe("style.load"))}}_createLayers(){var t;const e=Se(this.stylesheet.layers);this.setGlobalState(null!==(t=this.stylesheet.state)&&void 0!==t?t:null),this.dispatcher.broadcast("SL",e),this._order=e.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const t of e){const e=ep(t,this._globalState);e.setEventedParent(this,{layer:{id:t.id}}),this._layers[t.id]=e}}_loadSprite(t,e=!1,i=void 0){let r;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,e,i,r){return n(this,void 0,void 0,(function*(){const s=ip(t),o=i>1?"@2x":"",a={},l={};for(const{id:t,url:i}of s){const n=e.transformRequest(rp(i,o,".json"),"SpriteJSON");a[t]=ae(n,r);const s=e.transformRequest(rp(i,o,".png"),"SpriteImage");l[t]=me.getImage(s,r)}return yield Promise.all([...Object.values(a),...Object.values(l)]),function(t,e){return n(this,void 0,void 0,(function*(){const i={};for(const r in t){i[r]={};const n=Qt.getImageCanvasContext((yield e[r]).data),s=(yield t[r]).data;for(const t in s){const{width:e,height:o,x:a,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m}=s[t];i[r][t]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m,spriteData:{width:e,height:o,x:a,y:l,context:n}}}}return i}))}(a,l)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const i in t){this._spritesImagesIds[i]=[];const r=this._spritesImagesIds[i]?this._spritesImagesIds[i].filter((e=>!(e in t))):[];for(const t of r)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const r in t[i]){const n="default"===i?r:`${i}:${r}`;this._spritesImagesIds[i].push(n),n in this.imageManager.images?this.imageManager.updateImage(n,t[i][r],!1):this.imageManager.addImage(n,t[i][r]),e&&(this._changedImages[n]=!0)}}})).catch((t=>{this._spriteRequest=null,r=t,this.fire(new ve(r))})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),e&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new xe("data",{dataType:"style"})),i&&i(r)}))}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new xe("data",{dataType:"style"}))}_validateLayer(t){const e=this.sourceCaches[t.source];if(!e)return;const i=t.sourceLayer;if(!i)return;const r=e.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(i))&&this.fire(new ve(new Error(`Source layer "${i}" does not exist on source "${r.id}" as specified by style layer "${t.id}".`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const t in this.sourceCaches)if(!this.sourceCaches[t].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeByIds(t,e=!1){const i=this._serializedAllLayers();if(!t||0===t.length)return Object.values(e?zt(i):i);const r=[];for(const n of t)if(i[n]){const t=e?zt(i[n]):i[n];r.push(t)}return r}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize())}return t}hasTransitions(){var t,e,i;if(null===(t=this.light)||void 0===t?void 0:t.hasTransition())return!0;if(null===(e=this.sky)||void 0===e?void 0:e.hasTransition())return!0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return!0;for(const t in this.sourceCaches)if(this.sourceCaches[t].hasTransition())return!0;for(const t in this._layers)if(this._layers[t].hasTransition())return!0;return!1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const e=this._changed;if(e){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else{if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t)}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.sky.updateTransitions(t),this._resetUpdates()}const i={};for(const t in this.sourceCaches){const e=this.sourceCaches[t];i[t]=e.used,e.used=!1}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0)}for(const t in i){const e=this.sourceCaches[t];!!i[t]!=!!e.used&&e.fire(new xe("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}))}this.light.recalculate(t),this.sky.recalculate(t),this.projection.recalculate(t),this.z=t.zoom,e&&this.fire(new xe("data",{dataType:"style"}))}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={}}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(t,!1),removedIds:e})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1}setState(t,e={}){var i;this._checkLoaded();const r=this.serialize();if(t=e.transformStyle?e.transformStyle(r,t):t,(null===(i=e.validate)||void 0===i||i)&&Om(this,eo(t)))return!1;(t=zt(t)).layers=Se(t.layers);const n=function(t,e){if(!t)return[{command:"setStyle",args:[e]}];let i=[];try{if(!Me(t.version,e.version))return[{command:"setStyle",args:[e]}];Me(t.center,e.center)||i.push({command:"setCenter",args:[e.center]}),Me(t.state,e.state)||i.push({command:"setGlobalState",args:[e.state]}),Me(t.centerAltitude,e.centerAltitude)||i.push({command:"setCenterAltitude",args:[e.centerAltitude]}),Me(t.zoom,e.zoom)||i.push({command:"setZoom",args:[e.zoom]}),Me(t.bearing,e.bearing)||i.push({command:"setBearing",args:[e.bearing]}),Me(t.pitch,e.pitch)||i.push({command:"setPitch",args:[e.pitch]}),Me(t.roll,e.roll)||i.push({command:"setRoll",args:[e.roll]}),Me(t.sprite,e.sprite)||i.push({command:"setSprite",args:[e.sprite]}),Me(t.glyphs,e.glyphs)||i.push({command:"setGlyphs",args:[e.glyphs]}),Me(t.transition,e.transition)||i.push({command:"setTransition",args:[e.transition]}),Me(t.light,e.light)||i.push({command:"setLight",args:[e.light]}),Me(t.terrain,e.terrain)||i.push({command:"setTerrain",args:[e.terrain]}),Me(t.sky,e.sky)||i.push({command:"setSky",args:[e.sky]}),Me(t.projection,e.projection)||i.push({command:"setProjection",args:[e.projection]});const r={},n=[];!function(t,e,i,r){let n;for(n in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,n)&&(Object.prototype.hasOwnProperty.call(e,n)||Ee(n,i,r));for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&(Object.prototype.hasOwnProperty.call(t,n)?Me(t[n],e[n])||("geojson"===t[n].type&&"geojson"===e[n].type&&ze(t,e,n)?Ie(i,{command:"setGeoJSONSourceData",args:[n,e[n].data]}):Ae(n,e,i,r)):Ce(n,e,i))}(t.sources,e.sources,n,r);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&r[t.source]?i.push({command:"removeLayer",args:[t.id]}):s.push(t)})),i=i.concat(n),function(t,e,i){e=e||[];const r=(t=t||[]).map(De),n=e.map(De),s=t.reduce(Re,{}),o=e.reduce(Re,{}),a=r.slice(),l=Object.create(null);let c,h,u,p,d;for(let t=0,e=0;t<r.length;t++)c=r[t],Object.prototype.hasOwnProperty.call(o,c)?e++:(Ie(i,{command:"removeLayer",args:[c]}),a.splice(a.indexOf(c,e),1));for(let t=0,e=0;t<n.length;t++)c=n[n.length-1-t],a[a.length-1-t]!==c&&(Object.prototype.hasOwnProperty.call(s,c)?(Ie(i,{command:"removeLayer",args:[c]}),a.splice(a.lastIndexOf(c,a.length-e),1)):e++,p=a[a.length-t],Ie(i,{command:"addLayer",args:[o[c],p]}),a.splice(a.length-t,0,c),l[c]=!0);for(let t=0;t<n.length;t++)if(c=n[t],h=s[c],u=o[c],!l[c]&&!Me(h,u))if(Me(h.source,u.source)&&Me(h["source-layer"],u["source-layer"])&&Me(h.type,u.type)){for(d in ke(h.layout,u.layout,i,c,null,"setLayoutProperty"),ke(h.paint,u.paint,i,c,null,"setPaintProperty"),Me(h.filter,u.filter)||Ie(i,{command:"setFilter",args:[c,u.filter]}),Me(h.minzoom,u.minzoom)&&Me(h.maxzoom,u.maxzoom)||Ie(i,{command:"setLayerZoomRange",args:[c,u.minzoom,u.maxzoom]}),h)Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?ke(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):Me(h[d],u[d])||Ie(i,{command:"setLayerProperty",args:[c,d,u[d]]}));for(d in u)Object.prototype.hasOwnProperty.call(u,d)&&!Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?ke(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):Me(h[d],u[d])||Ie(i,{command:"setLayerProperty",args:[c,d,u[d]]}))}else Ie(i,{command:"removeLayer",args:[c]}),p=a[a.lastIndexOf(c)+1],Ie(i,{command:"addLayer",args:[u,p]})}(s,e.layers,i)}catch(t){console.warn("Unable to compute style diff:",t),i=[{command:"setStyle",args:[e]}]}return i}(r,t),s=this._getOperationsToPerform(n);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return!1;for(const t of s.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const r of t)switch(r.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":case"setRoll":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,r.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,r.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,r.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,r.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,r.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,r.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,r.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,r.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,r.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,r.args)));break;case"setSky":e.push((()=>this.setSky.apply(this,r.args)));break;case"setProjection":this.setProjection.apply(this,r.args);break;case"setGlobalState":e.push((()=>this.setGlobalState.apply(this,r.args)));break;case"setTransition":e.push((()=>{}));break;default:i.push(r.command)}return{operations:e,unimplemented:i}}addImage(t,e){if(this.getImage(t))return this.fire(new ve(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,e),this._afterImageUpdated(t)}updateImage(t,e){this.imageManager.updateImage(t,e)}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new ve(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t)}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new xe("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,e,i={}){if(this._checkLoaded(),void 0!==this.sourceCaches[t])throw new Error(`Source "${t}" already exists.`);if(!e.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(e).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(e.type)>=0&&this._validate(eo.source,`sources.${t}`,e,null,i))return;this.map&&this.map._collectResourceTiming&&(e.collectResourceTiming=!0);const r=this.sourceCaches[t]=new Ed(t,e,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:t}))),r.onAdd(this.map),this._changed=!0}removeSource(t){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error("There is no source with this ID");for(const e in this._layers)if(this._layers[e].source===t)return this.fire(new ve(new Error(`Source "${t}" cannot be removed while layer "${e}" is using it.`)));const e=this.sourceCaches[t];delete this.sourceCaches[t],delete this._updatedSources[t],e.fire(new xe("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),e.setEventedParent(null),e.onRemove(this.map),this._changed=!0}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error(`There is no source with this ID=${t}`);const i=this.sourceCaches[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0}getSource(t){return this.sourceCaches[t]&&this.sourceCaches[t].getSource()}addLayer(t,e,i={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new ve(new Error(`Layer "${r}" already exists on this map.`)));let n;if("custom"===t.type){if(Om(this,function(t){const e=[],i=t.id;return void 0===i&&e.push({message:`layers.${i}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${i}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),e}(t)))return;n=ep(t,this._globalState)}else{if("source"in t&&"object"==typeof t.source&&(this.addSource(r,t.source),t=wt(t=zt(t),{source:r})),this._validate(eo.layer,`layers.${r}`,t,{arrayIndex:-1},i))return;n=ep(t,this._globalState),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}})}const s=e?this._order.indexOf(e):this._order.length;if(e&&-1===s)this.fire(new ve(new Error(`Cannot add layer "${r}" before non-existing layer "${e}".`)));else{if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=n,this._removedLayers[r]&&n.source&&"custom"!==n.type){const t=this._removedLayers[r];delete this._removedLayers[r],t.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",this.sourceCaches[n.source].pause())}this._updateLayer(n),n.onAdd&&n.onAdd(this.map)}}moveLayer(t,e){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new ve(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===e)return;const i=this._order.indexOf(t);this._order.splice(i,1);const r=e?this._order.indexOf(e):this._order.length;e&&-1===r?this.fire(new ve(new Error(`Cannot move layer "${t}" before non-existing layer "${e}".`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0)}removeLayer(t){this._checkLoaded();const e=this._layers[t];if(!e)return void this.fire(new ve(new Error(`Cannot remove non-existing layer "${t}".`)));e.setEventedParent(null);const i=this._order.indexOf(t);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=e,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],e.onRemove&&e.onRemove(this.map)}getLayer(t){return this._layers[t]}getLayersOrder(){return[...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,e,i){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===e&&r.maxzoom===i||(null!=e&&(r.minzoom=e),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new ve(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)))}setFilter(t,e,i={}){this._checkLoaded();const r=this.getLayer(t);if(r){if(!At(r.filter,e))return null==e?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(eo.filter,`layers.${r.id}.filter`,e,null,i)||(r.setFilter(zt(e)),this._updateLayer(r)))}else this.fire(new ve(new Error(`Cannot filter non-existing layer "${t}".`)))}getFilter(t){return zt(this.getLayer(t).filter)}setLayoutProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?At(n.getLayoutProperty(e),i)||(n.setLayoutProperty(e,i,r),this._updateLayer(n)):this.fire(new ve(new Error(`Cannot style non-existing layer "${t}".`)))}getLayoutProperty(t,e){const i=this.getLayer(t);if(i)return i.getLayoutProperty(e);this.fire(new ve(new Error(`Cannot get style of non-existing layer "${t}".`)))}setPaintProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?At(n.getPaintProperty(e),i)||this._updatePaintProperty(n,e,i,r):this.fire(new ve(new Error(`Cannot style non-existing layer "${t}".`)))}_updatePaintProperty(t,e,i,r={}){t.setPaintProperty(e,i,r)&&this._updateLayer(t),this._changed=!0,this._updatedPaintProps[t.id]=!0,this._serializedLayers=null}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,e){this._checkLoaded();const i=t.source,r=t.sourceLayer,n=this.sourceCaches[i];if(void 0===n)return void this.fire(new ve(new Error(`The source '${i}' does not exist in the map's style.`)));const s=n.getSource().type;"geojson"===s&&r?this.fire(new ve(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===t.id&&this.fire(new ve(new Error("The feature id parameter must be provided."))),n.setFeatureState(r,t.id,e)):this.fire(new ve(new Error("The sourceLayer parameter must be provided for vector source types.")))}removeFeatureState(t,e){this._checkLoaded();const i=t.source,r=this.sourceCaches[i];if(void 0===r)return void this.fire(new ve(new Error(`The source '${i}' does not exist in the map's style.`)));const n=r.getSource().type,s="vector"===n?t.sourceLayer:void 0;"vector"!==n||s?e&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new ve(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,t.id,e):this.fire(new ve(new Error("The sourceLayer parameter must be provided for vector source types.")))}getFeatureState(t){this._checkLoaded();const e=t.source,i=t.sourceLayer,r=this.sourceCaches[e];if(void 0!==r)return"vector"!==r.getSource().type||i?(void 0===t.id&&this.fire(new ve(new Error("The feature id parameter must be provided."))),r.getFeatureState(i,t.id)):void this.fire(new ve(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new ve(new Error(`The source '${e}' does not exist in the map's style.`)))}getTransition(){return wt({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=Ct(this.sourceCaches,(t=>t.serialize())),e=this._serializeByIds(this._order,!0),i=this.map.getTerrain()||void 0,r=this.stylesheet;return Et({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:t,layers:e,terrain:i},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.sourceCaches[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.sourceCaches[t.source].pause()),this._serializedLayers=null,this._changed=!0}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},r=[];for(let n=this._order.length-1;n>=0;n--){const s=this._order[n];if(e(s)){i[s]=n;for(const e of t){const t=e[s];if(t)for(const e of t)r.push(e)}}}r.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const n=[];for(let s=this._order.length-1;s>=0;s--){const o=this._order[s];if(e(o))for(let t=r.length-1;t>=0;t--){const e=r[t].feature;if(i[e.layer.id]<s)break;n.push(e),r.pop()}else for(const e of t){const t=e[o];if(t)for(const e of t)n.push(e.feature)}}return n}queryRenderedFeatures(t,e,i){e&&e.filter&&this._validate(eo.filter,"queryRenderedFeatures.filter",e.filter,null,e);const r={};if(e&&e.layers){if(!(Array.isArray(e.layers)||e.layers instanceof Set))return this.fire(new ve(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const t of e.layers){const e=this._layers[t];if(!e)return this.fire(new ve(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[e.source]=!0}}const n=[];e.availableImages=this._availableImages;const s=this._serializedAllLayers(),o=e.layers instanceof Set?e.layers:Array.isArray(e.layers)?new Set(e.layers):null,a=Object.assign(Object.assign({},e),{layers:o,globalState:this._globalState});for(const o in this.sourceCaches)e.layers&&!r[o]||n.push(Cp(this.sourceCaches[o],this._layers,s,t,a,i,this.map.terrain?(t,e,i)=>this.map.terrain.getElevation(t,e,i):void 0));return this.placement&&n.push(function(t,e,i,r,n,s,o){const a={},l=s.queryRenderedSymbols(r),c=[];for(const t of Object.keys(l).map(Number))c.push(o[t]);c.sort(Ep);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,{filterSpec:n.filter,globalState:n.globalState},n.layers,n.availableImages,t);for(const t in r){const e=a[t]=a[t]||[],n=r[t];n.sort(((t,e)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(t.featureIndex);return r.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of n)e.push(t)}}return function(t,e,i){for(const r in t)for(const n of t[r])Ap(n,i[e[r].source]);return t}(a,t,i)}(this._layers,s,this.sourceCaches,t,a,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(t,e){(null==e?void 0:e.filter)&&this._validate(eo.filter,"querySourceFeatures.filter",e.filter,null,e);const i=this.sourceCaches[t];return i?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),r=[],n={};for(let t=0;t<i.length;t++){const s=i[t],o=s.tileID.canonical.key;n[o]||(n[o]=!0,s.querySourceFeatures(r,e))}return r}(i,e?Object.assign(Object.assign({},e),{globalState:this._globalState}):{globalState:this._globalState}):[]}getLight(){return this.light.getLight()}setLight(t,e={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const e in t)if(!At(t[e],i[e])){r=!0;break}if(!r)return;const n={now:Qt.now(),transition:wt({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,e),this.light.updateTransitions(n)}getProjection(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.projection}setProjection(t){if(this._checkLoaded(),this.projection){if(this.projection.name===t.type)return;this.projection.destroy(),delete this.projection}this.stylesheet.projection=t,this._setProjectionInternal(t.type)}getSky(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.sky}setSky(t,e={}){this._checkLoaded();const i=this.getSky();let r=!1;if(!t&&!i)return;if(t&&!i)r=!0;else if(!t&&i)r=!0;else for(const e in t)if(!At(t[e],i[e])){r=!0;break}if(!r)return;const n={now:Qt.now(),transition:wt({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=t,this.sky.setSky(t,e),this.sky.updateTransitions(n)}_setProjectionInternal(t){const e=function(t){if(Array.isArray(t)){const e=new gm({type:t});return{projection:e,transform:new Lm,cameraHelper:new Fm(e)}}switch(t){case"mercator":return{projection:new $f,transform:new Qf,cameraHelper:new rm};case"globe":{const t=new gm({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return{projection:t,transform:new Lm,cameraHelper:new Fm(t)}}case"vertical-perspective":return{projection:new mm,transform:new Rm,cameraHelper:new Bm};default:return Dt(`Unknown projection name: ${t}. Falling back to mercator projection.`),{projection:new $f,transform:new Qf,cameraHelper:new rm}}}(t);this.projection=e.projection,this.map.migrateProjection(e.transform,e.cameraHelper);for(const t in this.sourceCaches)this.sourceCaches[t].reload()}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&Om(this,t.call(eo,wt({key:e,style:this.serialize(),value:i,styleSpec:we},r)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),pd().off(cd,this._rtlPluginLoaded);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.sourceCaches){const e=this.sourceCaches[t];e.setEventedParent(null),e.onRemove(this.map)}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(t)}_clearSource(t){this.sourceCaches[t].clearTiles()}_reloadSource(t){this.sourceCaches[t].resume(),this.sourceCaches[t].reload()}_updateSources(t){for(const e in this.sourceCaches)this.sourceCaches[e].update(t,this.map.terrain)}_generateCollisionBoxes(){for(const t in this.sourceCaches)this._reloadSource(t)}_updatePlacement(t,e,i,r,n=!1){let s=!1,o=!1;const a={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!a[i.source]){const t=this.sourceCaches[i.source];a[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,a[i.source],t.center.lng);s=s||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((n=n||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(Qt.now(),t.zoom))&&(this.pauseablePlacement=new Sf(t,this.map.terrain,this._order,n,e,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,a),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(Qt.now()),o=!0),s&&this.pauseablePlacement.placement.setStale()),o||s)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,a[e.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(Qt.now())}_releaseSymbolFadeTiles(){for(const t in this.sourceCaches)this.sourceCaches[t].releaseSymbolFadeTiles()}getImages(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(e.icons);this._updateTilesForChangedImages();const i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,e.icons),t}))}getGlyphs(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(e.stacks),i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,e={}){this._checkLoaded(),t&&this._validate(eo.glyphs,"glyphs",t,null,e)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t))}addSprite(t,e,i={},r){this._checkLoaded();const n=[{id:t,url:e}],s=[...ip(this.stylesheet.sprite),...n];this._validate(eo.sprite,"sprite",s,null,i)||(this.stylesheet.sprite=s,this._loadSprite(n,!0,r))}removeSprite(t){this._checkLoaded();const e=ip(this.stylesheet.sprite);if(e.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;e.splice(e.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=e.length>0?e:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new xe("data",{dataType:"style"}))}else this.fire(new ve(new Error(`Sprite "${t}" doesn't exists on this map.`)))}getSprite(){return ip(this.stylesheet.sprite)}setSprite(t,e={},i){this._checkLoaded(),t&&this._validate(eo.sprite,"sprite",t,null,e)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,i):(this._unloadSprite(),i&&i(null)))}}var Nm=Yo([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Um{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null}bind(t,e,i,r,n,s,o,a,l){this.context=t;let c=this.boundPaintVertexBuffers.length!==r.length;for(let t=0;!c&&t<r.length;t++)this.boundPaintVertexBuffers[t]!==r[t]&&(c=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==n||this.boundVertexOffset!==s||this.boundDynamicVertexBuffer!==o||this.boundDynamicVertexBuffer2!==a||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,r,n,s,o,a,l):(t.bindVertexArray.set(this.vao),o&&o.bind(),n&&n.dynamicDraw&&n.bind(),a&&a.bind(),l&&l.bind())}freshBind(t,e,i,r,n,s,o,a){const l=t.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffer=s,this.boundDynamicVertexBuffer2=o,this.boundDynamicVertexBuffer3=a,e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);s&&s.enableAttributes(h,t),o&&o.enableAttributes(h,t),a&&a.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,n);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,n);s&&(s.bind(),s.setVertexAttribPointers(h,t,n)),r&&r.bind(),o&&(o.bind(),o.setVertexAttribPointers(h,t,n)),a&&(a.bind(),a.setVertexAttribPointers(h,t,n)),c.currentNumAttributes=l}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null)}}const Zm=(t,e,i,r,n)=>({u_texture:0,u_ele_delta:t,u_fog_matrix:e,u_fog_color:i?i.properties.get("fog-color"):zi.white,u_fog_ground_blend:i?i.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:n?0:i?i.calculateFogBlendOpacity(r):0,u_horizon_color:i?i.properties.get("horizon-color"):zi.white,u_horizon_fog_blend:i?i.properties.get("horizon-fog-blend"):1,u_is_globe_mode:n?1:0}),Gm={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function $m(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const r=t[i].split(" ");e.push(r.pop())}return e}class qm{constructor(t,e,i,r,n,s,o,a,l=[]){const c=t.gl;this.program=c.createProgram();const h=$m(e.staticAttributes),u=i?i.getBinderAttributes():[],p=h.concat(u),d=jf.prelude.staticUniforms?$m(jf.prelude.staticUniforms):[],f=o.staticUniforms?$m(o.staticUniforms):[],m=e.staticUniforms?$m(e.staticUniforms):[],_=i?i.getBinderUniforms():[],g=d.concat(f).concat(m).concat(_),y=[];for(const t of g)y.indexOf(t)<0&&y.push(t);const x=i?i.defines():[];um(c)&&x.unshift("#version 300 es"),n&&x.push("#define OVERDRAW_INSPECTOR;"),s&&x.push("#define TERRAIN3D;"),a&&x.push(a),l&&x.push(...l);let v=x.concat(jf.prelude.fragmentSource,o.fragmentSource,e.fragmentSource).join("\n"),b=x.concat(jf.prelude.vertexSource,o.vertexSource,e.vertexSource).join("\n");um(c)||(v=function(t){return t.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(v),b=function(t){return t.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(b));const w=c.createShader(c.FRAGMENT_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(w,v),c.compileShader(w),!c.getShaderParameter(w,c.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${c.getShaderInfoLog(w)}`);c.attachShader(this.program,w);const T=c.createShader(c.VERTEX_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(T,b),c.compileShader(T),!c.getShaderParameter(T,c.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${c.getShaderInfoLog(T)}`);c.attachShader(this.program,T),this.attributes={};const P={};this.numAttributes=p.length;for(let t=0;t<this.numAttributes;t++)p[t]&&(c.bindAttribLocation(this.program,t,p[t]),this.attributes[p[t]]=t);if(c.linkProgram(this.program),!c.getProgramParameter(this.program,c.LINK_STATUS))throw new Error(`Program failed to link: ${c.getProgramInfoLog(this.program)}`);c.deleteShader(T),c.deleteShader(w);for(let t=0;t<y.length;t++){const e=y[t];if(e&&!P[e]){const t=c.getUniformLocation(this.program,e);t&&(P[e]=t)}}this.fixedUniforms=r(t,P),this.terrainUniforms=((t,e)=>({u_depth:new _l(t,e.u_depth),u_terrain:new _l(t,e.u_terrain),u_terrain_dim:new gl(t,e.u_terrain_dim),u_terrain_matrix:new Sl(t,e.u_terrain_matrix),u_terrain_unpack:new vl(t,e.u_terrain_unpack),u_terrain_exaggeration:new gl(t,e.u_terrain_exaggeration)}))(t,P),this.projectionUniforms=((t,e)=>({u_projection_matrix:new Sl(t,e.u_projection_matrix),u_projection_tile_mercator_coords:new vl(t,e.u_projection_tile_mercator_coords),u_projection_clipping_plane:new vl(t,e.u_projection_clipping_plane),u_projection_transition:new gl(t,e.u_projection_transition),u_projection_fallback_matrix:new Sl(t,e.u_projection_fallback_matrix)}))(t,P),this.binderUniforms=i?i.getUniforms(t,P):[]}draw(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y){const x=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(r),t.setColorMode(n),t.setCullFace(s),a){t.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,a.depthTexture),t.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,a.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(a[t])}if(l)for(const t in l)this.projectionUniforms[Gm[t]].set(l[t]);if(o)for(const t in this.fixedUniforms)this.fixedUniforms[t].set(o[t]);m&&m.setUniforms(t,this.binderUniforms,d,{zoom:f});let v=0;switch(e){case x.LINES:v=2;break;case x.TRIANGLES:v=3;break;case x.LINE_STRIP:v=1}for(const i of p.get()){const r=i.vaos||(i.vaos={});(r[c]||(r[c]=new Um)).bind(t,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,_,g,y),x.drawElements(e,i.primitiveLength*v,x.UNSIGNED_SHORT,i.primitiveOffset*v*2)}}}function Wm(t,e,i){const r=1/tt(i,1,e.transform.tileZoom),n=Math.pow(2,i.tileID.overscaledZ),s=i.tileSize*Math.pow(2,e.transform.tileZoom)/n,o=s*(i.tileID.canonical.x+i.tileID.wrap*n),a=s*i.tileID.canonical.y;return{u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[r,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[o>>16,a>>16],u_pixel_coord_lower:[65535&o,65535&a]}}const Hm=(t,e,i,r)=>{const n=t.style.light,s=n.properties.get("position"),o=[s.x,s.y,s.z],a=m();var l,c,h,u;"viewport"===n.properties.get("anchor")&&(l=a,c=t.transform.bearingInRadians,h=Math.sin(c),u=Math.cos(c),l[0]=u,l[1]=h,l[2]=0,l[3]=-h,l[4]=u,l[5]=0,l[6]=0,l[7]=0,l[8]=1),function(t,e,i){var r=e[0],n=e[1],s=e[2];t[0]=r*i[0]+n*i[3]+s*i[6],t[1]=r*i[1]+n*i[4]+s*i[7],t[2]=r*i[2]+n*i[5]+s*i[8]}(o,o,a);const p=t.transform.transformLightDirection(o),d=n.properties.get("color");return{u_lightpos:o,u_lightpos_globe:p,u_lightintensity:n.properties.get("intensity"),u_lightcolor:[d.r,d.g,d.b],u_vertical_gradient:+e,u_opacity:i,u_fill_translate:r}},Xm=(t,e,i,r,n,s,o)=>wt(Hm(t,e,i,r),Wm(s,t,o),{u_height_factor:-Math.pow(2,n.overscaledZ)/o.tileSize/8}),Ym=(t,e,i,r)=>wt(Wm(e,t,i),{u_fill_translate:r}),Km=t=>({u_fill_translate:t}),Jm=(t,e)=>({u_world:t,u_fill_translate:e}),Qm=(t,e,i,r,n)=>wt(Ym(t,e,i,n),{u_world:r}),t_=(t,e,i,r,n)=>{const s=t.transform;let o,a,l=0;if("map"===i.paint.get("circle-pitch-alignment")){const t=tt(e,1,s.zoom);o=!0,a=[t,t],l=t/(Q*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*n}else o=!1,a=s.pixelsToGLUnits;return{u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===i.paint.get("circle-pitch-scale")),u_pitch_with_map:+o,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:a,u_globe_extrude_scale:l,u_translate:r}},e_=t=>({u_pixel_extrude_scale:[1/t.width,1/t.height]}),i_=t=>({u_viewport_size:[t.width,t.height]}),r_=(t,e=1)=>({u_color:t,u_overlay:0,u_overlay_scale:e}),n_=(t,e,i,r)=>{const n=tt(t,1,e)/(Q*Math.pow(2,t.tileID.overscaledZ))*2*Math.PI*r;return{u_extrude_scale:tt(t,1,e),u_intensity:i,u_globe_extrude_scale:n}},s_=(t,e,i,r)=>{const n=_();I(n,0,t.width,t.height,0,0,1);const s=t.context.gl;return{u_matrix:n,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:i,u_color_ramp:r,u_opacity:e.paint.get("heatmap-opacity")}},o_=(t,e,i)=>{const r=i.paint.get("hillshade-accent-color");let n;switch(i.paint.get("hillshade-method")){case"basic":n=4;break;case"combined":n=1;break;case"igor":n=2;break;case"multidirectional":n=3;break;default:n=0}const s=i.getIlluminationProperties();for(let e=0;e<s.directionRadians.length;e++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s.directionRadians[e]+=t.transform.bearingInRadians);return{u_image:0,u_latrange:l_(0,e.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:s.altitudeRadians,u_azimuths:s.directionRadians,u_accent:r,u_method:n,u_highlights:s.highlightColor,u_shadows:s.shadowColor}},a_=(t,e)=>{const i=e.stride,r=_();return I(r,0,Q,-8192,0,0,1),b(r,r,[0,-8192,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:t.overscaledZ,u_unpack:e.getUnpackVector()}};function l_(t,e){const i=Math.pow(2,e.canonical.z),r=e.canonical.y;return[new Up(0,r/i).toLngLat().lat,new Up(0,(r+1)/i).toLngLat().lat]}const c_=(t,e,i=0)=>({u_image:0,u_unpack:e.getUnpackVector(),u_dimension:[e.stride,e.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:t.paint.get("color-relief-opacity")}),h_=(t,e,i,r)=>{const n=t.transform;return{u_translation:m_(t,e,i),u_ratio:r/tt(e,1,n.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},u_=(t,e,i,r,n)=>wt(h_(t,e,i,r),{u_image:0,u_image_height:n}),p_=(t,e,i,r,n)=>{const s=t.transform,o=f_(e,s);return{u_translation:m_(t,e,i),u_texsize:e.imageAtlasTexture.size,u_ratio:r/tt(e,1,s.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[o,n.fromScale,n.toScale],u_fade:n.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},d_=(t,e,i,r,n,s)=>{const o=t.lineAtlas,a=f_(e,t.transform),l="round"===i.layout.get("line-cap"),c=o.getDash(n.from,l),h=o.getDash(n.to,l),u=c.width*s.fromScale,p=h.width*s.toScale;return wt(h_(t,e,i,r),{u_patternscale_a:[a/u,-c.height/2],u_patternscale_b:[a/p,-h.height/2],u_sdfgamma:o.width/(256*Math.min(u,p)*t.pixelRatio)/2,u_image:0,u_tex_y_a:c.y,u_tex_y_b:h.y,u_mix:s.t})};function f_(t,e){return 1/tt(t,1,e.tileZoom)}function m_(t,e,i){return ot(t.transform,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const __=(t,e,i,r,n)=>{return{u_tl_parent:t,u_scale_parent:e,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(o=r.paint.get("raster-saturation"),o>0?1-1/(1.001-o):-o),u_contrast_factor:(s=r.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:g_(r.paint.get("raster-hue-rotate")),u_coords_top:[n[0].x,n[0].y,n[1].x,n[1].y],u_coords_bottom:[n[3].x,n[3].y,n[2].x,n[2].y]};var s,o};function g_(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return[(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const y_=(t,e,i,r,n,s,o,a,l,c,h,u,p)=>{const d=o.transform;return{u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:d.cameraToCenterDistance,u_pitch:d.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:d.width/d.height,u_fade_change:o.options.fadeDuration?o.symbolFadeChange:1,u_label_plane_matrix:a,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+r,u_is_along_line:n,u_is_variable_anchor:s,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:p}},x_=(t,e,i,r,n,s,o,a,l,c,h,u,p,d)=>{const f=o.transform;return wt(y_(t,e,i,r,n,s,o,a,l,c,h,u,d),{u_gamma_scale:r?Math.cos(f.pitch*Math.PI/180)*f.cameraToCenterDistance:1,u_device_pixel_ratio:o.pixelRatio,u_is_halo:1})},v_=(t,e,i,r,n,s,o,a,l,c,h,u,p)=>wt(x_(t,e,i,r,n,s,o,a,l,c,!0,h,0,p),{u_texsize_icon:u,u_texture_icon:1}),b_=(t,e)=>({u_opacity:t,u_color:e}),w_=(t,e,i,r,n)=>wt(function(t,e,i,r){const n=i.imageManager.getPattern(t.from.toString()),s=i.imageManager.getPattern(t.to.toString()),{width:o,height:a}=i.imageManager.getPixelSize(),l=Math.pow(2,r.tileID.overscaledZ),c=r.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(r.tileID.canonical.x+r.tileID.wrap*l),u=c*r.tileID.canonical.y;return{u_image:0,u_pattern_tl_a:n.tl,u_pattern_br_a:n.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[o,a],u_mix:e.t,u_pattern_size_a:n.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/tt(r,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(i,n,e,r),{u_opacity:t}),T_=(t,e)=>{},P_={fillExtrusion:(t,e)=>({u_lightpos:new xl(t,e.u_lightpos),u_lightpos_globe:new xl(t,e.u_lightpos_globe),u_lightintensity:new gl(t,e.u_lightintensity),u_lightcolor:new xl(t,e.u_lightcolor),u_vertical_gradient:new gl(t,e.u_vertical_gradient),u_opacity:new gl(t,e.u_opacity),u_fill_translate:new yl(t,e.u_fill_translate)}),fillExtrusionPattern:(t,e)=>({u_lightpos:new xl(t,e.u_lightpos),u_lightpos_globe:new xl(t,e.u_lightpos_globe),u_lightintensity:new gl(t,e.u_lightintensity),u_lightcolor:new xl(t,e.u_lightcolor),u_vertical_gradient:new gl(t,e.u_vertical_gradient),u_height_factor:new gl(t,e.u_height_factor),u_opacity:new gl(t,e.u_opacity),u_fill_translate:new yl(t,e.u_fill_translate),u_image:new _l(t,e.u_image),u_texsize:new yl(t,e.u_texsize),u_pixel_coord_upper:new yl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new yl(t,e.u_pixel_coord_lower),u_scale:new xl(t,e.u_scale),u_fade:new gl(t,e.u_fade)}),fill:(t,e)=>({u_fill_translate:new yl(t,e.u_fill_translate)}),fillPattern:(t,e)=>({u_image:new _l(t,e.u_image),u_texsize:new yl(t,e.u_texsize),u_pixel_coord_upper:new yl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new yl(t,e.u_pixel_coord_lower),u_scale:new xl(t,e.u_scale),u_fade:new gl(t,e.u_fade),u_fill_translate:new yl(t,e.u_fill_translate)}),fillOutline:(t,e)=>({u_world:new yl(t,e.u_world),u_fill_translate:new yl(t,e.u_fill_translate)}),fillOutlinePattern:(t,e)=>({u_world:new yl(t,e.u_world),u_image:new _l(t,e.u_image),u_texsize:new yl(t,e.u_texsize),u_pixel_coord_upper:new yl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new yl(t,e.u_pixel_coord_lower),u_scale:new xl(t,e.u_scale),u_fade:new gl(t,e.u_fade),u_fill_translate:new yl(t,e.u_fill_translate)}),circle:(t,e)=>({u_camera_to_center_distance:new gl(t,e.u_camera_to_center_distance),u_scale_with_map:new _l(t,e.u_scale_with_map),u_pitch_with_map:new _l(t,e.u_pitch_with_map),u_extrude_scale:new yl(t,e.u_extrude_scale),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_globe_extrude_scale:new gl(t,e.u_globe_extrude_scale),u_translate:new yl(t,e.u_translate)}),collisionBox:(t,e)=>({u_pixel_extrude_scale:new yl(t,e.u_pixel_extrude_scale)}),collisionCircle:(t,e)=>({u_viewport_size:new yl(t,e.u_viewport_size)}),debug:(t,e)=>({u_color:new bl(t,e.u_color),u_overlay:new _l(t,e.u_overlay),u_overlay_scale:new gl(t,e.u_overlay_scale)}),depth:T_,clippingMask:T_,heatmap:(t,e)=>({u_extrude_scale:new gl(t,e.u_extrude_scale),u_intensity:new gl(t,e.u_intensity),u_globe_extrude_scale:new gl(t,e.u_globe_extrude_scale)}),heatmapTexture:(t,e)=>({u_matrix:new Sl(t,e.u_matrix),u_world:new yl(t,e.u_world),u_image:new _l(t,e.u_image),u_color_ramp:new _l(t,e.u_color_ramp),u_opacity:new gl(t,e.u_opacity)}),hillshade:(t,e)=>({u_image:new _l(t,e.u_image),u_latrange:new yl(t,e.u_latrange),u_exaggeration:new gl(t,e.u_exaggeration),u_altitudes:new Tl(t,e.u_altitudes),u_azimuths:new Tl(t,e.u_azimuths),u_accent:new bl(t,e.u_accent),u_method:new _l(t,e.u_method),u_shadows:new wl(t,e.u_shadows),u_highlights:new wl(t,e.u_highlights)}),hillshadePrepare:(t,e)=>({u_matrix:new Sl(t,e.u_matrix),u_image:new _l(t,e.u_image),u_dimension:new yl(t,e.u_dimension),u_zoom:new gl(t,e.u_zoom),u_unpack:new vl(t,e.u_unpack)}),colorRelief:(t,e)=>({u_image:new _l(t,e.u_image),u_unpack:new vl(t,e.u_unpack),u_dimension:new yl(t,e.u_dimension),u_elevation_stops:new _l(t,e.u_elevation_stops),u_color_stops:new _l(t,e.u_color_stops),u_color_ramp_size:new _l(t,e.u_color_ramp_size),u_opacity:new gl(t,e.u_opacity)}),line:(t,e)=>({u_translation:new yl(t,e.u_translation),u_ratio:new gl(t,e.u_ratio),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_units_to_pixels:new yl(t,e.u_units_to_pixels)}),lineGradient:(t,e)=>({u_translation:new yl(t,e.u_translation),u_ratio:new gl(t,e.u_ratio),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_units_to_pixels:new yl(t,e.u_units_to_pixels),u_image:new _l(t,e.u_image),u_image_height:new gl(t,e.u_image_height)}),linePattern:(t,e)=>({u_translation:new yl(t,e.u_translation),u_texsize:new yl(t,e.u_texsize),u_ratio:new gl(t,e.u_ratio),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_image:new _l(t,e.u_image),u_units_to_pixels:new yl(t,e.u_units_to_pixels),u_scale:new xl(t,e.u_scale),u_fade:new gl(t,e.u_fade)}),lineSDF:(t,e)=>({u_translation:new yl(t,e.u_translation),u_ratio:new gl(t,e.u_ratio),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_units_to_pixels:new yl(t,e.u_units_to_pixels),u_patternscale_a:new yl(t,e.u_patternscale_a),u_patternscale_b:new yl(t,e.u_patternscale_b),u_sdfgamma:new gl(t,e.u_sdfgamma),u_image:new _l(t,e.u_image),u_tex_y_a:new gl(t,e.u_tex_y_a),u_tex_y_b:new gl(t,e.u_tex_y_b),u_mix:new gl(t,e.u_mix)}),raster:(t,e)=>({u_tl_parent:new yl(t,e.u_tl_parent),u_scale_parent:new gl(t,e.u_scale_parent),u_buffer_scale:new gl(t,e.u_buffer_scale),u_fade_t:new gl(t,e.u_fade_t),u_opacity:new gl(t,e.u_opacity),u_image0:new _l(t,e.u_image0),u_image1:new _l(t,e.u_image1),u_brightness_low:new gl(t,e.u_brightness_low),u_brightness_high:new gl(t,e.u_brightness_high),u_saturation_factor:new gl(t,e.u_saturation_factor),u_contrast_factor:new gl(t,e.u_contrast_factor),u_spin_weights:new xl(t,e.u_spin_weights),u_coords_top:new vl(t,e.u_coords_top),u_coords_bottom:new vl(t,e.u_coords_bottom)}),symbolIcon:(t,e)=>({u_is_size_zoom_constant:new _l(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new _l(t,e.u_is_size_feature_constant),u_size_t:new gl(t,e.u_size_t),u_size:new gl(t,e.u_size),u_camera_to_center_distance:new gl(t,e.u_camera_to_center_distance),u_pitch:new gl(t,e.u_pitch),u_rotate_symbol:new _l(t,e.u_rotate_symbol),u_aspect_ratio:new gl(t,e.u_aspect_ratio),u_fade_change:new gl(t,e.u_fade_change),u_label_plane_matrix:new Sl(t,e.u_label_plane_matrix),u_coord_matrix:new Sl(t,e.u_coord_matrix),u_is_text:new _l(t,e.u_is_text),u_pitch_with_map:new _l(t,e.u_pitch_with_map),u_is_along_line:new _l(t,e.u_is_along_line),u_is_variable_anchor:new _l(t,e.u_is_variable_anchor),u_texsize:new yl(t,e.u_texsize),u_texture:new _l(t,e.u_texture),u_translation:new yl(t,e.u_translation),u_pitched_scale:new gl(t,e.u_pitched_scale)}),symbolSDF:(t,e)=>({u_is_size_zoom_constant:new _l(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new _l(t,e.u_is_size_feature_constant),u_size_t:new gl(t,e.u_size_t),u_size:new gl(t,e.u_size),u_camera_to_center_distance:new gl(t,e.u_camera_to_center_distance),u_pitch:new gl(t,e.u_pitch),u_rotate_symbol:new _l(t,e.u_rotate_symbol),u_aspect_ratio:new gl(t,e.u_aspect_ratio),u_fade_change:new gl(t,e.u_fade_change),u_label_plane_matrix:new Sl(t,e.u_label_plane_matrix),u_coord_matrix:new Sl(t,e.u_coord_matrix),u_is_text:new _l(t,e.u_is_text),u_pitch_with_map:new _l(t,e.u_pitch_with_map),u_is_along_line:new _l(t,e.u_is_along_line),u_is_variable_anchor:new _l(t,e.u_is_variable_anchor),u_texsize:new yl(t,e.u_texsize),u_texture:new _l(t,e.u_texture),u_gamma_scale:new gl(t,e.u_gamma_scale),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_is_halo:new _l(t,e.u_is_halo),u_translation:new yl(t,e.u_translation),u_pitched_scale:new gl(t,e.u_pitched_scale)}),symbolTextAndIcon:(t,e)=>({u_is_size_zoom_constant:new _l(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new _l(t,e.u_is_size_feature_constant),u_size_t:new gl(t,e.u_size_t),u_size:new gl(t,e.u_size),u_camera_to_center_distance:new gl(t,e.u_camera_to_center_distance),u_pitch:new gl(t,e.u_pitch),u_rotate_symbol:new _l(t,e.u_rotate_symbol),u_aspect_ratio:new gl(t,e.u_aspect_ratio),u_fade_change:new gl(t,e.u_fade_change),u_label_plane_matrix:new Sl(t,e.u_label_plane_matrix),u_coord_matrix:new Sl(t,e.u_coord_matrix),u_is_text:new _l(t,e.u_is_text),u_pitch_with_map:new _l(t,e.u_pitch_with_map),u_is_along_line:new _l(t,e.u_is_along_line),u_is_variable_anchor:new _l(t,e.u_is_variable_anchor),u_texsize:new yl(t,e.u_texsize),u_texsize_icon:new yl(t,e.u_texsize_icon),u_texture:new _l(t,e.u_texture),u_texture_icon:new _l(t,e.u_texture_icon),u_gamma_scale:new gl(t,e.u_gamma_scale),u_device_pixel_ratio:new gl(t,e.u_device_pixel_ratio),u_is_halo:new _l(t,e.u_is_halo),u_translation:new yl(t,e.u_translation),u_pitched_scale:new gl(t,e.u_pitched_scale)}),background:(t,e)=>({u_opacity:new gl(t,e.u_opacity),u_color:new bl(t,e.u_color)}),backgroundPattern:(t,e)=>({u_opacity:new gl(t,e.u_opacity),u_image:new _l(t,e.u_image),u_pattern_tl_a:new yl(t,e.u_pattern_tl_a),u_pattern_br_a:new yl(t,e.u_pattern_br_a),u_pattern_tl_b:new yl(t,e.u_pattern_tl_b),u_pattern_br_b:new yl(t,e.u_pattern_br_b),u_texsize:new yl(t,e.u_texsize),u_mix:new gl(t,e.u_mix),u_pattern_size_a:new yl(t,e.u_pattern_size_a),u_pattern_size_b:new yl(t,e.u_pattern_size_b),u_scale_a:new gl(t,e.u_scale_a),u_scale_b:new gl(t,e.u_scale_b),u_pixel_coord_upper:new yl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new yl(t,e.u_pixel_coord_lower),u_tile_units_to_pixels:new gl(t,e.u_tile_units_to_pixels)}),terrain:(t,e)=>({u_texture:new _l(t,e.u_texture),u_ele_delta:new gl(t,e.u_ele_delta),u_fog_matrix:new Sl(t,e.u_fog_matrix),u_fog_color:new bl(t,e.u_fog_color),u_fog_ground_blend:new gl(t,e.u_fog_ground_blend),u_fog_ground_blend_opacity:new gl(t,e.u_fog_ground_blend_opacity),u_horizon_color:new bl(t,e.u_horizon_color),u_horizon_fog_blend:new gl(t,e.u_horizon_fog_blend),u_is_globe_mode:new gl(t,e.u_is_globe_mode)}),terrainDepth:(t,e)=>({u_ele_delta:new gl(t,e.u_ele_delta)}),terrainCoords:(t,e)=>({u_texture:new _l(t,e.u_texture),u_terrain_coords_id:new gl(t,e.u_terrain_coords_id),u_ele_delta:new gl(t,e.u_ele_delta)}),projectionErrorMeasurement:(t,e)=>({u_input:new gl(t,e.u_input),u_output_expected:new gl(t,e.u_output_expected)}),atmosphere:(t,e)=>({u_sun_pos:new xl(t,e.u_sun_pos),u_atmosphere_blend:new gl(t,e.u_atmosphere_blend),u_globe_position:new xl(t,e.u_globe_position),u_globe_radius:new gl(t,e.u_globe_radius),u_inv_proj_matrix:new Sl(t,e.u_inv_proj_matrix)}),sky:(t,e)=>({u_sky_color:new bl(t,e.u_sky_color),u_horizon_color:new bl(t,e.u_horizon_color),u_horizon:new yl(t,e.u_horizon),u_horizon_normal:new yl(t,e.u_horizon_normal),u_sky_horizon_blend:new gl(t,e.u_sky_horizon_blend),u_sky_blend:new gl(t,e.u_sky_blend)})};class S_{constructor(t,e,i){this.context=t;const r=t.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const M_={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class I_{constructor(t,e,i,r){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=r,this.context=t;const n=t.gl;this.buffer=n.createBuffer(),t.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer)}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const r=e.attributes[this.attributes[i].name];void 0!==r&&t.enableVertexAttribArray(r)}}setVertexAttribPointers(t,e,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],s=e.attributes[n.name];void 0!==s&&t.vertexAttribPointer(s,n.components,t[M_[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class C_{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class E_ extends C_{getDefault(){return zi.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class A_ extends C_{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1)}}class z_ extends C_{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1)}}class k_ extends C_{getDefault(){return[!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class D_ extends C_{getDefault(){return!0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1)}}class R_ extends C_{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1)}}class L_ extends C_{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1)}}class B_ extends C_{getDefault(){const t=this.gl;return[t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1)}}class F_ extends C_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1}}class O_ extends C_{getDefault(){return[0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1)}}class j_ extends C_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1}}class V_ extends C_{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1)}}class N_ extends C_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1}}class U_ extends C_{getDefault(){const t=this.gl;return[t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1)}}class Z_ extends C_{getDefault(){return zi.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class G_ extends C_{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1)}}class $_ extends C_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1}}class q_ extends C_{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1)}}class W_ extends C_{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1)}}class H_ extends C_{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1)}}class X_ extends C_{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1)}}class Y_ extends C_{getDefault(){const t=this.gl;return[0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class K_ extends C_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1}}class J_ extends C_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class Q_ extends C_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1}}class tg extends C_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class eg extends C_{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class ig extends C_{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;um(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1}}class rg extends C_{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1}}class ng extends C_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1}}class sg extends C_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1}}class og extends C_{constructor(t,e){super(t),this.context=t,this.parent=e}getDefault(){return null}}class ag extends og{setDirty(){this.dirty=!0}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1}}class lg extends og{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class cg extends og{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}const hg="Framebuffer is not complete";class ug{constructor(t,e,i,r,n){this.context=t,this.width=e,this.height=i;const s=t.gl,o=this.framebuffer=s.createFramebuffer();if(this.colorAttachment=new ag(t,o),r)this.depthAttachment=n?new cg(t,o):new lg(t,o);else if(n)throw new Error("Stencil cannot be set without depth");if(s.checkFramebufferStatus(s.FRAMEBUFFER)!==s.FRAMEBUFFER_COMPLETE)throw new Error(hg)}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e)}t.deleteFramebuffer(this.framebuffer)}}class pg{constructor(t){var e,i;if(this.gl=t,this.clearColor=new E_(this),this.clearDepth=new A_(this),this.clearStencil=new z_(this),this.colorMask=new k_(this),this.depthMask=new D_(this),this.stencilMask=new R_(this),this.stencilFunc=new L_(this),this.stencilOp=new B_(this),this.stencilTest=new F_(this),this.depthRange=new O_(this),this.depthTest=new j_(this),this.depthFunc=new V_(this),this.blend=new N_(this),this.blendFunc=new U_(this),this.blendColor=new Z_(this),this.blendEquation=new G_(this),this.cullFace=new $_(this),this.cullFaceSide=new q_(this),this.frontFace=new W_(this),this.program=new H_(this),this.activeTexture=new X_(this),this.viewport=new Y_(this),this.bindFramebuffer=new K_(this),this.bindRenderbuffer=new J_(this),this.bindTexture=new Q_(this),this.bindVertexBuffer=new tg(this),this.bindElementBuffer=new eg(this),this.bindVertexArray=new ig(this),this.pixelStoreUnpack=new rg(this),this.pixelStoreUnpackPremultiplyAlpha=new ng(this),this.pixelStoreUnpackFlipY=new sg(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),um(t)){this.HALF_FLOAT=t.HALF_FLOAT;const r=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,t.getExtension("EXT_color_buffer_float")}else{t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(t,e){return new S_(this,t,e)}createVertexBuffer(t,e,i){return new I_(this,t,e,i)}createRenderbuffer(t,e,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),n}createFramebuffer(t,e,i,r){return new ug(this,t,e,i,r)}clear({color:t,depth:e,stencil:i}){const r=this.gl;let n=0;t&&(n|=r.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(n|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(n|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(n)}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace))}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1)}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1)}setColorMode(t){At(t.blendFunction,nm.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask)}createVertexArray(){var t;return um(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return um(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null)}}let dg;function fg(t,e,i,r,n){const s=t.context,o=t.transform,a=s.gl,l=t.useProgram("collisionBox"),c=[];let h=0,u=0;for(let p=0;p<r.length;p++){const d=r[p],f=e.getTile(d).getBucket(i);if(!f)continue;const m=n?f.textCollisionBox:f.iconCollisionBox,_=f.collisionCircleArray;_.length>0&&(c.push({circleArray:_,circleOffset:u,coord:d}),h+=_.length/4,u=h),m&&l.draw(s,a.LINES,am.disabled,cm.disabled,t.colorModeForRenderPass(),om.disabled,e_(t.transform),t.style.map.terrain&&t.style.map.terrain.getTerrainData(d),o.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,t.transform.zoom,null,null,m.collisionVertexBuffer)}if(!n||!c.length)return;const p=t.useProgram("collisionCircle"),d=new qa;d.resize(4*h),d._trim();let f=0;for(const t of c)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,r=t.circleArray[i+0],n=t.circleArray[i+1],s=t.circleArray[i+2],o=t.circleArray[i+3];d.emplace(f++,r,n,s,o,0),d.emplace(f++,r,n,s,o,1),d.emplace(f++,r,n,s,o,2),d.emplace(f++,r,n,s,o,3)}(!dg||dg.length<2*h)&&(dg=function(t){const e=2*t,i=new Ha;i.resize(e),i._trim();for(let t=0;t<e;t++){const e=6*t;i.uint16[e+0]=4*t+0,i.uint16[e+1]=4*t+1,i.uint16[e+2]=4*t+2,i.uint16[e+3]=4*t+2,i.uint16[e+4]=4*t+3,i.uint16[e+5]=4*t+0}return i}(h));const m=s.createIndexBuffer(dg,!0),_=s.createVertexBuffer(d,au.members,!0);for(const e of c){const r=i_(t.transform);p.draw(s,a.TRIANGLES,am.disabled,cm.disabled,t.colorModeForRenderPass(),om.disabled,r,t.style.map.terrain&&t.style.map.terrain.getTerrainData(e.coord),null,i.id,_,m,tl.simpleSegment(0,2*e.circleOffset,e.circleArray.length,e.circleArray.length/2),null,t.transform.zoom,null,null,null)}_.destroy(),m.destroy()}const mg=y(new Float32Array(16));function _g(t,e,i,r,n,o){const{horizontalAlign:a,verticalAlign:l}=zu(t);return new s((-(a-.5)*e/n+r[0])*o,(-(l-.5)*i/n+r[1])*o)}function gg(t,e,i,r,n,o){const a=e.tileAnchorPoint.add(new s(e.translation[0],e.translation[1]));if(e.pitchWithMap){let t=r.mult(o);i||(t=t.rotate(-n));const s=a.add(t);return Od(s.x,s.y,e.pitchedLabelPlaneMatrix,e.getElevation).point}if(i){const i=Wd(e.tileAnchorPoint.x+1,e.tileAnchorPoint.y,e).point.sub(t),n=Math.atan(i.y/i.x)+(i.x<0?Math.PI:0);return t.add(r.rotate(n))}return t.add(r)}function yg(t,e,i,r,n,o,a,l,c,h,u,p){const d=t.text.placedSymbolArray,f=t.text.dynamicLayoutVertexArray,m=t.icon.dynamicLayoutVertexArray,_={};f.clear();for(let m=0;m<d.length;m++){const g=d.get(m),y=g.hidden||!g.crossTileID||t.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(y){const r=new s(g.anchorX,g.anchorY),d={getElevation:p,width:n.width,height:n.height,pitchedLabelPlaneMatrix:o,pitchWithMap:i,transform:n,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=i?Xd(r.x,r.y,d):Wd(r.x,r.y,d),x=jd(n.cameraToCenterDistance,m.signedDistanceFromCamera);let v=Du(t.textSizeData,l,g)*x/24;i&&(v*=t.tilePixelRatio/a);const{width:b,height:w,anchor:T,textOffset:P,textBoxScale:S}=y,M=_g(T,b,w,P,S,v),I=n.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),C=gg(m.point,d,e,M,-n.bearingInRadians,I),E=t.allowVerticalPlacement&&g.placedOrientation===Au.vertical?Math.PI/2:0;for(let t=0;t<g.numGlyphs;t++)Ou(f,C,E);c&&g.associatedIconIndex>=0&&(_[g.associatedIconIndex]={shiftedAnchor:C,angle:E})}else tf(g.numGlyphs,f)}if(c){m.clear();const e=t.icon.placedSymbolArray;for(let t=0;t<e.length;t++){const i=e.get(t);if(i.hidden)tf(i.numGlyphs,m);else{const e=_[t];if(e)for(let t=0;t<i.numGlyphs;t++)Ou(m,e.shiftedAnchor,e.angle);else tf(i.numGlyphs,m)}}t.icon.dynamicLayoutVertexBuffer.updateData(m)}t.text.dynamicLayoutVertexBuffer.updateData(f)}function xg(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function vg(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=t.context,f=d.gl,m=t.transform,g="map"===a,y="map"===l,v="viewport"!==a&&"point"!==i.layout.get("symbol-placement"),b=g&&!y&&!v,w=!i.layout.get("symbol-sort-key").isConstant();let T=!1;const P=t.getDepthModeForSublayer(0,am.ReadOnly),S=i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"),M=[],I=m.getCircleRadiusCorrection();for(const a of r){const r=e.getTile(a),l=r.getBucket(i);if(!l)continue;const h=n?l.text:l.icon;if(!h||!h.segments.get().length||!h.hasVisibleVertices)continue;const u=h.programConfigurations.get(i.id),d=n||l.sdfIcons,P=n?l.textSizeData:l.iconSizeData,C=y||0!==m.pitch,E=t.useProgram(xg(d,n,l),u),A=Ru(P,m.zoom),z=t.style.map.terrain&&t.style.map.terrain.getTerrainData(a);let k,D,R,L,B=[0,0],F=null;if(n)D=r.glyphAtlasTexture,R=f.LINEAR,k=r.glyphAtlasTexture.size,l.iconsInText&&(B=r.imageAtlasTexture.size,F=r.imageAtlasTexture,L=C||t.options.rotating||t.options.zooming||"composite"===P.kind||"camera"===P.kind?f.LINEAR:f.NEAREST);else{const e=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;D=r.imageAtlasTexture,R=d||t.options.rotating||t.options.zooming||e||C?f.LINEAR:f.NEAREST,k=r.imageAtlasTexture.size}const O=tt(r,1,t.transform.zoom),j=Ld(g,t.transform,O),V=_();x(V,j);const N=Bd(y,g,t.transform,O),U=ot(m,r,s,o),Z=m.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!p,applyTerrainMatrix:!0}),G=S&&l.hasTextData(),$="none"!==i.layout.get("icon-text-fit")&&G&&l.hasIconData();if(v){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(a,e,i):null,r="map"===i.layout.get("text-rotation-alignment");Nd(l,t,n,j,V,y,c,r,a.toUnwrapped(),m.width,m.height,U,e)}const q=n&&S||$,W=v||q?mg:y?j:t.transform.clipSpaceToPixelsMatrix,H=d&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let X;X=d?l.iconsInText?v_(P.kind,A,b,y,v,q,t,W,N,U,k,B,I):x_(P.kind,A,b,y,v,q,t,W,N,U,n,k,0,I):y_(P.kind,A,b,y,v,q,t,W,N,U,n,k,I);const Y={program:E,buffers:h,uniformValues:X,projectionData:Z,atlasTexture:D,atlasTextureIcon:F,atlasInterpolation:R,atlasInterpolationIcon:L,isSDF:d,hasHalo:H};if(w&&l.canOverlap){T=!0;const t=h.segments.get();for(const e of t)M.push({segments:new tl([e]),sortKey:e.sortKey,state:Y,terrainData:z})}else M.push({segments:h.segments,sortKey:0,state:Y,terrainData:z})}T&&M.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of M){const r=e.state;if(d.activeTexture.set(f.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,f.CLAMP_TO_EDGE),r.atlasTextureIcon&&(d.activeTexture.set(f.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,f.CLAMP_TO_EDGE)),r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,bg(r.buffers,e.segments,i,t,r.program,P,h,u,n,r.projectionData,e.terrainData)),n.u_is_halo=0}bg(r.buffers,e.segments,i,t,r.program,P,h,u,r.uniformValues,r.projectionData,e.terrainData)}}function bg(t,e,i,r,n,s,o,a,l,c,h){const u=r.context;n.draw(u,u.gl.TRIANGLES,s,o,a,om.backCCW,l,h,c,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,r.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer)}function wg(t,e,i,r,n){const s=t.context,o=s.gl,a=cm.disabled,l=new nm([o.ONE,o.ONE],zi.transparent,[!0,!0,!0,!0]),c=e.getBucket(i);if(!c)return;const h=r.key;let u=i.heatmapFbos.get(h);u||(u=Pg(s,e.tileSize,e.tileSize),i.heatmapFbos.set(h,u)),s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,e.tileSize,e.tileSize]),s.clear({color:zi.transparent});const p=c.programConfigurations.get(i.id),d=t.useProgram("heatmap",p,!n),f=t.transform.getProjectionData({overscaledTileID:e.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),m=t.style.map.terrain.getTerrainData(r);d.draw(s,o.TRIANGLES,am.disabled,a,l,om.disabled,n_(e,t.transform.zoom,i.paint.get("heatmap-intensity"),1),m,f,i.id,c.layoutVertexBuffer,c.indexBuffer,c.segments,i.paint,t.transform.zoom,p)}function Tg(t,e,i,r,n){const s=t.context,o=s.gl,a=t.transform;s.setColorMode(t.colorModeForRenderPass());const l=Sg(s,e),c=i.key,h=e.heatmapFbos.get(c);if(!h)return;s.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,h.colorAttachment.get()),s.activeTexture.set(o.TEXTURE1),l.bind(o.LINEAR,o.CLAMP_TO_EDGE);const u=a.getProjectionData({overscaledTileID:i,applyTerrainMatrix:n,applyGlobeMatrix:!r});t.useProgram("heatmapTexture").draw(s,o.TRIANGLES,am.disabled,cm.disabled,t.colorModeForRenderPass(),om.disabled,s_(t,e,0,1),null,u,e.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments,e.paint,a.zoom),h.destroy(),e.heatmapFbos.delete(c)}function Pg(t,e,i){var r,n;const s=t.gl,o=s.createTexture();s.bindTexture(s.TEXTURE_2D,o),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR);const a=null!==(r=t.HALF_FLOAT)&&void 0!==r?r:s.UNSIGNED_BYTE,l=null!==(n=t.RGBA16F)&&void 0!==n?n:s.RGBA;s.texImage2D(s.TEXTURE_2D,0,l,e,i,0,s.RGBA,a,null);const c=t.createFramebuffer(e,i,!1,!1);return c.colorAttachment.set(o),c}function Sg(t,e){return e.colorRampTexture||(e.colorRampTexture=new Ec(t,e.colorRamp,t.gl.RGBA)),e.colorRampTexture}function Mg(t,e,i,r,n){if(!i||!r||!r.imageAtlas)return;const s=r.imageAtlas.patternPositions;let o=s[i.to.toString()],a=s[i.from.toString()];if(!o&&a&&(o=a),!a&&o&&(a=o),!o||!a){const t=n.getPaintProperty(e);o=s[t],a=s[t]}o&&a&&t.setConstantPatternPositions(o,a)}function Ig(t,e,i,r,n,s,o,a){const l=t.context.gl,c="fill-pattern",h=i.paint.get(c),u=h&&h.constantOr(1),p=i.getCrossfadeParameters();let d,f,m,_,g;const y=t.transform,x=i.paint.get("fill-translate"),v=i.paint.get("fill-translate-anchor");o?(f=u&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=l.LINES):(f=u?"fillPattern":"fill",d=l.TRIANGLES);const b=h.constantOr(null);for(const h of r){const r=e.getTile(h);if(u&&!r.patternsLoaded())continue;const w=r.getBucket(i);if(!w)continue;const T=w.programConfigurations.get(i.id),P=t.useProgram(f,T),S=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h);u&&(t.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),T.updatePaintBuffers(p)),Mg(T,c,b,r,i);const M=y.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),I=ot(y,r,x,v);if(o){_=w.indexBuffer2,g=w.segments2;const e=[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===f&&u?Qm(t,p,r,e,I):Jm(e,I)}else _=w.indexBuffer,g=w.segments,m=u?Ym(t,p,r,I):Km(I);const C=t.stencilModeForClipping(h);P.draw(t.context,d,n,C,s,om.backCCW,m,S,M,i.id,w.layoutVertexBuffer,_,g,i.paint,t.transform.zoom,T)}}function Cg(t,e,i,r,n,s,o,a){const l=t.context,c=l.gl,h="fill-extrusion-pattern",u=i.paint.get(h),p=u.constantOr(1),d=i.getCrossfadeParameters(),f=i.paint.get("fill-extrusion-opacity"),m=u.constantOr(null),_=t.transform;for(const u of r){const r=e.getTile(u),g=r.getBucket(i);if(!g)continue;const y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(u),x=g.programConfigurations.get(i.id),v=t.useProgram(p?"fillExtrusionPattern":"fillExtrusion",x);p&&(t.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),x.updatePaintBuffers(d));const b=_.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!a,applyTerrainMatrix:!0});Mg(x,h,m,r,i);const w=ot(_,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),T=i.paint.get("fill-extrusion-vertical-gradient"),P=p?Xm(t,T,f,w,u,d,r):Hm(t,T,f,w);v.draw(l,l.gl.TRIANGLES,n,s,o,om.backCCW,P,y,b,i.id,g.layoutVertexBuffer,g.indexBuffer,g.segments,i.paint,t.transform.zoom,x,t.style.map.terrain&&g.centroidVertexBuffer)}}function Eg(t,e,i,r,n,s,o,a,l){var c;const h=t.style.projection,u=t.context,p=t.transform,d=u.gl,f=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=t.useProgram("hillshade",null,!1,f),_=!t.options.moving;for(const f of r){const r=e.getTile(f),g=r.fbo;if(!g)continue;const y=h.getMeshFromTileID(u,f.canonical,a,!0,"raster"),x=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(f);u.activeTexture.set(d.TEXTURE0),d.bindTexture(d.TEXTURE_2D,g.colorAttachment.get());const v=p.getProjectionData({overscaledTileID:f,aligned:_,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,d.TRIANGLES,s,n[f.overscaledZ],o,om.backCCW,o_(t,r,i),x,v,i.id,y.vertexBuffer,y.indexBuffer,y.segments)}}function Ag(t,e,i,r,n,s,o,a,l){var c;const h=t.style.projection,u=t.context,p=t.transform,d=u.gl,f=t.useProgram("colorRelief"),m=!t.options.moving;let _=!0,g=0;for(const y of r){const r=e.getTile(y),x=r.dem;if(_){const t=d.getParameter(d.MAX_TEXTURE_SIZE),{elevationTexture:e,colorTexture:r}=i.getColorRampTextures(u,t,x.getUnpackVector());u.activeTexture.set(d.TEXTURE1),e.bind(d.NEAREST,d.CLAMP_TO_EDGE),u.activeTexture.set(d.TEXTURE4),r.bind(d.LINEAR,d.CLAMP_TO_EDGE),_=!1,g=e.size[0]}if(!x||!x.data)continue;const v=x.stride,b=x.getPixels();if(u.activeTexture.set(d.TEXTURE0),u.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||t.getTileTexture(v),r.demTexture){const t=r.demTexture;t.update(b,{premultiply:!1}),t.bind(d.LINEAR,d.CLAMP_TO_EDGE)}else r.demTexture=new Ec(u,b,d.RGBA,{premultiply:!1}),r.demTexture.bind(d.LINEAR,d.CLAMP_TO_EDGE);const w=h.getMeshFromTileID(u,y.canonical,a,!0,"raster"),T=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(y),P=p.getProjectionData({overscaledTileID:y,aligned:m,applyGlobeMatrix:!l,applyTerrainMatrix:!0});f.draw(u,d.TRIANGLES,s,n[y.overscaledZ],o,om.backCCW,c_(i,r.dem,g),T,P,i.id,w.vertexBuffer,w.indexBuffer,w.segments)}}const zg=[new s(0,0),new s(Q,0),new s(Q,Q),new s(0,Q)];function kg(t,e,i,r,n,s,o,a,l=!1,c=!1){const h=r[r.length-1].overscaledZ,u=t.context,p=u.gl,d=t.useProgram("raster"),f=t.transform,m=t.style.projection,_=t.colorModeForRenderPass(),g=!t.options.moving;for(const y of r){const r=t.getDepthModeForSublayer(y.overscaledZ-h,1===i.paint.get("raster-opacity")?am.ReadWrite:am.ReadOnly,p.LESS),x=e.getTile(y);x.registerFadeDuration(i.paint.get("raster-fade-duration"));const v=e.findLoadedParent(y,0),b=e.findLoadedSibling(y),w=Dg(x,v||b||null,e,i,t.transform,t.style.map.terrain);let T,P;const S="nearest"===i.paint.get("raster-resampling")?p.NEAREST:p.LINEAR;u.activeTexture.set(p.TEXTURE0),x.texture.bind(S,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(p.TEXTURE1),v?(v.texture.bind(S,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),T=Math.pow(2,v.tileID.overscaledZ-x.tileID.overscaledZ),P=[x.tileID.canonical.x*T%1,x.tileID.canonical.y*T%1]):x.texture.bind(S,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),x.texture.useMipmap&&u.extTextureFilterAnisotropic&&t.transform.pitch>20&&p.texParameterf(p.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const M=t.style.map.terrain&&t.style.map.terrain.getTerrainData(y),I=f.getProjectionData({overscaledTileID:y,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),C=__(P||[0,0],T||1,w,i,a),E=m.getMeshFromTileID(u,y.canonical,s,o,"raster");d.draw(u,p.TRIANGLES,r,n?n[y.overscaledZ]:cm.disabled,_,l?om.frontCCW:om.backCCW,C,M,I,i.id,E.vertexBuffer,E.indexBuffer,E.segments)}}function Dg(t,e,i,r,n,s){const o=r.paint.get("raster-fade-duration");if(!s&&o>0){const r=Qt.now(),s=(r-t.timeAdded)/o,a=e?(r-e.timeAdded)/o:-1,l=i.getSource(),c=Md(n,{tileSize:l.tileSize,roundZoom:l.roundZoom}),h=!e||Math.abs(e.tileID.overscaledZ-c)>Math.abs(t.tileID.overscaledZ-c),u=h&&t.refreshedUponExpiration?1:vt(h?s:1-a,0,1);return t.refreshedUponExpiration&&s>=1&&(t.refreshedUponExpiration=!1),e?{opacity:1,mix:1-u}:{opacity:u,mix:0}}return{opacity:1,mix:0}}const Rg=new zi(1,0,0,1),Lg=new zi(0,1,0,1),Bg=new zi(0,0,1,1),Fg=new zi(1,0,1,1),Og=new zi(0,1,1,1);function jg(t,e,i,r){Ng(t,0,e+i/2,t.transform.width,i,r)}function Vg(t,e,i,r){Ng(t,e-i/2,0,i,t.transform.height,r)}function Ng(t,e,i,r,n,s){const o=t.context,a=o.gl;a.enable(a.SCISSOR_TEST),a.scissor(e*t.pixelRatio,i*t.pixelRatio,r*t.pixelRatio,n*t.pixelRatio),o.clear({color:s}),a.disable(a.SCISSOR_TEST)}function Ug(t,e,i){const r=t.context,n=r.gl,s=t.useProgram("debug"),o=am.disabled,a=cm.disabled,l=t.colorModeForRenderPass(),c="$debug",h=t.style.map.terrain&&t.style.map.terrain.getTerrainData(i);r.activeTexture.set(n.TEXTURE0);const u=e.getTileByID(i.key).latestRawTileData,p=Math.floor((u&&u.byteLength||0)/1024),d=e.getTile(i).tileSize,f=512/Math.min(d,512)*(i.overscaledZ/t.transform.zoom)*.5;let m=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(m+=` => ${i.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,r=t.context.gl,n=t.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(e,5,5),n.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(t,`${m} ${p}kB`);const _=t.transform.getProjectionData({overscaledTileID:i,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,n.TRIANGLES,o,a,nm.alphaBlended,om.disabled,r_(zi.transparent,f),null,_,c,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),s.draw(r,n.LINE_STRIP,o,a,l,om.disabled,r_(zi.red),h,_,c,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments)}function Zg(t,e,i,r){const{isRenderingGlobe:n}=r,s=t.context,o=s.gl,a=t.transform,l=t.colorModeForRenderPass(),c=t.getDepthModeFor3D(),h=t.useProgram("terrain");s.bindFramebuffer.set(null),s.viewport.set([0,0,t.width,t.height]);for(const r of i){const i=e.getTerrainMesh(r.tileID),u=t.renderToTexture.getTexture(r),p=e.getTerrainData(r.tileID);s.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,u.texture);const d=e.getMeshFrameDelta(a.zoom),f=a.calculateFogMatrix(r.tileID.toUnwrapped()),m=Zm(d,f,t.style.sky,a.pitch,n),_=a.getProjectionData({overscaledTileID:r.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(s,o.TRIANGLES,c,cm.disabled,l,om.backCCW,m,p,_,"terrain",i.vertexBuffer,i.indexBuffer,i.segments)}}function Gg(t,e){if(!e.mesh){const i=new Da;i.emplaceBack(-1,-1),i.emplaceBack(1,-1),i.emplaceBack(1,1),i.emplaceBack(-1,1);const r=new Xa;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),e.mesh=new Nf(t.createVertexBuffer(i,Uf.members),t.createIndexBuffer(r),tl.simpleSegment(0,0,i.length,r.length))}return e.mesh}class $g{constructor(t,e){this.context=new pg(t),this.transform=e,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:y(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=Ed.maxUnderzooming+Ed.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Ff}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize()}setup(){const t=this.context,e=new Da;e.emplaceBack(0,0),e.emplaceBack(Q,0),e.emplaceBack(0,Q),e.emplaceBack(Q,Q),this.tileExtentBuffer=t.createVertexBuffer(e,Uf.members),this.tileExtentSegments=tl.simpleSegment(0,0,4,2);const i=new Da;i.emplaceBack(0,0),i.emplaceBack(Q,0),i.emplaceBack(0,Q),i.emplaceBack(Q,Q),this.debugBuffer=t.createVertexBuffer(i,Uf.members),this.debugSegments=tl.simpleSegment(0,0,4,5);const r=new La;r.emplaceBack(0,0,0,0),r.emplaceBack(Q,0,Q,0),r.emplaceBack(0,Q,0,Q),r.emplaceBack(Q,Q,Q,Q),this.rasterBoundsBuffer=t.createVertexBuffer(r,Nm.members),this.rasterBoundsSegments=tl.simpleSegment(0,0,4,2);const n=new Da;n.emplaceBack(0,0),n.emplaceBack(Q,0),n.emplaceBack(0,Q),n.emplaceBack(Q,Q),this.rasterBoundsBufferPosOnly=t.createVertexBuffer(n,Uf.members),this.rasterBoundsSegmentsPosOnly=tl.simpleSegment(0,0,4,5);const s=new Da;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(s,Uf.members),this.viewportSegments=tl.simpleSegment(0,0,4,2);const o=new Ka;o.emplaceBack(0),o.emplaceBack(1),o.emplaceBack(3),o.emplaceBack(2),o.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(o);const a=new Xa;a.emplaceBack(1,0,2),a.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(a);const l=this.context.gl;this.stencilClearMode=new cm({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.tileExtentMesh=new Nf(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments)}clearStencil(){const t=this.context,e=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const i=_();I(i,0,this.width,this.height,0,0,1),w(i,i,[e.drawingBufferWidth,e.drawingBufferHeight,0]);const r={mainMatrix:i,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:i};this.useProgram("clippingMask",null,!0).draw(t,e.TRIANGLES,am.disabled,this.stencilClearMode,nm.disabled,om.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}_renderTileClippingMasks(t,e,i){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source,this.nextStencilID+e.length>256&&this.clearStencil();const r=this.context;r.setColorMode(nm.disabled),r.setDepthMode(am.disabled);const n={};for(const t of e)n[t.key]=this.nextStencilID++;this._renderTileMasks(n,e,i,!0),this._renderTileMasks(n,e,i,!1),this._tileClippingMaskIDs=n}_renderTileMasks(t,e,i,r){const n=this.context,s=n.gl,o=this.style.projection,a=this.transform,l=this.useProgram("clippingMask");for(const c of e){const e=t[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=o.getMeshFromTileID(this.context,c.canonical,r,!0,"stencil"),p=a.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(n,s.TRIANGLES,am.disabled,new cm({func:s.ALWAYS,mask:0},e,255,s.KEEP,s.KEEP,s.REPLACE),nm.disabled,i?om.disabled:om.backCCW,null,h,p,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments)}}_renderTilesDepthBuffer(){const t=this.context,e=t.gl,i=this.style.projection,r=this.transform,n=this.useProgram("depth"),s=this.getDepthModeFor3D(),o=Id(r,{tileSize:r.tileSize});for(const a of o){const o=this.style.map.terrain&&this.style.map.terrain.getTerrainData(a),l=i.getMeshFromTileID(this.context,a.canonical,!0,!0,"raster"),c=r.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!0,applyTerrainMatrix:!0});n.draw(t,e.TRIANGLES,s,cm.disabled,nm.disabled,om.backCCW,null,o,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new cm({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new cm({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const t={};for(let i=0;i<n;i++)t[i+r]=new cm({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=n,[t,i]}return[{[r]:cm.disabled},i]}stencilConfigForOverlapTwoPass(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(this.clearStencil(),n>1){const t={},s={};for(let i=0;i<n;i++)t[i+r]=new cm({func:e.GREATER,mask:255},n+1+i,255,e.KEEP,e.KEEP,e.REPLACE),s[i+r]=new cm({func:e.GREATER,mask:255},1+i,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID=2*n+1,[t,s,i]}return this.nextStencilID=3,[{[r]:new cm({func:e.GREATER,mask:255},2,255,e.KEEP,e.KEEP,e.REPLACE)},{[r]:new cm({func:e.GREATER,mask:255},1,255,e.KEEP,e.KEEP,e.REPLACE)},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const e=1/8;return new nm([t.CONSTANT_COLOR,t.ONE],new zi(e,e,e,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?nm.unblended:nm.alphaBlended}getDepthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return am.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new am(i||this.context.gl.LEQUAL,e,[r,r])}getDepthModeFor3D(){return new am(this.context.gl.LEQUAL,am.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,e){var i,r;this.style=t,this.options=e,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(Qt.now()),this.imageManager.beginFrame();const n=this.style._order,s=this.style.sourceCaches,o={},a={},l={},c={isRenderingToTexture:!1,isRenderingGlobe:(null===(i=t.projection)||void 0===i?void 0:i.transitionState)>0};for(const t in s){const e=s[t];e.used&&e.prepare(this.context),o[t]=e.getVisibleCoordinates(!1),a[t]=o[t].slice().reverse(),l[t]=e.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let t=0;t<n.length;t++)if(this.style._layers[n[t]].is3D()){this.opaquePassCutoff=t;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of n){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=a[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,s[e.source],e,i,c)}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:t=>this.useProgram(t)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:e.showOverdrawInspector?zi.black:zi.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(t,e){const i=t.context,r=i.gl,n=((t,e,i)=>{const r=Math.cos(e.rollInRadians),n=Math.sin(e.rollInRadians),s=xd(e),o=e.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return{u_sky_color:t.properties.get("sky-color"),u_horizon_color:t.properties.get("horizon-color"),u_horizon:[(e.width/2-s*n)*i,(e.height/2+s*r)*i],u_horizon_normal:[-n,r],u_sky_horizon_blend:t.properties.get("sky-horizon-blend")*e.height/2*i,u_sky_blend:o}})(e,t.style.map.transform,t.pixelRatio),s=new am(r.LEQUAL,am.ReadWrite,[0,1]),o=cm.disabled,a=t.colorModeForRenderPass(),l=t.useProgram("sky"),c=Gg(i,e);l.draw(i,r.TRIANGLES,s,o,a,om.disabled,n,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments)}(this,this.style.sky),this._showOverdrawInspector=e.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=n.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[n[this.currentLayer]],e=s[t.source],i=o[t.source];this._renderTileClippingMasks(t,i,!1),this.renderLayer(this,e,t,i,c)}this.renderPass="translucent";let h=!1;for(this.currentLayer=0;this.currentLayer<n.length;this.currentLayer++){const t=this.style._layers[n[this.currentLayer]],e=s[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t,c))continue;this.opaquePassEnabledForLayer()||h||(h=!0,c.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===t.type?l:a)[t.source];this._renderTileClippingMasks(t,o[t.source],!!this.renderToTexture),this.renderLayer(this,e,t,i,c)}if(c.isRenderingGlobe&&function(t,e,i){const r=t.context,n=r.gl,s=t.useProgram("atmosphere"),o=new am(n.LEQUAL,am.ReadOnly,[0,1]),a=t.transform,l=function(t,e){const i=t.properties.get("position"),r=[-i.x,-i.y,-i.z],n=y(new Float64Array(16));var s,o,a,l,c,h,u;return"map"===t.properties.get("anchor")&&(S(n,n,e.rollInRadians),T(n,n,-e.pitchInRadians),S(n,n,e.bearingInRadians),T(n,n,e.center.lat*Math.PI/180),P(n,n,-e.center.lng*Math.PI/180)),(s=r)[0]=((a=n)[0]*(l=(o=r)[0])+a[4]*(c=o[1])+a[8]*(h=o[2])+a[12])/(u=(u=a[3]*l+a[7]*c+a[11]*h+a[15])||1),s[1]=(a[1]*l+a[5]*c+a[9]*h+a[13])/u,s[2]=(a[2]*l+a[6]*c+a[10]*h+a[14])/u,r}(i,t.transform),c=a.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),h=e.properties.get("atmosphere-blend")*c.projectionTransition;if(0===h)return;const u=bm(a.worldSize,a.center.lat),p=a.inverseProjectionMatrix,d=new Float64Array(4);d[3]=1,G(d,d,a.modelViewProjectionMatrix),d[0]/=d[3],d[1]/=d[3],d[2]/=d[3],d[3]=1,G(d,d,p),d[0]/=d[3],d[1]/=d[3],d[2]/=d[3],d[3]=1;const f=((t,e,i,r,n)=>({u_sun_pos:t,u_atmosphere_blend:e,u_globe_position:i,u_globe_radius:r,u_inv_proj_matrix:n}))(l,h,[d[0],d[1],d[2]],u,p),m=Gg(r,e);s.draw(r,n.TRIANGLES,o,cm.disabled,nm.alphaBlended,om.disabled,f,null,null,"atmosphere",m.vertexBuffer,m.indexBuffer,m.segments)}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const t=function(t,e){let i=null;const r=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.sourceCaches[i.source]]:[])),n=r.filter((t=>"vector"===t.getSource().type)),s=r.filter((t=>"vector"!==t.getSource().type)),o=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t)};return n.forEach((t=>o(t))),i||s.forEach((t=>o(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let r=0;r<i.length;r++)Ug(t,e,i[r])}(this,t,t.getVisibleCoordinates())}this.options.showPadding&&function(t){const e=t.transform.padding;jg(t,t.transform.height-(e.top||0),3,Rg),jg(t,e.bottom||0,3,Lg),Vg(t,e.left||0,3,Bg),Vg(t,t.transform.width-(e.right||0),3,Fg);const i=t.transform.centerPoint;!function(t,e,i,r){Ng(t,e-1,i-10,2,20,r),Ng(t,e-10,i-1,20,2,r)}(t,i.x,t.transform.height-i.y,Og)}(this),this.context.setDefault()}maybeDrawDepthAndCoords(t){if(!this.style||!this.style.map||!this.style.map.terrain)return;const e=this.terrainFacilitator.matrix,i=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;var n,s;r||(r=t?!((n=e)[0]===(s=i)[0]&&n[1]===s[1]&&n[2]===s[2]&&n[3]===s[3]&&n[4]===s[4]&&n[5]===s[5]&&n[6]===s[6]&&n[7]===s[7]&&n[8]===s[8]&&n[9]===s[9]&&n[10]===s[10]&&n[11]===s[11]&&n[12]===s[12]&&n[13]===s[13]&&n[14]===s[14]&&n[15]===s[15]):!function(t,e){var i=t[0],r=t[1],n=t[2],s=t[3],o=t[4],a=t[5],l=t[6],c=t[7],h=t[8],u=t[9],d=t[10],f=t[11],m=t[12],_=t[13],g=t[14],y=t[15],x=e[0],v=e[1],b=e[2],w=e[3],T=e[4],P=e[5],S=e[6],M=e[7],I=e[8],C=e[9],E=e[10],A=e[11],z=e[12],k=e[13],D=e[14],R=e[15];return Math.abs(i-x)<=p*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(r-v)<=p*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=p*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(s-w)<=p*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(o-T)<=p*Math.max(1,Math.abs(o),Math.abs(T))&&Math.abs(a-P)<=p*Math.max(1,Math.abs(a),Math.abs(P))&&Math.abs(l-S)<=p*Math.max(1,Math.abs(l),Math.abs(S))&&Math.abs(c-M)<=p*Math.max(1,Math.abs(c),Math.abs(M))&&Math.abs(h-I)<=p*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(u-C)<=p*Math.max(1,Math.abs(u),Math.abs(C))&&Math.abs(d-E)<=p*Math.max(1,Math.abs(d),Math.abs(E))&&Math.abs(f-A)<=p*Math.max(1,Math.abs(f),Math.abs(A))&&Math.abs(m-z)<=p*Math.max(1,Math.abs(m),Math.abs(z))&&Math.abs(_-k)<=p*Math.max(1,Math.abs(_),Math.abs(k))&&Math.abs(g-D)<=p*Math.max(1,Math.abs(g),Math.abs(D))&&Math.abs(y-R)<=p*Math.max(1,Math.abs(y),Math.abs(R))}(e,i)),r||(r=this.style.map.terrain.sourceCache.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]}(e,i),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,e){const i=t.context,r=i.gl,n=t.transform,s=nm.unblended,o=new am(r.LEQUAL,am.ReadWrite,[0,1]),a=e.sourceCache.getRenderableTiles(),l=t.useProgram("terrainDepth");i.bindFramebuffer.set(e.getFramebuffer("depth").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:zi.transparent,depth:1});for(const t of a){const a=e.getTerrainMesh(t.tileID),c=e.getTerrainData(t.tileID),h=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:e.getMeshFrameDelta(n.zoom)};l.draw(i,r.TRIANGLES,o,cm.disabled,s,om.backCCW,u,c,h,"terrain",a.vertexBuffer,a.indexBuffer,a.segments)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain),function(t,e){const i=t.context,r=i.gl,n=t.transform,s=nm.unblended,o=new am(r.LEQUAL,am.ReadWrite,[0,1]),a=e.getCoordsTexture(),l=e.sourceCache.getRenderableTiles(),c=t.useProgram("terrainCoords");i.bindFramebuffer.set(e.getFramebuffer("coords").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:zi.transparent,depth:1}),e.coordsIndex=[];for(const t of l){const l=e.getTerrainMesh(t.tileID),h=e.getTerrainData(t.tileID);i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,a.texture);const u={u_terrain_coords_id:(255-e.coordsIndex.length)/255,u_texture:0,u_ele_delta:e.getMeshFrameDelta(n.zoom)},p=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});c.draw(i,r.TRIANGLES,o,cm.disabled,s,om.backCCW,u,h,p,"terrain",l.vertexBuffer,l.indexBuffer,l.segments),e.coordsIndex.push(t.tileID.key)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain))}renderLayer(t,e,i,r,n){i.isHidden(this.transform.zoom)||("background"===i.type||"custom"===i.type||(r||[]).length)&&(this.id=i.id,(t=>"symbol"===t.type)(i)?function(t,e,i,r,n,s){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:o}=s,a=cm.disabled,l=t.colorModeForRenderPass();(i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,e,i,r,n,s,o,a,l){const c=e.transform,h=e.style.map.terrain,u="map"===n,p="map"===s;for(const n of t){const t=r.getTile(n),s=t.getBucket(i);if(!s||!s.text||!s.text.segments.get().length)continue;const d=Ru(s.textSizeData,c.zoom),f=tt(t,1,e.transform.zoom),m=Ld(u,e.transform,f),_="none"!==i.layout.get("icon-text-fit")&&s.hasIconData();if(d){const e=Math.pow(2,c.zoom-t.tileID.overscaledZ),i=h?(t,e)=>h.getElevation(n,t,e):null;yg(s,u,p,l,c,m,e,d,_,ot(c,t,o,a),n.toUnwrapped(),i)}}}(r,t,i,e,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&vg(t,e,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),a,l,o),0!==i.paint.get("text-opacity").constantOr(1)&&vg(t,e,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),a,l,o),e.map.showCollisionBoxes&&(fg(t,e,i,r,!0),fg(t,e,i,r,!1))}(t,e,i,r,this.style.placement.variableOffsets,n):(t=>"circle"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=i.paint.get("circle-opacity"),a=i.paint.get("circle-stroke-width"),l=i.paint.get("circle-stroke-opacity"),c=!i.layout.get("circle-sort-key").isConstant();if(0===o.constantOr(1)&&(0===a.constantOr(1)||0===l.constantOr(1)))return;const h=t.context,u=h.gl,p=t.transform,d=t.getDepthModeForSublayer(0,am.ReadOnly),f=cm.disabled,m=t.colorModeForRenderPass(),_=[],g=p.getCircleRadiusCorrection();for(let n=0;n<r.length;n++){const o=r[n],a=e.getTile(o),l=a.getBucket(i);if(!l)continue;const h=ot(p,a,i.paint.get("circle-translate"),i.paint.get("circle-translate-anchor")),u=l.programConfigurations.get(i.id),d=t.useProgram("circle",u),f=l.layoutVertexBuffer,m=l.indexBuffer,y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o),x={programConfiguration:u,program:d,layoutVertexBuffer:f,indexBuffer:m,uniformValues:t_(t,a,i,h,g),terrainData:y,projectionData:p.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(c){const t=l.segments.get();for(const e of t)_.push({segments:new tl([e]),sortKey:e.sortKey,state:x})}else _.push({segments:l.segments,sortKey:0,state:x})}c&&_.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of _){const{programConfiguration:r,program:n,layoutVertexBuffer:s,indexBuffer:o,uniformValues:a,terrainData:l,projectionData:c}=e.state;n.draw(h,u.TRIANGLES,d,f,m,om.backCCW,a,l,c,i.id,s,o,e.segments,i.paint,t.transform.zoom,r)}}(t,e,i,r,n):(t=>"heatmap"===t.type)(i)?function(t,e,i,r,n){if(0===i.paint.get("heatmap-opacity"))return;const s=t.context,{isRenderingToTexture:o,isRenderingGlobe:a}=n;if(t.style.map.terrain){for(const n of r){const r=e.getTile(n);e.hasRenderableParent(n)||("offscreen"===t.renderPass?wg(t,r,i,n,a):"translucent"===t.renderPass&&Tg(t,i,n,o,a))}s.viewport.set([0,0,t.width,t.height])}else"offscreen"===t.renderPass?function(t,e,i,r){const n=t.context,s=n.gl,o=t.transform,a=cm.disabled,l=new nm([s.ONE,s.ONE],zi.transparent,[!0,!0,!0,!0]);(function(t,e,i){const r=t.gl;t.activeTexture.set(r.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let n=i.heatmapFbos.get(wc);n?(r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),t.bindFramebuffer.set(n.framebuffer)):(n=Pg(t,e.width/4,e.height/4),i.heatmapFbos.set(wc,n))})(n,t,i),n.clear({color:zi.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(e.hasRenderableParent(h))continue;const u=e.getTile(h),p=u.getBucket(i);if(!p)continue;const d=p.programConfigurations.get(i.id),f=t.useProgram("heatmap",d),m=o.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),_=o.getCircleRadiusCorrection();f.draw(n,s.TRIANGLES,am.disabled,a,l,om.backCCW,n_(u,o.zoom,i.paint.get("heatmap-intensity"),_),null,m,i.id,p.layoutVertexBuffer,p.indexBuffer,p.segments,i.paint,o.zoom,d)}n.viewport.set([0,0,t.width,t.height])}(t,e,i,r):"translucent"===t.renderPass&&function(t,e){const i=t.context,r=i.gl;i.setColorMode(t.colorModeForRenderPass());const n=e.heatmapFbos.get(wc);n&&(i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1),Sg(i,e).bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(i,r.TRIANGLES,am.disabled,cm.disabled,t.colorModeForRenderPass(),om.disabled,s_(t,e,0,1),null,null,e.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,e.paint,t.transform.zoom))}(t,i)}(t,e,i,r,n):(t=>"line"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=i.paint.get("line-opacity"),a=i.paint.get("line-width");if(0===o.constantOr(1)||0===a.constantOr(1))return;const l=t.getDepthModeForSublayer(0,am.ReadOnly),c=t.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=i.paint.get("line-pattern"),p=u.constantOr(1),d=i.paint.get("line-gradient"),f=i.getCrossfadeParameters(),m=p?"linePattern":h?"lineSDF":d?"lineGradient":"line",_=t.context,g=_.gl,y=t.transform;let x=!0;for(const n of r){const r=e.getTile(n);if(p&&!r.patternsLoaded())continue;const o=r.getBucket(i);if(!o)continue;const a=o.programConfigurations.get(i.id),b=t.context.program.get(),w=t.useProgram(m,a),T=x||w.program!==b,P=t.style.map.terrain&&t.style.map.terrain.getTerrainData(n),S=u.constantOr(null);if(S&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[S.to.toString()],i=t.patternPositions[S.from.toString()];e&&i&&a.setConstantPatternPositions(e,i)}const M=y.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0}),I=y.getPixelScale(),C=p?p_(t,r,i,I,f):h?d_(t,r,i,I,h,f):d?u_(t,r,i,I,o.lineClipsArray.length):h_(t,r,i,I);if(p)_.activeTexture.set(g.TEXTURE0),r.imageAtlasTexture.bind(g.LINEAR,g.CLAMP_TO_EDGE),a.updatePaintBuffers(f);else if(h&&(T||t.lineAtlas.dirty))_.activeTexture.set(g.TEXTURE0),t.lineAtlas.bind(_);else if(d){const r=o.gradients[i.id];let s=r.texture;if(i.gradientVersion!==r.version){let a=256;if(i.stepInterpolant){const i=e.getSource().maxzoom,r=n.canonical.z===i?Math.ceil(1<<t.transform.maxZoom-n.canonical.z):1;a=vt((v=o.maxLineLength/Q*1024*r)<=1?1:Math.pow(2,Math.ceil(Math.log(v)/Math.LN2)),256,_.maxTextureSize)}r.gradient=bc({expression:i.gradientExpression(),evaluationKey:"lineProgress",resolution:a,image:r.gradient||void 0,clips:o.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new Ec(_,r.gradient,g.RGBA),r.version=i.gradientVersion,s=r.texture}_.activeTexture.set(g.TEXTURE0),s.bind(i.stepInterpolant?g.NEAREST:g.LINEAR,g.CLAMP_TO_EDGE)}const E=t.stencilModeForClipping(n);w.draw(_,g.TRIANGLES,l,E,c,om.disabled,C,P,M,i.id,o.layoutVertexBuffer,o.indexBuffer,o.segments,i.paint,t.transform.zoom,a,o.layoutVertexBuffer2),x=!1}var v}(t,e,i,r,n):(t=>"fill"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("fill-color"),o=i.paint.get("fill-opacity");if(0===o.constantOr(1))return;const{isRenderingToTexture:a}=n,l=t.colorModeForRenderPass(),c=i.paint.get("fill-pattern"),h=t.opaquePassEnabledForLayer()&&!c.constantOr(1)&&1===s.constantOr(zi.transparent).a&&1===o.constantOr(0)?"opaque":"translucent";if(t.renderPass===h){const n=t.getDepthModeForSublayer(1,"opaque"===t.renderPass?am.ReadWrite:am.ReadOnly);Ig(t,e,i,r,n,l,!1,a)}if("translucent"===t.renderPass&&i.paint.get("fill-antialias")){const n=t.getDepthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,am.ReadOnly);Ig(t,e,i,r,n,l,!0,a)}}(t,e,i,r,n):(t=>"fill-extrusion"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("fill-extrusion-opacity");if(0===s)return;const{isRenderingToTexture:o}=n;if("translucent"===t.renderPass){const n=new am(t.context.gl.LEQUAL,am.ReadWrite,t.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))Cg(t,e,i,r,n,cm.disabled,nm.disabled,o),Cg(t,e,i,r,n,t.stencilModeFor3D(),t.colorModeForRenderPass(),o);else{const s=t.colorModeForRenderPass();Cg(t,e,i,r,n,cm.disabled,s,o)}}}(t,e,i,r,n):(t=>"hillshade"===t.type)(i)?function(t,e,i,r,n){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=t.context,a=t.style.projection.useSubdivision,l=t.getDepthModeForSublayer(0,am.ReadOnly),c=t.colorModeForRenderPass();if("offscreen"===t.renderPass)!function(t,e,i,r,n,s,o){const a=t.context,l=a.gl;for(const c of i){const i=e.getTile(c),h=i.dem;if(!h||!h.data)continue;if(!i.needsHillshadePrepare)continue;const u=h.dim,p=h.stride,d=h.getPixels();if(a.activeTexture.set(l.TEXTURE1),a.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(p),i.demTexture){const t=i.demTexture;t.update(d,{premultiply:!1}),t.bind(l.NEAREST,l.CLAMP_TO_EDGE)}else i.demTexture=new Ec(a,d,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);a.activeTexture.set(l.TEXTURE0);let f=i.fbo;if(!f){const t=new Ec(a,{width:u,height:u,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),f=i.fbo=a.createFramebuffer(u,u,!0,!1),f.colorAttachment.set(t.texture)}a.bindFramebuffer.set(f.framebuffer),a.viewport.set([0,0,u,u]),t.useProgram("hillshadePrepare").draw(a,l.TRIANGLES,n,s,o,om.disabled,a_(i.tileID,h),null,null,r.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1}}(t,e,r,i,l,cm.disabled,c),o.viewport.set([0,0,t.width,t.height]);else if("translucent"===t.renderPass)if(a){const[n,o,a]=t.stencilConfigForOverlapTwoPass(r);Eg(t,e,i,a,n,l,c,!1,s),Eg(t,e,i,a,o,l,c,!0,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Eg(t,e,i,o,n,l,c,!1,s)}}(t,e,i,r,n):(t=>"color-relief"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(!r.length)return;const{isRenderingToTexture:s}=n,o=t.style.projection.useSubdivision,a=t.getDepthModeForSublayer(0,am.ReadOnly),l=t.colorModeForRenderPass();if(o){const[n,o,c]=t.stencilConfigForOverlapTwoPass(r);Ag(t,e,i,c,n,a,l,!1,s),Ag(t,e,i,c,o,a,l,!0,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Ag(t,e,i,o,n,a,l,!1,s)}}(t,e,i,r,n):(t=>"raster"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const{isRenderingToTexture:s}=n,o=e.getSource(),a=t.style.projection.useSubdivision;if(o instanceof td)kg(t,e,i,r,null,!1,!1,o.tileCoords,o.flippedWindingOrder,s);else if(a){const[n,o,a]=t.stencilConfigForOverlapTwoPass(r);kg(t,e,i,a,n,!1,!0,zg,!1,s),kg(t,e,i,a,o,!0,!0,zg,!1,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);kg(t,e,i,o,n,!1,!0,zg,!1,s)}}(t,e,i,r,n):(t=>"background"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("background-color"),o=i.paint.get("background-opacity");if(0===o)return;const{isRenderingToTexture:a}=n,l=t.context,c=l.gl,h=t.style.projection,u=t.transform,p=u.tileSize,d=i.paint.get("background-pattern");if(t.isPatternMissing(d))return;const f=!d&&1===s.a&&1===o&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==f)return;const m=cm.disabled,_=t.getDepthModeForSublayer(0,"opaque"===f?am.ReadWrite:am.ReadOnly),g=t.colorModeForRenderPass(),y=t.useProgram(d?"backgroundPattern":"background"),x=r||Id(u,{tileSize:p,terrain:t.style.map.terrain});d&&(l.activeTexture.set(c.TEXTURE0),t.imageManager.bind(t.context));const v=i.getCrossfadeParameters();for(const e of x){const r=u.getProjectionData({overscaledTileID:e,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),n=d?w_(o,t,d,{tileID:e,tileSize:p},v):b_(o,s),f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e),x=h.getMeshFromTileID(l,e.canonical,!1,!0,"raster");y.draw(l,c.TRIANGLES,_,m,g,om.backCCW,n,f,r,i.id,x.vertexBuffer,x.indexBuffer,x.segments)}}(t,0,i,r,n):(t=>"custom"===t.type)(i)&&function(t,e,i,r){const{isRenderingGlobe:n}=r,s=t.context,o=i.implementation,a=t.style.projection,l=t.transform,c=l.getProjectionDataForCustomLayer(n),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:a.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${a.shaderPreludeCode.vertexSource}`,define:a.shaderDefine},defaultProjectionData:c},u=o.renderingMode?o.renderingMode:"2d";if("offscreen"===t.renderPass){const e=o.prerender;e&&(t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),e.call(o,s.gl,h),s.setDirty(),t.setBaseState())}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),s.setStencilMode(cm.disabled);const e="3d"===u?t.getDepthModeFor3D():t.getDepthModeForSublayer(0,am.ReadOnly);s.setDepthMode(e),o.render(s.gl,h),s.setDirty(),t.setBaseState(),s.bindFramebuffer.set(null)}}(t,0,i,n))}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t]}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return!1;if(!t.from||!t.to)return!0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return!e||!i}useProgram(t,e,i=!1,r=[]){this.cache=this.cache||{};const n=!!this.style.map.terrain,s=this.style.projection,o=i?jf.projectionMercator:s.shaderPreludeCode,a=i?Zf:s.shaderDefine,l=t+(e?e.cacheKey:"")+`/${i?Gf:s.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(n?"/terrain":"")+(r?`/${r.join("/")}`:"");return this.cache[l]||(this.cache[l]=new qm(this.context,jf[t],e,P_[t],this._showOverdrawInspector,n,o,a,r)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Ec(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy()}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}function qg(t,e){let i,r=!1,n=null,s=null;const o=()=>{n=null,r&&(t.apply(s,i),n=setTimeout(o,e),r=!1)};return(...t)=>(r=!0,s=this,i=t,n||o(),n)}class Wg{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t)})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(!this._isValidHash(t))return!1;const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,t)},this._removeHash=()=>{const t=this._getCurrentHash();if(0===t.length)return;const e=t.join("/");let i=e;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${e}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let n=window.location.href.replace(/(#.+)?$/,r);n=n.replace("&&","&"),window.history.replaceState(window.history.state,null,n)},this._updateHash=qg(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t)}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),s=Math.round(e.lng*n)/n,o=Math.round(e.lat*n)/n,a=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=t?`/${s}/${o}/${i}`:`${i}/${o}/${s}`,(a||l)&&(c+="/"+Math.round(10*a)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===t?(e=!0,`${r}=${c}`):i})).filter((t=>t));return e||i.push(`${t}=${c}`),`#${i.join("&")}`}return`#${c}`}_isValidHash(t){if(t.length<3||t.some(isNaN))return!1;try{new Dp(+t[2],+t[1])}catch(t){return!1}const e=+t[0],i=+(t[3]||0),r=+(t[4]||0);return e>=this._map.getMinZoom()&&e<=this._map.getMaxZoom()&&i>=-180&&i<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const Hg={linearity:.3,easing:yt(0,0,.3,1)},Xg=wt({deceleration:2500,maxSpeed:1400},Hg),Yg=wt({deceleration:20,maxSpeed:1400},Hg),Kg=wt({deceleration:1e3,maxSpeed:360},Hg),Jg=wt({deceleration:1e3,maxSpeed:90},Hg),Qg=wt({deceleration:1e3,maxSpeed:360},Hg);class ty{constructor(t){this._map=t,this.clear()}clear(){this._inertiaBuffer=[]}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:Qt.now(),settings:t})}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=Qt.now();for(;t.length>0&&e-t[0].time>160;)t.shift()}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const e={zoom:0,bearing:0,pitch:0,roll:0,pan:new s(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)e.zoom+=t.zoomDelta||0,e.bearing+=t.bearingDelta||0,e.pitch+=t.pitchDelta||0,e.roll+=t.rollDelta||0,t.panDelta&&e.pan._add(t.panDelta),t.around&&(e.around=t.around),t.pinchAround&&(e.pinchAround=t.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(e.pan.mag()){const n=iy(e.pan.mag(),i,wt({},Xg,t||{})),s=e.pan.mult(n.amount/e.pan.mag()),o=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=o.easingCenter,r.offset=o.easingOffset,ey(r,n)}if(e.zoom){const t=iy(e.zoom,i,Yg);r.zoom=this._map.transform.zoom+t.amount,ey(r,t)}if(e.bearing){const t=iy(e.bearing,i,Kg);r.bearing=this._map.transform.bearing+vt(t.amount,-179,179),ey(r,t)}if(e.pitch){const t=iy(e.pitch,i,Jg);r.pitch=this._map.transform.pitch+t.amount,ey(r,t)}if(e.roll){const t=iy(e.roll,i,Qg);r.roll=this._map.transform.roll+vt(t.amount,-179,179),ey(r,t)}if(r.zoom||r.bearing){const t=void 0===e.pinchAround?e.around:e.pinchAround;r.around=t?this._map.unproject(t):this._map.getCenter()}return this.clear(),wt(r,{noMoveStart:!0})}}function ey(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing)}function iy(t,e,i){const{maxSpeed:r,linearity:n,deceleration:s}=i,o=vt(t*n/(e/1e3),-r,r),a=Math.abs(o)/(s*n);return{easing:i.easing,duration:1e3*a,amount:o*(a/2)}}class ry extends xe{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i,r={}){i=i instanceof MouseEvent?i:new MouseEvent(t,i);const n=te.mousePos(e.getCanvas(),i);super(t,wt({point:n,lngLat:e.unproject(n),originalEvent:i},r)),this._defaultPrevented=!1,this.target=e}}class ny extends xe{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){const r="touchend"===t?i.changedTouches:i.touches,n=te.touchPos(e.getCanvasContainer(),r),o=n.map((t=>e.unproject(t))),a=n.reduce(((t,e,i,r)=>t.add(e.div(r.length))),new s(0,0));super(t,{points:n,point:a,lngLats:o,lngLat:e.unproject(a),originalEvent:i}),this._defaultPrevented=!1}}class sy extends xe{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1}}class oy{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance}reset(){delete this._mousedownPos}wheel(t){return this._firePreventable(new sy(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new ry(t.type,this._map,t))}mouseup(t){this._map.fire(new ry(t.type,this._map,t))}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new ry(t.type,this._map,t))}dblclick(t){return this._firePreventable(new ry(t.type,this._map,t))}mouseover(t){this._map.fire(new ry(t.type,this._map,t))}mouseout(t){this._map.fire(new ry(t.type,this._map,t))}touchstart(t){return this._firePreventable(new ny(t.type,this._map,t))}touchmove(t){this._map.fire(new ny(t.type,this._map,t))}touchend(t){this._map.fire(new ny(t.type,this._map,t))}touchcancel(t){this._map.fire(new ny(t.type,this._map,t))}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class ay{constructor(t){this._map=t}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent}mousemove(t){this._map.fire(new ry(t.type,this._map,t))}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new ry("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new ry(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class ly{constructor(t){this._map=t}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return{lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.screenPointToLocation(s.convert(t),this._map.terrain)}}class cy{constructor(t,e){this._map=t,this._tr=new ly(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(te.disableDrag(),this._startPos=this._lastPos=e,this._active=!0)}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=te.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const n=Math.min(r.x,i.x),s=Math.max(r.x,i.x),o=Math.min(r.y,i.y),a=Math.max(r.y,i.y);te.setTransform(this._box,`translate(${n}px,${o}px)`),this._box.style.width=s-n+"px",this._box.style.height=a-o+"px"}mouseupWindow(t,e){if(!this._active)return;if(0!==t.button)return;const i=this._startPos,r=e;if(this.reset(),te.suppressClick(),i.x!==r.x||i.y!==r.y)return this._map.fire(new xe("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(i,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t)}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t))}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(te.remove(this._box),this._box=null),te.enableDrag(),delete this._startPos,delete this._lastPos}_fireEvent(t,e){return this._map.fire(new xe(t,{originalEvent:e}))}}function hy(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let r=0;r<t.length;r++)i[t[r].identifier]=e[r];return i}class uy{constructor(t){this.reset(),this.numTouches=t.numTouches}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1}touchstart(t,e,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),i.length===this.numTouches&&(this.centroid=function(t){const e=new s(0,0);for(const i of t)e._add(i);return e.div(t.length)}(e),this.touches=hy(i,e)))}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const r=hy(i,e);for(const t in this.touches){const e=r[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0)}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class py{constructor(t){this.singleTap=new uy(t),this.numTaps=t.numTaps,this.reset()}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset()}touchstart(t,e,i){this.singleTap.touchstart(t,e,i)}touchmove(t,e,i){this.singleTap.touchmove(t,e,i)}touchend(t,e,i){const r=this.singleTap.touchend(t,e,i);if(r){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class dy{constructor(t){this._tr=new ly(t),this._zoomIn=new py({numTouches:1,numTaps:2}),this._zoomOut=new py({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i)}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i)}touchend(t,e,i){const r=this._zoomIn.touchend(t,e,i),n=this._zoomOut.touchend(t,e,i),s=this._tr;return r?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:s.zoom+1,around:s.unproject(r)},{originalEvent:t})}):n?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:s.zoom-1,around:s.unproject(n)},{originalEvent:t})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class fy{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset()}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t)}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.rollDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=Array.isArray(e)?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0))}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const r=Array.isArray(e)?e[0]:e;return!this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&te.suppressClick(),this.reset(t))}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const my=0,_y=2,gy={[my]:1,[_y]:2};class yy{constructor(t){this._correctEvent=t.checkCorrectEvent}startMove(t){const e=te.mouseButton(t);this._eventButton=e}endMove(t){delete this._eventButton}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return!function(t,e){const i=gy[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return te.mouseButton(t)===this._eventButton}}class xy{constructor(){this._firstTouch=void 0}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier}endMove(t){delete this._firstTouch}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}class vy{constructor(t=new yy({checkCorrectEvent:()=>!0}),e=new xy){this.mouseMoveStateManager=t,this.oneFingerTouchMoveStateManager=e}_executeRelevantHandler(t,e,i){return t instanceof MouseEvent?e(t):"undefined"!=typeof TouchEvent&&t instanceof TouchEvent?i(t):void 0}startMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.startMove(t)),(t=>this.oneFingerTouchMoveStateManager.startMove(t)))}endMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.endMove(t)),(t=>this.oneFingerTouchMoveStateManager.endMove(t)))}isValidStartEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidStartEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidStartEvent(t)))}isValidMoveEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidMoveEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(t)))}isValidEndEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidEndEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidEndEvent(t)))}}const by=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=t=>{t.preventDefault()}};class wy{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset()}reset(){this._active=!1,this._touches={},this._sum=new s(0,0)}_shouldBePrevented(t){return t<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active){if(!this._shouldBePrevented(i.length))return t.preventDefault(),this._calculateTransform(t,e,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",t)}}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&this._shouldBePrevented(i.length)&&this.reset()}touchcancel(){this.reset()}_calculateTransform(t,e,i){i.length>0&&(this._active=!0);const r=hy(i,e),n=new s(0,0),o=new s(0,0);let a=0;for(const t in r){const e=r[t],i=this._touches[t];i&&(n._add(e),o._add(e.sub(i)),a++,r[t]=e)}if(this._touches=r,this._shouldBePrevented(a)||!o.mag())return;const l=o.div(a);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(a),panDelta:l}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Ty{constructor(){this.reset()}reset(){this._active=!1,delete this._firstTwoTouches}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]))}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[r,n]=this._firstTwoTouches,s=Py(i,e,r),o=Py(i,e,n);if(!s||!o)return;const a=this._aroundCenter?null:s.add(o).div(2);return this._move([s,o],a,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[r,n]=this._firstTwoTouches,s=Py(i,e,r),o=Py(i,e,n);s&&o||(this._active&&te.suppressClick(),this.reset())}touchcancel(){this.reset()}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}}function Py(t,e,i){for(let r=0;r<t.length;r++)if(t[r].identifier===i)return e[r]}function Sy(t,e){return Math.log(t/e)/Math.LN2}class My extends Ty{reset(){super.reset(),delete this._distance,delete this._startDistance}_start(t){this._startDistance=this._distance=t[0].dist(t[1])}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Sy(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Sy(this._distance,i),pinchAround:e}}}function Iy(t,e){return 180*t.angleWith(e)/Math.PI}class Cy extends Ty{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1])}_move(t,e,i){const r=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Iy(this._vector,r),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Iy(t,this._startVector);return Math.abs(i)<e}}function Ey(t){return Math.abs(t.y)>Math.abs(t.x)}class Ay extends Ty{constructor(t){super(),this._currentTouchCount=0,this._map=t}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length}_start(t){this._lastPoints=t,Ey(t[0].sub(t[1]))&&(this._valid=!1)}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=t[0].sub(this._lastPoints[0]),n=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,n,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(r.y+n.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const r=t.mag()>=2,n=e.mag()>=2;if(!r&&!n)return;if(!r||!n)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const s=t.y>0==e.y>0;return Ey(t)&&Ey(e)&&s}}const zy={panStep:100,bearingStep:15,pitchStep:10};class ky{constructor(t){this._tr=new ly(t);const e=zy;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1}reset(){this._active=!1}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,r=0,n=0,s=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),n=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),n=1);break;case 38:t.shiftKey?r=1:(t.preventDefault(),s=-1);break;case 40:t.shiftKey?r=-1:(t.preventDefault(),s=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:o=>{const a=this._tr;o.easeTo({duration:300,easeId:"keyboardHandler",easing:Dy,zoom:e?Math.round(a.zoom)+e*(t.shiftKey?2:1):a.zoom,bearing:a.bearing+i*this._bearingStep,pitch:a.pitch+r*this._pitchStep,offset:[-n*this._panStep,-s*this._panStep],center:a.center},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function Dy(t){return t*(2-t)}const Ry=4.000244140625,Ly=1/450;class By{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t)},this._map=t,this._tr=new ly(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=Ly}setZoomRate(t){this._defaultZoomRate=t}setWheelZoomRate(t){this._wheelZoomRate=t}isEnabled(){return!!this._enabled}isActive(){return!!this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around)}disable(){this.isEnabled()&&(this._enabled=!1)}_shouldBePrevented(t){return!!this._map.cooperativeGestures.isEnabled()&&!(t.ctrlKey||this._map.cooperativeGestures.isBypassed(t))}wheel(t){if(!this.isEnabled())return;if(this._shouldBePrevented(t))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",t);let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=Qt.now(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%Ry==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault()}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=te.mousePos(this._map.getCanvas(),t),i=this._tr;this._aroundPoint=this._aroundCenter?i.transform.locationToScreenPoint(Dp.convert(i.center)):e,this._frameId||(this._frameId=!0,this._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const e=t.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=e),"number"==typeof this._targetZoom&&(this._targetZoom+=e)}if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>Ry?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const r="number"!=typeof this._targetZoom?t.scale:Mt(this._targetZoom);this._targetZoom=t.getConstrained(t.getCameraLngLat(),It(r*i)).zoom,"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0}const e="number"!=typeof this._targetZoom?t.zoom:this._targetZoom,i=this._startZoom,r=this._easing;let n,s=!1;if("wheel"===this._type&&i&&r){const t=Qt.now()-this._lastWheelEventTime,o=Math.min((t+5)/200,1),a=r(o);n=xr.number(i,e,a),o<1?this._frameId||(this._frameId=!0):s=!0}else n=e,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout}),200)),this._lastExpectedZoom=n,{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let e=xt;if(this._prevEase){const t=this._prevEase,i=(Qt.now()-t.start)/t.duration,r=t.easing(i+.01)-t.easing(i),n=.27/Math.sqrt(r*r+1e-4)*.01;e=yt(n,Math.sqrt(.0729-n*n),.25,1)}return this._prevEase={start:Qt.now(),duration:t,easing:e},e}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout)}}class Fy{constructor(t,e){this._clickZoom=t,this._tapZoom=e}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class Oy{constructor(t){this._tr=new ly(t),this.reset()}reset(){this._active=!1}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class jy{constructor(){this._tap=new py({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset()}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const r=e[0],n=t.timeStamp-this._tapTime<500,s=this._tapPoint.dist(r)<30;n&&s?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset()}else this._tap.touchstart(t,e,i)}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=e[0],n=r.y-this._swipePoint.y;return this._swipePoint=r,t.preventDefault(),this._active=!0,{zoomDelta:n/128}}}else this._tap.touchmove(t,e,i)}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else{const r=this._tap.touchend(t,e,i);r&&(this._tapTime=t.timeStamp,this._tapPoint=r)}}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Vy{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class Ny{constructor(t,e,i,r){this._pitchWithRotate=t.pitchWithRotate,this._rollEnabled=t.rollEnabled,this._mouseRotate=e,this._mousePitch=i,this._mouseRoll=r}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class Uy{constructor(t,e,i,r){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}class Zy{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1}isActive(){return!1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=te.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=e,this._container.appendChild(r);const n=document.createElement("div");n.className="maplibregl-mobile-message",n.textContent=i,this._container.appendChild(n),this._container.setAttribute("aria-hidden","true")}_destroyUI(){this._container&&(te.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container}enable(){this._setupUI(),this._enabled=!0}disable(){this._enabled=!1,this._destroyUI()}isEnabled(){return this._enabled}isBypassed(t){return t[this._bypassKey]}notifyGestureBlocked(t,e){this._enabled&&(this._map.fire(new xe("cooperativegestureprevented",{gestureType:t,originalEvent:e})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show")}),100))}}const Gy=t=>t.zoom||t.drag||t.roll||t.pitch||t.rotate;class $y extends xe{}function qy(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta||t.rollDelta}class Wy{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`)},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,r={needsRenderFrame:!1},n={},s={};for(const{handlerName:l,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;if(this._blockedByActive(s,h,l))c.reset();else if(c[e||t.type]){if(a=t,Wt[e||t.type]&&(a instanceof MouseEvent||a instanceof WheelEvent)){const i=te.mousePos(this._map.getCanvas(),t);u=c[e||t.type](t,i)}else if(Ht(t,e||t.type)){const i=this._getMapTouches(t.touches),r=te.touchPos(this._map.getCanvas(),i);u=c[e||t.type](t,r,i)}else qt[o=e||t.type]||Wt[o]||(u=c[e||t.type](t));this.mergeHandlerResult(r,n,u,l,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()}(u||c.isActive())&&(s[l]=c)}var o,a;const l={};for(const t in this._previousActiveHandlers)s[t]||(l[t]=i);this._previousActiveHandlers=s,(Object.keys(l).length||qy(r))&&(this._changes.push([r,n,l]),this._triggerRenderFrame()),(Object.keys(s).length||qy(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:c}=r;c&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],c(this._map))},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new ty(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)te.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}destroy(){for(const[t,e,i]of this._listeners)te.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new oy(e,t));const r=e.boxZoom=new cy(e,t);this._add("boxZoom",r),t.interactive&&t.boxZoom&&r.enable();const n=e.cooperativeGestures=new Zy(e,t.cooperativeGestures);this._add("cooperativeGestures",n),t.cooperativeGestures&&n.enable();const o=new dy(e),a=new Oy(e);e.doubleClickZoom=new Fy(a,o),this._add("tapZoom",o),this._add("clickZoom",a),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const l=new jy;this._add("tapDragZoom",l);const c=e.touchPitch=new Ay(e);this._add("touchPitch",c),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const h=()=>e.project(e.getCenter()),u=function({enable:t,clickTolerance:e,aroundCenter:i=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:n=.8},o){const a=new yy({checkCorrectEvent:t=>0===te.mouseButton(t)&&t.ctrlKey||2===te.mouseButton(t)&&!t.ctrlKey});return new fy({clickTolerance:e,move:(t,e)=>{const a=o();if(i&&Math.abs(a.y-t.y)>r)return{bearingDelta:Zt(new s(t.x,e.y),e,a)};let l=(e.x-t.x)*n;return i&&e.y<a.y&&(l=-l),{bearingDelta:l}},moveStateManager:a,enable:t,assignEvents:by})}(t,h),p=function({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5}){const r=new yy({checkCorrectEvent:t=>0===te.mouseButton(t)&&t.ctrlKey||2===te.mouseButton(t)});return new fy({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:r,enable:t,assignEvents:by})}(t),d=function({enable:t,clickTolerance:e,rollDegreesPerPixelMoved:i=.3},r){const n=new yy({checkCorrectEvent:t=>2===te.mouseButton(t)&&t.ctrlKey});return new fy({clickTolerance:e,move:(t,e)=>{const n=r();let s=(e.x-t.x)*i;return e.y<n.y&&(s=-s),{rollDelta:s}},moveStateManager:n,enable:t,assignEvents:by})}(t,h);e.dragRotate=new Ny(t,u,p,d),this._add("mouseRotate",u,["mousePitch"]),this._add("mousePitch",p,["mouseRotate","mouseRoll"]),this._add("mouseRoll",d,["mousePitch"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const f=function({enable:t,clickTolerance:e}){const i=new yy({checkCorrectEvent:t=>0===te.mouseButton(t)&&!t.ctrlKey});return new fy({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:by})}(t),m=new wy(t,e);e.dragPan=new Vy(i,f,m),this._add("mousePan",f),this._add("touchPan",m,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const _=new Cy,g=new My;e.touchZoomRotate=new Uy(i,g,_,l),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",g,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate);const y=e.scrollZoom=new By(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",y,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const x=e.keyboard=new ky(e);this._add("keyboard",x),t.interactive&&t.keyboard&&e.keyboard.enable(),this._add("blockableMapEvent",new ay(e))}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[]}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return Boolean(Gy(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const r in t)if(r!==i&&(!e||e.indexOf(r)<0))return!0;return!1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,e,i,r,n){if(!i)return;wt(t,i);const s={handlerName:r,originalEvent:i.originalEvent||n};void 0!==i.zoomDelta&&(e.zoom=s),void 0!==i.panDelta&&(e.drag=s),void 0!==i.rollDelta&&(e.roll=s),void 0!==i.pitchDelta&&(e.pitch=s),void 0!==i.bearingDelta&&(e.rotate=s)}_applyChanges(){const t={},e={},i={};for(const[r,n,o]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new s(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(t.rollDelta=(t.rollDelta||0)+r.rollDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),wt(e,n),wt(i,o);this._updateMapTransform(t,e,i),this._changes=[]}_updateMapTransform(t,e,i){const r=this._map,n=r._getTransformForUpdate(),s=r.terrain;if(!(qy(t)||s&&this._terrainMovement))return this._fireEvents(e,i,!0);r._stop(!0);let{panDelta:o,zoomDelta:a,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:p}=t;void 0!==p&&(u=p),u=u||r.transform.centerPoint,s&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const d={panDelta:o,zoomDelta:a,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const f=u.distSqr(n.centerPoint)<.01?n.center:n.screenPointToLocation(o?u.sub(o):u);s?(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(d,n),this._terrainMovement||!e.drag&&!e.zoom?e.drag&&this._terrainMovement?n.setCenter(n.screenPointToLocation(n.centerPoint.sub(o))):this._map.cameraHelper.handleMapControlsPan(d,n,f):(this._terrainMovement=!0,this._map._elevationFreeze=!0,this._map.cameraHelper.handleMapControlsPan(d,n,f))):(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(d,n),this._map.cameraHelper.handleMapControlsPan(d,n,f)),r._applyUpdatedTransform(n),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0)}_fireEvents(t,e,i){const r=Gy(this._eventsInProgress),n=Gy(t),s={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(s[`${e}start`]=i),this._eventsInProgress[e]=t[e]}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const t in s)this._fireEvent(t,s[t]);n&&this._fireEvent("move",n.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i)}const o={};let a;for(const t in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[t];this._handlersById[i].isActive()||(delete this._eventsInProgress[t],a=e[i]||r,o[`${t}end`]=a)}for(const t in o)this._fireEvent(t,o[t]);const l=Gy(this._eventsInProgress),c=(r||n)&&!l;if(c&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const t=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&t.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(t)}if(i&&c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),e=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&Qt.prefersReducedMotion?(this._map.fire(new xe("moveend",{originalEvent:a})),e(this._map.getBearing())&&this._map.resetNorth()):(e(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:a})),this._updatingCamera=!1}}_fireEvent(t,e){this._map.fire(new xe(t,e?{originalEvent:e}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new $y("renderFrame",{timeStamp:t})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}class Hy extends be{constructor(t,e,i){super(),this._renderFrameCallback=()=>{const t=Math.min((Qt.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,this.cameraHelper=e,this.on("moveend",(()=>{delete this._requestedCameraState}))}migrateProjection(t,e){t.apply(this.transform),this.transform=t,this.cameraHelper=e}getCenter(){return new Dp(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}getCenterElevation(){return this.transform.elevation}setCenterElevation(t,e){return this.jumpTo({elevation:t},e),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(t){this._centerClampedToGround=t}panBy(t,e,i){return t=s.convert(t).mult(-1),this.panTo(this.transform.center,wt({offset:t},e),i)}panTo(t,e,i){return this.easeTo(wt({center:t},e),i)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,e,i){return this.easeTo(wt({zoom:t},e),i)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(t,e){return t!=this.transform.fov&&(this.transform.setFov(t),this.fire(new xe("movestart",e)).fire(new xe("move",e)).fire(new xe("moveend",e))),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,e,i){return this.easeTo(wt({bearing:t},e),i)}resetNorth(t,e){return this.rotateTo(0,wt({duration:1e3},t),e),this}resetNorthPitch(t,e){return this.easeTo(wt({bearing:0,pitch:0,roll:0,duration:1e3},t),e),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}getRoll(){return this.transform.roll}setRoll(t,e){return this.jumpTo({roll:t},e),this}cameraForBounds(t,e){t=Rp.convert(t).adjustAntiMeridian();const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,e,i,r){const n={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=wt({padding:n,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const t=r.padding;r.padding={top:t,bottom:t,right:t,left:t}}const s=wt(n,r.padding);r.padding=s;const o=this.transform,a=new Rp(t,e);return this.cameraHelper.cameraForBoxAndBearing(r,s,a,i,o)}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,e,i,r,n){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(s.convert(t)),this.transform.screenPointToLocation(s.convert(e)),i,r),r,n)}_fitInternal(t,e,i){return t?(delete(e=wt(t,e)).padding,e.linear?this.easeTo(e,i):this.flyTo(e,i)):this}jumpTo(t,e){this.stop();const i=this._getTransformForUpdate();let r=!1,n=!1,s=!1;const o=i.zoom;this.cameraHelper.handleJumpToCenterZoom(i,t);const a=i.zoom!==o;return"elevation"in t&&i.elevation!==+t.elevation&&i.setElevation(+t.elevation),"bearing"in t&&i.bearing!==+t.bearing&&(r=!0,i.setBearing(+t.bearing)),"pitch"in t&&i.pitch!==+t.pitch&&(n=!0,i.setPitch(+t.pitch)),"roll"in t&&i.roll!==+t.roll&&(s=!0,i.setRoll(+t.roll)),null==t.padding||i.isPaddingEqual(t.padding)||i.setPadding(t.padding),this._applyUpdatedTransform(i),this.fire(new xe("movestart",e)).fire(new xe("move",e)),a&&this.fire(new xe("zoomstart",e)).fire(new xe("zoom",e)).fire(new xe("zoomend",e)),r&&this.fire(new xe("rotatestart",e)).fire(new xe("rotate",e)).fire(new xe("rotateend",e)),n&&this.fire(new xe("pitchstart",e)).fire(new xe("pitch",e)).fire(new xe("pitchend",e)),s&&this.fire(new xe("rollstart",e)).fire(new xe("roll",e)).fire(new xe("rollend",e)),this.fire(new xe("moveend",e))}calculateCameraOptionsFromTo(t,e,i,r=0){const n=Up.fromLngLat(t,e),s=Up.fromLngLat(i,r),o=s.x-n.x,a=s.y-n.y,l=s.z-n.z,c=Math.hypot(o,a,l);if(0===c)throw new Error("Can't calculate camera options with same From and To");const h=Math.hypot(o,a),u=It(this.transform.cameraToCenterDistance/c/this.transform.tileSize),p=180*Math.atan2(o,-a)/Math.PI;let d=180*Math.acos(h/c)/Math.PI;return d=l<0?90-d:90+d,{center:s.toLngLat(),elevation:r,zoom:u,pitch:d,bearing:p}}calculateCameraOptionsFromCameraLngLatAltRotation(t,e,i,r,n){const s=this.transform.calculateCenterFromCameraLngLatAlt(t,e,i,r);return{center:s.center,elevation:s.elevation,zoom:s.zoom,bearing:i,pitch:r,roll:n}}easeTo(t,e){this._stop(!1,t.easeId),(!1===(t=wt({offset:[0,0],duration:500,easing:xt},t)).animate||!t.essential&&Qt.prefersReducedMotion)&&(t.duration=0);const i=this._getTransformForUpdate(),r=this.getBearing(),n=i.pitch,o=i.roll,a="bearing"in t?this._normalizeBearing(t.bearing,r):r,l="pitch"in t?+t.pitch:n,c="roll"in t?this._normalizeBearing(t.roll,o):o,h="padding"in t?t.padding:i.padding,u=s.convert(t.offset);let p,d;t.around&&(p=Dp.convert(t.around),d=i.locationToScreenPoint(p));const f={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},m=this.cameraHelper.handleEaseTo(i,{bearing:a,pitch:l,roll:c,padding:h,around:p,aroundPoint:d,offsetAsPoint:u,offset:t.offset,zoom:t.zoom,center:t.center});return this._rotating=this._rotating||r!==a,this._pitching=this._pitching||l!==n,this._rolling=this._rolling||c!==o,this._padding=!i.isPaddingEqual(h),this._zooming=this._zooming||m.isZooming,this._easeId=t.easeId,this._prepareEase(e,t.noMoveStart,f),this.terrain&&this._prepareElevation(m.elevationCenter),this._ease((r=>{m.easeFunc(r),this.terrain&&!t.freezeElevation&&this._updateElevation(r),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(i=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e,i)}),t),this}_prepareEase(t,e,i={}){this._moving=!0,e||i.moving||this.fire(new xe("movestart",t)),this._zooming&&!i.zooming&&this.fire(new xe("zoomstart",t)),this._rotating&&!i.rotating&&this.fire(new xe("rotatestart",t)),this._pitching&&!i.pitching&&this.fire(new xe("pitchstart",t)),this._rolling&&!i.rolling&&this.fire(new xe("rollstart",t))}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0}_updateElevation(t){void 0!==this._elevationStart&&void 0!==this._elevationCenter||this._prepareElevation(this.transform.center),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const e=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&e!==this._elevationTarget){const i=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(i-(e-(i*t+this._elevationStart))/(1-t)),this._elevationTarget=e}this.transform.setElevation(xr.number(this._elevationStart,this._elevationTarget,t))}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain)}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(t){if(!this.terrain&&t.elevation>=0&&t.pitch<=90)return{};const e=t.getCameraLngLat(),i=t.getCameraAltitude(),r=this.terrain?this.terrain.getElevationForLngLatZoom(e,t.zoom):0;if(i<r){const i=this.calculateCameraOptionsFromTo(e,r,t.center,t.elevation);return{pitch:i.pitch,zoom:i.zoom}}return{}}_applyUpdatedTransform(t){const e=[];if(e.push((t=>this._elevateCameraIfInsideTerrain(t))),this.transformCameraUpdate&&e.push((t=>this.transformCameraUpdate(t))),!e.length)return;const i=t.clone();for(const t of e){const e=i.clone(),{center:r,zoom:n,roll:s,pitch:o,bearing:a,elevation:l}=t(e);r&&e.setCenter(r),void 0!==l&&e.setElevation(l),void 0!==n&&e.setZoom(n),void 0!==s&&e.setRoll(s),void 0!==o&&e.setPitch(o),void 0!==a&&e.setBearing(a),i.apply(e)}this.transform.apply(i)}_fireMoveEvents(t){this.fire(new xe("move",t)),this._zooming&&this.fire(new xe("zoom",t)),this._rotating&&this.fire(new xe("rotate",t)),this._pitching&&this.fire(new xe("pitch",t)),this._rolling&&this.fire(new xe("roll",t))}_afterEase(t,e){if(this._easeId&&e&&this._easeId===e)return;delete this._easeId;const i=this._zooming,r=this._rotating,n=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,i&&this.fire(new xe("zoomend",t)),r&&this.fire(new xe("rotateend",t)),n&&this.fire(new xe("pitchend",t)),s&&this.fire(new xe("rollend",t)),this.fire(new xe("moveend",t))}flyTo(t,e){if(!t.essential&&Qt.prefersReducedMotion){const i=Tt(t,["center","zoom","bearing","pitch","roll","elevation"]);return this.jumpTo(i,e)}this.stop(),t=wt({offset:[0,0],speed:1.2,curve:1.42,easing:xt},t);const i=this._getTransformForUpdate(),r=i.bearing,n=i.pitch,o=i.roll,a=i.padding,l="bearing"in t?this._normalizeBearing(t.bearing,r):r,c="pitch"in t?+t.pitch:n,h="roll"in t?this._normalizeBearing(t.roll,o):o,u="padding"in t?t.padding:i.padding,p=s.convert(t.offset);let d=i.centerPoint.add(p);const f=i.screenPointToLocation(d),m=this.cameraHelper.handleFlyTo(i,{bearing:l,pitch:c,roll:h,padding:u,locationAtOffset:f,offsetAsPoint:p,center:t.center,minZoom:t.minZoom,zoom:t.zoom});let _=t.curve;const g=Math.max(i.width,i.height),y=g/m.scaleOfZoom,x=m.pixelPathLength;"number"==typeof m.scaleOfMinZoom&&(_=Math.sqrt(g/m.scaleOfMinZoom/x*2));const v=_*_;function b(t){const e=(y*y-g*g+(t?-1:1)*v*v*x*x)/(2*(t?y:g)*v*x);return Math.log(Math.sqrt(e*e+1)-e)}function w(t){return(Math.exp(t)-Math.exp(-t))/2}function T(t){return(Math.exp(t)+Math.exp(-t))/2}const P=b(!1);let S=function(t){return T(P)/T(P+_*t)},M=function(t){return g*((T(P)*(w(e=P+_*t)/T(e))-w(P))/v)/x;var e},I=(b(!0)-P)/_;if(Math.abs(x)<2e-6||!isFinite(I)){if(Math.abs(g-y)<1e-6)return this.easeTo(t,e);const i=y<g?-1:1;I=Math.abs(Math.log(y/g))/_,M=()=>0,S=t=>Math.exp(i*_*t)}return t.duration="duration"in t?+t.duration:1e3*I/("screenSpeed"in t?+t.screenSpeed/_:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=r!==l,this._pitching=c!==n,this._rolling=h!==o,this._padding=!i.isPaddingEqual(u),this._prepareEase(e,!1),this.terrain&&this._prepareElevation(m.targetCenter),this._ease((s=>{const f=s*I,_=1/S(f),g=M(f);this._rotating&&i.setBearing(xr.number(r,l,s)),this._pitching&&i.setPitch(xr.number(n,c,s)),this._rolling&&i.setRoll(xr.number(o,h,s)),this._padding&&(i.interpolatePadding(a,u,s),d=i.centerPoint.add(p)),m.easeFunc(s,_,g,d),this.terrain&&!t.freezeElevation&&this._updateElevation(s),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(()=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e)}),t),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(t,e){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e)}return t||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=Qt.now(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_normalizeBearing(t,e){t=bt(t,-180,180);const i=Math.abs(t-e);return Math.abs(t-360-e)<i&&(t-=360),Math.abs(t+360-e)<i&&(t+=360),t}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom(Dp.convert(t),this.transform.tileZoom):null}}const Xy={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class Yy{constructor(t=Xy){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")))},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions()},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"))},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show")},this.options=t}getDefaultPosition(){return"bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=te.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=te.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=te.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){te.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i)}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id}const e=this._map.style.sourceCaches;for(const i in e){const r=e[i];if(r.used||r.usedForTerrain){const e=r.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution)}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let r=i+1;r<t.length;r++)if(t[r].indexOf(e)>=0)return!1;return!0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=te.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null)}}class Ky{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact")}},this.options=t}getDefaultPosition(){return"bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=te.create("div","maplibregl-ctrl");const e=te.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){te.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0}}class Jy{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}var Qy;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(Qy||(Qy={}));let tx=null,ex=[];const ix=1e3/60,rx="loadTime",nx="fullLoadTime",sx={mark(t){performance.mark(t)},frame(t){const e=t;null!=tx&&ex.push(e-tx),tx=e},clearMetrics(){tx=null,ex=[],performance.clearMeasures(rx),performance.clearMeasures(nx);for(const t in Qy)performance.clearMarks(Qy[t])},getPerformanceMetrics(){performance.measure(rx,Qy.create,Qy.load),performance.measure(nx,Qy.create,Qy.fullLoad);const t=performance.getEntriesByName(rx)[0].duration,e=performance.getEntriesByName(nx)[0].duration,i=ex.length,r=1/(ex.reduce(((t,e)=>t+e),0)/i/1e3),n=ex.filter((t=>t>ix)).reduce(((t,e)=>t+(e-ix)/ix),0);return{loadTime:t,fullLoadTime:e,fps:r,percentDroppedFrames:n/(i+n)*100,totalFrames:i}}};var ox=Yo([{name:"a_pos3d",type:"Int16",components:3}]);class ax extends be{constructor(t){super(),this._lastTilesetChange=Qt.now(),this.sourceCache=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=t._source.tileSize*2**this.deltaZoom,t.usedForTerrain=!0,t.tileSize=this.tileSize}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null}update(t,e){this.sourceCache.update(t,e),this._renderableTilesKeys=[];const i={};for(const r of Id(t,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:e,calculateTileZoom:this.sourceCache._source.calculateTileZoom}))i[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),I(r.terrainRttPosMatrix32f,0,Q,Q,0,0,1),this._tiles[r.key]=new dd(r,this.tileSize),this._lastTilesetChange=Qt.now());for(const t in this._tiles)i[t]||delete this._tiles[t]}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[])}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t,e){return e?this._getTerrainCoordsForTileRanges(t,e):this._getTerrainCoordsForRegularTile(t)}_getTerrainCoordsForRegularTile(t){const e={};for(const i of this._renderableTilesKeys){const r=this._tiles[i].tileID,n=t.clone(),s=rt();if(r.canonical.equals(t.canonical))I(s,0,Q,Q,0,0,1);else if(r.canonical.isChildOf(t.canonical)){const e=r.canonical.z-t.canonical.z,i=r.canonical.x-(r.canonical.x>>e<<e),n=r.canonical.y-(r.canonical.y>>e<<e),o=Q>>e;I(s,0,o,o,0,0,1),b(s,s,[-i*o,-n*o,0])}else{if(!t.canonical.isChildOf(r.canonical))continue;{const e=t.canonical.z-r.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),n=t.canonical.y-(t.canonical.y>>e<<e),o=Q>>e;I(s,0,Q,Q,0,0,1),b(s,s,[i*o,n*o,0]),w(s,s,[1/2**e,1/2**e,0])}}n.terrainRttPosMatrix32f=new Float32Array(s),e[i]=n}return e}_getTerrainCoordsForTileRanges(t,e){const i={};for(const r of this._renderableTilesKeys){const n=this._tiles[r].tileID;if(!this._isWithinTileRanges(n,e))continue;const s=t.clone(),o=rt();if(n.canonical.z===t.canonical.z){const e=t.canonical.x-n.canonical.x,i=t.canonical.y-n.canonical.y;I(o,0,Q,Q,0,0,1),b(o,o,[e*Q,i*Q,0])}else if(n.canonical.z>t.canonical.z){const e=n.canonical.z-t.canonical.z,i=n.canonical.x-(n.canonical.x>>e<<e),r=n.canonical.y-(n.canonical.y>>e<<e),s=t.canonical.x-(n.canonical.x>>e),a=t.canonical.y-(n.canonical.y>>e),l=Q>>e;I(o,0,l,l,0,0,1),b(o,o,[-i*l+s*Q,-r*l+a*Q,0])}else{const e=t.canonical.z-n.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),r=t.canonical.y-(t.canonical.y>>e<<e),s=(t.canonical.x>>e)-n.canonical.x,a=(t.canonical.y>>e)-n.canonical.y,l=Q<<e;I(o,0,l,l,0,0,1),b(o,o,[i*Q+s*l,r*Q+a*l,0])}s.terrainRttPosMatrix32f=new Float32Array(o),i[r]=s}return i}getSourceTile(t,e){const i=this.sourceCache._source;let r=t.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(r).key);let n=this.sourceCache.getTileByID(this._sourceTileCache[t.key]);if((!n||!n.dem)&&e)for(;r>=i.minzoom&&(!n||!n.dem);)n=this.sourceCache.getTileByID(t.scaledTo(r--).key);return n}anyTilesAfterTime(t=Date.now()){return this._lastTilesetChange>=t}_isWithinTileRanges(t,e){return e[t.canonical.z]&&t.canonical.x>=e[t.canonical.z].minTileX&&t.canonical.x<=e[t.canonical.z].maxTileX&&t.canonical.y>=e[t.canonical.z].minTileY&&t.canonical.y<=e[t.canonical.z].maxTileY}}class lx{constructor(t,e,i){this._meshCache={},this.painter=t,this.sourceCache=new ax(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024}getDEMElevation(t,e,i,r=8192){var n;if(!(e>=0&&e<r&&i>=0&&i<r))return 0;const s=this.getTerrainData(t),o=null===(n=s.tile)||void 0===n?void 0:n.dem;if(!o)return 0;const a=function(t,e,i){var r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t}([],[e/r*Q,i/r*Q],s.u_terrain_matrix),l=[a[0]*o.dim,a[1]*o.dim],c=Math.floor(l[0]),h=Math.floor(l[1]),u=l[0]-c,p=l[1]-h;return o.get(c,h)*(1-u)*(1-p)+o.get(c+1,h)*u*(1-p)+o.get(c,h+1)*(1-u)*p+o.get(c+1,h+1)*u*p}getElevationForLngLatZoom(t,e){if(!function(t,e){const{x:i,y:r}=Up.fromLngLat(e);return!(t<0||t>25||r<0||r>=1||i<0||i>=1)}(e,t.wrap()))return 0;const{tileID:i,mercatorX:r,mercatorY:n}=this._getOverscaledTileIDFromLngLatZoom(t,e);return this.getElevation(i,r%Q,n%Q,Q)}getElevation(t,e,i,r=8192){return this.getDEMElevation(t,e,i,r)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,e=new vc({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new Ec(t,e,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new Ec(t,new vc({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=y([])}const e=this.sourceCache.getSourceTile(t,!0);if(e&&e.dem&&(!e.demTexture||e.needsTerrainPrepare)){const t=this.painter.context;e.demTexture=this.painter.getTileTexture(e.dem.stride),e.demTexture?e.demTexture.update(e.dem.getPixels(),{premultiply:!1}):e.demTexture=new Ec(t,e.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),e.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),e.needsTerrainPrepare=!1}const i=e&&e+e.tileID.key+t.key;if(i&&!this._demMatrixCache[i]){const i=this.sourceCache.sourceCache._source.maxzoom;let s=t.canonical.z-e.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=i?s=t.canonical.z-i:Dt("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=t.canonical.x-(t.canonical.x>>s<<s),a=t.canonical.y-(t.canonical.y>>s<<s),l=((r=new Float64Array(16))[0]=(n=[1/(Q<<s),1/(Q<<s),0])[0],r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=n[1],r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=n[2],r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r);b(l,l,[o*Q,a*Q,0]),this._demMatrixCache[t.key]={matrix:l,coord:t}}var r,n;return{u_depth:2,u_terrain:3,u_terrain_dim:e&&e.dem&&e.dem.dim||1,u_terrain_matrix:i?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:e&&e.dem&&e.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(e&&e.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:e}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,r=e.height/devicePixelRatio;return!this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new Ec(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new Ec(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const e=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,i=0;t<this._coordsTextureSize;t++)for(let r=0;r<this._coordsTextureSize;r++,i+=4)e[i+0]=255&r,e[i+1]=255&t,e[i+2]=r>>8<<4|t>>8,e[i+3]=0;const i=new vc({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(e.buffer)),r=new Ec(t,i,t.gl.RGBA,{premultiply:!1});return r.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(t){this.painter.maybeDrawDepthAndCoords(!0);const e=new Uint8Array(4),i=this.painter.context,r=i.gl,n=Math.round(t.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(t.y*this.painter.pixelRatio/devicePixelRatio),o=Math.round(this.painter.height/devicePixelRatio);i.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(n,o-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null);const a=e[0]+(e[2]>>4<<8),l=e[1]+((15&e[2])<<8),c=this.coordsIndex[255-e[3]],h=c&&this.sourceCache.getTileByID(c);if(!h)return null;const u=this._coordsTextureSize,p=(1<<h.tileID.canonical.z)*u;return new Up((h.tileID.canonical.x*u+a)/p+h.tileID.wrap,(h.tileID.canonical.y*u+l)/p,this.getElevation(h.tileID,a,l,u))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(t){var e;const i=(null===(e=this.painter.style.projection)||void 0===e?void 0:e.transitionState)>0,r=i&&0===t.canonical.y,n=i&&t.canonical.y===(1<<t.canonical.z)-1,s=`m_${r?"n":""}_${n?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const o=this.painter.context,a=new Ra,l=new Xa,c=this.meshSize,h=Q/c,u=c*c;for(let t=0;t<=c;t++)for(let e=0;e<=c;e++)a.emplaceBack(e*h,t*h,0);for(let t=0;t<u;t+=c+1)for(let e=0;e<c;e++)l.emplaceBack(e+t,c+e+t+1,c+e+t+2),l.emplaceBack(e+t,c+e+t+2,e+t+1);const p=a.length,d=p+(c+1),f=(c+1)*c,m=r?ch:0,_=r?0:1,g=n?hh:Q,y=n?0:1;for(let t=0;t<=c;t++)a.emplaceBack(t*h,m,_);for(let t=0;t<=c;t++)a.emplaceBack(t*h,g,y);for(let t=0;t<c;t++)l.emplaceBack(f+t,d+t,d+t+1),l.emplaceBack(f+t,d+t+1,f+t+1),l.emplaceBack(0+t,p+t+1,p+t),l.emplaceBack(0+t,0+t+1,p+t+1);const x=a.length,v=x+2*(c+1);for(const t of[0,1])for(let e=0;e<=c;e++)for(const i of[0,1])a.emplaceBack(t*Q,e*h,i);for(let t=0;t<2*c;t+=2)l.emplaceBack(x+t,x+t+1,x+t+3),l.emplaceBack(x+t,x+t+3,x+t+2),l.emplaceBack(v+t,v+t+3,v+t+1),l.emplaceBack(v+t,v+t+2,v+t+3);const b=new Nf(o.createVertexBuffer(a,ox.members),o.createIndexBuffer(l),tl.simpleSegment(0,0,a.length,l.length));return this._meshCache[s]=b,b}getMeshFrameDelta(t){return 2*Math.PI*kp/Math.pow(2,Math.max(t,0))/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,e){const i=Up.fromLngLat(t.wrap()),r=(1<<e)*Q,n=i.x*r,s=i.y*r,o=Math.floor(n/Q),a=Math.floor(s/Q);return{tileID:new Xp(e,0,e,o,a),mercatorX:n,mercatorY:s}}}class cx{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy()}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new Ec(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id)}stampObject(t){t.stamp=++this._stamp}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1}freeAllObjects(){for(const t of this._objects)this.freeObject(t)}isFull(){return!(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const hx={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class ux{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new cx(t.context,30,e.sourceCache.tileSize*e.qualityFactor)}destruct(){this.pool.destruct()}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsAscending={};for(const e in t.sourceCaches){this._coordsAscending[e]={};const i=t.sourceCaches[e].getVisibleCoordinates(),r=t.sourceCaches[e].getSource(),n=r instanceof td?r.terrainTileRanges:null;for(const t of i){const i=this.terrain.sourceCache.getTerrainCoords(t,n);for(const t in i)this._coordsAscending[e][t]||(this._coordsAscending[e][t]=[]),this._coordsAscending[e][t].push(i[t])}}this._coordsAscendingStr={};for(const e of t._order){const i=t._layers[e],r=i.source;if(hx[i.type]&&!this._coordsAscendingStr[r]){this._coordsAscendingStr[r]={};for(const t in this._coordsAscending[r])this._coordsAscendingStr[r][t]=this._coordsAscending[r][t].map((t=>t.key)).sort().join()}}for(const t of this._renderableTiles)for(const e in this._coordsAscendingStr){const i=this._coordsAscendingStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[])}}renderLayer(t,e){if(t.isHidden(this.painter.transform.zoom))return!1;const i=Object.assign(Object.assign({},e),{isRenderingToTexture:!0}),r=t.type,n=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(hx[r]&&(this._prevType&&hx[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(t.id),!s))return!0;if(hx[this._prevType]||hx[r]&&s){this._prevType=r;const t=this._stacks.length-1,e=this._stacks[t]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(Zg(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[t]){const e=this.pool.getObjectForId(r.rtt[t].id);if(e.stamp===r.rtt[t].stamp){this.pool.useObject(e);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[t]={id:s.id,stamp:s.stamp},n.context.bindFramebuffer.set(s.fbo.framebuffer),n.context.clear({color:zi.transparent,stencil:0}),n.currentStencilSource=void 0;for(let t=0;t<e.length;t++){const o=n.style._layers[e[t]],a=o.source?this._coordsAscending[o.source][r.tileID.key]:[r.tileID];n.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),n._renderTileClippingMasks(o,a,!0),n.renderLayer(n,n.style.sourceCaches[o.source],o,a,i),o.source&&(r.rttCoords[o.source]=this._coordsAscendingStr[o.source][r.tileID.key])}}return Zg(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects(),hx[r]}return!1}}const px={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},dx=r,fx={hash:!1,interactive:!0,bearingSnap:7,attributionControl:Xy,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:ee.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0},mx={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class _x{constructor(t,e,i=!1){this.mousedown=t=>{this.startMove(t,te.mousePos(this.element,t)),te.addEventListener(window,"mousemove",this.mousemove),te.addEventListener(window,"mouseup",this.mouseup)},this.mousemove=t=>{this.move(t,te.mousePos(this.element,t))},this.mouseup=t=>{this._rotatePitchHandler.dragEnd(t),this.offTemp()},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=te.touchPos(this.element,t.targetTouches)[0],this.startMove(t,this._startPos),te.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),te.addEventListener(window,"touchend",this.touchend))},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=te.touchPos(this.element,t.targetTouches)[0],this.move(t,this._lastPos))},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp()},this.reset=()=>{this._rotatePitchHandler.reset(),delete this._startPos,delete this._lastPos,this.offTemp()},this._clickTolerance=10,this.element=e;const r=new vy;this._rotatePitchHandler=new fy({clickTolerance:3,move:(t,r)=>{const n=e.getBoundingClientRect(),o=new s((n.bottom-n.top)/2,(n.right-n.left)/2);return{bearingDelta:Zt(new s(t.x,r.y),r,o),pitchDelta:i?-.5*(r.y-t.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=t,te.addEventListener(e,"mousedown",this.mousedown),te.addEventListener(e,"touchstart",this.touchstart,{passive:!1}),te.addEventListener(e,"touchcancel",this.reset)}startMove(t,e){this._rotatePitchHandler.dragStart(t,e),te.disableDrag()}move(t,e){const i=this.map,{bearingDelta:r,pitchDelta:n}=this._rotatePitchHandler.dragMove(t,e)||{};r&&i.setBearing(i.getBearing()+r),n&&i.setPitch(i.getPitch()+n)}off(){const t=this.element;te.removeEventListener(t,"mousedown",this.mousedown),te.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),te.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),te.removeEventListener(window,"touchend",this.touchend),te.removeEventListener(t,"touchcancel",this.reset),this.offTemp()}offTemp(){te.enableDrag(),te.removeEventListener(window,"mousemove",this.mousemove),te.removeEventListener(window,"mouseup",this.mouseup),te.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),te.removeEventListener(window,"touchend",this.touchend)}}let gx;function yx(t,e,i,r=!1){if(r||!i.getCoveringTilesDetailsProvider().allowWorldCopies())return null==t?void 0:t.wrap();const n=new Dp(t.lng,t.lat);if(t=new Dp(t.lng,t.lat),e){const r=new Dp(t.lng-360,t.lat),n=new Dp(t.lng+360,t.lat),s=i.locationToScreenPoint(t).distSqr(e);i.locationToScreenPoint(r).distSqr(e)<s?t=r:i.locationToScreenPoint(n).distSqr(e)<s&&(t=n)}for(;Math.abs(t.lng-i.center.lng)>180;){const e=i.locationToScreenPoint(t);if(e.x>=0&&e.y>=0&&e.x<=i.width&&e.y<=i.height)break;t.lng>i.center.lng?t.lng-=360:t.lng+=360}return t.lng!==n.lng&&i.isPointOnMapSurface(i.locationToScreenPoint(t))?t:n}const xx={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function vx(t,e,i){const r=t.classList;for(const t in xx)r.remove(`maplibregl-${i}-anchor-${t}`);r.add(`maplibregl-${i}-anchor-${e}`)}class bx extends be{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup()},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup()},this._update=t=>{if(!this._map)return;const e=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!e)&&this._map.once("render",this._update),this._lngLat=yx(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let r="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?r="rotateX(0deg)":"map"===this._pitchAlignment&&(r=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||t&&"moveend"!==t.type||(this._pos=this._pos.round()),te.setTransform(this._element,`${xx[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${r} ${i}`),Qt.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type)})).catch((()=>{}))},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new xe("dragstart"))),this.fire(new xe("drag")))},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new xe("dragend")),this._state="inactive"},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp))},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._subpixelPositioning=t&&t.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=s.convert(t&&t.offset||[0,0]);else{this._defaultMarker=!0,this._element=te.create("div");const e=te.createNS("http://www.w3.org/2000/svg","svg"),i=41,r=27;e.setAttributeNS(null,"display","block"),e.setAttributeNS(null,"height",`${i}px`),e.setAttributeNS(null,"width",`${r}px`),e.setAttributeNS(null,"viewBox",`0 0 ${r} ${i}`);const n=te.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const o=te.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"fill-rule","nonzero");const a=te.createNS("http://www.w3.org/2000/svg","g");a.setAttributeNS(null,"transform","translate(3.0, 29.0)"),a.setAttributeNS(null,"fill","#000000");const l=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of l){const e=te.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),a.appendChild(e)}const c=te.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const h=te.createNS("http://www.w3.org/2000/svg","path");h.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(h);const u=te.createNS("http://www.w3.org/2000/svg","g");u.setAttributeNS(null,"opacity","0.25"),u.setAttributeNS(null,"fill","#000000");const p=te.createNS("http://www.w3.org/2000/svg","path");p.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),u.appendChild(p);const d=te.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"transform","translate(6.0, 7.0)"),d.setAttributeNS(null,"fill","#FFFFFF");const f=te.createNS("http://www.w3.org/2000/svg","g");f.setAttributeNS(null,"transform","translate(8.0, 8.0)");const m=te.createNS("http://www.w3.org/2000/svg","circle");m.setAttributeNS(null,"fill","#000000"),m.setAttributeNS(null,"opacity","0.25"),m.setAttributeNS(null,"cx","5.5"),m.setAttributeNS(null,"cy","5.5"),m.setAttributeNS(null,"r","5.4999962");const _=te.createNS("http://www.w3.org/2000/svg","circle");_.setAttributeNS(null,"fill","#FFFFFF"),_.setAttributeNS(null,"cx","5.5"),_.setAttributeNS(null,"cy","5.5"),_.setAttributeNS(null,"r","5.4999962"),f.appendChild(m),f.appendChild(_),o.appendChild(a),o.appendChild(c),o.appendChild(u),o.appendChild(d),o.appendChild(f),e.appendChild(o),e.setAttributeNS(null,"height",i*this._scale+"px"),e.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(e),this._offset=s.convert(t&&t.offset||[0,-14])}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault()})),this._element.addEventListener("mousedown",(t=>{t.preventDefault()})),vx(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null}addTo(t){return this.remove(),this._map=t,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",t._getUIString("Marker.Title")),t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),t.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),te.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=Dp.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[r,-1*(e-i+r)],"bottom-right":[-r,-1*(e-i+r)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress)}return this}setSubpixelPositioning(t){return this._subpixelPositioning=t,this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var e,i;const r=null===(e=this._map)||void 0===e?void 0:e.terrain,n=this._map.transform.isLocationOccluded(this._lngLat);if(!r||n){const t=n?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==t&&(this._element.style.opacity=t))}if(t)this._opacityTimeout=null;else{if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null}),100)}const o=this._map,a=o.terrain.depthAtPoint(this._pos),l=o.terrain.getElevationForLngLatZoom(this._lngLat,o.transform.tileZoom);if(o.transform.lngLatToCameraDepth(this._lngLat,l)-a<.006)return void(this._element.style.opacity=this._opacity);const c=-this._offset.y/o.transform.pixelsPerMeter,h=Math.sin(o.getPitch()*Math.PI/180)*c,u=o.terrain.depthAtPoint(new s(this._pos.x,this._pos.y-this._offset.y)),p=o.transform.lngLatToCameraDepth(this._lngLat,l+h)-u>.006;(null===(i=this._popup)||void 0===i?void 0:i.isOpen())&&p&&this._popup.remove(),this._element.style.opacity=p?this._opacityWhenCovered:this._opacity}getOffset(){return this._offset}setOffset(t){return this._offset=s.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t)}removeClassName(t){this._element.classList.remove(t)}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return(void 0===this._opacity||void 0===t&&void 0===e)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const wx={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let Tx=0,Px=!1;const Sx={maxWidth:100,unit:"metric"};function Mx(t,e,i){const r=i&&i.maxWidth||100,n=t._container.clientHeight/2,s=t._container.clientWidth/2,o=t.unproject([s-r/2,n]),a=t.unproject([s+r/2,n]),l=Math.round(t.project(a).x-t.project(o).x),c=Math.min(r,l,t._container.clientWidth),h=o.distanceTo(a);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?Ix(e,c,i/5280,t._getUIString("ScaleControl.Miles")):Ix(e,c,i,t._getUIString("ScaleControl.Feet"))}else i&&"nautical"===i.unit?Ix(e,c,h/1852,t._getUIString("ScaleControl.NauticalMiles")):h>=1e3?Ix(e,c,h/1e3,t._getUIString("ScaleControl.Kilometers")):Ix(e,c,h,t._getUIString("ScaleControl.Meters"))}function Ix(t,e,i,r){const n=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(n/i)+"px",t.innerHTML=`${n}&nbsp;${r}`}const Cx={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0},Ex=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Ax(t){if(t){if("number"==typeof t){const e=Math.round(Math.abs(t)/Math.SQRT2);return{center:new s(0,0),top:new s(0,t),"top-left":new s(e,e),"top-right":new s(-e,e),bottom:new s(0,-t),"bottom-left":new s(e,-e),"bottom-right":new s(-e,-e),left:new s(t,0),right:new s(-t,0)}}if(t instanceof s||Array.isArray(t)){const e=s.convert(t);return{center:e,top:e,"top-left":e,"top-right":e,bottom:e,"bottom-left":e,"bottom-right":e,left:e,right:e}}return{center:s.convert(t.center||[0,0]),top:s.convert(t.top||[0,0]),"top-left":s.convert(t["top-left"]||[0,0]),"top-right":s.convert(t["top-right"]||[0,0]),bottom:s.convert(t.bottom||[0,0]),"bottom-left":s.convert(t["bottom-left"]||[0,0]),"bottom-right":s.convert(t["bottom-right"]||[0,0]),left:s.convert(t.left||[0,0]),right:s.convert(t.right||[0,0])}}return Ax(new s(0,0))}const zx=r;t.AJAXError=ne,t.AttributionControl=Yy,t.BoxZoomHandler=cy,t.CanvasSource=id,t.CooperativeGesturesHandler=Zy,t.DoubleClickZoomHandler=Fy,t.DragPanHandler=Vy,t.DragRotateHandler=Ny,t.EdgeInsets=qf,t.Event=xe,t.Evented=be,t.FullscreenControl=class extends be{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange()},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen()},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:Dt("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange")}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=te.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){te.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange)}_setupUI(){const t=this._fullscreenButton=te.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);te.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange)}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new xe("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new xe("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable())}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen()}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen()}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize()}},t.GeoJSONSource=Jp,t.GeolocateControl=class extends be{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new xe("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new xe("geolocate",t)),this._finish()}},this._updateCamera=t=>{const e=new Dp(t.coords.longitude,t.coords.latitude),i=t.coords.accuracy,r=wt({bearing:this._map.getBearing()},this.options.fitBoundsOptions),n=Rp.fromLngLat(e,i);this._map.fitBounds(n,r,{geolocateSource:!0})},this._updateMarker=t=>{if(t){const e=new Dp(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(e).addTo(this._map),this._userLocationDotMarker.setLngLat(e).addTo(this._map),this._accuracy=t.coords.accuracy,this._updateCircleRadiusIfNeeded()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()},this._onUpdate=()=>{this._updateCircleRadiusIfNeeded()},this._onError=t=>{if(this._map){if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===t.code&&Px)return;this.options.trackUserLocation&&this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new xe("error",t)),this._finish()}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=te.create("button","maplibregl-ctrl-geolocate",this._container),te.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0)},this._finishSetupUI=t=>{if(this._map){if(!1===t){Dt("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}else{const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=te.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new bx({element:this._dotElement}),this._circleElement=te.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new bx({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onUpdate),this._map.on("move",this._onUpdate),this._map.on("rotate",this._onUpdate),this._map.on("pitch",this._onUpdate)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{const e=(null==t?void 0:t[0])instanceof ResizeObserverEntry;t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||e||this._map.isZooming()||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new xe("trackuserlocationend")),this.fire(new xe("userlocationlostfocus")))}))}},this.options=wt({},wx,t)}onAdd(t){return this._map=t,this._container=te.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return n(this,arguments,void 0,(function*(t=!1){if(void 0!==gx&&!t)return gx;if(void 0===window.navigator.permissions)return gx=!!window.navigator.geolocation,gx;try{const t=yield window.navigator.permissions.query({name:"geolocation"});gx="denied"!==t.state}catch(t){gx=!!window.navigator.geolocation}return gx}))}().then((t=>this._finishSetupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),te.remove(this._container),this._map.off("zoom",this._onUpdate),this._map.off("move",this._onUpdate),this._map.off("rotate",this._onUpdate),this._map.off("pitch",this._onUpdate),this._map=void 0,Tx=0,Px=!1}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadiusIfNeeded(){const t=this._userLocationDotMarker.getLngLat();if(!(this.options.showUserLocation&&this.options.showAccuracyCircle&&this._accuracy&&t))return;const e=this._map.project(t),i=this._map.unproject([e.x+100,e.y]),r=t.distanceTo(i)/100,n=2*this._accuracy/r;this._circleElement.style.width=`${n.toFixed(2)}px`,this._circleElement.style.height=`${n.toFixed(2)}px`}trigger(){if(!this._setup)return Dt("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new xe("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":Tx--,Px=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new xe("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new xe("trackuserlocationstart")),this.fire(new xe("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),Tx++,Tx>1?(t={maximumAge:6e5,timeout:0},Px=!0):(t=this.options.positionOptions,Px=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t)}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},t.GlobeControl=class{constructor(){this._toggleProjection=()=>{var t;const e=null===(t=this._map.getProjection())||void 0===t?void 0:t.type;this._map.setProjection("mercator"!==e&&e?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon()},this._updateGlobeIcon=()=>{var t;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(t=this._map.getProjection())||void 0===t?void 0:t.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"))}}onAdd(t){return this._map=t,this._container=te.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=te.create("button","maplibregl-ctrl-globe",this._container),te.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){te.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0}},t.Hash=Wg,t.ImageSource=td,t.KeyboardHandler=ky,t.LngLat=Dp,t.LngLatBounds=Rp,t.LogoControl=Ky,t.Map=class extends Hy{constructor(t){var e,i;sx.mark(Qy.create);const r=Object.assign(Object.assign(Object.assign({},fx),t),{canvasContextAttributes:Object.assign(Object.assign({},fx.canvasContextAttributes),t.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const n=new Qf,s=new rm;if(void 0!==r.minZoom&&n.setMinZoom(r.minZoom),void 0!==r.maxZoom&&n.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&n.setMinPitch(r.minPitch),void 0!==r.maxPitch&&n.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&n.setRenderWorldCopies(r.renderWorldCopies),super(n,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new Jy,this._controls=[],this._mapId=St(),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new xe("webglcontextlost",{originalEvent:t}))},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new xe("webglcontextrestored",{originalEvent:t}))},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update()},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},px),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this.transformCameraUpdate=r.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=me.addThrottleControl((()=>this.isMoving())),this._requestManager=new _e(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else{if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0)})),this.once("idle",(()=>{this._idleTriggered=!0})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=qg((t=>{this._trackResize&&!this._removed&&(this.resize(t),this.redraw())}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0})),this._resizeObserver.observe(this._container)}this.handlers=new Wy(this,r),this._hash=r.hash&&new Wg("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,wt({},r.fitBoundsOptions,{duration:0}))));const o="string"==typeof r.style||!("globe"===(null===(i=null===(e=r.style)||void 0===e?void 0:e.projection)||void 0===i?void 0:i.type));this.resize(null,o),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new Yy("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new Ky,r.logoPosition),this.on("style.load",(()=>{if(o||this._resizeTransform(),this.transform.unmodified){const t=Tt(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(t)}})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new xe(`${t.dataType}data`,t))})),this.on("dataloading",(t=>{this.fire(new xe(`${t.dataType}dataloading`,t))})),this.on("dataabort",(t=>{this.fire(new xe("sourcedataabort",t))}))}_getMapId(){return this._mapId}setGlobalStateProperty(t,e){return this.style.setGlobalStateProperty(t,e),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(t,e){if(void 0===e&&(e=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new ve(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[e];return-1!==e.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new ve(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const e=this._controls.indexOf(t);return e>-1&&this._controls.splice(e,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}coveringTiles(t){return Id(this.transform,t)}calculateCameraOptionsFromTo(t,e,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,r)}resize(t,e=!0){const[i,r]=this._containerDimensions(),n=this._getClampedPixelRatio(i,r);if(this._resizeCanvas(i,r,n),this.painter.resize(i,r,n),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(i,r);this._resizeCanvas(i,r,e),this.painter.resize(i,r,e)}this._resizeTransform(e);const s=!this._moving;return s&&(this.stop(),this.fire(new xe("movestart",t)).fire(new xe("move",t))),this.fire(new xe("resize",t)),s&&this.fire(new xe("moveend",t)),this}_resizeTransform(t=!0){var e;const[i,r]=this._containerDimensions();this.transform.resize(i,r,t),null===(e=this._requestedCameraState)||void 0===e||e.resize(i,r,t)}_getClampedPixelRatio(t,e){const{0:i,1:r}=this._maxCanvasSize,n=this.getPixelRatio(),s=t*n,o=e*n;return Math.min(s>i?i/s:1,o>r?r/o:1)*n}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize()}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(Rp.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.setMinZoom(t),this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.setMaxZoom(t),this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.setMinPitch(t),this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>180)throw new Error("maxPitch must be less than or equal to 180");if(t>=this.transform.minPitch)return this.transform.setMaxPitch(t),this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.setRenderWorldCopies(t),this._update()}project(t){return this.transform.locationToScreenPoint(Dp.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.screenPointToLocation(s.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let r=!1;const n=n=>{const s=e.filter((t=>this.getLayer(t))),o=0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[];o.length?r||(r=!0,i.call(this,new ry(t,this,n.originalEvent,{features:o}))):r=!1};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:()=>{r=!1}}}}if("mouseleave"===t||"mouseout"===t){let r=!1;const n=n=>{const s=e.filter((t=>this.getLayer(t)));(0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[]).length?r=!0:r&&(r=!1,i.call(this,new ry(t,this,n.originalEvent)))},s=e=>{r&&(r=!1,i.call(this,new ry(t,this,e.originalEvent)))};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:s}}}{const r=t=>{const r=e.filter((t=>this.getLayer(t))),n=0!==r.length?this.queryRenderedFeatures(t.point,{layers:r}):[];n.length&&(t.features=n,i.call(this,t),delete t.features)};return{layers:e,listener:i,delegates:{[t]:r}}}}_saveDelegatedListener(t,e){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(e)}_removeDelegatedListener(t,e,i){if(!this._delegatedListeners||!this._delegatedListeners[t])return;const r=this._delegatedListeners[t];for(let t=0;t<r.length;t++){const n=r[t];if(n.listener===i&&n.layers.length===e.length&&n.layers.every((t=>e.includes(t)))){for(const t in n.delegates)this.off(t,n.delegates[t]);return void r.splice(t,1)}}}on(t,e,i){if(void 0===i)return super.on(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);this._saveDelegatedListener(t,n);for(const t in n.delegates)this.on(t,n.delegates[t]);return{unsubscribe:()=>{this._removeDelegatedListener(t,r,i)}}}once(t,e,i){if(void 0===i)return super.once(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);for(const e in n.delegates){const s=n.delegates[e];n.delegates[e]=(...e)=>{this._removeDelegatedListener(t,r,i),s(...e)}}this._saveDelegatedListener(t,n);for(const t in n.delegates)this.once(t,n.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._removeDelegatedListener(t,"string"==typeof e?[e]:e,i),this)}queryRenderedFeatures(t,e){if(!this.style)return[];let i;const r=t instanceof s||Array.isArray(t),n=r?t:[[0,0],[this.transform.width,this.transform.height]];if(e=e||(r?{}:t)||{},n instanceof s||"number"==typeof n[0])i=[s.convert(n)];else{const t=s.convert(n[0]),e=s.convert(n[1]);i=[t,new s(e.x,t.y),e,new s(t.x,e.y),t]}return this.style.queryRenderedFeatures(i,e,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,e){return!1!==(e=wt({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},e)).diff&&e.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,e),this):(this._localIdeographFontFamily=e.localIdeographFontFamily,this._updateStyle(t,e))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){var i,r;if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const n=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new Vm(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,n):this.style.loadJSON(t,e,n),this):(null===(r=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===r||r.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new Vm(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(t,e){if("string"==typeof t){const i=this._requestManager.transformRequest(t,"Style");ae(i,new AbortController).then((t=>{this._updateDiff(t.data,e)})).catch((t=>{t&&this.fire(new ve(t))}))}else"object"==typeof t&&this._updateDiff(t,e)}_updateDiff(t,e){try{this.style.setState(t,e)&&this._update(!0)}catch(i){Dt(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(t,e)}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():Dt("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const e=this.style&&this.style.sourceCaches[t];if(void 0!==e)return e.loaded();this.fire(new ve(new Error(`There is no source with ID '${t}'`)))}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const e=this.style.sourceCaches[t.source];if(!e)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&e.reload();for(const e in this.style._layers){const i=this.style._layers[e];"hillshade"===i.type&&i.source===t.source&&Dt("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===i.type&&i.source===t.source&&Dt("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.")}this.terrain=new lx(this.painter,e,t),this.painter.renderToTexture=new ux(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=e=>{var i;"style"===e.dataType?this.terrain.sourceCache.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=e.source)||void 0===i?void 0:i.type)?this.terrain.sourceCache.freeRtt():this.terrain.sourceCache.freeRtt(e.tile.tileID))},this.style.on("data",this._terrainDataCallback)}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new xe("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}}return!0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}setSourceTileLodParams(t,e,i){if(i){const r=this.getSource(i);if(!r)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);r.calculateTileZoom=Pd(Math.max(1,t),Math.max(1,e))}else for(const i in this.style.sourceCaches)this.style.sourceCaches[i].getSource().calculateTileZoom=Pd(Math.max(1,t),Math.max(1,e));return this._update(!0),this}refreshTiles(t,e){const i=this.style.sourceCaches[t];if(!i)throw new Error(`There is no source cache with ID "${t}", cannot refresh tile`);void 0===e?i.reload(!0):i.refreshTiles(e.map((t=>new Wp(t.z,t.x,t.y))))}addImage(t,e,i={}){const{pixelRatio:r=1,sdf:n=!1,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c}=i;if(this._lazyInitEmptyStyle(),!(e instanceof HTMLImageElement||Ft(e))){if(void 0===e.width||void 0===e.height)return this.fire(new ve(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:i,height:h,data:u}=e,p=e;return this.style.addImage(t,{data:new vc({width:i,height:h},new Uint8Array(u)),pixelRatio:r,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c,sdf:n,version:0,userImage:p}),p.onAdd&&p.onAdd(this,t),this}}{const{width:i,height:h,data:u}=Qt.getImageData(e);this.style.addImage(t,{data:new vc({width:i,height:h},u),pixelRatio:r,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c,sdf:n,version:0})}}updateImage(t,e){const i=this.style.getImage(t);if(!i)return this.fire(new ve(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=e instanceof HTMLImageElement||Ft(e)?Qt.getImageData(e):e,{width:n,height:s,data:o}=r;if(void 0===n||void 0===s)return this.fire(new ve(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(n!==i.data.width||s!==i.data.height)return this.fire(new ve(new Error("The width and height of the updated image must be that same as the previous version of the image")));const a=!(e instanceof HTMLImageElement||Ft(e));return i.data.replace(o,a),this.style.updateImage(t,i),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new ve(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t)}loadImage(t){return me.getImage(this._requestManager.transformRequest(t,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,r={}){return this.style.setPaintProperty(t,e,i,r),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,r={}){return this.style.setLayoutProperty(t,e,i,r),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0)})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0)})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setSky(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSky(t,e),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=te.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=te.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const n=this._controlContainer=te.create("div","maplibregl-control-container",t),s=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{s[t]=te.create("div",`maplibregl-ctrl-${t} `,n)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`}_setupPainter(){const t=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type)}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,t):this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t),!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new $g(i,this.transform),ce.testSupport(i)}migrateProjection(t,e){super.migrateProjection(t,e),this.painter.transform=t,this.fire(new xe("projectiontransition",{newProjection:this.style.projection.name}))}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t)}_render(t){var e,i,r,n,s;const o=this._idleTriggered?this._fadeDuration:0,a=(null===(e=this.style.projection)||void 0===e?void 0:e.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let l=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,e=Qt.now();this.style.zoomHistory.update(t,e);const i=new Eo(t,{now:e,fadeDuration:o,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=i.crossFadingFactor();1===r&&r===this._crossFadingFactor||(l=!0,this._crossFadingFactor=r),this.style.update(i)}const c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0!==a;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(n=this.style.projection)||void 0===n?void 0:n.transitionState,null===(s=this.style.projection)||void 0===s?void 0:s.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||c)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,o,this._crossSourceCollisions,c),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:o,showPadding:this.showPadding}),this.fire(new xe("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,sx.mark(Qy.load),this.fire(new xe("load"))),this.style&&(this.style.hasTransitions()||l)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const h=this._sourcesDirty||this._styleDirty||this._placementDirty;return h||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new xe("idle")),!this._loaded||this._fullyLoaded||h||(this._fullyLoaded=!0,sx.mark(Qy.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),me.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const e=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==e?void 0:e.loseContext)&&e.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),te.remove(this._canvasContainer),te.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),sx.clearMetrics(),this._removed=!0,this.fire(new xe("remove"))}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,Qt.frame(this._frameRequest,(t=>{sx.frame(t),this._frameRequest=null;try{this._render(t)}catch(t){if(!function(t){return t.message===Xt}(t)&&!function(t){return t.message===hg}(t))throw t}}),(()=>{})))}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update())}get showPadding(){return!!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update())}get repaint(){return!!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(t){this._vertices=t,this._update()}get version(){return dx}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(t){return this._lazyInitEmptyStyle(),this.style.setProjection(t),this._update(!0)}},t.MapMouseEvent=ry,t.MapTouchEvent=ny,t.MapWheelEvent=sy,t.Marker=bx,t.MercatorCoordinate=Up,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString())},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i)},this.options=wt({},mx,t),this._container=te.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),te.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),te.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t})})),this._compassIcon=te.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new _x(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){te.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map}_createButton(t,e){const i=te.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Point=s,t.Popup=class extends be{constructor(t){super(),this._updateOpacity=()=>{void 0!==this.options.locationOccludedOpacity&&(this._container.style.opacity=this._map.transform.isLocationOccluded(this.getLngLat())?`${this.options.locationOccludedOpacity}`:"")},this.remove=()=>(this._content&&te.remove(this._content),this._container&&(te.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new xe("close"))),this),this._onMouseUp=t=>{this._update(t.point)},this._onMouseMove=t=>{this._update(t.point)},this._onDrag=t=>{this._update(t.point)},this._update=t=>{if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=te.create("div","maplibregl-popup",this._map.getContainer()),this._tip=te.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer")}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=yx(this._lngLat,this._flatPos,this._map.transform,this._trackPointer),this._trackPointer&&!t)return;const e=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationToScreenPoint(this._lngLat));let i=this.options.anchor;const r=Ax(this.options.offset);if(!i){const t=this._container.offsetWidth,n=this._container.offsetHeight;let s;s=e.y+r.bottom.y<n?["top"]:e.y>this._map.transform.height-n?["bottom"]:[],e.x<t/2?s.push("left"):e.x>this._map.transform.width-t/2&&s.push("right"),i=0===s.length?"bottom":s.join("-")}let n=e.add(r[i]);this.options.subpixelPositioning||(n=n.round()),te.setTransform(this._container,`${xx[i]} translate(${n.x}px,${n.y}px)`),vx(this._container,i,"popup"),this._updateOpacity()},this._onClose=()=>{this.remove()},this.options=wt(Object.create(Cx),t)}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new xe("open")),this}isOpen(){return!!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=Dp.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=t;r=i.firstChild,r;)e.appendChild(r);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=te.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){return this._container&&this._container.classList.add(t),this}removeClassName(t){return this._container&&this._container.classList.remove(t),this}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t}_createCloseButton(){this.options.closeButton&&(this._closeButton=te.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose))}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(Ex);t&&t.focus()}},t.RasterDEMTileSource=Kp,t.RasterTileSource=$p,t.ScaleControl=class{constructor(t){this._onMove=()=>{Mx(this._map,this._container,this.options)},this.setUnit=t=>{this.options.unit=t,Mx(this._map,this._container,this.options)},this.options=Object.assign(Object.assign({},Sx),t)}getDefaultPosition(){return"bottom-left"}onAdd(t){return this._map=t,this._container=te.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){te.remove(this._container),this._map.off("move",this._onMove),this._map=void 0}},t.ScrollZoomHandler=By,t.Style=Vm,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon()},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"))},this.options=t}onAdd(t){return this._map=t,this._container=te.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=te.create("button","maplibregl-ctrl-terrain",this._container),te.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){te.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0}},t.TwoFingersTouchPitchHandler=Ay,t.TwoFingersTouchRotateHandler=Cy,t.TwoFingersTouchZoomHandler=My,t.TwoFingersTouchZoomRotateHandler=Uy,t.VectorTileSource=Gp,t.VideoSource=ed,t.addProtocol=function(t,e){ee.REGISTERED_PROTOCOLS[t]=e},t.addSourceType=(t,e)=>n(void 0,void 0,void 0,(function*(){if(nd(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{rd[t]=e})(t,e)})),t.clearPrewarmedResources=function(){const t=wp;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(xp),wp=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},t.config=ee,t.createTileMesh=dm,t.getMaxParallelImageRequests=function(){return ee.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return pd().getRTLTextPluginStatus()},t.getVersion=function(){return zx},t.getWorkerCount=function(){return vp.workerCount},t.getWorkerUrl=function(){return ee.WORKER_URL},t.importScriptInWorkers=function(t){return Mp().broadcast("IS",t)},t.prewarm=function(){Pp().acquire(xp)},t.removeProtocol=function(t){delete ee.REGISTERED_PROTOCOLS[t]},t.setMaxParallelImageRequests=function(t){ee.MAX_PARALLEL_IMAGE_REQUESTS=t},t.setRTLTextPlugin=function(t,e){return pd().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){vp.workerCount=t},t.setWorkerUrl=function(t){ee.WORKER_URL=t}}));
//# sourceMappingURL=maplibre-gl-csp.js.map
