<?php

declare(strict_types=1);

namespace Drupal\mapsemble_store_locator_demo\Controller;

use Drupal\Core\Controller\ControllerBase;



/**
 * Returns a page that renders the Mapsemble map block for the demo.
 */
final class MapsembleStoreLocatorController extends ControllerBase {

  /**
   * Page callback: renders the Mapsemble block for the Store Locator demo.
   */
  public function page(): array {
    /** @var \Drupal\Core\Block\BlockManagerInterface $block_manager */
    $block_manager = \Drupal::service('plugin.manager.block');

    // Use the demo map entity defined by this module's config: "store_locator".
    $configuration = [
      'map' => 'store_locator',
      'height' => '900px',
    ];

    $plugin_block = $block_manager->createInstance('mapsemble_map', $configuration);

    $build = $plugin_block->build();
    // Provide a page title for better UX.
    $build['#title'] = $this->t('Store locator');

    return $build;
  }

}
