<?php

namespace Drupal\mapsemble\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Base class for Mapsemble events.
 */
abstract class MapsembleEventBase extends Event {

  /**
   * The remote entity identifier.
   *
   * @var string
   */
  protected string $remoteId;

  /**
   * The filters to apply when building content.
   *
   * @var array
   */
  protected array $filters;

  /**
   * The locale code.
   *
   * @var string
   */
  protected string $locale;

  /**
   * Constructs a MapsembleEventBase object.
   *
   * @param string $remoteId
   *   The remote ID.
   * @param array $filters
   *   The filters.
   * @param string $locale
   *   The locale.
   */
  public function __construct(string $remoteId = '', array $filters = [], string $locale = '') {
    $this->remoteId = $remoteId;
    $this->filters = $filters;
    $this->locale = $locale;
  }

  /**
   * Gets the remote entity ID.
   *
   * @return string
   *   The remote ID.
   */
  public function getRemoteId(): string {
    return $this->remoteId;
  }

  /**
   * Sets the remote entity ID.
   *
   * @param string $remoteId
   *   The remote ID.
   *
   * @return $this
   */
  public function setRemoteId(string $remoteId): MapsembleEventBase {
    $this->remoteId = $remoteId;
    return $this;
  }

  /**
   * Gets the filters array.
   *
   * @return array
   *   The filters.
   */
  public function getFilters(): array {
    return $this->filters;
  }

  /**
   * Sets the filters array.
   *
   * @param array $filters
   *   The filters to set.
   *
   * @return $this
   */
  public function setFilters(array $filters): MapsembleEventBase {
    $this->filters = $filters;
    return $this;
  }

  /**
   * Gets the locale code.
   *
   * @return string
   *   The locale code.
   */
  public function getLocale(): string {
    return $this->locale;
  }

  /**
   * Sets the locale code.
   *
   * @param string $locale
   *   The locale code to set.
   *
   * @return $this
   */
  public function setLocale(string $locale): MapsembleEventBase {
    $this->locale = $locale;
    return $this;
  }

}
