<?php

namespace Drupal\mapsemble\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Provides a Field plugin manager.
 */
class FieldPluginManager extends DefaultPluginManager {

  /**
   * Constructs a FieldPluginManager object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/Field',
      $namespaces,
      $module_handler,
      'Drupal\\mapsemble\\Plugin\\FieldPluginInterface',
      'Drupal\\mapsemble\\Attribute\\FieldPlugin',
      'Drupal\\mapsemble\\Annotation\\FieldPlugin'
    );
    $this->alterInfo('mapsemble_field_plugin_info');
    $this->setCacheBackend($cache_backend, 'mapsemble_field_plugins');
  }

  /**
   * Gets plugin definitions compatible with a pair of types.
   *
   * @param string $drupalFieldType
   *   The Drupal field type.
   * @param string $mapsembleFieldType
   *   The Mapsemble field type.
   *
   * @return array
   *   Matching plugin definitions.
   */
  public function getCompatibleDefinitions(string $drupalFieldType, string $mapsembleFieldType): array {
    return array_filter($this->getDefinitions(), function (array $definition) use ($drupalFieldType, $mapsembleFieldType) {
      $d = $definition['drupal_field_types'] ?? [];
      $m = $definition['mapsemble_field_types'] ?? [];
      return in_array($drupalFieldType, $d, TRUE) && in_array($mapsembleFieldType, $m, TRUE);
    });
  }

}
