<?php

namespace Drupal\mapsemble\Plugin\Filter;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\mapsemble\Attribute\FilterPlugin;
use Drupal\mapsemble\Plugin\FilterPluginBase;

/**
 * Filter plugin for list/options fields.
 */
#[FilterPlugin(
  id: "options_field_filter",
  label: new TranslatableMarkup("Options Field Filter"),
  field_types: [
    "list_string",
    "list_integer",
    "list_float",
  ],
)]
class OptionsFieldFilter extends FilterPluginBase {

  /**
   * {@inheritdoc}
   */
  public function filter(
    string $entityTypeId,
    string $bundle,
    string $fieldName,
    FieldDefinitionInterface $fieldDefinition,
    string|array $value = '',
  ): array {
    $entityStorage = $this->entityTypeManager->getStorage($entityTypeId);
    $definition = $this->entityTypeManager->getDefinition($entityTypeId);

    // Build base query.
    $query = $entityStorage->getQuery()
      ->condition('status', 1)
      ->accessCheck(TRUE);

    if ($definition->hasKey('bundle')) {
      $query->condition($definition->getKey('bundle'), $bundle);
    }

    // Only get entities that have a value for this field.
    $query->exists($fieldName);

    if (!empty($value)) {
      $query->condition($fieldName, $value, 'IN');
    }
    else {
      throw new \Exception('No value provided');
    }

    $entityIds = $query->execute();

    // Return entity IDs as array values (not associative).
    return array_values($entityIds);
  }

}
