<?php

/**
 * @file
 * Theme hooks for Mapsemble Store.
 */

/**
 * Prepares variables for Mapsemble Store templates.
 */
function template_preprocess_mapsemble_store(&$variables) {
  $variables['content'] = $variables['elements'];
  $variables['mapsemble_store'] = $variables['elements']['#mapsemble_store'];
  // Ensure attributes class array exists.
  if (!isset($variables['attributes']['class']) || !is_array($variables['attributes']['class'])) {
    $variables['attributes']['class'] = [];
  }
  $variables['attributes']['class'][] = 'mapsemble-store';

  // Add 'mobile' class when the URL query contains device=mobile.
  try {
    $request = \Drupal::request();
    if ($request) {
      $device = $request->query->get('device');
      if (is_string($device) && strtolower($device) === 'mobile') {
        $variables['attributes']['class'][] = 'mobile';
      } else{
        $variables['attributes']['class'][] = 'desktop';
      }
    }
  }
  catch (\Throwable) {
    // Silently ignore to avoid breaking rendering.
  }

  // Ensure cache contexts vary by the 'device' query argument to prevent
  // cache leakage across different query variants.
  if (!isset($variables['#cache']) || !is_array($variables['#cache'])) {
    $variables['#cache'] = [];
  }
  if (!isset($variables['#cache']['contexts']) || !is_array($variables['#cache']['contexts'])) {
    $variables['#cache']['contexts'] = [];
  }
  // Vary cache narrowly by the specific query arg instead of all query args.
  $variables['#cache']['contexts'][] = 'url.query_args:device';
}
