<?php

declare(strict_types=1);

namespace Drupal\mapsemble_store_locator_demo\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\mapsemble\Entity\MapsembleMap;

/**
 * Returns a page that renders the Mapsemble map block for the demo.
 */
final class MapsembleStoreLocatorController extends ControllerBase {

  /**
   * Page callback: renders the Mapsemble block for the Store Locator demo.
   */
  public function page(): array {
    $map = MapsembleMap::load('store_locator');
    $build = [];
    if ($map->getMapId()) {
      $build['map'] = [
        '#type' => 'mapsemble_map',
        '#map' => $map,
        '#height' => '900px',
      ];
    }
    else {
      // If user can administer Mapsemble, expose the setup form to manually
      // create the remote map and synchronize content.
      $account = \Drupal::currentUser();
      if ($account->hasPermission('administer mapsemble')) {
        $build['mapsemble_setup_form'] = [
          '#type' => 'details',
          '#title' => $this->t('Mapsemble setup'),
          '#open' => TRUE,
          'form' => \Drupal::formBuilder()->getForm(
            'Drupal\mapsemble_store_locator_demo\Form\MapsembleStoreLocatorSetupForm'
          ),
          '#weight' => 100,
        ];
      }
    }

    return $build;
  }

}
