<?php

namespace Drupal\mapsemble_store_locator_demo;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Http\ClientFactory;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * The store locator service.
 */
class MapsembleStoreLocatorInstaller {

  /**
   * The HTTP client factory.
   *
   * @var \Drupal\Core\Http\ClientFactory
   */
  protected $httpClientFactory;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new MapsembleStoreLocatorService object.
   *
   * @param \Drupal\Core\Http\ClientFactory $http_client_factory
   *   The HTTP client factory.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(
    ClientFactory $http_client_factory,
    ConfigFactoryInterface $config_factory,
  ) {
    $this->httpClientFactory = $http_client_factory;
    $this->configFactory = $config_factory;
  }

  /**
   * Creates a new instance of the service.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
   *   The container.
   *
   * @return static
   *   The service instance.
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('http_client_factory'),
      $container->get('config.factory')
    );
  }

  /**
   * Makes a POST request to the Mapsemble API and updates the configuration.
   */
  public function createMapsembleMapOnInstall() {
    /** @var \Drupal\mapsemble\MapsembleApi $mapsembleApi */
    $mapsembleApi = \Drupal::service('mapsemble.api');

    try {

      $data = $mapsembleApi->createDrupalMap();
    }
    catch (\Exception $e) {
      throw new \Exception(
        'Error creating a map in Mapsemble. Did you use the correct API key?: ' . $e->getMessage(
        )
      );
    }

    $mapId = $data['id'] ?? NULL;
    $layerId = $data['layers'][1]['id'] ?? NULL;
    $dataSourceId = $data['layers'][1]['dataSource']['id'] ?? NULL;

    if (!$mapId || !$layerId || !$dataSourceId) {
      throw new \Exception('Invalid response from Mapsemble API');
    }
    $config = $this->configFactory->getEditable('mapsemble.map.store_locator');
    $settings = $config->get('settings');
    $settings['mapsemble']['mapId'] = $mapId;
    $settings['mapsemble']['dataSourceId'] = $dataSourceId;
    $settings['mapsemble']['layerId'] = $layerId;
    $config->set('settings', $settings);
    $config->save();
  }

}
