<?php

declare(strict_types=1);

namespace Drupal\mapsemble_store_locator_demo;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access control handler for the Mapsemble Store entity.
 */
final class StoreAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'view':
        // Allow viewing stores to users who have the core "access content" permission.
        if ($account->hasPermission('access content')) {
          return AccessResult::allowed()->cachePerPermissions();
        }
        // Otherwise, fall back to parent for any additional logic or deny.
        return parent::checkAccess($entity, $operation, $account);

      default:
        return parent::checkAccess($entity, $operation, $account);
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    // Defer create access to the parent or other permissions defined elsewhere.
    return parent::checkCreateAccess($account, $context, $entity_bundle);
  }

}
